/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.ruoli;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliHelper;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class RuoliList
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            RuoliHelper ruoliHelper = new RuoliHelper(request, pd, session);
            ruoliHelper.makeMenu();
            RuoliCore ruoliCore = new RuoliCore();
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.RUOLI;
            List<Ruolo> lista = null;
            if (!ServletUtils.isSearchDone((IConsoleHelper)ruoliHelper)) {
                lista = ServletUtils.getRisultatiRicercaFromSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, Ruolo.class);
            }
            ricerca = ruoliHelper.checkSearchParameters(idLista, ricerca);
            ruoliHelper.clearFiltroSoggettoByPostBackProtocollo(3, (ISearch)ricerca, idLista);
            if (lista == null) {
                String userLogin;
                List<String> protocolli;
                boolean filtroSoggetto = false;
                String filterApiContesto = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroApiContesto");
                if (!"Soggetti".equals(filterApiContesto) && ruoliHelper.isSoggettoMultitenantSelezionato() && (protocolli = ruoliCore.getProtocolli(request, session, false)) != null && protocolli.size() == 1) {
                    filtroSoggetto = true;
                }
                if (filtroSoggetto) {
                    ricerca.addFilter(idLista, "filtroSoggetto", ruoliHelper.getSoggettoMultitenantSelezionato());
                }
                lista = ruoliCore.isVisioneOggettiGlobale(userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session)) ? ruoliCore.ruoliList(null, (ISearch)ricerca) : ruoliCore.ruoliList(userLogin, (ISearch)ricerca);
            }
            if (!ruoliHelper.isPostBackFilterElement()) {
                ServletUtils.setRisultatiRicercaIntoSession((HttpServletRequest)request, (HttpSession)session, (int)idLista, (List)lista);
            }
            ruoliHelper.prepareRuoliList((ISearch)ricerca, lista);
            String msg = ruoliHelper.getParameter("errorExport");
            if (msg != null && !"".equals(msg)) {
                pd.setMessage("Errore durante esportazione: " + msg);
            }
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.LIST());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.LIST());
        }
    }
}

