/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.ruoli;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCostanti;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class RuoliAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            RuoliHelper ruoliHelper = new RuoliHelper(request, pd, session);
            ruoliHelper.makeMenu();
            String nome = ruoliHelper.getParameter("ruoloNome");
            String descrizione = ruoliHelper.getParameter("ruoloDescrizione");
            String tipologia = ruoliHelper.getParameter("ruoloTipologia");
            if (tipologia == null) {
                tipologia = RuoliCostanti.DEFAULT_VALUE_PARAMETRO_RUOLO_TIPOLOGIA;
            }
            String nomeEsterno = ruoliHelper.getParameter("ruoloNomeEsterno");
            String contesto = ruoliHelper.getParameter("ruoloContesto");
            if (contesto == null) {
                contesto = RuoliCostanti.DEFAULT_VALUE_PARAMETRO_RUOLO_CONTESTO_UTILIZZO;
            }
            RuoliCore ruoliCore = new RuoliCore();
            if (ruoliHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitleServletAdd((PageData)pd, (String)"Ruoli", (String)"ruoliList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = ruoliHelper.addRuoloToDati(TipoOperazione.ADD, null, nome != null ? nome : "", descrizione != null ? descrizione : "", tipologia, nomeEsterno, contesto, dati, null);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = ruoliHelper.ruoloCheckData(TipoOperazione.ADD, null);
            if (!isOk) {
                ServletUtils.setPageDataTitleServletAdd((PageData)pd, (String)"Ruoli", (String)"ruoliList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = ruoliHelper.addRuoloToDati(TipoOperazione.ADD, null, nome, descrizione, tipologia, nomeEsterno, contesto, dati, null);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.ADD());
            }
            Ruolo ruolo = new Ruolo();
            ruolo.setNome(nome);
            ruolo.setDescrizione(descrizione);
            ruolo.setTipologia(RuoloTipologia.toEnumConstant((String)tipologia, (boolean)true));
            if (ruolo.getTipologia() != null && (RuoloTipologia.QUALSIASI.equals((Object)ruolo.getTipologia()) || RuoloTipologia.ESTERNO.equals((Object)ruolo.getTipologia()))) {
                String n = nomeEsterno;
                if (n != null) {
                    n = n.trim();
                }
                ruolo.setNomeEsterno(n);
            }
            ruolo.setContestoUtilizzo(RuoloContesto.toEnumConstant((String)contesto, (boolean)true));
            ruolo.setSuperUser(userLogin);
            ruoliCore.performCreateOperation(userLogin, ruoliHelper.smista(), ruolo);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            if (ruoliCore.isSetSearchAfterAdd()) {
                ruoliCore.setSearchAfterAdd(Liste.RUOLI, ruolo.getNome(), request, session, (ISearch)ricerca);
            }
            List<Ruolo> lista = null;
            lista = ruoliCore.isVisioneOggettiGlobale(userLogin) ? ruoliCore.ruoliList(null, (ISearch)ricerca) : ruoliCore.ruoliList(userLogin, (ISearch)ricerca);
            ruoliHelper.prepareRuoliList((ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"ruoli", (ForwardParams)ForwardParams.ADD());
        }
    }
}

