/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pdd;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.dao.SoggettoCtrlStat;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class PddSinglePdDChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            PddHelper pddHelper = new PddHelper(request, pd, session);
            pddHelper.makeMenu();
            String id = pddHelper.getParameter("id");
            String descr = pddHelper.getParameter("descrizione");
            String implementazione = pddHelper.getParameter("implementazione");
            String subject = pddHelper.getParameter("subject");
            String clientAuth = pddHelper.getParameter("client_auth");
            String tipo = pddHelper.getParameter("tipo");
            String nome = pddHelper.getParameter("nome");
            PddCore pddCore = new PddCore();
            if (id == null || id.equals("")) {
                pd.setMessage("L'identificativo della porta di dominio &egrave; necessario!");
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardGeneralError((ActionMapping)mapping, (String)"pddSinglePdD", (ForwardParams)ForwardParams.CHANGE());
            }
            long idPdd = Long.parseLong(id);
            PdDControlStation pdd = pddCore.getPdDControlStation(idPdd);
            if (pddHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitleServletChange((PageData)pd, (String)"Porte di Dominio", (String)"pddSinglePdDList.do", (String)pdd.getNome());
                if (descr == null) {
                    descr = pdd.getDescrizione();
                }
                if (nome == null) {
                    nome = pdd.getNome();
                }
                if (implementazione == null) {
                    implementazione = pdd.getImplementazione();
                }
                if (subject == null) {
                    subject = pdd.getSubject();
                }
                if (clientAuth == null && pdd.getClientAuth() != null) {
                    clientAuth = pdd.getClientAuth().toString();
                }
                tipo = pdd.getTipo();
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = pddHelper.addPddToDati(dati, nome, id, "", subject, "", "", PddTipologia.toPddTipologia((String)tipo), TipoOperazione.CHANGE, null, "", "", 0, descr, "", 0, implementazione, clientAuth);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"pddSinglePdD", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = pddHelper.pddCheckData(TipoOperazione.CHANGE);
            if (!isOk) {
                ServletUtils.setPageDataTitleServletChange((PageData)pd, (String)"Porte di Dominio", (String)"pddSinglePdDList.do", (String)pdd.getNome());
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = pddHelper.addPddToDati(dati, nome, id, "", subject, "", "", PddTipologia.toPddTipologia((String)tipo), TipoOperazione.CHANGE, null, "", "", 0, descr, "", 0, implementazione, clientAuth);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"pddSinglePdD", (ForwardParams)ForwardParams.CHANGE());
            }
            pdd.setDescrizione(descr);
            pdd.setImplementazione(implementazione);
            if (subject != null && !"".equals(subject)) {
                pdd.setSubject(subject);
            } else {
                pdd.setSubject(null);
            }
            pdd.setClientAuth(StatoFunzionalita.toEnumConstant((String)clientAuth));
            ArrayList<Object> oggettiDaAggiornare = new ArrayList<Object>();
            if (!pdd.getNome().equals(nome)) {
                List<SoggettoCtrlStat> soggetti = pddCore.soggettiWithServer(pdd.getNome());
                for (SoggettoCtrlStat soggettoCtrlStat : soggetti) {
                    if (soggettoCtrlStat.getSoggettoReg() != null) {
                        soggettoCtrlStat.getSoggettoReg().setPortaDominio(nome);
                    }
                    oggettiDaAggiornare.add(soggettoCtrlStat);
                }
                pdd.setOldNomeForUpdate(pdd.getNome());
                pdd.setNome(nome);
            }
            oggettiDaAggiornare.add(pdd);
            pddCore.performUpdateOperation(userLogin, pddHelper.smista(), oggettiDaAggiornare.toArray(new Object[1]));
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<PdDControlStation> lista = null;
            lista = pddCore.isVisioneOggettiGlobale(userLogin) ? pddCore.pddList(null, (ISearch)ricerca) : pddCore.pddList(userLogin, (ISearch)ricerca);
            pddHelper.preparePddSinglePddList(lista, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"pddSinglePdD", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"pddSinglePdD", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

