/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pdd;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.registry.PortaDominio;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddHelper;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class PddSinglePdDAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            PddHelper pddHelper = new PddHelper(request, pd, session);
            pddHelper.makeMenu();
            String nome = pddHelper.getParameter("nome");
            String descr = pddHelper.getParameter("descrizione");
            String implementazione = pddHelper.getParameter("implementazione");
            String subject = pddHelper.getParameter("subject");
            String clientAuth = pddHelper.getParameter("client_auth");
            PddCore pddCore = new PddCore();
            if (pddHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitleServletAdd((PageData)pd, (String)"Porte di Dominio", (String)"pddSinglePdDList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                if (implementazione == null || "".equals(implementazione)) {
                    implementazione = "standard";
                }
                dati = pddHelper.addPddToDati(dati, nome, null, "", subject, "", "", PddTipologia.ESTERNO, TipoOperazione.ADD, null, "", "", 0, descr, "", 0, implementazione, clientAuth);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"pddSinglePdD", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = pddHelper.pddCheckData(TipoOperazione.ADD);
            if (!isOk) {
                ServletUtils.setPageDataTitleServletAdd((PageData)pd, (String)"Porte di Dominio", (String)"pddSinglePdDList.do");
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = pddHelper.addPddToDati(dati, nome, null, "", subject, "", "", PddTipologia.ESTERNO, TipoOperazione.ADD, null, "", "", 0, descr, "", 0, implementazione, clientAuth);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"pddSinglePdD", (ForwardParams)ForwardParams.ADD());
            }
            PdDControlStation pdd = new PdDControlStation();
            pdd.setNome(nome);
            List<PortaDominio> listaPddOperative = null;
            listaPddOperative = pddCore.isVisioneOggettiGlobale(userLogin) ? pddCore.pddListSinglePdd(null, PddTipologia.OPERATIVO.toString(), (ISearch)new ConsoleSearch(true)) : pddCore.pddListSinglePdd(userLogin, PddTipologia.OPERATIVO.toString(), (ISearch)new ConsoleSearch(true));
            if (!listaPddOperative.isEmpty()) {
                pdd.setTipo(PddTipologia.ESTERNO.toString());
            } else {
                pdd.setTipo(PddTipologia.OPERATIVO.toString());
            }
            if (subject != null && !"".equals(subject)) {
                pdd.setSubject(subject);
            } else {
                pdd.setSubject(null);
            }
            pdd.setDescrizione(descr);
            pdd.setImplementazione(implementazione);
            pdd.setClientAuth(StatoFunzionalita.toEnumConstant((String)clientAuth));
            pdd.setSuperUser(userLogin);
            pddCore.performCreateOperation(userLogin, pddHelper.smista(), pdd);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            List<PdDControlStation> lista = null;
            lista = pddCore.isVisioneOggettiGlobale(userLogin) ? pddCore.pddList(null, (ISearch)ricerca) : pddCore.pddList(userLogin, (ISearch)ricerca);
            pddHelper.preparePddSinglePddList(lista, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"pddSinglePdD", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"pddSinglePdD", (ForwardParams)ForwardParams.ADD());
        }
    }
}

