/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.pa;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeHelper;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.slf4j.Logger;

public final class PorteApplicativeAzioneList
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            PorteApplicativeHelper porteApplicativeHelper = new PorteApplicativeHelper(request, pd, session);
            porteApplicativeHelper.makeMenu();
            Integer parentPA = ServletUtils.getIntegerAttributeFromSession((String)"_tabKey_portaPar", (HttpSession)session, (HttpServletRequest)request);
            if (parentPA == null) {
                parentPA = 0;
            }
            String idPorta = porteApplicativeHelper.getParametroLong("id");
            int idInt = Integer.parseInt(idPorta);
            String idsogg = porteApplicativeHelper.getParametroLong("idsogg");
            String idAsps = porteApplicativeHelper.getParametroLong("idAsps");
            if (idAsps == null) {
                idAsps = "";
            }
            String idTab = porteApplicativeHelper.getParametroInteger("idTab");
            if (!porteApplicativeHelper.isModalitaCompleta() && StringUtils.isNotEmpty((CharSequence)idTab)) {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)idTab, (String)"idTab");
            }
            PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore();
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore(porteApplicativeCore);
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(porteApplicativeCore);
            PortaApplicativa pa = porteApplicativeCore.getPortaApplicativa(idInt);
            AccordoServizioParteSpecifica asps = apsCore.getAccordoServizioParteSpecifica(Integer.parseInt(idAsps));
            AccordoServizioParteComuneSintetico aspc = apcCore.getAccordoServizioSintetico(IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
            ServiceBinding serviceBinding = apcCore.toMessageServiceBinding(aspc.getServiceBinding());
            Object labelPerPorta = null;
            labelPerPorta = parentPA != null && parentPA == 2 ? porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa(porteApplicativeHelper.getLabelAzioniDi(serviceBinding), porteApplicativeHelper.getLabelAzioni(serviceBinding), pa) : porteApplicativeHelper.getLabelAzioniDi(serviceBinding) + pa.getNome();
            MappingErogazionePortaApplicativa mappingErogazione = porteApplicativeCore.getMappingErogazionePortaApplicativa(pa);
            List<String> listaAzioni = null;
            if (mappingErogazione != null && mappingErogazione.isDefault()) {
                ArrayList<IDServizio> listId = new ArrayList<IDServizio>();
                listId.add(IDServizioFactory.getInstance().getIDServizioFromAccordo(asps));
                List<MappingErogazionePortaApplicativa> lista = porteApplicativeCore.getMapping(listId, false, true);
                if (lista != null && !lista.isEmpty()) {
                    AccordiServizioParteSpecificaHelper aspsHelper = new AccordiServizioParteSpecificaHelper(request, pd, session);
                    Map<String, String> azioni = porteApplicativeCore.getAzioniConLabel(asps, aspc, false, true, new ArrayList<String>());
                    ArrayList<String> azioniL = new ArrayList<String>();
                    if (azioni != null && azioni.size() > 0) {
                        azioniL.addAll(azioni.keySet());
                    }
                    listaAzioni = aspsHelper.getAllActionsNotRedefinedMappingErogazione(azioniL, lista);
                }
            } else {
                listaAzioni = pa.getAzione().getAzioneDelegataList();
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.PORTE_APPLICATIVE_AZIONI;
            ricerca = porteApplicativeHelper.checkSearchParameters(idLista, ricerca);
            List<Parameter> lstParam = porteApplicativeHelper.getTitoloPA(parentPA, idsogg, idAsps);
            ArrayList<Parameter> listaParametriSessione = new ArrayList<Parameter>();
            listaParametriSessione.add(new Parameter("id", idPorta));
            listaParametriSessione.add(new Parameter("idsogg", idsogg));
            listaParametriSessione.add(new Parameter("idAsps", idAsps));
            porteApplicativeHelper.preparePorteAzioneList((ISearch)ricerca, listaAzioni, parentPA, lstParam, "porteApplicativeAzione", listaParametriSessione, (String)labelPerPorta, serviceBinding, aspc);
            porteApplicativeHelper.impostaComandiMenuContestualePA(idsogg, idAsps);
            if (mappingErogazione != null && mappingErogazione.isDefault()) {
                pd.setAddButton(false);
                pd.setRemoveButton(false);
                pd.setSelect(false);
            }
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"porteApplicativeAzione", (ForwardParams)ForwardParams.LIST());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"porteApplicativeAzione", (ForwardParams)ForwardParams.LIST());
        }
    }
}

