/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.connettori;

import java.util.List;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.registry.Property;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleHelper;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.TipoOperazione;

public class ConnettoreJMSUtils {
    private ConnettoreJMSUtils() {
    }

    public static void fillConnettoreConfig(Connettore connettore, String jmsNome, String jmsTipo, String jmsUser, String jmsPwd, String jmsNfInitial, String jmsNfUrlPkg, String jmsNpUrl, String jmsConnectionFactory, String jmsSendAs) {
        org.openspcoop2.core.config.Property prop = new org.openspcoop2.core.config.Property();
        prop.setNome("location");
        prop.setValore(jmsNome);
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("user");
        prop.setValore(jmsUser);
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("tipo");
        prop.setValore(jmsTipo);
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("password");
        prop.setValore(jmsPwd);
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("connection-factory");
        prop.setValore(jmsConnectionFactory);
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("context-java.naming.factory.initial");
        prop.setValore(jmsNfInitial);
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("context-java.naming.factory.url.pkgs");
        prop.setValore(jmsNfUrlPkg);
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("context-java.naming.provider.url");
        prop.setValore(jmsNpUrl);
        connettore.addProperty(prop);
        prop = new org.openspcoop2.core.config.Property();
        prop.setNome("send-as");
        prop.setValore(jmsSendAs);
        connettore.addProperty(prop);
    }

    public static void fillConnettoreRegistry(org.openspcoop2.core.registry.Connettore connettore, String jmsNome, String jmsTipo, String jmsUser, String jmsPwd, String jmsNfInitial, String jmsNfUrlPkg, String jmsNpUrl, String jmsConnectionFactory, String jmsSendAs) {
        Property prop = new Property();
        prop.setNome("location");
        prop.setValore(jmsNome);
        connettore.addProperty(prop);
        prop = new Property();
        prop.setNome("user");
        prop.setValore(jmsUser);
        connettore.addProperty(prop);
        prop = new Property();
        prop.setNome("tipo");
        prop.setValore(jmsTipo);
        connettore.addProperty(prop);
        prop = new Property();
        prop.setNome("password");
        prop.setValore(jmsPwd);
        connettore.addProperty(prop);
        prop = new Property();
        prop.setNome("connection-factory");
        prop.setValore(jmsConnectionFactory);
        connettore.addProperty(prop);
        prop = new Property();
        prop.setNome("context-java.naming.factory.initial");
        prop.setValore(jmsNfInitial);
        connettore.addProperty(prop);
        prop = new Property();
        prop.setNome("context-java.naming.factory.url.pkgs");
        prop.setValore(jmsNfUrlPkg);
        connettore.addProperty(prop);
        prop = new Property();
        prop.setNome("context-java.naming.provider.url");
        prop.setValore(jmsNpUrl);
        connettore.addProperty(prop);
        prop = new Property();
        prop.setNome("send-as");
        prop.setValore(jmsSendAs);
        connettore.addProperty(prop);
    }

    public static void addJMSDati(List<DataElement> dati, String nome, String tipo, String user, String password, String initcont, String urlpgk, String provurl, String connfact, String sendas, String objectName, TipoOperazione tipoOperazione, String stato, ControlStationCore core, ConsoleHelper consoleHelper, int pageSize, boolean postBackViaPost) throws UtilsException {
        if (postBackViaPost || objectName != null || tipoOperazione != null) {
            // empty if block
        }
        DataElement de = new DataElement();
        de.setLabel("Dati Configurazione Coda");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nomeJms");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setType(DataElementType.SELECT);
        de.setValues(ConnettoriCostanti.TIPI_CODE_JMS);
        de.setSelected(tipo);
        de.setName("tipoJms");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Send As");
        de.setType(DataElementType.SELECT);
        de.setValues(ConnettoriCostanti.TIPO_SEND_AS);
        de.setSelected(sendas);
        de.setName("sendas");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Dati Configurazione Connessione");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Connection Factory");
        de.setValue(connfact);
        if (!consoleHelper.isShowGestioneWorkflowStatoDocumenti() || !StatiAccordo.finale.toString().equals(stato)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("connfact");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Utente");
        de.setValue(user);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("userJms");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Password");
        de.setName("passwordJms");
        core.getLockUtilities().lock(de, password);
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Contesto JNDI");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Initial Context Factory");
        de.setValue(initcont);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("initcont");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Url Pgk Prefixes");
        de.setValue(urlpgk);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("urlpgk");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Provider Url");
        de.setValue(provurl);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("provurl");
        de.setSize(pageSize);
        dati.add(de);
    }

    public static void addJMSDatiAsHidden(List<DataElement> dati, String nome, String tipo, String user, String password, String initcont, String urlpgk, String provurl, String connfact, String sendas, String objectName, TipoOperazione tipoOperazione, String stato, ControlStationCore core, int pageSize) throws UtilsException {
        if (tipoOperazione == null || stato != null) {
            // empty if block
        }
        DataElement de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.HIDDEN);
        de.setName("nomeJms");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo");
        de.setType(DataElementType.HIDDEN);
        de.setValue(tipo);
        de.setName("tipoJms");
        dati.add(de);
        if (!objectName.equals("serviziApplicativi")) {
            de = new DataElement();
            de.setLabel("Utente");
            de.setValue(user);
            de.setType(DataElementType.HIDDEN);
            de.setName("userJms");
            de.setSize(pageSize);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Password");
            de.setType(DataElementType.HIDDEN);
            de.setName("passwordJms");
            core.getLockUtilities().lockHidden(de, password);
            de.setSize(pageSize);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Initial Context Factory");
        de.setValue(initcont);
        de.setType(DataElementType.HIDDEN);
        de.setName("initcont");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Url Pgk Prefixes");
        de.setValue(urlpgk);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("urlpgk");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Provider Url");
        de.setValue(provurl);
        de.setType(DataElementType.HIDDEN);
        de.setName("provurl");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Connection Factory");
        de.setValue(connfact);
        de.setType(DataElementType.HIDDEN);
        de.setName("connfact");
        de.setSize(pageSize);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Send As");
        de.setType(DataElementType.HIDDEN);
        de.setValue(sendas);
        de.setName("sendas");
        dati.add(de);
    }
}

