/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneMultitenant;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.IdSoggetto;
import org.openspcoop2.core.config.constants.RuoloContesto;
import org.openspcoop2.core.config.constants.ServiceBinding;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazioneProxyPassRegolaAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            String idRegolaS = confHelper.getParameter("ppId");
            String nome = confHelper.getParameter("ppNome");
            String descrizione = confHelper.getParameter("ppDescr");
            String stato = confHelper.getParameter("ppStato");
            String regExprS = confHelper.getParametroBoolean("ppRegExpr");
            boolean regExpr = regExprS != null ? ServletUtils.isCheckBoxEnabled((String)regExprS) : false;
            String regolaText = confHelper.getParameter("ppRegText");
            String contestoEsterno = confHelper.getParameter("ppCE");
            String baseUrl = confHelper.getParameter("ppBaseUrl");
            String protocollo = confHelper.getParameter("ppProfilo");
            String soggetto = confHelper.getParameter("ppSogg");
            String ruolo = confHelper.getParameter("ppRuolo");
            String serviceBinding = confHelper.getParameter("ppServB");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            SoggettiCore soggettiCore = new SoggettiCore(confCore);
            Configurazione configurazioneGenerale = confCore.getConfigurazioneGenerale();
            ConfigurazioneMultitenant configurazioneMultitenant = configurazioneGenerale.getMultitenant();
            boolean multiTenant = false;
            if (configurazioneMultitenant != null) {
                StatoFunzionalita statoMultitenant = configurazioneMultitenant.getStato();
                multiTenant = StatoFunzionalita.ABILITATO.equals((Object)statoMultitenant);
            }
            confHelper.makeMenu();
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            List<String> protocolli = confCore.getProtocolli();
            ArrayList<IDSoggetto> soggetti = new ArrayList();
            if (StringUtils.isNotEmpty((CharSequence)protocollo)) {
                soggetti = soggettiCore.getIdSoggettiOperativi(protocollo);
            }
            lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new Parameter("Regole di Proxy Pass", "configurazioneProxyPassRegolaList.do"));
            lstParam.add(ServletUtils.getParameterAggiungi());
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            if (confHelper.isEditModeInProgress()) {
                if (nome == null) {
                    nome = "";
                    descrizione = "";
                    stato = StatoFunzionalita.ABILITATO.toString();
                    regExpr = false;
                    regolaText = "";
                    contestoEsterno = "";
                    baseUrl = "";
                    protocollo = "";
                    soggetto = "";
                    ruolo = "";
                    serviceBinding = "";
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addProxyPassConfigurazioneRegola(TipoOperazione.ADD, dati, idRegolaS, nome, descrizione, stato, regExpr, regolaText, contestoEsterno, baseUrl, protocollo, protocolli, soggetto, soggetti, ruolo, serviceBinding, multiTenant);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneProxyPassRegola", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.proxyPassConfigurazioneRegolaCheckData(TipoOperazione.ADD, null);
            if (!isOk) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addProxyPassConfigurazioneRegola(TipoOperazione.ADD, dati, idRegolaS, nome, descrizione, stato, regExpr, regolaText, contestoEsterno, baseUrl, protocollo, protocolli, soggetto, soggetti, ruolo, serviceBinding, multiTenant);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneProxyPassRegola", (ForwardParams)ForwardParams.ADD());
            }
            configurazioneGenerale = confCore.getConfigurazioneGenerale();
            if (configurazioneGenerale.getUrlInvocazione() == null) {
                configurazioneGenerale.setUrlInvocazione(new ConfigurazioneUrlInvocazione());
            }
            int posizione = ConfigurazioneUtilities.getProssimaPosizioneUrlInvocazioneRegola(configurazioneGenerale);
            ConfigurazioneUrlInvocazioneRegola regola = new ConfigurazioneUrlInvocazioneRegola();
            regola.setNome(nome);
            if (descrizione != null && !"".equals(descrizione)) {
                regola.setDescrizione(descrizione);
            }
            if (baseUrl != null && !"".equals(baseUrl)) {
                regola.setBaseUrl(baseUrl);
            }
            if (contestoEsterno != null && !"".equals(contestoEsterno)) {
                regola.setContestoEsterno(contestoEsterno);
            } else {
                regola.setContestoEsterno("");
            }
            regola.setRegexpr(regExpr);
            regola.setRegola(regolaText);
            if (StringUtils.isNotEmpty((CharSequence)protocollo)) {
                regola.setProtocollo(protocollo);
            }
            if (StringUtils.isNotEmpty((CharSequence)soggetto)) {
                IDSoggetto selezionatoToID = confCore.convertSoggettoSelezionatoToID(soggetto);
                IdSoggetto idSoggetto = new IdSoggetto();
                idSoggetto.setTipo(selezionatoToID.getTipo());
                idSoggetto.setNome(selezionatoToID.getNome());
                regola.setSoggetto(idSoggetto);
            }
            if (StringUtils.isNotEmpty((CharSequence)ruolo)) {
                if (ruolo.equals("erogazione")) {
                    regola.setRuolo(RuoloContesto.PORTA_APPLICATIVA);
                } else if (ruolo.equals("fruizione")) {
                    regola.setRuolo(RuoloContesto.PORTA_DELEGATA);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)serviceBinding)) {
                if (serviceBinding.equals("SOAP")) {
                    regola.setServiceBinding(ServiceBinding.SOAP);
                } else if (serviceBinding.equals("REST")) {
                    regola.setServiceBinding(ServiceBinding.REST);
                }
            }
            if (stato.equals(StatoFunzionalita.ABILITATO.getValue())) {
                regola.setStato(StatoFunzionalita.ABILITATO);
            } else {
                regola.setStato(StatoFunzionalita.DISABILITATO);
            }
            regola.setPosizione(posizione);
            confCore.performCreateOperation(userLogin, confHelper.smista(), regola);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_PROXY_PASS_REGOLA;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<ConfigurazioneUrlInvocazioneRegola> lista = confCore.proxyPassConfigurazioneRegolaList((ISearch)ricerca);
            confHelper.prepareProxyPassConfigurazioneRegolaList((ISearch)ricerca, lista);
            pd.setMessage("Configurazione Propriet&agrave; di Sistema modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", Costanti.MESSAGE_TYPE_INFO);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneProxyPassRegola", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneProxyPassRegola", (ForwardParams)ForwardParams.ADD());
        }
    }
}

