/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.id.UUIDUtilsGenerator;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class ConfigurazionePluginsArchiviJarAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            String nome = confHelper.getParameter("plNome");
            String sorgente = confHelper.getParameter("plSorg");
            BinaryParameter jarArchivio = confHelper.getBinaryParameter("plJar");
            String urlArchivio = confHelper.getParameter("plUrl");
            String dirArchivio = confHelper.getParameter("plDir");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            lstParam.add(new Parameter("Registro Archivi", "configurazionePluginsArchiviList.do"));
            lstParam.add(new Parameter(nome, "configurazionePluginsArchiviChange.do", new Parameter[]{new Parameter("plOldNome", nome)}));
            lstParam.add(ServletUtils.getParameterAggiungi());
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            if (confHelper.isEditModeInProgress()) {
                if (sorgente == null) {
                    sorgente = ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_PLUGINS_ARCHIVI_SORGENTE_JAR;
                    dirArchivio = "";
                    urlArchivio = "";
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addRegistroPluginJarToDati(TipoOperazione.ADD, dati, true, nome, sorgente, jarArchivio, dirArchivio, urlArchivio);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazionePluginsArchiviJar", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.registroPluginArchivioCheckData(TipoOperazione.ADD, sorgente, nome, jarArchivio, dirArchivio, urlArchivio, true);
            if (!isOk) {
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = confHelper.addRegistroPluginJarToDati(TipoOperazione.ADD, dati, true, nome, sorgente, jarArchivio, dirArchivio, urlArchivio);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazionePluginsArchiviJar", (ForwardParams)ForwardParams.ADD());
            }
            RegistroPlugin registro = confCore.getDatiRegistroPlugin(nome);
            registro.setData(new Date());
            RegistroPluginArchivio registroPluginArchivio = new RegistroPluginArchivio();
            registroPluginArchivio.setNomePlugin(nome);
            registroPluginArchivio.setData(registro.getData());
            registroPluginArchivio.setSorgente(DriverConfigurazioneDBLib.getEnumPluginSorgenteArchivio((String)sorgente));
            switch (registroPluginArchivio.getSorgente()) {
                case JAR: {
                    registroPluginArchivio.setNome(jarArchivio.getFilename());
                    registroPluginArchivio.setContenuto(jarArchivio.getValue());
                    break;
                }
                case URL: {
                    registroPluginArchivio.setUrl(urlArchivio);
                    registroPluginArchivio.setNome(UUIDUtilsGenerator.newUUID());
                    break;
                }
                case DIR: {
                    registroPluginArchivio.setDir(dirArchivio);
                    registroPluginArchivio.setNome(UUIDUtilsGenerator.newUUID());
                }
            }
            confCore.performCreateOperation(userLogin, confHelper.smista(), registroPluginArchivio);
            confCore.performUpdateOperation(userLogin, confHelper.smista(), registro);
            confCore.updatePluginClassLoader();
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.CONFIGURAZIONE_PLUGINS_ARCHIVI_JAR;
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<RegistroPluginArchivio> lista = confCore.pluginsArchiviJarList(nome, (ISearch)ricerca);
            confHelper.preparePluginsArchiviJarList(nome, (ISearch)ricerca, lista);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazionePluginsArchiviJar", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazionePluginsArchiviJar", (ForwardParams)ForwardParams.ADD());
        }
    }
}

