/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneGeneraleHandler;
import org.openspcoop2.core.config.ConfigurazioneHandler;
import org.openspcoop2.core.config.ConfigurazioneServiceHandlers;
import org.openspcoop2.core.config.constants.FaseServiceHandler;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.utils.handlers.ConfigurazioneHandlerBean;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ConfigurazioneHandlersServizioChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        TipoOperazione tipoOperazione = TipoOperazione.CHANGE;
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            boolean first = confHelper.isFirstTimeFromHttpParameters("hFirstTime");
            String idHandlerS = confHelper.getParametroLong("hId");
            TipoPdD ruoloPorta = null;
            String idPortaS = null;
            Long idPorta = null;
            ServiceBinding serviceBinding = null;
            String nomePlugin = confHelper.getParameter("hPlugin");
            String fase = confHelper.getParameter("hFase");
            String stato = confHelper.getParameter("hStato");
            FaseServiceHandler faseSH = FaseServiceHandler.toEnumConstant((String)fase);
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            Long idHandler = Long.parseLong(idHandlerS);
            ConfigurazioneHandlerBean handler = confCore.getHandlerServizio(fase, idHandler);
            Plugin plugin = handler.getPlugin();
            String tipo = plugin.getTipo();
            List<String> tipiPluginGiaUtilizzati = null;
            ArrayList<Parameter> lstParamSession = new ArrayList<Parameter>();
            Parameter parTipologia = null;
            if (fase != null) {
                parTipologia = new Parameter("hFase", fase);
                lstParamSession.add(parTipologia);
            }
            String labelHandler = confHelper.getLabelTipologiaFromFaseMessageHandler(fase, true);
            String servletListURL = "configurazioneHandlersServizioList.do";
            String messaggioValoriNonDisponibili = MessageFormat.format("Non sono disponibili Plugin per la fase {0}", labelHandler);
            String messaggioHandlerServizioDuplicato = null;
            ArrayList<Parameter> lstParam = null;
            lstParam = new ArrayList<Parameter>();
            if (!lstParamSession.isEmpty()) {
                lstParam.add(new Parameter(labelHandler, servletListURL, lstParamSession.toArray(new Parameter[lstParamSession.size()])));
            } else {
                lstParam.add(new Parameter(labelHandler, servletListURL));
            }
            lstParam.add(new Parameter(plugin.getLabel(), null));
            lstParam.add(0, new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            if (confHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                if (first) {
                    nomePlugin = plugin.getTipo();
                    stato = handler.getStato().getValue();
                }
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                confHelper.addHandlerServizioToDati(dati, tipoOperazione, idHandlerS, nomePlugin, stato, ruoloPorta, idPortaS, serviceBinding, fase, tipiPluginGiaUtilizzati, messaggioValoriNonDisponibili);
                confHelper.addToDatiFirstTimeDisabled(dati, "allFirstTime");
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneHandlersServizio", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = confHelper.handlerServizioCheckData(tipoOperazione, handler, nomePlugin, stato, ruoloPorta, idPorta, fase, tipo, messaggioHandlerServizioDuplicato);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                confHelper.addHandlerServizioToDati(dati, tipoOperazione, idHandlerS, nomePlugin, stato, ruoloPorta, idPortaS, serviceBinding, fase, tipiPluginGiaUtilizzati, messaggioValoriNonDisponibili);
                confHelper.addToDatiFirstTimeDisabled(dati, "allFirstTime");
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneHandlersServizio", (ForwardParams)ForwardParams.CHANGE());
            }
            handler.setStato(StatoFunzionalita.toEnumConstant((String)stato));
            ArrayList<Configurazione> oggettiDaAggiornare = new ArrayList<Configurazione>();
            List listaDaAggiornare = null;
            Configurazione configurazione = confCore.getConfigurazioneGenerale();
            if (configurazione.getConfigurazioneHandler() == null) {
                configurazione.setConfigurazioneHandler(new ConfigurazioneGeneraleHandler());
            }
            if (configurazione.getConfigurazioneHandler().getService() == null) {
                configurazione.getConfigurazioneHandler().setService(new ConfigurazioneServiceHandlers());
            }
            switch (faseSH) {
                case EXIT: {
                    listaDaAggiornare = configurazione.getConfigurazioneHandler().getService().getExitList();
                    break;
                }
                case INIT: {
                    listaDaAggiornare = configurazione.getConfigurazioneHandler().getService().getInitList();
                    break;
                }
                case INTEGRATION_MANAGER_REQUEST: {
                    listaDaAggiornare = configurazione.getConfigurazioneHandler().getService().getIntegrationManagerRequestList();
                    break;
                }
                case INTEGRATION_MANAGER_RESPONSE: {
                    listaDaAggiornare = configurazione.getConfigurazioneHandler().getService().getIntegrationManagerResponseList();
                }
            }
            oggettiDaAggiornare.add(configurazione);
            if (listaDaAggiornare != null) {
                for (ConfigurazioneHandler handlerToCheck : listaDaAggiornare) {
                    if (!handlerToCheck.getTipo().equals(handler.getTipo())) continue;
                    confHelper.updateHandler(handlerToCheck, (ConfigurazioneHandler)handler, tipoOperazione);
                }
            }
            confCore.performUpdateOperation(userLogin, confHelper.smista(), oggettiDaAggiornare.toArray(new Object[oggettiDaAggiornare.size()]));
            int idLista = Liste.CONFIGURAZIONE_HANDLERS_SERVIZIO;
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<ConfigurazioneHandlerBean> lista = confCore.handlersServizioList((ISearch)ricerca, fase);
            confHelper.prepareHandlersServizioList(ricerca, lista, ruoloPorta, idPortaS, serviceBinding, fase);
            if (ruoloPorta == null) {
                pd.setMessage("Configurazione Service Handler modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", Costanti.MESSAGE_TYPE_INFO);
            }
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneHandlersServizio", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneHandlersServizio", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

