/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneGeneraleHandler;
import org.openspcoop2.core.config.ConfigurazioneHandler;
import org.openspcoop2.core.config.ConfigurazioneServiceHandlers;
import org.openspcoop2.core.config.constants.FaseServiceHandler;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.plugins.utils.handlers.ConfigurazioneHandlerBean;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ConfigurazioneHandlersServizioAdd
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        TipoOperazione tipoOperazione = TipoOperazione.ADD;
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            boolean first = confHelper.isFirstTimeFromHttpParameters("hFirstTime");
            TipoPdD ruoloPorta = null;
            String idPortaS = null;
            Long idPorta = null;
            ServiceBinding serviceBinding = null;
            String nomePlugin = confHelper.getParameter("hPlugin");
            String fase = confHelper.getParameter("hFase");
            String stato = confHelper.getParameter("hStato");
            FaseServiceHandler faseSH = FaseServiceHandler.toEnumConstant((String)fase);
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            ArrayList<String> tipiPluginGiaUtilizzati = null;
            ConsoleSearch ricercaPluginUilizzati = new ConsoleSearch(true);
            List<ConfigurazioneHandlerBean> listaEsistenti = confCore.handlersServizioList((ISearch)ricercaPluginUilizzati, fase);
            if (listaEsistenti != null && !listaEsistenti.isEmpty()) {
                tipiPluginGiaUtilizzati = new ArrayList<String>();
                for (ConfigurazioneHandlerBean configurazioneHandlerBean : listaEsistenti) {
                    tipiPluginGiaUtilizzati.add(configurazioneHandlerBean.getPlugin().getTipo());
                }
            }
            ArrayList<Parameter> lstParamSession = new ArrayList<Parameter>();
            Parameter parTipologia = null;
            if (fase != null) {
                parTipologia = new Parameter("hFase", fase);
                lstParamSession.add(parTipologia);
            }
            String labelHandler = confHelper.getLabelTipologiaFromFaseServiceHandler(fase);
            String servletListURL = "configurazioneHandlersServizioList.do";
            String messaggioValoriNonDisponibili = MessageFormat.format("Non sono disponibili Plugin per la fase {0}", labelHandler);
            String messaggioHandlerServizioDuplicato = null;
            String tipo = null;
            Plugin plugin = null;
            if (nomePlugin != null) {
                plugin = confCore.getPlugin(TipoPlugin.SERVICE_HANDLER, nomePlugin, false);
            }
            if (plugin != null) {
                messaggioHandlerServizioDuplicato = MessageFormat.format("Esiste gi&agrave; un Service Handler per la fase {0} che utilizza il plugin {1}", labelHandler, plugin.getLabel());
                tipo = plugin.getTipo();
            }
            ArrayList<Parameter> lstParam = null;
            lstParam = new ArrayList<Parameter>();
            if (!lstParamSession.isEmpty()) {
                lstParam.add(new Parameter(labelHandler, servletListURL, lstParamSession.toArray(new Parameter[lstParamSession.size()])));
            } else {
                lstParam.add(new Parameter(labelHandler, servletListURL));
            }
            lstParam.add(ServletUtils.getParameterAggiungi());
            lstParam.add(0, new Parameter("Configurazione Generale", "configurazioneGenerale.do"));
            if (confHelper.isEditModeInProgress()) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                if (first) {
                    nomePlugin = "";
                    stato = StatoFunzionalita.ABILITATO.getValue();
                }
                ArrayList<Object> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                confHelper.addHandlerServizioToDati(dati, tipoOperazione, null, nomePlugin, stato, ruoloPorta, idPortaS, serviceBinding, fase, tipiPluginGiaUtilizzati, messaggioValoriNonDisponibili);
                if (pd.getMessage() != null && pd.isDisableEditMode()) {
                    dati = new ArrayList();
                }
                confHelper.addToDatiFirstTimeDisabled(dati, "hFirstTime");
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"configurazioneHandlersServizio", (ForwardParams)ForwardParams.ADD());
            }
            boolean isOk = confHelper.handlerServizioCheckData(TipoOperazione.ADD, null, nomePlugin, stato, ruoloPorta, idPorta, fase, tipo, messaggioHandlerServizioDuplicato);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, lstParam);
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                confHelper.addHandlerServizioToDati(dati, tipoOperazione, null, nomePlugin, stato, ruoloPorta, idPortaS, serviceBinding, fase, tipiPluginGiaUtilizzati, messaggioValoriNonDisponibili);
                confHelper.addToDatiFirstTimeDisabled(dati, "hFirstTime");
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"configurazioneHandlersServizio", (ForwardParams)ForwardParams.ADD());
            }
            ConfigurazioneHandler handler = new ConfigurazioneHandler();
            handler.setTipo(plugin.getTipo());
            handler.setStato(StatoFunzionalita.toEnumConstant((String)stato));
            int posizione = confCore.getMaxPosizioneHandlersServizio(fase) + 1;
            handler.setPosizione(posizione);
            ArrayList<Configurazione> oggettiDaAggiornare = new ArrayList<Configurazione>();
            Configurazione configurazione = confCore.getConfigurazioneGenerale();
            if (configurazione.getConfigurazioneHandler() == null) {
                configurazione.setConfigurazioneHandler(new ConfigurazioneGeneraleHandler());
            }
            if (configurazione.getConfigurazioneHandler().getService() == null) {
                configurazione.getConfigurazioneHandler().setService(new ConfigurazioneServiceHandlers());
            }
            switch (faseSH) {
                case EXIT: {
                    configurazione.getConfigurazioneHandler().getService().addExit(handler);
                    break;
                }
                case INIT: {
                    configurazione.getConfigurazioneHandler().getService().addInit(handler);
                    break;
                }
                case INTEGRATION_MANAGER_REQUEST: {
                    configurazione.getConfigurazioneHandler().getService().addIntegrationManagerRequest(handler);
                    break;
                }
                case INTEGRATION_MANAGER_RESPONSE: {
                    configurazione.getConfigurazioneHandler().getService().addIntegrationManagerResponse(handler);
                }
            }
            oggettiDaAggiornare.add(configurazione);
            confCore.performUpdateOperation(userLogin, confHelper.smista(), oggettiDaAggiornare.toArray(new Object[oggettiDaAggiornare.size()]));
            int idLista = Liste.CONFIGURAZIONE_HANDLERS_SERVIZIO;
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<ConfigurazioneHandlerBean> lista = confCore.handlersServizioList((ISearch)ricerca, fase);
            confHelper.prepareHandlersServizioList(ricerca, lista, ruoloPorta, idPortaS, serviceBinding, fase);
            if (ruoloPorta == null) {
                pd.setMessage("Configurazione Service Handler modificata con successo<BR><b>Attenzione:</b> Le modifiche saranno operative al prossimo riavvio di GovWay", Costanti.MESSAGE_TYPE_INFO);
            }
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"configurazioneHandlersServizio", (ForwardParams)ForwardParams.ADD());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneHandlersServizio", (ForwardParams)ForwardParams.ADD());
        }
    }
}

