/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.config;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneHelper;
import org.openspcoop2.web.lib.mvc.Costanti;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class ConfigurazioneControlloTrafficoAttivazionePolicyList
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            ConfigurazioneHelper confHelper = new ConfigurazioneHelper(request, pd, session);
            confHelper.makeMenu();
            String ruoloPortaParam = confHelper.getParametroRuoloPolicy("CTPolicyRuoloPorta");
            RuoloPolicy ruoloPorta = null;
            if (ruoloPortaParam != null) {
                ruoloPorta = RuoloPolicy.toEnumConstant((String)ruoloPortaParam);
            }
            String nomePorta = confHelper.getParameter("CTPolicyNomePorta");
            ServiceBinding serviceBinding = null;
            String serviceBindingParam = confHelper.getParametroServiceBinding("CTPolicyServiceBinding");
            if (serviceBindingParam != null && !"".equals(serviceBindingParam)) {
                serviceBinding = ServiceBinding.valueOf((String)serviceBindingParam);
            }
            String idTab = confHelper.getParametroInteger("idTab");
            if (!confHelper.isModalitaCompleta() && StringUtils.isNotEmpty((CharSequence)idTab)) {
                ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)idTab, (String)"idTab");
            }
            String cambiaPosizione = confHelper.getParameter("CTPolictyActivePos");
            ConfigurazioneCore confCore = new ConfigurazioneCore();
            int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ATTIVAZIONE_POLICY;
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            if (StringUtils.isNotEmpty((CharSequence)cambiaPosizione)) {
                String idPolicyS = confHelper.getParametroLong("CTPolicyId");
                long idPolicyLong = Long.parseLong(idPolicyS);
                String risorsaPolicy = confHelper.getParameter("CTPolicyRisorsa");
                ConsoleSearch ricercaPerRisorsa = new ConsoleSearch(true);
                ricercaPerRisorsa.addFilter(idLista, "filtroTipoRisorsaPolicy", risorsaPolicy);
                List<AttivazionePolicy> lista = confCore.attivazionePolicyList(ricercaPerRisorsa, ruoloPorta, nomePorta);
                if (lista != null && !lista.isEmpty()) {
                    AttivazionePolicy regolaToMove = null;
                    int index = 0;
                    for (int i = 0; i < lista.size(); ++i) {
                        if (lista.get(i).getId() != idPolicyLong) continue;
                        regolaToMove = lista.get(i);
                        index = i;
                        break;
                    }
                    AttivazionePolicy regolaToSwitch = null;
                    if (cambiaPosizione.equals("su")) {
                        if (index > 0) {
                            regolaToSwitch = lista.get(index - 1);
                        }
                    } else if (index < lista.size() - 1) {
                        regolaToSwitch = lista.get(index + 1);
                    }
                    if (regolaToMove != null && regolaToSwitch != null) {
                        int posizioneAttuale = regolaToMove.getPosizione();
                        regolaToMove.setPosizione(regolaToSwitch.getPosizione());
                        regolaToSwitch.setPosizione(posizioneAttuale);
                        ArrayList<AttivazionePolicy> list = new ArrayList<AttivazionePolicy>();
                        list.add(regolaToMove);
                        list.add(regolaToSwitch);
                        confCore.performUpdateOperation(userLogin, confHelper.smista(), list.toArray(new Object[1]));
                        String msgCompletato = confHelper.eseguiResetJmx(TipoOperazione.CHANGE, ruoloPorta, nomePorta);
                        if (msgCompletato != null && !"".equals(msgCompletato)) {
                            pd.setMessage(msgCompletato, Costanti.MESSAGE_TYPE_INFO);
                        }
                    }
                }
            }
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            ricerca = confHelper.checkSearchParameters(idLista, ricerca);
            List<TipoRisorsaPolicyAttiva> listaTipoRisorsa = confHelper.gestisciCriteriFiltroRisorsaPolicy(ricerca, ruoloPorta, nomePorta);
            List<AttivazionePolicy> lista = confCore.attivazionePolicyList(ricerca, ruoloPorta, nomePorta);
            confHelper.prepareAttivazionePolicyList(ricerca, lista, listaTipoRisorsa, idLista, ruoloPorta, nomePorta, serviceBinding);
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.LIST());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"configurazioneControlloTrafficoAttivazionePolicy", (ForwardParams)ForwardParams.LIST());
        }
    }
}

