/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.archivi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.ActionForm;
import org.govway.struts.upload.FormFile;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissing;
import org.openspcoop2.protocol.engine.archive.ImportInformationMissingCollection;
import org.openspcoop2.protocol.information_missing.Wizard;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ArchiveModeType;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.archive.ImportMode;
import org.openspcoop2.protocol.sdk.archive.MapPlaceholder;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.serialization.JavaDeserializer;
import org.openspcoop2.utils.serialization.JavaSerializer;
import org.openspcoop2.web.ctrlstat.core.SerialiableFormFile;
import org.openspcoop2.web.ctrlstat.dao.PdDControlStation;
import org.openspcoop2.web.ctrlstat.servlet.FileUploadForm;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviHelper;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;

public class ImporterUtils {
    private SoggettiCore soggettiCore = null;
    private AccordiServizioParteComuneCore aspcCore = null;
    private AccordiCooperazioneCore acCore = null;
    private PddCore pddCore = null;

    public ImporterUtils(ArchiviCore archiviCore) throws Exception {
        this.soggettiCore = new SoggettiCore(archiviCore);
        this.aspcCore = new AccordiServizioParteComuneCore(archiviCore);
        this.acCore = new AccordiCooperazioneCore(archiviCore);
        this.pddCore = new PddCore(archiviCore);
    }

    public List<String> getIdSoggetti(List<String> protocolli, String importMode, String protocolloMissingInput, String tipoPdDMissingInput, Wizard wizard, ArchiviHelper helper) throws Exception {
        int i;
        ArrayList<String> listIdSoggetti = new ArrayList<String>();
        ArrayList<String> protocolliDaScorrere = new ArrayList<String>();
        if (wizard != null && wizard.getRequisiti() != null && wizard.getRequisiti().sizeProtocolloList() > 0) {
            for (i = 0; i < wizard.getRequisiti().sizeProtocolloList(); ++i) {
                protocolliDaScorrere.add(wizard.getRequisiti().getProtocollo(i).getNome());
            }
        } else {
            protocolliDaScorrere.addAll(protocolli);
        }
        for (i = 0; i < protocolliDaScorrere.size(); ++i) {
            IProtocolFactory pf;
            IArchive archiveEngine;
            List importModesByProtocol;
            String protocollo = (String)protocolliDaScorrere.get(i);
            if ("-".equals(protocollo) || !(importModesByProtocol = (archiveEngine = (pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo)).createArchive()).getImportModes()).contains(new ImportMode(importMode))) continue;
            List<String> tipi = this.soggettiCore.getTipiSoggettiGestitiProtocollo(protocollo);
            for (int j = 0; j < tipi.size(); ++j) {
                String tipo = tipi.get(j);
                FiltroRicercaSoggetti filtro = new FiltroRicercaSoggetti();
                filtro.setTipo(tipo);
                List<IDSoggetto> idSoggetti = this.soggettiCore.getAllIdSoggettiRegistro(filtro);
                for (int k = 0; k < idSoggetti.size(); ++k) {
                    IDSoggetto id = idSoggetti.get(k);
                    listIdSoggetti.add(id.getTipo() + "/" + id.getNome());
                }
            }
        }
        if (protocolloMissingInput == null && tipoPdDMissingInput == null) {
            if (listIdSoggetti.size() <= 0) {
                throw new ProtocolException("Non risulta configurato alcun soggetto. Tale configurazione \u00e8 richiesta per procedere con l'importazione");
            }
            if (listIdSoggetti.size() != 1) {
                listIdSoggetti.add("-");
            }
            Collections.sort(listIdSoggetti);
            return listIdSoggetti;
        }
        ArrayList<String> listIdSoggettiFiltrati = new ArrayList<String>();
        for (String tipoNome : listIdSoggetti) {
            PdDControlStation pdd;
            Soggetto sog;
            String[] tmp = tipoNome.split("/");
            String tipo = tmp[0];
            String nome = tmp[1];
            IDSoggetto idSoggetto = new IDSoggetto(tipo, nome);
            if (protocolloMissingInput != null && !protocolloMissingInput.equals(this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tipo)) || tipoPdDMissingInput != null && ((sog = this.soggettiCore.getSoggettoRegistro(idSoggetto)).getPortaDominio() == null || !tipoPdDMissingInput.equals((pdd = this.pddCore.getPdDControlStation(sog.getPortaDominio())).getTipo()))) continue;
            listIdSoggettiFiltrati.add(tipoNome);
        }
        Object criteri = "";
        if (protocolloMissingInput != null) {
            criteri = (String)criteri + " Profilo di Interoperabilit\u00e0:" + helper.getLabelProtocollo(protocolloMissingInput);
        }
        if (tipoPdDMissingInput != null) {
            criteri = (String)criteri + " tipoPdDAssociata:" + tipoPdDMissingInput;
        }
        if (listIdSoggettiFiltrati.size() <= 0) {
            throw new ProtocolException("Non risulta configurato alcun soggetto che soddisfa i seguenti requisiti: " + (String)criteri + ". Tale configurazione \u00e8 richiesta per procedere con l'importazione");
        }
        if (listIdSoggettiFiltrati.size() != 1) {
            listIdSoggettiFiltrati.add("-");
        }
        Collections.sort(listIdSoggettiFiltrati);
        return listIdSoggettiFiltrati;
    }

    public List<String> getIdAccordiServizioParteComune(List<String> protocolli, String importMode, String protocolloMissingInput, ArchiviHelper helper) throws Exception {
        ArrayList<String> listIdAccordiServizioParteComune = new ArrayList<String>();
        for (int i = 0; i < protocolli.size(); ++i) {
            IProtocolFactory pf;
            IArchive archiveEngine;
            List importModesByProtocol;
            String protocollo = protocolli.get(i);
            if ("-".equals(protocollo) || protocolloMissingInput != null && !protocolloMissingInput.equals(protocollo) || !(importModesByProtocol = (archiveEngine = (pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo)).createArchive()).getImportModes()).contains(new ImportMode(importMode))) continue;
            List<String> tipi = this.soggettiCore.getTipiSoggettiGestitiProtocollo(protocollo);
            for (int j = 0; j < tipi.size(); ++j) {
                String tipo = tipi.get(j);
                FiltroRicercaAccordi filtro = new FiltroRicercaAccordi();
                filtro.setTipoSoggettoReferente(tipo);
                try {
                    List<IDAccordo> idAccordi = this.aspcCore.getAllIdAccordiServizio(filtro);
                    for (int k = 0; k < idAccordi.size(); ++k) {
                        listIdAccordiServizioParteComune.add(IDAccordoFactory.getInstance().getUriFromIDAccordo(idAccordi.get(k)));
                    }
                    continue;
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
            }
        }
        if (listIdAccordiServizioParteComune.size() <= 0) {
            if (protocolloMissingInput == null) {
                throw new ProtocolException("Non risulta configurata alcuna API. Tale configurazione \u00e8 richiesta per procedere con l'importazione");
            }
            throw new ProtocolException("Non risulta configurata alcuna API (Profilo di Interoperabilit\u00e0: " + helper.getLabelProtocollo(protocolloMissingInput) + "). Tale configurazione \u00e8 richiesta per procedere con l'importazione");
        }
        if (listIdAccordiServizioParteComune.size() != 1) {
            listIdAccordiServizioParteComune.add("-");
        }
        Collections.sort(listIdAccordiServizioParteComune);
        return listIdAccordiServizioParteComune;
    }

    public List<String> getIdAccordiCooperazione(List<String> protocolli, String importMode, String protocolloMissingInput, ArchiviHelper helper) throws Exception {
        ArrayList<String> listIdAccordiCooperazione = new ArrayList<String>();
        for (int i = 0; i < protocolli.size(); ++i) {
            IProtocolFactory pf;
            IArchive archiveEngine;
            List importModesByProtocol;
            String protocollo = protocolli.get(i);
            if ("-".equals(protocollo) || protocolloMissingInput != null && !protocolloMissingInput.equals(protocollo) || !(importModesByProtocol = (archiveEngine = (pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo)).createArchive()).getImportModes()).contains(new ImportMode(importMode))) continue;
            List<String> tipi = this.soggettiCore.getTipiSoggettiGestitiProtocollo(protocollo);
            for (int j = 0; j < tipi.size(); ++j) {
                String tipo = tipi.get(j);
                FiltroRicercaAccordi filtro = new FiltroRicercaAccordi();
                filtro.setTipoSoggettoReferente(tipo);
                try {
                    List<IDAccordoCooperazione> idAccordi = this.acCore.getAllIdAccordiCooperazione(filtro);
                    for (int k = 0; k < idAccordi.size(); ++k) {
                        listIdAccordiCooperazione.add(IDAccordoCooperazioneFactory.getInstance().getUriFromIDAccordo(idAccordi.get(k)));
                    }
                    continue;
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
            }
        }
        if (listIdAccordiCooperazione.size() <= 0) {
            if (protocolloMissingInput == null) {
                throw new ProtocolException("Non risulta configurato alcun Accordo di Cooperazione. Tale configurazione \u00e8 richiesta per procedere con l'importazione");
            }
            throw new ProtocolException("Non risulta configurato alcun Accordo di Cooperazione (Profilo di Interoperabilit\u00e0: " + helper.getLabelProtocollo(protocolloMissingInput) + "). Tale configurazione \u00e8 richiesta per procedere con l'importazione");
        }
        if (listIdAccordiCooperazione.size() != 1) {
            listIdAccordiCooperazione.add("-");
        }
        Collections.sort(listIdAccordiCooperazione);
        return listIdAccordiCooperazione;
    }

    public Map<String, String> getImportModesWithProtocol(List<String> protocolli) throws ProtocolException {
        HashMap<String, String> importModes = new HashMap<String, String>();
        for (int i = 0; i < protocolli.size(); ++i) {
            String protocolName = protocolli.get(i);
            if ("-".equals(protocolName)) continue;
            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocolName);
            IArchive archiveEngine = pf.createArchive();
            List importModesByProtocol = archiveEngine.getImportModes();
            for (ImportMode imp : importModesByProtocol) {
                if (importModes.containsKey(imp.toString())) continue;
                importModes.put(imp.toString(), protocolName);
            }
        }
        return importModes;
    }

    public List<ArchiveModeType> getImportModeTypes(ArchiveMode mode, String protocol) throws ProtocolException {
        IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
        IArchive archiveEngine = pf.createArchive();
        return archiveEngine.getMappingTypesExtensions(mode).getAllTypes();
    }

    public List<String> getValidExtensions(ArchiveModeType type, ArchiveMode mode, String protocol) throws ProtocolException {
        IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocol);
        IArchive archiveEngine = pf.createArchive();
        return archiveEngine.getMappingTypesExtensions(mode).mappingTypeToExts(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSerializeObject(File tmpF, Object object) throws Exception {
        JavaSerializer javaSerializer = new JavaSerializer();
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(tmpF);
            javaSerializer.writeObject(object, (OutputStream)fout);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T readObject(File f, Class<T> c, boolean deleteFile) throws Exception {
        FileInputStream fis = null;
        JavaDeserializer javaDeserializer = new JavaDeserializer();
        try {
            fis = new FileInputStream(f);
            Object object = javaDeserializer.readObject((InputStream)fis, c);
            return (T)object;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
            if (deleteFile) {
                try {
                    if (f.delete()) {
                        // empty if block
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public File writeFormFile(String sessionId, FormFile ff) throws Exception {
        File tmpF = FileSystemUtilities.createTempFile((String)(sessionId + "-" + ff.getFileName()), (String)"tmp");
        this.writeSerializeObject(tmpF, ff);
        return tmpF;
    }

    public FormFile readFormFile(String filePath, ActionForm form) throws Exception {
        FormFile ff = null;
        if (StringUtils.isNotEmpty((CharSequence)filePath)) {
            File f = new File(filePath);
            ff = this.readObject(f, FormFile.class, true);
        } else {
            FileUploadForm fileUpload = (FileUploadForm)form;
            ff = fileUpload.getTheFile();
        }
        return ff != null && !(ff instanceof SerialiableFormFile) ? new SerialiableFormFile(ff) : ff;
    }

    public File writeImportInformationMissingCollectionFile(String sessionId, ImportInformationMissingCollection importInformationMissingCollection) throws Exception {
        File tmpF = FileSystemUtilities.createTempFile((String)(sessionId + "-importInformationMissingCollection"), (String)"tmp");
        this.writeSerializeObject(tmpF, importInformationMissingCollection);
        return tmpF;
    }

    public File writeImportInformationMissingObjectFile(String sessionId, Object object) throws Exception {
        File tmpF = FileSystemUtilities.createTempFile((String)(sessionId + "-importInformationMissingObject"), (String)"tmp");
        this.writeSerializeObject(tmpF, object);
        return tmpF;
    }

    public ImportInformationMissingCollection readImportInformationMissingCollectionFile(String filePath) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)filePath)) {
            File f = new File(filePath);
            return this.readObject(f, ImportInformationMissingCollection.class, true);
        }
        return null;
    }

    public <T> T readImportInformationMissingObjectFile(String filePath, Class<T> classObject) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)filePath)) {
            File f = new File(filePath);
            return this.readObject(f, classObject, true);
        }
        return null;
    }

    public ImportInformationMissingCollection updateInformationMissingCheckData(HashMap<String, String> mapRequisitiInput, HashMap<String, String> mapRequisitiInputStepIncrement, String importInformationMissing_soggettoInput, String importInformationMissing_versioneInput, List<PortType> importInformationMissing_portTypes, String importInformationMissing_portTypeImplementedInput, String importInformationMissing_accordoServizioParteComuneInput, String importInformationMissing_accordoCooperazioneInput, InvocazioneServizio importInformationMissing_invocazioneServizio, Connettore importInformationMissing_connettore, Credenziali importInformationMissing_credenziali, MapPlaceholder importInformationMissing_placeholder, String importInformationMissingCollectionFilePath, String importInformationMissingObjectId, ImportInformationMissingCollection importInformationMissingCollection) throws Exception {
        IDSoggetto idSoggetto = null;
        if (importInformationMissing_soggettoInput != null && !"".equals(importInformationMissing_soggettoInput) && !"-".equals(importInformationMissing_soggettoInput)) {
            String[] splitSoggetto = importInformationMissing_soggettoInput.split("/");
            idSoggetto = new IDSoggetto(splitSoggetto[0].trim(), splitSoggetto[1].trim());
        }
        Integer versione = null;
        if (importInformationMissing_versioneInput != null) {
            try {
                versione = Integer.parseInt(importInformationMissing_versioneInput);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        IDAccordo idAccordoServizioParteComune = null;
        if (importInformationMissing_accordoServizioParteComuneInput != null && !"".equals(importInformationMissing_accordoServizioParteComuneInput) && !"-".equals(importInformationMissing_accordoServizioParteComuneInput)) {
            idAccordoServizioParteComune = IDAccordoFactory.getInstance().getIDAccordoFromUri(importInformationMissing_accordoServizioParteComuneInput.trim());
        }
        IDAccordoCooperazione idAccordoCooperazione = null;
        if (importInformationMissing_accordoCooperazioneInput != null && !"".equals(importInformationMissing_accordoCooperazioneInput) && !"-".equals(importInformationMissing_accordoCooperazioneInput)) {
            idAccordoCooperazione = IDAccordoCooperazioneFactory.getInstance().getIDAccordoFromUri(importInformationMissing_accordoCooperazioneInput.trim());
        }
        ImportInformationMissing importInformationMissing = null;
        if (importInformationMissingObjectId != null) {
            if (importInformationMissingCollection != null) {
                importInformationMissing = importInformationMissingCollection.remove(importInformationMissingObjectId);
            } else {
                importInformationMissingCollection = new ImportInformationMissingCollection();
            }
            if (importInformationMissing == null) {
                importInformationMissing = new ImportInformationMissing();
            }
            if (mapRequisitiInput != null) {
                importInformationMissing.setRequisitiInput(mapRequisitiInput);
            }
            if (mapRequisitiInputStepIncrement != null) {
                importInformationMissing.setRequisitiInputStepIncrement(mapRequisitiInputStepIncrement);
            }
            if (idSoggetto != null) {
                importInformationMissing.setSoggetto(idSoggetto);
            }
            if (versione != null) {
                importInformationMissing.setVersione(versione);
            }
            if (importInformationMissing_portTypes != null) {
                importInformationMissing.setPortTypes(importInformationMissing_portTypes);
            }
            if (importInformationMissing_portTypeImplementedInput != null) {
                importInformationMissing.setPortTypeImplemented(importInformationMissing_portTypeImplementedInput);
            }
            if (idAccordoServizioParteComune != null) {
                importInformationMissing.setIdAccordoServizioParteComune(idAccordoServizioParteComune);
            }
            if (idAccordoCooperazione != null) {
                importInformationMissing.setIdAccordoCooperazione(idAccordoCooperazione);
            }
            if (importInformationMissing_invocazioneServizio != null) {
                importInformationMissing.setInvocazioneServizio(importInformationMissing_invocazioneServizio);
            }
            if (importInformationMissing_connettore != null) {
                importInformationMissing.setConnettore(importInformationMissing_connettore);
            }
            if (importInformationMissing_credenziali != null) {
                importInformationMissing.setCredenziali(importInformationMissing_credenziali);
            }
            if (importInformationMissing_placeholder != null) {
                importInformationMissing.setInputPlaceholder(importInformationMissing_placeholder);
            }
            importInformationMissingCollection.add(importInformationMissingObjectId, importInformationMissing);
        }
        return importInformationMissingCollection;
    }
}

