/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.archivi;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.allarmi.IdAllarme;
import org.openspcoop2.core.controllo_traffico.IdActivePolicy;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGenericProperties;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDScope;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.archive.Archive;
import org.openspcoop2.protocol.sdk.archive.ArchiveCascadeConfiguration;
import org.openspcoop2.protocol.sdk.archive.ArchiveMode;
import org.openspcoop2.protocol.sdk.archive.ExportMode;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.archive.MappingModeTypesExtensions;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;

public class ArchiviExporter
extends HttpServlet {
    private static final long serialVersionUID = -7341279067126334095L;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.processRequest(req, resp);
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response) {
        Object redirect = null;
        try {
            MappingModeTypesExtensions mappingModeTypeExt;
            String extSingleArchive;
            boolean exportFromApi;
            HttpSession session = request.getSession(true);
            PageData pd = new PageData();
            ArchiviHelper archiviHelper = new ArchiviHelper(request, pd, session);
            ArchiviCore archiviCore = new ArchiviCore();
            SoggettiCore soggettiCore = new SoggettiCore(archiviCore);
            AccordiServizioParteSpecificaCore aspsCore = new AccordiServizioParteSpecificaCore(archiviCore);
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
            String servletSourceExport = archiviHelper.getParameter("tipoExport");
            ArchiveType archiveType = ArchiveType.valueOf((String)servletSourceExport);
            String objToExport = archiviHelper.getParameter("obj");
            String cascadePolicyConfig = archiviHelper.getParameter("cascadePolicyConfig");
            String cascadePluginConfig = archiviHelper.getParameter("cascadePluginConfig");
            String cascade = archiviHelper.getParameter("cascade");
            String cascadePdd = archiviHelper.getParameter("cascadePdd");
            String cascadeGruppi = archiviHelper.getParameter("cascadeGruppi");
            String cascadeRuoli = archiviHelper.getParameter("cascadeRuoli");
            String cascadeScope = archiviHelper.getParameter("cascadeScope");
            String cascadeSoggetti = archiviHelper.getParameter("cascadeSoggetti");
            String cascadeServiziApplicativi = archiviHelper.getParameter("cascadeServiziApplicativi");
            String cascadePorteDelegate = archiviHelper.getParameter("cascadePorteDelegate");
            String cascadePorteApplicative = archiviHelper.getParameter("cascadePorteApplicative");
            String cascadeAccordiCooperazione = archiviHelper.getParameter("cascadeAc");
            String cascadeAccordiServizioComposto = archiviHelper.getParameter("cascadeAsc");
            String cascadeAccordiServizioParteComune = archiviHelper.getParameter("cascadeAspc");
            String cascadeAccordiServizioParteSpecifica = archiviHelper.getParameter("cascadeAsps");
            String cascadeFruizioni = archiviHelper.getParameter("cascadeFruizioni");
            String tipoConfigurazione = archiviHelper.getParameter("tipoDump");
            String protocollo = archiviHelper.getParameter("protocollo");
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            IArchive archiveFactory = protocolFactory.createArchive();
            ArchiveType tipoEsportazione = null;
            tipoEsportazione = tipoConfigurazione != null ? ArchiveType.valueOf((String)tipoConfigurazione) : archiveType;
            String exportMode = archiviHelper.getParameter("tipologiaArchivio");
            List exportModes = archiveFactory.getExportModes(tipoEsportazione);
            ExportMode exportModeObject = null;
            for (ExportMode tmp : exportModes) {
                if (!tmp.equals(exportMode)) continue;
                exportModeObject = tmp;
                break;
            }
            ArchiveCascadeConfiguration cascadeConfig = new ArchiveCascadeConfiguration(false);
            if (ServletUtils.isCheckBoxEnabled((String)cascade)) {
                cascadeConfig = exportModeObject.getCascade();
                if (!archiviCore.isExportArchive_servizi_standard()) {
                    if (cascadePdd != null && !"".equals(cascadePdd)) {
                        cascadeConfig.setCascadePdd(ServletUtils.isCheckBoxEnabled((String)cascadePdd));
                    }
                    if (cascadeGruppi != null && !"".equals(cascadeGruppi)) {
                        cascadeConfig.setCascadeGruppi(ServletUtils.isCheckBoxEnabled((String)cascadeGruppi));
                    }
                    if (cascadeRuoli != null && !"".equals(cascadeRuoli)) {
                        cascadeConfig.setCascadeRuoli(ServletUtils.isCheckBoxEnabled((String)cascadeRuoli));
                    }
                    if (cascadeScope != null && !"".equals(cascadeScope)) {
                        cascadeConfig.setCascadeScope(ServletUtils.isCheckBoxEnabled((String)cascadeScope));
                    }
                    if (cascadeSoggetti != null && !"".equals(cascadeSoggetti)) {
                        cascadeConfig.setCascadeSoggetti(ServletUtils.isCheckBoxEnabled((String)cascadeSoggetti));
                    }
                    if (cascadeServiziApplicativi != null && !"".equals(cascadeServiziApplicativi)) {
                        cascadeConfig.setCascadeServiziApplicativi(ServletUtils.isCheckBoxEnabled((String)cascadeServiziApplicativi));
                    }
                    if (cascadePorteDelegate != null && !"".equals(cascadePorteDelegate)) {
                        cascadeConfig.setCascadePorteDelegate(ServletUtils.isCheckBoxEnabled((String)cascadePorteDelegate));
                    }
                    if (cascadePorteApplicative != null && !"".equals(cascadePorteApplicative)) {
                        cascadeConfig.setCascadePorteApplicative(ServletUtils.isCheckBoxEnabled((String)cascadePorteApplicative));
                    }
                    if (cascadeAccordiCooperazione != null && !"".equals(cascadeAccordiCooperazione)) {
                        cascadeConfig.setCascadeAccordoCooperazione(ServletUtils.isCheckBoxEnabled((String)cascadeAccordiCooperazione));
                    }
                    if (cascadeAccordiServizioParteComune != null && !"".equals(cascadeAccordiServizioParteComune)) {
                        cascadeConfig.setCascadeAccordoServizioParteComune(ServletUtils.isCheckBoxEnabled((String)cascadeAccordiServizioParteComune));
                    }
                    if (cascadeAccordiServizioComposto != null && !"".equals(cascadeAccordiServizioComposto)) {
                        cascadeConfig.setCascadeAccordoServizioComposto(ServletUtils.isCheckBoxEnabled((String)cascadeAccordiServizioComposto));
                    }
                    if (cascadeAccordiServizioParteSpecifica != null && !"".equals(cascadeAccordiServizioParteSpecifica)) {
                        cascadeConfig.setCascadeAccordoServizioParteSpecifica(ServletUtils.isCheckBoxEnabled((String)cascadeAccordiServizioParteSpecifica));
                    }
                    if (cascadeFruizioni != null && !"".equals(cascadeFruizioni)) {
                        cascadeConfig.setCascadeFruizioni(ServletUtils.isCheckBoxEnabled((String)cascadeFruizioni));
                    }
                }
            }
            cascadeConfig.setCascadePolicyConfigurazione(ServletUtils.isCheckBoxEnabled((String)cascadePolicyConfig));
            cascadeConfig.setCascadePluginConfigurazione(ServletUtils.isCheckBoxEnabled((String)cascadePluginConfig));
            ExporterUtils exporterUtils = new ExporterUtils(archiviCore);
            List<Object> identificativi = null;
            switch (archiveType) {
                case SOGGETTO: {
                    identificativi = exporterUtils.getIdsSoggetti(objToExport);
                    redirect = "soggettiList.do";
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                    identificativi = exporterUtils.getIdsAccordiServizioParteComune(objToExport);
                    redirect = "accordiServizioParteComuneList.do?tipoAccordo=apc";
                    break;
                }
                case ACCORDO_SERVIZIO_COMPOSTO: {
                    identificativi = exporterUtils.getIdsAccordiServizioComposti(objToExport);
                    redirect = "accordiServizioParteComuneList.do?tipoAccordo=asc";
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: 
                case EROGAZIONE: 
                case FRUIZIONE: {
                    String tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_tipologiaErogazione");
                    boolean gestioneFruitori = false;
                    if (tipologia != null && "fruizione".equals(tipologia)) {
                        gestioneFruitori = true;
                    }
                    identificativi = exporterUtils.getIdsAccordiServizioParteSpecifica(objToExport, gestioneFruitori);
                    Boolean vistaErogazioni = ServletUtils.getBooleanAttributeFromSession((String)"_tabKey_vistaErogazioni", (HttpSession)session, (HttpServletRequest)request).getValue();
                    if (vistaErogazioni != null && vistaErogazioni.booleanValue()) {
                        redirect = "aspsErogazioniList.do";
                        break;
                    }
                    redirect = "accordiServizioParteSpecificaList.do";
                    break;
                }
                case ACCORDO_COOPERAZIONE: {
                    identificativi = exporterUtils.getIdsAccordiCooperazione(objToExport);
                    redirect = "accordiCooperazioneList.do";
                    break;
                }
                case SERVIZIO_APPLICATIVO: {
                    identificativi = exporterUtils.getIdsServiziApplicativi(objToExport);
                    redirect = "serviziApplicativiList.do";
                    break;
                }
                case GRUPPO: {
                    identificativi = exporterUtils.getIdsGruppi(objToExport);
                    redirect = "gruppiList.do";
                    break;
                }
                case RUOLO: {
                    identificativi = exporterUtils.getIdsRuoli(objToExport);
                    redirect = "ruoliList.do";
                    break;
                }
                case SCOPE: {
                    identificativi = exporterUtils.getIdsScope(objToExport);
                    redirect = "scopeList.do";
                    break;
                }
                case CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIG_POLICY: {
                    identificativi = exporterUtils.getIdsControlloTrafficoConfigPolicy(objToExport);
                    redirect = "configurazioneControlloTrafficoConfigurazionePolicyList.do";
                    break;
                }
                case CONFIGURAZIONE_CONTROLLO_TRAFFICO_ACTIVE_POLICY: {
                    identificativi = exporterUtils.getIdsControlloTrafficoActivePolicy(objToExport);
                    redirect = "configurazioneControlloTrafficoAttivazionePolicyList.do";
                    break;
                }
                case ALLARME: {
                    identificativi = exporterUtils.getIdsAllarmi(objToExport);
                    redirect = "configurazioneAllarmiList.do";
                    break;
                }
                case CONFIGURAZIONE_TOKEN_POLICY: {
                    identificativi = exporterUtils.getIdsTokenPolicy(objToExport);
                    redirect = "configurazionePolicyGestioneTokenList.do?_tabKey_infoType=token";
                    break;
                }
                case CONFIGURAZIONE_ATTRIBUTE_AUTHORITY: {
                    identificativi = exporterUtils.getIdsAttributeAuthority(objToExport);
                    redirect = "configurazionePolicyGestioneTokenList.do?_tabKey_infoType=aa";
                    break;
                }
                case CONFIGURAZIONE_PLUGIN_CLASSE: {
                    identificativi = exporterUtils.getIdsPluginClassi(objToExport);
                    redirect = "configurazionePluginsClassiList.do";
                    break;
                }
                case CONFIGURAZIONE_PLUGIN_ARCHVIO: {
                    identificativi = exporterUtils.getIdsPluginArchivi(objToExport);
                    redirect = "configurazionePluginsArchiviList.do";
                    break;
                }
                case CONFIGURAZIONE_URL_INVOCAZIONE_REGOLA: {
                    identificativi = exporterUtils.getIdsUrlInvocazioneRegole(objToExport);
                    redirect = "configurazioneProxyPassRegolaList.do";
                    break;
                }
                default: {
                    redirect = "messagePage.do";
                }
            }
            Archive archive = archiviCore.readArchiveForExport(userLogin, archiviHelper.smista(), tipoEsportazione, identificativi, cascadeConfig);
            List<String> protocolli = archiviCore.getProtocolli(request, session);
            ArrayList<String> tipiSoggetti = new ArrayList<String>();
            ArrayList<String> tipiServizi = new ArrayList<String>();
            for (String protocolloUtente : protocolli) {
                tipiSoggetti.addAll(soggettiCore.getTipiSoggettiGestitiProtocollo(protocolloUtente));
                tipiServizi.addAll(aspsCore.getTipiServiziGestitiProtocollo(protocolloUtente, null));
            }
            exporterUtils.filterByProtocol(tipiSoggetti, tipiServizi, archive);
            boolean bl = exportFromApi = ArchiveType.ACCORDO_SERVIZIO_PARTE_COMUNE.equals((Object)archiveType) || ArchiveType.ACCORDO_SERVIZIO_COMPOSTO.equals((Object)archiveType);
            if (archiviHelper.isSoggettoMultitenantSelezionato() && !exportFromApi) {
                IDSoggetto idSoggettoSelezionato = archiviCore.convertSoggettoSelezionatoToID(archiviHelper.getSoggettoMultitenantSelezionato());
                exporterUtils.filterBySoggettoSelezionato(idSoggettoSelezionato, archive);
            }
            if ((extSingleArchive = (mappingModeTypeExt = archiveFactory.getExportMappingTypesExtensions(archive, (ArchiveMode)exportModeObject, archiviCore.getRegistryReader(protocolFactory), archiviCore.getConfigIntegrationReader(protocolFactory))).getPreferExtSingleObject()) == null) {
                extSingleArchive = mappingModeTypeExt.mappingArchiveTypeToExt(archiveType);
            }
            if (extSingleArchive == null) {
                extSingleArchive = (String)mappingModeTypeExt.getExtensions().get(0);
            }
            String ext = null;
            if (mappingModeTypeExt.getExtensions().size() == 1 || mappingModeTypeExt.getPreferExtSingleObject() == null) {
                ext = (String)mappingModeTypeExt.getExtensions().get(0);
            } else {
                for (int i = 0; i < mappingModeTypeExt.getExtensions().size(); ++i) {
                    String extTmp = (String)mappingModeTypeExt.getExtensions().get(i);
                    if (extTmp.equals(mappingModeTypeExt.getPreferExtSingleObject())) continue;
                    ext = extTmp;
                    break;
                }
            }
            String prefix = "GovWay";
            String fileName = null;
            switch (archiveType) {
                case SOGGETTO: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "Soggetti." + ext;
                        break;
                    }
                    IDSoggetto idSoggetto = (IDSoggetto)identificativi.get(0);
                    fileName = prefix + "Soggetto_" + idSoggetto.getTipo() + idSoggetto.getNome() + "." + extSingleArchive;
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_COMUNE: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "APIs." + ext;
                        break;
                    }
                    IDAccordo idAccordo = (IDAccordo)identificativi.get(0);
                    fileName = prefix + "API_" + idAccordo.getNome();
                    if (idAccordo.getSoggettoReferente() != null) {
                        fileName = (String)fileName + "_" + idAccordo.getSoggettoReferente().getTipo() + idAccordo.getSoggettoReferente().getNome();
                    }
                    if (idAccordo.getVersione() != null) {
                        fileName = (String)fileName + "_" + idAccordo.getVersione();
                    }
                    fileName = (String)fileName + "." + extSingleArchive;
                    break;
                }
                case ACCORDO_SERVIZIO_COMPOSTO: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "AccordiServizioComposto." + ext;
                        break;
                    }
                    IDAccordo idAccordo = (IDAccordo)identificativi.get(0);
                    fileName = prefix + "AccordiServizioComposto_" + idAccordo.getNome();
                    if (idAccordo.getSoggettoReferente() != null) {
                        fileName = (String)fileName + "_" + idAccordo.getSoggettoReferente().getTipo() + idAccordo.getSoggettoReferente().getNome();
                    }
                    if (idAccordo.getVersione() != null) {
                        fileName = (String)fileName + "_" + idAccordo.getVersione();
                    }
                    fileName = (String)fileName + "." + extSingleArchive;
                    break;
                }
                case ACCORDO_SERVIZIO_PARTE_SPECIFICA: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "Servizi." + ext;
                        break;
                    }
                    IDServizio idServizio = (IDServizio)identificativi.get(0);
                    fileName = prefix + "Servizio_" + idServizio.getTipo() + idServizio.getNome();
                    fileName = (String)fileName + "_" + idServizio.getSoggettoErogatore().getTipo() + idServizio.getSoggettoErogatore().getNome();
                    if (idServizio.getVersione() != null) {
                        fileName = (String)fileName + "_" + idServizio.getVersione();
                    }
                    fileName = (String)fileName + "." + extSingleArchive;
                    break;
                }
                case ACCORDO_COOPERAZIONE: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "AccordiCooperazione." + ext;
                        break;
                    }
                    IDAccordo idAccordo = (IDAccordoCooperazione)identificativi.get(0);
                    fileName = prefix + "AccordiCooperazione_" + idAccordo.getNome();
                    if (idAccordo.getSoggettoReferente() != null) {
                        fileName = (String)fileName + "_" + idAccordo.getSoggettoReferente().getTipo() + idAccordo.getSoggettoReferente().getNome();
                    }
                    if (idAccordo.getVersione() != null) {
                        fileName = (String)fileName + "_" + idAccordo.getVersione();
                    }
                    fileName = (String)fileName + "." + extSingleArchive;
                    break;
                }
                case EROGAZIONE: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "Erogazioni." + ext;
                        break;
                    }
                    IDServizio idServizio = (IDServizio)identificativi.get(0);
                    fileName = prefix + "Erogazione_" + idServizio.getTipo() + idServizio.getNome();
                    fileName = (String)fileName + "_" + idServizio.getSoggettoErogatore().getTipo() + idServizio.getSoggettoErogatore().getNome();
                    if (idServizio.getVersione() != null) {
                        fileName = (String)fileName + "_" + idServizio.getVersione();
                    }
                    fileName = (String)fileName + "." + extSingleArchive;
                    break;
                }
                case FRUIZIONE: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "Fruizioni." + ext;
                        break;
                    }
                    IDFruizione idFruizione = (IDFruizione)identificativi.get(0);
                    IDServizio idServizio = idFruizione.getIdServizio();
                    fileName = prefix + "Fruizione_" + idFruizione.getIdFruitore().getTipo() + idFruizione.getIdFruitore().getNome();
                    fileName = (String)fileName + "_" + idServizio.getTipo() + idServizio.getNome();
                    fileName = (String)fileName + "_" + idServizio.getSoggettoErogatore().getTipo() + idServizio.getSoggettoErogatore().getNome();
                    if (idServizio.getVersione() != null) {
                        fileName = (String)fileName + "_" + idServizio.getVersione();
                    }
                    fileName = (String)fileName + "." + extSingleArchive;
                    break;
                }
                case SERVIZIO_APPLICATIVO: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "Applicativi." + ext;
                        break;
                    }
                    IDServizioApplicativo idServizioApplicativo = (IDServizioApplicativo)identificativi.get(0);
                    fileName = prefix + "Applicativo_" + idServizioApplicativo.getIdSoggettoProprietario().getTipo() + idServizioApplicativo.getIdSoggettoProprietario().getNome() + "_" + idServizioApplicativo.getNome() + "." + extSingleArchive;
                    break;
                }
                case GRUPPO: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "Tags." + ext;
                        break;
                    }
                    IDGruppo idGruppo = (IDGruppo)identificativi.get(0);
                    fileName = prefix + "Tag_" + idGruppo.getNome() + "." + extSingleArchive;
                    break;
                }
                case RUOLO: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "Ruoli." + ext;
                        break;
                    }
                    IDRuolo idRuolo = (IDRuolo)identificativi.get(0);
                    fileName = prefix + "Ruolo_" + idRuolo.getNome() + "." + extSingleArchive;
                    break;
                }
                case SCOPE: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "Scope." + ext;
                        break;
                    }
                    IDScope idScope = (IDScope)identificativi.get(0);
                    fileName = prefix + "Scope_" + idScope.getNome() + "." + extSingleArchive;
                    break;
                }
                case CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIG_POLICY: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "ControlloTrafficoPolicy." + ext;
                        break;
                    }
                    IdPolicy idPolicy = (IdPolicy)identificativi.get(0);
                    fileName = prefix + "ControlloTrafficoPolicy_" + idPolicy.getNome() + "." + extSingleArchive;
                    break;
                }
                case CONFIGURAZIONE_CONTROLLO_TRAFFICO_ACTIVE_POLICY: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "RateLimitingPolicy." + ext;
                        break;
                    }
                    IdActivePolicy idActivePolicy = (IdActivePolicy)identificativi.get(0);
                    fileName = prefix + "RateLimitingPolicy_" + idActivePolicy.getAlias() + "." + extSingleArchive;
                    break;
                }
                case ALLARME: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "Allarmi." + ext;
                        break;
                    }
                    IdAllarme idAllarme = (IdAllarme)identificativi.get(0);
                    fileName = prefix + "Allarme_" + idAllarme.getAlias() + "." + extSingleArchive;
                    break;
                }
                case CONFIGURAZIONE_TOKEN_POLICY: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "TokenPolicy." + ext;
                        break;
                    }
                    IdPolicy idPolicy = (IDGenericProperties)identificativi.get(0);
                    fileName = prefix + "TokenPolicy_" + idPolicy.getTipologia() + "_" + idPolicy.getNome() + "." + extSingleArchive;
                    break;
                }
                case CONFIGURAZIONE_ATTRIBUTE_AUTHORITY: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "AttributeAuthority." + ext;
                        break;
                    }
                    IdPolicy idPolicy = (IDGenericProperties)identificativi.get(0);
                    fileName = prefix + "AttributeAuthority_" + idPolicy.getNome() + "." + extSingleArchive;
                    break;
                }
                case CONFIGURAZIONE_PLUGIN_CLASSE: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "PluginClassi." + ext;
                        break;
                    }
                    Object idPlugin = (IdPlugin)identificativi.get(0);
                    fileName = prefix + "Plugin_" + idPlugin.getTipoPlugin() + "_" + idPlugin.getTipo() + "." + extSingleArchive;
                    break;
                }
                case CONFIGURAZIONE_PLUGIN_ARCHVIO: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "PluginArchivi." + ext;
                        break;
                    }
                    Object idPlugin = (String)identificativi.get(0);
                    fileName = prefix + "ArchivioPlugins_" + (String)idPlugin + "." + extSingleArchive;
                    break;
                }
                case CONFIGURAZIONE_URL_INVOCAZIONE_REGOLA: {
                    if (identificativi == null || identificativi.isEmpty()) {
                        throw new Exception("Identificativi non forniti");
                    }
                    if (identificativi.size() > 1) {
                        fileName = prefix + "RegoleProxyPass." + ext;
                        break;
                    }
                    String idRegola = (String)identificativi.get(0);
                    fileName = prefix + "RegolaProxyPass_" + idRegola + "." + extSingleArchive;
                    break;
                }
                case CONFIGURAZIONE_URL_INVOCAZIONE: {
                    fileName = prefix + "ConfigurazioneUrlInvocazione." + extSingleArchive;
                    break;
                }
                default: {
                    fileName = prefix + "Configurazione." + extSingleArchive;
                }
            }
            HttpUtilities.setOutputFile((HttpServletResponse)response, (boolean)true, (String)fileName);
            ServletOutputStream out = response.getOutputStream();
            out.write(archiviCore.export(userLogin, archiviHelper.smista(), protocollo, archive, (ArchiveMode)exportModeObject));
        }
        catch (Exception e) {
            ControlStationCore.logError("Errore durante l'esportazione dell'archivio: " + e.getMessage(), e);
            if (redirect != null) {
                String msg = e.getMessage();
                redirect = ((String)redirect).contains("?") ? (String)redirect + "&errorExport='" + msg + "'" : (String)redirect + "?errorExport='" + msg + "'";
                redirect = (String)redirect + "&mpText='" + msg + "'";
                redirect = (String)redirect + "&mpBC=Esporta";
                try {
                    response.sendRedirect((String)redirect);
                }
                catch (Throwable t) {
                    ControlStationCore.logError("Errore durante l'esportazione dell'archivio (redirect:" + (String)redirect + "): " + t.getMessage(), t);
                }
            }
            try {
                response.sendRedirect("messagePage.do");
            }
            catch (Throwable t) {
                ControlStationCore.logError("Errore durante l'esportazione dell'archivio (redirect:messagePage.do): " + t.getMessage(), t);
            }
        }
    }
}

