/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAzione;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAzione;
import org.openspcoop2.core.config.RispostaAsincrona;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.InvocazioneServizioTipoAutenticazione;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.PortaDelegataAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.constants.TipologiaErogazione;
import org.openspcoop2.core.config.constants.TipologiaFruizione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.id.IdentificativiFruizione;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.ConfigurazioneServizioAzione;
import org.openspcoop2.core.registry.Connettore;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.PortTypeSintetico;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.registry.driver.db.IDAccordoDB;
import org.openspcoop2.monitor.engine.alarm.AlarmEngineConfig;
import org.openspcoop2.monitor.engine.alarm.utils.AllarmiUtils;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.DBOggettiInUsoUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.config.ProtocolImplementation;
import org.openspcoop2.protocol.sdk.config.ProtocolSubscription;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedConnettore;
import org.openspcoop2.web.ctrlstat.plugins.IExtendedBean;
import org.openspcoop2.web.ctrlstat.plugins.IExtendedListServlet;
import org.openspcoop2.web.ctrlstat.plugins.WrapperExtendedBean;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaFruitoriPorteDelegateMappingInfo;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaPorteApplicativeMappingInfo;
import org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni.ErogazioniHelper;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoreStatusParams;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.slf4j.Logger;

public class AccordiServizioParteSpecificaUtilities {
    private AccordiServizioParteSpecificaUtilities() {
    }

    public static boolean[] getPermessiUtente(AccordiServizioParteSpecificaHelper apsHelper) {
        PermessiUtente pu = null;
        if (apsHelper.getCore().isUsedByApi()) {
            pu = new PermessiUtente();
            pu.setServizi(true);
            pu.setAccordiCooperazione(false);
        } else {
            pu = ServletUtils.getUserFromSession((HttpServletRequest)apsHelper.getRequest(), (HttpSession)apsHelper.getSession()).getPermessi();
        }
        boolean[] permessi = new boolean[]{pu.isServizi(), pu.isAccordiCooperazione()};
        return permessi;
    }

    public static List<AccordoServizioParteComuneSintetico> getListaAPI(String tipoProtocollo, String userLogin, AccordiServizioParteSpecificaCore apsCore, AccordiServizioParteSpecificaHelper apsHelper) throws Exception {
        AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(apsCore);
        ConsoleSearch searchAccordi = new ConsoleSearch(true);
        searchAccordi.addFilter(Liste.ACCORDI, "filtroProtocollo", tipoProtocollo);
        List<AccordoServizioParteComuneSintetico> listaTmp = AccordiServizioParteComuneUtilities.accordiListFromPermessiUtente(apcCore, userLogin, searchAccordi, AccordiServizioParteSpecificaUtilities.getPermessiUtente(apsHelper));
        List<AccordoServizioParteComuneSintetico> listaAPI = null;
        if (apsHelper.isModalitaCompleta()) {
            listaAPI = listaTmp;
        } else {
            listaAPI = new ArrayList<AccordoServizioParteComuneSintetico>();
            for (AccordoServizioParteComuneSintetico accordoServizioParteComune : listaTmp) {
                if (ServiceBinding.REST.equals((Object)accordoServizioParteComune.getServiceBinding())) {
                    if (accordoServizioParteComune.getResource().isEmpty()) continue;
                    listaAPI.add(accordoServizioParteComune);
                    continue;
                }
                boolean ptValido = false;
                for (PortTypeSintetico pt : accordoServizioParteComune.getPortType()) {
                    if (pt.getAzione().isEmpty()) continue;
                    ptValido = true;
                    break;
                }
                if (!ptValido) continue;
                listaAPI.add(accordoServizioParteComune);
            }
        }
        return listaAPI;
    }

    public static List<IDAccordoDB> getListaIdAPI(String tipoProtocollo, String userLogin, AccordiServizioParteSpecificaCore apsCore, AccordiServizioParteSpecificaHelper apsHelper) throws DriverControlStationException, DriverRegistroServiziException {
        AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(apsCore);
        boolean soloAccordiConsistentiRest = false;
        boolean soloAccordiConsistentiSoap = false;
        if (!apsHelper.isModalitaCompleta()) {
            soloAccordiConsistentiRest = true;
            soloAccordiConsistentiSoap = true;
        }
        ConsoleSearch searchAccordi = new ConsoleSearch(true);
        searchAccordi.addFilter(Liste.ACCORDI, "filtroProtocollo", tipoProtocollo);
        return AccordiServizioParteComuneUtilities.idAccordiListFromPermessiUtente(apcCore, userLogin, searchAccordi, AccordiServizioParteSpecificaUtilities.getPermessiUtente(apsHelper), soloAccordiConsistentiRest, soloAccordiConsistentiSoap);
    }

    public static List<PortTypeSintetico> getListaPortTypes(AccordoServizioParteComuneSintetico as, AccordiServizioParteSpecificaHelper apsHelper) {
        ArrayList<PortTypeSintetico> portTypesTmp = as.getPortType();
        ArrayList<PortTypeSintetico> portTypes = null;
        if (apsHelper.isModalitaCompleta()) {
            portTypes = portTypesTmp;
        } else {
            portTypes = new ArrayList<PortTypeSintetico>();
            for (PortTypeSintetico portType : portTypesTmp) {
                if (portType.getAzione().isEmpty()) continue;
                portTypes.add(portType);
            }
        }
        return portTypes;
    }

    public static boolean isSoggettoOperativo(IDSoggetto idSoggettoErogatore, AccordiServizioParteSpecificaCore apsCore) throws DriverControlStationException, DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverControlStationNotFound {
        PddCore pddCore = new PddCore(apsCore);
        SoggettiCore soggettiCore = new SoggettiCore(apsCore);
        Soggetto soggetto = soggettiCore.getSoggettoRegistro(idSoggettoErogatore);
        return !pddCore.isPddEsterna(soggetto.getPortaDominio());
    }

    public static void create(AccordoServizioParteSpecifica asps, boolean alreadyExists, IDServizio idServizio, IDSoggetto idFruitore, String tipoProtocollo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, long idProv, Connettore connettore, boolean generaPortaApplicativa, boolean generaPortaDelegata, String autenticazione, String autenticazioneOpzionale, TipoAutenticazionePrincipal autenticazionePrincipal, List<String> autenticazioneParametroList, String autorizzazione, String autorizzazioneAutenticati, String autorizzazioneRuoli, String autorizzazioneRuoliTipologia, String autorizzazioneRuoliMatch, String servizioApplicativo, String ruolo, String soggettoAutenticato, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken, String autorizzazioneTokenOptions, String autorizzazioneScope, String scope, String autorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String gestioneToken, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, ProtocolProperties protocolProperties, ConsoleOperationType consoleOperationType, AccordiServizioParteSpecificaCore apsCore, ErogazioniHelper apsHelper, String nomeSAServer, String canaleStato, String canale, boolean gestioneCanaliEnabled, String identificazioneAttributiStato, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi) throws DriverControlStationException, ProtocolException, DriverConfigurazioneException, DriverConfigurazioneNotFound, DriverRegistroServiziNotFound, DriverRegistroServiziException, ControlStationCoreException, UtilsException {
        if (asps == null) {
            throw new DriverControlStationException("Param asps is null");
        }
        ArrayList<Object> listaOggettiDaCreare = new ArrayList<Object>();
        if (!alreadyExists) {
            listaOggettiDaCreare.add(asps);
        }
        if (generaPortaApplicativa) {
            AccordiServizioParteSpecificaUtilities.generaPortaApplicativa(listaOggettiDaCreare, idServizio, tipoProtocollo, serviceBinding, idProv, connettore, autenticazione, autenticazioneOpzionale, autenticazionePrincipal, autenticazioneParametroList, autorizzazione, autorizzazioneAutenticati, autorizzazioneRuoli, autorizzazioneRuoliTipologia, autorizzazioneRuoliMatch, servizioApplicativo, ruolo, soggettoAutenticato, autorizzazioneAutenticatiToken, autorizzazioneRuoliToken, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken, autorizzazioneTokenOptions, autorizzazioneScope, scope, autorizzazioneScopeMatch, allegatoXacmlPolicy, gestioneToken, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, apsCore, apsHelper, nomeSAServer, canaleStato, canale, gestioneCanaliEnabled, identificazioneAttributiStato, attributeAuthoritySelezionate, attributeAuthorityAttributi);
        }
        if (generaPortaDelegata) {
            AccordiServizioParteSpecificaUtilities.generaPortaDelegata(listaOggettiDaCreare, idFruitore, idServizio, tipoProtocollo, serviceBinding, idProv, autenticazione, autenticazioneOpzionale, autenticazionePrincipal, autenticazioneParametroList, autorizzazione, autorizzazioneAutenticati, autorizzazioneRuoli, autorizzazioneRuoliTipologia, autorizzazioneRuoliMatch, servizioApplicativo, ruolo, autorizzazioneAutenticatiToken, autorizzazioneRuoliToken, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken, autorizzazioneTokenOptions, autorizzazioneScope, scope, autorizzazioneScopeMatch, allegatoXacmlPolicy, gestioneToken, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, apsCore, canaleStato, canale, gestioneCanaliEnabled, identificazioneAttributiStato, attributeAuthoritySelezionate, attributeAuthorityAttributi);
        }
        if (generaPortaDelegata) {
            for (Fruitore fruitore : asps.getFruitoreList()) {
                if (!fruitore.getTipo().equals(idFruitore.getTipo()) || !fruitore.getNome().equals(idFruitore.getNome())) continue;
                fruitore.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)consoleOperationType, null));
            }
        } else {
            asps.setProtocolPropertyList(ProtocolPropertiesUtils.toProtocolPropertiesRegistry((ProtocolProperties)protocolProperties, (ConsoleOperationType)consoleOperationType, null));
        }
        if (alreadyExists) {
            apsCore.performUpdateOperation(asps.getSuperUser(), apsHelper.smista(), asps);
        }
        apsCore.performCreateOperation(asps.getSuperUser(), apsHelper.smista(), listaOggettiDaCreare.toArray());
    }

    public static void generaPortaApplicativa(List<Object> listaOggettiDaCreare, IDServizio idServizio, String tipoProtocollo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, long idProv, Connettore connettore, String erogazioneAutenticazione, String erogazioneAutenticazioneOpzionale, TipoAutenticazionePrincipal erogazioneAutenticazionePrincipal, List<String> erogazioneAutenticazioneParametroList, String erogazioneAutorizzazione, String erogazioneAutorizzazioneAutenticati, String erogazioneAutorizzazioneRuoli, String erogazioneAutorizzazioneRuoliTipologia, String erogazioneAutorizzazioneRuoliMatch, String nomeSA, String erogazioneRuolo, String erogazioneSoggettoAutenticato, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken, String autorizzazioneTokenOptions, String autorizzazioneScope, String scope, String autorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String gestioneToken, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, AccordiServizioParteSpecificaCore apsCore, ErogazioniHelper apsHelper, String nomeSAServer, String canaleStato, String canale, boolean gestioneCanaliEnabled, String identificazioneAttributiStato, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi) throws DriverControlStationException, ProtocolException {
        String[] splitSoggetto;
        PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(apsCore);
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo);
        ProtocolImplementation implementationDefault = protocolFactory.createProtocolIntegrationConfiguration().createDefaultImplementation(serviceBinding, idServizio);
        PortaApplicativa portaApplicativa = implementationDefault.getPortaApplicativa();
        MappingErogazionePortaApplicativa mappingErogazione = implementationDefault.getMapping();
        portaApplicativa.setIdSoggetto(Long.valueOf(idProv));
        IDSoggetto idSoggettoAutenticatoErogazione = null;
        if (erogazioneSoggettoAutenticato != null && !"".equals(erogazioneSoggettoAutenticato) && !"-".equals(erogazioneSoggettoAutenticato) && (splitSoggetto = erogazioneSoggettoAutenticato.split("/")) != null) {
            idSoggettoAutenticatoErogazione = new IDSoggetto();
            if (splitSoggetto.length == 2) {
                idSoggettoAutenticatoErogazione.setTipo(splitSoggetto[0]);
                idSoggettoAutenticatoErogazione.setNome(splitSoggetto[1]);
            } else {
                idSoggettoAutenticatoErogazione.setNome(splitSoggetto[0]);
            }
        }
        String nomeServizioApplicativoErogatore = nomeSA;
        ServizioApplicativo sa = null;
        if (!apsHelper.isModalitaCompleta()) {
            nomeServizioApplicativoErogatore = portaApplicativa.getNome();
            sa = new ServizioApplicativo();
            sa.setNome(nomeServizioApplicativoErogatore);
            sa.setTipologiaFruizione(TipologiaFruizione.DISABILITATO.getValue());
            sa.setTipologiaErogazione(TipologiaErogazione.TRASPARENTE.getValue());
            sa.setIdSoggetto(Long.valueOf(idProv));
            sa.setTipoSoggettoProprietario(portaApplicativa.getTipoSoggettoProprietario());
            sa.setNomeSoggettoProprietario(portaApplicativa.getNomeSoggettoProprietario());
            RispostaAsincrona rispostaAsinc = new RispostaAsincrona();
            rispostaAsinc.setAutenticazione(InvocazioneServizioTipoAutenticazione.NONE);
            rispostaAsinc.setGetMessage(CostantiConfigurazione.DISABILITATO);
            sa.setRispostaAsincrona(rispostaAsinc);
            InvocazioneServizio invServizio = new InvocazioneServizio();
            String user = null;
            String password = null;
            if (connettore.sizePropertyList() > 0) {
                for (int i = 0; i < connettore.sizePropertyList(); ++i) {
                    if ("user".equals(connettore.getProperty(i).getNome())) {
                        user = connettore.getProperty(i).getValore();
                        continue;
                    }
                    if (!"password".equals(connettore.getProperty(i).getNome())) continue;
                    password = connettore.getProperty(i).getValore();
                }
            }
            if (user != null) {
                invServizio.setAutenticazione(InvocazioneServizioTipoAutenticazione.BASIC);
                InvocazioneCredenziali credenziali = new InvocazioneCredenziali();
                credenziali.setUser(user);
                credenziali.setPassword(password);
                invServizio.setCredenziali(credenziali);
            } else {
                invServizio.setAutenticazione(InvocazioneServizioTipoAutenticazione.NONE);
            }
            invServizio.setGetMessage(CostantiConfigurazione.DISABILITATO);
            invServizio.setConnettore(connettore.mappingIntoConnettoreConfigurazione());
            sa.setInvocazioneServizio(invServizio);
            listaOggettiDaCreare.add(sa);
        }
        if (StringUtils.isNotEmpty((CharSequence)nomeSAServer)) {
            portaApplicativa.setServizioApplicativoDefault(nomeServizioApplicativoErogatore);
            nomeServizioApplicativoErogatore = nomeSAServer;
        }
        porteApplicativeCore.configureControlloAccessiPortaApplicativa(portaApplicativa, erogazioneAutenticazione, erogazioneAutenticazioneOpzionale, erogazioneAutenticazionePrincipal, erogazioneAutenticazioneParametroList, erogazioneAutorizzazione, erogazioneAutorizzazioneAutenticati, erogazioneAutorizzazioneRuoli, erogazioneAutorizzazioneRuoliTipologia, erogazioneAutorizzazioneRuoliMatch, nomeServizioApplicativoErogatore, erogazioneRuolo, idSoggettoAutenticatoErogazione, autorizzazioneAutenticatiToken, autorizzazioneRuoliToken, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken, autorizzazioneTokenOptions, autorizzazioneScope, scope, autorizzazioneScopeMatch, allegatoXacmlPolicy, identificazioneAttributiStato, attributeAuthoritySelezionate, attributeAuthorityAttributi);
        porteApplicativeCore.configureControlloAccessiGestioneToken(portaApplicativa, gestioneToken, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, autorizzazioneTokenOptions);
        if (gestioneCanaliEnabled) {
            if ("ridefinito".equals(canaleStato)) {
                portaApplicativa.setCanale(canale);
            } else {
                portaApplicativa.setCanale(null);
            }
        } else {
            portaApplicativa.setCanale(null);
        }
        listaOggettiDaCreare.add(portaApplicativa);
        listaOggettiDaCreare.add(mappingErogazione);
    }

    public static void generaPortaDelegata(List<Object> listaOggettiDaCreare, IDSoggetto idFruitore, IDServizio idServizio, String tipoProtocollo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, long idProv, String fruizioneAutenticazione, String fruizioneAutenticazioneOpzionale, TipoAutenticazionePrincipal fruizioneAutenticazionePrincipal, List<String> fruizioneAutenticazioneParametroList, String fruizioneAutorizzazione, String fruizioneAutorizzazioneAutenticati, String fruizioneAutorizzazioneRuoli, String fruizioneAutorizzazioneRuoliTipologia, String fruizioneAutorizzazioneRuoliMatch, String fruizioneServizioApplicativo, String fruizioneRuolo, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken, String autorizzazioneTokenOptions, String autorizzazioneScope, String scope, String autorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String gestioneToken, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, AccordiServizioParteSpecificaCore apsCore, String canaleStato, String canale, boolean gestioneCanaliEnabled, String identificazioneAttributiStato, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi) throws DriverControlStationException, ProtocolException, DriverConfigurazioneException {
        PorteDelegateCore porteDelegateCore = new PorteDelegateCore(apsCore);
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(tipoProtocollo);
        ProtocolSubscription subscriptionDefault = protocolFactory.createProtocolIntegrationConfiguration().createDefaultSubscription(serviceBinding, idFruitore, idServizio);
        PortaDelegata portaDelegata = subscriptionDefault.getPortaDelegata();
        MappingFruizionePortaDelegata mappingFruizione = subscriptionDefault.getMapping();
        portaDelegata.setIdSoggetto(Long.valueOf(idProv));
        porteDelegateCore.configureControlloAccessiPortaDelegata(portaDelegata, fruizioneAutenticazione, fruizioneAutenticazioneOpzionale, fruizioneAutenticazionePrincipal, fruizioneAutenticazioneParametroList, fruizioneAutorizzazione, fruizioneAutorizzazioneAutenticati, fruizioneAutorizzazioneRuoli, fruizioneAutorizzazioneRuoliTipologia, fruizioneAutorizzazioneRuoliMatch, fruizioneServizioApplicativo, fruizioneRuolo, autorizzazioneAutenticatiToken, autorizzazioneRuoliToken, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken, autorizzazioneTokenOptions, autorizzazioneScope, scope, autorizzazioneScopeMatch, allegatoXacmlPolicy, identificazioneAttributiStato, attributeAuthoritySelezionate, attributeAuthorityAttributi);
        porteDelegateCore.configureControlloAccessiGestioneToken(portaDelegata, gestioneToken, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, autorizzazioneTokenOptions);
        if (gestioneCanaliEnabled) {
            if ("ridefinito".equals(canaleStato)) {
                portaDelegata.setCanale(canale);
            } else {
                portaDelegata.setCanale(null);
            }
        } else {
            portaDelegata.setCanale(null);
        }
        if (!porteDelegateCore.existsPortaDelegata(mappingFruizione.getIdPortaDelegata())) {
            listaOggettiDaCreare.add(portaDelegata);
        }
        listaOggettiDaCreare.add(mappingFruizione);
    }

    public static List<Object> getOggettiDaAggiornare(AccordoServizioParteSpecifica asps, AccordiServizioParteSpecificaCore apsCore) throws Exception {
        ConsoleSearch ricercaPolicies;
        Object idServizioOLD;
        String oldUri;
        PorteDelegateCore porteDelegateCore = new PorteDelegateCore(apsCore);
        PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(apsCore);
        ServiziApplicativiCore saCore = new ServiziApplicativiCore(apsCore);
        AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(apsCore);
        ConfigurazioneCore confCore = new ConfigurazioneCore(apcCore);
        ArrayList<PortaDelegata> listaPD = new ArrayList<PortaDelegata>();
        ArrayList<PortaApplicativa> listaPA = new ArrayList<PortaApplicativa>();
        ArrayList<ServizioApplicativo> listaPASA = new ArrayList<ServizioApplicativo>();
        HashMap<String, AttivazionePolicy> listaPolicyDaAggiornare = new HashMap<String, AttivazionePolicy>();
        HashMap<String, ConfigurazioneAllarmeBean> listaAllarmiDaAggiornare = new HashMap<String, ConfigurazioneAllarmeBean>();
        String newUri = IDServizioFactory.getInstance().getUriFromAccordo(asps);
        if (!newUri.equals(oldUri = IDServizioFactory.getInstance().getUriFromIDServizio(asps.getOldIDServizioForUpdate()))) {
            FiltroRicercaPorteDelegate filtroPD = new FiltroRicercaPorteDelegate();
            filtroPD.setTipoSoggettoErogatore(asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo());
            filtroPD.setNomeSoggettoErogatore(asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome());
            filtroPD.setTipoServizio(asps.getOldIDServizioForUpdate().getTipo());
            filtroPD.setNomeServizio(asps.getOldIDServizioForUpdate().getNome());
            filtroPD.setVersioneServizio(asps.getOldIDServizioForUpdate().getVersione());
            List<IDPortaDelegata> listIdsPorteDelegate = porteDelegateCore.getAllIdPorteDelegate(filtroPD);
            if (listIdsPorteDelegate != null && !listIdsPorteDelegate.isEmpty()) {
                String tmpLocationSuffix = "/" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo() + "_" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome() + "/" + asps.getOldIDServizioForUpdate().getTipo() + "_" + asps.getOldIDServizioForUpdate().getNome();
                String locationSuffix = tmpLocationSuffix + "/v" + asps.getOldIDServizioForUpdate().getVersione();
                String locationSuffixOldWithoutV = tmpLocationSuffix + "/" + asps.getOldIDServizioForUpdate().getVersione();
                String newLocationSuffix = "/" + asps.getTipoSoggettoErogatore() + "_" + asps.getNomeSoggettoErogatore() + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione();
                Iterator iterator = listIdsPorteDelegate.iterator();
                while (iterator.hasNext()) {
                    IDPortaDelegata idPortaDelegata = (IDPortaDelegata)iterator.next();
                    PortaDelegata tmpPorta = porteDelegateCore.getPortaDelegata(idPortaDelegata);
                    tmpPorta.getSoggettoErogatore().setTipo(asps.getTipoSoggettoErogatore());
                    tmpPorta.getSoggettoErogatore().setNome(asps.getNomeSoggettoErogatore());
                    tmpPorta.getServizio().setTipo(asps.getTipo());
                    tmpPorta.getServizio().setNome(asps.getNome());
                    tmpPorta.getServizio().setVersione(asps.getVersione());
                    String locationPrefix = tmpPorta.getTipoSoggettoProprietario() + "_" + tmpPorta.getNomeSoggettoProprietario();
                    String check1 = (String)locationPrefix + locationSuffix;
                    String check2 = "__" + (String)locationPrefix + locationSuffix;
                    String check1oldWithoutV = (String)locationPrefix + locationSuffixOldWithoutV;
                    String check2oldWithoutV = "__" + (String)locationPrefix + locationSuffixOldWithoutV;
                    String parteRimanente = "";
                    String nuovoNome = null;
                    boolean match = false;
                    if (tmpPorta.getNome().equals(check1) || tmpPorta.getNome().equals(check1oldWithoutV)) {
                        match = true;
                        nuovoNome = (String)locationPrefix + newLocationSuffix;
                    } else if (tmpPorta.getNome().startsWith(check2)) {
                        match = true;
                        parteRimanente = tmpPorta.getNome().substring(check2.length());
                        nuovoNome = "__" + (String)locationPrefix + newLocationSuffix + parteRimanente;
                    } else if (tmpPorta.getNome().startsWith(check2oldWithoutV)) {
                        match = true;
                        parteRimanente = tmpPorta.getNome().substring(check2oldWithoutV.length());
                        nuovoNome = "__" + (String)locationPrefix + newLocationSuffix + parteRimanente;
                    }
                    if (match) {
                        PortaDelegataAzione pdAzione;
                        IDPortaDelegata oldIDPortaDelegataForUpdate = new IDPortaDelegata();
                        oldIDPortaDelegataForUpdate.setNome(tmpPorta.getNome());
                        tmpPorta.setOldIDPortaDelegataForUpdate(oldIDPortaDelegataForUpdate);
                        tmpPorta.setNome(nuovoNome);
                        String descrizionePD = tmpPorta.getDescrizione();
                        if (descrizionePD != null && !descrizionePD.equals("")) {
                            String soggettoOldCaso1 = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo() + "/" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome();
                            String soggettoNewCaso1 = asps.getTipoSoggettoErogatore() + "/" + asps.getNomeSoggettoErogatore();
                            String matchCaso = soggettoOldCaso1 + ":" + asps.getOldIDServizioForUpdate().getTipo() + "/" + asps.getOldIDServizioForUpdate().getNome() + ":" + asps.getOldIDServizioForUpdate().getVersione();
                            if (descrizionePD.endsWith(matchCaso)) {
                                String replaceCaso = soggettoNewCaso1 + ":" + asps.getTipo() + "/" + asps.getNome() + ":" + asps.getVersione();
                                descrizionePD = descrizionePD.replace(matchCaso, replaceCaso);
                            }
                            String soggettoOldCaso2 = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo() + "_" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome();
                            String soggettoNewCaso2 = asps.getTipoSoggettoErogatore() + "_" + asps.getNomeSoggettoErogatore();
                            String tmpMatchCaso2 = soggettoOldCaso2 + "/" + asps.getOldIDServizioForUpdate().getTipo() + "_" + asps.getOldIDServizioForUpdate().getNome() + "/";
                            String matchCaso2 = tmpMatchCaso2 + "v" + asps.getOldIDServizioForUpdate().getVersione();
                            String matchCaso2oldWithoutV = tmpMatchCaso2 + asps.getOldIDServizioForUpdate().getVersione();
                            if (descrizionePD.contains(matchCaso2)) {
                                String replaceCaso2 = soggettoNewCaso2 + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione();
                                descrizionePD = descrizionePD.replace(matchCaso2, replaceCaso2);
                            } else if (descrizionePD.contains(matchCaso2oldWithoutV)) {
                                String replaceCaso2 = soggettoNewCaso2 + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione();
                                descrizionePD = descrizionePD.replace(matchCaso2oldWithoutV, replaceCaso2);
                            }
                            tmpPorta.setDescrizione(descrizionePD);
                        }
                        PortaDelegataAzioneIdentificazione identificazione = (pdAzione = tmpPorta.getAzione()) != null ? pdAzione.getIdentificazione() : null;
                        String patterAzione = "";
                        if (pdAzione != null) {
                            patterAzione = pdAzione.getPattern() != null ? pdAzione.getPattern() : "";
                        }
                        String patternAzionePrefixOld = ".*/";
                        String patternAzioneSuffix1Old = "/([^/|^?]*).*";
                        String patternAzionePrefixNew = "/";
                        String patternAzioneSuffix1New = "/([^/?]*).*";
                        if (PortaDelegataAzioneIdentificazione.URL_BASED.equals((Object)identificazione)) {
                            String regex;
                            int endidx;
                            int startidx;
                            String tmpPat;
                            boolean newPattern;
                            boolean oldPattern = patterAzione.startsWith(patternAzionePrefixOld) && patterAzione.endsWith(patternAzioneSuffix1Old);
                            boolean bl = newPattern = patterAzione.startsWith(patternAzionePrefixNew) && patterAzione.endsWith(patternAzioneSuffix1New);
                            if ((oldPattern || newPattern) && (tmpPat = patterAzione.substring(startidx = oldPattern ? patternAzionePrefixOld.length() : patternAzionePrefixNew.length(), endidx = oldPattern ? patterAzione.lastIndexOf(patternAzioneSuffix1Old) : patterAzione.lastIndexOf(patternAzioneSuffix1New))).matches(regex = "(.*)\\/(.*)\\/(.*)\\/(.*)")) {
                                String[] val = tmpPat.split("/");
                                String partFruitore = val[0];
                                Object partErogatore = val[1];
                                Object partServizio = val[2];
                                Object partVersione = val[3];
                                String rimanenteRegExp = "";
                                int lengthParteRimanenteRegExp = (partFruitore + "/" + (String)partErogatore + "/" + (String)partServizio + "/" + (String)partVersione).length();
                                if (tmpPat.length() > lengthParteRimanenteRegExp) {
                                    rimanenteRegExp = tmpPat.substring(lengthParteRimanenteRegExp);
                                }
                                boolean matchURL = false;
                                String partErogatoreOld = "(?:" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo() + "_)?" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome();
                                String partErogatoreNew = "(?:" + asps.getTipoSoggettoErogatore() + "_)?" + asps.getNomeSoggettoErogatore();
                                if (((String)partErogatore).equals(partErogatoreOld)) {
                                    partErogatore = partErogatoreNew;
                                    matchURL = true;
                                }
                                String partServizioOld = "(?:" + asps.getOldIDServizioForUpdate().getTipo() + "_)?" + asps.getOldIDServizioForUpdate().getNome();
                                String partServizioNew = "(?:" + asps.getTipo() + "_)?" + asps.getNome();
                                if (((String)partServizio).equals(partServizioOld)) {
                                    partServizio = partServizioNew;
                                    matchURL = true;
                                }
                                String versioneOld = "v" + asps.getOldIDServizioForUpdate().getVersione();
                                String versioneOldOldWithoutV = "" + asps.getOldIDServizioForUpdate().getVersione();
                                if (((String)partVersione).equals(versioneOld) || ((String)partVersione).equals(versioneOldOldWithoutV)) {
                                    partVersione = "v" + asps.getVersione();
                                    matchURL = true;
                                }
                                if (matchURL) {
                                    String newPatternAzione = patternAzionePrefixNew + partFruitore + "/" + (String)partErogatore + "/" + (String)partServizio + "/" + (String)partVersione + rimanenteRegExp + patternAzioneSuffix1New;
                                    pdAzione.setPattern(newPatternAzione);
                                    tmpPorta.setAzione(pdAzione);
                                }
                            }
                        }
                        String nomePortaDelegante = null;
                        if (pdAzione != null) {
                            String string = nomePortaDelegante = pdAzione.getNomePortaDelegante() != null ? pdAzione.getNomePortaDelegante() : null;
                        }
                        if (PortaDelegataAzioneIdentificazione.DELEGATED_BY.equals((Object)identificazione) && nomePortaDelegante != null) {
                            String nuovoNomeDelegate = null;
                            boolean matchDelegate = false;
                            if (nomePortaDelegante.equals(check1) || nomePortaDelegante.equals(check1oldWithoutV)) {
                                matchDelegate = true;
                                nuovoNomeDelegate = (String)locationPrefix + newLocationSuffix;
                            }
                            if (matchDelegate) {
                                tmpPorta.getAzione().setNomePortaDelegante(nuovoNomeDelegate);
                            }
                        }
                        if (tmpPorta.getOldIDPortaDelegataForUpdate() != null && tmpPorta.getOldIDPortaDelegataForUpdate().getNome() != null) {
                            ConsoleSearch ricercaPolicies2 = new ConsoleSearch(true);
                            List<AttivazionePolicy> listaPolicies = null;
                            try {
                                listaPolicies = confCore.attivazionePolicyList(ricercaPolicies2, RuoloPolicy.DELEGATA, tmpPorta.getOldIDPortaDelegataForUpdate().getNome());
                            }
                            catch (Exception endidx) {
                                // empty catch block
                            }
                            if (listaPolicies != null && !listaPolicies.isEmpty()) {
                                for (AttivazionePolicy ap : listaPolicies) {
                                    if (ap.getFiltro() == null || !tmpPorta.getOldIDPortaDelegataForUpdate().getNome().equals(ap.getFiltro().getNomePorta())) continue;
                                    ap.getFiltro().setNomePorta(tmpPorta.getNome());
                                    listaPolicyDaAggiornare.put(ap.getIdActivePolicy(), ap);
                                }
                            }
                        }
                        if (confCore.isConfigurazioneAllarmiEnabled() && tmpPorta.getOldIDPortaDelegataForUpdate() != null && tmpPorta.getOldIDPortaDelegataForUpdate().getNome() != null) {
                            ConsoleSearch ricercaPolicies3 = new ConsoleSearch(true);
                            List<ConfigurazioneAllarmeBean> listaAllarmi = null;
                            try {
                                listaAllarmi = confCore.allarmiList(ricercaPolicies3, RuoloPorta.DELEGATA, tmpPorta.getOldIDPortaDelegataForUpdate().getNome());
                            }
                            catch (Exception endidx) {
                                // empty catch block
                            }
                            if (listaAllarmi != null && !listaAllarmi.isEmpty()) {
                                for (ConfigurazioneAllarmeBean allarme : listaAllarmi) {
                                    if (allarme.getFiltro() == null || !tmpPorta.getOldIDPortaDelegataForUpdate().getNome().equals(allarme.getFiltro().getNomePorta())) continue;
                                    allarme.getFiltro().setNomePorta(tmpPorta.getNome());
                                    listaAllarmiDaAggiornare.put(allarme.getNome(), allarme);
                                }
                            }
                        }
                    }
                    listaPD.add(tmpPorta);
                }
            }
            FiltroRicercaPorteApplicative filtroPA = new FiltroRicercaPorteApplicative();
            filtroPA.setTipoSoggetto(asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo());
            filtroPA.setNomeSoggetto(asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome());
            filtroPA.setTipoServizio(asps.getOldIDServizioForUpdate().getTipo());
            filtroPA.setNomeServizio(asps.getOldIDServizioForUpdate().getNome());
            filtroPA.setVersioneServizio(asps.getOldIDServizioForUpdate().getVersione());
            List<IDPortaApplicativa> listIdsPorteApplicative = porteApplicativeCore.getAllIdPorteApplicative(filtroPA);
            HashMap<String, String> mapOldToNewSaName = new HashMap<String, String>();
            if (listIdsPorteApplicative != null && !listIdsPorteApplicative.isEmpty()) {
                String tmpLocationSuffix = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo() + "_" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome() + "/" + asps.getOldIDServizioForUpdate().getTipo() + "_" + asps.getOldIDServizioForUpdate().getNome();
                String locationSuffix = (String)tmpLocationSuffix + "/v" + asps.getOldIDServizioForUpdate().getVersione();
                String locationSuffixOldWithoutV = (String)tmpLocationSuffix + "/" + asps.getOldIDServizioForUpdate().getVersione();
                String newLocationSuffix = asps.getTipoSoggettoErogatore() + "_" + asps.getNomeSoggettoErogatore() + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione();
                for (IDPortaApplicativa idPortaApplicativa : listIdsPorteApplicative) {
                    PortaApplicativa tmpPorta = porteApplicativeCore.getPortaApplicativa(idPortaApplicativa);
                    tmpPorta.setTipoSoggettoProprietario(asps.getTipoSoggettoErogatore());
                    tmpPorta.setNomeSoggettoProprietario(asps.getNomeSoggettoErogatore());
                    tmpPorta.getServizio().setTipo(asps.getTipo());
                    tmpPorta.getServizio().setNome(asps.getNome());
                    tmpPorta.getServizio().setVersione(asps.getVersione());
                    String check1 = locationSuffix;
                    String check2 = "__" + locationSuffix;
                    String check1oldWithoutV = locationSuffixOldWithoutV;
                    String check2oldWithoutV = "__" + (String)locationSuffixOldWithoutV;
                    String parteRimanente = "";
                    String nuovoNome = null;
                    boolean match = false;
                    if (tmpPorta.getNome().equals(check1) || tmpPorta.getNome().equals(check1oldWithoutV)) {
                        match = true;
                        nuovoNome = newLocationSuffix;
                    } else if (tmpPorta.getNome().startsWith(check2)) {
                        match = true;
                        parteRimanente = tmpPorta.getNome().substring(check2.length());
                        nuovoNome = "__" + newLocationSuffix + parteRimanente;
                    } else if (tmpPorta.getNome().startsWith(check2oldWithoutV)) {
                        match = true;
                        parteRimanente = tmpPorta.getNome().substring(check2oldWithoutV.length());
                        nuovoNome = "__" + newLocationSuffix + parteRimanente;
                    }
                    IDPortaApplicativa oldIDPortaApplicativaForUpdate = null;
                    if (match) {
                        PortaApplicativaAzione paAzione;
                        oldIDPortaApplicativaForUpdate = new IDPortaApplicativa();
                        oldIDPortaApplicativaForUpdate.setNome(tmpPorta.getNome());
                        tmpPorta.setOldIDPortaApplicativaForUpdate(oldIDPortaApplicativaForUpdate);
                        tmpPorta.setNome(nuovoNome);
                        String descrizionePA = tmpPorta.getDescrizione();
                        if (descrizionePA != null && !descrizionePA.equals("")) {
                            String soggettoOldCaso1 = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo() + "/" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome();
                            String soggettoNewCaso1 = asps.getTipoSoggettoErogatore() + "/" + asps.getNomeSoggettoErogatore();
                            String matchCaso = soggettoOldCaso1 + ":" + asps.getOldIDServizioForUpdate().getTipo() + "/" + asps.getOldIDServizioForUpdate().getNome() + ":" + asps.getOldIDServizioForUpdate().getVersione();
                            if (descrizionePA.endsWith(matchCaso)) {
                                String replaceCaso = soggettoNewCaso1 + ":" + asps.getTipo() + "/" + asps.getNome() + ":" + asps.getVersione();
                                descrizionePA = descrizionePA.replace(matchCaso, replaceCaso);
                            }
                            String soggettoOldCaso2 = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo() + "_" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome();
                            String soggettoNewCaso2 = asps.getTipoSoggettoErogatore() + "_" + asps.getNomeSoggettoErogatore();
                            String tmpMatchCaso2 = soggettoOldCaso2 + "/" + asps.getOldIDServizioForUpdate().getTipo() + "_" + asps.getOldIDServizioForUpdate().getNome() + "/";
                            String matchCaso2 = tmpMatchCaso2 + "v" + asps.getOldIDServizioForUpdate().getVersione();
                            String matchCaso2oldWithoutV = tmpMatchCaso2 + asps.getOldIDServizioForUpdate().getVersione();
                            if (descrizionePA.contains(matchCaso2)) {
                                String replaceCaso2 = soggettoNewCaso2 + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione();
                                descrizionePA = descrizionePA.replace(matchCaso2, replaceCaso2);
                            } else if (descrizionePA.contains(matchCaso2oldWithoutV)) {
                                String replaceCaso2 = soggettoNewCaso2 + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione();
                                descrizionePA = descrizionePA.replace(matchCaso2oldWithoutV, replaceCaso2);
                            }
                            tmpPorta.setDescrizione(descrizionePA);
                        }
                        PortaApplicativaAzioneIdentificazione identificazione = (paAzione = tmpPorta.getAzione()) != null ? paAzione.getIdentificazione() : null;
                        String patterAzione = "";
                        if (paAzione != null) {
                            patterAzione = paAzione.getPattern() != null ? paAzione.getPattern() : "";
                        }
                        String patternAzionePrefixOld = ".*/";
                        String patternAzioneSuffix1Old = "/([^/|^?]*).*";
                        String patternAzionePrefixNew = "/";
                        String patternAzioneSuffix1New = "/([^/?]*).*";
                        if (PortaApplicativaAzioneIdentificazione.URL_BASED.equals((Object)identificazione)) {
                            String regex;
                            int endidx;
                            int startidx;
                            String tmpPat;
                            boolean newPattern;
                            boolean oldPattern = patterAzione.startsWith(patternAzionePrefixOld) && patterAzione.endsWith(patternAzioneSuffix1Old);
                            boolean bl = newPattern = patterAzione.startsWith(patternAzionePrefixNew) && patterAzione.endsWith(patternAzioneSuffix1New);
                            if ((oldPattern || newPattern) && (tmpPat = patterAzione.substring(startidx = oldPattern ? patternAzionePrefixOld.length() : patternAzionePrefixNew.length(), endidx = oldPattern ? patterAzione.lastIndexOf(patternAzioneSuffix1Old) : patterAzione.lastIndexOf(patternAzioneSuffix1New))).matches(regex = "(.*)\\/(.*)\\/(.*)")) {
                                String[] val = tmpPat.split("/");
                                Object partErogatore = val[0];
                                Object partServizio = val[1];
                                Object partVersione = val[2];
                                String rimanenteRegExp = "";
                                int lengthParteRimanenteRegExp = ((String)partErogatore + "/" + (String)partServizio + "/" + (String)partVersione).length();
                                if (tmpPat.length() > lengthParteRimanenteRegExp) {
                                    rimanenteRegExp = tmpPat.substring(lengthParteRimanenteRegExp);
                                }
                                boolean matchURL = false;
                                String partErogatoreOld = "(?:" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo() + "_)?" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome();
                                String partErogatoreNew = "(?:" + asps.getTipoSoggettoErogatore() + "_)?" + asps.getNomeSoggettoErogatore();
                                if (((String)partErogatore).equals(partErogatoreOld)) {
                                    partErogatore = partErogatoreNew;
                                    matchURL = true;
                                }
                                String partOldServizio = "(?:" + asps.getOldIDServizioForUpdate().getTipo() + "_)?" + asps.getOldIDServizioForUpdate().getNome();
                                String partNewServizio = "(?:" + asps.getTipo() + "_)?" + asps.getNome();
                                if (((String)partServizio).equals(partOldServizio)) {
                                    partServizio = partNewServizio;
                                    matchURL = true;
                                }
                                String versioneOld = "v" + asps.getOldIDServizioForUpdate().getVersione();
                                String versioneOldOldWithoutV = "" + asps.getOldIDServizioForUpdate().getVersione();
                                if (((String)partVersione).equals(versioneOld) || ((String)partVersione).equals(versioneOldOldWithoutV)) {
                                    partVersione = "v" + asps.getVersione();
                                    matchURL = true;
                                }
                                if (matchURL) {
                                    String newPatternAzione = patternAzionePrefixNew + (String)partErogatore + "/" + (String)partServizio + "/" + (String)partVersione + rimanenteRegExp + patternAzioneSuffix1New;
                                    paAzione.setPattern(newPatternAzione);
                                    tmpPorta.setAzione(paAzione);
                                }
                            }
                        }
                        String nomePortaDelegante = null;
                        if (paAzione != null) {
                            String string = nomePortaDelegante = paAzione.getNomePortaDelegante() != null ? paAzione.getNomePortaDelegante() : null;
                        }
                        if (PortaApplicativaAzioneIdentificazione.DELEGATED_BY.equals((Object)identificazione) && nomePortaDelegante != null) {
                            String nuovoNomeDelegate = null;
                            boolean matchDelegate = false;
                            if (nomePortaDelegante.equals(check1) || nomePortaDelegante.equals(check1oldWithoutV)) {
                                matchDelegate = true;
                                nuovoNomeDelegate = newLocationSuffix;
                            }
                            if (matchDelegate) {
                                tmpPorta.getAzione().setNomePortaDelegante(nuovoNomeDelegate);
                            }
                        }
                        if (tmpPorta.getOldIDPortaApplicativaForUpdate() != null && tmpPorta.getOldIDPortaApplicativaForUpdate().getNome() != null) {
                            ConsoleSearch ricercaPolicies4 = new ConsoleSearch(true);
                            List<AttivazionePolicy> listaPolicies = null;
                            try {
                                listaPolicies = confCore.attivazionePolicyList(ricercaPolicies4, RuoloPolicy.APPLICATIVA, tmpPorta.getOldIDPortaApplicativaForUpdate().getNome());
                            }
                            catch (Exception endidx) {
                                // empty catch block
                            }
                            if (listaPolicies != null && !listaPolicies.isEmpty()) {
                                for (AttivazionePolicy ap : listaPolicies) {
                                    if (ap.getFiltro() == null || !tmpPorta.getOldIDPortaApplicativaForUpdate().getNome().equals(ap.getFiltro().getNomePorta())) continue;
                                    ap.getFiltro().setNomePorta(tmpPorta.getNome());
                                    listaPolicyDaAggiornare.put(ap.getIdActivePolicy(), ap);
                                }
                            }
                        }
                        if (confCore.isConfigurazioneAllarmiEnabled() && tmpPorta.getOldIDPortaApplicativaForUpdate() != null && tmpPorta.getOldIDPortaApplicativaForUpdate().getNome() != null) {
                            ConsoleSearch ricercaPolicies5 = new ConsoleSearch(true);
                            List<ConfigurazioneAllarmeBean> listaAllarmi = null;
                            try {
                                listaAllarmi = confCore.allarmiList(ricercaPolicies5, RuoloPorta.APPLICATIVA, tmpPorta.getOldIDPortaApplicativaForUpdate().getNome());
                            }
                            catch (Exception endidx) {
                                // empty catch block
                            }
                            if (listaAllarmi != null && !listaAllarmi.isEmpty()) {
                                for (ConfigurazioneAllarmeBean allarme : listaAllarmi) {
                                    if (allarme.getFiltro() == null || !tmpPorta.getOldIDPortaApplicativaForUpdate().getNome().equals(allarme.getFiltro().getNomePorta())) continue;
                                    allarme.getFiltro().setNomePorta(tmpPorta.getNome());
                                    listaAllarmiDaAggiornare.put(allarme.getNome(), allarme);
                                }
                            }
                        }
                    }
                    listaPA.add(tmpPorta);
                    if (oldIDPortaApplicativaForUpdate == null || tmpPorta.sizeServizioApplicativoList() <= 0) continue;
                    for (PortaApplicativaServizioApplicativo portaApplicativaSA : tmpPorta.getServizioApplicativoList()) {
                        String checkNomeSAoldWithoutV;
                        String checkNumero;
                        String withoutPrefix;
                        boolean equalsName = portaApplicativaSA.getNome().equals(oldIDPortaApplicativaForUpdate.getNome());
                        boolean equalsConSuffissoConnettoriMultipli = false;
                        String suffixConnettoreMultiplo = null;
                        if (!equalsName && portaApplicativaSA.getNome().startsWith(oldIDPortaApplicativaForUpdate.getNome()) && (withoutPrefix = portaApplicativaSA.getNome().substring(oldIDPortaApplicativaForUpdate.getNome().length())) != null && withoutPrefix.startsWith("__SA") && !withoutPrefix.equals("__SA") && (checkNumero = withoutPrefix.substring("__SA".length())) != null) {
                            try {
                                int numero = Integer.parseInt(checkNumero);
                                if (numero > 0) {
                                    suffixConnettoreMultiplo = withoutPrefix;
                                    equalsConSuffissoConnettoriMultipli = true;
                                }
                            }
                            catch (Exception numero) {
                                // empty catch block
                            }
                        }
                        if (!equalsName && !equalsConSuffissoConnettoriMultipli) continue;
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setNome(portaApplicativaSA.getNome());
                        idSA.setIdSoggettoProprietario(new IDSoggetto(asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo(), asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome()));
                        ServizioApplicativo sa = saCore.getServizioApplicativo(idSA);
                        IDServizioApplicativo oldIDServizioApplicativoForUpdate = new IDServizioApplicativo();
                        oldIDServizioApplicativoForUpdate.setNome(sa.getNome());
                        oldIDServizioApplicativoForUpdate.setIdSoggettoProprietario(idSA.getIdSoggettoProprietario());
                        sa.setOldIDServizioApplicativoForUpdate(oldIDServizioApplicativoForUpdate);
                        sa.setTipoSoggettoProprietario(asps.getTipoSoggettoErogatore());
                        sa.setNomeSoggettoProprietario(asps.getNomeSoggettoErogatore());
                        String soggettoOld = asps.getOldIDServizioForUpdate().getSoggettoErogatore().getTipo() + "_" + asps.getOldIDServizioForUpdate().getSoggettoErogatore().getNome();
                        String soggettoNew = asps.getTipoSoggettoErogatore() + "_" + asps.getNomeSoggettoErogatore();
                        if (equalsName) {
                            String tmpCheckNomeSA = soggettoOld + "/" + asps.getOldIDServizioForUpdate().getTipo() + "_" + asps.getOldIDServizioForUpdate().getNome() + "/";
                            String checkNomeSA = tmpCheckNomeSA + "v" + asps.getOldIDServizioForUpdate().getVersione();
                            checkNomeSAoldWithoutV = tmpCheckNomeSA + asps.getOldIDServizioForUpdate().getVersione();
                            if (sa.getNome().endsWith(checkNomeSA)) {
                                sa.setNome(sa.getNome().replace(checkNomeSA, soggettoNew + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione()));
                            } else if (sa.getNome().startsWith("__") && sa.getNome().contains(checkNomeSA)) {
                                sa.setNome(sa.getNome().replace(checkNomeSA, soggettoNew + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione()));
                            } else if (sa.getNome().endsWith(checkNomeSAoldWithoutV)) {
                                sa.setNome(sa.getNome().replace(checkNomeSAoldWithoutV, soggettoNew + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione()));
                            } else if (sa.getNome().startsWith("__") && sa.getNome().contains(checkNomeSAoldWithoutV)) {
                                sa.setNome(sa.getNome().replace(checkNomeSAoldWithoutV, soggettoNew + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione()));
                            }
                            mapOldToNewSaName.put(portaApplicativaSA.getNome(), sa.getNome());
                            portaApplicativaSA.setNome(sa.getNome());
                            listaPASA.add(sa);
                            continue;
                        }
                        if (!equalsConSuffissoConnettoriMultipli) continue;
                        String tmpCheckNomeSA = soggettoOld + "/" + asps.getOldIDServizioForUpdate().getTipo() + "_" + asps.getOldIDServizioForUpdate().getNome() + "/";
                        String checkNomeSA = tmpCheckNomeSA + "v" + asps.getOldIDServizioForUpdate().getVersione();
                        checkNomeSAoldWithoutV = tmpCheckNomeSA + asps.getOldIDServizioForUpdate().getVersione();
                        if (sa.getNome().endsWith(checkNomeSA + suffixConnettoreMultiplo)) {
                            sa.setNome(sa.getNome().replace(checkNomeSA, soggettoNew + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione()));
                        } else if (sa.getNome().startsWith("__") && sa.getNome().contains(checkNomeSA) && sa.getNome().endsWith(suffixConnettoreMultiplo)) {
                            sa.setNome(sa.getNome().replace(checkNomeSA, soggettoNew + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione()));
                        } else if (sa.getNome().endsWith(checkNomeSAoldWithoutV + suffixConnettoreMultiplo)) {
                            sa.setNome(sa.getNome().replace(checkNomeSAoldWithoutV, soggettoNew + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione()));
                        } else if (sa.getNome().startsWith("__") && sa.getNome().contains(checkNomeSAoldWithoutV) && sa.getNome().endsWith(suffixConnettoreMultiplo)) {
                            sa.setNome(sa.getNome().replace(checkNomeSAoldWithoutV, soggettoNew + "/" + asps.getTipo() + "_" + asps.getNome() + "/v" + asps.getVersione()));
                        }
                        mapOldToNewSaName.put(portaApplicativaSA.getNome(), sa.getNome());
                        portaApplicativaSA.setNome(sa.getNome());
                        listaPASA.add(sa);
                    }
                }
            }
            if (listaPA != null && !listaPA.isEmpty()) {
                for (PortaApplicativa portaApplicativa : listaPA) {
                    if (portaApplicativa.sizeServizioApplicativoList() <= 0) continue;
                    for (PortaApplicativaServizioApplicativo portaApplicativaSA : portaApplicativa.getServizioApplicativoList()) {
                        if (!mapOldToNewSaName.containsKey(portaApplicativaSA.getNome())) continue;
                        String nomeAggiornato = (String)mapOldToNewSaName.get(portaApplicativaSA.getNome());
                        portaApplicativaSA.setNome(nomeAggiornato);
                    }
                }
            }
        }
        ArrayList<Object> oggettiDaAggiornare = new ArrayList<Object>();
        oggettiDaAggiornare.add(asps);
        for (PortaDelegata portaDelegata : listaPD) {
            oggettiDaAggiornare.add(portaDelegata);
        }
        for (ServizioApplicativo sa : listaPASA) {
            oggettiDaAggiornare.add(sa);
        }
        for (PortaApplicativa portaApplicativa : listaPA) {
            oggettiDaAggiornare.add(portaApplicativa);
        }
        if (!newUri.equals(oldUri)) {
            idServizioOLD = asps.getOldIDServizioForUpdate();
            String uriOLD = IDServizioFactory.getInstance().getUriFromIDServizio((IDServizio)idServizioOLD);
            List<AccordoServizioParteComune> ass = apcCore.accordiServizioServiziComponenti((IDServizio)idServizioOLD);
            for (int i = 0; i < ass.size(); ++i) {
                AccordoServizioParteComune accordoServizioComposto = ass.get(i);
                if (accordoServizioComposto.getServizioComposto() == null) continue;
                for (int j = 0; j < accordoServizioComposto.getServizioComposto().sizeServizioComponenteList(); ++j) {
                    IDServizio idServizioComponente = IDServizioFactory.getInstance().getIDServizioFromValues(accordoServizioComposto.getServizioComposto().getServizioComponente(j).getTipo(), accordoServizioComposto.getServizioComposto().getServizioComponente(j).getNome(), accordoServizioComposto.getServizioComposto().getServizioComponente(j).getTipoSoggetto(), accordoServizioComposto.getServizioComposto().getServizioComponente(j).getNomeSoggetto(), accordoServizioComposto.getServizioComposto().getServizioComponente(j).getVersione().intValue());
                    String uriServizioComponente = IDServizioFactory.getInstance().getUriFromIDServizio(idServizioComponente);
                    if (!uriServizioComponente.equals(uriOLD)) continue;
                    accordoServizioComposto.getServizioComposto().getServizioComponente(j).setTipoSoggetto(asps.getTipoSoggettoErogatore());
                    accordoServizioComposto.getServizioComposto().getServizioComponente(j).setNomeSoggetto(asps.getNomeSoggettoErogatore());
                    accordoServizioComposto.getServizioComposto().getServizioComponente(j).setTipo(asps.getTipo());
                    accordoServizioComposto.getServizioComposto().getServizioComponente(j).setNome(asps.getNome());
                    accordoServizioComposto.getServizioComposto().getServizioComponente(j).setVersione(asps.getVersione());
                }
                oggettiDaAggiornare.add(accordoServizioComposto);
            }
        }
        if (!newUri.equals(oldUri)) {
            idServizioOLD = asps.getOldIDServizioForUpdate();
            ricercaPolicies = new ConsoleSearch(true);
            List<AttivazionePolicy> listaPolicies = null;
            try {
                listaPolicies = confCore.attivazionePolicyListByFilter(ricercaPolicies, null, null, null, null, null, null, null, (IDServizio)idServizioOLD, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (listaPolicies != null && !listaPolicies.isEmpty()) {
                for (AttivazionePolicy ap : listaPolicies) {
                    if (ap.getFiltro() == null) continue;
                    if (idServizioOLD.getSoggettoErogatore().getTipo().equals(ap.getFiltro().getTipoErogatore())) {
                        ap.getFiltro().setTipoErogatore(asps.getTipoSoggettoErogatore());
                    }
                    if (idServizioOLD.getSoggettoErogatore().getNome().equals(ap.getFiltro().getNomeErogatore())) {
                        ap.getFiltro().setNomeErogatore(asps.getNomeSoggettoErogatore());
                    }
                    if (idServizioOLD.getTipo().equals(ap.getFiltro().getTipoServizio())) {
                        ap.getFiltro().setTipoServizio(asps.getTipo());
                    }
                    if (idServizioOLD.getNome().equals(ap.getFiltro().getNomeServizio())) {
                        ap.getFiltro().setNomeServizio(asps.getNome());
                    }
                    if (ap.getFiltro().getVersioneServizio() != null && idServizioOLD.getVersione().intValue() == ap.getFiltro().getVersioneServizio().intValue()) {
                        ap.getFiltro().setVersioneServizio(asps.getVersione());
                    }
                    listaPolicyDaAggiornare.put(ap.getIdActivePolicy(), ap);
                }
            }
        }
        if (!listaPolicyDaAggiornare.isEmpty()) {
            for (AttivazionePolicy ap : listaPolicyDaAggiornare.values()) {
                oggettiDaAggiornare.add(ap);
            }
        }
        if (confCore.isConfigurazioneAllarmiEnabled()) {
            if (!newUri.equals(oldUri)) {
                idServizioOLD = asps.getOldIDServizioForUpdate();
                ricercaPolicies = new ConsoleSearch(true);
                List<ConfigurazioneAllarmeBean> listaAllarmi = null;
                try {
                    listaAllarmi = confCore.allarmiListByFilter(ricercaPolicies, null, null, null, null, null, null, null, (IDServizio)idServizioOLD, null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (listaAllarmi != null && !listaAllarmi.isEmpty()) {
                    for (ConfigurazioneAllarmeBean allarme : listaAllarmi) {
                        if (allarme.getFiltro() == null) continue;
                        if (idServizioOLD.getSoggettoErogatore().getTipo().equals(allarme.getFiltro().getTipoErogatore())) {
                            allarme.getFiltro().setTipoErogatore(asps.getTipoSoggettoErogatore());
                        }
                        if (idServizioOLD.getSoggettoErogatore().getNome().equals(allarme.getFiltro().getNomeErogatore())) {
                            allarme.getFiltro().setNomeErogatore(asps.getNomeSoggettoErogatore());
                        }
                        if (idServizioOLD.getTipo().equals(allarme.getFiltro().getTipoServizio())) {
                            allarme.getFiltro().setTipoServizio(asps.getTipo());
                        }
                        if (idServizioOLD.getNome().equals(allarme.getFiltro().getNomeServizio())) {
                            allarme.getFiltro().setNomeServizio(asps.getNome());
                        }
                        if (allarme.getFiltro().getVersioneServizio() != null && idServizioOLD.getVersione().intValue() == allarme.getFiltro().getVersioneServizio().intValue()) {
                            allarme.getFiltro().setVersioneServizio(asps.getVersione());
                        }
                        listaAllarmiDaAggiornare.put(allarme.getNome(), allarme);
                    }
                }
            }
            if (!listaAllarmiDaAggiornare.isEmpty()) {
                for (ConfigurazioneAllarmeBean allarme : listaAllarmiDaAggiornare.values()) {
                    oggettiDaAggiornare.add(allarme);
                }
            }
        }
        return oggettiDaAggiornare;
    }

    public static boolean deleteAccordoServizioParteSpecifica(AccordoServizioParteSpecifica asps, boolean gestioneFruitori, boolean gestioneErogatori, IDSoggetto idSoggettoFruitore, IDServizio idServizio, IExtendedListServlet extendedServlet, String superUser, AccordiServizioParteSpecificaCore apsCore, AccordiServizioParteSpecificaHelper apsHelper, StringBuilder inUsoMessage, String newLine) throws Exception {
        SoggettiCore soggettiCore = new SoggettiCore(apsCore);
        PddCore pddCore = new PddCore(apsCore);
        PorteDelegateCore porteDelegateCore = new PorteDelegateCore(apsCore);
        PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(apsCore);
        ConfigurazioneCore confCore = new ConfigurazioneCore(apsCore);
        ServiziApplicativiCore saCore = new ServiziApplicativiCore(apsCore);
        ArrayList<PortaApplicativa> paGenerateAutomcaticamente = null;
        List<IDPortaApplicativa> idPAGenerateAutomaticamente = null;
        ArrayList<PortaDelegata> pdGenerateAutomcaticamente = null;
        List<IDPortaDelegata> idPDGenerateAutomaticamente = null;
        ArrayList<IDPortaDelegata> idPDGenerateAutomaticamenteTutteFruizioni = null;
        if (asps != null) {
            boolean generaPACheckSoggetto = true;
            IDSoggetto idSoggettoEr = new IDSoggetto(asps.getTipoSoggettoErogatore(), asps.getNomeSoggettoErogatore());
            Soggetto soggetto = soggettiCore.getSoggettoRegistro(idSoggettoEr);
            if (pddCore.isPddEsterna(soggetto.getPortaDominio())) {
                generaPACheckSoggetto = false;
            }
            if (gestioneFruitori) {
                idPDGenerateAutomaticamente = porteDelegateCore.getIDPorteDelegateAssociate(idServizio, idSoggettoFruitore);
                if (idPDGenerateAutomaticamente != null && !idPDGenerateAutomaticamente.isEmpty()) {
                    for (IDPortaDelegata idPortaDelegata : idPDGenerateAutomaticamente) {
                        if (idPortaDelegata.getIdentificativiFruizione() == null) {
                            idPortaDelegata.setIdentificativiFruizione(new IdentificativiFruizione());
                        }
                        if (idPortaDelegata.getIdentificativiFruizione().getSoggettoFruitore() == null) {
                            idPortaDelegata.getIdentificativiFruizione().setSoggettoFruitore(idSoggettoFruitore);
                        }
                        if (pdGenerateAutomcaticamente == null) {
                            pdGenerateAutomcaticamente = new ArrayList<PortaDelegata>();
                        }
                        pdGenerateAutomcaticamente.add(porteDelegateCore.getPortaDelegata(idPortaDelegata));
                    }
                }
                if (asps.sizeFruitoreList() > 0) {
                    for (Fruitore fruitore : asps.getFruitoreList()) {
                        IDSoggetto idF = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                        if (idF.equals((Object)idSoggettoFruitore)) {
                            if (idPDGenerateAutomaticamente == null || idPDGenerateAutomaticamente.isEmpty()) continue;
                            if (idPDGenerateAutomaticamenteTutteFruizioni == null) {
                                idPDGenerateAutomaticamenteTutteFruizioni = new ArrayList<IDPortaDelegata>();
                            }
                            idPDGenerateAutomaticamenteTutteFruizioni.addAll(idPDGenerateAutomaticamente);
                            continue;
                        }
                        List<IDPortaDelegata> l = porteDelegateCore.getIDPorteDelegateAssociate(idServizio, idF);
                        if (l == null || l.isEmpty()) continue;
                        if (idPDGenerateAutomaticamenteTutteFruizioni == null) {
                            idPDGenerateAutomaticamenteTutteFruizioni = new ArrayList();
                        }
                        idPDGenerateAutomaticamenteTutteFruizioni.addAll(l);
                    }
                }
            } else if (generaPACheckSoggetto && (idPAGenerateAutomaticamente = porteApplicativeCore.getIDPorteApplicativeAssociate(idServizio)) != null && !idPAGenerateAutomaticamente.isEmpty()) {
                for (IDPortaApplicativa idPortaApplicativa : idPAGenerateAutomaticamente) {
                    if (paGenerateAutomcaticamente == null) {
                        paGenerateAutomcaticamente = new ArrayList<PortaApplicativa>();
                    }
                    paGenerateAutomcaticamente.add(porteApplicativeCore.getPortaApplicativa(idPortaApplicativa));
                }
            }
        }
        HashMap<ErrorsHandlerCostant, List<String>> whereIsInUso = new HashMap<ErrorsHandlerCostant, List<String>>();
        boolean normalizeObjectIds = !apsHelper.isModalitaCompleta();
        boolean apsEliminabile = true;
        ArrayList<IDPortaDelegata> idPDGenerateAutomaticamenteCheckInUso = new ArrayList<IDPortaDelegata>();
        ArrayList<IDPortaApplicativa> idPAGenerateAutomaticamenteCheckInUso = new ArrayList<IDPortaApplicativa>();
        if (gestioneErogatori) {
            if (idPAGenerateAutomaticamente != null && !idPAGenerateAutomaticamente.isEmpty()) {
                idPAGenerateAutomaticamenteCheckInUso.addAll(idPAGenerateAutomaticamente);
            }
            if (asps.sizeFruitoreList() > 0) {
                for (Object fruitore : asps.getFruitoreList()) {
                    List<IDPortaDelegata> idPDGenerateAutomaticamenteTmp;
                    IDSoggetto idSoggettoFruitoreCheck = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                    Soggetto soggettoCheck = soggettiCore.getSoggettoRegistro(idSoggettoFruitoreCheck);
                    if (pddCore.isPddEsterna(soggettoCheck.getPortaDominio()) || (idPDGenerateAutomaticamenteTmp = porteDelegateCore.getIDPorteDelegateAssociate(idServizio, idSoggettoFruitoreCheck)) == null || idPDGenerateAutomaticamenteTmp.isEmpty()) continue;
                    apsEliminabile = false;
                    break;
                }
            }
        } else if (gestioneFruitori) {
            List<IDPortaApplicativa> idPAGenerateAutomaticamenteTmp;
            if (idPDGenerateAutomaticamente != null && !idPDGenerateAutomaticamente.isEmpty()) {
                idPDGenerateAutomaticamenteCheckInUso.addAll(idPDGenerateAutomaticamente);
            }
            if ((idPAGenerateAutomaticamenteTmp = porteApplicativeCore.getIDPorteApplicativeAssociate(idServizio)) != null && !idPAGenerateAutomaticamenteTmp.isEmpty()) {
                apsEliminabile = false;
            }
            if (apsEliminabile && asps.sizeFruitoreList() > 0) {
                for (Fruitore fruitore : asps.getFruitoreList()) {
                    List<IDPortaDelegata> idPDGenerateAutomaticamenteTmp;
                    Soggetto soggettoCheck;
                    IDSoggetto idSoggettoFruitoreCheck = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                    if (idSoggettoFruitoreCheck.equals((Object)idSoggettoFruitore) || pddCore.isPddEsterna((soggettoCheck = soggettiCore.getSoggettoRegistro(idSoggettoFruitoreCheck)).getPortaDominio()) || (idPDGenerateAutomaticamenteTmp = porteDelegateCore.getIDPorteDelegateAssociate(idServizio, idSoggettoFruitore)) == null || idPDGenerateAutomaticamenteTmp.isEmpty()) continue;
                    apsEliminabile = false;
                    break;
                }
            }
        }
        boolean inUso = false;
        inUso = apsCore.isAccordoServizioParteSpecificaInUso(asps, whereIsInUso, idPDGenerateAutomaticamenteTutteFruizioni, idPAGenerateAutomaticamente, normalizeObjectIds);
        if (!inUso) {
            WrapperExtendedBean wrapper;
            List<IExtendedBean> listExt;
            ArrayList<WrapperExtendedBean> listaOggettiDaEliminare = new ArrayList<WrapperExtendedBean>();
            ArrayList<ServizioApplicativo> listaServiziApplicativiDaEliminare = new ArrayList<ServizioApplicativo>();
            if (paGenerateAutomcaticamente != null && !paGenerateAutomcaticamente.isEmpty()) {
                for (PortaApplicativa paGenerataAutomcaticamente : paGenerateAutomcaticamente) {
                    List<ConfigurazioneAllarmeBean> listAllarmi;
                    List<AttivazionePolicy> listAttivazione;
                    if (extendedServlet != null) {
                        listExt = null;
                        try {
                            listExt = extendedServlet.extendedBeanList(TipoOperazione.DEL, apsHelper, apsCore, paGenerataAutomcaticamente);
                        }
                        catch (Exception e) {
                            ControlStationCore.logError(e.getMessage(), e);
                        }
                        if (listExt != null && !listExt.isEmpty()) {
                            for (IExtendedBean iExtendedBean : listExt) {
                                wrapper = new WrapperExtendedBean();
                                wrapper.setExtendedBean(iExtendedBean);
                                wrapper.setExtendedServlet(extendedServlet);
                                wrapper.setOriginalBean(paGenerataAutomcaticamente);
                                wrapper.setManageOriginalBean(false);
                                listaOggettiDaEliminare.add(wrapper);
                            }
                        }
                    }
                    MappingErogazionePortaApplicativa mappingErogazione = new MappingErogazionePortaApplicativa();
                    IDSoggetto soggettoErogatore = new IDSoggetto(paGenerataAutomcaticamente.getTipoSoggettoProprietario(), paGenerataAutomcaticamente.getNomeSoggettoProprietario());
                    IDPortaApplicativa idPortaApplicativa = new IDPortaApplicativa();
                    idPortaApplicativa.setNome(paGenerataAutomcaticamente.getNome());
                    mappingErogazione.setIdPortaApplicativa(idPortaApplicativa);
                    IDServizio idServizioPA = IDServizioFactory.getInstance().getIDServizioFromValues(paGenerataAutomcaticamente.getServizio().getTipo(), paGenerataAutomcaticamente.getServizio().getNome(), soggettoErogatore, paGenerataAutomcaticamente.getServizio().getVersione().intValue());
                    mappingErogazione.setIdServizio(idServizioPA);
                    if (porteApplicativeCore.existsMappingErogazionePortaApplicativa(mappingErogazione)) {
                        listaOggettiDaEliminare.add((WrapperExtendedBean)mappingErogazione);
                    }
                    if ((listAttivazione = confCore.attivazionePolicyList(new ConsoleSearch(true), RuoloPolicy.APPLICATIVA, paGenerataAutomcaticamente.getNome())) != null && !listAttivazione.isEmpty()) {
                        listaOggettiDaEliminare.addAll(listAttivazione);
                    }
                    if (confCore.isConfigurazioneAllarmiEnabled() && (listAllarmi = confCore.allarmiList(new ConsoleSearch(true), RuoloPorta.APPLICATIVA, paGenerataAutomcaticamente.getNome())) != null && !listAllarmi.isEmpty()) {
                        listaOggettiDaEliminare.addAll(listAllarmi);
                    }
                    listaOggettiDaEliminare.add((WrapperExtendedBean)paGenerataAutomcaticamente);
                    if (paGenerataAutomcaticamente.getServizioApplicativoDefault() != null) {
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setIdSoggettoProprietario(soggettoErogatore);
                        idSA.setNome(paGenerataAutomcaticamente.getServizioApplicativoDefault());
                        ServizioApplicativo saGeneratoAutomaticamente = saCore.getServizioApplicativo(idSA);
                        if (!"server".equals(saGeneratoAutomaticamente.getTipo())) {
                            listaServiziApplicativiDaEliminare.add(saGeneratoAutomaticamente);
                        }
                    }
                    for (PortaApplicativaServizioApplicativo paSA : paGenerataAutomcaticamente.getServizioApplicativoList()) {
                        boolean connettoreMultiploAggiunto = paSA.getNome().startsWith(paGenerataAutomcaticamente.getNome() + "__SA");
                        if (!paSA.getNome().equals(paGenerataAutomcaticamente.getNome()) && !connettoreMultiploAggiunto) continue;
                        IDServizioApplicativo idSA = new IDServizioApplicativo();
                        idSA.setIdSoggettoProprietario(soggettoErogatore);
                        idSA.setNome(paSA.getNome());
                        ServizioApplicativo saGeneratoAutomaticamente = saCore.getServizioApplicativo(idSA);
                        if ("server".equals(saGeneratoAutomaticamente.getTipo())) continue;
                        listaServiziApplicativiDaEliminare.add(saGeneratoAutomaticamente);
                    }
                }
            }
            if (pdGenerateAutomcaticamente != null && !pdGenerateAutomcaticamente.isEmpty()) {
                for (PortaDelegata pdGenerataAutomcaticamente : pdGenerateAutomcaticamente) {
                    List<ConfigurazioneAllarmeBean> listAllarmi;
                    List<AttivazionePolicy> listAttivazione;
                    if (extendedServlet != null) {
                        listExt = null;
                        try {
                            listExt = extendedServlet.extendedBeanList(TipoOperazione.DEL, apsHelper, apsCore, pdGenerataAutomcaticamente);
                        }
                        catch (Exception e) {
                            ControlStationCore.logError(e.getMessage(), e);
                        }
                        if (listExt != null && !listExt.isEmpty()) {
                            for (IExtendedBean iExtendedBean : listExt) {
                                wrapper = new WrapperExtendedBean();
                                wrapper.setExtendedBean(iExtendedBean);
                                wrapper.setExtendedServlet(extendedServlet);
                                wrapper.setOriginalBean(pdGenerataAutomcaticamente);
                                wrapper.setManageOriginalBean(false);
                                listaOggettiDaEliminare.add(wrapper);
                            }
                        }
                    }
                    MappingFruizionePortaDelegata mappingFruizione = new MappingFruizionePortaDelegata();
                    mappingFruizione.setIdFruitore(idSoggettoFruitore);
                    mappingFruizione.setIdServizio(idServizio);
                    IDPortaDelegata idPortaDelegata = new IDPortaDelegata();
                    idPortaDelegata.setNome(pdGenerataAutomcaticamente.getNome());
                    mappingFruizione.setIdPortaDelegata(idPortaDelegata);
                    if (porteDelegateCore.existsMappingFruizionePortaDelegata(mappingFruizione)) {
                        listaOggettiDaEliminare.add((WrapperExtendedBean)mappingFruizione);
                    }
                    if ((listAttivazione = confCore.attivazionePolicyList(new ConsoleSearch(true), RuoloPolicy.DELEGATA, pdGenerataAutomcaticamente.getNome())) != null && !listAttivazione.isEmpty()) {
                        listaOggettiDaEliminare.addAll(listAttivazione);
                    }
                    if (confCore.isConfigurazioneAllarmiEnabled() && (listAllarmi = confCore.allarmiList(new ConsoleSearch(true), RuoloPorta.DELEGATA, pdGenerataAutomcaticamente.getNome())) != null && !listAllarmi.isEmpty()) {
                        listaOggettiDaEliminare.addAll(listAllarmi);
                    }
                    listaOggettiDaEliminare.add((WrapperExtendedBean)pdGenerataAutomcaticamente);
                }
            }
            boolean updateAPS = false;
            if (apsEliminabile) {
                if (listaServiziApplicativiDaEliminare != null && !listaOggettiDaEliminare.isEmpty()) {
                    listaOggettiDaEliminare.addAll(listaServiziApplicativiDaEliminare);
                }
                listaOggettiDaEliminare.add((WrapperExtendedBean)asps);
            } else if (gestioneFruitori && asps.sizeFruitoreList() > 0) {
                for (int j = 0; j < asps.sizeFruitoreList(); ++j) {
                    Fruitore fruitore = asps.getFruitore(j);
                    IDSoggetto idSoggettoFruitoreCheck = new IDSoggetto(fruitore.getTipo(), fruitore.getNome());
                    if (!idSoggettoFruitoreCheck.equals((Object)idSoggettoFruitore)) continue;
                    asps.removeFruitore(j);
                    updateAPS = true;
                    break;
                }
            }
            apsCore.performDeleteOperation(superUser, apsHelper.smista(), listaOggettiDaEliminare.toArray());
            if (updateAPS) {
                apsCore.performUpdateOperation(superUser, apsHelper.smista(), asps);
            }
            return true;
        }
        String tipo = null;
        tipo = gestioneFruitori ? "Fruizione del Servizio" : (apsHelper.isModalitaCompleta() ? "Servizio" : "Erogazione del Servizio");
        inUsoMessage.append(DBOggettiInUsoUtils.toString((IDServizio)idServizio, whereIsInUso, (boolean)true, (String)newLine, (boolean)normalizeObjectIds, (String)tipo));
        inUsoMessage.append(newLine);
        return false;
    }

    public static void deleteAccordoServizioParteSpecificaPorteApplicative(IDPortaApplicativa idPortaApplicativa, IDServizio idServizio, String superUser, AccordiServizioParteSpecificaCore apsCore, AccordiServizioParteSpecificaHelper apsHelper, StringBuilder inUsoMessage) throws Exception {
        PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(apsCore);
        ConfigurazioneCore confCore = new ConfigurazioneCore(apsCore);
        ServiziApplicativiCore saCore = new ServiziApplicativiCore(apsCore);
        ArrayList<Object> listaOggettiDaEliminare = new ArrayList<Object>();
        PortaApplicativa tmpPA = porteApplicativeCore.getPortaApplicativa(idPortaApplicativa);
        boolean isDefault = apsCore.isDefaultMappingErogazione(idServizio, idPortaApplicativa);
        if (!isDefault) {
            List<ConfigurazioneAllarmeBean> listAllarmi;
            MappingErogazionePortaApplicativa mappingErogazione = new MappingErogazionePortaApplicativa();
            mappingErogazione.setIdServizio(idServizio);
            mappingErogazione.setIdPortaApplicativa(idPortaApplicativa);
            listaOggettiDaEliminare.add(mappingErogazione);
            List<AttivazionePolicy> listAttivazione = confCore.attivazionePolicyList(new ConsoleSearch(true), RuoloPolicy.APPLICATIVA, tmpPA.getNome());
            if (listAttivazione != null && !listAttivazione.isEmpty()) {
                listaOggettiDaEliminare.addAll(listAttivazione);
            }
            if (confCore.isConfigurazioneAllarmiEnabled() && (listAllarmi = confCore.allarmiList(new ConsoleSearch(true), RuoloPorta.APPLICATIVA, tmpPA.getNome())) != null && !listAllarmi.isEmpty()) {
                listaOggettiDaEliminare.addAll(listAllarmi);
            }
            listaOggettiDaEliminare.add(tmpPA);
            if (tmpPA.getServizioApplicativoDefault() != null) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(new IDSoggetto(tmpPA.getTipoSoggettoProprietario(), tmpPA.getNomeSoggettoProprietario()));
                idSA.setNome(tmpPA.getServizioApplicativoDefault());
                ServizioApplicativo saGeneratoAutomaticamente = saCore.getServizioApplicativo(idSA);
                if (!"server".equals(saGeneratoAutomaticamente.getTipo())) {
                    listaOggettiDaEliminare.add(saGeneratoAutomaticamente);
                }
            }
            for (PortaApplicativaServizioApplicativo paSA : tmpPA.getServizioApplicativoList()) {
                boolean connettoreMultiploAggiunto = paSA.getNome().startsWith(tmpPA.getNome() + "__SA");
                if (!paSA.getNome().equals(tmpPA.getNome()) && !connettoreMultiploAggiunto) continue;
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(new IDSoggetto(tmpPA.getTipoSoggettoProprietario(), tmpPA.getNomeSoggettoProprietario()));
                idSA.setNome(paSA.getNome());
                ServizioApplicativo saGeneratoAutomaticamente = saCore.getServizioApplicativo(idSA);
                if ("server".equals(saGeneratoAutomaticamente.getTipo())) continue;
                listaOggettiDaEliminare.add(saGeneratoAutomaticamente);
            }
            apsCore.performDeleteOperation(superUser, apsHelper.smista(), listaOggettiDaEliminare.toArray(new Object[1]));
        } else {
            inUsoMessage.append("Non \u00e8 possibile eliminare il gruppo 'Predefinito'");
        }
    }

    public static void deleteAccordoServizioParteSpecificaFruitoriPorteDelegate(List<IDPortaDelegata> listPortaDelegataDaELiminare, AccordoServizioParteSpecifica asps, IDSoggetto idSoggettoFruitore, String superUser, AccordiServizioParteSpecificaCore apsCore, AccordiServizioParteSpecificaHelper apsHelper, StringBuilder inUsoMessage) throws Exception {
        PorteDelegateCore porteDelegateCore = new PorteDelegateCore(apsCore);
        ConfigurazioneCore confCore = new ConfigurazioneCore(apsCore);
        IDServizio idServizioFromAccordo = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
        ArrayList<AccordoServizioParteSpecifica> listaOggettiDaModificare = new ArrayList<AccordoServizioParteSpecifica>();
        Fruitore fruitore = null;
        for (Fruitore fruitoreCheck : asps.getFruitoreList()) {
            if (!fruitoreCheck.getTipo().equals(idSoggettoFruitore.getTipo()) || !fruitoreCheck.getNome().equals(idSoggettoFruitore.getNome())) continue;
            fruitore = fruitoreCheck;
            break;
        }
        boolean updateASPS = false;
        for (int i = 0; i < listPortaDelegataDaELiminare.size(); ++i) {
            ArrayList<Object> listaOggettiDaEliminare = new ArrayList<Object>();
            IDPortaDelegata idPortaDelegata = listPortaDelegataDaELiminare.get(i);
            PortaDelegata tmpPD = porteDelegateCore.getPortaDelegata(idPortaDelegata);
            boolean isDefault = apsCore.isDefaultMappingFruizione(idServizioFromAccordo, idSoggettoFruitore, idPortaDelegata);
            if (!isDefault) {
                List<ConfigurazioneAllarmeBean> listAllarmi;
                MappingFruizionePortaDelegata mappingFruizione = new MappingFruizionePortaDelegata();
                mappingFruizione.setIdFruitore(idSoggettoFruitore);
                mappingFruizione.setIdPortaDelegata(idPortaDelegata);
                mappingFruizione.setIdServizio(idServizioFromAccordo);
                listaOggettiDaEliminare.add(mappingFruizione);
                List<AttivazionePolicy> listAttivazione = confCore.attivazionePolicyList(new ConsoleSearch(true), RuoloPolicy.DELEGATA, tmpPD.getNome());
                if (listAttivazione != null && !listAttivazione.isEmpty()) {
                    listaOggettiDaEliminare.addAll(listAttivazione);
                }
                if (confCore.isConfigurazioneAllarmiEnabled() && (listAllarmi = confCore.allarmiList(new ConsoleSearch(true), RuoloPorta.DELEGATA, tmpPD.getNome())) != null && !listAllarmi.isEmpty()) {
                    listaOggettiDaEliminare.addAll(listAllarmi);
                }
                listaOggettiDaEliminare.add(tmpPD);
                apsCore.performDeleteOperation(superUser, apsHelper.smista(), listaOggettiDaEliminare.toArray(new Object[1]));
                int index = -1;
                for (int j = 0; j < fruitore.sizeConfigurazioneAzioneList(); ++j) {
                    ConfigurazioneServizioAzione config = fruitore.getConfigurazioneAzione(j);
                    if (config == null) continue;
                    String azione = tmpPD.getAzione().getAzioneDelegata(0);
                    if (!config.getAzioneList().contains(azione)) continue;
                    index = j;
                    break;
                }
                if (index < 0) continue;
                updateASPS = true;
                fruitore.removeConfigurazioneAzione(index);
                continue;
            }
            inUsoMessage.append("Non \u00e8 possibile eliminare il gruppo 'Predefinito'");
        }
        if (updateASPS) {
            listaOggettiDaModificare.add(asps);
        }
        if (!listaOggettiDaModificare.isEmpty()) {
            porteDelegateCore.performUpdateOperation(superUser, apsHelper.smista(), listaOggettiDaModificare.toArray());
        }
    }

    public static final MappingErogazionePortaApplicativa getDefaultMappingPA(List<MappingErogazionePortaApplicativa> listaMappingErogazione) {
        return listaMappingErogazione.stream().filter(m -> m.isDefault()).findFirst().orElse(null);
    }

    public static final MappingErogazionePortaApplicativa getMappingPA(List<MappingErogazionePortaApplicativa> listaMappingErogazione, String mappingPA) {
        return listaMappingErogazione.stream().filter(m -> m.getNome().equals(mappingPA)).findFirst().orElse(null);
    }

    public static final MappingErogazionePortaApplicativa getMappingPAFilterByDescription(List<MappingErogazionePortaApplicativa> listaMappingErogazione, String descrizione) {
        return listaMappingErogazione.stream().filter(m -> m.getDescrizione().equals(descrizione)).findFirst().orElse(null);
    }

    public static AccordiServizioParteSpecificaPorteApplicativeMappingInfo getMappingInfo(String mappingPA, AccordoServizioParteSpecifica asps, AccordiServizioParteSpecificaCore apsCore) throws DriverControlStationException, DriverRegistroServiziException, DriverConfigurazioneException, DriverConfigurazioneNotFound {
        int listaMappingErogazioneSize;
        if (asps == null) {
            throw new DriverControlStationException("Param asps is null");
        }
        PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(apsCore);
        IDServizio idServizio2 = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
        List<MappingErogazionePortaApplicativa> listaMappingErogazione = apsCore.mappingServiziPorteAppList(idServizio2, asps.getId(), null);
        MappingErogazionePortaApplicativa mappingSelezionato = null;
        MappingErogazionePortaApplicativa mappingDefault = null;
        boolean paMappingSelezionatoMulti = false;
        String mappingLabel = "";
        String[] listaMappingLabels = null;
        String[] listaMappingValues = null;
        ArrayList<String> azioniOccupate = new ArrayList<String>();
        int idxConfigurazione = 0;
        int n = listaMappingErogazioneSize = listaMappingErogazione != null ? listaMappingErogazione.size() : 0;
        if (listaMappingErogazioneSize > 0) {
            mappingDefault = AccordiServizioParteSpecificaUtilities.getDefaultMappingPA(listaMappingErogazione);
            if (mappingPA != null) {
                mappingSelezionato = AccordiServizioParteSpecificaUtilities.getMappingPA(listaMappingErogazione, mappingPA);
            }
            if (mappingSelezionato == null) {
                mappingSelezionato = mappingDefault;
            }
            if (mappingSelezionato == null) {
                throw new DriverControlStationException("Mapping not found");
            }
            PortaApplicativa paMappingTmp = porteApplicativeCore.getPortaApplicativa(mappingSelezionato.getIdPortaApplicativa());
            boolean bl = paMappingSelezionatoMulti = paMappingTmp.getBehaviour() != null;
            if (!mappingSelezionato.isDefault()) {
                mappingLabel = porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa(null, null, paMappingTmp, Integer.MAX_VALUE);
            }
            listaMappingLabels = new String[listaMappingErogazioneSize];
            listaMappingValues = new String[listaMappingErogazioneSize];
            for (int i = 0; i < listaMappingErogazione.size(); ++i) {
                PortaApplicativa portaApplicativa;
                int idx;
                MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa = listaMappingErogazione.get(i);
                String nomeMappingNoDefault = null;
                PortaApplicativa paMapping = porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
                listaMappingLabels[i] = nomeMappingNoDefault = porteApplicativeCore.getLabelRegolaMappingErogazionePortaApplicativa(null, null, paMapping, 70, true);
                listaMappingValues[i] = mappingErogazionePortaApplicativa.getNome();
                if (!mappingErogazionePortaApplicativa.isDefault() && (idx = mappingErogazionePortaApplicativa.getNome().indexOf("Specific")) > -1) {
                    String idxTmp = mappingErogazionePortaApplicativa.getNome().substring(idx + "Specific".length());
                    int idxMax = -1;
                    try {
                        idxMax = Integer.parseInt(idxTmp);
                    }
                    catch (Exception e) {
                        idxMax = 0;
                    }
                    idxConfigurazione = Math.max(idxConfigurazione, idxMax);
                }
                if ((portaApplicativa = porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa())).getAzione() == null || portaApplicativa.getAzione().getAzioneDelegataList() == null) continue;
                azioniOccupate.addAll(portaApplicativa.getAzione().getAzioneDelegataList());
            }
        }
        String nomeNuovaConfigurazione = "Specific" + ++idxConfigurazione;
        AccordiServizioParteSpecificaPorteApplicativeMappingInfo mappingInfo = new AccordiServizioParteSpecificaPorteApplicativeMappingInfo();
        mappingInfo.setListaMappingErogazione(listaMappingErogazione);
        mappingInfo.setMappingSelezionato(mappingSelezionato);
        mappingInfo.setMappingDefault(mappingDefault);
        mappingInfo.setMappingLabel(mappingLabel);
        mappingInfo.setListaMappingLabels(listaMappingLabels);
        mappingInfo.setListaMappingValues(listaMappingValues);
        mappingInfo.setAzioniOccupate(azioniOccupate);
        mappingInfo.setNomeNuovaConfigurazione(nomeNuovaConfigurazione);
        mappingInfo.setPaMappingSelezionatoMulti(paMappingSelezionatoMulti);
        return mappingInfo;
    }

    public static void addAccordoServizioParteSpecificaPorteApplicative(MappingErogazionePortaApplicativa mappingDefault, MappingErogazionePortaApplicativa mappingSelezionato, String nome, String nomeGruppo, String[] azioni, String modeCreazione, String modeCreazioneConnettore, String endpointtype, String tipoconn, String autenticazioneHttp, String connettoreDebug, String url, String nomeCodaJms, String tipoJms, String initcont, String urlpgk, String provurl, String connfact, String tipoSendas, String user, String password, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String proxyEnabled, String proxyHostname, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String httpImpl, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, boolean autenticazioneToken, String tokenPolicy, List<ExtendedConnettore> listExtendedConnettore, String erogazioneAutenticazione, String erogazioneAutenticazioneOpzionale, TipoAutenticazionePrincipal erogazioneAutenticazionePrincipal, List<String> erogazioneAutenticazioneParametroList, String erogazioneAutorizzazione, String erogazioneAutorizzazioneAutenticati, String erogazioneAutorizzazioneRuoli, String erogazioneAutorizzazioneRuoliTipologia, String erogazioneAutorizzazioneRuoliMatch, String nomeSA, String erogazioneRuolo, String erogazioneSoggettoAutenticato, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken, String autorizzazioneTokenOptions, String autorizzazioneScope, String scope, String autorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String gestioneToken, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, AccordoServizioParteSpecifica asps, String protocollo, String userLogin, AccordiServizioParteSpecificaCore apsCore, AccordiServizioParteSpecificaHelper apsHelper, String nomeSAServer, String identificazioneAttributiStato, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, ConnettoreStatusParams connettoreStatusParams) throws Exception {
        if (!autenticazioneToken || nomeSA != null) {
            // empty if block
        }
        PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(apsCore);
        AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(apsCore);
        SoggettiCore soggettiCore = new SoggettiCore(apcCore);
        ServiziApplicativiCore saCore = new ServiziApplicativiCore(apsCore);
        ConfigurazioneCore confCore = new ConfigurazioneCore(apsCore);
        IDServizio idServizio2 = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
        AccordoServizioParteComuneSintetico as = null;
        org.openspcoop2.message.constants.ServiceBinding serviceBinding = null;
        if (asps != null) {
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            as = apcCore.getAccordoServizioSintetico(idAccordo);
            serviceBinding = apcCore.toMessageServiceBinding(as.getServiceBinding());
        }
        ArrayList<Object> listaOggettiDaCreare = new ArrayList<Object>();
        PortaApplicativa portaApplicativaDefault = porteApplicativeCore.getPortaApplicativa(mappingDefault.getIdPortaApplicativa());
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
        ProtocolImplementation implementation = null;
        IConfigIntegrationReader configIntegrationReader = apsCore.getConfigIntegrationReader(protocolFactory);
        PortaApplicativa portaApplicativaDaCopiare = null;
        if (modeCreazione.equals("eredita")) {
            portaApplicativaDaCopiare = porteApplicativeCore.getPortaApplicativa(mappingSelezionato.getIdPortaApplicativa());
            implementation = protocolFactory.createProtocolIntegrationConfiguration().createImplementation(configIntegrationReader, serviceBinding, idServizio2, portaApplicativaDefault, portaApplicativaDaCopiare, nome, nomeGruppo, azioni);
        } else {
            implementation = protocolFactory.createProtocolIntegrationConfiguration().createImplementation(configIntegrationReader, serviceBinding, idServizio2, portaApplicativaDefault, nome, nomeGruppo, azioni);
        }
        PortaApplicativa portaApplicativa = implementation.getPortaApplicativa();
        MappingErogazionePortaApplicativa mappingErogazione = implementation.getMapping();
        List rateLimitingPolicies = implementation.getRateLimitingPolicies();
        List allarmi = implementation.getAllarmi();
        long soggInt = soggettiCore.getIdSoggetto(idServizio2.getSoggettoErogatore().getNome(), idServizio2.getSoggettoErogatore().getTipo());
        portaApplicativa.setIdSoggetto(Long.valueOf(soggInt));
        Connettore connettore = null;
        if (ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore)) {
            connettore = new Connettore();
            if (endpointtype.equals("custom")) {
                connettore.setTipo(tipoconn);
            } else {
                connettore.setTipo(endpointtype);
            }
            apsHelper.fillConnettore(connettore, connettoreDebug, endpointtype, endpointtype, tipoconn, url, nomeCodaJms, tipoJms, user, password, initcont, urlpgk, provurl, connfact, tipoSendas, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, proxyEnabled, proxyHostname, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, httpImpl, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, tokenPolicy, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, connettoreStatusParams, listExtendedConnettore);
        }
        boolean addSpecSicurezza = false;
        if (!modeCreazione.equals("eredita")) {
            String[] splitSoggetto;
            String nomeServizioApplicativoErogatore = portaApplicativaDefault.getServizioApplicativo(0).getNome();
            if (ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore)) {
                InvocazioneCredenziali invCredenziali;
                nomeServizioApplicativoErogatore = portaApplicativa.getNome();
                ServizioApplicativo sa = new ServizioApplicativo();
                sa.setNome(nomeServizioApplicativoErogatore);
                sa.setTipologiaFruizione(TipologiaFruizione.DISABILITATO.getValue());
                sa.setTipologiaErogazione(TipologiaErogazione.TRASPARENTE.getValue());
                sa.setIdSoggetto(Long.valueOf(soggInt));
                sa.setTipoSoggettoProprietario(portaApplicativa.getTipoSoggettoProprietario());
                sa.setNomeSoggettoProprietario(portaApplicativa.getNomeSoggettoProprietario());
                RispostaAsincrona rispostaAsinc = new RispostaAsincrona();
                rispostaAsinc.setAutenticazione(InvocazioneServizioTipoAutenticazione.NONE);
                rispostaAsinc.setGetMessage(CostantiConfigurazione.DISABILITATO);
                sa.setRispostaAsincrona(rispostaAsinc);
                InvocazioneServizio invServizio = new InvocazioneServizio();
                if (ServletUtils.isCheckBoxEnabled((String)autenticazioneHttp)) {
                    invServizio.setAutenticazione(InvocazioneServizioTipoAutenticazione.BASIC);
                    invCredenziali = new InvocazioneCredenziali();
                    invCredenziali.setUser(user);
                    invCredenziali.setPassword(password);
                    invServizio.setCredenziali(invCredenziali);
                } else {
                    invServizio.setAutenticazione(InvocazioneServizioTipoAutenticazione.NONE);
                }
                invServizio.setGetMessage(CostantiConfigurazione.DISABILITATO);
                invServizio.setConnettore(connettore.mappingIntoConnettoreConfigurazione());
                if (endpointtype.equals(TipiConnettore.JMS.getNome()) && user != null && !"".equals(user) && password != null && !"".equals(password)) {
                    invServizio.setAutenticazione(InvocazioneServizioTipoAutenticazione.BASIC);
                    invCredenziali = new InvocazioneCredenziali();
                    invCredenziali.setUser(user);
                    invCredenziali.setPassword(password);
                    invServizio.setCredenziali(invCredenziali);
                }
                sa.setInvocazioneServizio(invServizio);
                listaOggettiDaCreare.add(sa);
            }
            if (StringUtils.isNotEmpty((CharSequence)nomeSAServer)) {
                portaApplicativa.setServizioApplicativoDefault(nomeServizioApplicativoErogatore);
                nomeServizioApplicativoErogatore = nomeSAServer;
            }
            IDSoggetto idSoggettoAutenticatoErogazione = null;
            if (erogazioneSoggettoAutenticato != null && !"".equals(erogazioneSoggettoAutenticato) && !"-".equals(erogazioneSoggettoAutenticato) && (splitSoggetto = erogazioneSoggettoAutenticato.split("/")) != null) {
                idSoggettoAutenticatoErogazione = new IDSoggetto();
                if (splitSoggetto.length == 2) {
                    idSoggettoAutenticatoErogazione.setTipo(splitSoggetto[0]);
                    idSoggettoAutenticatoErogazione.setNome(splitSoggetto[1]);
                } else {
                    idSoggettoAutenticatoErogazione.setNome(splitSoggetto[0]);
                }
            }
            porteApplicativeCore.configureControlloAccessiPortaApplicativa(portaApplicativa, erogazioneAutenticazione, erogazioneAutenticazioneOpzionale, erogazioneAutenticazionePrincipal, erogazioneAutenticazioneParametroList, erogazioneAutorizzazione, erogazioneAutorizzazioneAutenticati, erogazioneAutorizzazioneRuoli, erogazioneAutorizzazioneRuoliTipologia, erogazioneAutorizzazioneRuoliMatch, nomeServizioApplicativoErogatore, erogazioneRuolo, idSoggettoAutenticatoErogazione, autorizzazioneAutenticatiToken, autorizzazioneRuoliToken, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken, autorizzazioneTokenOptions, autorizzazioneScope, scope, autorizzazioneScopeMatch, allegatoXacmlPolicy, identificazioneAttributiStato, attributeAuthoritySelezionate, attributeAuthorityAttributi);
            porteApplicativeCore.configureControlloAccessiGestioneToken(portaApplicativa, gestioneToken, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, autorizzazioneTokenOptions);
        } else {
            PortaApplicativaServizioApplicativo portaApplicativaDaCopiareServizioApplicativo;
            portaApplicativa.getServizioApplicativoList().clear();
            org.openspcoop2.core.config.Connettore connettorePDClonato = null;
            InvocazioneServizioTipoAutenticazione tipoAutenticazioneClonata = null;
            InvocazioneCredenziali invocazioneCredenzialiClonata = null;
            if (!ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore) && portaApplicativaDaCopiare != null && !mappingSelezionato.isDefault() && portaApplicativaDaCopiare.getServizioApplicativoList().size() < 2 && (portaApplicativaDaCopiareServizioApplicativo = (PortaApplicativaServizioApplicativo)portaApplicativaDaCopiare.getServizioApplicativoList().get(0)).getNome().equals(portaApplicativaDaCopiare.getNome())) {
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setNome(portaApplicativaDaCopiareServizioApplicativo.getNome());
                idSA.setIdSoggettoProprietario(new IDSoggetto(portaApplicativaDaCopiare.getTipoSoggettoProprietario(), portaApplicativaDaCopiare.getNomeSoggettoProprietario()));
                ServizioApplicativo saDaCopiare = saCore.getServizioApplicativo(idSA);
                connettorePDClonato = (org.openspcoop2.core.config.Connettore)saDaCopiare.getInvocazioneServizio().getConnettore().clone();
                if (saDaCopiare.getInvocazioneServizio().getAutenticazione() != null) {
                    tipoAutenticazioneClonata = saDaCopiare.getInvocazioneServizio().getAutenticazione();
                }
                if (saDaCopiare.getInvocazioneServizio().getCredenziali() != null) {
                    invocazioneCredenzialiClonata = (InvocazioneCredenziali)saDaCopiare.getInvocazioneServizio().getCredenziali().clone();
                }
            }
            if (ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore) || connettorePDClonato != null) {
                PortaApplicativa portaApplicativaSelezionata = porteApplicativeCore.getPortaApplicativa(mappingSelezionato.getIdPortaApplicativa());
                for (Object paSADefault : portaApplicativaSelezionata.getServizioApplicativoList()) {
                    idServizioApplicativoDefault = new IDServizioApplicativo();
                    idServizioApplicativoDefault.setNome(paSADefault.getNome());
                    idServizioApplicativoDefault.setIdSoggettoProprietario(new IDSoggetto(portaApplicativaSelezionata.getTipoSoggettoProprietario(), portaApplicativaSelezionata.getNomeSoggettoProprietario()));
                    saDefault = saCore.getServizioApplicativo(idServizioApplicativoDefault);
                    sa = (ServizioApplicativo)saDefault.clone();
                    sa.setNome(portaApplicativa.getNome());
                    if (ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore)) {
                        InvocazioneCredenziali invCredenziali;
                        if (ServletUtils.isCheckBoxEnabled((String)autenticazioneHttp)) {
                            sa.getInvocazioneServizio().setAutenticazione(InvocazioneServizioTipoAutenticazione.BASIC);
                            invCredenziali = new InvocazioneCredenziali();
                            invCredenziali.setUser(user);
                            invCredenziali.setPassword(password);
                            sa.getInvocazioneServizio().setCredenziali(invCredenziali);
                        } else {
                            sa.getInvocazioneServizio().setAutenticazione(InvocazioneServizioTipoAutenticazione.NONE);
                            sa.getInvocazioneServizio().setCredenziali(null);
                        }
                        if (endpointtype.equals(TipiConnettore.JMS.getNome()) && user != null && !"".equals(user) && password != null && !"".equals(password)) {
                            sa.getInvocazioneServizio().setAutenticazione(InvocazioneServizioTipoAutenticazione.BASIC);
                            invCredenziali = new InvocazioneCredenziali();
                            invCredenziali.setUser(user);
                            invCredenziali.setPassword(password);
                            sa.getInvocazioneServizio().setCredenziali(invCredenziali);
                        }
                    } else {
                        sa.getInvocazioneServizio().setAutenticazione(tipoAutenticazioneClonata);
                        sa.getInvocazioneServizio().setCredenziali(invocazioneCredenzialiClonata);
                    }
                    if (ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore)) {
                        sa.getInvocazioneServizio().setConnettore(connettore.mappingIntoConnettoreConfigurazione());
                        sa.getInvocazioneServizio().setGetMessage(StatoFunzionalita.DISABILITATO);
                        sa.setInvocazionePorta(new InvocazionePorta());
                    } else {
                        sa.getInvocazioneServizio().setConnettore(connettorePDClonato);
                    }
                    sa.setTipo(null);
                    listaOggettiDaCreare.add(sa);
                    PortaApplicativaServizioApplicativo paSa = new PortaApplicativaServizioApplicativo();
                    paSa.setNome(sa.getNome());
                    portaApplicativa.getServizioApplicativoList().add(paSa);
                }
                if (portaApplicativaSelezionata.getServizioApplicativoDefault() != null) {
                    if (StringUtils.isNotEmpty((CharSequence)nomeSAServer)) {
                        paSAtmp = null;
                        for (PortaApplicativaServizioApplicativo paSADefault : portaApplicativa.getServizioApplicativoList()) {
                            if (!paSADefault.getNome().equals(portaApplicativa.getNome())) continue;
                            paSAtmp = paSADefault;
                            break;
                        }
                        if (paSAtmp != null) {
                            portaApplicativa.getServizioApplicativoList().remove(paSAtmp);
                            portaApplicativa.setServizioApplicativoDefault(paSAtmp.getNome());
                        }
                        paSa = new PortaApplicativaServizioApplicativo();
                        paSa.setNome(nomeSAServer);
                        portaApplicativa.getServizioApplicativoList().add(paSa);
                    } else {
                        paSAtmp = null;
                        for (PortaApplicativaServizioApplicativo paSADefault : portaApplicativa.getServizioApplicativoList()) {
                            if (!paSADefault.getNome().equals(portaApplicativa.getNome())) continue;
                            paSAtmp = paSADefault;
                            break;
                        }
                        if (paSAtmp != null) {
                            portaApplicativa.getServizioApplicativoList().remove(paSAtmp);
                        }
                        paSa = new PortaApplicativaServizioApplicativo();
                        paSa.setNome(portaApplicativa.getNome());
                        portaApplicativa.getServizioApplicativoList().add(paSa);
                        portaApplicativa.setServizioApplicativoDefault(null);
                    }
                } else if (StringUtils.isNotEmpty((CharSequence)nomeSAServer)) {
                    paSAtmp = null;
                    for (PortaApplicativaServizioApplicativo paSADefault : portaApplicativa.getServizioApplicativoList()) {
                        if (!paSADefault.getNome().equals(portaApplicativa.getNome())) continue;
                        paSAtmp = paSADefault;
                        break;
                    }
                    if (paSAtmp != null) {
                        portaApplicativa.getServizioApplicativoList().remove(paSAtmp);
                        portaApplicativa.setServizioApplicativoDefault(paSAtmp.getNome());
                        paSa = new PortaApplicativaServizioApplicativo();
                        paSa.setNome(nomeSAServer);
                        portaApplicativa.getServizioApplicativoList().add(paSa);
                    }
                }
            } else if (portaApplicativaDaCopiare.getBehaviour() != null) {
                for (PortaApplicativaServizioApplicativo paSADefault : portaApplicativaDaCopiare.getServizioApplicativoList()) {
                    paSa = new PortaApplicativaServizioApplicativo();
                    paSa.setDatiConnettore(paSADefault.getDatiConnettore());
                    paSa.setNome(paSADefault.getNome());
                    idServizioApplicativoDefault = new IDServizioApplicativo();
                    idServizioApplicativoDefault.setNome(paSADefault.getNome());
                    idServizioApplicativoDefault.setIdSoggettoProprietario(new IDSoggetto(portaApplicativaDaCopiare.getTipoSoggettoProprietario(), portaApplicativaDaCopiare.getNomeSoggettoProprietario()));
                    saDefault = saCore.getServizioApplicativo(idServizioApplicativoDefault);
                    if (!"server".equals(saDefault.getTipo())) {
                        sa = (ServizioApplicativo)saDefault.clone();
                        sa.setNome(portaApplicativa.getNome());
                        if (!apsHelper.isConnettoreDefault((PortaApplicativaServizioApplicativo)paSa)) {
                            String nuovoNomeSA = portaApplicativa.getNome() + "__SA" + apsHelper.getIdxNuovoConnettoreMultiplo(portaApplicativa);
                            sa.setNome(nuovoNomeSA);
                        }
                        paSa.setNome(sa.getNome());
                        listaOggettiDaCreare.add(sa);
                    }
                    portaApplicativa.getServizioApplicativoList().add(paSa);
                }
            } else {
                for (PortaApplicativaServizioApplicativo paSADefault : portaApplicativaDefault.getServizioApplicativoList()) {
                    paSa = new PortaApplicativaServizioApplicativo();
                    paSa.setNome(paSADefault.getNome());
                    portaApplicativa.getServizioApplicativoList().add(paSa);
                }
            }
        }
        listaOggettiDaCreare.add(portaApplicativa);
        listaOggettiDaCreare.add(mappingErogazione);
        if (rateLimitingPolicies != null && !rateLimitingPolicies.isEmpty()) {
            for (AttivazionePolicy attivazionePolicy : rateLimitingPolicies) {
                listaOggettiDaCreare.add(attivazionePolicy);
            }
        }
        ArrayList<ConfigurazioneAllarmeBean> confAllarmi = new ArrayList<ConfigurazioneAllarmeBean>();
        if (allarmi != null && !allarmi.isEmpty()) {
            for (Allarme allarme : allarmi) {
                Plugin plugin = confCore.getPlugin(TipoPlugin.ALLARME, allarme.getTipo(), false);
                ConfigurazioneAllarmeBean configurazioneAllarmeBean = new ConfigurazioneAllarmeBean(allarme, plugin);
                listaOggettiDaCreare.add(configurazioneAllarmeBean);
                confAllarmi.add(configurazioneAllarmeBean);
            }
        }
        porteApplicativeCore.performCreateOperation(userLogin, apsHelper.smista(), listaOggettiDaCreare.toArray());
        if (addSpecSicurezza) {
            porteApplicativeCore.performUpdateOperation(userLogin, apsHelper.smista(), asps);
        }
        if (!confAllarmi.isEmpty() && !ControlStationCore.isAPIMode()) {
            StringBuilder bfError = new StringBuilder();
            for (ConfigurazioneAllarmeBean allarme : confAllarmi) {
                try {
                    AllarmiUtils.notifyStateActiveThread((boolean)true, (boolean)false, (boolean)false, null, (ConfigurazioneAllarmeBean)allarme, (Logger)ControlStationCore.getLog(), (AlarmEngineConfig)apsCore.getAllarmiConfig());
                }
                catch (Exception e) {
                    if (bfError.length() > 0) {
                        bfError.append("<br/>");
                    }
                    String errorMsg = MessageFormat.format("Allarme {0} salvato correttamente nel registro, ma la notifica verso il gestore degli allarmi \u00e8 fallita: {1}", allarme.getAlias(), e.getMessage());
                    ControlStationCore.getLog().error(errorMsg, (Throwable)e);
                    bfError.append(errorMsg);
                }
            }
            if (bfError.length() > 0) {
                apsHelper.getPd().setMessage(bfError.toString());
            }
        }
    }

    public static final MappingFruizionePortaDelegata getDefaultMappingPD(List<MappingFruizionePortaDelegata> listaMappingFruizione) {
        return listaMappingFruizione.stream().filter(m -> m.isDefault()).findFirst().orElse(null);
    }

    public static final MappingFruizionePortaDelegata getMappingPD(List<MappingFruizionePortaDelegata> listaMappingFruizione, String mappingPD) {
        return listaMappingFruizione.stream().filter(m -> m.getNome().equals(mappingPD)).findFirst().orElse(null);
    }

    public static final MappingFruizionePortaDelegata getMappingPDFilterByDescription(List<MappingFruizionePortaDelegata> listaMappingFruizione, String descrizione) {
        return listaMappingFruizione.stream().filter(m -> m.getDescrizione().equals(descrizione)).findFirst().orElse(null);
    }

    public static AccordiServizioParteSpecificaFruitoriPorteDelegateMappingInfo getMappingInfo(String mappingPD, IDSoggetto idSoggettoFruitore, AccordoServizioParteSpecifica asps, AccordiServizioParteSpecificaCore apsCore) throws DriverControlStationException, DriverRegistroServiziException, DriverConfigurazioneException, DriverConfigurazioneNotFound {
        int listaMappingFruizioneSize;
        PorteDelegateCore porteDelegateCore = new PorteDelegateCore(apsCore);
        IDServizio idServizio2 = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
        long idFru = apsCore.getIdFruizioneAccordoServizioParteSpecifica(idSoggettoFruitore, idServizio2);
        List<MappingFruizionePortaDelegata> listaMappingFruizione = apsCore.serviziFruitoriMappingList(idFru, idSoggettoFruitore, idServizio2, null);
        MappingFruizionePortaDelegata mappingSelezionato = null;
        MappingFruizionePortaDelegata mappingDefault = null;
        String mappingLabel = "";
        String[] listaMappingLabels = null;
        String[] listaMappingValues = null;
        ArrayList<String> azioniOccupate = new ArrayList<String>();
        int idxConfigurazione = 0;
        int n = listaMappingFruizioneSize = listaMappingFruizione != null ? listaMappingFruizione.size() : 0;
        if (listaMappingFruizioneSize > 0) {
            mappingDefault = AccordiServizioParteSpecificaUtilities.getDefaultMappingPD(listaMappingFruizione);
            if (mappingPD != null) {
                mappingSelezionato = AccordiServizioParteSpecificaUtilities.getMappingPD(listaMappingFruizione, mappingPD);
            }
            if (mappingSelezionato == null) {
                mappingSelezionato = mappingDefault;
            }
            if (mappingSelezionato == null) {
                throw new DriverControlStationException("Mapping not found");
            }
            if (!mappingSelezionato.isDefault()) {
                PortaDelegata pdMapping = porteDelegateCore.getPortaDelegata(mappingSelezionato.getIdPortaDelegata());
                mappingLabel = porteDelegateCore.getLabelRegolaMappingFruizionePortaDelegata(null, null, pdMapping, Integer.MAX_VALUE);
            }
            listaMappingLabels = new String[listaMappingFruizioneSize];
            listaMappingValues = new String[listaMappingFruizioneSize];
            for (int i = 0; i < listaMappingFruizione.size(); ++i) {
                PortaDelegata portaDelegata;
                int idx;
                MappingFruizionePortaDelegata mappingFruizionePortaDelegata = listaMappingFruizione.get(i);
                String nomeMappingNoDefault = null;
                PortaDelegata pdMapping = porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata());
                listaMappingLabels[i] = nomeMappingNoDefault = porteDelegateCore.getLabelRegolaMappingFruizionePortaDelegata(null, null, pdMapping, 70, true);
                listaMappingValues[i] = mappingFruizionePortaDelegata.getNome();
                if (!mappingFruizionePortaDelegata.isDefault() && (idx = mappingFruizionePortaDelegata.getNome().indexOf("Specific")) > -1) {
                    String idxTmp = mappingFruizionePortaDelegata.getNome().substring(idx + "Specific".length());
                    int idxMax = -1;
                    try {
                        idxMax = Integer.parseInt(idxTmp);
                    }
                    catch (Exception e) {
                        idxMax = 0;
                    }
                    idxConfigurazione = Math.max(idxConfigurazione, idxMax);
                }
                if ((portaDelegata = porteDelegateCore.getPortaDelegata(mappingFruizionePortaDelegata.getIdPortaDelegata())).getAzione() == null || portaDelegata.getAzione().getAzioneDelegataList() == null) continue;
                azioniOccupate.addAll(portaDelegata.getAzione().getAzioneDelegataList());
            }
        }
        String nomeNuovaConfigurazione = "Specific" + ++idxConfigurazione;
        AccordiServizioParteSpecificaFruitoriPorteDelegateMappingInfo info = new AccordiServizioParteSpecificaFruitoriPorteDelegateMappingInfo();
        info.setListaMappingFruizione(listaMappingFruizione);
        info.setMappingSelezionato(mappingSelezionato);
        info.setMappingDefault(mappingDefault);
        info.setMappingLabel(mappingLabel);
        info.setListaMappingLabels(listaMappingLabels);
        info.setListaMappingValues(listaMappingValues);
        info.setAzioniOccupate(azioniOccupate);
        info.setNomeNuovaConfigurazione(nomeNuovaConfigurazione);
        return info;
    }

    public static void addAccordoServizioParteSpecificaPorteDelegate(MappingFruizionePortaDelegata mappingDefault, MappingFruizionePortaDelegata mappingSelezionato, String nome, String nomeGruppo, String[] azioni, String modeCreazione, String modeCreazioneConnettore, String endpointtype, String tipoconn, String autenticazioneHttp, String connettoreDebug, String url, String nomeCodaJms, String tipoJms, String initcont, String urlpgk, String provurl, String connfact, String tipoSendas, String user, String password, String httpsurl, String httpstipologia, boolean httpshostverify, boolean httpsTrustVerifyCert, String httpspath, String httpstipo, String httpspwd, String httpsalgoritmo, boolean httpsstato, String httpskeystore, String httpspwdprivatekeytrust, String httpspathkey, String httpstipokey, String httpspwdkey, String httpspwdprivatekey, String httpsalgoritmokey, String httpsKeyAlias, String httpsTrustStoreCRLs, String httpsTrustStoreOCSPPolicy, String httpsKeyStoreBYOKPolicy, String proxyEnabled, String proxyHostname, String proxyPort, String proxyUsername, String proxyPassword, String tempiRispostaEnabled, String tempiRispostaConnectionTimeout, String tempiRispostaReadTimeout, String tempiRispostaTempoMedioRisposta, String opzioniAvanzate, String transferMode, String transferModeChunkSize, String redirectMode, String redirectMaxHop, String httpImpl, String requestOutputFileName, String requestOutputFileNamePermissions, String requestOutputFileNameHeaders, String requestOutputFileNameHeadersPermissions, String requestOutputParentDirCreateIfNotExists, String requestOutputOverwriteIfExists, String responseInputMode, String responseInputFileName, String responseInputFileNameHeaders, String responseInputDeleteAfterRead, String responseInputWaitTime, boolean autenticazioneToken, String tokenPolicy, List<ExtendedConnettore> listExtendedConnettore, String fruizioneAutenticazione, String fruizioneAutenticazioneOpzionale, TipoAutenticazionePrincipal fruizioneAutenticazionePrincipal, List<String> fruizioneAutenticazioneParametroList, String fruizioneAutorizzazione, String fruizioneAutorizzazioneAutenticati, String fruizioneAutorizzazioneRuoli, String fruizioneAutorizzazioneRuoliTipologia, String fruizioneAutorizzazioneRuoliMatch, String fruizioneServizioApplicativo, String fruizioneRuolo, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken, String autorizzazioneTokenOptions, String autorizzazioneScope, String scope, String autorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String gestioneToken, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, IDSoggetto idSoggettoFruitore, AccordoServizioParteSpecifica asps, String userLogin, AccordiServizioParteSpecificaCore apsCore, AccordiServizioParteSpecificaHelper apsHelper, String identificazioneAttributiStato, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi, String apiKeyHeader, String apiKeyValue, String appIdHeader, String appIdValue, ConnettoreStatusParams connettoreStatusParams) throws Exception {
        if (autenticazioneHttp == null || autenticazioneToken) {
            // empty if block
        }
        PorteDelegateCore porteDelegateCore = new PorteDelegateCore(apsCore);
        AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore(apsCore);
        SoggettiCore soggettiCore = new SoggettiCore(apcCore);
        ConfigurazioneCore confCore = new ConfigurazioneCore(apsCore);
        IDServizio idServizio2 = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
        String tipoSoggettoFruitore = idSoggettoFruitore.getTipo();
        String nomeSoggettoFruitore = idSoggettoFruitore.getNome();
        AccordoServizioParteComuneSintetico as = null;
        org.openspcoop2.message.constants.ServiceBinding serviceBinding = null;
        if (asps != null) {
            IDAccordo idAccordo = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
            as = apcCore.getAccordoServizioSintetico(idAccordo);
            serviceBinding = apcCore.toMessageServiceBinding(as.getServiceBinding());
        }
        ArrayList<Object> listaOggettiDaCreare = new ArrayList<Object>();
        ArrayList<AccordoServizioParteSpecifica> listaOggettiDaModificare = new ArrayList<AccordoServizioParteSpecifica>();
        PortaDelegata portaDelegataDefault = porteDelegateCore.getPortaDelegata(mappingDefault.getIdPortaDelegata());
        String protocollo = apsCore.getProtocolloAssociatoTipoServizio(idServizio2.getTipo());
        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
        Connettore connettore = null;
        if (ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore)) {
            connettore = new Connettore();
            if (endpointtype.equals("custom")) {
                connettore.setTipo(tipoconn);
            } else {
                connettore.setTipo(endpointtype);
            }
            apsHelper.fillConnettore(connettore, connettoreDebug, endpointtype, endpointtype, tipoconn, url, nomeCodaJms, tipoJms, user, password, initcont, urlpgk, provurl, connfact, tipoSendas, httpsurl, httpstipologia, httpshostverify, httpsTrustVerifyCert, httpspath, httpstipo, httpspwd, httpsalgoritmo, httpsstato, httpskeystore, httpspwdprivatekeytrust, httpspathkey, httpstipokey, httpspwdkey, httpspwdprivatekey, httpsalgoritmokey, httpsKeyAlias, httpsTrustStoreCRLs, httpsTrustStoreOCSPPolicy, httpsKeyStoreBYOKPolicy, proxyEnabled, proxyHostname, proxyPort, proxyUsername, proxyPassword, tempiRispostaEnabled, tempiRispostaConnectionTimeout, tempiRispostaReadTimeout, tempiRispostaTempoMedioRisposta, opzioniAvanzate, transferMode, transferModeChunkSize, redirectMode, redirectMaxHop, httpImpl, requestOutputFileName, requestOutputFileNamePermissions, requestOutputFileNameHeaders, requestOutputFileNameHeadersPermissions, requestOutputParentDirCreateIfNotExists, requestOutputOverwriteIfExists, responseInputMode, responseInputFileName, responseInputFileNameHeaders, responseInputDeleteAfterRead, responseInputWaitTime, tokenPolicy, apiKeyHeader, apiKeyValue, appIdHeader, appIdValue, connettoreStatusParams, listExtendedConnettore);
        }
        IConfigIntegrationReader configIntegrationReader = apsCore.getConfigIntegrationReader(protocolFactory);
        ProtocolSubscription subscription = null;
        PortaDelegata portaDelegataDaCopiare = null;
        if (modeCreazione.equals("eredita")) {
            portaDelegataDaCopiare = porteDelegateCore.getPortaDelegata(mappingSelezionato.getIdPortaDelegata());
            subscription = protocolFactory.createProtocolIntegrationConfiguration().createSubscription(configIntegrationReader, serviceBinding, idSoggettoFruitore, idServizio2, portaDelegataDefault, portaDelegataDaCopiare, nome, nomeGruppo, azioni);
        } else {
            subscription = protocolFactory.createProtocolIntegrationConfiguration().createSubscription(configIntegrationReader, serviceBinding, idSoggettoFruitore, idServizio2, portaDelegataDefault, nome, nomeGruppo, azioni);
        }
        boolean clonatoDaPDConConnettoreRidefinito = false;
        if (!ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore) && portaDelegataDaCopiare != null && portaDelegataDaCopiare.getAzione() != null && PortaDelegataAzioneIdentificazione.DELEGATED_BY.equals((Object)portaDelegataDaCopiare.getAzione().getIdentificazione())) {
            String azioneConnettoreDaPortaDelegataDaClonare = null;
            if (portaDelegataDaCopiare.getAzione().sizeAzioneDelegataList() > 0) {
                azioneConnettoreDaPortaDelegataDaClonare = portaDelegataDaCopiare.getAzione().getAzioneDelegata(0);
            }
            Connettore connettorePortaDelegataDaClonare = null;
            Fruitore fruitore = null;
            if (azioneConnettoreDaPortaDelegataDaClonare != null) {
                for (Fruitore fruitoreCheck : asps.getFruitoreList()) {
                    if (!fruitoreCheck.getTipo().equals(tipoSoggettoFruitore) || !fruitoreCheck.getNome().equals(nomeSoggettoFruitore)) continue;
                    fruitore = fruitoreCheck;
                    break;
                }
                if (fruitore != null) {
                    for (ConfigurazioneServizioAzione check : fruitore.getConfigurazioneAzioneList()) {
                        if (!check.getAzioneList().contains(azioneConnettoreDaPortaDelegataDaClonare)) continue;
                        connettorePortaDelegataDaClonare = check.getConnettore();
                        break;
                    }
                }
            }
            if (connettorePortaDelegataDaClonare != null) {
                clonatoDaPDConConnettoreRidefinito = true;
                Connettore newConnettoreRidefinito = (Connettore)connettorePortaDelegataDaClonare.clone();
                ConfigurazioneServizioAzione configurazioneAzione = new ConfigurazioneServizioAzione();
                configurazioneAzione.setConnettore(newConnettoreRidefinito);
                for (int i = 0; i < azioni.length; ++i) {
                    configurazioneAzione.addAzione(azioni[i]);
                }
                fruitore.addConfigurazioneAzione(configurazioneAzione);
            }
        }
        if (ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore)) {
            Fruitore fruitore = null;
            for (Fruitore fruitoreCheck : asps.getFruitoreList()) {
                if (!fruitoreCheck.getTipo().equals(tipoSoggettoFruitore) || !fruitoreCheck.getNome().equals(nomeSoggettoFruitore)) continue;
                fruitore = fruitoreCheck;
                break;
            }
            ConfigurazioneServizioAzione configurazioneAzione = new ConfigurazioneServizioAzione();
            configurazioneAzione.setConnettore(connettore);
            for (int i = 0; i < azioni.length; ++i) {
                configurazioneAzione.addAzione(azioni[i]);
            }
            if (fruitore != null) {
                fruitore.addConfigurazioneAzione(configurazioneAzione);
            }
        }
        PortaDelegata portaDelegata = subscription.getPortaDelegata();
        MappingFruizionePortaDelegata mappingFruizione = subscription.getMapping();
        List rateLimitingPolicies = subscription.getRateLimitingPolicies();
        List allarmi = subscription.getAllarmi();
        long idSoggFru = soggettiCore.getIdSoggetto(nomeSoggettoFruitore, tipoSoggettoFruitore);
        portaDelegata.setIdSoggetto(Long.valueOf(idSoggFru));
        if (!modeCreazione.equals("eredita")) {
            porteDelegateCore.configureControlloAccessiPortaDelegata(portaDelegata, fruizioneAutenticazione, fruizioneAutenticazioneOpzionale, fruizioneAutenticazionePrincipal, fruizioneAutenticazioneParametroList, fruizioneAutorizzazione, fruizioneAutorizzazioneAutenticati, fruizioneAutorizzazioneRuoli, fruizioneAutorizzazioneRuoliTipologia, fruizioneAutorizzazioneRuoliMatch, fruizioneServizioApplicativo, fruizioneRuolo, autorizzazioneAutenticatiToken, autorizzazioneRuoliToken, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken, autorizzazioneTokenOptions, autorizzazioneScope, scope, autorizzazioneScopeMatch, allegatoXacmlPolicy, identificazioneAttributiStato, attributeAuthoritySelezionate, attributeAuthorityAttributi);
            porteDelegateCore.configureControlloAccessiGestioneToken(portaDelegata, gestioneToken, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, autenticazioneTokenIssuer, autenticazioneTokenClientId, autenticazioneTokenSubject, autenticazioneTokenUsername, autenticazioneTokenEMail, autorizzazioneTokenOptions);
        }
        listaOggettiDaCreare.add(portaDelegata);
        listaOggettiDaCreare.add(mappingFruizione);
        if (rateLimitingPolicies != null && !rateLimitingPolicies.isEmpty()) {
            for (AttivazionePolicy attivazionePolicy : rateLimitingPolicies) {
                listaOggettiDaCreare.add(attivazionePolicy);
            }
        }
        ArrayList<ConfigurazioneAllarmeBean> confAllarmi = new ArrayList<ConfigurazioneAllarmeBean>();
        if (allarmi != null && !allarmi.isEmpty()) {
            for (Allarme allarme : allarmi) {
                Plugin plugin = confCore.getPlugin(TipoPlugin.ALLARME, allarme.getTipo(), false);
                ConfigurazioneAllarmeBean configurazioneAllarmeBean = new ConfigurazioneAllarmeBean(allarme, plugin);
                listaOggettiDaCreare.add(configurazioneAllarmeBean);
                confAllarmi.add(configurazioneAllarmeBean);
            }
        }
        porteDelegateCore.performCreateOperation(userLogin, apsHelper.smista(), listaOggettiDaCreare.toArray());
        if (ServletUtils.isCheckBoxEnabled((String)modeCreazioneConnettore) || clonatoDaPDConConnettoreRidefinito) {
            listaOggettiDaModificare.add(asps);
        }
        if (!listaOggettiDaModificare.isEmpty()) {
            porteDelegateCore.performUpdateOperation(userLogin, apsHelper.smista(), listaOggettiDaModificare.toArray());
        }
        if (!confAllarmi.isEmpty() && !ControlStationCore.isAPIMode()) {
            StringBuilder bfError = new StringBuilder();
            for (ConfigurazioneAllarmeBean allarme : confAllarmi) {
                try {
                    AllarmiUtils.notifyStateActiveThread((boolean)true, (boolean)false, (boolean)false, null, (ConfigurazioneAllarmeBean)allarme, (Logger)ControlStationCore.getLog(), (AlarmEngineConfig)apsCore.getAllarmiConfig());
                }
                catch (Exception e) {
                    if (bfError.length() > 0) {
                        bfError.append("<br/>");
                    }
                    String errorMsg = MessageFormat.format("Allarme {0} salvato correttamente nel registro, ma la notifica verso il gestore degli allarmi \u00e8 fallita: {1}", allarme.getAlias(), e.getMessage());
                    ControlStationCore.getLog().error(errorMsg, (Throwable)e);
                    bfError.append(errorMsg);
                }
            }
            if (bfError.length() > 0) {
                apsHelper.getPd().setMessage(bfError.toString());
            }
        }
    }

    public static void deleteAccordoServizioParteSpecificaAllegati(AccordoServizioParteSpecifica asps, String userLogin, AccordiServizioParteSpecificaCore apsCore, AccordiServizioParteSpecificaHelper apsHelper, List<Long> idAllegati) throws Exception {
        ArchiviCore archiviCore = new ArchiviCore(apsCore);
        block7: for (int i = 0; i < idAllegati.size(); ++i) {
            long idAllegato = idAllegati.get(i);
            Documento doc = archiviCore.getDocumento(idAllegato, false);
            switch (RuoliDocumento.valueOf((String)doc.getRuolo())) {
                case allegato: {
                    Documento documento;
                    int j;
                    for (j = 0; j < asps.sizeAllegatoList(); ++j) {
                        documento = asps.getAllegato(j);
                        if (!documento.getFile().equals(doc.getFile())) continue;
                        asps.removeAllegato(j);
                        continue block7;
                    }
                    continue block7;
                }
                case specificaSemiformale: {
                    Documento documento;
                    int j;
                    for (j = 0; j < asps.sizeSpecificaSemiformaleList(); ++j) {
                        documento = asps.getSpecificaSemiformale(j);
                        if (!documento.getFile().equals(doc.getFile())) continue;
                        asps.removeSpecificaSemiformale(j);
                        continue block7;
                    }
                    continue block7;
                }
                case specificaCoordinamento: {
                    continue block7;
                }
                case specificaSicurezza: {
                    Documento documento;
                    int j;
                    for (j = 0; j < asps.sizeSpecificaSicurezzaList(); ++j) {
                        documento = asps.getSpecificaSicurezza(j);
                        if (!documento.getFile().equals(doc.getFile())) continue;
                        asps.removeSpecificaSicurezza(j);
                        continue block7;
                    }
                    continue block7;
                }
                case specificaLivelloServizio: {
                    Documento documento;
                    int j;
                    for (j = 0; j < asps.sizeSpecificaLivelloServizioList(); ++j) {
                        documento = asps.getSpecificaLivelloServizio(j);
                        if (!documento.getFile().equals(doc.getFile())) continue;
                        asps.removeSpecificaLivelloServizio(j);
                        continue block7;
                    }
                    continue block7;
                }
            }
        }
        apsCore.performUpdateOperation(userLogin, apsHelper.smista(), asps);
    }

    public static void sostituisciDocumentoAsps(AccordoServizioParteSpecifica asps, Documento doc, Documento toCheck) {
        switch (RuoliDocumento.valueOf((String)doc.getRuolo())) {
            case allegato: {
                for (int i = 0; i < asps.sizeAllegatoList(); ++i) {
                    Documento documento = asps.getAllegato(i);
                    if (!documento.getId().equals(doc.getId())) continue;
                    asps.removeAllegato(i);
                    break;
                }
                asps.addAllegato(toCheck);
                break;
            }
            case specificaSemiformale: {
                for (int i = 0; i < asps.sizeSpecificaSemiformaleList(); ++i) {
                    Documento documento = asps.getSpecificaSemiformale(i);
                    if (!documento.getId().equals(doc.getId())) continue;
                    asps.removeSpecificaSemiformale(i);
                    break;
                }
                asps.addSpecificaSemiformale(toCheck);
                break;
            }
            case specificaSicurezza: {
                for (int i = 0; i < asps.sizeSpecificaSicurezzaList(); ++i) {
                    Documento documento = asps.getSpecificaSicurezza(i);
                    if (!documento.getId().equals(doc.getId())) continue;
                    asps.removeSpecificaSicurezza(i);
                    break;
                }
                asps.addSpecificaSicurezza(toCheck);
                break;
            }
            case specificaLivelloServizio: {
                for (int i = 0; i < asps.sizeSpecificaLivelloServizioList(); ++i) {
                    Documento documento = asps.getSpecificaLivelloServizio(i);
                    if (!documento.getId().equals(doc.getId())) continue;
                    asps.removeSpecificaLivelloServizio(i);
                    break;
                }
                asps.addSpecificaLivelloServizio(toCheck);
                break;
            }
        }
    }

    public static boolean alreadyExists(AccordiServizioParteSpecificaCore apsCore, AccordiServizioParteSpecificaHelper apsHelper, long idSoggettoErogatore, IDServizio idAccordoServizioParteSpecifica, String uriAccordoServizioParteComune, String tipoFruitore, String nomeFruitore, String protocollo, String profilo, String portType, boolean gestioneFruitori, boolean gestioneErogatori, StringBuilder inUsoMessage) throws DriverControlStationException, DriverRegistroServiziException, DriverRegistroServiziNotFound, DriverConfigurazioneException {
        PorteApplicativeCore porteApplicativeCore = new PorteApplicativeCore(apsCore);
        IDAccordoFactory idAccordoFactory = IDAccordoFactory.getInstance();
        String tiposervizio = idAccordoServizioParteSpecifica.getTipo();
        String nomeservizio = idAccordoServizioParteSpecifica.getNome();
        Integer versioneInt = idAccordoServizioParteSpecifica.getVersione();
        String tipoErogatore = idAccordoServizioParteSpecifica.getSoggettoErogatore().getTipo();
        String nomeErogatore = idAccordoServizioParteSpecifica.getSoggettoErogatore().getNome();
        if (apsCore.existServizio(nomeservizio, tiposervizio, versioneInt, idSoggettoErogatore) > 0L) {
            String labelServizio = apsHelper.getLabelNomeServizio(protocollo, tiposervizio, nomeservizio, versioneInt);
            String labelSoggetto = apsHelper.getLabelNomeSoggetto(protocollo, tipoErogatore, nomeErogatore);
            AccordoServizioParteSpecifica asps = apsCore.getServizio(idAccordoServizioParteSpecifica, false);
            if (gestioneFruitori || gestioneErogatori) {
                String uriApc = asps.getAccordoServizioParteComune();
                if (!uriAccordoServizioParteComune.equals(uriApc)) {
                    String msg = "Esiste gi&agrave; una fruizione o erogazione del servizio {0} erogato dal Soggetto {1} che implementa una API differente: {2}";
                    msg = MessageFormat.format(msg, labelServizio, labelSoggetto, apsHelper.getLabelIdAccordo(idAccordoFactory.getIDAccordoFromUri(uriApc)));
                    inUsoMessage.append(msg);
                    return true;
                }
                if (!(profilo == null || "".equals(profilo) || "-".equals(profilo) || profilo.equals(asps.getVersioneProtocollo()))) {
                    String msg = "Esiste gi&agrave; una fruizione o erogazione del servizio {0} erogato dal Soggetto {1} configurata con una versione di protocollo differente: {2}";
                    msg = MessageFormat.format(msg, labelServizio, labelSoggetto, asps.getVersioneProtocollo() == null ? "usa versione erogatore" : asps.getVersioneProtocollo());
                    inUsoMessage.append(msg);
                    return true;
                }
                if (!(portType == null || "".equals(portType) || "-".equals(portType) || portType.equals(asps.getPortType()))) {
                    String msg = "Esiste gi&agrave; una fruizione o erogazione del servizio {0} erogato dal Soggetto {1} che implementa un servizio differente: {2}";
                    msg = MessageFormat.format(msg, labelServizio, labelSoggetto, asps.getPortType() == null ? "Nessun Servizio" : asps.getPortType());
                    inUsoMessage.append(msg);
                    return true;
                }
            }
            String msg = null;
            if (gestioneFruitori) {
                boolean found = false;
                for (Fruitore fruitore : asps.getFruitoreList()) {
                    if (!fruitore.getTipo().equals(tipoFruitore) || !fruitore.getNome().equals(nomeFruitore)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    String labelSoggettoFruitore = apsHelper.getLabelNomeSoggetto(protocollo, tipoFruitore, nomeFruitore);
                    msg = "Esiste gi&agrave; una fruizione, da parte del Soggetto {0}, del servizio {1} erogato dal Soggetto {2}";
                    msg = MessageFormat.format(msg, labelSoggettoFruitore, labelServizio, labelSoggetto);
                }
            } else if (gestioneErogatori) {
                List<IDPortaApplicativa> l = porteApplicativeCore.getIDPorteApplicativeAssociate(idAccordoServizioParteSpecifica);
                if (l != null && !l.isEmpty()) {
                    msg = "Esiste gi&agrave; una erogazione del servizio {0} erogato dal Soggetto {1}";
                    msg = MessageFormat.format(msg, labelServizio, labelSoggetto);
                }
            } else {
                msg = "Esiste gi&agrave; una erogazione del servizio {0} erogato dal Soggetto {1}";
                msg = MessageFormat.format(msg, labelServizio, labelSoggetto);
            }
            if (msg != null) {
                inUsoMessage.append(msg);
                return true;
            }
        }
        return false;
    }
}

