/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.aps;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaHelper;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.slf4j.Logger;

public final class AccordiServizioParteSpecificaList
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        try {
            AccordiServizioParteSpecificaHelper apsHelper = new AccordiServizioParteSpecificaHelper(request, pd, session);
            apsHelper.makeMenu();
            ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, null, (String)"_tabKey_vistaErogazioni");
            AccordiServizioParteSpecificaCore apsCore = new AccordiServizioParteSpecificaCore();
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            int idLista = Liste.SERVIZI;
            ricerca = apsHelper.checkSearchParameters(idLista, ricerca);
            String tipologia = apsHelper.getParameter("_tabKey_tipologiaErogazione");
            if (tipologia == null) {
                tipologia = (String)ServletUtils.getObjectFromSession((HttpServletRequest)request, (HttpSession)session, String.class, (String)"_tabKey_tipologiaErogazione");
            }
            boolean gestioneFruitori = false;
            boolean gestioneErogatori = false;
            if (tipologia != null) {
                if ("erogazione".equals(tipologia)) {
                    ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)"erogazione", (String)"_tabKey_tipologiaErogazione");
                    ricerca.addFilter(idLista, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE);
                    gestioneErogatori = true;
                } else if ("fruizione".equals(tipologia)) {
                    ServletUtils.setObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (Object)"fruizione", (String)"_tabKey_tipologiaErogazione");
                    boolean filtraSoloEsterni = true;
                    if (apsCore.isMultitenant() && apsCore.getMultitenantSoggettiFruizioni() != null) {
                        switch (apsCore.getMultitenantSoggettiFruizioni()) {
                            case SOLO_SOGGETTI_ESTERNI: {
                                filtraSoloEsterni = true;
                                break;
                            }
                            case ESCLUDI_SOGGETTO_FRUITORE: 
                            case TUTTI: {
                                filtraSoloEsterni = false;
                            }
                        }
                    }
                    if (filtraSoloEsterni) {
                        ricerca.addFilter(idLista, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE);
                    }
                    gestioneFruitori = true;
                } else if ("completa".equals(tipologia)) {
                    ServletUtils.removeObjectFromSession((HttpServletRequest)request, (HttpSession)session, (String)"_tabKey_tipologiaErogazione");
                }
            }
            String superUser = ServletUtils.getUserLoginFromSession((HttpSession)session);
            PermessiUtente pu = ServletUtils.getUserFromSession((HttpServletRequest)request, (HttpSession)session).getPermessi();
            boolean[] permessi = new boolean[]{pu.isServizi(), pu.isAccordiCooperazione()};
            List<AccordoServizioParteSpecifica> lista = null;
            lista = apsCore.isVisioneOggettiGlobale(superUser) ? apsCore.soggettiServizioList(null, (ISearch)ricerca, permessi, gestioneFruitori, gestioneErogatori) : apsCore.soggettiServizioList(superUser, (ISearch)ricerca, permessi, gestioneFruitori, gestioneErogatori);
            apsHelper.prepareServiziList((ISearch)ricerca, lista);
            String msg = apsHelper.getParameter("errorExport");
            if (msg != null && !"".equals(msg)) {
                pd.setMessage("Errore durante esportazione: " + msg);
            }
            ServletUtils.setSearchObjectIntoSession((HttpServletRequest)request, (HttpSession)session, (ISearch)ricerca);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForward((ActionMapping)mapping, (String)"accordiServizioParteSpecifica", (ForwardParams)ForwardParams.LIST());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteSpecifica", (ForwardParams)ForwardParams.LIST());
        }
    }
}

