/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.apc;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.IdSoggetto;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.ResourceRepresentation;
import org.openspcoop2.core.registry.ResourceRepresentationJson;
import org.openspcoop2.core.registry.ResourceRepresentationXml;
import org.openspcoop2.core.registry.ResourceRequest;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.core.registry.constants.RepresentationType;
import org.openspcoop2.core.registry.constants.RepresentationXmlType;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.utils.rest.api.ApiResponse;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneHelper;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneUtilities;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public final class AccordiServizioParteComuneResourcesRepresentationChange
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        TipoOperazione tipoOp = TipoOperazione.CHANGE;
        try {
            AccordiServizioParteComuneHelper apcHelper = new AccordiServizioParteComuneHelper(request, pd, session);
            apcHelper.makeMenu();
            AccordiServizioParteComuneCore apcCore = new AccordiServizioParteComuneCore();
            SoggettiCore soggettiCore = new SoggettiCore(apcCore);
            String editMode = apcHelper.getParametroEditMode("edit-mode");
            String id = apcHelper.getParametroLong("id");
            long idAccordoLong = Long.parseLong(id);
            String nomeRisorsa = apcHelper.getParameter("nomeRs");
            if (nomeRisorsa == null) {
                nomeRisorsa = "";
            }
            String statusS = apcHelper.getParametroInteger("statusResRisposta");
            Integer status = null;
            try {
                if (statusS != null) {
                    status = Integer.parseInt(statusS);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String isReq = apcHelper.getParametroBoolean("req");
            boolean isRequest = ServletUtils.isCheckBoxEnabled((String)isReq);
            String descr = apcHelper.getParameter("descrResRepres");
            if (descr == null) {
                descr = "";
            }
            String idRep = apcHelper.getParameter("idResRepres");
            int idRepInt = Integer.parseInt(idRep);
            String messageProcessorS = apcHelper.getParameter("messageTypeResRepres");
            MessageType messageType = StringUtils.isNotEmpty((CharSequence)messageProcessorS) && !messageProcessorS.equals("D") ? MessageType.valueOf((String)messageProcessorS) : null;
            String mediaType = apcHelper.getParameter("mediaTypeResRepres");
            String tipoS = apcHelper.getParameter("tipoResRepres");
            RepresentationType tipo = StringUtils.isNotEmpty((CharSequence)tipoS) && !messageProcessorS.equals("nd") ? RepresentationType.toEnumConstant((String)tipoS) : null;
            String nome = apcHelper.getParameter("nomeResRepres");
            String tipoJson = apcHelper.getParameter("jsonTypeResRepres");
            String namespaceXml = apcHelper.getParameter("xmlNamespaceResRepres");
            String nomeXml = apcHelper.getParameter("xmlNameResRepres");
            String xmlTypeS = apcHelper.getParameter("xmlTipoResRepres");
            RepresentationXmlType xmlType = StringUtils.isNotEmpty((CharSequence)xmlTypeS) ? RepresentationXmlType.toEnumConstant((String)xmlTypeS) : null;
            String tipoAccordo = apcHelper.getParameter("tipoAccordo");
            if ("".equals(tipoAccordo)) {
                tipoAccordo = null;
            }
            AccordoServizioParteComune as = apcCore.getAccordoServizioFull(idAccordoLong);
            String labelASTitle = apcHelper.getLabelIdAccordo(as);
            String protocollo = null;
            IdSoggetto soggettoReferente = as.getSoggettoReferente();
            String tipoSoggettoReferente = soggettoReferente.getTipo();
            protocollo = soggettiCore.getProtocolloAssociatoTipoSoggetto(tipoSoggettoReferente);
            ServiceBinding serviceBinding = apcCore.toMessageServiceBinding(as.getServiceBinding());
            IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
            Resource risorsa = null;
            for (int j = 0; j < as.sizeResourceList() && !nomeRisorsa.equals((risorsa = as.getResource(j)).getNome()); ++j) {
            }
            if (risorsa == null) {
                throw new Exception("Risorsa con nome '" + nomeRisorsa + "' non trovata nell'accordo con id '" + idAccordoLong + "'");
            }
            Long idResponse = null;
            Long idResource = null;
            ResourceRequest resourceRequest = null;
            ResourceResponse resourceResponse = null;
            ResourceRepresentation resourceRepresentationOLD = null;
            List representationList = null;
            if (isRequest) {
                resourceRequest = risorsa.getRequest();
                idResource = risorsa.getId();
                if (resourceRequest != null) {
                    representationList = resourceRequest.getRepresentationList();
                }
            } else if (risorsa.getResponseList() != null) {
                for (int i = 0; i < risorsa.getResponseList().size(); ++i) {
                    resourceResponse = risorsa.getResponse(i);
                    if (resourceResponse.getStatus() != status.intValue()) continue;
                    idResponse = resourceResponse.getId();
                    break;
                }
                if (resourceResponse != null) {
                    representationList = resourceResponse.getRepresentationList();
                }
            }
            String oldMediaType = null;
            if (representationList != null && !representationList.isEmpty()) {
                for (ResourceRepresentation resourceRepresentation : representationList) {
                    if (resourceRepresentation.getId().intValue() != idRepInt) continue;
                    resourceRepresentationOLD = resourceRepresentation;
                    break;
                }
            }
            if (resourceRepresentationOLD != null) {
                oldMediaType = resourceRepresentationOLD.getMediaType();
            }
            Parameter pTipoAccordo = AccordiServizioParteComuneUtilities.getParametroAccordoServizio(tipoAccordo);
            Parameter pIdAccordo = new Parameter("id", id);
            Parameter pNomeRisorsa = new Parameter("nomeRs", risorsa.getNome());
            Parameter pIsRequest = new Parameter("req", "" + isRequest);
            Parameter pIdRisorsa = new Parameter("idRs", "" + risorsa.getId());
            Parameter pResponseStatus = new Parameter("statusResRisposta", statusS);
            Boolean isModalitaVistaApiCustom = ServletUtils.getBooleanAttributeFromSession((String)"vistaApi", (HttpSession)session, (HttpServletRequest)request, (Boolean)false).getValue();
            List<Parameter> listaParams = apcHelper.getTitoloApc(TipoOperazione.CHANGE, as, tipoAccordo, labelASTitle, null, false);
            String labelRisorse = isModalitaVistaApiCustom != null && isModalitaVistaApiCustom != false ? "Risorse" : "Risorse di " + labelASTitle;
            listaParams.add(new Parameter(labelRisorse, "accordiServizioParteComuneResourcesList.do", new Parameter[]{pIdAccordo, pTipoAccordo}));
            String labelRisorsa = NamingUtils.getLabelResource((Resource)risorsa);
            listaParams.add(new Parameter(labelRisorsa, "accordiServizioParteComuneResourcesChange.do", new Parameter[]{pIdAccordo, pTipoAccordo, pIdRisorsa}));
            if (!isRequest) {
                String labelResponse = "Risposte";
                listaParams.add(new Parameter(labelResponse, "accordiServizioParteComuneResourcesRisposteList.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa}));
                String labelRisposta = "HTTP Status " + (ApiResponse.isDefaultHttpReturnCode((int)status) ? "Default" : statusS);
                listaParams.add(new Parameter(labelRisposta, "accordiServizioParteComuneResourcesRisposteChange.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa, pResponseStatus}));
            }
            String labelRepresentation = "Rappresentazione";
            listaParams.add(new Parameter(labelRepresentation, "accordiServizioParteComuneResourcesRepresentationList.do", new Parameter[]{pIdAccordo, pTipoAccordo, pNomeRisorsa, pIsRequest, pResponseStatus}));
            listaParams.add(new Parameter(oldMediaType, null));
            if (ServletUtils.isEditModeInProgress((String)editMode)) {
                ServletUtils.setPageDataTitle((PageData)pd, listaParams);
                if (mediaType == null) {
                    mediaType = resourceRepresentationOLD.getMediaType();
                    descr = resourceRepresentationOLD.getDescrizione();
                    nome = resourceRepresentationOLD.getNome();
                    messageType = apcCore.toMessageMessageType(resourceRepresentationOLD.getMessageType());
                    tipo = resourceRepresentationOLD.getRepresentationType();
                    if (tipo != null) {
                        switch (tipo) {
                            case JSON: {
                                ResourceRepresentationJson json = resourceRepresentationOLD.getJson();
                                tipoJson = json.getTipo();
                                break;
                            }
                            default: {
                                ResourceRepresentationXml xml = resourceRepresentationOLD.getXml();
                                namespaceXml = xml.getNamespace();
                                nomeXml = xml.getNome();
                                xmlType = xml.getXmlType();
                            }
                        }
                    }
                }
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = apcHelper.addAccordiResourceRepresentationToDati(tipoOp, dati, id, as.getStatoPackage(), tipoAccordo, protocollo, protocolFactory, serviceBinding, nomeRisorsa, isRequest, statusS, idRepInt, mediaType, nome, descr, messageType, tipo, tipoJson, nomeXml, namespaceXml, xmlType);
                pd.setDati(dati);
                if (apcHelper.isModalitaStandard() || apcHelper.isShowGestioneWorkflowStatoDocumenti() && StatiAccordo.finale.toString().equals(as.getStatoPackage())) {
                    pd.disableEditMode();
                }
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeInProgress((ActionMapping)mapping, (String)"accordiServizioParteComuneResourcesRepresentation", (ForwardParams)ForwardParams.CHANGE());
            }
            boolean isOk = apcHelper.accordiResourceRepresentationCheckData(tipoOp, id, nomeRisorsa, isRequest, statusS, mediaType, nome, descr, messageType, tipo, tipoJson, nomeXml, namespaceXml, xmlType, idResource, idResponse, oldMediaType);
            if (!isOk) {
                ServletUtils.setPageDataTitle((PageData)pd, listaParams);
                List<DataElement> dati = new ArrayList<DataElement>();
                dati.add(ServletUtils.getDataElementForEditModeFinished());
                dati = apcHelper.addAccordiResourceRepresentationToDati(tipoOp, dati, id, as.getStatoPackage(), tipoAccordo, protocollo, protocolFactory, serviceBinding, nomeRisorsa, isRequest, statusS, idRepInt, mediaType, nome, descr, messageType, tipo, tipoJson, nomeXml, namespaceXml, xmlType);
                pd.setDati(dati);
                ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
                return ServletUtils.getStrutsForwardEditModeCheckError((ActionMapping)mapping, (String)"accordiServizioParteComuneResourcesRepresentation", (ForwardParams)ForwardParams.CHANGE());
            }
            ResourceRepresentation newRepresentation = new ResourceRepresentation();
            newRepresentation.setMessageType(apcCore.fromMessageMessageType(messageType));
            newRepresentation.setDescrizione(descr);
            newRepresentation.setNome(nome);
            newRepresentation.setMediaType(mediaType);
            newRepresentation.setRepresentationType(tipo);
            if (tipo != null) {
                switch (tipo) {
                    case JSON: {
                        ResourceRepresentationJson json = new ResourceRepresentationJson();
                        json.setTipo(tipoJson);
                        newRepresentation.setJson(json);
                        break;
                    }
                    case XML: {
                        ResourceRepresentationXml xml = new ResourceRepresentationXml();
                        xml.setXmlType(xmlType);
                        xml.setNome(nomeXml);
                        xml.setNamespace(namespaceXml);
                        newRepresentation.setXml(xml);
                        break;
                    }
                }
            }
            int idx = -1;
            if (representationList != null && !representationList.isEmpty()) {
                for (int i = 0; i < representationList.size(); ++i) {
                    ResourceRepresentation resourceRepresentation = (ResourceRepresentation)representationList.get(i);
                    if (resourceRepresentation.getId().intValue() != idRepInt) continue;
                    idx = i;
                    break;
                }
                if (idx > -1) {
                    representationList.remove(idx);
                    representationList.add(idx, newRepresentation);
                }
            }
            apcCore.performUpdateOperation(userLogin, apcHelper.smista(), as);
            as = apcCore.getAccordoServizioFull(idAccordoLong);
            ConsoleSearch ricerca = (ConsoleSearch)ServletUtils.getSearchObjectFromSession((HttpServletRequest)request, (HttpSession)session, ConsoleSearch.class);
            risorsa = null;
            for (int j = 0; j < as.sizeResourceList() && !nomeRisorsa.equals((risorsa = as.getResource(j)).getNome()); ++j) {
            }
            if (risorsa == null) {
                throw new Exception("Risorsa con nome '" + nomeRisorsa + "' non trovata nell'accordo con id '" + idAccordoLong + "'");
            }
            idResponse = null;
            idResource = null;
            resourceRequest = null;
            resourceResponse = null;
            if (isRequest) {
                resourceRequest = risorsa.getRequest();
                idResource = risorsa.getId();
            } else if (risorsa.getResponseList() != null) {
                for (int i = 0; i < risorsa.getResponseList().size(); ++i) {
                    resourceResponse = risorsa.getResponse(i);
                    if (resourceResponse.getStatus() != status.intValue()) continue;
                    idResponse = resourceResponse.getId();
                    break;
                }
            }
            List<ResourceRepresentation> lista = apcCore.accordiResourceRepresentationsList(idResource, isRequest, idResponse, (ISearch)ricerca);
            apcHelper.prepareAccordiResourcesRepresentationsList(id, as, lista, ricerca, tipoAccordo, isRequest, risorsa, resourceRequest, resourceResponse);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"accordiServizioParteComuneResourcesRepresentation", (ForwardParams)ForwardParams.CHANGE());
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"accordiServizioParteComuneResourcesRepresentation", (ForwardParams)ForwardParams.CHANGE());
        }
    }
}

