/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet.about;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.govway.struts.action.Action;
import org.govway.struts.action.ActionForm;
import org.govway.struts.action.ActionForward;
import org.govway.struts.action.ActionMapping;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.servlet.GeneralHelper;
import org.openspcoop2.web.ctrlstat.servlet.about.AboutCostanti;
import org.openspcoop2.web.ctrlstat.servlet.about.AboutHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.ForwardParams;
import org.openspcoop2.web.lib.mvc.GeneralData;
import org.openspcoop2.web.lib.mvc.MessageType;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.slf4j.Logger;

public class About
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        PageData pd = new PageData();
        GeneralHelper generalHelper = new GeneralHelper(session);
        GeneralData gd = generalHelper.initGeneralData(request);
        String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)session);
        try {
            AboutHelper aHelper = new AboutHelper(request, pd, session);
            aHelper.makeMenu();
            ArrayList<Parameter> lstParam = new ArrayList<Parameter>();
            lstParam.add(new Parameter("Informazioni", null));
            ServletUtils.setPageDataTitle((PageData)pd, lstParam);
            List<DataElement> dati = new ArrayList<DataElement>();
            BinaryParameter infoP = aHelper.getBinaryParameter("info");
            String infoDone = aHelper.getParametroBoolean("infoFinish");
            boolean doUpdate = ServletUtils.isCheckBoxEnabled((String)infoDone);
            Object aggiornamentoNonRiuscito = null;
            String aggiornamentoEffettuato = null;
            if (doUpdate) {
                if (infoP.getValue() != null) {
                    try {
                        aHelper.getCore().updateInfoVersion(request, session, infoP.getValue());
                        aggiornamentoEffettuato = "Aggiornamento completato con successo";
                        gd.setTitle(StringEscapeUtils.escapeHtml4((String)aHelper.getCore().getConsoleNomeEsteso(request, session)));
                    }
                    catch (Exception e) {
                        aggiornamentoNonRiuscito = "Aggiornamento fallito: " + e.getMessage();
                    }
                } else {
                    aggiornamentoNonRiuscito = "Licenza non fornita";
                }
            }
            dati = aHelper.addAboutToDati(dati, TipoOperazione.OTHER, userLogin, infoP);
            if (!StringUtils.isEmpty((CharSequence)aggiornamentoNonRiuscito)) {
                pd.setMessage((String)aggiornamentoNonRiuscito, MessageType.ERROR);
            } else if (!StringUtils.isEmpty(aggiornamentoEffettuato)) {
                pd.setMessage(aggiornamentoEffettuato, MessageType.INFO);
            }
            pd.setDati(dati);
            ServletUtils.setGeneralAndPageDataIntoSession((HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (PageData)pd);
            return ServletUtils.getStrutsForwardEditModeFinished((ActionMapping)mapping, (String)"about", (ForwardParams)AboutCostanti.TIPO_OPERAZIONE_ABOUT);
        }
        catch (Exception e) {
            return ServletUtils.getStrutsForwardError((Logger)ControlStationCore.getLog(), (Throwable)e, (PageData)pd, (HttpServletRequest)request, (HttpSession)session, (GeneralData)gd, (ActionMapping)mapping, (String)"about", (ForwardParams)AboutCostanti.TIPO_OPERAZIONE_ABOUT);
        }
    }
}

