/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.servlet;

import jakarta.mail.BodyPart;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openspcoop2.core.allarmi.Allarme;
import org.openspcoop2.core.allarmi.constants.RuoloPorta;
import org.openspcoop2.core.allarmi.constants.StatoAllarme;
import org.openspcoop2.core.allarmi.utils.AllarmiConverterUtils;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.Filtri;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.ModalitaIdentificazione;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.AttributeAuthority;
import org.openspcoop2.core.config.AutorizzazioneScope;
import org.openspcoop2.core.config.CanaleConfigurazione;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazionePortaHandler;
import org.openspcoop2.core.config.ConfigurazioneTracciamentoPorta;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.CorrelazioneApplicativa;
import org.openspcoop2.core.config.CorrelazioneApplicativaRisposta;
import org.openspcoop2.core.config.CorsConfigurazione;
import org.openspcoop2.core.config.CorsConfigurazioneHeaders;
import org.openspcoop2.core.config.CorsConfigurazioneMethods;
import org.openspcoop2.core.config.CorsConfigurazioneOrigin;
import org.openspcoop2.core.config.Dump;
import org.openspcoop2.core.config.DumpConfigurazione;
import org.openspcoop2.core.config.DumpConfigurazioneRegola;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.GestioneToken;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.MessageSecurity;
import org.openspcoop2.core.config.MtomProcessor;
import org.openspcoop2.core.config.MtomProcessorFlowParameter;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaAutorizzazioneToken;
import org.openspcoop2.core.config.PortaApplicativaBehaviour;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.PortaDelegataAutorizzazioneToken;
import org.openspcoop2.core.config.PortaDelegataLocalForward;
import org.openspcoop2.core.config.PortaTracciamento;
import org.openspcoop2.core.config.Property;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ProprietaOggetto;
import org.openspcoop2.core.config.ResponseCachingConfigurazione;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneControl;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneGenerale;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneHashGenerator;
import org.openspcoop2.core.config.ResponseCachingConfigurazioneRegola;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaRichiesta;
import org.openspcoop2.core.config.TrasformazioneRegolaRisposta;
import org.openspcoop2.core.config.TrasformazioneSoap;
import org.openspcoop2.core.config.TrasformazioneSoapRisposta;
import org.openspcoop2.core.config.Trasformazioni;
import org.openspcoop2.core.config.ValidazioneContenutiApplicativi;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.MTOMProcessorType;
import org.openspcoop2.core.config.constants.PluginCostanti;
import org.openspcoop2.core.config.constants.RuoloTipoMatch;
import org.openspcoop2.core.config.constants.ScopeTipoMatch;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.StatoFunzionalitaBloccante;
import org.openspcoop2.core.config.constants.StatoFunzionalitaCacheDigestQueryParameter;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConPersonalizzazione;
import org.openspcoop2.core.config.constants.StatoFunzionalitaConWarning;
import org.openspcoop2.core.config.constants.TipoAutenticazione;
import org.openspcoop2.core.config.constants.TipoAutenticazionePrincipal;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.config.constants.TipoBehaviour;
import org.openspcoop2.core.config.constants.TipoGestioneCORS;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.db.IDServizioApplicativoDB;
import org.openspcoop2.core.config.utils.TracciamentoCompatibilitaFiltroEsiti;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.constants.TipoPdD;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.constants.Costanti;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.core.controllo_traffico.driver.PolicyGroupByActiveThreadsType;
import org.openspcoop2.core.id.IDAccordo;
import org.openspcoop2.core.id.IDAccordoCooperazione;
import org.openspcoop2.core.id.IDFruizione;
import org.openspcoop2.core.id.IDGruppo;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDRuolo;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.mapping.MappingErogazionePortaApplicativa;
import org.openspcoop2.core.mapping.MappingFruizionePortaDelegata;
import org.openspcoop2.core.mvc.properties.Config;
import org.openspcoop2.core.mvc.properties.constants.ItemType;
import org.openspcoop2.core.mvc.properties.provider.ExternalResources;
import org.openspcoop2.core.mvc.properties.provider.ProviderException;
import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;
import org.openspcoop2.core.mvc.properties.utils.ConfigManager;
import org.openspcoop2.core.mvc.properties.utils.PropertiesSourceConfiguration;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.constants.TipoPlugin;
import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Azione;
import org.openspcoop2.core.registry.Documento;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.Operation;
import org.openspcoop2.core.registry.PortType;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Resource;
import org.openspcoop2.core.registry.Ruolo;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.beans.AccordoServizioParteComuneSintetico;
import org.openspcoop2.core.registry.beans.ProprietaOggettoSintetico;
import org.openspcoop2.core.registry.beans.ResourceSintetica;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.FormatoSpecifica;
import org.openspcoop2.core.registry.constants.HttpMethod;
import org.openspcoop2.core.registry.constants.RuoliDocumento;
import org.openspcoop2.core.registry.constants.RuoloContesto;
import org.openspcoop2.core.registry.constants.RuoloTipologia;
import org.openspcoop2.core.registry.constants.ScopeContesto;
import org.openspcoop2.core.registry.constants.ServiceBinding;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.constants.TipiDocumentoSicurezza;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.FiltroRicercaAccordi;
import org.openspcoop2.core.registry.driver.FiltroRicercaGruppi;
import org.openspcoop2.core.registry.driver.FiltroRicercaRuoli;
import org.openspcoop2.core.registry.driver.FiltroRicercaScope;
import org.openspcoop2.core.registry.driver.IDAccordoCooperazioneFactory;
import org.openspcoop2.core.registry.driver.IDAccordoFactory;
import org.openspcoop2.core.registry.driver.IDServizioFactory;
import org.openspcoop2.core.transazioni.utils.PropertiesSerializator;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.monitor.engine.alarm.wrapper.ConfigurazioneAllarmeBean;
import org.openspcoop2.pdd.config.CostantiProprieta;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.ConfigurazioneLoadBalancer;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.LoadBalancerType;
import org.openspcoop2.pdd.core.behaviour.built_in.load_balance.sticky.StickyUtils;
import org.openspcoop2.pdd.core.behaviour.conditional.ConditionalUtils;
import org.openspcoop2.pdd.core.connettori.ConnettoreCheck;
import org.openspcoop2.pdd.core.controllo_traffico.policy.config.PolicyConfiguration;
import org.openspcoop2.pdd.core.dynamic.DynamicHelperCostanti;
import org.openspcoop2.pdd.core.dynamic.DynamicUtils;
import org.openspcoop2.pdd.core.integrazione.GruppoIntegrazione;
import org.openspcoop2.pdd.core.integrazione.TipoIntegrazione;
import org.openspcoop2.pdd.core.token.TokenUtilities;
import org.openspcoop2.pdd.core.trasformazioni.TipoTrasformazione;
import org.openspcoop2.protocol.engine.ProtocolFactoryManager;
import org.openspcoop2.protocol.engine.utils.NamingUtils;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.ArchiveType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemType;
import org.openspcoop2.protocol.sdk.constants.ConsoleItemValueType;
import org.openspcoop2.protocol.sdk.constants.ConsoleOperationType;
import org.openspcoop2.protocol.sdk.constants.EsitoTransazioneName;
import org.openspcoop2.protocol.sdk.constants.FunzionalitaProtocollo;
import org.openspcoop2.protocol.sdk.properties.AbstractConsoleItem;
import org.openspcoop2.protocol.sdk.properties.AbstractProperty;
import org.openspcoop2.protocol.sdk.properties.BaseConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BinaryProperty;
import org.openspcoop2.protocol.sdk.properties.BooleanConsoleItem;
import org.openspcoop2.protocol.sdk.properties.BooleanProperty;
import org.openspcoop2.protocol.sdk.properties.ConsoleConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleDynamicConfiguration;
import org.openspcoop2.protocol.sdk.properties.IConsoleHelper;
import org.openspcoop2.protocol.sdk.properties.NumberConsoleItem;
import org.openspcoop2.protocol.sdk.properties.NumberProperty;
import org.openspcoop2.protocol.sdk.properties.ProtocolProperties;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesFactory;
import org.openspcoop2.protocol.sdk.properties.ProtocolPropertiesUtils;
import org.openspcoop2.protocol.sdk.properties.StringConsoleItem;
import org.openspcoop2.protocol.sdk.properties.StringProperty;
import org.openspcoop2.protocol.sdk.properties.SubtitleConsoleItem;
import org.openspcoop2.protocol.sdk.properties.TitleConsoleItem;
import org.openspcoop2.protocol.sdk.registry.IConfigIntegrationReader;
import org.openspcoop2.protocol.sdk.registry.IRegistryReader;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.protocol.utils.EsitiConfigUtils;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.protocol.utils.ModIUtils;
import org.openspcoop2.utils.BooleanNullable;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.byok.BYOKManager;
import org.openspcoop2.utils.certificate.ocsp.OCSPManager;
import org.openspcoop2.utils.mime.MimeMultipart;
import org.openspcoop2.utils.properties.PropertiesUtilities;
import org.openspcoop2.utils.regexp.RegExpException;
import org.openspcoop2.utils.regexp.RegExpNotFoundException;
import org.openspcoop2.utils.regexp.RegExpNotValidException;
import org.openspcoop2.utils.regexp.RegExpUtilities;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.openspcoop2.utils.resources.Charset;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.transport.http.HttpRequestMethod;
import org.openspcoop2.utils.xml.XPathExpressionEngine;
import org.openspcoop2.utils.xml2json.JsonXmlPathExpressionEngine;
import org.openspcoop2.web.ctrlstat.config.ConsoleProperties;
import org.openspcoop2.web.ctrlstat.core.AutorizzazioneUtilities;
import org.openspcoop2.web.ctrlstat.core.Connettori;
import org.openspcoop2.web.ctrlstat.core.ConsoleSearch;
import org.openspcoop2.web.ctrlstat.core.ControlStationCore;
import org.openspcoop2.web.ctrlstat.core.ControlStationCoreException;
import org.openspcoop2.web.ctrlstat.core.ControlStationLogger;
import org.openspcoop2.web.ctrlstat.core.DBManager;
import org.openspcoop2.web.ctrlstat.core.InitListener;
import org.openspcoop2.web.ctrlstat.core.Utilities;
import org.openspcoop2.web.ctrlstat.costanti.CostantiControlStation;
import org.openspcoop2.web.ctrlstat.costanti.InUsoType;
import org.openspcoop2.web.ctrlstat.costanti.TipologiaConnettori;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationException;
import org.openspcoop2.web.ctrlstat.driver.DriverControlStationNotFound;
import org.openspcoop2.web.ctrlstat.plugins.ExtendedMenuItem;
import org.openspcoop2.web.ctrlstat.plugins.IExtendedMenu;
import org.openspcoop2.web.ctrlstat.servlet.ApiKeyState;
import org.openspcoop2.web.ctrlstat.servlet.ConsoleUtilities;
import org.openspcoop2.web.ctrlstat.servlet.OggettoDialogEnum;
import org.openspcoop2.web.ctrlstat.servlet.ac.AccordiCooperazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.apc.AccordiServizioParteComuneCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaCore;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaFruitoriPorteDelegateMappingInfo;
import org.openspcoop2.web.ctrlstat.servlet.aps.AccordiServizioParteSpecificaPorteApplicativeMappingInfo;
import org.openspcoop2.web.ctrlstat.servlet.aps.erogazioni.ErogazioniCostanti;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ArchiviCore;
import org.openspcoop2.web.ctrlstat.servlet.archivi.ExporterUtils;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCore;
import org.openspcoop2.web.ctrlstat.servlet.config.ConfigurazioneCostanti;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCore;
import org.openspcoop2.web.ctrlstat.servlet.connettori.ConnettoriCostanti;
import org.openspcoop2.web.ctrlstat.servlet.gruppi.GruppiCore;
import org.openspcoop2.web.ctrlstat.servlet.pa.PorteApplicativeCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCore;
import org.openspcoop2.web.ctrlstat.servlet.pd.PorteDelegateCostanti;
import org.openspcoop2.web.ctrlstat.servlet.pdd.PddCore;
import org.openspcoop2.web.ctrlstat.servlet.protocol_properties.ProtocolPropertiesCore;
import org.openspcoop2.web.ctrlstat.servlet.protocol_properties.ProtocolPropertiesUtilities;
import org.openspcoop2.web.ctrlstat.servlet.remote_stores.RemoteStoresCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCore;
import org.openspcoop2.web.ctrlstat.servlet.ruoli.RuoliCostanti;
import org.openspcoop2.web.ctrlstat.servlet.sa.ServiziApplicativiCore;
import org.openspcoop2.web.ctrlstat.servlet.scope.ScopeCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCore;
import org.openspcoop2.web.ctrlstat.servlet.soggetti.SoggettiCostanti;
import org.openspcoop2.web.ctrlstat.servlet.utenti.UtentiCore;
import org.openspcoop2.web.lib.audit.web.AuditHelper;
import org.openspcoop2.web.lib.mvc.BinaryParameter;
import org.openspcoop2.web.lib.mvc.CheckboxStatusType;
import org.openspcoop2.web.lib.mvc.DataElement;
import org.openspcoop2.web.lib.mvc.DataElementInfo;
import org.openspcoop2.web.lib.mvc.DataElementType;
import org.openspcoop2.web.lib.mvc.Dialog;
import org.openspcoop2.web.lib.mvc.MenuEntry;
import org.openspcoop2.web.lib.mvc.PageData;
import org.openspcoop2.web.lib.mvc.Parameter;
import org.openspcoop2.web.lib.mvc.ServletUtils;
import org.openspcoop2.web.lib.mvc.TargetType;
import org.openspcoop2.web.lib.mvc.TipoOperazione;
import org.openspcoop2.web.lib.mvc.properties.beans.BaseItemBean;
import org.openspcoop2.web.lib.mvc.properties.beans.ConfigBean;
import org.openspcoop2.web.lib.mvc.properties.exception.UserInputValidationException;
import org.openspcoop2.web.lib.mvc.security.Validatore;
import org.openspcoop2.web.lib.mvc.security.exception.ValidationException;
import org.openspcoop2.web.lib.users.dao.InterfaceType;
import org.openspcoop2.web.lib.users.dao.PermessiUtente;
import org.openspcoop2.web.lib.users.dao.User;
import org.slf4j.Logger;

public class ConsoleHelper
implements IConsoleHelper {
    protected HttpServletRequest request;
    protected PageData pd;
    protected HttpSession session;
    protected ControlStationCore core = null;
    protected PddCore pddCore = null;
    protected SoggettiCore soggettiCore = null;
    protected UtentiCore utentiCore = null;
    protected ServiziApplicativiCore saCore = null;
    protected ArchiviCore archiviCore = null;
    protected AccordiServizioParteComuneCore apcCore = null;
    protected AccordiServizioParteSpecificaCore apsCore = null;
    protected PorteDelegateCore porteDelegateCore = null;
    protected PorteApplicativeCore porteApplicativeCore = null;
    protected AccordiCooperazioneCore acCore = null;
    protected ConfigurazioneCore confCore = null;
    protected ConnettoriCore connettoriCore = null;
    protected ProtocolPropertiesCore protocolPropertiesCore = null;
    protected RuoliCore ruoliCore = null;
    protected ScopeCore scopeCore = null;
    protected GruppiCore gruppiCore = null;
    protected RemoteStoresCore remoteStoresCore = null;
    protected AuditHelper auditHelper;
    private boolean multipart = false;
    private String contentType = null;
    private MimeMultipart mimeMultipart = null;
    private Map<String, List<InputStream>> mapParametri = null;
    private Map<String, Object> mapParametriReaded = null;
    private Map<String, List<String>> mapNomiFileParametri = null;
    private List<String> idBinaryParameterRicevuti = null;
    protected Logger log = null;
    protected IDAccordoCooperazioneFactory idAccordoCooperazioneFactory = null;
    protected IDAccordoFactory idAccordoFactory = null;
    protected IDServizioFactory idServizioFactory = null;
    private static String tmpDirectory = null;
    protected int size = 50;
    private static InterfaceType tipoInterfacciaAPI = null;
    private boolean errorInit = false;
    private Exception eErrorInit;
    private HashMap<String, byte[]> customBinaryParameters = new HashMap();
    private static boolean riusoIdCorrelazioneApplicativaPA = false;

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public PageData getPd() {
        return this.pd;
    }

    public HttpSession getSession() {
        return this.session;
    }

    protected void logError(String msg, Throwable e) {
        if (this.log != null) {
            this.log.error(msg, e);
        }
    }

    protected void logError(String msg) {
        if (this.log != null) {
            this.log.error(msg);
        }
    }

    public void setMessage(String message, boolean append) throws DriverControlStationException {
        this.setMessage(message, append, null);
    }

    public void setMessage(String message, boolean append, String type) throws DriverControlStationException {
        org.openspcoop2.web.lib.mvc.MessageType messageType = org.openspcoop2.web.lib.mvc.MessageType.ERROR;
        if (type != null) {
            try {
                messageType = org.openspcoop2.web.lib.mvc.MessageType.fromValue((String)type);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (messageType == null) {
                try {
                    messageType = org.openspcoop2.web.lib.mvc.MessageType.valueOf((String)type.toUpperCase());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (messageType == null) {
                messageType = org.openspcoop2.web.lib.mvc.MessageType.ERROR;
            }
        }
        if (this.pd != null) {
            String actualMsg;
            StringBuilder sb = new StringBuilder();
            if (append && (actualMsg = this.pd.getMessage()) != null && StringUtils.isNotEmpty((CharSequence)actualMsg)) {
                sb.append(actualMsg);
                sb.append("<br/>");
            }
            sb.append(message);
            this.pd.setMessage(message, messageType);
        }
    }

    public boolean isEditModeInProgress() throws DriverControlStationException, ValidationException {
        String editMode = this.getParametroEditMode("edit-mode");
        return ServletUtils.isEditModeInProgress((String)editMode);
    }

    public boolean isEditModeFinished() throws DriverControlStationException, ValidationException {
        String editMode = this.getParametroEditMode("edit-mode");
        return ServletUtils.isEditModeFinished((String)editMode);
    }

    public String getPostBackElementName() throws DriverControlStationException {
        return this.getParameter("postBackElementName");
    }

    public boolean isPostBack() throws DriverControlStationException {
        String postbackElementName = this.getPostBackElementName();
        return postbackElementName != null && !"".equals(postbackElementName);
    }

    public boolean isPostBackFilterElement() throws DriverControlStationException {
        String postbackElementName = this.getPostBackElementName();
        return postbackElementName != null && postbackElementName.startsWith("filterValue_");
    }

    public <T> T getAttributeFromSession(String attributeName, Class<T> type) {
        return (T)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, type, (String)attributeName);
    }

    public void clearFiltroSoggettoByPostBackProtocollo(int posizioneFiltroProtocollo, ISearch ricerca, int idLista) throws DriverControlStationException {
        String value;
        String postBackElement = this.getPostBackElementName();
        if (("filterValue_" + posizioneFiltroProtocollo).equals(postBackElement) && "filtroProtocollo".equals(this.getParameter("filterName_" + posizioneFiltroProtocollo)) && ((value = this.getParameter("filterValue_" + posizioneFiltroProtocollo)) == null || "".equals(value))) {
            ricerca.clearFilter(idLista, "filtroSoggetto");
        }
    }

    public ControlStationCore getCore() {
        return this.core;
    }

    public AuditHelper getAuditHelper() {
        return this.auditHelper;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public String getContentType() {
        return this.contentType;
    }

    public static String getTmpDir() throws DriverControlStationException {
        if (tmpDirectory == null) {
            ConsoleHelper.initTmpDir();
        }
        return tmpDirectory;
    }

    public static synchronized void initTmpDir() throws DriverControlStationException {
        if (tmpDirectory == null) {
            File file = null;
            try {
                file = FileSystemUtilities.createTempFile((String)"__pddconsole__", (String)".tmp");
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
            tmpDirectory = FilenameUtils.getFullPath((String)file.getAbsolutePath());
            if (file.exists()) {
                try {
                    Files.delete(file.toPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static InterfaceType getTipoInterfacciaAPI() {
        return tipoInterfacciaAPI;
    }

    public static void setTipoInterfacciaAPI(InterfaceType tipoInterfacciaAPI) {
        ConsoleHelper.tipoInterfacciaAPI = tipoInterfacciaAPI;
    }

    public InterfaceType getTipoInterfaccia() {
        if (tipoInterfacciaAPI != null) {
            return tipoInterfacciaAPI;
        }
        User user = ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session);
        if (user != null) {
            return user.getInterfaceType();
        }
        return InterfaceType.STANDARD;
    }

    public boolean isModalitaCompleta() {
        return InterfaceType.equals((InterfaceType)this.getTipoInterfaccia(), (InterfaceType[])new InterfaceType[]{InterfaceType.COMPLETA});
    }

    public boolean isModalitaAvanzata() {
        return InterfaceType.equals((InterfaceType)this.getTipoInterfaccia(), (InterfaceType[])new InterfaceType[]{InterfaceType.AVANZATA, InterfaceType.COMPLETA});
    }

    public boolean isModalitaStandard() {
        return InterfaceType.equals((InterfaceType)this.getTipoInterfaccia(), (InterfaceType[])new InterfaceType[]{InterfaceType.STANDARD});
    }

    public boolean isSoggettoMultitenantSelezionato() {
        return this.core.isMultitenant() && StringUtils.isNotEmpty((CharSequence)this.getSoggettoMultitenantSelezionato());
    }

    public String getSoggettoMultitenantSelezionato() {
        return ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session).getSoggettoSelezionatoPddConsole();
    }

    public boolean isSoggettoMultitenantSelezionatoConsoleMonitoraggio() {
        return this.core.isMultitenant() && StringUtils.isNotEmpty((CharSequence)this.getSoggettoMultitenantSelezionatoConsoleMonitoraggio());
    }

    public String getSoggettoMultitenantSelezionatoConsoleMonitoraggio() {
        return ServletUtils.getUserFromSession((HttpServletRequest)this.request, (HttpSession)this.session).getSoggettoSelezionatoPddMonitor();
    }

    public ConsoleHelper(HttpServletRequest request, PageData pd, HttpSession session) {
        ControlStationCore core = null;
        try {
            core = new ControlStationCore();
        }
        catch (Exception e) {
            if (this.log != null) {
                this.logError("Exception ctrlstatHelper: " + e.getMessage(), e);
            }
            this.errorInit = true;
            this.eErrorInit = e;
        }
        this.init(core, request, pd, session);
        try {
            if (this.isPostBack()) {
                pd.setPostBackResult(true);
            }
        }
        catch (Exception e) {
            this.logError("Exception ctrlstatHelper: " + e.getMessage(), e);
        }
    }

    public ConsoleHelper(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) {
        this.init(core, request, pd, session);
    }

    private void init(ControlStationCore core, HttpServletRequest request, PageData pd, HttpSession session) {
        this.request = request;
        this.pd = pd;
        this.session = session;
        this.log = ControlStationLogger.getPddConsoleCoreLogger();
        try {
            if (this.request.getCharacterEncoding() == null) {
                this.request.setCharacterEncoding(Charset.UTF_8.getValue());
            }
            this.core = core;
            this.pddCore = new PddCore(this.core);
            this.utentiCore = new UtentiCore(this.core);
            this.soggettiCore = new SoggettiCore(this.core);
            this.saCore = new ServiziApplicativiCore(this.core);
            this.archiviCore = new ArchiviCore(this.core);
            this.apcCore = new AccordiServizioParteComuneCore(this.core);
            this.apsCore = new AccordiServizioParteSpecificaCore(this.core);
            this.porteDelegateCore = new PorteDelegateCore(this.core);
            this.porteApplicativeCore = new PorteApplicativeCore(this.core);
            this.acCore = new AccordiCooperazioneCore(this.core);
            this.confCore = new ConfigurazioneCore(this.core);
            this.connettoriCore = new ConnettoriCore(this.core);
            this.protocolPropertiesCore = new ProtocolPropertiesCore(this.core);
            this.ruoliCore = new RuoliCore(this.core);
            this.scopeCore = new ScopeCore(this.core);
            this.gruppiCore = new GruppiCore(this.core);
            this.remoteStoresCore = new RemoteStoresCore(this.core);
            this.auditHelper = new AuditHelper(request, pd, session);
            this.idBinaryParameterRicevuti = new ArrayList<String>();
            this.contentType = request.getContentType();
            if (this.contentType != null && this.contentType.indexOf("multipart/form-data") != -1) {
                this.multipart = true;
                this.mimeMultipart = new MimeMultipart((InputStream)request.getInputStream(), this.contentType);
                this.mapParametri = new HashMap<String, List<InputStream>>();
                this.mapParametriReaded = new HashMap<String, Object>();
                this.mapNomiFileParametri = new HashMap<String, List<String>>();
                for (int i = 0; i < this.mimeMultipart.countBodyParts(); ++i) {
                    BodyPart bodyPart = this.mimeMultipart.getBodyPart(i);
                    String partName = this.getBodyPartName(bodyPart);
                    if (partName == null) {
                        throw new DriverControlStationException("Part name non trovato per body part alla posizione '" + i + "'");
                    }
                    List<Object> list = null;
                    if (this.mapParametri.containsKey(partName)) {
                        list = this.mapParametri.get(partName);
                    } else {
                        list = new ArrayList();
                        this.mapParametri.put(partName, list);
                    }
                    if (partName.startsWith("__fd__")) {
                        this.idBinaryParameterRicevuti.add(partName);
                    }
                    list.add(bodyPart.getInputStream());
                    String fileName = this.getBodyPartFileName(bodyPart);
                    if (fileName == null) continue;
                    List<Object> nomiFiles = null;
                    if (this.mapNomiFileParametri.containsKey(partName)) {
                        nomiFiles = this.mapNomiFileParametri.get(partName);
                    } else {
                        nomiFiles = new ArrayList();
                        this.mapNomiFileParametri.put(partName, nomiFiles);
                    }
                    nomiFiles.add(fileName);
                }
            } else {
                Enumeration parameterNames = this.request.getParameterNames();
                while (parameterNames.hasMoreElements()) {
                    String param = (String)parameterNames.nextElement();
                    if (!param.startsWith("__fd__")) continue;
                    this.idBinaryParameterRicevuti.add(param);
                }
            }
            try {
                if (!ControlStationCore.isAPIMode()) {
                    ConsoleProperties consoleProperties = ConsoleProperties.getInstance();
                    this.size = consoleProperties.getConsoleLunghezzaLabel();
                }
            }
            catch (Exception e) {
                this.size = 50;
            }
            this.getTabId();
        }
        catch (Exception e) {
            this.logError("Exception ctrlstatHelper: " + e.getMessage(), e);
            this.errorInit = true;
            this.eErrorInit = e;
        }
        this.idAccordoCooperazioneFactory = IDAccordoCooperazioneFactory.getInstance();
        this.idAccordoFactory = IDAccordoFactory.getInstance();
        this.idServizioFactory = IDServizioFactory.getInstance();
    }

    public String getTabId() throws DriverControlStationException {
        return ConsoleHelper.getTabId(this.log, this, this.request);
    }

    public static String getTabId(Logger log, ConsoleHelper helper, HttpServletRequest request) throws DriverControlStationException {
        Object idTabObj = request.getAttribute("__tabKey__");
        if (idTabObj == null) {
            log.trace("CHECKTABID: non trovato come attributo");
            String idTab = helper != null ? helper.getParameter("__tabKey__") : request.getParameter("__tabKey__");
            idTab = Validatore.getInstance().validateTabId(idTab);
            if (idTab == null) {
                log.trace("CHECKTABID: non trovato come parametro");
                idTab = UUID.randomUUID().toString();
                request.setAttribute("__tabKey__", (Object)idTab);
                log.debug("CHECKTABID: generato nuovo id: [" + idTab + "]");
                return idTab;
            }
            request.setAttribute("__tabKey__", (Object)idTab);
            log.trace("CHECKTABID: trovato come parametro: [" + idTab + "]");
            return idTab;
        }
        log.trace("CHECKTABID: trovato come attributo: [" + (String)idTabObj + "]");
        return (String)idTabObj;
    }

    public String getPrevTabId() throws Exception {
        return ConsoleHelper.getPrevTabId(this.log, this, this.request);
    }

    public static String getPrevTabId(Logger log, ConsoleHelper helper, HttpServletRequest request) throws Exception {
        String idTab = helper != null ? helper.getParameter("__prevTabKey__") : request.getParameter("__prevTabKey__");
        idTab = Validatore.getInstance().validateTabId(idTab);
        return idTab;
    }

    public boolean isShowGestioneWorkflowStatoDocumenti() {
        return this.core.isShowGestioneWorkflowStatoDocumenti(this);
    }

    public IDAccordo getIDAccordoFromValues(String nomeAS, String soggettoReferente, String versione) throws DriverControlStationException {
        try {
            org.openspcoop2.core.config.Soggetto s = this.soggettiCore.getSoggetto(Integer.parseInt(soggettoReferente));
            IDSoggetto assr = new IDSoggetto();
            assr.setTipo(s.getTipo());
            assr.setNome(s.getNome());
            int versioneInt = 1;
            if (versione != null && !"".equals(versione)) {
                versioneInt = Integer.parseInt(versione);
            }
            return this.idAccordoFactory.getIDAccordoFromValues(nomeAS, assr, Integer.valueOf(versioneInt));
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public IDServizio getIDServizioFromValues(String tipo, String nome, String soggettoErogatore, String versione) throws DriverControlStationException {
        try {
            org.openspcoop2.core.config.Soggetto s = this.soggettiCore.getSoggetto(Integer.parseInt(soggettoErogatore));
            IDSoggetto assr = new IDSoggetto();
            assr.setTipo(s.getTipo());
            assr.setNome(s.getNome());
            int versioneInt = 1;
            if (versione != null && !"".equals(versione)) {
                versioneInt = Integer.parseInt(versione);
            }
            return this.idServizioFactory.getIDServizioFromValues(tipo, nome, assr, versioneInt);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public IDServizio getIDServizioFromValues(String tipo, String nome, String tipoSoggettoErogatore, String soggettoErogatore, String versione) throws DriverControlStationException {
        try {
            IDSoggetto assr = new IDSoggetto();
            assr.setTipo(tipoSoggettoErogatore);
            assr.setNome(soggettoErogatore);
            int versioneInt = 1;
            if (versione != null && !"".equals(versione)) {
                versioneInt = Integer.parseInt(versione);
            }
            return this.idServizioFactory.getIDServizioFromValues(tipo, nome, assr, versioneInt);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public IDAccordo getIDAccordoFromUri(String uriAccordo) throws DriverControlStationException {
        try {
            return this.idAccordoFactory.getIDAccordoFromUri(uriAccordo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public int getSize() {
        return this.size;
    }

    private String getBodyPartName(BodyPart bodyPart) throws DriverControlStationException {
        String partName = null;
        String[] headers = null;
        try {
            headers = bodyPart.getHeader("Content-Disposition");
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        if (headers != null && headers.length > 0) {
            String header = headers[0];
            int prefixIndex = header.indexOf("form-data; name=\"") + "form-data; name=\"".length();
            partName = header.substring(prefixIndex);
            int suffixIndex = partName.indexOf("\"");
            partName = partName.substring(0, suffixIndex);
        }
        return partName;
    }

    private String getBodyPartFileName(BodyPart bodyPart) throws DriverControlStationException {
        String header;
        int prefixIndex;
        String partName = null;
        String[] headers = null;
        try {
            headers = bodyPart.getHeader("Content-Disposition");
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        if (headers != null && headers.length > 0 && (prefixIndex = (header = headers[0]).indexOf("filename=\"")) > -1) {
            partName = header.substring(prefixIndex + "filename=\"".length());
            int suffixIndex = partName.indexOf("\"");
            partName = partName.substring(0, suffixIndex);
            partName = FilenameUtils.getName((String)partName);
        }
        return partName;
    }

    private void checkErrorInit() throws DriverControlStationException {
        if (this.errorInit) {
            throw new DriverControlStationException("Inizializzazione fallita: " + this.eErrorInit.getMessage(), this.eErrorInit);
        }
    }

    public Enumeration<?> getParameterNames() throws DriverControlStationException {
        this.checkErrorInit();
        if (this.multipart) {
            throw new DriverControlStationException("Not Implemented");
        }
        return this.request.getParameterNames();
    }

    public String[] getParameterValues(String parameterName) throws DriverControlStationException {
        this.checkErrorInit();
        if (this.multipart) {
            String[] array = null;
            if (this.mapParametriReaded.containsKey(parameterName)) {
                array = (String[])this.mapParametriReaded.get(parameterName);
            } else {
                List<InputStream> list = this.mapParametri.get(parameterName);
                if (list != null && !list.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    for (InputStream inputStream : list) {
                        if (inputStream == null) continue;
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
                            baos.flush();
                            baos.close();
                        }
                        catch (Exception e) {
                            throw new DriverControlStationException(e.getMessage(), e);
                        }
                        if (sb.length() > 0) {
                            sb.append(",");
                        }
                        sb.append(baos.toString());
                    }
                    if (sb.length() > 0) {
                        String v = sb.toString();
                        array = v.split(",");
                        this.mapParametriReaded.put(parameterName, array);
                    }
                }
            }
            return array;
        }
        return this.request.getParameterValues(parameterName);
    }

    public String getParameter(String parameterName) throws DriverControlStationException {
        return this.getParameter(parameterName, String.class, null);
    }

    public <T> T getParameter(String parameterName, Class<T> type) throws DriverControlStationException {
        return this.getParameter(parameterName, type, null);
    }

    public <T> T getParameter(String parameterName, Class<T> type, T defaultValue) throws DriverControlStationException {
        this.checkErrorInit();
        T toReturn = null;
        if (type == byte[].class) {
            throw new DriverControlStationException("Per leggere un parametro di tipo byte[] utilizzare il metodo getBinaryParameter");
        }
        String paramAsString = null;
        if (this.multipart) {
            if (this.mapParametriReaded.containsKey(parameterName)) {
                paramAsString = (String)this.mapParametriReaded.get(parameterName);
            } else {
                List<InputStream> list = this.mapParametri.get(parameterName);
                if (list != null && !list.isEmpty()) {
                    if (list.size() > 1) {
                        throw new DriverControlStationException("Parametro [" + parameterName + "] Duplicato.");
                    }
                    InputStream inputStream = list.get(0);
                    if (inputStream != null) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        try {
                            IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
                            baos.flush();
                            baos.close();
                        }
                        catch (Exception e) {
                            throw new DriverControlStationException(e.getMessage(), e);
                        }
                        paramAsString = baos.toString();
                        this.mapParametriReaded.put(parameterName, paramAsString);
                    }
                }
            }
        } else {
            paramAsString = this.request.getParameter(parameterName);
        }
        if (paramAsString != null) {
            while (paramAsString.contains("\r\n")) {
                paramAsString = paramAsString.replace("\r\n", "\n");
            }
            try {
                Constructor<T> constructor = type.getConstructor(String.class);
                toReturn = constructor != null ? (T)constructor.newInstance(paramAsString) : (T)type.cast(paramAsString);
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        }
        if (toReturn == null && defaultValue != null) {
            return defaultValue;
        }
        return toReturn;
    }

    public byte[] getBinaryParameterContent(String parameterName) throws DriverControlStationException {
        byte[] b = null;
        List<byte[]> bpContents = this._getBinaryParameterContent(parameterName);
        if (bpContents != null && !bpContents.isEmpty()) {
            return bpContents.get(0);
        }
        return b;
    }

    public List<byte[]> _getBinaryParameterContent(String parameterName) throws DriverControlStationException {
        this.checkErrorInit();
        List<byte[]> bpContents = null;
        if (this.multipart) {
            if (this.mapParametriReaded.containsKey(parameterName)) {
                return (List)this.mapParametriReaded.get(parameterName);
            }
            List<InputStream> list = this.mapParametri.get(parameterName);
            if (list != null && !list.isEmpty()) {
                bpContents = new ArrayList();
                for (InputStream inputStream : list) {
                    if (inputStream == null) continue;
                    ByteArrayOutputStream baosInner = new ByteArrayOutputStream();
                    try {
                        IOUtils.copy((InputStream)inputStream, (OutputStream)baosInner);
                    }
                    catch (Exception e2) {
                        throw new DriverControlStationException(e2.getMessage(), e2);
                    }
                    byte[] b = baosInner.toByteArray();
                    bpContents.add(b);
                }
                if (!bpContents.isEmpty()) {
                    this.mapParametriReaded.put(parameterName, bpContents);
                    return bpContents;
                }
            }
        } else {
            String[] paramAsString = this.request.getParameterValues(parameterName);
            if (paramAsString != null) {
                List<String> tmpStrings = Arrays.asList(paramAsString);
                bpContents = tmpStrings.stream().map(e -> e.getBytes()).collect(Collectors.toList());
            }
        }
        return bpContents;
    }

    public String getFileNameParameter(String parameterName) throws DriverControlStationException {
        this.checkErrorInit();
        if (this.multipart) {
            List<String> tmp = this.mapNomiFileParametri.get(parameterName);
            return tmp != null && tmp.size() > 0 ? tmp.get(0) : null;
        }
        return this.request.getParameter(parameterName);
    }

    public List<String> getFileNamesParameter(String parameterName) throws DriverControlStationException {
        this.checkErrorInit();
        if (this.multipart) {
            List<String> tmp = this.mapNomiFileParametri.get(parameterName);
            return tmp;
        }
        String[] tmp = this.request.getParameterValues(parameterName);
        return tmp != null && tmp.length > 0 ? Arrays.asList(tmp) : null;
    }

    public void registerBinaryParameter(String parameterName, byte[] content) {
        this.customBinaryParameters.put(parameterName, content);
    }

    public BinaryParameter newBinaryParameter(String parameterName) throws DriverControlStationException {
        BinaryParameter bp = new BinaryParameter();
        bp.setName(parameterName);
        return bp;
    }

    public BinaryParameter getBinaryParameter(String parameterName) throws DriverControlStationException {
        String postBackElementName;
        this.checkErrorInit();
        BinaryParameter bp = this.newBinaryParameter(parameterName);
        String filename = null;
        String fileId = null;
        File file = null;
        FileOutputStream fos = null;
        FileInputStream fis = null;
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        byte[] bpContent = null;
        bpContent = this.customBinaryParameters.containsKey(parameterName) ? this.customBinaryParameters.get(parameterName) : this.getBinaryParameterContent(parameterName);
        if (bpContent != null && bpContent.length > 0) {
            filename = this.getParameter("__fn__" + parameterName);
            fileId = this.getParameter("__fd__" + parameterName);
            if (!(StringUtils.isNotBlank((CharSequence)fileId) && StringUtils.isNotBlank((CharSequence)filename) && (file = new File(ConsoleHelper.getTmpDir() + File.separator + "__pddconsole__" + fileId + ".tmp")).exists() && file.delete())) {
                // empty if block
            }
            filename = this.getFileNameParameter(parameterName);
            try {
                file = FileSystemUtilities.createTempFile((String)"__pddconsole__", (String)".tmp");
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
            fileId = file.getName().substring(0, file.getName().indexOf(".tmp"));
            fileId = fileId.substring(fileId.indexOf("__pddconsole__") + "__pddconsole__".length());
            try {
                bais = new ByteArrayInputStream(bpContent);
                fos = new FileOutputStream(file);
                IOUtils.copy((InputStream)bais, (OutputStream)fos);
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
            finally {
                try {
                    if (bais != null) {
                        bais.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (fos != null) {
                        fos.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        filename = this.getParameter("__fn__" + parameterName);
        fileId = this.getParameter("__fd__" + parameterName);
        if (StringUtils.isNotBlank((CharSequence)fileId) && StringUtils.isNotBlank((CharSequence)filename)) {
            file = new File(ConsoleHelper.getTmpDir() + File.separator + "__pddconsole__" + fileId + ".tmp");
            if (file.exists()) {
                try {
                    fis = new FileInputStream(file);
                    baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)fis, (OutputStream)baos);
                    baos.flush();
                    bpContent = baos.toByteArray();
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
                finally {
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (baos != null) {
                            baos.close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }
            bpContent = null;
        } else {
            bpContent = null;
            filename = null;
            fileId = null;
        }
        bp.setValue(bpContent);
        bp.setFilename(filename);
        bp.setId(fileId);
        if (this.isPostBack() && (postBackElementName = this.getPostBackElementName()) != null && postBackElementName.startsWith(parameterName) && postBackElementName.contains("__fr__")) {
            bp.setValue(null);
            bp.setFilename(null);
            bp.setId(null);
        }
        return bp;
    }

    public List<BinaryParameter> getBinaryParameters(String parameterName) throws DriverControlStationException {
        String postBackElementName;
        boolean ricevutoContenuto;
        this.checkErrorInit();
        String filename = null;
        String fileId = null;
        File file = null;
        FileOutputStream fos = null;
        FileInputStream fis = null;
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        byte[] bpContent = null;
        List<byte[]> bpContents = this._getBinaryParameterContent(parameterName);
        ArrayList<BinaryParameter> toRet = new ArrayList<BinaryParameter>();
        boolean bl = ricevutoContenuto = bpContents != null && bpContents.size() > 0;
        if (ricevutoContenuto) {
            for (int i = 0; i < bpContents.size(); ++i) {
                bpContent = bpContents.get(i);
                if (bpContent != null && bpContent.length > 0) continue;
                ricevutoContenuto = false;
                break;
            }
        }
        if (ricevutoContenuto) {
            fileNames = this.getParameter("__fn__" + parameterName);
            fileIds = this.getParameter("__fd__" + parameterName);
            if (StringUtils.isNotBlank((CharSequence)fileIds) && StringUtils.isNotBlank((CharSequence)fileNames)) {
                ids = fileIds.split(",");
                for (String id : ids) {
                    file = new File(ConsoleHelper.getTmpDir() + File.separator + "__pddconsole__" + id + ".tmp");
                    if (file.exists() && file.delete()) continue;
                }
            }
            List<String> fileNamesParameter = this.getFileNamesParameter(parameterName);
            for (int i = 0; i < bpContents.size(); ++i) {
                bpContent = bpContents.get(i);
                filename = fileNamesParameter.get(i);
                try {
                    file = FileSystemUtilities.createTempFile((String)"__pddconsole__", (String)".tmp");
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
                fileId = file.getName().substring(0, file.getName().indexOf(".tmp"));
                fileId = fileId.substring(fileId.indexOf("__pddconsole__") + "__pddconsole__".length());
                try {
                    bais = new ByteArrayInputStream(bpContent);
                    fos = new FileOutputStream(file);
                    IOUtils.copy((InputStream)bais, (OutputStream)fos);
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
                finally {
                    try {
                        if (bais != null) {
                            bais.close();
                        }
                    }
                    catch (Exception exception) {}
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (Exception exception) {}
                }
                BinaryParameter bp = this.newBinaryParameter(parameterName);
                bp.setValue(bpContent);
                bp.setFilename(filename);
                bp.setId(fileId);
                toRet.add(bp);
            }
        } else {
            fileNames = this.getParameter("__fn__" + parameterName);
            fileIds = this.getParameter("__fd__" + parameterName);
            if (StringUtils.isNotBlank((CharSequence)fileIds) && StringUtils.isNotBlank((CharSequence)fileNames)) {
                ids = Arrays.asList(fileIds.split(","));
                List<String> fileNamesParameter = Arrays.asList(fileNames.split(","));
                for (int i = 0; i < ids.size(); ++i) {
                    fileId = (String)ids.get(i);
                    filename = fileNamesParameter.get(i);
                    file = new File(ConsoleHelper.getTmpDir() + File.separator + "__pddconsole__" + fileId + ".tmp");
                    if (file.exists()) {
                        try {
                            fis = new FileInputStream(file);
                            baos = new ByteArrayOutputStream();
                            IOUtils.copy((InputStream)fis, (OutputStream)baos);
                            baos.flush();
                            bpContent = baos.toByteArray();
                        }
                        catch (Exception e) {
                            throw new DriverControlStationException(e.getMessage(), e);
                        }
                        finally {
                            try {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                            catch (Exception exception) {}
                            try {
                                if (baos != null) {
                                    baos.close();
                                }
                            }
                            catch (Exception exception) {}
                        }
                    }
                    bpContent = null;
                    BinaryParameter bp = this.newBinaryParameter(parameterName);
                    bp.setValue(bpContent);
                    bp.setFilename(filename);
                    bp.setId(fileId);
                    toRet.add(bp);
                }
            } else {
                bpContent = null;
                filename = null;
                fileId = null;
                BinaryParameter bp = this.newBinaryParameter(parameterName);
                bp.setValue(bpContent);
                bp.setFilename(filename);
                bp.setId(fileId);
                toRet.add(bp);
            }
        }
        if (this.isPostBack() && (postBackElementName = this.getPostBackElementName()) != null && postBackElementName.startsWith(parameterName) && postBackElementName.contains("__fr__")) {
            String[] split = postBackElementName.split("__fr__");
            try {
                int pos = Integer.parseInt(split[1]);
                ((BinaryParameter)toRet.get(pos)).setValue(null);
                ((BinaryParameter)toRet.get(pos)).setFilename(null);
                ((BinaryParameter)toRet.get(pos)).setId(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return toRet;
    }

    public String getParametroBoolean(String parameterName) throws ValidationException, DriverControlStationException {
        return this.getParametroBoolean(parameterName, true);
    }

    public String getParametroBoolean(String parameterName, boolean validate) throws ValidationException, DriverControlStationException {
        if (validate) {
            this.validaParametroBoolean(parameterName);
        }
        return this.getParameter(parameterName);
    }

    public String getParametroInteger(String parameterName) throws ValidationException, DriverControlStationException {
        return this.getParametroInteger(parameterName, true);
    }

    public String getParametroInteger(String parameterName, boolean validate) throws ValidationException, DriverControlStationException {
        if (validate) {
            this.validaParametroInteger(parameterName);
        }
        return this.getParameter(parameterName);
    }

    public String getParametroLong(String parameterName) throws ValidationException, DriverControlStationException {
        return this.getParametroLong(parameterName, true);
    }

    public String getParametroLong(String parameterName, boolean validate) throws ValidationException, DriverControlStationException {
        if (validate) {
            this.validaParametroLong(parameterName);
        }
        return this.getParameter(parameterName);
    }

    public String getLockedParameter(String parameterName) throws UtilsException, DriverControlStationException {
        return this.getLockedParameter(parameterName, true);
    }

    public String getLockedParameter(String parameterName, boolean unwrap) throws UtilsException, DriverControlStationException {
        String inputValue = this.getParameter(parameterName);
        if (inputValue == null || "********".equals(inputValue)) {
            String lockHiddenValue = this.getParameter("__lk__" + parameterName);
            if (this.core.getDriverBYOKUtilities().isEnabledBYOK() && unwrap) {
                return this.core.getDriverBYOKUtilities().unwrap(lockHiddenValue);
            }
            return lockHiddenValue;
        }
        return inputValue;
    }

    public String getMessageParameter(String parameterName) throws ValidationException {
        String val = Validatore.getInstance().getParametroOriginale(this.request, parameterName);
        Validatore.getInstance().validate("Il valore del parametro [" + parameterName + "]:[" + val + "]", val, null, true, true, new String[]{"HTTPParameterValueTextArea"});
        return val;
    }

    public void deleteBinaryProtocolPropertiesTmpFiles(ProtocolProperties protocolProperties) throws DriverControlStationException {
        this.checkErrorInit();
        if (protocolProperties != null) {
            for (int i = 0; i < protocolProperties.sizeProperties(); ++i) {
                AbstractProperty property = protocolProperties.getProperty(i);
                if (!(property instanceof BinaryProperty)) continue;
                BinaryProperty bProp = (BinaryProperty)property;
                BinaryParameter bp = new BinaryParameter();
                bp.setName(bProp.getId());
                bp.setFilename(bProp.getFileName());
                bp.setId(bProp.getFileId());
                bp.setValue((byte[])bProp.getValue());
                this.deleteBinaryParameter(bp);
            }
        }
    }

    public void deleteBinaryProtocolPropertyTmpFiles(ProtocolProperties protocolProperties, String propertyId) throws DriverControlStationException {
        this.checkErrorInit();
        if (protocolProperties != null) {
            for (int i = 0; i < protocolProperties.sizeProperties(); ++i) {
                AbstractProperty property = protocolProperties.getProperty(i);
                if (!(property instanceof BinaryProperty) || !property.getId().equals(propertyId)) continue;
                BinaryProperty bProp = (BinaryProperty)property;
                BinaryParameter bp = new BinaryParameter();
                bp.setName(bProp.getId());
                bp.setFilename(bProp.getFileName());
                bp.setId(bProp.getFileId());
                bp.setValue((byte[])bProp.getValue());
                this.deleteBinaryParameter(bp);
                break;
            }
        }
    }

    public void deleteBinaryProtocolPropertyTmpFiles(ProtocolProperties protocolProperties, String propertyId, String aliasId) throws DriverControlStationException {
        this.checkErrorInit();
        if (protocolProperties != null) {
            for (int i = 0; i < protocolProperties.sizeProperties(); ++i) {
                AbstractProperty property = protocolProperties.getProperty(i);
                if (!(property instanceof BinaryProperty) || !property.getId().equals(propertyId)) continue;
                BinaryProperty bProp = (BinaryProperty)property;
                BinaryParameter bp = new BinaryParameter();
                bp.setName(aliasId);
                bp.setFilename(bProp.getFileName());
                bp.setId(bProp.getFileId());
                bp.setValue((byte[])bProp.getValue());
                this.deleteBinaryParameter(bp);
                break;
            }
        }
    }

    public void deleteProtocolPropertiesBinaryParameters(BinaryParameter ... parameters) throws DriverControlStationException {
        this.checkErrorInit();
        File file = null;
        if (this.idBinaryParameterRicevuti != null && this.idBinaryParameterRicevuti.size() > 0) {
            for (String bp : this.idBinaryParameterRicevuti) {
                boolean delete = true;
                if (parameters != null && parameters.length > 0) {
                    for (BinaryParameter binaryParameter : parameters) {
                        if (binaryParameter.getId() == null || !binaryParameter.getId().equals(bp)) continue;
                        delete = false;
                        break;
                    }
                }
                if (!delete) continue;
                String val = this.getParameter(bp);
                file = new File(ConsoleHelper.getTmpDir() + File.separator + "__pddconsole__" + val + ".tmp");
                if (file.exists() && file.delete()) continue;
            }
        }
    }

    public void deleteBinaryParameters(BinaryParameter ... parameters) throws DriverControlStationException {
        this.checkErrorInit();
        if (parameters != null && parameters.length > 0) {
            for (BinaryParameter binaryParameter : parameters) {
                this.deleteBinaryParameter(binaryParameter);
            }
        }
    }

    private void deleteBinaryParameter(BinaryParameter bp) throws DriverControlStationException {
        this.checkErrorInit();
        File file = null;
        if (!(StringUtils.isNotBlank((CharSequence)bp.getId()) && (file = new File(ConsoleHelper.getTmpDir() + File.separator + "__pddconsole__" + bp.getId() + ".tmp")).exists() && file.delete())) {
            // empty if block
        }
        bp.setValue(null);
        bp.setFilename(null);
        bp.setId(null);
    }

    public ProtocolProperties estraiProtocolPropertiesDaRequest(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, String propertyId, BinaryParameter contenutoDocumentoParameter) throws DriverControlStationException, ValidationException, UtilsException {
        this.checkErrorInit();
        String editMode = this.getParametroEditMode("edit-mode");
        String postBackElementName = this.getParameter("postBackElementName");
        boolean primoAccessoAdd = ConsoleOperationType.ADD.equals((Object)consoleOperationType) && (editMode == null || "protocollo".equals(postBackElementName) || "accordo".equals(postBackElementName));
        ProtocolProperties properties = new ProtocolProperties();
        List consoleItems = consoleConfiguration.getConsoleItem();
        block7: for (BaseConsoleItem item : consoleItems) {
            ConsoleItemValueType consoleItemValueType;
            if (!(item instanceof AbstractConsoleItem) || (consoleItemValueType = ProtocolPropertiesUtils.getConsoleItemValueType((BaseConsoleItem)item)) == null) continue;
            switch (consoleItemValueType) {
                case BINARY: {
                    BinaryParameter bp = contenutoDocumentoParameter;
                    if (propertyId == null || !propertyId.equals(item.getId())) {
                        bp = this.getBinaryParameter(item.getId());
                    } else {
                        bp.setName(item.getId());
                    }
                    byte[] binValue = item.isLockedType() ? this.core.getDriverBYOKUtilities().unwrap(bp.getValue()) : bp.getValue();
                    BinaryProperty binaryProperty = ProtocolPropertiesFactory.newProperty((String)bp.getName(), (byte[])binValue, (String)bp.getFilename(), (String)bp.getId());
                    properties.addProperty((AbstractProperty)binaryProperty);
                    continue block7;
                }
                case NUMBER: {
                    String lvS = item.isLockedType() ? this.getLockedParameter(item.getId()) : this.getParameter(item.getId());
                    Long longValue = null;
                    try {
                        longValue = StringUtils.isNotEmpty((CharSequence)lvS) ? Long.valueOf(Long.parseLong(lvS)) : null;
                    }
                    catch (NumberFormatException e) {
                        longValue = null;
                    }
                    NumberProperty numberProperty = ProtocolPropertiesFactory.newProperty((String)item.getId(), (Long)longValue);
                    if (primoAccessoAdd) {
                        numberProperty.setValue((Object)((Long)((NumberConsoleItem)item).getDefaultValue()));
                    }
                    properties.addProperty((AbstractProperty)numberProperty);
                    continue block7;
                }
                case BOOLEAN: {
                    BooleanConsoleItem b;
                    String bvS = item.isLockedType() ? this.getLockedParameter(item.getId()) : this.getParameter(item.getId());
                    Boolean booleanValue = ServletUtils.isCheckBoxEnabled((String)bvS);
                    Boolean falseValue = null;
                    if (item instanceof BooleanConsoleItem && !(b = (BooleanConsoleItem)item).isConvertFalseAsNull()) {
                        falseValue = false;
                    }
                    BooleanProperty booleanProperty = ProtocolPropertiesFactory.newProperty((String)item.getId(), (Boolean)(booleanValue != false ? booleanValue : falseValue));
                    if (primoAccessoAdd) {
                        booleanProperty.setValue((Object)((Boolean)((BooleanConsoleItem)item).getDefaultValue()));
                    }
                    properties.addProperty((AbstractProperty)booleanProperty);
                    continue block7;
                }
            }
            StringProperty stringProperty = null;
            if (ConsoleItemType.MULTI_SELECT.equals((Object)item.getType())) {
                String[] parameterValues = this.getParameterValues(item.getId());
                String value = parameterValues != null && parameterValues.length > 0 ? ProtocolPropertiesUtils.getValueMultiSelect((String[])parameterValues) : null;
                stringProperty = ProtocolPropertiesFactory.newProperty((String)item.getId(), (String)value);
            } else {
                String parameterValue = item.isLockedType() ? this.getLockedParameter(item.getId()) : this.getParameter(item.getId());
                stringProperty = ProtocolPropertiesFactory.newProperty((String)item.getId(), (String)parameterValue);
            }
            if (primoAccessoAdd) {
                stringProperty.setValue((Object)((String)((StringConsoleItem)item).getDefaultValue()));
            }
            properties.addProperty((AbstractProperty)stringProperty);
        }
        return properties;
    }

    public ProtocolProperties estraiProtocolPropertiesDaRequest(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType) throws DriverControlStationException, ValidationException, UtilsException {
        this.checkErrorInit();
        return this.estraiProtocolPropertiesDaRequest(consoleConfiguration, consoleOperationType, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public void makeMenu() throws DriverControlStationException {
        try {
            List<ExtendedMenuItem> list;
            boolean showCodaMessaggi;
            boolean showAccordiCooperazione;
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)this.session);
            ExporterUtils exporterUtils = new ExporterUtils(this.archiviCore);
            PermessiUtente pu = null;
            User u = this.utentiCore.getUser(userLogin);
            pu = u.getPermessi();
            Boolean singlePdD = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"singlePdD");
            if (singlePdD == null) {
                singlePdD = this.core != null ? this.core.isSinglePdD() : true;
            }
            boolean isModalitaAvanzata = this.isModalitaAvanzata();
            boolean isModalitaCompleta = this.isModalitaCompleta();
            List<IExtendedMenu> extendedMenu = this.core.getExtendedMenu();
            ArrayList<Object> menu = new ArrayList<Object>();
            boolean bl = showAccordiCooperazione = pu.isAccordiCooperazione() && this.core.isAccordiCooperazioneEnabled();
            if (pu.isServizi() || showAccordiCooperazione) {
                Boolean serviziVisualizzaModalitaElenco = ConsoleProperties.getInstance().isEnableServiziVisualizzaModalitaElenco();
                MenuEntry me = new MenuEntry();
                String[][] entries = null;
                me.setTitle("Registro");
                int totEntries = 0;
                if (pu.isServizi()) {
                    if (this.core.isRegistroServiziLocale() && this.core.isGestionePddAbilitata(this)) {
                        ++totEntries;
                    }
                    totEntries += 2;
                    if (this.core.isRegistroServiziLocale()) {
                        ++totEntries;
                        if (isModalitaCompleta) {
                            ++totEntries;
                        } else {
                            if (serviziVisualizzaModalitaElenco.booleanValue()) {
                                totEntries += 2;
                            }
                            totEntries += 2;
                        }
                    }
                }
                if (showAccordiCooperazione && this.core.isRegistroServiziLocale()) {
                    totEntries += 2;
                }
                if (pu.isServizi() && this.core.isRegistroServiziLocale()) {
                    ++totEntries;
                    ++totEntries;
                }
                if (pu.isServizi() && this.isModalitaCompleta()) {
                    totEntries += 2;
                }
                if (extendedMenu != null) {
                    for (IExtendedMenu extMenu : extendedMenu) {
                        List<ExtendedMenuItem> list3 = extMenu.getExtendedItemsMenuRegistro(isModalitaAvanzata, this.core.isRegistroServiziLocale(), singlePdD, pu);
                        if (list3 == null || list3.size() <= 0) continue;
                        totEntries += list3.size();
                    }
                }
                entries = new String[totEntries][2];
                int n = 0;
                boolean pddVisualizzate = false;
                if (pu.isServizi()) {
                    if (this.core.isRegistroServiziLocale() && this.core.isGestionePddAbilitata(this)) {
                        void var15_23;
                        pddVisualizzate = true;
                        entries[n][0] = "Porte Dominio";
                        entries[n][1] = "pddSinglePdDList.do";
                        ++var15_23;
                    }
                    if (pddVisualizzate) {
                        void var15_25;
                        entries[var15_23][0] = "Soggetti";
                        entries[var15_23][1] = "soggettiList.do";
                        entries[++var15_24][0] = "Servizi Applicativi";
                        entries[var15_24][1] = "serviziApplicativiList.do";
                        ++var15_25;
                    }
                    if (this.core.isRegistroServiziLocale()) {
                        if (isModalitaCompleta) {
                            void var15_26;
                            entries[var15_25][0] = "API";
                            entries[var15_25][1] = "accordiServizioParteComuneList.do?tipoAccordo=apc";
                            ++var15_26;
                        } else {
                            void var15_27;
                            entries[var15_25][0] = "API";
                            entries[var15_25][1] = "accordiServizioParteComuneApiList.do?tipoAccordo=apc";
                            ++var15_27;
                        }
                        if (isModalitaCompleta) {
                            void var15_29;
                            entries[var15_28][0] = "Erogazioni";
                            entries[var15_28][1] = "accordiServizioParteSpecificaList.do?_tabKey_tipologiaErogazione=completa";
                            ++var15_29;
                        } else {
                            void var15_33;
                            if (serviziVisualizzaModalitaElenco.booleanValue()) {
                                void var15_31;
                                entries[var15_28][0] = "Erogazioni";
                                entries[var15_28][1] = "accordiServizioParteSpecificaList.do?_tabKey_tipologiaErogazione=erogazione";
                                entries[++var15_30][0] = "Fruizioni";
                                entries[var15_30][1] = "accordiServizioParteSpecificaList.do?_tabKey_tipologiaErogazione=fruizione";
                                ++var15_31;
                            }
                            entries[var15_31][0] = "Erogazioni";
                            entries[var15_31][1] = "aspsErogazioniList.do?_tabKey_tipologiaErogazione=erogazione";
                            entries[++var15_32][0] = "Fruizioni";
                            entries[var15_32][1] = "aspsErogazioniList.do?_tabKey_tipologiaErogazione=fruizione";
                            ++var15_33;
                        }
                    }
                }
                if (showAccordiCooperazione && this.core.isRegistroServiziLocale()) {
                    void var15_36;
                    entries[var15_34][0] = "Accordi Cooperazione";
                    entries[var15_34][1] = "accordiCooperazioneList.do";
                    entries[++var15_35][0] = "API (Servizio Composto)";
                    entries[var15_35][1] = "accordiServizioParteComuneList.do?tipoAccordo=asc";
                    ++var15_36;
                }
                if (!pddVisualizzate) {
                    void var15_38;
                    entries[var15_36][0] = "Soggetti";
                    entries[var15_36][1] = "soggettiList.do";
                    entries[++var15_37][0] = this.isModalitaCompleta() ? "Servizi Applicativi" : "Applicativi";
                    entries[var15_37][1] = "serviziApplicativiList.do";
                    ++var15_38;
                }
                if (pu.isServizi() && this.core.isRegistroServiziLocale()) {
                    void var15_40;
                    entries[var15_38][0] = "Ruoli";
                    entries[var15_38][1] = "ruoliList.do";
                    entries[++var15_39][0] = "Scope";
                    entries[var15_39][1] = "scopeList.do";
                    ++var15_40;
                }
                if (pu.isServizi() && this.isModalitaCompleta()) {
                    void var15_42;
                    entries[var15_40][0] = "Porte Delegate";
                    entries[var15_40][1] = "porteDelegateList.do";
                    entries[++var15_41][0] = "Porte Applicative";
                    entries[var15_41][1] = "porteApplicativeList.do";
                    ++var15_42;
                }
                if (extendedMenu != null) {
                    for (IExtendedMenu extMenu : extendedMenu) {
                        List<ExtendedMenuItem> list4 = extMenu.getExtendedItemsMenuRegistro(isModalitaAvanzata, this.core.isRegistroServiziLocale(), singlePdD, pu);
                        if (list4 == null) continue;
                        for (ExtendedMenuItem extendedMenuItem : list4) {
                            void var15_43;
                            entries[var15_43][0] = extendedMenuItem.getLabel();
                            entries[var15_43][1] = extendedMenuItem.getUrl();
                            ++var15_43;
                        }
                    }
                }
                me.setEntries(entries);
                menu.add(me);
            }
            List<ExtendedMenuItem> listStrumenti = null;
            if (extendedMenu != null) {
                for (IExtendedMenu extMenu : extendedMenu) {
                    listStrumenti = extMenu.getExtendedItemsMenuStrumenti(isModalitaAvanzata, this.core.isRegistroServiziLocale(), singlePdD, pu);
                }
            }
            List<String> aliases = this.confCore.getJmxPdDAliases();
            boolean bl2 = showCodaMessaggi = pu.isCodeMessaggi() && this.core.showCodaMessage();
            if (showCodaMessaggi || pu.isAuditing() || pu.isSistema() && aliases != null && aliases.size() > 0 || listStrumenti != null && listStrumenti.size() > 0) {
                void var15_48;
                MenuEntry me = new MenuEntry();
                me.setTitle("Strumenti");
                boolean bl3 = false;
                if (pu.isSistema() && aliases != null && aliases.size() > 0) {
                    void var15_45;
                    ++var15_45;
                }
                if (this.isModalitaAvanzata() && showCodaMessaggi) {
                    void var15_46;
                    ++var15_46;
                }
                if (pu.isAuditing()) {
                    void var15_47;
                    ++var15_47;
                }
                if (extendedMenu != null) {
                    for (IExtendedMenu extMenu : extendedMenu) {
                        List<ExtendedMenuItem> list2 = extMenu.getExtendedItemsMenuStrumenti(isModalitaAvanzata, this.core.isRegistroServiziLocale(), singlePdD, pu);
                        if (list2 == null || list2.size() <= 0) continue;
                        var15_48 += list2.size();
                    }
                }
                String[][] entries = new String[var15_48][2];
                int i = 0;
                if (pu.isSistema() && aliases != null && aliases.size() > 0) {
                    entries[i][0] = "Runtime";
                    entries[i][1] = "configurazioneSistemaAdd.do";
                    ++i;
                }
                if (pu.isAuditing()) {
                    entries[i][0] = "Auditing";
                    entries[i][1] = "auditing.do";
                    ++i;
                }
                if (this.isModalitaAvanzata() && showCodaMessaggi) {
                    entries[i][0] = "Coda Messaggi";
                    entries[i][1] = "monitor.do";
                    ++i;
                }
                if (extendedMenu != null) {
                    for (IExtendedMenu extMenu : extendedMenu) {
                        list = extMenu.getExtendedItemsMenuStrumenti(isModalitaAvanzata, this.core.isRegistroServiziLocale(), singlePdD, pu);
                        if (list == null) continue;
                        for (ExtendedMenuItem extendedMenuItem : list) {
                            entries[i][0] = extendedMenuItem.getLabel();
                            entries[i][1] = extendedMenuItem.getUrl();
                            ++i;
                        }
                    }
                }
                me.setEntries(entries);
                menu.add(me);
            }
            if (pu.isSistema()) {
                MenuEntry me = new MenuEntry();
                me.setTitle("Configurazione");
                Object var15_49 = null;
                String[][] entriesUtenti = null;
                int dimensioneEntries = 0;
                dimensioneEntries = 7;
                if (this.core.isVisualizzaConfigurazioneAllarmiEnabled()) {
                    ++dimensioneEntries;
                }
                ++dimensioneEntries;
                if (!this.isModalitaStandard()) {
                    ++dimensioneEntries;
                    ++dimensioneEntries;
                }
                if (this.core.isShowPulsantiImportExport() && pu.isServizi()) {
                    ++dimensioneEntries;
                    if (exporterUtils.existsAtLeastOneExportMode(ArchiveType.CONFIGURAZIONE, this.request, this.session)) {
                        ++dimensioneEntries;
                        if (isModalitaAvanzata) {
                            ++dimensioneEntries;
                        }
                    }
                }
                if (pu.isUtenti()) {
                    entriesUtenti = this.getVoceMenuUtenti();
                    dimensioneEntries += entriesUtenti.length;
                }
                if (extendedMenu != null) {
                    for (IExtendedMenu extMenu : extendedMenu) {
                        list = extMenu.getExtendedItemsMenuConfigurazione(isModalitaAvanzata, this.core.isRegistroServiziLocale(), singlePdD, pu);
                        if (list == null || list.size() <= 0) continue;
                        dimensioneEntries += list.size();
                    }
                }
                String[][] stringArray = new String[dimensioneEntries][2];
                int index = 0;
                stringArray[index][0] = "Generale";
                stringArray[index][1] = "configurazioneGenerale.do";
                ++index;
                if (!this.isModalitaStandard()) {
                    stringArray[index][0] = "Cache";
                    stringArray[index][1] = "configurazioneGenerale.do?configCaches=yes";
                    ++index;
                }
                if (!this.isModalitaStandard()) {
                    stringArray[index][0] = "Cache PDND";
                    stringArray[index][1] = "remoteStoresKeysList.do";
                    ++index;
                }
                stringArray[index][0] = "Controllo del Traffico";
                stringArray[index][1] = "configurazioneControlloTraffico.do";
                stringArray[++index][0] = "Tracciamento";
                stringArray[index][1] = "configurazioneTracciamentoTransazioni.do?tipo_configurazione=trace";
                stringArray[++index][0] = "Registrazione Messaggi";
                stringArray[index][1] = "configurazioneTracciamentoTransazioni.do?tipo_configurazione=dump";
                ++index;
                if (this.core.isVisualizzaConfigurazioneAllarmiEnabled()) {
                    stringArray[index][0] = "Allarmi";
                    stringArray[index][1] = "configurazioneAllarmiList.do";
                    ++index;
                }
                stringArray[index][0] = "Token Policy";
                stringArray[index][1] = "configurazionePolicyGestioneTokenList.do?_tabKey_infoType=token";
                stringArray[++index][0] = "Attribute Authority";
                stringArray[index][1] = "configurazionePolicyGestioneTokenList.do?_tabKey_infoType=aa";
                stringArray[++index][0] = "Tags";
                stringArray[index][1] = "gruppiList.do";
                ++index;
                if (pu.isUtenti() && entriesUtenti != null) {
                    for (int j = 0; j < entriesUtenti.length; ++j) {
                        stringArray[index][0] = entriesUtenti[j][0];
                        stringArray[index][1] = entriesUtenti[j][1];
                        ++index;
                    }
                }
                if (this.core.isShowPulsantiImportExport() && pu.isServizi()) {
                    stringArray[index][0] = "Importa";
                    stringArray[index][1] = "import.do?modalita=import";
                    ++index;
                    if (exporterUtils.existsAtLeastOneExportMode(ArchiveType.CONFIGURAZIONE, this.request, this.session)) {
                        stringArray[index][0] = "Esporta";
                        stringArray[index][1] = "export.do?tipoExport=" + ArchiveType.CONFIGURAZIONE.name();
                        ++index;
                        if (isModalitaAvanzata) {
                            stringArray[index][0] = "Elimina";
                            stringArray[index][1] = "import.do?modalita=elimina";
                            ++index;
                        }
                    }
                }
                stringArray[index][0] = "Auditing";
                stringArray[index][1] = "configurazioneAuditing.do";
                ++index;
                if (!pu.isUtenti()) {
                    // empty if block
                }
                if (extendedMenu != null) {
                    for (IExtendedMenu extMenu : extendedMenu) {
                        List<ExtendedMenuItem> list2 = extMenu.getExtendedItemsMenuConfigurazione(isModalitaAvanzata, this.core.isRegistroServiziLocale(), singlePdD, pu);
                        if (list2 == null) continue;
                        for (ExtendedMenuItem extendedMenuItem : list2) {
                            stringArray[index][0] = extendedMenuItem.getLabel();
                            stringArray[index][1] = extendedMenuItem.getUrl();
                            ++index;
                        }
                    }
                }
                me.setEntries(stringArray);
                menu.add(me);
            } else {
                int dimensioneEntries = 0;
                Object var15_51 = null;
                if (this.core.isShowPulsantiImportExport() && pu.isServizi()) {
                    ++dimensioneEntries;
                    if (exporterUtils.existsAtLeastOneExportMode(ArchiveType.CONFIGURAZIONE, this.request, this.session)) {
                        ++dimensioneEntries;
                        if (isModalitaAvanzata) {
                            ++dimensioneEntries;
                        }
                    }
                }
                if (pu.isUtenti()) {
                    String[][] stringArray = this.getVoceMenuUtenti();
                    dimensioneEntries += stringArray.length;
                }
                if (extendedMenu != null) {
                    for (IExtendedMenu extMenu : extendedMenu) {
                        List<ExtendedMenuItem> list3 = extMenu.getExtendedItemsMenuConfigurazione(isModalitaAvanzata, this.core.isRegistroServiziLocale(), singlePdD, pu);
                        if (list3 == null || list3.size() <= 0) continue;
                        dimensioneEntries += list3.size();
                    }
                }
                if (dimensioneEntries > 0) {
                    MenuEntry me = new MenuEntry();
                    me.setTitle("Configurazione");
                    String[][] entries = new String[dimensioneEntries][2];
                    int index = 0;
                    if (pu.isUtenti()) {
                        void var15_53;
                        for (int j = 0; j < ((void)var15_53).length; ++j) {
                            entries[index][0] = var15_53[j][0];
                            entries[index][1] = var15_53[j][1];
                            ++index;
                        }
                    }
                    if (this.core.isShowPulsantiImportExport() && pu.isServizi()) {
                        entries[index][0] = "Importa";
                        entries[index][1] = "import.do?modalita=import";
                        ++index;
                        if (exporterUtils.existsAtLeastOneExportMode(ArchiveType.CONFIGURAZIONE, this.request, this.session)) {
                            entries[index][0] = "Esporta";
                            entries[index][1] = "export.do?tipoExport=" + ArchiveType.CONFIGURAZIONE.name();
                            ++index;
                            if (isModalitaAvanzata) {
                                entries[index][0] = "Elimina";
                                entries[index][1] = "import.do?modalita=elimina";
                                ++index;
                            }
                        }
                    }
                    if (!pu.isUtenti()) {
                        // empty if block
                    }
                    if (extendedMenu != null) {
                        for (IExtendedMenu extMenu : extendedMenu) {
                            List<ExtendedMenuItem> list4 = extMenu.getExtendedItemsMenuConfigurazione(isModalitaAvanzata, this.core.isRegistroServiziLocale(), singlePdD, pu);
                            if (list4 == null) continue;
                            for (ExtendedMenuItem extendedMenuItem : list4) {
                                entries[index][0] = extendedMenuItem.getLabel();
                                entries[index][1] = extendedMenuItem.getUrl();
                                ++index;
                            }
                        }
                    }
                    me.setEntries(entries);
                    menu.add(me);
                }
            }
            for (MenuEntry menuEntry : menu) {
                String[][] entries = menuEntry.getEntries();
                if (entries == null || entries.length <= 0) continue;
                for (int i = 0; i < entries.length; ++i) {
                    String[] voce = entries[i];
                    if (voce[1] == null || "".equals(voce[1])) continue;
                    Object newUrl = voce[1];
                    newUrl = ((String)newUrl).contains("?") ? (String)newUrl + "&" : (String)newUrl + "?";
                    newUrl = (String)newUrl + "resetSearch";
                    newUrl = (String)newUrl + "=";
                    newUrl = (String)newUrl + "yes";
                    if (this.getTabId() != null) {
                        newUrl = (String)newUrl + "&";
                        newUrl = (String)newUrl + "__prevTabKey__";
                        newUrl = (String)newUrl + "=";
                        newUrl = (String)newUrl + this.getTabId();
                    }
                    voce[1] = newUrl;
                }
            }
            this.pd.setMenu(menu);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    private String[][] getVoceMenuUtenti() {
        String[][] entries = new String[1][2];
        entries[0][0] = "Utenti";
        entries[0][1] = "utentiList.do";
        return entries;
    }

    public void initializeFilter(ConsoleSearch ricerca) throws DriverControlStationException {
        this.initializeFilter(ricerca, Liste.SOGGETTI);
        this.initializeFilter(ricerca, Liste.SERVIZIO_APPLICATIVO);
        this.initializeFilter(ricerca, Liste.ACCORDI);
        this.initializeFilter(ricerca, Liste.ACCORDI_COOPERAZIONE);
        this.initializeFilter(ricerca, Liste.SERVIZI);
        this.initializeFilter(ricerca, Liste.PORTE_DELEGATE);
        this.initializeFilter(ricerca, Liste.PORTE_APPLICATIVE);
    }

    public void initializeFilter(ConsoleSearch ricerca, int idLista) throws DriverControlStationException {
        if (Liste.UTENTI_SERVIZI != idLista && Liste.UTENTI_SOGGETTI != idLista) {
            this.setFilterSelectedProtocol((ISearch)ricerca, idLista);
        }
        this.setFilterRuoloServizioApplicativo((ISearch)ricerca, idLista);
    }

    public ConsoleSearch checkSearchParameters(int idLista, ConsoleSearch ricerca) throws DriverControlStationException {
        try {
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ricerca.getSearchString(idLista);
            offset = this.getParameter("index") != null ? Integer.parseInt(this.getParameter("index")) : org.openspcoop2.web.lib.mvc.Costanti.INDEX_DEFAULT;
            ricerca.setIndexIniziale(idLista, offset);
            limit = this.getParameter("pageSize") != null ? Integer.parseInt(this.getParameter("pageSize")) : org.openspcoop2.web.lib.mvc.Costanti.PAGE_SIZE_DEFAULT;
            ricerca.setPageSize(idLista, limit);
            if (this.getParameter("search") != null) {
                search = this.getParameter("search");
                if ((search = search.trim()).equals("")) {
                    ricerca.setSearchString(idLista, "undefined");
                } else {
                    ricerca.setSearchString(idLista, search);
                }
            } else if (!this.core.isConservaRisultatiRicerca()) {
                ricerca.setSearchString(idLista, "undefined");
            }
            int index = 0;
            String nameFilter = PageData.getParametroFilterName((int)index);
            if (!this.core.isConservaRisultatiRicerca()) {
                ricerca.clearFilters(idLista);
                this.initializeFilter(ricerca, idLista);
            }
            while (this.getParameter(nameFilter) != null) {
                String paramFilterName = this.getParameter(nameFilter);
                paramFilterName = paramFilterName.trim();
                String paramFilterValue = this.getParameter(PageData.getParametroFilterValue((int)index));
                if (paramFilterValue == null) {
                    paramFilterValue = "";
                }
                if ((paramFilterValue = paramFilterValue.trim()).equals("")) {
                    paramFilterValue = "undefined";
                }
                ricerca.addFilter(idLista, paramFilterName, paramFilterValue);
                nameFilter = PageData.getParametroFilterName((int)(++index));
            }
            return ricerca;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean smista() throws DriverControlStationException {
        try {
            if (this.core.isUsedByApi()) {
                return false;
            }
            boolean usaSmistatore = true;
            Boolean singlePdD = this.core.isSinglePdD();
            if (singlePdD.booleanValue()) {
                usaSmistatore = false;
            }
            return usaSmistatore;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addNomeValoreToDati(TipoOperazione tipoOp, List<DataElement> dati, String nome, String valore, boolean enableUpdate) {
        DataElement de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (tipoOp.equals((Object)TipoOperazione.ADD) || enableUpdate) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nome");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Valore");
        de.setValue(valore);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("valore");
        de.setSize(this.getSize());
        de.setRequired(true);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addNomeValoreProprietaCifrataToDati(TipoOperazione tipoOp, List<DataElement> dati, String nome, String valore, boolean enableUpdate) throws UtilsException {
        DataElement de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (tipoOp.equals((Object)TipoOperazione.ADD) || enableUpdate) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nome");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Valore");
        de.setName("valore");
        de.setSize(this.getSize());
        this.core.getLockUtilities().lockProperty(de, valore);
        de.setRequired(true);
        dati.add(de);
        return dati;
    }

    public String wrapValoreProprieta(String valore) throws DriverControlStationException, UtilsException {
        return this.wrapValoreProprieta("valore", valore);
    }

    public String wrapValoreProprieta(String nomeParametro, String valore) throws DriverControlStationException, UtilsException {
        if (valore != null && StringUtils.isNotEmpty((CharSequence)valore) && BYOKManager.isEnabledBYOK() && nomeParametro.equals(this.getPostBackElementName())) {
            return this.core.getDriverBYOKUtilities().wrap(valore);
        }
        return valore;
    }

    public List<DataElement> addHiddenFieldsToDati(TipoOperazione tipoOp, String id, String idsogg, String idPorta, List<DataElement> dati) {
        return this.addHiddenFieldsToDati(tipoOp, id, idsogg, idPorta, null, dati);
    }

    public List<DataElement> addHiddenFieldsToDati(TipoOperazione tipoOp, String id, String idsogg, String idPorta, String idAsps, List<DataElement> dati) {
        return this.addHiddenFieldsToDati(tipoOp, id, idsogg, idPorta, idAsps, null, null, null, dati);
    }

    public List<DataElement> addHiddenFieldsToDati(TipoOperazione tipoOp, String id, String idsogg, String idPorta, String idAsps, String idFruizione, String tipoSoggettoFruitore, String nomeSoggettoFruitore, List<DataElement> dati) {
        DataElement de = new DataElement();
        if (id != null) {
            de.setLabel("Id");
            de.setValue(id);
            de.setType(DataElementType.HIDDEN);
            de.setName("id");
            dati.add(de);
        }
        if (idsogg != null) {
            de = new DataElement();
            de.setLabel("IdSogg");
            de.setValue(idsogg);
            de.setType(DataElementType.HIDDEN);
            de.setName("idsogg");
            dati.add(de);
        }
        if (idPorta != null) {
            de = new DataElement();
            de.setLabel("IdPorta");
            de.setValue(idPorta);
            de.setType(DataElementType.HIDDEN);
            de.setName("idPorta");
            dati.add(de);
        }
        if (idAsps != null) {
            de = new DataElement();
            de.setLabel("IdAsps");
            de.setValue(idAsps);
            de.setType(DataElementType.HIDDEN);
            de.setName("idAsps");
            dati.add(de);
        }
        if (idFruizione != null) {
            de = new DataElement();
            de.setLabel("IdFruizione");
            de.setValue(idFruizione);
            de.setType(DataElementType.HIDDEN);
            de.setName("myId");
            dati.add(de);
        }
        if (tipoSoggettoFruitore != null) {
            de = new DataElement();
            de.setValue(tipoSoggettoFruitore);
            de.setType(DataElementType.HIDDEN);
            de.setName("tipoSoggFru");
            dati.add(de);
        }
        if (nomeSoggettoFruitore != null) {
            de = new DataElement();
            de.setValue(nomeSoggettoFruitore);
            de.setType(DataElementType.HIDDEN);
            de.setName("nomeSoggFru");
            dati.add(de);
        }
        return dati;
    }

    public boolean checkNCName(String name, String object) throws DriverControlStationException {
        try {
            if (!RegularExpressionEngine.isMatch((String)name, (String)"^[_A-Za-z][\\-\\._A-Za-z0-9]*$")) {
                this.pd.setMessage("Il campo '" + object + "' pu\u00f2 iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.'");
                return false;
            }
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        return true;
    }

    public boolean checkNCNameAndSerial(String name, String object) throws DriverControlStationException {
        try {
            if (!RegularExpressionEngine.isMatch((String)name, (String)"^[_A-Za-z][\\-\\._A-Za-z0-9]*@[0-9]*$")) {
                this.pd.setMessage("Il campo '" + object + "' pu\u00f2 iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-' e '.', infine deve terminare con @ e numeri interi");
                return false;
            }
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        return true;
    }

    public boolean checkSimpleNamePath(String name, String object) throws DriverControlStationException {
        try {
            if (!RegularExpressionEngine.isMatch((String)name, (String)"^[0-9A-Za-z][\\-A-Za-z0-9]*$")) {
                this.pd.setMessage("Il campo '" + object + "' pu\u00f2 iniziare solo con un carattere o cifra [0-9A-Za-z] e dev'essere formato solo da caratteri, cifre e '-'");
                return false;
            }
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        return true;
    }

    public boolean checkSimpleName(String name, String object) throws DriverControlStationException {
        try {
            if (!RegularExpressionEngine.isMatch((String)name, (String)"^[0-9A-Za-z]+$")) {
                this.pd.setMessage("Il campo '" + object + "' deve essere formato solo da caratteri e cifre");
                return false;
            }
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        return true;
    }

    public boolean checkIntegrationEntityName(String name, String object) throws DriverControlStationException {
        try {
            if (!RegularExpressionEngine.isMatch((String)name, (String)"^[_A-Za-z][\\-\\._/A-Za-z0-9]*$")) {
                this.pd.setMessage("Il campo '" + object + "' pu\u00f2 iniziare solo con un carattere [A-Za-z] o il simbolo '_' e dev'essere formato solo da caratteri, cifre, '_' , '-', '.' e '/'");
                return false;
            }
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        return true;
    }

    public boolean checkNumber(String value, String object, boolean permitZeroAsValue) throws DriverControlStationException {
        block9: {
            if (permitZeroAsValue) {
                try {
                    if (!RegularExpressionEngine.isMatch((String)value, (String)"^[0-9]+$")) {
                        this.pd.setMessage("Il campo '" + object + "' deve essere formato solo da cifre");
                        return false;
                    }
                    break block9;
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
            }
            try {
                if (!RegularExpressionEngine.isMatch((String)value, (String)"^[1-9]+[0-9]*$")) {
                    if (value.charAt(0) == '0' && value.length() > 1) {
                        this.pd.setMessage("Il campo '" + object + "' deve contenere un numero intero maggiore di zero e non deve iniziare con la cifra '0'");
                    } else {
                        this.pd.setMessage("Il campo '" + object + "' deve contenere un numero intero maggiore di zero");
                    }
                    return false;
                }
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        }
        return true;
    }

    public boolean checkLength4000(String value, String object) throws DriverControlStationException {
        return this.checkLength(value, object, -1, 4000);
    }

    public boolean checkLength255(String value, String object) throws DriverControlStationException {
        return this.checkLength(value, object, -1, 255);
    }

    public boolean checkLengthSubject_SSL_Principal(String value, String object) throws DriverControlStationException {
        return this.checkLength(value, object, -1, 2800);
    }

    public boolean checkLength(String value, String object, int minLength, int maxLength) throws DriverControlStationException {
        if (minLength > 0 && (value == null || value.length() < minLength)) {
            this.pd.setMessage("L'informazione fornita nel campo '" + object + "' deve possedere una lunghezza maggiore di " + (minLength - 1));
            return false;
        }
        if (maxLength > 0 && value != null && value.length() > maxLength) {
            this.pd.setMessage("L'informazione fornita nel campo '" + object + "' deve possedere una lunghezza minore di " + maxLength);
            return false;
        }
        return true;
    }

    public boolean checkSpazi(String value, String object) throws DriverControlStationException {
        if (value.contains(" ")) {
            this.pd.setMessage("L'informazione fornita nel campo '" + object + "' non deve contenere spazi");
            return false;
        }
        return true;
    }

    public boolean checkEmail(String email, String object) throws DriverControlStationException {
        try {
            if (!RegularExpressionEngine.isMatch((String)email, (String)"^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$")) {
                this.pd.setMessage("Il campo '" + object + "' non contiene un indirizzo e-mail valido");
                return false;
            }
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        return true;
    }

    public boolean checkRegexp(String pattern, String object) throws DriverControlStationException {
        try {
            RegularExpressionEngine.validate((String)pattern);
        }
        catch (Exception e) {
            this.pd.setMessage("Il campo '" + object + "' non contiene un'espressione regolare valida: " + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean checkXPath(String pattern, String object) throws DriverControlStationException {
        try {
            XPathExpressionEngine engine = new XPathExpressionEngine();
            engine.validate(pattern);
        }
        catch (Exception e) {
            this.pd.setMessage("Il campo '" + object + "' non contiene un'espressione xpath valida: " + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean checkJsonPath(String pattern, String object) throws DriverControlStationException {
        try {
            JsonXmlPathExpressionEngine.validate((String)pattern, (Logger)this.log);
        }
        catch (Exception e) {
            this.pd.setMessage("Il campo '" + object + "' non contiene un'espressione json-path valida: " + e.getMessage());
            return false;
        }
        return true;
    }

    public boolean checkXPathOrJsonPath(String pattern, String object) throws DriverControlStationException {
        StringBuilder sb = new StringBuilder();
        try {
            XPathExpressionEngine engine = new XPathExpressionEngine();
            engine.validate(pattern);
            return true;
        }
        catch (Exception e) {
            if (sb.length() > 0) {
                sb.append("<BR/>");
                sb.append("<BR/>");
            }
            sb.append("XPath: " + e.getMessage());
            try {
                JsonXmlPathExpressionEngine.validate((String)pattern, (Logger)this.log);
                return true;
            }
            catch (Exception e2) {
                if (sb.length() > 0) {
                    sb.append("<BR/>");
                    sb.append("<BR/>");
                }
                sb.append("JsonPath: " + e2.getMessage());
                if (sb.length() > 0) {
                    this.pd.setMessage("Il campo '" + object + "' contiene un'espressione non validabile n\u00e9 come XPath n\u00e9 come JsonPath:<BR/><BR/>" + sb.toString());
                    return false;
                }
                return true;
            }
        }
    }

    public List<DataElement> addPorteServizioApplicativoToDati(TipoOperazione tipoOp, List<DataElement> dati, String servizioApplicativo, String[] servizioApplicativoList, int sizeAttuale, boolean addMsgServiziApplicativoNonDisponibili, boolean addTitle, boolean isToken) {
        if (isToken) {
            DataElement de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("tokenAuthz");
            de.setValue("true");
            dati.add(de);
        }
        if (servizioApplicativoList != null && servizioApplicativoList.length > 0) {
            DataElement de;
            String labelApplicativo = "Servizio Applicativo";
            if (!this.isModalitaCompleta()) {
                labelApplicativo = "Applicativo";
            }
            if (addTitle) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel(labelApplicativo);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Nome");
            de.setType(DataElementType.SELECT);
            de.setName("servizioApplicativo");
            de.setValues(servizioApplicativoList);
            de.setSelected(servizioApplicativo);
            dati.add(de);
        } else if (addMsgServiziApplicativoNonDisponibili) {
            if (sizeAttuale > 0) {
                this.pd.setMessage("Non esistono ulteriori servizi applicativi associabili alla porta", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            } else {
                this.pd.setMessage("Non esistono servizi applicativi associabili alla porta", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            }
            this.pd.disableEditMode();
        }
        return dati;
    }

    public List<DataElement> addPorteSoggettoToDati(TipoOperazione tipoOp, List<DataElement> dati, String[] soggettiLabelList, String[] soggettiList, String soggetto, int sizeAttuale, boolean addMsgSoggettiNonDisponibili, boolean addTitle) {
        if (soggettiList != null && soggettiList.length > 0) {
            DataElement de;
            if (addTitle) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Soggetto");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Nome");
            de.setType(DataElementType.SELECT);
            de.setName("soggt");
            de.setLabels(soggettiLabelList);
            de.setValues(soggettiList);
            de.setSelected(soggetto);
            dati.add(de);
        } else if (addMsgSoggettiNonDisponibili) {
            if (sizeAttuale > 0) {
                this.pd.setMessage("Non esistono ulteriori soggetti associabili", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            } else {
                this.pd.setMessage("Non esistono soggetti associabili", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            }
            this.pd.disableEditMode();
        }
        return dati;
    }

    public List<DataElement> addPorteServizioApplicativoAutorizzatiToDati(TipoOperazione tipoOp, List<DataElement> dati, String[] soggettiLabelList, String[] soggettiList, String soggetto, int sizeAttuale, Map<String, List<IDServizioApplicativoDB>> listServiziApplicativi, String sa, boolean addMsgApplicativiNonDisponibili, boolean showTitle, boolean isAutorizzazioneModi, boolean isSupportatoAutenticazioneApplicativiEsterni, boolean isToken) {
        DataElement de;
        if (isAutorizzazioneModi) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("autorizzazioneModIPA");
            de.setValue("true");
            dati.add(de);
        }
        if (isToken) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("tokenAuthz");
            de.setValue("true");
            dati.add(de);
        }
        if (soggettiList != null && soggettiList.length > 0 && listServiziApplicativi != null && listServiziApplicativi.size() > 0) {
            if (showTitle) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Applicativo");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Soggetto");
            de.setName("soggt");
            de.setValue(soggetto);
            if (this.core.isMultitenant() || isSupportatoAutenticazioneApplicativiEsterni) {
                de.setType(DataElementType.SELECT);
                de.setLabels(soggettiLabelList);
                de.setValues(soggettiList);
                de.setSelected(soggetto);
                de.setPostBack(true);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            dati.add(de);
            List<IDServizioApplicativoDB> listSA = null;
            if (soggetto != null && !"".equals(soggetto)) {
                listSA = listServiziApplicativi.get(soggetto);
            }
            if (listSA != null && !listSA.isEmpty()) {
                String[] saValues = new String[listSA.size()];
                String[] saLabels = new String[listSA.size()];
                int index = 0;
                for (IDServizioApplicativoDB saObject : listSA) {
                    saValues[index] = "" + saObject.getId();
                    saLabels[index] = saObject.getNome();
                    ++index;
                }
                de = new DataElement();
                if (showTitle) {
                    de.setLabel("Nome");
                } else {
                    de.setLabel("Applicativo");
                }
                de.setType(DataElementType.SELECT);
                de.setName("saAuthz");
                de.setLabels(saLabels);
                de.setValues(saValues);
                de.setSelected(sa);
                dati.add(de);
            } else {
                this.pd.setMessage("Non esistono applicativi associabili per il soggetto selezionato", org.openspcoop2.web.lib.mvc.MessageType.INFO);
                this.pd.disableEditMode();
            }
        } else if (addMsgApplicativiNonDisponibili) {
            if (sizeAttuale > 0) {
                this.pd.setMessage("Non esistono ulteriori applicativi associabili", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            } else {
                this.pd.setMessage("Non esistono applicativi associabili", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            }
            this.pd.disableEditMode();
        }
        return dati;
    }

    public boolean WSCheckData(TipoOperazione tipoOp) throws DriverControlStationException {
        try {
            String messageSecurity = this.getParameter("messageSecurity");
            if (!messageSecurity.equals("abilitato") && !messageSecurity.equals("disabilitato")) {
                this.pd.setMessage("Stato dev'essere abilitato o disabilitato");
                return false;
            }
            if (messageSecurity.equals("abilitato")) {
                String req = this.getParameter("propertiesConfigNameReq");
                String res = this.getParameter("propertiesConfigNameRes");
                if ((req == null || "".equals(req) || "-".equals(req)) && (res == null || "".equals(res) || "-".equals(res))) {
                    this.pd.setMessage("Almeno uno schema di sicurezza per la richiesta o per la risposta dev'essere abilitato");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addMessageSecurityToDati(List<DataElement> dati, boolean delegata, long idPorta, String messageSecurity, String url1, String url2, Boolean contaListe, int numWSreq, int numWSres, boolean showApplicaMTOMReq, String applicaMTOMReq, boolean showApplicaMTOMRes, String applicaMTOMRes, String idPropConfigReq, String idPropConfigRes, String[] propConfigReqLabelList, String[] propConfigReqList, String[] propConfigResLabelList, String[] propConfigResList, String oldIdPropConfigReq, String oldIdPropConfigRes) {
        DataElement de = new DataElement();
        de.setLabel("Message-Security");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        String[] tipoWS = new String[]{"abilitato", "disabilitato"};
        de.setLabel("Stato");
        de.setType(DataElementType.SELECT);
        de.setName("messageSecurity");
        de.setValues(tipoWS);
        de.setSelected(messageSecurity);
        de.setPostBack(true);
        dati.add(de);
        if ("abilitato".equals(messageSecurity)) {
            ConfigBean configurazioneBean;
            Map<String, Properties> mappaDB;
            Config configurazione;
            ConfigManager configManager;
            PropertiesSourceConfiguration propertiesSourceConfiguration;
            boolean valida;
            DataElement note;
            boolean editModeInProgress;
            de = new DataElement();
            de.setLabel("Richiesta");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Applica MTOM");
            if (showApplicaMTOMReq) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)applicaMTOMReq) || CostantiRegistroServizi.ABILITATO.equals(applicaMTOMReq)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(applicaMTOMReq);
            }
            de.setName("applicaMTOMReq");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Schema Sicurezza");
            de.setName("propertiesConfigNameReq");
            if (propConfigReqList.length > 1) {
                de.setType(DataElementType.SELECT);
                de.setLabels(propConfigReqLabelList);
                de.setValues(propConfigReqList);
                de.setSelected(idPropConfigReq);
                de.setPostBack(true);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(idPropConfigReq);
            }
            dati.add(de);
            if (idPropConfigReq.equals(oldIdPropConfigReq) && !idPropConfigReq.equals("-")) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl(url1);
                if (idPropConfigReq.equals("default")) {
                    if (contaListe.booleanValue()) {
                        de.setValue("Parametri(" + numWSreq + ")");
                    } else {
                        de.setValue("Parametri");
                    }
                } else if (numWSreq <= 0) {
                    editModeInProgress = true;
                    try {
                        editModeInProgress = this.isEditModeInProgress();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!editModeInProgress) {
                        de.setValue("Procedi con la configurazione");
                    } else {
                        note = new DataElement();
                        note.setBold(true);
                        note.setLabel("Attenzione");
                        note.setValue("Configurazione della sicurezza incompleta");
                        note.setType(DataElementType.NOTE);
                        dati.add(note);
                        de.setValue("Completa la configurazione");
                    }
                } else {
                    valida = false;
                    try {
                        propertiesSourceConfiguration = this.core.getMessageSecurityPropertiesSourceConfiguration();
                        configManager = ConfigManager.getinstance((Logger)ControlStationCore.getLog());
                        configurazione = configManager.getConfigurazione(propertiesSourceConfiguration, idPropConfigReq);
                        mappaDB = null;
                        mappaDB = delegata ? this.porteDelegateCore.readMessageSecurityRequestPropertiesConfiguration(idPorta) : this.porteApplicativeCore.readMessageSecurityRequestPropertiesConfiguration(idPorta);
                        configurazioneBean = this.porteApplicativeCore.leggiConfigurazione(configurazione, mappaDB);
                        valida = this.checkPropertiesConfigurationData(TipoOperazione.OTHER, configurazioneBean, null, null, configurazione);
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage(), e);
                    }
                    if (valida) {
                        de.setValue("Configurazione");
                    } else {
                        de.setValue("Completa la configurazione");
                    }
                }
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Risposta");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Applica MTOM");
            if (showApplicaMTOMRes) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)applicaMTOMRes) || CostantiRegistroServizi.ABILITATO.equals(applicaMTOMRes)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(applicaMTOMRes);
            }
            de.setName("applicaMTOMRes");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Schema Sicurezza");
            de.setName("propertiesConfigNameRes");
            if (propConfigResList.length > 1) {
                de.setType(DataElementType.SELECT);
                de.setLabels(propConfigResLabelList);
                de.setValues(propConfigResList);
                de.setSelected(idPropConfigRes);
                de.setPostBack(true);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(idPropConfigReq);
            }
            dati.add(de);
            if (idPropConfigRes.equals(oldIdPropConfigRes) && !idPropConfigRes.equals("-")) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl(url2);
                if (idPropConfigRes.equals("default")) {
                    if (contaListe.booleanValue()) {
                        de.setValue("Parametri(" + numWSres + ")");
                    } else {
                        de.setValue("Parametri");
                    }
                } else if (numWSres <= 0) {
                    editModeInProgress = true;
                    try {
                        editModeInProgress = this.isEditModeInProgress();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!editModeInProgress) {
                        de.setValue("Procedi con la configurazione");
                    } else {
                        note = new DataElement();
                        note.setBold(true);
                        note.setLabel("Attenzione");
                        note.setValue("Configurazione della sicurezza incompleta");
                        note.setType(DataElementType.NOTE);
                        dati.add(note);
                        de.setValue("Completa la configurazione");
                    }
                } else {
                    valida = false;
                    try {
                        propertiesSourceConfiguration = this.core.getMessageSecurityPropertiesSourceConfiguration();
                        configManager = ConfigManager.getinstance((Logger)ControlStationCore.getLog());
                        configurazione = configManager.getConfigurazione(propertiesSourceConfiguration, idPropConfigRes);
                        mappaDB = null;
                        mappaDB = delegata ? this.porteDelegateCore.readMessageSecurityResponsePropertiesConfiguration(idPorta) : this.porteApplicativeCore.readMessageSecurityResponsePropertiesConfiguration(idPorta);
                        configurazioneBean = this.porteApplicativeCore.leggiConfigurazione(configurazione, mappaDB);
                        valida = this.checkPropertiesConfigurationData(TipoOperazione.OTHER, configurazioneBean, null, null, configurazione);
                    }
                    catch (Exception e) {
                        this.logError(e.getMessage(), e);
                    }
                    if (valida) {
                        de.setValue("Configurazione");
                    } else {
                        de.setValue("Completa la configurazione");
                    }
                }
                dati.add(de);
            }
        }
        dati = this.addParameterApplicaModifica(dati);
        return dati;
    }

    public List<DataElement> addMTOMToDati(List<DataElement> dati, String[] modeMtomListReq, String[] modeMtomListRes, String mtomRichiesta, String mtomRisposta, String url1, String url2, Boolean contaListe, int numMTOMreq, int numMTOMres) {
        DataElement de = new DataElement();
        de = new DataElement();
        de.setLabel("Richiesta");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        de.setType(DataElementType.SELECT);
        de.setName("mtomReq");
        de.setValues(modeMtomListReq);
        de.setSelected(mtomRichiesta);
        de.setSize(this.getSize());
        dati.add(de);
        if (url1 != null) {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl(url1);
            if (contaListe.booleanValue()) {
                de.setValue("Parametri(" + numMTOMreq + ")");
            } else {
                de.setValue("Parametri");
            }
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Risposta");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        de.setType(DataElementType.SELECT);
        de.setName("mtomRes");
        de.setValues(modeMtomListRes);
        de.setSelected(mtomRisposta);
        de.setSize(this.getSize());
        dati.add(de);
        if (url2 != null) {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            de.setUrl(url2);
            if (contaListe.booleanValue()) {
                de.setValue("Parametri(" + numMTOMres + ")");
            } else {
                de.setValue("Parametri");
            }
            dati.add(de);
        }
        dati = this.addParameterApplicaModifica(dati);
        return dati;
    }

    public static boolean isRiusoIdCorrelazioneApplicativaPA() {
        return riusoIdCorrelazioneApplicativaPA;
    }

    public static void setRiusoIdCorrelazioneApplicativaPA(boolean riusoIdCorrelazioneApplicativaPA) {
        ConsoleHelper.riusoIdCorrelazioneApplicativaPA = riusoIdCorrelazioneApplicativaPA;
    }

    public List<DataElement> addCorrelazioneApplicativaToDati(List<DataElement> dati, boolean portaDelegata, boolean riusoID, String scadcorr, String urlRichiesta, String urlRisposta, Boolean contaListe, int numCorrelazioneReq, int numCorrelazioneRes) {
        DataElement de = new DataElement();
        de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Correlazione Applicativa");
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.SUBTITLE);
        de.setLabel("Richiesta");
        dati.add(de);
        if (portaDelegata) {
            if (riusoID && numCorrelazioneReq > 0 && this.isModalitaAvanzata()) {
                de = new DataElement();
                de.setLabel("Scadenza (minuti)");
                de.setNote("Definisce una scadenza per il riuso del solito ID Protocollo");
                de.setValue(scadcorr);
                de.setType(DataElementType.TEXT_EDIT);
                de.setName("scadcorr");
                dati.add(de);
            }
        } else if (riusoIdCorrelazioneApplicativaPA && numCorrelazioneReq > 0 && this.isModalitaAvanzata()) {
            de = new DataElement();
            de.setLabel("Scadenza (minuti)");
            de.setNote("Definisce una scadenza per il riuso del solito ID Protocollo");
            de.setValue(scadcorr);
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("scadcorr");
            dati.add(de);
        }
        de = new DataElement();
        de.setType(DataElementType.LINK);
        de.setUrl(urlRichiesta);
        if (contaListe.booleanValue()) {
            ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Regole", (Long)Long.valueOf(numCorrelazioneReq));
        } else {
            ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Regole");
        }
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.SUBTITLE);
        de.setLabel("Risposta");
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.LINK);
        de.setUrl(urlRisposta);
        if (contaListe.booleanValue()) {
            ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Regole", (Long)Long.valueOf(numCorrelazioneRes));
        } else {
            ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Regole");
        }
        dati.add(de);
        dati = this.addParameterApplicaModifica(dati);
        return dati;
    }

    public List<DataElement> addParameterApplicaModifica(List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("applicaMod");
        de.setValue("yes");
        dati.add(de);
        return dati;
    }

    public boolean correlazioneApplicativaCheckData(TipoOperazione tipoOp, boolean portaDelegata, String scadcorr) throws DriverControlStationException {
        try {
            if (scadcorr != null && !scadcorr.equals("")) {
                int scadCorrInt = -1;
                try {
                    scadCorrInt = Integer.parseInt(scadcorr);
                }
                catch (Exception e) {
                    this.pd.setMessage("Scadenza Correlazione Applicativa non valida, inserire un numero intero maggiore di zero");
                    return false;
                }
                if (scadCorrInt <= 0) {
                    this.pd.setMessage("Scadenza Correlazione Applicativa non valida, inserire un numero intero maggiore di zero");
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean correlazioneApplicativaRichiestaCheckData(TipoOperazione tipoOp, boolean portaDelegata, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws DriverControlStationException {
        try {
            String id = this.getParameter("id");
            int idInt = Integer.parseInt(id);
            String elemxml = this.getParameter("elemxml");
            String mode = this.getParameter("mode");
            String pattern = this.getParameter("pattern");
            String idcorr = this.getParameter("idcorr");
            int idcorrInt = 0;
            if (idcorr != null) {
                idcorrInt = Integer.parseInt(idcorr);
            }
            if (elemxml != null && !"".equals(elemxml) && !this.checkLength255(elemxml, "Elemento")) {
                return false;
            }
            if ((mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_URL_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_HEADER_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_CONTENT_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_FREEMARKER_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_VELOCITY_TEMPLATE)) && pattern.equals("")) {
                String label = "";
                label = mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_HEADER_BASED) ? "Nome" : (mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_FREEMARKER_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_VELOCITY_TEMPLATE) ? "Template" : "Pattern");
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", label));
                return false;
            }
            if (!(mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_URL_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_HEADER_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_CONTENT_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_INPUT_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_FREEMARKER_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_VELOCITY_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_DISABILITATO))) {
                this.pd.setMessage("Modalit&agrave; identificazione dev'essere disabilitato, headerBased, urlBased, contentBased o inputBased ");
                return false;
            }
            if (mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_URL_BASED) && !this.checkRegexp(pattern, ModalitaIdentificazione.URL_BASED.getLabelParametro())) {
                return false;
            }
            if (mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_TEMPLATE)) {
                try {
                    DynamicUtils.validate((String)ModalitaIdentificazione.GOVWAY_TEMPLATE.getLabelParametro(), (String)pattern, (boolean)false);
                }
                catch (Exception e) {
                    this.pd.setMessage("Il valore indicato nel parametro '" + ModalitaIdentificazione.GOVWAY_TEMPLATE.getLabelParametro() + "' non risulta corretto: " + e.getMessage());
                    return false;
                }
            }
            if (mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_CONTENT_BASED) && (org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding) ? !this.checkXPath(pattern, ModalitaIdentificazione.CONTENT_BASED.getLabelParametro()) : !this.checkXPathOrJsonPath(pattern, ModalitaIdentificazione.CONTENT_BASED.getLabelParametro()))) {
                return false;
            }
            boolean giaRegistrato = false;
            StringBuilder existsMessage = new StringBuilder();
            giaRegistrato = portaDelegata ? ConsoleUtilities.alreadyExistsCorrelazioneApplicativaRichiesta(this.porteDelegateCore, (long)idInt, elemxml, (long)idcorrInt, existsMessage) : ConsoleUtilities.alreadyExistsCorrelazioneApplicativaRichiesta(this.porteApplicativeCore, (long)idInt, elemxml, (long)idcorrInt, existsMessage);
            if (giaRegistrato) {
                this.pd.setMessage(existsMessage.toString());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean correlazioneApplicativaRispostaCheckData(TipoOperazione tipoOp, boolean portaDelegata, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws DriverControlStationException {
        try {
            String id = this.getParameter("id");
            int idInt = Integer.parseInt(id);
            String elemxml = this.getParameter("elemxml");
            String mode = this.getParameter("mode");
            String pattern = this.getParameter("pattern");
            String idcorr = this.getParameter("idcorr");
            int idcorrInt = 0;
            if (idcorr != null) {
                idcorrInt = Integer.parseInt(idcorr);
            }
            if (elemxml != null && !"".equals(elemxml) && !this.checkLength255(elemxml, "Elemento")) {
                return false;
            }
            if ((mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_URL_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_HEADER_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_CONTENT_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_FREEMARKER_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_VELOCITY_TEMPLATE)) && pattern.equals("")) {
                String label = "";
                label = mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_HEADER_BASED) ? "Nome" : (mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_FREEMARKER_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_VELOCITY_TEMPLATE) ? "Template" : "Pattern");
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", label));
                return false;
            }
            if (!(mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_URL_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_HEADER_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_CONTENT_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_INPUT_BASED) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_FREEMARKER_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_VELOCITY_TEMPLATE) || mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_DISABILITATO))) {
                this.pd.setMessage("Modalit&agrave; identificazione dev'essere disabilitato, headerBased, urlBased, contentBased o inputBased ");
                return false;
            }
            if (mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_URL_BASED) && !this.checkRegexp(pattern, ModalitaIdentificazione.URL_BASED.getLabelParametro())) {
                return false;
            }
            if (mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_TEMPLATE)) {
                try {
                    DynamicUtils.validate((String)ModalitaIdentificazione.GOVWAY_TEMPLATE.getLabelParametro(), (String)pattern, (boolean)false);
                }
                catch (Exception e) {
                    this.pd.setMessage("Il valore indicato nel parametro '" + ModalitaIdentificazione.GOVWAY_TEMPLATE.getLabelParametro() + "' non risulta corretto: " + e.getMessage());
                    return false;
                }
            }
            if (mode.equals(CostantiControlStation.VALUE_PARAMETRO_MODE_CORRELAZIONE_CONTENT_BASED) && (org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding) ? !this.checkXPath(pattern, ModalitaIdentificazione.CONTENT_BASED.getLabelParametro()) : !this.checkXPathOrJsonPath(pattern, ModalitaIdentificazione.CONTENT_BASED.getLabelParametro()))) {
                return false;
            }
            boolean giaRegistrato = false;
            StringBuilder existsMessage = new StringBuilder();
            giaRegistrato = portaDelegata ? ConsoleUtilities.alreadyExistsCorrelazioneApplicativaRisposta(this.porteDelegateCore, (long)idInt, elemxml, (long)idcorrInt, existsMessage) : ConsoleUtilities.alreadyExistsCorrelazioneApplicativaRisposta(this.porteApplicativeCore, (long)idInt, elemxml, (long)idcorrInt, existsMessage);
            if (giaRegistrato) {
                this.pd.setMessage(existsMessage.toString());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean MTOMCheckData(TipoOperazione tipoOp) throws DriverControlStationException {
        try {
            String mtomRichiesta = this.getParameter("mtomReq");
            String mtomRisposta = this.getParameter("mtomRes");
            if (!(mtomRichiesta.equals("disable") || mtomRichiesta.equals("packaging") || mtomRichiesta.equals("verify") || mtomRichiesta.equals("unpackaging"))) {
                this.pd.setMessage("Stato della Richiesta dev'essere disabled, packaging, unpackaging o verify.");
                return false;
            }
            if (!(mtomRisposta.equals("disable") || mtomRisposta.equals("packaging") || mtomRisposta.equals("verify") || mtomRisposta.equals("unpackaging"))) {
                this.pd.setMessage("Stato della Risposta dev'essere disabled, packaging, unpackaging o verify.");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean MTOMParameterCheckData(TipoOperazione tipoOp, boolean isRisposta, boolean isPortaDelegata) throws DriverControlStationException {
        try {
            String id = this.getParameter("id");
            int idInt = Integer.parseInt(id);
            String nome = this.getParameter("nome");
            String contentType = this.getParameter("contentT");
            String pattern = this.getParameter("pattern");
            if (nome.equals("") || pattern.equals("")) {
                Object tmpElenco = "";
                if (nome.equals("")) {
                    tmpElenco = "Nome";
                }
                if (pattern.equals("")) {
                    tmpElenco = ((String)tmpElenco).equals("") ? "Pattern" : (String)tmpElenco + ", Pattern";
                }
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", tmpElenco));
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo Nome");
                return false;
            }
            if (pattern.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo Pattern");
                return false;
            }
            if (contentType != null && contentType.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo Content Type");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (contentType != null && !"".equals(contentType) && !this.checkLength255(contentType, "Content Type")) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                MtomProcessor mtomProcessor = null;
                boolean giaRegistrato = false;
                String nomeporta = null;
                if (isPortaDelegata) {
                    PortaDelegata pde = this.porteDelegateCore.getPortaDelegata(idInt);
                    nomeporta = pde.getNome();
                    mtomProcessor = pde.getMtomProcessor();
                } else {
                    PortaApplicativa pa = this.porteApplicativeCore.getPortaApplicativa(idInt);
                    nomeporta = pa.getNome();
                    mtomProcessor = pa.getMtomProcessor();
                }
                if (mtomProcessor != null) {
                    if (!isRisposta) {
                        if (mtomProcessor.getRequestFlow() != null) {
                            for (int i = 0; i < mtomProcessor.getRequestFlow().sizeParameterList(); ++i) {
                                MtomProcessorFlowParameter tmpMTOM = mtomProcessor.getRequestFlow().getParameter(i);
                                if (!nome.equals(tmpMTOM.getNome())) continue;
                                giaRegistrato = true;
                                break;
                            }
                        }
                    } else if (mtomProcessor.getResponseFlow() != null) {
                        for (int i = 0; i < mtomProcessor.getResponseFlow().sizeParameterList(); ++i) {
                            MtomProcessorFlowParameter tmpMTOM = mtomProcessor.getResponseFlow().getParameter(i);
                            if (!nome.equals(tmpMTOM.getNome())) continue;
                            giaRegistrato = true;
                            break;
                        }
                    }
                }
                if (giaRegistrato) {
                    if (isPortaDelegata) {
                        this.pd.setMessage(MessageFormat.format("La propriet&agrave; di MTOM {0} &egrave; gi&agrave; stato associata alla porta delegata {1}", nome, nomeporta));
                    } else {
                        this.pd.setMessage(MessageFormat.format("La propriet&agrave; di MTOM {0} &egrave; gi&agrave; stato associata alla porta applicativa {1}", nome, nomeporta));
                    }
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addMTOMParameterToDati(TipoOperazione tipoOp, List<DataElement> dati, boolean enableUpdate, String nome, String pattern, String contentType, String obbligatorio, MTOMProcessorType type) {
        DataElement de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (tipoOp.equals((Object)TipoOperazione.ADD) || enableUpdate) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nome");
        de.setSize(this.getSize());
        de.setRequired(true);
        DataElementInfo dInfoPattern = new DataElementInfo("Nome");
        switch (type) {
            case PACKAGING: 
            case VERIFY: {
                dInfoPattern.setBody("Identificativo della regola di processamento");
                break;
            }
            default: {
                dInfoPattern = null;
            }
        }
        de.setInfo(dInfoPattern);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Pattern");
        de.setValue(pattern);
        de.setType(DataElementType.TEXT_AREA);
        de.setName("pattern");
        de.setSize(this.getSize());
        de.setRequired(true);
        dInfoPattern = new DataElementInfo("Pattern");
        switch (type) {
            case PACKAGING: {
                dInfoPattern.setBody("Espressione XPath che identifica sul messaggio un elemento da convertire in MTOM-XOP attachment");
                break;
            }
            case VERIFY: {
                dInfoPattern.setBody("Espressione XPath che identifica sul messaggio un elemento; il gateway verifica che l'elemento individuato sia un MTOM-XOP attachment");
                break;
            }
            default: {
                dInfoPattern = null;
            }
        }
        de.setInfo(dInfoPattern);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Content Type");
        de.setValue(contentType);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("contentT");
        de.setSize(this.getSize());
        dInfoPattern = new DataElementInfo("Content Type");
        switch (type) {
            case PACKAGING: {
                dInfoPattern.setBody("L'elemento convertito in MTOM-XOP attachment possieder\u00e0 il Content-Type indicato.<BR/>Nel caso non ne sia definito uno verr\u00e0 utilizzato il Content-Type 'application/octet-stream'");
                break;
            }
            case VERIFY: {
                dInfoPattern.setBody("Indica il Content-Type associato all'attachment MTOM-XOP per l'elemento identificato; il gateway verifica la corrispondenza.<BR/>Nel caso non ne sia definito uno verr\u00e0 utilizzato il Content-Type 'application/octet-stream'");
                break;
            }
            default: {
                dInfoPattern = null;
            }
        }
        de.setInfo(dInfoPattern);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Elemento Obbligatorio");
        de.setType(DataElementType.CHECKBOX);
        if (ServletUtils.isCheckBoxEnabled((String)obbligatorio) || CostantiRegistroServizi.ABILITATO.equals(obbligatorio)) {
            de.setSelected(true);
        }
        de.setName("obbl");
        dati.add(de);
        return dati;
    }

    public List<DataElement> addProtocolPropertiesToDatiRegistry(List<DataElement> dati, ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, ProtocolProperties protocolProperties) throws DriverControlStationException {
        return this.addProtocolPropertiesToDatiRegistry(dati, consoleConfiguration, consoleOperationType, protocolProperties, null, null);
    }

    public List<DataElement> addProtocolPropertiesToDatiRegistry(List<DataElement> dati, ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, ProtocolProperties protocolProperties, List<ProtocolProperty> listaProtocolPropertiesDaDB, Properties binaryPropertyChangeInfoProprietario) throws DriverControlStationException {
        String titleId = null;
        String endTitleId = null;
        String subtitleId = null;
        String endSubtitleId = null;
        for (BaseConsoleItem item : consoleConfiguration.getConsoleItem()) {
            AbstractProperty property = ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)protocolProperties, (String)item.getId());
            Object defaultItemValue = null;
            if (item instanceof AbstractConsoleItem) {
                AbstractConsoleItem itemConsole = (AbstractConsoleItem)item;
                defaultItemValue = itemConsole.getDefaultValue();
            }
            try {
                ProtocolPropertiesUtils.setDefaultValue((BaseConsoleItem)item, (AbstractProperty)property);
                ProtocolProperty protocolProperty = ProtocolPropertiesUtils.getProtocolPropertyRegistry((String)item.getId(), listaProtocolPropertiesDaDB);
                dati = ProtocolPropertiesUtilities.itemToDataElement(dati, this, item, defaultItemValue, consoleOperationType, binaryPropertyChangeInfoProprietario, protocolProperty, this.getSize());
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
            if (ConsoleItemType.TITLE.equals((Object)item.getType()) && item instanceof TitleConsoleItem) {
                TitleConsoleItem titleItem = (TitleConsoleItem)item;
                if (!titleItem.isCloseable()) continue;
                titleId = titleItem.getId();
                endTitleId = titleItem.getLastItemId();
                continue;
            }
            if (ConsoleItemType.SUBTITLE.equals((Object)item.getType()) && item instanceof SubtitleConsoleItem) {
                SubtitleConsoleItem subItem = (SubtitleConsoleItem)item;
                if (!subItem.isCloseable()) continue;
                subtitleId = subItem.getId();
                endSubtitleId = subItem.getLastItemId();
                continue;
            }
            if (endTitleId != null && endTitleId.equals(item.getId())) {
                this.impostaAperturaTitle(dati, titleId);
                continue;
            }
            if (endSubtitleId == null || !endSubtitleId.equals(item.getId())) continue;
            this.impostaAperturaSubTitle(dati, subtitleId);
        }
        DataElement de = new DataElement();
        de.setName("ppSet");
        de.setType(DataElementType.HIDDEN);
        de.setValue("ok");
        dati.add(de);
        return dati;
    }

    public List<DataElement> addProtocolPropertiesToDatiConfig(List<DataElement> dati, ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, ProtocolProperties protocolProperties) throws DriverControlStationException {
        return this.addProtocolPropertiesToDatiRegistry(dati, consoleConfiguration, consoleOperationType, protocolProperties, null, null);
    }

    public List<DataElement> addProtocolPropertiesToDatiConfig(List<DataElement> dati, ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, ProtocolProperties protocolProperties, List<org.openspcoop2.core.config.ProtocolProperty> listaProtocolPropertiesDaDB, Properties binaryPropertyChangeInfoProprietario) throws DriverControlStationException {
        String titleId = null;
        String endTitleId = null;
        String subtitleId = null;
        String endSubtitleId = null;
        for (BaseConsoleItem item : consoleConfiguration.getConsoleItem()) {
            AbstractProperty property = ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)protocolProperties, (String)item.getId());
            Object defaultItemValue = null;
            if (item instanceof AbstractConsoleItem) {
                AbstractConsoleItem itemConsole = (AbstractConsoleItem)item;
                defaultItemValue = itemConsole.getDefaultValue();
            }
            try {
                ProtocolPropertiesUtils.setDefaultValue((BaseConsoleItem)item, (AbstractProperty)property);
                org.openspcoop2.core.config.ProtocolProperty protocolProperty = ProtocolPropertiesUtils.getProtocolPropertyConfig((String)item.getId(), listaProtocolPropertiesDaDB);
                dati = ProtocolPropertiesUtilities.itemToDataElement(dati, this, item, defaultItemValue, consoleOperationType, binaryPropertyChangeInfoProprietario, protocolProperty, this.getSize());
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
            if (ConsoleItemType.TITLE.equals((Object)item.getType()) && item instanceof TitleConsoleItem) {
                TitleConsoleItem titleItem = (TitleConsoleItem)item;
                if (!titleItem.isCloseable()) continue;
                titleId = titleItem.getId();
                endTitleId = titleItem.getLastItemId();
                continue;
            }
            if (ConsoleItemType.SUBTITLE.equals((Object)item.getType()) && item instanceof SubtitleConsoleItem) {
                SubtitleConsoleItem subItem = (SubtitleConsoleItem)item;
                if (!subItem.isCloseable()) continue;
                subtitleId = subItem.getId();
                endSubtitleId = subItem.getLastItemId();
                continue;
            }
            if (endTitleId != null && endTitleId.equals(item.getId())) {
                this.impostaAperturaTitle(dati, titleId);
                continue;
            }
            if (endSubtitleId == null || !endSubtitleId.equals(item.getId())) continue;
            this.impostaAperturaSubTitle(dati, subtitleId);
        }
        DataElement de = new DataElement();
        de.setName("ppSet");
        de.setType(DataElementType.HIDDEN);
        de.setValue("ok");
        dati.add(de);
        return dati;
    }

    public List<DataElement> addProtocolPropertiesToDatiAsHidden(List<DataElement> dati, ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, ProtocolProperties protocolProperties) throws DriverControlStationException {
        return this.addProtocolPropertiesToDatiAsHidden(dati, consoleConfiguration, consoleOperationType, protocolProperties, null, null);
    }

    public List<DataElement> addProtocolPropertiesToDatiAsHidden(List<DataElement> dati, ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, ProtocolProperties protocolProperties, List<ProtocolProperty> listaProtocolPropertiesDaDB, Properties binaryPropertyChangeInfoProprietario) throws DriverControlStationException {
        for (BaseConsoleItem item : consoleConfiguration.getConsoleItem()) {
            AbstractProperty property = ProtocolPropertiesUtils.getAbstractPropertyById((ProtocolProperties)protocolProperties, (String)item.getId());
            Object defaultItemValue = null;
            if (item instanceof AbstractConsoleItem) {
                AbstractConsoleItem itemConsole = (AbstractConsoleItem)item;
                defaultItemValue = itemConsole.getDefaultValue();
            }
            try {
                ProtocolPropertiesUtils.setDefaultValue((BaseConsoleItem)item, (AbstractProperty)property);
                ProtocolProperty protocolProperty = ProtocolPropertiesUtils.getProtocolPropertyRegistry((String)item.getId(), listaProtocolPropertiesDaDB);
                dati = ProtocolPropertiesUtilities.itemToDataElementAsHidden(dati, this, item, defaultItemValue, consoleOperationType, binaryPropertyChangeInfoProprietario, protocolProperty, this.getSize());
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        }
        DataElement de = new DataElement();
        de.setName("ppSet");
        de.setType(DataElementType.HIDDEN);
        de.setValue("ok");
        dati.add(de);
        return dati;
    }

    public void validaProtocolProperties(ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, ProtocolProperties properties) throws ProtocolException {
        try {
            List consoleItems = consoleConfiguration.getConsoleItem();
            for (int i = 0; i < properties.sizeProperties(); ++i) {
                BinaryProperty bp;
                AbstractProperty property = properties.getProperty(i);
                AbstractConsoleItem consoleItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleItems, (AbstractProperty)property);
                if (consoleItem == null || consoleItem.isHidden()) continue;
                if (consoleItem instanceof StringConsoleItem) {
                    StringProperty sp = (StringProperty)property;
                    if (consoleItem.isRequired() && StringUtils.isEmpty((CharSequence)((CharSequence)sp.getValue()))) {
                        if (consoleItem.getLabel() == null || "".equals(consoleItem.getLabel())) {
                            throw new ProtocolException("Dati incompleti.");
                        }
                        throw new ProtocolException(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", consoleItem.getLabel()));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)consoleItem.getRegexpr()) && !RegularExpressionEngine.isMatch((String)((String)sp.getValue()), (String)consoleItem.getRegexpr())) {
                        throw new ProtocolException(MessageFormat.format("Il campo {0} deve rispettare il seguente pattern: {1}", consoleItem.getLabel(), consoleItem.getRegexpr()));
                    }
                    if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)sp.getValue()))) continue;
                    try {
                        if (this.checkLength4000((String)sp.getValue(), consoleItem.getLabel())) continue;
                        throw new ProtocolException(this.pd.getMessage());
                    }
                    catch (Exception e) {
                        throw new ProtocolException(e.getMessage(), (Throwable)e);
                    }
                }
                if (consoleItem instanceof NumberConsoleItem) {
                    NumberConsoleItem nci;
                    NumberProperty np = (NumberProperty)property;
                    if (consoleItem.isRequired() && np.getValue() == null) {
                        if (consoleItem.getLabel() == null || "".equals(consoleItem.getLabel())) {
                            throw new ProtocolException("Dati incompleti.");
                        }
                        throw new ProtocolException(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", consoleItem.getLabel()));
                    }
                    if (np.getValue() == null || !ConsoleItemType.NUMBER.equals((Object)consoleItem.getType()) || !(consoleItem instanceof NumberConsoleItem)) continue;
                    long v = (Long)np.getValue();
                    if (v < (nci = (NumberConsoleItem)consoleItem).getMin()) {
                        throw new ProtocolException(MessageFormat.format("Il valore indicato per {0} \u00e8 minore del minimo consentito: ${1}", consoleItem.getLabel(), nci.getMin()));
                    }
                    if (v <= nci.getMax()) continue;
                    throw new ProtocolException(MessageFormat.format("Il valore indicato per {0} \u00e8 maggiore del massimo consentito: ${1}", consoleItem.getLabel(), nci.getMax()));
                }
                if (consoleItem instanceof BinaryConsoleItem) {
                    bp = (BinaryProperty)property;
                    if (!consoleOperationType.equals((Object)ConsoleOperationType.ADD) || !consoleItem.isRequired() || bp.getValue() != null && ((byte[])bp.getValue()).length != 0) continue;
                    if (consoleItem.getLabel() == null || "".equals(consoleItem.getLabel())) {
                        throw new ProtocolException("Dati incompleti.");
                    }
                    throw new ProtocolException(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", consoleItem.getLabel()));
                }
                if (!(consoleItem instanceof BooleanConsoleItem)) continue;
                bp = (BooleanProperty)property;
                if (!consoleItem.isRequired() || bp.getValue() != null) continue;
                if (consoleItem.getLabel() == null || "".equals(consoleItem.getLabel())) {
                    throw new ProtocolException("Dati incompleti.");
                }
                throw new ProtocolException(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", consoleItem.getLabel()));
            }
        }
        catch (RegExpException | RegExpNotFoundException | RegExpNotValidException e) {
            throw new ProtocolException(e);
        }
        catch (ProtocolException e) {
            throw e;
        }
    }

    public void validaProtocolPropertyBinaria(String nome, ConsoleConfiguration consoleConfiguration, ConsoleOperationType consoleOperationType, ProtocolProperties properties) throws ProtocolException {
        List consoleItems = consoleConfiguration.getConsoleItem();
        for (int i = 0; i < properties.sizeProperties(); ++i) {
            AbstractProperty property = properties.getProperty(i);
            AbstractConsoleItem consoleItem = ProtocolPropertiesUtils.getAbstractConsoleItem((List)consoleItems, (AbstractProperty)property);
            if (consoleItem == null || !(consoleItem instanceof BinaryConsoleItem) || !consoleItem.getId().equals(nome)) continue;
            BinaryProperty bp = (BinaryProperty)property;
            if (!consoleItem.isRequired() || bp.getValue() != null && ((byte[])bp.getValue()).length != 0) continue;
            throw new ProtocolException(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", consoleItem.getLabel()));
        }
    }

    public List<DataElement> addRuoliToDati(TipoOperazione tipoOp, List<DataElement> dati, boolean enableUpdate, FiltroRicercaRuoli filtroRuoli, String nome, List<String> ruoliGiaConfigurati, boolean addSelezioneVuota, boolean addMsgServiziApplicativoNonDisponibili, boolean addTitoloSezione, String accessDaChangeTmp, boolean isToken) throws DriverRegistroServiziException {
        return this.addRuoliToDati(tipoOp, dati, enableUpdate, filtroRuoli, nome, ruoliGiaConfigurati, addSelezioneVuota, addMsgServiziApplicativoNonDisponibili, "Nome", addTitoloSezione, accessDaChangeTmp, isToken);
    }

    public List<DataElement> addRuoliToDati(TipoOperazione tipoOp, List<DataElement> dati, boolean enableUpdate, FiltroRicercaRuoli filtroRuoli, String nome, List<String> ruoliGiaConfigurati, boolean addSelezioneVuota, boolean addMsgServiziApplicativoNonDisponibili, String labelParametro, boolean addTitoloSezione, String accessDaChangeTmp, boolean isToken) throws DriverRegistroServiziException {
        List<String> allRuoli = this.confCore.getAllRuoli(filtroRuoli);
        ArrayList<String> ruoliDaFarScegliere = new ArrayList<String>();
        if (ruoliGiaConfigurati != null && ruoliGiaConfigurati.size() > 0) {
            for (String ruolo : allRuoli) {
                if (ruoliGiaConfigurati.contains(ruolo)) continue;
                ruoliDaFarScegliere.add(ruolo);
            }
        } else {
            ruoliDaFarScegliere.addAll(allRuoli);
        }
        DataElement de = new DataElement();
        de.setName("accessoDaChange");
        de.setType(DataElementType.HIDDEN);
        de.setValue(accessDaChangeTmp);
        dati.add(de);
        if (isToken) {
            de = new DataElement();
            de.setType(DataElementType.HIDDEN);
            de.setName("tokenAuthz");
            de.setValue("true");
            dati.add(de);
        }
        if (ruoliDaFarScegliere.size() > 0) {
            if (addTitoloSezione) {
                de = new DataElement();
                de.setLabel("Ruolo");
                de.setType(DataElementType.TITLE);
                dati.add(de);
            }
            ArrayList<String> ruoli = new ArrayList<String>();
            if (addSelezioneVuota) {
                ruoli.add("-");
            }
            ruoli.addAll(ruoliDaFarScegliere);
            de = new DataElement();
            de.setLabel(labelParametro);
            de.setValue(nome);
            if (tipoOp.equals((Object)TipoOperazione.ADD) || enableUpdate) {
                de.setType(DataElementType.SELECT);
                de.setValues(ruoli);
                de.setSelected(nome);
            } else {
                de.setType(DataElementType.TEXT);
            }
            de.setName("ruolo");
            de.setSize(this.getSize());
            dati.add(de);
        } else if (addMsgServiziApplicativoNonDisponibili) {
            if (allRuoli.size() > 0) {
                this.pd.setMessage("Non esistono ulteriori ruoli associabili");
            } else {
                this.pd.setMessage("Non esistono ruoli associabili");
            }
            this.pd.disableEditMode();
        }
        return dati;
    }

    public List<DataElement> addScopeToDati(TipoOperazione tipoOp, List<DataElement> dati, boolean enableUpdate, FiltroRicercaScope filtroScope, String nome, List<String> ruoliGiaConfigurati, boolean addSelezioneVuota, boolean addMsgServiziApplicativoNonDisponibili, boolean addTitoloSezione) throws DriverRegistroServiziException {
        return this.addScopeToDati(tipoOp, dati, enableUpdate, filtroScope, nome, ruoliGiaConfigurati, addSelezioneVuota, addMsgServiziApplicativoNonDisponibili, "Nome", addTitoloSezione);
    }

    public List<DataElement> addScopeToDati(TipoOperazione tipoOp, List<DataElement> dati, boolean enableUpdate, FiltroRicercaScope filtroScope, String nome, List<String> scopeGiaConfigurati, boolean addSelezioneVuota, boolean addMsgServiziApplicativoNonDisponibili, String labelParametro, boolean addTitoloSezione) throws DriverRegistroServiziException {
        List<String> allRuoli = this.confCore.getAllScope(filtroScope);
        ArrayList<String> scopeDaFarScegliere = new ArrayList<String>();
        if (scopeGiaConfigurati != null && scopeGiaConfigurati.size() > 0) {
            for (String ruolo : allRuoli) {
                if (scopeGiaConfigurati.contains(ruolo)) continue;
                scopeDaFarScegliere.add(ruolo);
            }
        } else {
            scopeDaFarScegliere.addAll(allRuoli);
        }
        if (scopeDaFarScegliere.size() > 0) {
            if (addTitoloSezione) {
                DataElement de = new DataElement();
                de.setLabel("Scope");
                de.setType(DataElementType.TITLE);
                dati.add(de);
            }
            ArrayList<String> ruoli = new ArrayList<String>();
            if (addSelezioneVuota) {
                ruoli.add("-");
            }
            ruoli.addAll(scopeDaFarScegliere);
            DataElement de = new DataElement();
            de.setLabel(labelParametro);
            de.setValue(nome);
            if (tipoOp.equals((Object)TipoOperazione.ADD) || enableUpdate) {
                de.setType(DataElementType.SELECT);
                de.setValues(ruoli);
                de.setSelected(nome);
            } else {
                de.setType(DataElementType.TEXT);
            }
            de.setName("scope");
            de.setSize(this.getSize());
            dati.add(de);
        } else if (addMsgServiziApplicativoNonDisponibili) {
            if (allRuoli.size() > 0) {
                this.pd.setMessage("Non esistono ulteriori scope associabili");
            } else {
                this.pd.setMessage("Non esistono scope associabili");
            }
            this.pd.disableEditMode();
        }
        return dati;
    }

    public boolean ruoloCheckData(TipoOperazione tipoOp, String nome, List<String> ruoli) throws DriverControlStationException {
        try {
            if (ruoli != null && ruoli.contains(nome)) {
                this.pd.setMessage(MessageFormat.format("Il ruolo ''{0}'' &egrave; gi&agrave; stato associata al soggetto", nome));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean scopeCheckData(TipoOperazione tipoOp, String nome, List<String> scopes) throws DriverControlStationException {
        try {
            if (scopes != null && scopes.contains(nome)) {
                this.pd.setMessage(MessageFormat.format("Lo scope ''{0}'' &egrave; gi&agrave; stato associata al soggetto", nome));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void controlloAccessi(List<DataElement> dati) throws DriverControlStationException {
        DataElement de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Controllo degli Accessi");
        dati.add(de);
    }

    public List<String> convertFromDataElementValue_parametroAutenticazioneList(String autenticazione, TipoAutenticazionePrincipal autenticazionePrincipal) throws DriverControlStationException {
        ArrayList<Object> l = null;
        if (TipoAutenticazione.BASIC.equals(autenticazione)) {
            String v = this.getParameter("autenticazioneParametro0");
            if (v != null && !"".equals(v)) {
                l = new ArrayList();
                l.add(v);
            }
        } else if (TipoAutenticazione.PRINCIPAL.equals(autenticazione)) {
            if (autenticazionePrincipal == null) {
                autenticazionePrincipal = TipoAutenticazionePrincipal.CONTAINER;
            }
            switch (autenticazionePrincipal) {
                case CONTAINER: 
                case INDIRIZZO_IP: 
                case INDIRIZZO_IP_X_FORWARDED_FOR: {
                    break;
                }
                case HEADER: 
                case FORM: {
                    String v = this.getParameter("autenticazioneParametro0");
                    if (v != null && !"".equals(v)) {
                        l = new ArrayList();
                        l.add(v);
                    }
                    if (l == null || (v = this.getParameter("autenticazioneParametro1")) == null || "".equals(v)) break;
                    l.add(v);
                    break;
                }
                case URL: {
                    String v = this.getParameter("autenticazioneParametro0");
                    if (v == null || "".equals(v)) break;
                    l = new ArrayList();
                    l.add(v);
                    break;
                }
                case TOKEN: {
                    String v = this.getParameter("autenticazioneParametro0");
                    if (v != null && !"".equals(v)) {
                        l = new ArrayList();
                        l.add(v);
                    }
                    if (l == null || (v = this.getParameter("autenticazioneParametro1")) == null || "".equals(v)) break;
                    l.add(v);
                }
            }
        } else if (TipoAutenticazione.APIKEY.equals(autenticazione)) {
            l = new ArrayList<Object>();
            String v = this.getParameter("autenticazioneParametro0");
            l.add("" + ServletUtils.isCheckBoxEnabled((String)v));
            String[] vPos = this.getParameterValues("autenticazioneParametro1");
            boolean query = false;
            boolean header = false;
            boolean cookie = false;
            if (vPos != null && vPos.length > 0) {
                for (int i = 0; i < vPos.length; ++i) {
                    String sel = vPos[i];
                    if ("queryParameter".equals(sel)) {
                        query = true;
                        continue;
                    }
                    if ("header".equals(sel)) {
                        header = true;
                        continue;
                    }
                    if (!"cookie".equals(sel)) continue;
                    cookie = true;
                }
            }
            l.add("" + query);
            l.add("" + header);
            l.add("" + cookie);
            v = this.getParameter("autenticazioneParametro2");
            l.add("" + ServletUtils.isCheckBoxEnabled((String)v));
            String forwardApiKey = this.getParameter("autenticazioneParametro3");
            if (ServletUtils.isCheckBoxEnabled((String)forwardApiKey)) {
                l.add("false");
            } else {
                l.add("true");
            }
            String forwardAppId = this.getParameter("autenticazioneParametro7");
            if (ServletUtils.isCheckBoxEnabled((String)forwardAppId)) {
                l.add("false");
            } else {
                l.add("true");
            }
            v = this.getParameter("autenticazioneParametro4");
            l.add(v);
            v = this.getParameter("autenticazioneParametro5");
            l.add(v);
            v = this.getParameter("autenticazioneParametro6");
            l.add(v);
            v = this.getParameter("autenticazioneParametro8");
            l.add(v);
            v = this.getParameter("autenticazioneParametro9");
            l.add(v);
            v = this.getParameter("autenticazioneParametro10");
            l.add(v);
        }
        return l;
    }

    public void controlloAccessiAdd(List<DataElement> dati, TipoOperazione tipoOperazione, String statoControlloAccessiAdd, boolean forceAutenticato) {
        if (!this.isModalitaCompleta() && TipoOperazione.ADD.equals((Object)tipoOperazione)) {
            DataElement de;
            if (!forceAutenticato) {
                de = new DataElement();
                de.setLabel("Controllo degli Accessi");
                de.setType(DataElementType.TITLE);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Accesso API");
            de.setName("controlloAccessiStato");
            if (forceAutenticato) {
                de.setType(DataElementType.HIDDEN);
                de.setValue("autenticato");
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_PORTE_CONTROLLO_ACCESSI_STATO);
                de.setLabels(CostantiControlStation.SELECT_VALUES_PARAMETRO_PORTE_CONTROLLO_ACCESSI_STATO);
                de.setSelected(statoControlloAccessiAdd);
            }
            dati.add(de);
        }
    }

    public void controlloAccessiAutenticazione(List<DataElement> dati, TipoOperazione tipoOperazione, String servletChiamante, Object oggetto, String protocolloParam, String autenticazione, String autenticazioneCustom, String autenticazioneOpzionale, TipoAutenticazionePrincipal autenticazionePrincipal, List<String> autenticazioneParametroList, boolean confPers, boolean isSupportatoAutenticazioneSoggetti, boolean isPortaDelegata, String gestioneToken, String gestioneTokenPolicy, String autenticazioneTokenIssuer, String autenticazioneTokenClientId, String autenticazioneTokenSubject, String autenticazioneTokenUsername, String autenticazioneTokenEMail, boolean oldAutenticazioneCustom, String urlAutenticazioneCustomProperties, int numAutenticazioneCustomPropertiesList, boolean forceHttps, boolean forceDisableOptional) throws DriverControlStationException {
        String protocollo;
        boolean tokenAbilitato;
        boolean bl = tokenAbilitato = StatoFunzionalita.ABILITATO.getValue().equalsIgnoreCase(gestioneToken) && gestioneTokenPolicy != null && !gestioneTokenPolicy.equals("-");
        boolean mostraSezione = !tipoOperazione.equals((Object)TipoOperazione.ADD) || (isPortaDelegata ? this.core.isEnabledAutenticazione_generazioneAutomaticaPorteDelegate() : this.core.isEnabledAutenticazione_generazioneAutomaticaPorteApplicative());
        boolean allHidden = false;
        if (!this.isModalitaCompleta() && TipoOperazione.ADD.equals((Object)tipoOperazione)) {
            allHidden = true;
        }
        if (((protocollo = protocolloParam) == null || "".equals(protocollo)) && oggetto != null) {
            if (isPortaDelegata) {
                PortaDelegata pd = (PortaDelegata)oggetto;
                if (pd != null && pd.getServizio() != null && pd.getServizio().getTipo() != null) {
                    try {
                        protocollo = this.apsCore.getProtocolloAssociatoTipoServizio(pd.getServizio().getTipo());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                }
            } else {
                PortaApplicativa pa = (PortaApplicativa)oggetto;
                if (pa != null && pa.getServizio() != null && pa.getServizio().getTipo() != null) {
                    try {
                        protocollo = this.apsCore.getProtocolloAssociatoTipoServizio(pa.getServizio().getTipo());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                }
            }
        }
        boolean existsAutorizzazioniPuntuali = false;
        if (oggetto != null) {
            if (isPortaDelegata) {
                PortaDelegata pdObject = (PortaDelegata)oggetto;
                if (pdObject != null && pdObject.sizeServizioApplicativoList() > 0) {
                    existsAutorizzazioniPuntuali = true;
                }
            } else {
                PortaApplicativa pa = (PortaApplicativa)oggetto;
                if (pa != null && (pa.getSoggetti() != null && pa.getSoggetti().sizeSoggettoList() > 0 || pa.getServiziApplicativiAutorizzati() != null && pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0)) {
                    existsAutorizzazioniPuntuali = true;
                }
            }
        }
        boolean modipa = this.isProfiloModIPA(protocollo);
        if (forceHttps) {
            autenticazione = TipoAutenticazione.SSL.getValue();
        }
        if (forceDisableOptional) {
            if ("porteApplicativeControlloAccessi.do".equals(servletChiamante) && ServletUtils.isCheckBoxEnabled((String)autenticazioneOpzionale)) {
                forceDisableOptional = false;
            } else {
                autenticazioneOpzionale = "no";
            }
        }
        if (mostraSezione) {
            boolean addTitle;
            if (tokenAbilitato) {
                DataElement de;
                if (!allHidden) {
                    de = new DataElement();
                    de.setType(DataElementType.SUBTITLE);
                    de.setLabel("Required Claims");
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Issuer");
                de.setName("autenticazioneIssuer");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue("" + ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenIssuer));
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenIssuer));
                }
                dati.add(de);
                de = new DataElement();
                de.setLabel("ClientId");
                de.setName("autenticazioneClientId");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue("" + ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenClientId));
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenClientId));
                }
                dati.add(de);
                de = new DataElement();
                de.setLabel("Subject");
                de.setName("autenticazioneSubject");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue("" + ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenSubject));
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenSubject));
                }
                dati.add(de);
                de = new DataElement();
                de.setLabel("Username");
                de.setName("autenticazioneUsername");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue("" + ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenUsername));
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenUsername));
                }
                dati.add(de);
                de = new DataElement();
                de.setLabel("eMail");
                de.setName("autenticazioneEMail");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue("" + ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenEMail));
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(ServletUtils.isCheckBoxEnabled((String)autenticazioneTokenEMail));
                }
                dati.add(de);
            }
            boolean bl2 = addTitle = !allHidden && isSupportatoAutenticazioneSoggetti;
            if (addTitle) {
                DataElement de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setName("autenticazioneTitle");
                if (modipa && !isPortaDelegata) {
                    de.setLabel("Autenticazione Canale");
                } else {
                    de.setLabel("Autenticazione Trasporto");
                }
                de.setStatoAperturaSezioni(DataElement.STATO_APERTURA_SEZIONI.APERTO);
                dati.add(de);
            }
            if (isSupportatoAutenticazioneSoggetti) {
                List autenticazioneValues = TipoAutenticazione.getValues();
                List autenticazioneLabels = TipoAutenticazione.getLabels();
                int totEl = autenticazioneValues.size();
                if (confPers) {
                    ++totEl;
                }
                String[] tipoAutenticazione = new String[totEl];
                String[] labelTipoAutenticazione = new String[totEl];
                for (int i = 0; i < autenticazioneValues.size(); ++i) {
                    tipoAutenticazione[i] = (String)autenticazioneValues.get(i);
                    labelTipoAutenticazione[i] = (String)autenticazioneLabels.get(i);
                }
                if (confPers) {
                    tipoAutenticazione[totEl - 1] = "custom";
                    labelTipoAutenticazione[totEl - 1] = "plugin";
                }
                DataElement de = new DataElement();
                de.setLabel("Stato");
                de.setName("autenticazione");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(autenticazione);
                } else if (forceHttps) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(autenticazione);
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Stato");
                    de.setName("autenticazione__label");
                    de.setType(DataElementType.TEXT);
                    de.setValue(TipoAutenticazione.SSL.getLabel());
                    de.setValoreDefault(TipoAutenticazione.DISABILITATO.getLabel());
                } else if (existsAutorizzazioniPuntuali) {
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(autenticazione);
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Stato");
                    de.setName("autenticazione__label");
                    de.setType(DataElementType.TEXT);
                    String labelAutenticazione = null;
                    for (int i = 0; i < tipoAutenticazione.length; ++i) {
                        if (autenticazione == null || !autenticazione.equals(tipoAutenticazione[i])) continue;
                        labelAutenticazione = labelTipoAutenticazione[i];
                        break;
                    }
                    de.setValue(labelAutenticazione != null ? labelAutenticazione : autenticazione);
                    de.setValoreDefault(TipoAutenticazione.DISABILITATO.getLabel());
                } else {
                    de.setType(DataElementType.SELECT);
                    de.setValues(tipoAutenticazione);
                    de.setLabels(labelTipoAutenticazione);
                    de.setPostBack(true);
                    de.setSelected(autenticazione);
                    de.setValoreDefaultSelect(TipoAutenticazione.DISABILITATO.getValue());
                }
                dati.add(de);
                String tipoAutenticazioneCustom = isPortaDelegata ? "Fruizione" : "Erogazione";
                boolean autenticazioneCustomHidden = allHidden || autenticazione == null || !autenticazione.equals("custom");
                this.addCustomField(TipoPlugin.AUTENTICAZIONE, tipoAutenticazioneCustom, null, "autenticazione", "autenticazioneCustom", "Tipo Personalizzato", autenticazioneCustom, autenticazioneCustomHidden, dati, false);
                if (autenticazione != null && autenticazione.equals("custom") && oldAutenticazioneCustom) {
                    Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setUrl(urlAutenticazioneCustomProperties);
                    String labelCustomProperties = "Propriet&agrave;";
                    if (contaListe.booleanValue()) {
                        ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelCustomProperties, (Long)Long.valueOf(numAutenticazioneCustomPropertiesList));
                    } else {
                        ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelCustomProperties);
                    }
                    dati.add(de);
                }
                try {
                    if ("autenticazione".equals(this.getPostBackElementName())) {
                        autenticazioneParametroList = null;
                    }
                }
                catch (Exception contaListe) {
                    // empty catch block
                }
                boolean addOpzionale = true;
                if (TipoAutenticazione.BASIC.equals(autenticazione)) {
                    String autenticazioneParametro = null;
                    if (autenticazioneParametroList != null && !autenticazioneParametroList.isEmpty()) {
                        autenticazioneParametro = autenticazioneParametroList.get(0);
                    }
                    de = new DataElement();
                    de.setLabel("Forward Authorization");
                    de.setName("autenticazioneParametro0");
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("" + ServletUtils.isCheckBoxEnabled((String)autenticazioneParametro));
                    } else {
                        de.setType(DataElementType.CHECKBOX);
                        if (autenticazioneParametro == null || "".equals(autenticazioneParametro)) {
                            autenticazioneParametro = "no";
                        }
                        de.setSelected(ServletUtils.isCheckBoxEnabled((String)autenticazioneParametro));
                    }
                    dati.add(de);
                } else if (TipoAutenticazione.PRINCIPAL.equals(autenticazione)) {
                    List autenticazionePrincipalValues = TipoAutenticazionePrincipal.getValues((boolean)tokenAbilitato);
                    List autenticazionePrincipalLabels = TipoAutenticazionePrincipal.getLabels((boolean)tokenAbilitato);
                    de = new DataElement();
                    de.setLabel("Tipo");
                    de.setName("autenticazionePrincipalTipo");
                    if (autenticazionePrincipal == null) {
                        autenticazionePrincipal = TipoAutenticazionePrincipal.CONTAINER;
                    }
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue(autenticazionePrincipal.getValue());
                    } else {
                        de.setType(DataElementType.SELECT);
                        de.setValues(autenticazionePrincipalValues);
                        de.setLabels(autenticazionePrincipalLabels);
                        de.setPostBack(true);
                        de.setSelected(autenticazionePrincipal.getValue());
                    }
                    dati.add(de);
                    switch (autenticazionePrincipal) {
                        case CONTAINER: 
                        case INDIRIZZO_IP: 
                        case INDIRIZZO_IP_X_FORWARDED_FOR: {
                            break;
                        }
                        case HEADER: 
                        case FORM: {
                            String autenticazioneParametro = null;
                            if (autenticazioneParametroList != null && !autenticazioneParametroList.isEmpty()) {
                                autenticazioneParametro = autenticazioneParametroList.get(0);
                            }
                            de = new DataElement();
                            if (TipoAutenticazionePrincipal.HEADER.equals((Object)autenticazionePrincipal)) {
                                de.setLabel(CostantiControlStation.LABEL_PARAMETRO_PORTE_AUTENTICAZIONE_PRINCIPAL_HEADER);
                            } else {
                                de.setLabel(CostantiControlStation.LABEL_PARAMETRO_PORTE_AUTENTICAZIONE_PRINCIPAL_FORM);
                            }
                            de.setName("autenticazioneParametro0");
                            de.setValue(autenticazioneParametro);
                            if (allHidden) {
                                de.setType(DataElementType.HIDDEN);
                            } else {
                                de.setType(DataElementType.TEXT_EDIT);
                                de.setRequired(true);
                            }
                            dati.add(de);
                            if (autenticazioneParametroList != null && !autenticazioneParametroList.isEmpty() && autenticazioneParametroList.size() > 1) {
                                autenticazioneParametro = autenticazioneParametroList.get(1);
                            }
                            de = new DataElement();
                            de.setName("autenticazioneParametro1");
                            if (TipoAutenticazionePrincipal.HEADER.equals((Object)autenticazionePrincipal)) {
                                de.setLabel("Forward Header");
                            } else {
                                de.setLabel("Forward Parametro Url");
                            }
                            if (autenticazioneParametro == null || "".equals(autenticazioneParametro)) {
                                autenticazioneParametro = "no";
                            }
                            if (allHidden) {
                                de.setType(DataElementType.HIDDEN);
                                de.setValue(autenticazioneParametro);
                            } else {
                                de.setType(DataElementType.CHECKBOX);
                                de.setSelected(ServletUtils.isCheckBoxEnabled((String)autenticazioneParametro));
                            }
                            dati.add(de);
                            break;
                        }
                        case URL: {
                            String autenticazioneParametro = null;
                            if (autenticazioneParametroList != null && !autenticazioneParametroList.isEmpty()) {
                                autenticazioneParametro = autenticazioneParametroList.get(0);
                            }
                            de = new DataElement();
                            de.setLabel(CostantiControlStation.LABEL_PARAMETRO_PORTE_AUTENTICAZIONE_PRINCIPAL_ESPRESSIONE);
                            de.setName("autenticazioneParametro0");
                            de.setValue(autenticazioneParametro);
                            if (allHidden) {
                                de.setType(DataElementType.HIDDEN);
                            } else {
                                de.setType(DataElementType.TEXT_AREA);
                                de.setRequired(true);
                            }
                            dati.add(de);
                            break;
                        }
                        case TOKEN: {
                            String autenticazioneParametro = null;
                            if (autenticazioneParametroList != null && !autenticazioneParametroList.isEmpty()) {
                                autenticazioneParametro = autenticazioneParametroList.get(0);
                            }
                            de = new DataElement();
                            de.setLabel(CostantiControlStation.LABEL_PARAMETRO_PORTE_AUTENTICAZIONE_PRINCIPAL_TOKEN_CLAIM);
                            de.setName("autenticazioneParametro0");
                            de.setValue(autenticazioneParametro);
                            if (allHidden) {
                                de.setType(DataElementType.HIDDEN);
                            } else {
                                de.setType(DataElementType.SELECT);
                                ArrayList<String> values = new ArrayList<String>();
                                values.add("subject");
                                values.add("clientId");
                                values.add("eMail");
                                values.add("username");
                                ArrayList<String> labels = new ArrayList<String>();
                                labels.addAll(values);
                                values.add("custom");
                                labels.add("seleziona altro claim");
                                de.setValues(values);
                                de.setLabels(labels);
                                de.setSelected(autenticazioneParametro);
                                de.setRequired(true);
                                de.setPostBack(true);
                            }
                            dati.add(de);
                            boolean claimProprietario = "custom".equals(autenticazioneParametro);
                            if (!claimProprietario) break;
                            autenticazioneParametro = autenticazioneParametroList != null && !autenticazioneParametroList.isEmpty() && autenticazioneParametroList.size() > 1 ? autenticazioneParametroList.get(1) : null;
                            de = new DataElement();
                            de.setName("autenticazioneParametro1");
                            de.setLabel("Nome");
                            de.setValue(autenticazioneParametro);
                            if (allHidden) {
                                de.setType(DataElementType.HIDDEN);
                            } else {
                                de.setType(DataElementType.TEXT_EDIT);
                                de.setRequired(true);
                            }
                            dati.add(de);
                        }
                    }
                } else if (TipoAutenticazione.APIKEY.equals(autenticazione)) {
                    ApiKeyState apiKeyState = new ApiKeyState(autenticazioneParametroList);
                    de = new DataElement();
                    de.setName("autenticazioneParametro0");
                    de.setValue(apiKeyState.appId);
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setLabel("App ID");
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(apiKeyState.appIdSelected);
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    this.addOpzionale(dati, allHidden, forceDisableOptional, autenticazioneOpzionale, autenticazione);
                    addOpzionale = false;
                    de = new DataElement();
                    de.setName("autenticazioneParametro1");
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                        de.setSelezionati(apiKeyState.posizioneSelected);
                    } else {
                        de.setLabel("Posizione");
                        de.setType(DataElementType.MULTI_SELECT);
                        de.setSelezionati(apiKeyState.posizioneSelected);
                        de.setValues(apiKeyState.posizioneValues);
                        de.setLabels(apiKeyState.posizioneLabels);
                        de.setRows(3);
                        de.setPostBack(!apiKeyState.useOAS3NamesSelected);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setName("autenticazioneParametro2");
                    de.setValue(apiKeyState.useOAS3Names);
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setLabel("Nomi Standard OAS3");
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(apiKeyState.useOAS3NamesSelected);
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    if (!apiKeyState.useOAS3NamesSelected) {
                        de = new DataElement();
                        de.setLabel("Api Key");
                        de.setType(DataElementType.SUBTITLE);
                        dati.add(de);
                    }
                    de = new DataElement();
                    de.setName("autenticazioneParametro3");
                    de.setValue(apiKeyState.forwardApiKey);
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        if (apiKeyState.useOAS3NamesSelected) {
                            de.setLabel("Forward Api Key");
                        } else {
                            de.setLabel("Forward");
                        }
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(apiKeyState.forwardApiKeySelected);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setName("autenticazioneParametro4");
                    de.setValue(apiKeyState.queryParameterApiKey);
                    if (allHidden || apiKeyState.useOAS3NamesSelected || !apiKeyState.queryParameterEnabled) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setLabel(ModalitaIdentificazione.FORM_BASED.getLabel());
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setValue(apiKeyState.queryParameterApiKey);
                        de.setRequired(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setName("autenticazioneParametro5");
                    de.setValue(apiKeyState.headerApiKey);
                    if (allHidden || apiKeyState.useOAS3NamesSelected || !apiKeyState.headerEnabled) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setLabel(ModalitaIdentificazione.HEADER_BASED.getLabel());
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setValue(apiKeyState.headerApiKey);
                        de.setRequired(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setName("autenticazioneParametro6");
                    de.setValue(apiKeyState.cookieApiKey);
                    if (allHidden || apiKeyState.useOAS3NamesSelected || !apiKeyState.cookieEnabled) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setLabel(ModalitaIdentificazione.COOKIE_BASED.getLabel());
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setValue(apiKeyState.cookieApiKey);
                        de.setRequired(true);
                    }
                    dati.add(de);
                    if (!apiKeyState.useOAS3NamesSelected && apiKeyState.appIdSelected) {
                        de = new DataElement();
                        de.setLabel("App ID");
                        de.setType(DataElementType.SUBTITLE);
                        dati.add(de);
                    }
                    de = new DataElement();
                    de.setName("autenticazioneParametro7");
                    de.setValue(apiKeyState.forwardAppId);
                    if (allHidden || !apiKeyState.appIdSelected) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        if (apiKeyState.useOAS3NamesSelected) {
                            de.setLabel("Forward App ID");
                        } else {
                            de.setLabel("Forward");
                        }
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(apiKeyState.forwardAppIdSelected);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setName("autenticazioneParametro8");
                    de.setValue(apiKeyState.queryParameterAppId);
                    if (allHidden || apiKeyState.useOAS3NamesSelected || !apiKeyState.queryParameterEnabled || !apiKeyState.appIdSelected) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setLabel(ModalitaIdentificazione.FORM_BASED.getLabel());
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setValue(apiKeyState.queryParameterAppId);
                        de.setRequired(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setName("autenticazioneParametro9");
                    de.setValue(apiKeyState.headerAppId);
                    if (allHidden || apiKeyState.useOAS3NamesSelected || !apiKeyState.headerEnabled || !apiKeyState.appIdSelected) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setLabel(ModalitaIdentificazione.HEADER_BASED.getLabel());
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setValue(apiKeyState.headerAppId);
                        de.setRequired(true);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setName("autenticazioneParametro10");
                    de.setValue(apiKeyState.cookieAppId);
                    if (allHidden || apiKeyState.useOAS3NamesSelected || !apiKeyState.cookieEnabled || !apiKeyState.appIdSelected) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setLabel(ModalitaIdentificazione.COOKIE_BASED.getLabel());
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setValue(apiKeyState.cookieAppId);
                        de.setRequired(true);
                    }
                    dati.add(de);
                }
                if (addOpzionale) {
                    this.addOpzionale(dati, allHidden, forceDisableOptional, autenticazioneOpzionale, autenticazione);
                }
            }
            if (addTitle) {
                this.impostaAperturaTitle(dati, "autenticazioneTitle");
            }
        } else {
            DataElement de = new DataElement();
            de.setLabel("Stato");
            de.setType(DataElementType.HIDDEN);
            de.setName("autenticazione");
            de.setValue(TipoAutenticazione.DISABILITATO.getValue());
            dati.add(de);
        }
    }

    private void addOpzionale(List<DataElement> dati, boolean allHidden, boolean forceDisableOptional, String autenticazioneOpzionale, String autenticazione) {
        DataElement de = new DataElement();
        de.setLabel("Opzionale");
        de.setName("autenticazioneOpzionale");
        if (forceDisableOptional) {
            de.setType(DataElementType.HIDDEN);
            de.setSelected(ServletUtils.isCheckBoxEnabled((String)autenticazioneOpzionale));
        } else if (!allHidden && !TipoAutenticazione.DISABILITATO.getValue().equals(autenticazione)) {
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(ServletUtils.isCheckBoxEnabled((String)autenticazioneOpzionale));
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue("");
        }
        dati.add(de);
    }

    public void controlloAccessiGestioneToken(List<DataElement> dati, TipoOperazione tipoOperazione, String gestioneToken, String[] gestioneTokenPolicyLabels, String[] gestioneTokenPolicyValues, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, Object oggetto, String protocolloParam, boolean isPortaDelegata, boolean forceGestioneToken) throws DriverControlStationException {
        this.controlloAccessiGestioneToken(dati, tipoOperazione, gestioneToken, gestioneTokenPolicyLabels, gestioneTokenPolicyValues, gestioneTokenPolicy, gestioneTokenOpzionale, gestioneTokenValidazioneInput, gestioneTokenIntrospection, gestioneTokenUserInfo, gestioneTokenForward, oggetto, protocolloParam, isPortaDelegata, forceGestioneToken, false);
    }

    public void controlloAccessiGestioneToken(List<DataElement> dati, TipoOperazione tipoOperazione, String gestioneToken, String[] gestioneTokenPolicyLabels, String[] gestioneTokenPolicyValues, String gestioneTokenPolicy, String gestioneTokenOpzionale, String gestioneTokenValidazioneInput, String gestioneTokenIntrospection, String gestioneTokenUserInfo, String gestioneTokenForward, Object oggetto, String protocolloParam, boolean isPortaDelegata, boolean forceGestioneToken, boolean forceMostraSezione) throws DriverControlStationException {
        boolean mostraSezione;
        if (oggetto != null) {
            // empty if block
        }
        boolean bl = !tipoOperazione.equals((Object)TipoOperazione.ADD) || (isPortaDelegata ? this.core.isEnabledToken_generazioneAutomaticaPorteDelegate() : this.core.isEnabledToken_generazioneAutomaticaPorteApplicative()) ? true : (mostraSezione = false);
        if (mostraSezione || forceMostraSezione) {
            DataElement de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setName("gestioneTokenTitle");
            de.setLabel("Autenticazione Token");
            de.setStatoAperturaSezioni(DataElement.STATO_APERTURA_SEZIONI.CHIUSO);
            dati.add(de);
            String[] valoriAbilitazione = new String[]{StatoFunzionalita.DISABILITATO.getValue(), StatoFunzionalita.ABILITATO.getValue()};
            de = new DataElement();
            de.setLabel("Stato");
            de.setName("gestioneToken");
            if (forceGestioneToken) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(gestioneToken);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(valoriAbilitazione);
                de.setValoreDefaultSelect(StatoFunzionalita.DISABILITATO.getValue());
                de.setPostBack(true);
                de.setSelected(gestioneToken);
            }
            dati.add(de);
            if (StatoFunzionalita.ABILITATO.getValue().equals(gestioneToken)) {
                de = new DataElement();
                de.setLabel("Policy");
                de.setType(DataElementType.SELECT);
                de.setName("gtPolicy");
                de.setValues(gestioneTokenPolicyValues);
                de.setValues(gestioneTokenPolicyLabels);
                de.setSelected(gestioneTokenPolicy);
                de.setRequired(true);
                if (forceGestioneToken) {
                    de.setValoreDefaultSelect("-");
                }
                de.setPostBack(true);
                dati.add(de);
                if (gestioneTokenPolicy != null && !gestioneTokenPolicy.equals("-")) {
                    Map<String, Properties> mappaDB = null;
                    try {
                        GenericProperties policySelezionata = this.confCore.getGenericProperties(gestioneTokenPolicy, "gestionePolicyToken", true);
                        mappaDB = this.confCore.readGestorePolicyTokenPropertiesConfiguration(policySelezionata.getId());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    de = new DataElement();
                    de.setLabel("Token Opzionale");
                    de.setName("gtOpzionale");
                    if (!isPortaDelegata && protocolloParam != null && this.core.isProfiloModIPA(protocolloParam) && !StatoFunzionalita.ABILITATO.getValue().equals(gestioneTokenOpzionale)) {
                        if (forceGestioneToken) {
                            de.setType(DataElementType.HIDDEN);
                        } else {
                            de.setType(DataElementType.CHECKBOX);
                            de.setSelected(ServletUtils.isCheckBoxEnabled((String)gestioneTokenOpzionale));
                        }
                    } else {
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(ServletUtils.isCheckBoxEnabled((String)gestioneTokenOpzionale));
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Validazione JWT");
                    de.setName("gtValidazione");
                    try {
                        if (TokenUtilities.isValidazioneEnabled(mappaDB)) {
                            if (forceGestioneToken && tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                                de.setType(DataElementType.TEXT);
                                de.setValue(gestioneTokenValidazioneInput);
                            } else {
                                de.setType(DataElementType.SELECT);
                                de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA_CON_WARNING);
                                de.setSelected(gestioneTokenValidazioneInput);
                                de.setPostBack(true);
                            }
                        } else {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
                        }
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Introspection");
                    de.setName("gtIntrospection");
                    try {
                        if (TokenUtilities.isIntrospectionEnabled(mappaDB)) {
                            if (forceGestioneToken && tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                                de.setType(DataElementType.TEXT);
                                de.setValue(gestioneTokenIntrospection);
                            } else {
                                de.setType(DataElementType.SELECT);
                                de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA_CON_WARNING);
                                de.setSelected(gestioneTokenIntrospection);
                                de.setPostBack(true);
                            }
                        } else {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
                        }
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("User Info");
                    de.setName("gtUserInfo");
                    try {
                        if (TokenUtilities.isUserInfoEnabled(mappaDB)) {
                            if (forceGestioneToken && tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                                de.setType(DataElementType.TEXT);
                                de.setValue(gestioneTokenUserInfo);
                            } else {
                                de.setType(DataElementType.SELECT);
                                de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA_CON_WARNING);
                                de.setSelected(gestioneTokenUserInfo);
                                de.setPostBack(true);
                            }
                        } else {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
                        }
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Token Forward");
                    de.setName("gtTokenForward");
                    try {
                        if (TokenUtilities.isTokenForwardEnabled(mappaDB)) {
                            if (forceGestioneToken && tipoOperazione.equals((Object)TipoOperazione.ADD)) {
                                de.setType(DataElementType.TEXT);
                                de.setValue(gestioneTokenForward);
                            } else {
                                de.setType(DataElementType.SELECT);
                                de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA);
                                de.setSelected(gestioneTokenForward);
                                de.setPostBack(true);
                            }
                        } else {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
                        }
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    dati.add(de);
                }
            }
            this.impostaAperturaTitle(dati, "gestioneTokenTitle");
        } else {
            DataElement de = new DataElement();
            de.setLabel("Stato");
            de.setType(DataElementType.HIDDEN);
            de.setName("gestioneToken");
            de.setValue(gestioneToken);
            dati.add(de);
            if (StatoFunzionalita.ABILITATO.getValue().equals(gestioneToken)) {
                de = new DataElement();
                de.setLabel("Policy");
                de.setType(DataElementType.HIDDEN);
                de.setName("gtPolicy");
                de.setValue(gestioneTokenPolicy);
                dati.add(de);
                if (gestioneTokenPolicy != null && !gestioneTokenPolicy.equals("-")) {
                    Map<String, Properties> mappaDB = null;
                    try {
                        GenericProperties policySelezionata = this.confCore.getGenericProperties(gestioneTokenPolicy, "gestionePolicyToken", true);
                        mappaDB = this.confCore.readGestorePolicyTokenPropertiesConfiguration(policySelezionata.getId());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    de = new DataElement();
                    de.setLabel("Token Opzionale");
                    de.setName("gtOpzionale");
                    if (!isPortaDelegata && protocolloParam != null && this.core.isProfiloModIPA(protocolloParam) && !StatoFunzionalita.ABILITATO.getValue().equals(gestioneTokenOpzionale)) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue(ServletUtils.isCheckBoxEnabled((String)gestioneTokenOpzionale) ? "yes" : "no");
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Validazione JWT");
                    de.setName("gtValidazione");
                    de.setType(DataElementType.HIDDEN);
                    try {
                        if (TokenUtilities.isValidazioneEnabled(mappaDB)) {
                            de.setValue(gestioneTokenValidazioneInput);
                        } else {
                            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
                        }
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Introspection");
                    de.setName("gtIntrospection");
                    de.setType(DataElementType.HIDDEN);
                    try {
                        if (TokenUtilities.isIntrospectionEnabled(mappaDB)) {
                            de.setValue(gestioneTokenIntrospection);
                        } else {
                            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
                        }
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("User Info");
                    de.setName("gtUserInfo");
                    de.setType(DataElementType.HIDDEN);
                    try {
                        if (TokenUtilities.isUserInfoEnabled(mappaDB)) {
                            de.setValue(gestioneTokenUserInfo);
                        } else {
                            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
                        }
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Token Forward");
                    de.setName("gtTokenForward");
                    de.setType(DataElementType.HIDDEN);
                    try {
                        if (TokenUtilities.isTokenForwardEnabled(mappaDB)) {
                            de.setValue(gestioneTokenForward);
                        } else {
                            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
                        }
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    dati.add(de);
                }
            }
        }
    }

    public void controlloAccessiAutorizzazione(List<DataElement> dati, TipoOperazione tipoOperazione, String servletChiamante, Object oggetto, String protocolloParam, String autenticazione, String autenticazioneCustom, String autorizzazione, String autorizzazioneCustom, String autorizzazioneAutenticati, String urlAutorizzazioneAutenticati, int numAutenticati, List<String> autenticati, String autenticato, String autorizzazioneRuoli, String urlAutorizzazioneRuoli, int numRuoli, String ruolo, String autorizzazioneRuoliTipologia, String autorizzazioneRuoliMatch, boolean confPers, boolean isSupportatoAutenticazione, boolean contaListe, boolean isPortaDelegata, boolean addTitoloSezione, String autorizzazioneScope, String urlAutorizzazioneScope, int numScope, String scope, String autorizzazioneScopeMatch, String gestioneToken, String gestioneTokenPolicy, String autorizzazione_token, String autorizzazione_tokenOptions, BinaryParameter allegatoXacmlPolicy, String urlAutorizzazioneErogazioneApplicativiAutenticati, int numErogazioneApplicativiAutenticati, String urlAutorizzazioneCustomPropertiesList, int numAutorizzazioneCustomPropertiesList, String identificazioneAttributiStato, String[] attributeAuthorityLabels, String[] attributeAuthorityValues, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi, String autorizzazioneAutenticatiToken, String urlAutorizzazioneAutenticatiToken, int numAutenticatiToken, String autorizzazioneRuoliToken, String urlAutorizzazioneRuoliToken, int numRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken) throws DriverControlStationException {
        this.controlloAccessiAutorizzazione(dati, tipoOperazione, servletChiamante, oggetto, protocolloParam, autenticazione, autenticazioneCustom, autorizzazione, autorizzazioneCustom, autorizzazioneAutenticati, urlAutorizzazioneAutenticati, numAutenticati, autenticati, null, autenticato, autorizzazioneRuoli, urlAutorizzazioneRuoli, numRuoli, ruolo, autorizzazioneRuoliTipologia, autorizzazioneRuoliMatch, confPers, isSupportatoAutenticazione, contaListe, isPortaDelegata, addTitoloSezione, autorizzazioneScope, urlAutorizzazioneScope, numScope, scope, autorizzazioneScopeMatch, gestioneToken, gestioneTokenPolicy, autorizzazione_token, autorizzazione_tokenOptions, allegatoXacmlPolicy, urlAutorizzazioneErogazioneApplicativiAutenticati, numErogazioneApplicativiAutenticati, urlAutorizzazioneCustomPropertiesList, numAutorizzazioneCustomPropertiesList, identificazioneAttributiStato, attributeAuthorityLabels, attributeAuthorityValues, attributeAuthoritySelezionate, attributeAuthorityAttributi, autorizzazioneAutenticatiToken, urlAutorizzazioneAutenticatiToken, numAutenticatiToken, autorizzazioneRuoliToken, urlAutorizzazioneRuoliToken, numRuoliToken, autorizzazioneRuoliTipologiaToken, autorizzazioneRuoliMatchToken);
    }

    public void controlloAccessiAutorizzazione(List<DataElement> dati, TipoOperazione tipoOperazione, String servletChiamante, Object oggetto, String protocolloParam, String autenticazione, String autenticazioneCustom, String autorizzazione, String autorizzazioneCustom, String autorizzazioneAutenticati, String urlAutorizzazioneAutenticati, int numAutenticati, List<String> autenticati, List<String> autenticatiLabel, String autenticato, String autorizzazioneRuoli, String urlAutorizzazioneRuoli, int numRuoli, String ruolo, String autorizzazioneRuoliTipologia, String autorizzazioneRuoliMatch, boolean confPers, boolean isSupportatoAutenticazione, boolean contaListe, boolean isPortaDelegata, boolean addTitoloSezione, String autorizzazioneScope, String urlAutorizzazioneScope, int numScope, String scope, String autorizzazioneScopeMatch, String gestioneToken, String gestioneTokenPolicy, String autorizzazione_token, String autorizzazione_tokenOptions, BinaryParameter allegatoXacmlPolicy, String urlAutorizzazioneErogazioneApplicativiAutenticati, int numErogazioneApplicativiAutenticati, String urlAutorizzazioneCustomPropertiesList, int numAutorizzazioneCustomPropertiesList, String identificazioneAttributiStato, String[] attributeAuthorityLabels, String[] attributeAuthorityValues, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi, String autorizzazioneAutenticatiToken, String urlAutorizzazioneAutenticatiToken, int numAutenticatiToken, String autorizzazioneRuoliToken, String urlAutorizzazioneRuoliToken, int numRuoliToken, String autorizzazioneRuoliTipologiaToken, String autorizzazioneRuoliMatchToken) throws DriverControlStationException {
        String protocollo;
        boolean allHidden = false;
        if (!this.isModalitaCompleta() && TipoOperazione.ADD.equals((Object)tipoOperazione)) {
            allHidden = true;
        }
        if (((protocollo = protocolloParam) == null || "".equals(protocollo)) && oggetto != null) {
            if (isPortaDelegata) {
                PortaDelegata pd = (PortaDelegata)oggetto;
                if (pd != null && pd.getServizio() != null && pd.getServizio().getTipo() != null) {
                    try {
                        protocollo = this.apsCore.getProtocolloAssociatoTipoServizio(pd.getServizio().getTipo());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                }
            } else {
                PortaApplicativa pa = (PortaApplicativa)oggetto;
                if (pa != null && pa.getServizio() != null && pa.getServizio().getTipo() != null) {
                    try {
                        protocollo = this.apsCore.getProtocolloAssociatoTipoServizio(pa.getServizio().getTipo());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                }
            }
        }
        String oldAutenticazione = null;
        IDServizio idAps = null;
        if (oggetto != null) {
            if (isPortaDelegata) {
                PortaDelegata pd = (PortaDelegata)oggetto;
                if (pd != null) {
                    oldAutenticazione = pd.getAutenticazione();
                }
            } else {
                PortaApplicativa pa = (PortaApplicativa)oggetto;
                if (pa != null) {
                    oldAutenticazione = pa.getAutenticazione();
                    if ("porteApplicativeControlloAccessi.do".equals(servletChiamante)) {
                        try {
                            idAps = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario(), pa.getServizio().getVersione().intValue());
                        }
                        catch (Exception e) {
                            throw new DriverControlStationException(e.getMessage(), e);
                        }
                    }
                }
            }
        }
        boolean mostraSezione = false;
        try {
            mostraSezione = !tipoOperazione.equals((Object)TipoOperazione.ADD) || (isPortaDelegata ? this.core.isEnabledAutorizzazione_generazioneAutomaticaPorteDelegate() : this.core.isEnabledAutorizzazione_generazioneAutomaticaPorteApplicative(protocollo == null ? true : this.soggettiCore.isSupportatoAutenticazioneSoggetti(protocollo)));
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        boolean tokenAbilitato = StatoFunzionalita.ABILITATO.getValue().equalsIgnoreCase(gestioneToken) && gestioneTokenPolicy != null && !gestioneTokenPolicy.equals("-");
        boolean profiloModi = this.isProfiloModIPA(protocollo);
        boolean isSupportatoAutenticazioneApplicativiEsterni = false;
        try {
            isSupportatoAutenticazioneApplicativiEsterni = this.saCore.isSupportatoAutenticazioneApplicativiEsterniErogazione(protocollo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        boolean modiSicurezzaMessaggio = false;
        if (!isPortaDelegata && profiloModi && !allHidden && "porteApplicativeControlloAccessi.do".equals(servletChiamante) && idAps != null) {
            try {
                AccordoServizioParteSpecifica asps = this.apsCore.getServizio(idAps);
                idAps.setPortType(asps.getPortType());
                idAps.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
                IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
                IConsoleDynamicConfiguration consoleDynamicConfiguration = protocolFactory.createDynamicConfigurationConsole();
                IRegistryReader registryReader = this.apcCore.getRegistryReader(protocolFactory);
                IConfigIntegrationReader configRegistryReader = this.apcCore.getConfigIntegrationReader(protocolFactory);
                ConsoleConfiguration consoleConfiguration = consoleDynamicConfiguration.getDynamicConfigAccordoServizioParteSpecifica(ConsoleOperationType.CHANGE, (IConsoleHelper)this, registryReader, configRegistryReader, idAps);
                if (consoleConfiguration != null && consoleConfiguration.getConsoleItem() != null && !consoleConfiguration.getConsoleItem().isEmpty()) {
                    modiSicurezzaMessaggio = true;
                }
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        }
        if (mostraSezione) {
            PortaDelegata portaDelegata;
            if (!tipoOperazione.equals((Object)TipoOperazione.ADD) && attributeAuthorityValues != null && attributeAuthorityValues.length > 0) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setName("attrStatoTitle");
                de.setLabel("Identificazione Attributi");
                de.setStatoAperturaSezioni(DataElement.STATO_APERTURA_SEZIONI.CHIUSO);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Stato");
                de.setName("attrStato");
                de.setValue(identificazioneAttributiStato);
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setType(DataElementType.SELECT);
                    String[] valoriAbilitazione = new String[]{StatoFunzionalita.DISABILITATO.getValue(), StatoFunzionalita.ABILITATO.getValue()};
                    de.setValues(valoriAbilitazione);
                    de.setPostBack(true);
                    de.setSelected(identificazioneAttributiStato);
                    de.setValoreDefaultSelect(StatoFunzionalita.DISABILITATO.getValue());
                }
                dati.add(de);
                de = new DataElement();
                de.setLabel("Attribute Authority");
                de.setName("attrAuthority");
                if (allHidden || !StatoFunzionalita.ABILITATO.getValue().equals(identificazioneAttributiStato)) {
                    de.setType(DataElementType.HIDDEN);
                    de.setSelezionati(attributeAuthoritySelezionate);
                } else {
                    de.setRequired(true);
                    de.setType(DataElementType.MULTI_SELECT);
                    de.setValues(attributeAuthorityValues);
                    de.setLabels(attributeAuthorityLabels);
                    de.setPostBack(true);
                    de.setSelezionati(attributeAuthoritySelezionate);
                }
                dati.add(de);
                de = new DataElement();
                de.setLabel("Attributi Richiesti");
                de.setName("AAttr");
                int sizeAA = 0;
                if (attributeAuthoritySelezionate != null) {
                    sizeAA = attributeAuthoritySelezionate.length;
                }
                de.setValue(attributeAuthorityAttributi);
                if (allHidden || !StatoFunzionalita.ABILITATO.getValue().equals(identificazioneAttributiStato)) {
                    de.setType(DataElementType.HIDDEN);
                } else if (sizeAA > 1) {
                    de.setType(DataElementType.TEXT_AREA);
                    de.setNote("Elencare gli attributi da richiedere, separandoli con la virgola, utilizzando una riga per ogni A.A. (nomeAA=listaAttributi)");
                    de.setRows(sizeAA <= 10 ? sizeAA : 10);
                } else {
                    de.setType(DataElementType.TEXT_EDIT);
                    de.setNote("Elencare gli attributi da richiedere, separandoli con la virgola");
                }
                dati.add(de);
                this.impostaAperturaTitle(dati, "attrStatoTitle");
            }
            boolean addTitle = false;
            if (!allHidden) {
                addTitle = true;
                DataElement de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setName("autorizzazioneTitle");
                de.setLabel("Autorizzazione");
                de.setStatoAperturaSezioni(DataElement.STATO_APERTURA_SEZIONI.APERTO);
                dati.add(de);
            }
            IDServizio idServizio = null;
            AccordoServizioParteSpecifica asps = null;
            boolean isModISignaHubPush = false;
            if (isPortaDelegata && this.isProfiloModIPA(protocollo) && (portaDelegata = (PortaDelegata)oggetto) != null && portaDelegata.getServizio() != null && portaDelegata.getServizio().getTipo() != null && portaDelegata.getServizio().getNome() != null && portaDelegata.getServizio().getVersione() != null && portaDelegata.getSoggettoErogatore() != null && portaDelegata.getSoggettoErogatore().getTipo() != null && portaDelegata.getSoggettoErogatore().getNome() != null) {
                try {
                    idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(portaDelegata.getServizio().getTipo(), portaDelegata.getServizio().getNome(), portaDelegata.getSoggettoErogatore().getTipo(), portaDelegata.getSoggettoErogatore().getNome(), portaDelegata.getServizio().getVersione().intValue());
                    if (idServizio != null) {
                        asps = this.apsCore.getServizio(idServizio, false);
                    }
                    if (asps != null) {
                        IDAccordo modisignalHubPushApi = ModIUtils.buildSignalHubPushIdAPI((IDSoggetto)this.soggettiCore.getSoggettoOperativoDefault(null, protocollo));
                        IDAccordo idAccordoServizio = IDAccordoFactory.getInstance().getIDAccordoFromUri(asps.getAccordoServizioParteComune());
                        isModISignaHubPush = modisignalHubPushApi.equals((Object)idAccordoServizio);
                    }
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
            }
            List<String> auturizzazioneValues = AutorizzazioneUtilities.getStati(isModISignaHubPush);
            int totEl = auturizzazioneValues.size();
            if (confPers) {
                ++totEl;
            }
            String[] tipoAutorizzazione = new String[totEl];
            String[] tipoAutorizzazioneLabel = new String[totEl];
            for (int i = 0; i < auturizzazioneValues.size(); ++i) {
                tipoAutorizzazione[i] = auturizzazioneValues.get(i);
                tipoAutorizzazioneLabel[i] = auturizzazioneValues.get(i);
            }
            if (confPers) {
                tipoAutorizzazione[totEl - 1] = "custom";
                tipoAutorizzazioneLabel[totEl - 1] = "plugin";
            }
            if (modiSicurezzaMessaggio && AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione) && numErogazioneApplicativiAutenticati > 0) {
                autorizzazione = AutorizzazioneUtilities.STATO_ABILITATO;
            }
            DataElement de = new DataElement();
            de.setLabel("Stato");
            de.setName("autorizzazione");
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(autorizzazione);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(tipoAutorizzazione);
                de.setLabels(tipoAutorizzazioneLabel);
                de.setPostBack(true);
                de.setSelected(autorizzazione);
                de.setValoreDefaultSelect(StatoFunzionalita.DISABILITATO.getValue());
            }
            dati.add(de);
            String tipoAutorizzazioneCustom = isPortaDelegata ? "Fruizione" : "Erogazione";
            boolean autorizzazioneCustomHidden = allHidden || autorizzazione == null || !autorizzazione.equals("custom");
            this.addCustomField(TipoPlugin.AUTORIZZAZIONE, tipoAutorizzazioneCustom, null, "autorizzazione", "autorizzazioneCustom", "Tipo Personalizzato", autorizzazioneCustom, autorizzazioneCustomHidden, dati, false);
            boolean old_autorizzazione_autenticazione = false;
            boolean old_autorizzazione_ruoli = false;
            boolean old_autorizzazione_token_autenticazione = false;
            boolean old_autorizzazione_token_ruoli = false;
            boolean old_autorizzazione_scope = false;
            boolean old_xacmlPolicy = false;
            boolean old_autorizzazione_custom = false;
            String old_autorizzazione = null;
            Long idPorta = null;
            String nomePostback = this.getPostBackElementName();
            if (!"autorizzazioneAutenticazione".equals(nomePostback) && TipoOperazione.CHANGE.equals((Object)tipoOperazione) && numAutenticati > 0) {
                autorizzazioneAutenticati = "yes";
            }
            if (!"autorizzazioneRuoli".equals(nomePostback) && TipoOperazione.CHANGE.equals((Object)tipoOperazione) && numRuoli > 0) {
                autorizzazioneRuoli = "yes";
            }
            if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && oggetto != null) {
                if (isPortaDelegata) {
                    PortaDelegata pd = (PortaDelegata)oggetto;
                    old_autorizzazione = AutorizzazioneUtilities.convertToStato(pd.getAutorizzazione());
                    old_autorizzazione_autenticazione = TipoAutorizzazione.isAuthenticationRequired((String)pd.getAutorizzazione());
                    old_autorizzazione_ruoli = TipoAutorizzazione.isRolesRequired((String)pd.getAutorizzazione());
                    old_autorizzazione_token_autenticazione = pd.getAutorizzazioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)pd.getAutorizzazioneToken().getAutorizzazioneApplicativi());
                    old_autorizzazione_token_ruoli = pd.getAutorizzazioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)pd.getAutorizzazioneToken().getAutorizzazioneRuoli());
                    old_autorizzazione_scope = pd.getScope() != null && pd.getScope().getStato().equals((Object)StatoFunzionalita.ABILITATO);
                    old_xacmlPolicy = StringUtils.isNotEmpty((CharSequence)pd.getXacmlPolicy());
                    idPorta = pd.getId();
                    if (idServizio == null) {
                        try {
                            idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pd.getServizio().getTipo(), pd.getServizio().getNome(), pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome(), pd.getServizio().getVersione().intValue());
                        }
                        catch (Exception e) {
                            throw new DriverControlStationException(e.getMessage(), e);
                        }
                    }
                    old_autorizzazione_custom = pd.getAutorizzazione() != null && !TipoAutorizzazione.getAllValues().contains(pd.getAutorizzazione());
                } else {
                    PortaApplicativa pa = (PortaApplicativa)oggetto;
                    old_autorizzazione = AutorizzazioneUtilities.convertToStato(pa.getAutorizzazione());
                    old_autorizzazione_autenticazione = TipoAutorizzazione.isAuthenticationRequired((String)pa.getAutorizzazione());
                    old_autorizzazione_ruoli = TipoAutorizzazione.isRolesRequired((String)pa.getAutorizzazione());
                    old_autorizzazione_token_autenticazione = pa.getAutorizzazioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)pa.getAutorizzazioneToken().getAutorizzazioneApplicativi());
                    old_autorizzazione_token_ruoli = pa.getAutorizzazioneToken() != null && StatoFunzionalita.ABILITATO.equals((Object)pa.getAutorizzazioneToken().getAutorizzazioneRuoli());
                    old_autorizzazione_scope = pa.getScope() != null && pa.getScope().getStato().equals((Object)StatoFunzionalita.ABILITATO);
                    old_xacmlPolicy = StringUtils.isNotEmpty((CharSequence)pa.getXacmlPolicy());
                    idPorta = pa.getId();
                    try {
                        idServizio = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario(), pa.getServizio().getVersione().intValue());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                    boolean bl = old_autorizzazione_custom = pa.getAutorizzazione() != null && !TipoAutorizzazione.getAllValues().contains(pa.getAutorizzazione());
                }
            }
            if (autorizzazione != null && autorizzazione.equals("custom") && old_autorizzazione_custom) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl(urlAutorizzazioneCustomPropertiesList);
                String labelCustomProperties = "Propriet&agrave;";
                if (contaListe) {
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelCustomProperties, (Long)Long.valueOf(numAutorizzazioneCustomPropertiesList));
                } else {
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelCustomProperties);
                }
                dati.add(de);
            }
            boolean labelAutorizzazioneTrasportoAttuata = false;
            if (!AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione)) {
                boolean autorizzazione_autenticazione = false;
                boolean isSupportatoAutorizzazioneRichiedentiSenzaAutenticazione = false;
                try {
                    isSupportatoAutorizzazioneRichiedentiSenzaAutenticazione = this.soggettiCore.isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazione(protocollo);
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
                if (AutorizzazioneUtilities.STATO_ABILITATO.equals(autorizzazione) || "signal-Hub".equals(autorizzazione)) {
                    if (!allHidden && (!isSupportatoAutenticazione || autenticazione != null && !TipoAutenticazione.DISABILITATO.equals(autenticazione) || isSupportatoAutorizzazioneRichiedentiSenzaAutenticazione)) {
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        if (isPortaDelegata) {
                            de.setLabel("Autorizzazione Trasporto");
                        } else {
                            String labelTrasporto = "Autorizzazione Trasporto";
                            if (profiloModi && !isPortaDelegata) {
                                labelTrasporto = "Autorizzazione Canale";
                            }
                            String labelSoggetti = isSupportatoAutenticazione && (autenticazione != null && !TipoAutenticazione.DISABILITATO.equals(autenticazione) || isSupportatoAutorizzazioneRichiedentiSenzaAutenticazione) ? labelTrasporto : "Soggetti";
                            de.setLabel(labelSoggetti);
                        }
                        labelAutorizzazioneTrasportoAttuata = true;
                        dati.add(de);
                    }
                    autorizzazione_autenticazione = ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticati);
                    de = new DataElement();
                    de.setLabel("per Richiedente");
                    de.setName("autorizzazioneAutenticazione");
                    if (!isSupportatoAutenticazione || autenticazione != null && !TipoAutenticazione.DISABILITATO.equals(autenticazione) || isSupportatoAutorizzazioneRichiedentiSenzaAutenticazione) {
                        if (allHidden) {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue("" + autorizzazione_autenticazione);
                        } else {
                            de.setType(DataElementType.CHECKBOX);
                            de.setSelected(autorizzazione_autenticazione);
                            de.setPostBack(true);
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("no");
                    }
                    dati.add(de);
                }
                if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                    if (!isSupportatoAutenticazione || autenticazione != null && !TipoAutenticazione.DISABILITATO.equals(autenticazione) || isSupportatoAutorizzazioneRichiedentiSenzaAutenticazione) {
                        if (urlAutorizzazioneAutenticati != null && autorizzazione_autenticazione && (old_autorizzazione_autenticazione || "custom".equals(old_autorizzazione)) && oldAutenticazione != null && (oldAutenticazione.equals(autenticazione) || "custom".equals(autenticazione) && oldAutenticazione.equals(autenticazioneCustom))) {
                            de = new DataElement();
                            de.setType(DataElementType.LINK);
                            de.setUrl(urlAutorizzazioneAutenticati);
                            if (isPortaDelegata) {
                                String labelApplicativi = "Servizi Applicativi";
                                if (!this.isModalitaCompleta()) {
                                    labelApplicativi = "Applicativi";
                                }
                                if (contaListe) {
                                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi, (Long)Long.valueOf(numAutenticati));
                                } else {
                                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi);
                                }
                            } else if (contaListe) {
                                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Soggetti", (Long)Long.valueOf(numAutenticati));
                            } else {
                                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Soggetti");
                            }
                            dati.add(de);
                        }
                        boolean supportatoAutenticazioneApplicativiErogazione = false;
                        try {
                            supportatoAutenticazioneApplicativiErogazione = this.saCore.isSupportatoAutenticazioneApplicativiErogazione(protocollo);
                        }
                        catch (Exception e) {
                            throw new DriverControlStationException(e.getMessage(), e);
                        }
                        if (!isPortaDelegata && supportatoAutenticazioneApplicativiErogazione && isSupportatoAutenticazione && !profiloModi && oldAutenticazione != null && (oldAutenticazione.equals(autenticazione) || "custom".equals(autenticazione) && oldAutenticazione.equals(autenticazioneCustom)) && urlAutorizzazioneErogazioneApplicativiAutenticati != null && autorizzazione_autenticazione && (old_autorizzazione_autenticazione || "custom".equals(old_autorizzazione))) {
                            de = new DataElement();
                            de.setType(DataElementType.LINK);
                            de.setUrl(urlAutorizzazioneErogazioneApplicativiAutenticati);
                            String labelApplicativi = "Servizi Applicativi";
                            if (!this.isModalitaCompleta()) {
                                labelApplicativi = "Applicativi";
                            }
                            if (contaListe) {
                                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi, (Long)Long.valueOf(numErogazioneApplicativiAutenticati));
                            } else {
                                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi);
                            }
                            dati.add(de);
                        }
                    }
                } else if (!(allHidden || isSupportatoAutenticazione && (autenticazione == null || TipoAutenticazione.DISABILITATO.equals(autenticazione)))) {
                    if ("accordiServizioParteSpecificaFruitoriAdd.do".equals(servletChiamante) && autorizzazione_autenticazione && isPortaDelegata) {
                        String[] saArray = null;
                        if (autenticati != null && autenticati.size() > 0) {
                            saArray = autenticati.toArray(new String[1]);
                        }
                        this.addPorteServizioApplicativoToDati(tipoOperazione, dati, autenticato, saArray, 0, false, false, false);
                    }
                    if ("accordiServizioParteSpecificaAdd.do".equals(servletChiamante) && autorizzazione_autenticazione && !isPortaDelegata) {
                        String[] soggettiList = null;
                        String[] soggettiLabelList = null;
                        if (autenticati != null && autenticati.size() > 0) {
                            soggettiList = autenticati.toArray(new String[1]);
                            if (autenticatiLabel != null && autenticatiLabel.size() > 0) {
                                soggettiLabelList = autenticatiLabel.toArray(new String[1]);
                            }
                        }
                        this.addPorteSoggettoToDati(tipoOperazione, dati, soggettiLabelList, soggettiList, autenticato, 0, false, false);
                    }
                }
            }
            if (!AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione)) {
                boolean autorizzazione_ruoli = false;
                if (AutorizzazioneUtilities.STATO_ABILITATO.equals(autorizzazione)) {
                    if (!allHidden && !labelAutorizzazioneTrasportoAttuata) {
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        de.setLabel("Autorizzazione Trasporto");
                        dati.add(de);
                    }
                    autorizzazione_ruoli = ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoli);
                    de = new DataElement();
                    de.setLabel("per Ruoli");
                    de.setName("autorizzazioneRuoli");
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("" + autorizzazione_ruoli);
                    } else {
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(autorizzazione_ruoli);
                        de.setPostBack(true);
                    }
                    dati.add(de);
                }
                if (autorizzazione_ruoli || "xacml-Policy".equals(autorizzazione)) {
                    de = new DataElement();
                    if (autorizzazione_ruoli) {
                        de.setLabel("Fonte");
                    } else {
                        de.setLabel("Fonte Ruoli");
                    }
                    de.setName("ruoloTipologia");
                    de.setValue(autorizzazioneRuoliTipologia);
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setType(DataElementType.SELECT);
                        de.setValues(RuoliCostanti.getRuoliTipologia());
                        de.setLabels(RuoliCostanti.getRuoliTipologiaLabel());
                        de.setSelected(autorizzazioneRuoliTipologia);
                        if ("accordiServizioParteSpecificaFruitoriAdd.do".equals(servletChiamante) || "accordiServizioParteSpecificaAdd.do".equals(servletChiamante)) {
                            de.setPostBack(true);
                        }
                    }
                    dati.add(de);
                }
                String postbackElement = this.getPostBackElementName();
                boolean aggiornatoFile = false;
                if (postbackElement != null && postbackElement.equals(allegatoXacmlPolicy.getName())) {
                    aggiornatoFile = true;
                }
                if ("xacml-Policy".equals(autorizzazione)) {
                    String filePolicyLabel = "Policy";
                    if (old_xacmlPolicy && !aggiornatoFile) {
                        filePolicyLabel = "Nuova";
                        DataElement saveAs = new DataElement();
                        saveAs.setValue("Download Policy Attuale");
                        saveAs.setType(DataElementType.LINK);
                        Parameter pIdAccordo = new Parameter("idAccordo", "" + idPorta);
                        Parameter pTipoAllegato = new Parameter("tipoDocumento", isPortaDelegata ? "pd" : "pa");
                        Parameter pTipoDoc = new Parameter("tipoDocumentoDaScaricare", isPortaDelegata ? "xacmlPolicy" : "xacmlPolicy");
                        saveAs.setUrl("downloadDocumento", new Parameter[]{pIdAccordo, pTipoAllegato, pTipoDoc});
                        saveAs.setDisabilitaAjaxStatus();
                        dati.add(saveAs);
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        de.setLabel("Modifica Policy");
                        de.setLabelStyleClass("noBold");
                        dati.add(de);
                    }
                    dati.add(allegatoXacmlPolicy.getFileDataElement(filePolicyLabel, "", this.getSize()));
                    dati.addAll(allegatoXacmlPolicy.getFileNameDataElement());
                    dati.add(allegatoXacmlPolicy.getFileIdDataElement());
                }
                if (autorizzazione_ruoli) {
                    String[] tipoRole = new String[]{RuoloTipoMatch.ALL.getValue(), RuoloTipoMatch.ANY.getValue()};
                    String[] labelRole = new String[]{"tutti", "almeno uno"};
                    de = new DataElement();
                    de.setLabel("Ruoli Richiesti");
                    de.setName("ruoloMatch");
                    de.setValue(autorizzazioneRuoliMatch);
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setType(DataElementType.SELECT);
                        de.setValues(tipoRole);
                        de.setLabels(labelRole);
                        de.setSelected(autorizzazioneRuoliMatch);
                    }
                    dati.add(de);
                }
                if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                    if (urlAutorizzazioneRuoli != null && autorizzazione_ruoli && (old_autorizzazione_ruoli || "custom".equals(old_autorizzazione))) {
                        de = new DataElement();
                        de.setType(DataElementType.LINK);
                        de.setUrl(urlAutorizzazioneRuoli);
                        if (contaListe) {
                            ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Ruoli", (Long)Long.valueOf(numRuoli));
                        } else {
                            ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Ruoli");
                        }
                        dati.add(de);
                    }
                } else if (!allHidden && ("accordiServizioParteSpecificaFruitoriAdd.do".equals(servletChiamante) || "accordiServizioParteSpecificaAdd.do".equals(servletChiamante)) && autorizzazione_ruoli) {
                    FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
                    if (isPortaDelegata) {
                        filtroRuoli.setContesto(RuoloContesto.PORTA_DELEGATA);
                    } else {
                        filtroRuoli.setContesto(RuoloContesto.PORTA_APPLICATIVA);
                    }
                    filtroRuoli.setTipologia(RuoloTipologia.QUALSIASI);
                    if (RuoloTipologia.INTERNO.equals(autorizzazioneRuoliTipologia)) {
                        filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
                    } else if (RuoloTipologia.ESTERNO.equals(autorizzazioneRuoliTipologia)) {
                        filtroRuoli.setTipologia(RuoloTipologia.ESTERNO);
                    }
                    try {
                        this.addRuoliToDati(tipoOperazione, dati, false, filtroRuoli, ruolo, null, true, false, "Ruolo", addTitoloSezione, null, false);
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                }
            }
            boolean labelAutorizzazioneTokenAttuata = false;
            if (!AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione)) {
                if ((tokenAbilitato || modiSicurezzaMessaggio) && !"xacml-Policy".equals(autorizzazione)) {
                    boolean autorizzazione_autenticazione_token = false;
                    if (!allHidden && !labelAutorizzazioneTokenAttuata) {
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        String labelToken = "Autorizzazione Token";
                        if (profiloModi && !isPortaDelegata) {
                            labelToken = "Autorizzazione Messaggio";
                        }
                        de.setLabel(labelToken);
                        labelAutorizzazioneTokenAttuata = true;
                        dati.add(de);
                    }
                    autorizzazione_autenticazione_token = ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticatiToken);
                    if (modiSicurezzaMessaggio && !old_autorizzazione_token_autenticazione && !autorizzazione_autenticazione_token && numErogazioneApplicativiAutenticati > 0) {
                        autorizzazione_autenticazione_token = true;
                    }
                    de = new DataElement();
                    de.setLabel("per Richiedente");
                    de.setName("autorizzazioneAutenticazioneToken");
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("" + autorizzazione_autenticazione_token);
                    } else {
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(autorizzazione_autenticazione_token);
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && (urlAutorizzazioneAutenticatiToken != null && autorizzazione_autenticazione_token && old_autorizzazione_token_autenticazione || modiSicurezzaMessaggio && numErogazioneApplicativiAutenticati > 0)) {
                        de = new DataElement();
                        de.setType(DataElementType.LINK);
                        if (!isPortaDelegata && profiloModi) {
                            de.setUrl(urlAutorizzazioneErogazioneApplicativiAutenticati, new Parameter[]{new Parameter("autorizzazioneModIPA", "" + modiSicurezzaMessaggio), new Parameter("tokenAuthz", "" + tokenAbilitato)});
                        } else {
                            de.setUrl(urlAutorizzazioneAutenticatiToken);
                        }
                        String labelApplicativi = "Servizi Applicativi";
                        if (!this.isModalitaCompleta()) {
                            labelApplicativi = "Applicativi";
                        }
                        if (contaListe) {
                            if (!isPortaDelegata && profiloModi) {
                                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi, (Long)Long.valueOf(numErogazioneApplicativiAutenticati));
                            } else {
                                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi, (Long)Long.valueOf(numAutenticatiToken));
                            }
                        } else {
                            ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi);
                        }
                        dati.add(de);
                    }
                }
                if ((tokenAbilitato || modiSicurezzaMessaggio) && !"xacml-Policy".equals(autorizzazione)) {
                    boolean autorizzazione_ruoli_token = false;
                    if (!allHidden && !labelAutorizzazioneTokenAttuata) {
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        String labelToken = "Autorizzazione Token";
                        if (profiloModi && !isPortaDelegata) {
                            labelToken = "Autorizzazione Messaggio";
                        }
                        de.setLabel(labelToken);
                        dati.add(de);
                    }
                    autorizzazione_ruoli_token = ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoliToken);
                    de = new DataElement();
                    de.setLabel("per Ruoli");
                    de.setName("autorizzazioneRuoliToken");
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("" + autorizzazione_ruoli_token);
                    } else {
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(autorizzazione_ruoli_token);
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    if (autorizzazione_ruoli_token) {
                        de = new DataElement();
                        de.setLabel("Fonte");
                        de.setName("ruoloTipologiaToken");
                        de.setValue(autorizzazioneRuoliTipologiaToken);
                        if (allHidden) {
                            de.setType(DataElementType.HIDDEN);
                        } else {
                            de.setType(DataElementType.SELECT);
                            de.setValues(RuoliCostanti.getRuoliTipologia());
                            de.setLabels(RuoliCostanti.getRuoliTipologiaLabel());
                            de.setSelected(autorizzazioneRuoliTipologiaToken);
                            if ("accordiServizioParteSpecificaFruitoriAdd.do".equals(servletChiamante) || "accordiServizioParteSpecificaAdd.do".equals(servletChiamante)) {
                                de.setPostBack(true);
                            }
                        }
                        dati.add(de);
                    }
                    if (autorizzazione_ruoli_token) {
                        String[] tipoRole = new String[]{RuoloTipoMatch.ALL.getValue(), RuoloTipoMatch.ANY.getValue()};
                        String[] labelRole = new String[]{"tutti", "almeno uno"};
                        de = new DataElement();
                        de.setLabel("Ruoli Richiesti");
                        de.setName("ruoloMatchToken");
                        de.setValue(autorizzazioneRuoliMatchToken);
                        if (allHidden) {
                            de.setType(DataElementType.HIDDEN);
                        } else {
                            de.setType(DataElementType.SELECT);
                            de.setValues(tipoRole);
                            de.setLabels(labelRole);
                            de.setSelected(autorizzazioneRuoliMatchToken);
                        }
                        dati.add(de);
                    }
                    if (TipoOperazione.CHANGE.equals((Object)tipoOperazione) && urlAutorizzazioneRuoliToken != null && autorizzazione_ruoli_token && old_autorizzazione_token_ruoli) {
                        de = new DataElement();
                        de.setType(DataElementType.LINK);
                        if (!isPortaDelegata && profiloModi) {
                            de.setUrl(urlAutorizzazioneRuoliToken, new Parameter[]{new Parameter("autorizzazioneModIPA", "" + modiSicurezzaMessaggio)});
                        } else {
                            de.setUrl(urlAutorizzazioneRuoliToken);
                        }
                        if (contaListe) {
                            ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Ruoli", (Long)Long.valueOf(numRuoliToken));
                        } else {
                            ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Ruoli");
                        }
                        dati.add(de);
                    }
                }
                if (tokenAbilitato && !"xacml-Policy".equals(autorizzazione)) {
                    if (!allHidden) {
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        de.setLabel("Autorizzazione per Token Claims");
                        dati.add(de);
                    }
                    boolean autorizzazioneTokenEnabled = ServletUtils.isCheckBoxEnabled((String)autorizzazione_token);
                    de = new DataElement();
                    de.setLabel("Abilitato");
                    de.setName("autorizzazioneToken");
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("" + autorizzazioneTokenEnabled);
                    } else {
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(autorizzazioneTokenEnabled);
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    if (autorizzazioneTokenEnabled) {
                        de = new DataElement();
                        de.setLabel("Claims");
                        de.setNote("Indicare per riga i claims richiesti (nome=valore); visualizzare 'info' per maggiori dettagli");
                        de.setName("autorizzazioneTokenOptions");
                        de.setValue(autorizzazione_tokenOptions);
                        if (allHidden) {
                            de.setType(DataElementType.HIDDEN);
                        } else {
                            de.setType(DataElementType.TEXT_AREA);
                            de.setRows(6);
                            de.setCols(55);
                        }
                        ServiceBinding serviceBinding = ServiceBinding.REST;
                        if (idServizio != null) {
                            try {
                                if (asps == null) {
                                    asps = this.apsCore.getServizio(idServizio, false);
                                }
                                AccordoServizioParteComuneSintetico aspc = this.apcCore.getAccordoServizioSintetico(this.idAccordoFactory.getIDAccordoFromUri(asps.getAccordoServizioParteComune()));
                                serviceBinding = aspc.getServiceBinding();
                            }
                            catch (Exception e) {
                                throw new DriverControlStationException(e.getMessage(), e);
                            }
                        }
                        int sizeAA = 0;
                        if (attributeAuthoritySelezionate != null) {
                            sizeAA = attributeAuthoritySelezionate.length;
                        }
                        DataElementInfo dInfoTokenClaims = new DataElementInfo("Claims");
                        if (sizeAA > 1) {
                            dInfoTokenClaims.setHeaderBody("Indicare per riga i claims richiesti nel token nella forma 'nome=valore'.<br/><br/>Per verificare un attributo prelevato da un authority indicarlo con i prefissi 'aa.' e 'attribute.' nella forma 'aa.nomeAuthority.attribute.nomeAttributo=valore'.<br/><br/>Ogni valore pu\u00f2 essere fornito in una delle seguenti modalit\u00e0:<br/>- <b>${anyValue}</b> : indica qualsiasi valore non nullo.<br/>- <b>${undefined}</b> : la risorsa indicata non deve esistere o non deve essere valorizzata.<br/>- <b>${regExpMatch:EXPR}</b> : la regola \u00e8 soddisfatta se l'intero valore del claim ha un match rispetto all'espressione regolare EXPR indicata. \u00c8 possibile utilizzare anche la versione ${regExpNotMatch:EXPR} che consente di attuare una negazione della condizione.<br/>- <b>${regExpFind:EXPR}</b> : simile alla precedente regola, il match dell'espressione regolare pu\u00f2 avvenire anche su una sottostringa del valore del claim. Come per la precedente esiste anche la versione ${regExpNotFind:EXPR}.<br/>- <b>valore</b> : indica esattamente il valore (case sensitive) che deve possedere il claim; il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway descritte di seguito.<br/>- <b>valore1,..,valoreN</b> : \u00e8 possibile elencare differenti valori ammissibili; come per la precedente opzione il valore pu\u00f2 contenere parti dinamiche.<br/>- <b>${ignoreCase:valore} o ${ignoreCase:valore1,...,valoreN}</b> : simile alle precedenti regole consente di attuare una verifica <b>case insensitive</b>.<br/>- <b>${not:valore} o ${not:valore1,...,valoreN}</b> : simile alle precedenti regole consente di indicare esattamente i valori (case sensitive) che <b>non</b> deve possedere il claim. \u00c8 possibile utilizzarla anche in combinazione con il controllo case-insensitive: ${not:${ignoreCase:valore}} o ${not:${ignoreCase:valore1,...,valoreN}}</b><br/><br/>Le espressioni utilizzabili come parti dinamiche, risolte a runtime dal gateway, sono:");
                        } else if (sizeAA == 1) {
                            dInfoTokenClaims.setHeaderBody("Indicare per riga i claims richiesti nel token nella forma 'nome=valore'.<br/><br/>Per verificare un attributo indicarlo con il prefisso 'attribute.' nella forma 'attribute.nome=valore'.<br/><br/>Ogni valore pu\u00f2 essere fornito in una delle seguenti modalit\u00e0:<br/>- <b>${anyValue}</b> : indica qualsiasi valore non nullo.<br/>- <b>${undefined}</b> : la risorsa indicata non deve esistere o non deve essere valorizzata.<br/>- <b>${regExpMatch:EXPR}</b> : la regola \u00e8 soddisfatta se l'intero valore del claim ha un match rispetto all'espressione regolare EXPR indicata. \u00c8 possibile utilizzare anche la versione ${regExpNotMatch:EXPR} che consente di attuare una negazione della condizione.<br/>- <b>${regExpFind:EXPR}</b> : simile alla precedente regola, il match dell'espressione regolare pu\u00f2 avvenire anche su una sottostringa del valore del claim. Come per la precedente esiste anche la versione ${regExpNotFind:EXPR}.<br/>- <b>valore</b> : indica esattamente il valore (case sensitive) che deve possedere il claim; il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway descritte di seguito.<br/>- <b>valore1,..,valoreN</b> : \u00e8 possibile elencare differenti valori ammissibili; come per la precedente opzione il valore pu\u00f2 contenere parti dinamiche.<br/>- <b>${ignoreCase:valore} o ${ignoreCase:valore1,...,valoreN}</b> : simile alle precedenti regole consente di attuare una verifica <b>case insensitive</b>.<br/>- <b>${not:valore} o ${not:valore1,...,valoreN}</b> : simile alle precedenti regole consente di indicare esattamente i valori (case sensitive) che <b>non</b> deve possedere il claim. \u00c8 possibile utilizzarla anche in combinazione con il controllo case-insensitive: ${not:${ignoreCase:valore}} o ${not:${ignoreCase:valore1,...,valoreN}}</b><br/><br/>Le espressioni utilizzabili come parti dinamiche, risolte a runtime dal gateway, sono:");
                        } else {
                            dInfoTokenClaims.setHeaderBody("Indicare per riga i claims richiesti nel token nella forma 'nome=valore'.<br/><br/>Ogni valore pu\u00f2 essere fornito in una delle seguenti modalit\u00e0:<br/>- <b>${anyValue}</b> : indica qualsiasi valore non nullo.<br/>- <b>${undefined}</b> : la risorsa indicata non deve esistere o non deve essere valorizzata.<br/>- <b>${regExpMatch:EXPR}</b> : la regola \u00e8 soddisfatta se l'intero valore del claim ha un match rispetto all'espressione regolare EXPR indicata. \u00c8 possibile utilizzare anche la versione ${regExpNotMatch:EXPR} che consente di attuare una negazione della condizione.<br/>- <b>${regExpFind:EXPR}</b> : simile alla precedente regola, il match dell'espressione regolare pu\u00f2 avvenire anche su una sottostringa del valore del claim. Come per la precedente esiste anche la versione ${regExpNotFind:EXPR}.<br/>- <b>valore</b> : indica esattamente il valore (case sensitive) che deve possedere il claim; il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway descritte di seguito.<br/>- <b>valore1,..,valoreN</b> : \u00e8 possibile elencare differenti valori ammissibili; come per la precedente opzione il valore pu\u00f2 contenere parti dinamiche.<br/>- <b>${ignoreCase:valore} o ${ignoreCase:valore1,...,valoreN}</b> : simile alle precedenti regole consente di attuare una verifica <b>case insensitive</b>.<br/>- <b>${not:valore} o ${not:valore1,...,valoreN}</b> : simile alle precedenti regole consente di indicare esattamente i valori (case sensitive) che <b>non</b> deve possedere il claim. \u00c8 possibile utilizzarla anche in combinazione con il controllo case-insensitive: ${not:${ignoreCase:valore}} o ${not:${ignoreCase:valore1,...,valoreN}}</b><br/><br/>Le espressioni utilizzabili come parti dinamiche, risolte a runtime dal gateway, sono:");
                        }
                        if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                            dInfoTokenClaims.setListBody(DynamicHelperCostanti.getLABEL_CONTROLLO_ACCESSI_AUTORIZZAZIONE_TOKEN_CLAIMS_REST_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata));
                        } else {
                            dInfoTokenClaims.setListBody(DynamicHelperCostanti.getLABEL_CONTROLLO_ACCESSI_AUTORIZZAZIONE_TOKEN_CLAIMS_SOAP_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata));
                        }
                        de.setInfo(dInfoTokenClaims);
                        dati.add(de);
                    }
                }
                boolean autorizzazione_scope = false;
                if ((AutorizzazioneUtilities.STATO_ABILITATO.equals(autorizzazione) || "signal-Hub".equals(autorizzazione)) && tokenAbilitato) {
                    if (!allHidden) {
                        de = new DataElement();
                        de.setType(DataElementType.SUBTITLE);
                        de.setLabel("Autorizzazione per Token Scope");
                        dati.add(de);
                    }
                    autorizzazione_scope = ServletUtils.isCheckBoxEnabled((String)autorizzazioneScope);
                    de = new DataElement();
                    de.setLabel("Abilitato");
                    de.setName("autorizzazioneScope");
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("" + autorizzazione_scope);
                    } else {
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(autorizzazione_scope);
                        de.setPostBack(true);
                    }
                    dati.add(de);
                    if (autorizzazione_scope) {
                        String[] tipoScope = new String[]{ScopeTipoMatch.ALL.getValue(), ScopeTipoMatch.ANY.getValue()};
                        String[] labelScope = new String[]{"tutti", "almeno uno"};
                        de = new DataElement();
                        de.setLabel("Scope Richiesti");
                        de.setName("scopeMatch");
                        if (allHidden) {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue(autorizzazioneScopeMatch);
                        } else {
                            de.setType(DataElementType.SELECT);
                            de.setValues(tipoScope);
                            de.setLabels(labelScope);
                            de.setSelected(autorizzazioneScopeMatch);
                        }
                        dati.add(de);
                    }
                    if (TipoOperazione.CHANGE.equals((Object)tipoOperazione)) {
                        if (urlAutorizzazioneScope != null && autorizzazione_scope && old_autorizzazione_scope) {
                            de = new DataElement();
                            de.setType(DataElementType.LINK);
                            de.setUrl(urlAutorizzazioneScope);
                            if (contaListe) {
                                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Scope", (Long)Long.valueOf(numScope));
                            } else {
                                ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Scope");
                            }
                            dati.add(de);
                        }
                    } else if (!allHidden && ("accordiServizioParteSpecificaFruitoriAdd.do".equals(servletChiamante) || "accordiServizioParteSpecificaAdd.do".equals(servletChiamante)) && autorizzazione_scope) {
                        FiltroRicercaScope filtroScope = new FiltroRicercaScope();
                        if (isPortaDelegata) {
                            filtroScope.setContesto(ScopeContesto.PORTA_DELEGATA);
                        } else {
                            filtroScope.setContesto(ScopeContesto.PORTA_APPLICATIVA);
                        }
                        try {
                            this.addScopeToDati(tipoOperazione, dati, false, filtroScope, scope, null, true, false, "Scope", addTitoloSezione);
                        }
                        catch (Exception e) {
                            throw new DriverControlStationException(e.getMessage(), e);
                        }
                    }
                }
            }
            if (addTitle) {
                this.impostaAperturaTitle(dati, "autorizzazioneTitle");
            }
        } else {
            de = new DataElement();
            de.setLabel("Stato");
            de.setType(DataElementType.HIDDEN);
            de.setName("autorizzazione");
            de.setValue(AutorizzazioneUtilities.STATO_DISABILITATO);
            dati.add(de);
        }
    }

    public void controlloAccessiAutorizzazioneContenuti(List<DataElement> dati, TipoOperazione tipoOperazione, boolean isPortaDelegata, Object oggetto, String protocolloParam, String autorizzazioneContenutiStato, String autorizzazioneContenuti, String autorizzazioneContenutiProperties, org.openspcoop2.message.constants.ServiceBinding serviceBinding, boolean old_autorizzazione_contenuti_custom, String urlAutorizzazioneContenutiCustomPropertiesList, int numAutorizzazioneContenutiCustomPropertiesList, boolean confPers) throws DriverControlStationException {
        String protocollo = protocolloParam;
        if ((protocollo == null || "".equals(protocollo)) && oggetto != null) {
            if (isPortaDelegata) {
                PortaDelegata pd = (PortaDelegata)oggetto;
                if (pd != null && pd.getServizio() != null && pd.getServizio().getTipo() != null) {
                    try {
                        protocollo = this.apsCore.getProtocolloAssociatoTipoServizio(pd.getServizio().getTipo());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                }
            } else {
                PortaApplicativa pa = (PortaApplicativa)oggetto;
                if (pa != null && pa.getServizio() != null && pa.getServizio().getTipo() != null) {
                    try {
                        protocollo = this.apsCore.getProtocolloAssociatoTipoServizio(pa.getServizio().getTipo());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                }
            }
        }
        DataElement de = new DataElement();
        de.setType(DataElementType.TITLE);
        de.setLabel("Autorizzazione Contenuti");
        de.setName("authContenutiStatoTitle");
        de.setStatoAperturaSezioni(DataElement.STATO_APERTURA_SEZIONI.CHIUSO);
        dati.add(de);
        ArrayList<String> authContenutiLabels = new ArrayList<String>();
        ArrayList<String> authContenutiValues = new ArrayList<String>();
        authContenutiLabels.addAll(Arrays.asList(CostantiControlStation.PARAMETRO_PORTE_CONTROLLO_ACCESSI_AUTORIZZAZIONE_CONTENUTI_STATO_LABELS));
        authContenutiValues.addAll(Arrays.asList(CostantiControlStation.PARAMETRO_PORTE_CONTROLLO_ACCESSI_AUTORIZZAZIONE_CONTENUTI_STATO_VALUES));
        if (confPers || autorizzazioneContenutiStato.equals("custom")) {
            authContenutiLabels.add("plugin");
            authContenutiValues.add("custom");
        }
        de = new DataElement();
        de.setType(DataElementType.SELECT);
        de.setSelected(autorizzazioneContenutiStato);
        de.setValues(authContenutiValues);
        de.setLabels(authContenutiLabels);
        de.setName("authContenutiStato");
        de.setLabel("Stato");
        de.setPostBack(true);
        de.setValoreDefaultSelect(CostantiControlStation.VALUE_PARAMETRO_PORTE_CONTROLLO_ACCESSI_AUTORIZZAZIONE_CONTENUTI_STATO_DISABILITATO);
        dati.add(de);
        if (!autorizzazioneContenutiStato.equals(CostantiControlStation.VALUE_PARAMETRO_PORTE_CONTROLLO_ACCESSI_AUTORIZZAZIONE_CONTENUTI_STATO_DISABILITATO)) {
            if (autorizzazioneContenutiStato.equals(CostantiControlStation.VALUE_PARAMETRO_PORTE_CONTROLLO_ACCESSI_AUTORIZZAZIONE_CONTENUTI_STATO_ABILITATO)) {
                de = new DataElement();
                de.setLabel("");
                de.setType(DataElementType.HIDDEN);
                de.setName("autorizzazioneContenuti");
                de.setValue(autorizzazioneContenuti);
                dati.add(de);
                de = new DataElement();
                de.setLabel("");
                de.setType(DataElementType.TEXT_AREA);
                de.setName("authContenutiProp");
                de.setValue(autorizzazioneContenutiProperties);
                de.setNote("Indicare per riga i controlli richiesti (risorsa=valore); visualizzare 'info' per maggiori dettagli");
                DataElementInfo info = new DataElementInfo("Autorizzazione Contenuti");
                info.setHeaderBody("Indicare per riga i controlli di autorizzazione richiesti nella forma (risorsa=valore).<br/><br/>Una risorsa identifica un header, una parte dell'url o del messaggio, un claim del token o un principal etc.<br/>Per identificare una risorsa sono utilizzabili le espressioni dinamiche descritte nell'ultima parte di questo box informazioni.<br/><br/>Ogni valore pu\u00f2 essere fornito in una delle seguenti modalit\u00e0:<br/>- <b>${anyValue}</b> : indica qualsiasi valore non nullo.<br/>- <b>${undefined}</b> : la risorsa indicata non deve esistere o non deve essere valorizzata.<br/>- <b>${regExpMatch:EXPR}</b> : la regola \u00e8 soddisfatta se il valore della risorsa ha un match completo rispetto all'espressione regolare EXPR indicata. \u00c8 possibile utilizzare anche la versione ${regExpNotMatch:EXPR} che consente di attuare una negazione della condizione.<br/>- <b>${regExpFind:EXPR}</b> : simile alla precedente regola, il match dell'espressione regolare pu\u00f2 avvenire anche su una sottostringa del valore della risorsa. Come per la precedente esiste anche la versione ${regExpNotFind:EXPR}.<br/>- <b>valore</b> : indica esattamente il valore (case sensitive) che deve possedere la risorsa; il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway descritte di seguito<br/>- <b>valore1,..,valoreN</b> : \u00e8 possibile elencare differenti valori ammissibili; come per la precedente opzione il valore pu\u00f2 contenere parti dinamiche<br/>- <b>${ignoreCase:valore} o ${ignoreCase:valore1,...,valoreN}</b> : simile alle precedenti regole consente di attuare una verifica <b>case insensitive</b>.<br/>- <b>${not:valore} o ${not:valore1,...,valoreN}</b> : simile alle precedenti regole consente di indicare esattamente i valori (case sensitive) che <b>non</b> deve possedere la risorsa. \u00c8 possibile utilizzarla anche in combinazione con il controllo case-insensitive: ${not:${ignoreCase:valore}} o ${not:${ignoreCase:valore1,...,valoreN}}</b><br/><br/><b>Identificazione delle risorse tramite espressioni dinamiche</b><br/><br/>Le espressioni utilizzabili, risolte a runtime dal gateway, sono:");
                if (org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBinding)) {
                    info.setListBody(DynamicHelperCostanti.getLABEL_CONTROLLO_ACCESSI_AUTORIZZAZIONE_CONTENUTI_REST_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata));
                } else {
                    info.setListBody(DynamicHelperCostanti.getLABEL_CONTROLLO_ACCESSI_AUTORIZZAZIONE_CONTENUTI_SOAP_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata));
                }
                de.setValoreDefault("");
                de.setInfo(info);
                dati.add(de);
            }
            if (autorizzazioneContenutiStato.equals("custom")) {
                String tipoAutorizzazioneCustom = isPortaDelegata ? "Fruizione" : "Erogazione";
                boolean autorizzazioneCustomHidden = false;
                this.addCustomField(TipoPlugin.AUTORIZZAZIONE_CONTENUTI, tipoAutorizzazioneCustom, null, "authContenutiStato", "autorizzazioneContenuti", "Tipo Personalizzato", autorizzazioneContenuti, autorizzazioneCustomHidden, dati, false);
                if (old_autorizzazione_contenuti_custom) {
                    Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
                    de = new DataElement();
                    de.setType(DataElementType.LINK);
                    de.setUrl(urlAutorizzazioneContenutiCustomPropertiesList);
                    String labelCustomProperties = "Propriet&agrave;";
                    if (contaListe.booleanValue()) {
                        ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelCustomProperties, (Long)Long.valueOf(numAutorizzazioneContenutiCustomPropertiesList));
                    } else {
                        ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelCustomProperties);
                    }
                    dati.add(de);
                }
            }
        }
        this.impostaAperturaTitle(dati, "authContenutiStatoTitle");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean controlloAccessiCheck(TipoOperazione tipoOperazione, String autenticazione, String autenticazioneOpzionale, TipoAutenticazionePrincipal autenticazionePrincipal, List<String> autenticazioneParametroList, String autorizzazione, String autorizzazioneAutenticati, String autorizzazioneRuoli, String autorizzazioneRuoliTipologia, String autorizzazioneRuoliMatch, boolean isSupportatoAutenticazione, boolean isPortaDelegata, Object oggetto, List<String> ruoli, String gestioneToken, String policy, String validazioneInput, String introspection, String userInfo, String forward, String autorizzazioneAutenticatiToken, String autorizzazioneRuoliToken, String autorizzazione_token, String autorizzazione_tokenOptions, String autorizzazioneScope, String autorizzazioneScopeMatch, BinaryParameter allegatoXacmlPolicy, String autorizzazioneContenutiStato, String autorizzazioneContenuto, String autorizzazioneContenutiProperties, String protocollo, String identificazioneAttributiStato, String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi) throws DriverControlStationException {
        try {
            block207: {
                boolean modificataTokenPolicy;
                boolean modiSicurezzaMessaggio;
                StringBuilder sbSoggetti;
                StringBuilder sbCheckAllarmi;
                StringBuilder sbCheckRateLimiting;
                StringBuilder sbCheckTrasformazioni;
                boolean profiloModi;
                PortaApplicativa pa;
                block205: {
                    block212: {
                        List<ConfigurazioneAllarmeBean> list;
                        ConsoleSearch ricercaAll;
                        String prefix;
                        block213: {
                            Iterator<AttivazionePolicy> iterator;
                            block214: {
                                boolean modificataTokenPolicy2;
                                ConsoleSearch ricercaAll2;
                                List<AttivazionePolicy> listaRateLimiting;
                                Object regola2;
                                StringBuilder sbCheckAllarmi2;
                                StringBuilder sbCheckRateLimiting2;
                                StringBuilder sbCheckTrasformazioni2;
                                PortaDelegata pd;
                                block209: {
                                    List<ConfigurazioneAllarmeBean> allarmi;
                                    String prefix2;
                                    block210: {
                                        block211: {
                                            List<AttivazionePolicy> listaRateLimiting2;
                                            boolean modificataAutenticazione;
                                            block208: {
                                                boolean modificataAutenticazione2;
                                                boolean userInfoB;
                                                if (TipoAutenticazione.PRINCIPAL.equals(autenticazione) && autenticazionePrincipal != null) {
                                                    switch (autenticazionePrincipal) {
                                                        case CONTAINER: 
                                                        case INDIRIZZO_IP: 
                                                        case INDIRIZZO_IP_X_FORWARDED_FOR: {
                                                            break;
                                                        }
                                                        case HEADER: {
                                                            if (autenticazioneParametroList != null && !autenticazioneParametroList.isEmpty() && !StringUtils.isEmpty((CharSequence)autenticazioneParametroList.get(0))) break;
                                                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", CostantiControlStation.LABEL_PARAMETRO_PORTE_AUTENTICAZIONE_PRINCIPAL_HEADER));
                                                            return false;
                                                        }
                                                        case FORM: {
                                                            if (autenticazioneParametroList != null && !autenticazioneParametroList.isEmpty() && !StringUtils.isEmpty((CharSequence)autenticazioneParametroList.get(0))) break;
                                                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", CostantiControlStation.LABEL_PARAMETRO_PORTE_AUTENTICAZIONE_PRINCIPAL_FORM));
                                                            return false;
                                                        }
                                                        case URL: {
                                                            if (autenticazioneParametroList == null || autenticazioneParametroList.isEmpty() || StringUtils.isEmpty((CharSequence)autenticazioneParametroList.get(0))) {
                                                                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", CostantiControlStation.LABEL_PARAMETRO_PORTE_AUTENTICAZIONE_PRINCIPAL_ESPRESSIONE));
                                                                return false;
                                                            }
                                                            if (this.checkRegexp(autenticazioneParametroList.get(0), ModalitaIdentificazione.URL_BASED.getLabelParametro())) break;
                                                            return false;
                                                        }
                                                        case TOKEN: {
                                                            if (autenticazioneParametroList == null || autenticazioneParametroList.isEmpty() || StringUtils.isEmpty((CharSequence)autenticazioneParametroList.get(0))) {
                                                                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", CostantiControlStation.LABEL_PARAMETRO_PORTE_AUTENTICAZIONE_PRINCIPAL_TOKEN_CLAIM));
                                                                return false;
                                                            }
                                                            String tipo = autenticazioneParametroList.get(0);
                                                            if (!"custom".equals(tipo) || autenticazioneParametroList.size() > 1 && !StringUtils.isEmpty((CharSequence)autenticazioneParametroList.get(1))) break;
                                                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Nome del Claim"));
                                                            return false;
                                                        }
                                                    }
                                                }
                                                if (TipoAutenticazione.APIKEY.equals(autenticazione)) {
                                                    if (autenticazioneParametroList == null || autenticazioneParametroList.isEmpty()) {
                                                        this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Posizione"));
                                                        return false;
                                                    }
                                                    ApiKeyState apiKeyState = new ApiKeyState(autenticazioneParametroList);
                                                    if (!(apiKeyState.queryParameterEnabled || apiKeyState.headerEnabled || apiKeyState.cookieEnabled)) {
                                                        this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Posizione"));
                                                        return false;
                                                    }
                                                    if (!apiKeyState.useOAS3NamesSelected) {
                                                        if (apiKeyState.queryParameterEnabled && (apiKeyState.queryParameterApiKey == null || "".equals(apiKeyState.queryParameterApiKey))) {
                                                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Api Key - " + ModalitaIdentificazione.FORM_BASED.getLabel()));
                                                            return false;
                                                        }
                                                        if (apiKeyState.headerEnabled && (apiKeyState.headerApiKey == null || "".equals(apiKeyState.headerApiKey))) {
                                                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Api Key - " + ModalitaIdentificazione.HEADER_BASED.getLabel()));
                                                            return false;
                                                        }
                                                        if (apiKeyState.cookieEnabled && (apiKeyState.cookieApiKey == null || "".equals(apiKeyState.cookieApiKey))) {
                                                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Api Key - " + ModalitaIdentificazione.COOKIE_BASED.getLabel()));
                                                            return false;
                                                        }
                                                        if (apiKeyState.appIdSelected) {
                                                            if (apiKeyState.queryParameterEnabled) {
                                                                if (apiKeyState.queryParameterAppId == null || "".equals(apiKeyState.queryParameterAppId)) {
                                                                    this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "App ID - " + ModalitaIdentificazione.FORM_BASED.getLabel()));
                                                                    return false;
                                                                }
                                                                if (apiKeyState.queryParameterAppId.equalsIgnoreCase(apiKeyState.queryParameterApiKey)) {
                                                                    this.pd.setMessage(MessageFormat.format("&Egrave; necessario indicare dei valori differenti in {0} e {1}", "'" + ModalitaIdentificazione.FORM_BASED.getLabel() + "' tra Api Key", "App ID"));
                                                                    return false;
                                                                }
                                                            }
                                                            if (apiKeyState.headerEnabled) {
                                                                if (apiKeyState.headerAppId == null || "".equals(apiKeyState.headerAppId)) {
                                                                    this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "App ID - " + ModalitaIdentificazione.HEADER_BASED.getLabel()));
                                                                    return false;
                                                                }
                                                                if (apiKeyState.headerAppId.equalsIgnoreCase(apiKeyState.headerApiKey)) {
                                                                    this.pd.setMessage(MessageFormat.format("&Egrave; necessario indicare dei valori differenti in {0} e {1}", "'" + ModalitaIdentificazione.HEADER_BASED.getLabel() + "' tra Api Key", "App ID"));
                                                                    return false;
                                                                }
                                                            }
                                                            if (apiKeyState.cookieEnabled) {
                                                                if (apiKeyState.cookieAppId == null || "".equals(apiKeyState.cookieAppId)) {
                                                                    this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "App ID - " + ModalitaIdentificazione.COOKIE_BASED.getLabel()));
                                                                    return false;
                                                                }
                                                                if (apiKeyState.cookieAppId.equalsIgnoreCase(apiKeyState.cookieApiKey)) {
                                                                    this.pd.setMessage(MessageFormat.format("&Egrave; necessario indicare dei valori differenti in {0} e {1}", "'" + ModalitaIdentificazione.COOKIE_BASED.getLabel() + "' tra Api Key", "App ID"));
                                                                    return false;
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                                String autenticazioneCustom = null;
                                                if (autenticazione != null && autenticazione.equals("custom")) {
                                                    autenticazioneCustom = this.getParameter("autenticazioneCustom");
                                                    if (StringUtils.isEmpty((CharSequence)autenticazioneCustom) || "--".equals(autenticazioneCustom)) {
                                                        if (this.confCore.isConfigurazionePluginsEnabled()) {
                                                            this.pd.setMessage("Non \u00e8 stato selezionato nessun plugin da utilizzare come meccanismo di autenticazione");
                                                            return false;
                                                        }
                                                        this.pd.setMessage("Tipo Personalizzato obbligatorio per il tipo di autenticazione selezionato");
                                                        return false;
                                                    }
                                                    if (!this.checkLength255(autenticazioneCustom, "Autenticazione - controlli custom")) {
                                                        return false;
                                                    }
                                                }
                                                if (AutorizzazioneUtilities.STATO_ABILITATO.equals(gestioneToken)) {
                                                    boolean forwardB;
                                                    if (StringUtils.isEmpty((CharSequence)policy) || policy.equals("-")) {
                                                        this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Policy"));
                                                        return false;
                                                    }
                                                    boolean validazioneInputB = !StatoFunzionalitaConWarning.DISABILITATO.getValue().equals(validazioneInput);
                                                    boolean introspectionB = !StatoFunzionalitaConWarning.DISABILITATO.getValue().equals(introspection);
                                                    userInfoB = !StatoFunzionalitaConWarning.DISABILITATO.getValue().equals(userInfo);
                                                    boolean bl = forwardB = !StatoFunzionalitaConWarning.DISABILITATO.getValue().equals(forward);
                                                    if (!(validazioneInputB || introspectionB || userInfoB || forwardB)) {
                                                        StringBuilder sb = new StringBuilder();
                                                        sb.append("Validazione JWT").append(", ");
                                                        sb.append("Introspection").append(", ");
                                                        sb.append("User Info").append(" o ");
                                                        sb.append("Token Forward");
                                                        this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario abilitare almeno una voce tra {0}", sb.toString()));
                                                        return false;
                                                    }
                                                }
                                                if (AutorizzazioneUtilities.STATO_ABILITATO.equals(identificazioneAttributiStato)) {
                                                    if (attributeAuthoritySelezionate == null || attributeAuthoritySelezionate.length <= 0) {
                                                        this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Attribute Authority"));
                                                        return false;
                                                    }
                                                    if (!this.checkAttributes(attributeAuthoritySelezionate, attributeAuthorityAttributi)) {
                                                        return false;
                                                    }
                                                }
                                                if (AutorizzazioneUtilities.STATO_ABILITATO.equals(autorizzazione) || "signal-Hub".equals(autorizzazione)) {
                                                    if (!(ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticati) || ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoli) || ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticatiToken) || ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoliToken) || ServletUtils.isCheckBoxEnabled((String)autorizzazioneScope) || autorizzazione_tokenOptions != null && !"".equals(autorizzazione_tokenOptions))) {
                                                        this.pd.setMessage("Selezionare almeno una modalit&agrave; di autorizzazione");
                                                        return false;
                                                    }
                                                    if (ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticati) && !ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoli) && isSupportatoAutenticazione && (isPortaDelegata || !this.soggettiCore.isSupportatoAutorizzazioneRichiedenteSenzaAutenticazioneErogazione(protocollo))) {
                                                        boolean modipa = this.isProfiloModIPA(protocollo);
                                                        String label = "trasporto";
                                                        if (modipa && !isPortaDelegata) {
                                                            label = "canale";
                                                        }
                                                        if (TipoAutenticazione.DISABILITATO.equals(autenticazione)) {
                                                            this.pd.setMessage(MessageFormat.format("Con la sola modalit&agrave; di autorizzazione ''{0}'' deve essere indicata anche una modalit&agrave; di autenticazione", label));
                                                            return false;
                                                        }
                                                        if (ServletUtils.isCheckBoxEnabled((String)autenticazioneOpzionale)) {
                                                            this.pd.setMessage(MessageFormat.format("Con la sola modalit&agrave; di autorizzazione ''{0}'' non &egrave; possibile associata una modalit&agrave; di autenticazione ''opzionale''", label));
                                                            return false;
                                                        }
                                                    }
                                                    if (ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticati) && ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoli) && isSupportatoAutenticazione && !ServletUtils.isCheckBoxEnabled((String)autenticazioneOpzionale)) {
                                                        RuoloTipologia ruoloTipologia = RuoloTipologia.toEnumConstant((String)autorizzazioneRuoliTipologia);
                                                        if (TipoAutenticazione.BASIC.equals(autenticazione) && (ruoloTipologia == null || RuoloTipologia.QUALSIASI.equals(autorizzazioneRuoliTipologia) || RuoloTipologia.ESTERNO.equals(autorizzazioneRuoliTipologia))) {
                                                            this.pd.setMessage(MessageFormat.format(CostantiControlStation.MESSAGGIO_ERRORE_CON_UNA_MODALITA_DI_AUTENTICAZIONE_BASIC_OBBLIGATORIA_NON_E_POSSIBILE_SELEZIONARE_ENTRAMBE_LE_MODALITA_DI_AUTORIZZAZIONE, "per Richiedente", "per Ruoli con fonte esterna o qualsiasi"));
                                                            return false;
                                                        }
                                                    }
                                                    if (ServletUtils.isCheckBoxEnabled((String)autorizzazione_token) && (autorizzazione_tokenOptions == null || "".equals(autorizzazione_tokenOptions))) {
                                                        this.pd.setMessage("Dati incompleti. Definire almeno un claim utilizzato per autorizzare la richiesta");
                                                        return false;
                                                    }
                                                    if (autorizzazione_tokenOptions != null) {
                                                        try (Scanner scanner = new Scanner(autorizzazione_tokenOptions);){
                                                            while (scanner.hasNextLine()) {
                                                                String line = scanner.nextLine();
                                                                if (line == null || line.trim().equals("") || (line = line.trim()) != null && line.startsWith("#") || line == null || line.contains("=")) continue;
                                                                this.pd.setMessage("I claims in ogni riga devono essere indicati come coppia (nome=valore); non \u00e8 stato riscontrato il carattere separatore '='");
                                                                userInfoB = false;
                                                                return userInfoB;
                                                            }
                                                        }
                                                        if (!this.checkLength(autorizzazione_tokenOptions, "autorizzazioneTokenOptions", -1, 4000)) {
                                                            return false;
                                                        }
                                                    }
                                                }
                                                if (AutorizzazioneUtilities.STATO_ABILITATO.equals(autorizzazione) || "xacml-Policy".equals(autorizzazione)) {
                                                    RuoloTipologia ruoloTipologia;
                                                    if ("xacml-Policy".equals(autorizzazione)) {
                                                        if (ruoli != null && ruoli.size() > 0) {
                                                            this.pd.setMessage(MessageFormat.format("La porta contiene gi&agrave; dei ruoli che non sono compatibili con la nuova autorizzazione ''{0}'' scelta.<BR/>Eliminare i ruoli prima di procedere con la modifica del tipo di autorizzazione.", "xacml-Policy"));
                                                            return false;
                                                        }
                                                        if (allegatoXacmlPolicy.getValue() != null) {
                                                            IProtocolFactory pf = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
                                                            Documento documento = new Documento();
                                                            documento.setFile("xacmlPolicy");
                                                            documento.setByteContenuto(allegatoXacmlPolicy.getValue());
                                                            documento.setTipo(TipiDocumentoSicurezza.XACML_POLICY.getNome());
                                                            documento.setRuolo(RuoliDocumento.specificaSicurezza.toString());
                                                            ValidazioneResult valida = pf.createValidazioneDocumenti().valida(documento);
                                                            if (!valida.isEsito()) {
                                                                this.pd.setMessage(valida.getMessaggioErrore());
                                                                return false;
                                                            }
                                                        } else if (oggetto != null) {
                                                            if (isPortaDelegata) {
                                                                PortaDelegata pd2 = (PortaDelegata)oggetto;
                                                                if (StringUtils.isEmpty((CharSequence)pd2.getXacmlPolicy())) {
                                                                    this.pd.setMessage(MessageFormat.format("La policy &egrave; obbligatoria quando si seleziona l''autorizzazione ''{0}''", "xacml-Policy"));
                                                                    return false;
                                                                }
                                                            } else {
                                                                PortaApplicativa pa2 = (PortaApplicativa)oggetto;
                                                                if (StringUtils.isEmpty((CharSequence)pa2.getXacmlPolicy())) {
                                                                    this.pd.setMessage(MessageFormat.format("La policy &egrave; obbligatoria quando si seleziona l''autorizzazione ''{0}''", "xacml-Policy"));
                                                                    return false;
                                                                }
                                                            }
                                                        }
                                                    }
                                                    if (RuoloTipologia.INTERNO.equals((Object)(ruoloTipologia = RuoloTipologia.toEnumConstant((String)autorizzazioneRuoliTipologia))) && isSupportatoAutenticazione && !AutorizzazioneUtilities.STATO_ABILITATO.equals(gestioneToken)) {
                                                        if (TipoAutenticazione.DISABILITATO.equals(autenticazione)) {
                                                            this.pd.setMessage(MessageFormat.format("Con una {0} per i ruoli di tipo ''{1}'' deve essere associata una modalit&agrave; di autenticazione", "Fonte".toLowerCase(), "Registro"));
                                                            return false;
                                                        }
                                                        if (ServletUtils.isCheckBoxEnabled((String)autenticazioneOpzionale)) {
                                                            this.pd.setMessage(MessageFormat.format("Con una {0} per i ruoli di tipo ''{1}'' non &egrave; possibile associata una modalit&agrave; di autenticazione ''opzionale''", "Fonte".toLowerCase(), "Registro"));
                                                            return false;
                                                        }
                                                    }
                                                    ArrayList<String> ruoliNonCompatibili = new ArrayList<String>();
                                                    if (ruoli != null && ruoli.size() > 0) {
                                                        for (String ruolo : ruoli) {
                                                            Ruolo ruoloObject = this.ruoliCore.getRuolo(ruolo);
                                                            if (RuoloTipologia.INTERNO.equals((Object)ruoloTipologia) && RuoloTipologia.ESTERNO.equals((Object)ruoloObject.getTipologia())) {
                                                                ruoliNonCompatibili.add(ruolo);
                                                            }
                                                            if (!RuoloTipologia.ESTERNO.equals((Object)ruoloTipologia) || !RuoloTipologia.INTERNO.equals((Object)ruoloObject.getTipologia())) continue;
                                                            ruoliNonCompatibili.add(ruolo);
                                                        }
                                                    }
                                                    if (ruoliNonCompatibili.size() > 0) {
                                                        String label = "";
                                                        label = RuoloTipologia.INTERNO.equals((Object)ruoloTipologia) ? "Registro" : "Esterna";
                                                        this.pd.setMessage(MessageFormat.format("La porta contiene gi&agrave; dei ruoli ({0}) che non sono compatibili con la nuova {1} ''{2}'' scelta.", ((Object)ruoliNonCompatibili).toString(), "Fonte".toLowerCase(), label));
                                                        return false;
                                                    }
                                                }
                                                if (oggetto == null) break block207;
                                                if (!isPortaDelegata) break block208;
                                                pd = (PortaDelegata)oggetto;
                                                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione) && pd.getRuoli() != null && pd.getRuoli().sizeRuoloList() > 0) {
                                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTORIZZAZIONE_TRASPORTO_DISABILITATA_AUTORIZZAZIONE_GENERALE);
                                                    return false;
                                                }
                                                if (!ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoli) && pd.getRuoli() != null && pd.getRuoli().sizeRuoloList() > 0) {
                                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTORIZZAZIONE_TRASPORTO_DISABILITATA_PUNTUALMENTE);
                                                    return false;
                                                }
                                                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione) && pd.sizeServizioApplicativoList() > 0) {
                                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTORIZZAZIONE_TRASPORTO_DISABILITATA_AUTORIZZAZIONE_GENERALE);
                                                    return false;
                                                }
                                                if (!ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticati) && pd.sizeServizioApplicativoList() > 0) {
                                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTORIZZAZIONE_TRASPORTO_DISABILITATA_PUNTUALMENTE);
                                                    return false;
                                                }
                                                sbCheckTrasformazioni2 = null;
                                                sbCheckRateLimiting2 = null;
                                                sbCheckAllarmi2 = null;
                                                if (!isSupportatoAutenticazione || pd.getAutenticazione() == null) break block209;
                                                prefix2 = "";
                                                boolean bl = modificataAutenticazione2 = !pd.getAutenticazione().equals(autenticazione);
                                                if (autenticazioneCustom != null && !"".equals(autenticazioneCustom)) {
                                                    boolean bl2 = modificataAutenticazione2 = !pd.getAutenticazione().equals(autenticazioneCustom);
                                                }
                                                if (!modificataAutenticazione2 && ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(autenticazione)) {
                                                    ApiKeyState immagineAttuale = new ApiKeyState(autenticazioneParametroList);
                                                    ApiKeyState immaginePd = new ApiKeyState(this.porteDelegateCore.getParametroAutenticazione(autenticazione, pd.getProprietaAutenticazioneList()));
                                                    if (immagineAttuale.appIdSelected != immaginePd.appIdSelected) {
                                                        modificataAutenticazione2 = true;
                                                        prefix2 = "(Modifica App ID) ";
                                                    }
                                                }
                                                if (!modificataAutenticazione2) break block209;
                                                if (pd.sizeServizioApplicativoList() > 0) {
                                                    this.pd.setMessage(prefix2 + CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTENTICAZIONE_TRASPORTO_MODIFICATA);
                                                    return false;
                                                }
                                                Trasformazioni trasformazioni = pd.getTrasformazioni();
                                                if (trasformazioni != null) {
                                                    StringBuilder sbSoggetti2 = new StringBuilder();
                                                    sbCheckTrasformazioni2 = new StringBuilder();
                                                    for (Object regola2 : trasformazioni.getRegolaList()) {
                                                        if (regola2.getApplicabilita() == null) continue;
                                                        if (regola2.getApplicabilita().sizeSoggettoList() > 0) {
                                                            sbSoggetti2.append("<br/>");
                                                            sbSoggetti2.append("- ");
                                                            sbSoggetti2.append(regola2.getNome());
                                                        }
                                                        if (regola2.getApplicabilita().sizeServizioApplicativoList() <= 0) continue;
                                                        sbCheckTrasformazioni2.append("<br/>");
                                                        sbCheckTrasformazioni2.append("- ");
                                                        sbCheckTrasformazioni2.append(regola2.getNome());
                                                    }
                                                    if (sbSoggetti2 != null && sbSoggetti2.length() > 0) {
                                                        this.pd.setMessage(prefix2 + CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TRASPORTO_MODIFICATA + sbSoggetti2.toString());
                                                        return false;
                                                    }
                                                    if (sbCheckTrasformazioni2.length() > 0) {
                                                        this.pd.setMessage(prefix2 + CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TRASPORTO_MODIFICATA + sbCheckTrasformazioni2.toString());
                                                        return false;
                                                    }
                                                }
                                                if ((listaRateLimiting = this.confCore.attivazionePolicyList(ricercaAll2 = new ConsoleSearch(true), RuoloPolicy.DELEGATA, pd.getNome())) == null || listaRateLimiting.isEmpty()) break block210;
                                                sbCheckRateLimiting2 = new StringBuilder();
                                                regola2 = listaRateLimiting.iterator();
                                                break block211;
                                            }
                                            pa = (PortaApplicativa)oggetto;
                                            profiloModi = this.isProfiloModIPA(protocollo);
                                            if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione) && pa.getRuoli() != null && pa.getRuoli().sizeRuoloList() > 0) {
                                                this.pd.setMessage(profiloModi ? CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTORIZZAZIONE_CANALE_DISABILITATA_AUTORIZZAZIONE_GENERALE : CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTORIZZAZIONE_TRASPORTO_DISABILITATA_AUTORIZZAZIONE_GENERALE);
                                                return false;
                                            }
                                            if (!ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoli) && pa.getRuoli() != null && pa.getRuoli().sizeRuoloList() > 0) {
                                                this.pd.setMessage(profiloModi ? CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTORIZZAZIONE_CANALE_DISABILITATA_PUNTUALMENTE : CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTORIZZAZIONE_TRASPORTO_DISABILITATA_PUNTUALMENTE);
                                                return false;
                                            }
                                            if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione)) {
                                                if (pa.getSoggetti() != null && pa.getSoggetti().sizeSoggettoList() > 0) {
                                                    this.pd.setMessage(profiloModi ? CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_AUTORIZZAZIONE_CANALE_DISABILITATA_AUTORIZZAZIONE_GENERALE : CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_AUTORIZZAZIONE_TRASPORTO_DISABILITATA_AUTORIZZAZIONE_GENERALE);
                                                    return false;
                                                }
                                                if (!profiloModi && pa.getServiziApplicativiAutorizzati() != null && pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTORIZZAZIONE_TRASPORTO_DISABILITATA_AUTORIZZAZIONE_GENERALE);
                                                    return false;
                                                }
                                            }
                                            if (!ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticati)) {
                                                if (pa.getSoggetti() != null && pa.getSoggetti().sizeSoggettoList() > 0) {
                                                    this.pd.setMessage(profiloModi ? CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_AUTORIZZAZIONE_CANALE_DISABILITATA_PUNTUALMENTE : CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_AUTORIZZAZIONE_TRASPORTO_DISABILITATA_PUNTUALMENTE);
                                                    return false;
                                                }
                                                if (!profiloModi && pa.getServiziApplicativiAutorizzati() != null && pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTORIZZAZIONE_TRASPORTO_DISABILITATA_PUNTUALMENTE);
                                                    return false;
                                                }
                                            }
                                            sbCheckTrasformazioni = null;
                                            sbCheckRateLimiting = null;
                                            sbCheckAllarmi = null;
                                            if (!isSupportatoAutenticazione || pa.getAutenticazione() == null) break block212;
                                            prefix = "";
                                            boolean bl = modificataAutenticazione = !pa.getAutenticazione().equals(autenticazione);
                                            if (!modificataAutenticazione && ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(autenticazione)) {
                                                ApiKeyState immagineAttuale = new ApiKeyState(autenticazioneParametroList);
                                                ApiKeyState immaginePa = new ApiKeyState(this.porteApplicativeCore.getParametroAutenticazione(autenticazione, pa.getProprietaAutenticazioneList()));
                                                if (immagineAttuale.appIdSelected != immaginePa.appIdSelected) {
                                                    modificataAutenticazione = true;
                                                    prefix = "(Modifica App ID) ";
                                                }
                                            }
                                            if (!modificataAutenticazione) break block212;
                                            if (pa.getSoggetti() != null && pa.getSoggetti().sizeSoggettoList() > 0) {
                                                this.pd.setMessage(prefix + (profiloModi ? CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_AUTENTICAZIONE_CANALE_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_AUTENTICAZIONE_TRASPORTO_MODIFICATA));
                                                return false;
                                            }
                                            if (pa.getServiziApplicativiAutorizzati() != null && pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                                                this.pd.setMessage(prefix + (profiloModi ? CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTENTICAZIONE_CANALE_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTENTICAZIONE_TRASPORTO_MODIFICATA));
                                                return false;
                                            }
                                            Trasformazioni trasformazioni = pa.getTrasformazioni();
                                            if (trasformazioni != null) {
                                                sbSoggetti = new StringBuilder();
                                                sbCheckTrasformazioni = new StringBuilder();
                                                for (TrasformazioneRegola trasformazioneRegola : trasformazioni.getRegolaList()) {
                                                    if (trasformazioneRegola.getApplicabilita() == null) continue;
                                                    if (trasformazioneRegola.getApplicabilita().sizeSoggettoList() > 0) {
                                                        sbSoggetti.append("<br/>");
                                                        sbSoggetti.append("- ");
                                                        sbSoggetti.append(trasformazioneRegola.getNome());
                                                    }
                                                    if (trasformazioneRegola.getApplicabilita().sizeServizioApplicativoList() <= 0) continue;
                                                    sbCheckTrasformazioni.append("<br/>");
                                                    sbCheckTrasformazioni.append("- ");
                                                    sbCheckTrasformazioni.append(trasformazioneRegola.getNome());
                                                }
                                                if (sbSoggetti.length() > 0) {
                                                    this.pd.setMessage(prefix + (profiloModi ? CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_CANALE_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TRASPORTO_MODIFICATA) + sbSoggetti.toString());
                                                    return false;
                                                }
                                                if (sbCheckTrasformazioni.length() > 0) {
                                                    this.pd.setMessage(prefix + (profiloModi ? CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_CANALE_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TRASPORTO_MODIFICATA) + sbCheckTrasformazioni.toString());
                                                    return false;
                                                }
                                            }
                                            if ((listaRateLimiting2 = this.confCore.attivazionePolicyList(ricercaAll = new ConsoleSearch(true), RuoloPolicy.APPLICATIVA, pa.getNome())) == null || listaRateLimiting2.isEmpty()) break block213;
                                            sbCheckRateLimiting = new StringBuilder();
                                            iterator = listaRateLimiting2.iterator();
                                            break block214;
                                        }
                                        while (regola2.hasNext()) {
                                            AttivazionePolicy attivazionePolicy = (AttivazionePolicy)regola2.next();
                                            if (attivazionePolicy.getFiltro() == null || attivazionePolicy.getFiltro().getServizioApplicativoFruitore() == null) continue;
                                            sbCheckRateLimiting2.append("<br/>");
                                            sbCheckRateLimiting2.append("- ");
                                            sbCheckRateLimiting2.append(attivazionePolicy.getAlias() != null ? attivazionePolicy.getAlias() : attivazionePolicy.getIdActivePolicy());
                                        }
                                        if (sbCheckRateLimiting2.length() > 0) {
                                            this.pd.setMessage(prefix2 + CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_RATE_LIMITING_AUTENTICAZIONE_TRASPORTO_MODIFICATA + sbCheckRateLimiting2.toString());
                                            return false;
                                        }
                                    }
                                    if (this.confCore.isConfigurazioneAllarmiEnabled() && (allarmi = this.confCore.allarmiList(ricercaAll2 = new ConsoleSearch(true), RuoloPorta.DELEGATA, pd.getNome())) != null && !allarmi.isEmpty()) {
                                        sbCheckAllarmi2 = new StringBuilder();
                                        for (ConfigurazioneAllarmeBean configurazioneAllarmeBean : allarmi) {
                                            if (configurazioneAllarmeBean.getFiltro() == null || configurazioneAllarmeBean.getFiltro().getServizioApplicativoFruitore() == null) continue;
                                            sbCheckAllarmi2.append("<br/>");
                                            sbCheckAllarmi2.append("- ");
                                            sbCheckAllarmi2.append(configurazioneAllarmeBean.getAlias() != null ? configurazioneAllarmeBean.getAlias() : configurazioneAllarmeBean.getNome());
                                        }
                                        if (sbCheckAllarmi2.length() > 0) {
                                            this.pd.setMessage(prefix2 + CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_ALLARMI_AUTENTICAZIONE_TRASPORTO_MODIFICATA + sbCheckAllarmi2.toString());
                                            return false;
                                        }
                                    }
                                }
                                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(gestioneToken) && pd.getAutorizzazioneToken() != null && pd.getAutorizzazioneToken().getRuoli() != null && pd.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA);
                                    return false;
                                }
                                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione) && pd.getAutorizzazioneToken() != null && pd.getAutorizzazioneToken().getRuoli() != null && pd.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTORIZZAZIONE_TOKEN_DISABILITATA_AUTORIZZAZIONE_GENERALE);
                                    return false;
                                }
                                if (!ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoliToken) && pd.getAutorizzazioneToken() != null && pd.getAutorizzazioneToken().getRuoli() != null && pd.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTORIZZAZIONE_TOKEN_DISABILITATA_PUNTUALMENTE);
                                    return false;
                                }
                                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(gestioneToken) && pd.getAutorizzazioneToken() != null && pd.getAutorizzazioneToken().getServiziApplicativi() != null && pd.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA);
                                    return false;
                                }
                                if (pd.getGestioneToken() != null && pd.getGestioneToken().getPolicy() != null && !pd.getGestioneToken().getPolicy().equals(policy) && pd.getAutorizzazioneToken() != null && pd.getAutorizzazioneToken().getServiziApplicativi() != null && pd.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY);
                                    return false;
                                }
                                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione) && pd.getAutorizzazioneToken() != null && pd.getAutorizzazioneToken().getServiziApplicativi() != null && pd.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTORIZZAZIONE_TOKEN_DISABILITATA_AUTORIZZAZIONE_GENERALE);
                                    return false;
                                }
                                if (!ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticatiToken) && pd.getAutorizzazioneToken() != null && pd.getAutorizzazioneToken().getServiziApplicativi() != null && pd.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTORIZZAZIONE_TOKEN_DISABILITATA_PUNTUALMENTE);
                                    return false;
                                }
                                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(gestioneToken) && pd.getScope() != null && pd.getScope().sizeScopeList() > 0) {
                                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_SCOPE_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA);
                                    return false;
                                }
                                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione) && pd.getScope() != null && pd.getScope().sizeScopeList() > 0) {
                                    this.pd.setMessage("Non &egrave; possibile disabilitare l'autorizzazione senza prima eliminare gli scope registrati nell'autorizzazione token per scope");
                                    return false;
                                }
                                if (!ServletUtils.isCheckBoxEnabled((String)autorizzazioneScope) && pd.getScope() != null && pd.getScope().sizeScopeList() > 0) {
                                    this.pd.setMessage("Non &egrave; possibile disabilitare l'autorizzazione token per scope senza prima eliminare gli scope registrati");
                                    return false;
                                }
                                boolean disabilitatoGestioneToken = AutorizzazioneUtilities.STATO_DISABILITATO.equals(gestioneToken);
                                boolean bl = modificataTokenPolicy2 = pd.getGestioneToken() != null && pd.getGestioneToken().getPolicy() != null && !pd.getGestioneToken().getPolicy().equals(policy);
                                if (disabilitatoGestioneToken || modificataTokenPolicy2) {
                                    Trasformazioni trasformazioni;
                                    StringBuilder sbSoggetti3 = new StringBuilder();
                                    if (sbCheckTrasformazioni2 == null && (trasformazioni = pd.getTrasformazioni()) != null) {
                                        sbCheckTrasformazioni2 = new StringBuilder();
                                        listaRateLimiting = trasformazioni.getRegolaList().iterator();
                                        while (listaRateLimiting.hasNext()) {
                                            regola2 = (TrasformazioneRegola)listaRateLimiting.next();
                                            if (regola2.getApplicabilita() == null) continue;
                                            if (regola2.getApplicabilita().sizeSoggettoList() > 0) {
                                                sbSoggetti3.append("<br/>");
                                                sbSoggetti3.append("- ");
                                                sbSoggetti3.append(regola2.getNome());
                                            }
                                            if (regola2.getApplicabilita().sizeServizioApplicativoList() <= 0) continue;
                                            sbCheckTrasformazioni2.append("<br/>");
                                            sbCheckTrasformazioni2.append("- ");
                                            sbCheckTrasformazioni2.append(regola2.getNome());
                                        }
                                    }
                                    if (sbSoggetti3 != null && sbSoggetti3.length() > 0) {
                                        this.pd.setMessage((disabilitatoGestioneToken ? CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TOKEN_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY) + sbSoggetti3.toString());
                                        return false;
                                    }
                                    if (sbCheckTrasformazioni2 != null && sbCheckTrasformazioni2.length() > 0) {
                                        this.pd.setMessage((disabilitatoGestioneToken ? CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TOKEN_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY) + sbCheckTrasformazioni2.toString());
                                        return false;
                                    }
                                    if (sbCheckRateLimiting2 == null && (listaRateLimiting = this.confCore.attivazionePolicyList(ricercaAll2 = new ConsoleSearch(true), RuoloPolicy.DELEGATA, pd.getNome())) != null && !listaRateLimiting.isEmpty()) {
                                        sbCheckRateLimiting2 = new StringBuilder();
                                        for (AttivazionePolicy attivazionePolicy : listaRateLimiting) {
                                            if (attivazionePolicy.getFiltro() == null || attivazionePolicy.getFiltro().getServizioApplicativoFruitore() == null) continue;
                                            sbCheckRateLimiting2.append("<br/>");
                                            sbCheckRateLimiting2.append("- ");
                                            sbCheckRateLimiting2.append(attivazionePolicy.getAlias() != null ? attivazionePolicy.getAlias() : attivazionePolicy.getIdActivePolicy());
                                        }
                                    }
                                    if (sbCheckRateLimiting2 != null && sbCheckRateLimiting2.length() > 0) {
                                        this.pd.setMessage((disabilitatoGestioneToken ? CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_RATE_LIMITING_AUTENTICAZIONE_TOKEN_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_RATE_LIMITING_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY) + sbCheckRateLimiting2.toString());
                                        return false;
                                    }
                                    if (this.confCore.isConfigurazioneAllarmiEnabled()) {
                                        List<ConfigurazioneAllarmeBean> allarmi;
                                        if (sbCheckAllarmi2 == null && (allarmi = this.confCore.allarmiList(ricercaAll2 = new ConsoleSearch(true), RuoloPorta.DELEGATA, pd.getNome())) != null && !allarmi.isEmpty()) {
                                            sbCheckAllarmi2 = new StringBuilder();
                                            for (ConfigurazioneAllarmeBean configurazioneAllarmeBean : allarmi) {
                                                if (configurazioneAllarmeBean.getFiltro() == null || configurazioneAllarmeBean.getFiltro().getServizioApplicativoFruitore() == null) continue;
                                                sbCheckAllarmi2.append("<br/>");
                                                sbCheckAllarmi2.append("- ");
                                                sbCheckAllarmi2.append(configurazioneAllarmeBean.getAlias() != null ? configurazioneAllarmeBean.getAlias() : configurazioneAllarmeBean.getNome());
                                            }
                                        }
                                        if (sbCheckAllarmi2 != null && sbCheckAllarmi2.length() > 0) {
                                            this.pd.setMessage((disabilitatoGestioneToken ? CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_ALLARMI_AUTENTICAZIONE_TOKEN_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_ALLARMI_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY) + sbCheckAllarmi2.toString());
                                            return false;
                                        }
                                    }
                                }
                                break block207;
                            }
                            while (iterator.hasNext()) {
                                AttivazionePolicy attivazionePolicy = iterator.next();
                                if (attivazionePolicy.getFiltro() == null || attivazionePolicy.getFiltro().getServizioApplicativoFruitore() == null && attivazionePolicy.getFiltro().getNomeFruitore() == null) continue;
                                sbCheckRateLimiting.append("<br/>");
                                sbCheckRateLimiting.append("- ");
                                sbCheckRateLimiting.append(attivazionePolicy.getAlias() != null ? attivazionePolicy.getAlias() : attivazionePolicy.getIdActivePolicy());
                            }
                            if (sbCheckRateLimiting.length() > 0) {
                                this.pd.setMessage(prefix + (profiloModi ? CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_RATE_LIMITING_AUTENTICAZIONE_CANALE_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_RATE_LIMITING_AUTENTICAZIONE_TRASPORTO_MODIFICATA) + sbCheckRateLimiting.toString());
                                return false;
                            }
                        }
                        if (this.confCore.isConfigurazioneAllarmiEnabled() && (list = this.confCore.allarmiList(ricercaAll = new ConsoleSearch(true), RuoloPorta.APPLICATIVA, pa.getNome())) != null && !list.isEmpty()) {
                            sbCheckAllarmi = new StringBuilder();
                            for (ConfigurazioneAllarmeBean configurazioneAllarmeBean : list) {
                                if (configurazioneAllarmeBean.getFiltro() == null || configurazioneAllarmeBean.getFiltro().getServizioApplicativoFruitore() == null && configurazioneAllarmeBean.getFiltro().getNomeFruitore() == null) continue;
                                sbCheckAllarmi.append("<br/>");
                                sbCheckAllarmi.append("- ");
                                sbCheckAllarmi.append(configurazioneAllarmeBean.getAlias() != null ? configurazioneAllarmeBean.getAlias() : configurazioneAllarmeBean.getNome());
                            }
                            if (sbCheckAllarmi.length() > 0) {
                                this.pd.setMessage(prefix + (profiloModi ? CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_ALLARMI_AUTENTICAZIONE_CANALE_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_ALLARMI_AUTENTICAZIONE_TRASPORTO_MODIFICATA) + sbCheckAllarmi.toString());
                                return false;
                            }
                        }
                    }
                    modiSicurezzaMessaggio = false;
                    try {
                        IDServizio idAps = IDServizioFactory.getInstance().getIDServizioFromValues(pa.getServizio().getTipo(), pa.getServizio().getNome(), pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario(), pa.getServizio().getVersione().intValue());
                        if (idAps == null) break block205;
                        AccordoServizioParteSpecifica asps = this.apsCore.getServizio(idAps);
                        idAps.setPortType(asps.getPortType());
                        idAps.setUriAccordoServizioParteComune(asps.getAccordoServizioParteComune());
                        IProtocolFactory protocolFactory = ProtocolFactoryManager.getInstance().getProtocolFactoryByName(protocollo);
                        IConsoleDynamicConfiguration consoleDynamicConfiguration = protocolFactory.createDynamicConfigurationConsole();
                        IRegistryReader iRegistryReader = this.apcCore.getRegistryReader(protocolFactory);
                        IConfigIntegrationReader iConfigIntegrationReader = this.apcCore.getConfigIntegrationReader(protocolFactory);
                        ConsoleConfiguration consoleConfiguration = consoleDynamicConfiguration.getDynamicConfigAccordoServizioParteSpecifica(ConsoleOperationType.CHANGE, (IConsoleHelper)this, iRegistryReader, iConfigIntegrationReader, idAps);
                        if (consoleConfiguration != null && consoleConfiguration.getConsoleItem() != null && !consoleConfiguration.getConsoleItem().isEmpty()) {
                            modiSicurezzaMessaggio = true;
                        }
                    }
                    catch (Exception t) {
                        this.logError(t.getMessage(), t);
                    }
                }
                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(gestioneToken) && pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getRuoli() != null && pa.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                    if (!profiloModi) {
                        this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA);
                        return false;
                    }
                    if (!modiSicurezzaMessaggio) {
                        this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA_MODI);
                        return false;
                    }
                }
                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione) && pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getRuoli() != null && pa.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTORIZZAZIONE_TOKEN_DISABILITATA_AUTORIZZAZIONE_GENERALE);
                    return false;
                }
                if (!ServletUtils.isCheckBoxEnabled((String)autorizzazioneRuoliToken) && pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getRuoli() != null && pa.getAutorizzazioneToken().getRuoli().sizeRuoloList() > 0) {
                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_RUOLI_PRESENTI_AUTORIZZAZIONE_TOKEN_DISABILITATA_PUNTUALMENTE);
                    return false;
                }
                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(gestioneToken)) {
                    if (profiloModi) {
                        if (!modiSicurezzaMessaggio && pa.getServiziApplicativiAutorizzati() != null && pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                            this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA_MODI);
                            return false;
                        }
                    } else if (pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getServiziApplicativi() != null && pa.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA);
                        return false;
                    }
                }
                if (pa.getGestioneToken() != null && pa.getGestioneToken().getPolicy() != null && !pa.getGestioneToken().getPolicy().equals(policy)) {
                    if (profiloModi) {
                        if (pa.getServiziApplicativiAutorizzati() != null && pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                            this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY_MODI);
                            return false;
                        }
                    } else if (pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getServiziApplicativi() != null && pa.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY);
                        return false;
                    }
                }
                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione)) {
                    if (profiloModi) {
                        if (pa.getServiziApplicativiAutorizzati() != null && pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                            this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTORIZZAZIONE_MESSAGGIO_DISABILITATA_AUTORIZZAZIONE_GENERALE);
                            return false;
                        }
                    } else if (pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getServiziApplicativi() != null && pa.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTORIZZAZIONE_TOKEN_DISABILITATA_AUTORIZZAZIONE_GENERALE);
                        return false;
                    }
                }
                if (!ServletUtils.isCheckBoxEnabled((String)autorizzazioneAutenticatiToken)) {
                    if (profiloModi) {
                        if (pa.getServiziApplicativiAutorizzati() != null && pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() > 0) {
                            this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTORIZZAZIONE_MESSAGGIO_DISABILITATA_PUNTUALMENTE);
                            return false;
                        }
                    } else if (pa.getAutorizzazioneToken() != null && pa.getAutorizzazioneToken().getServiziApplicativi() != null && pa.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() > 0) {
                        this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_AUTORIZZAZIONE_TOKEN_DISABILITATA_PUNTUALMENTE);
                        return false;
                    }
                }
                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(gestioneToken) && pa.getScope() != null && pa.getScope().sizeScopeList() > 0) {
                    this.pd.setMessage(CostantiControlStation.MESSAGGIO_ERRORE_SCOPE_PRESENTI_AUTENTICAZIONE_TOKEN_MODIFICATA);
                    return false;
                }
                if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione) && pa.getScope() != null && pa.getScope().sizeScopeList() > 0) {
                    this.pd.setMessage("Non &egrave; possibile disabilitare l'autorizzazione senza prima eliminare gli scope registrati nell'autorizzazione token per scope");
                    return false;
                }
                if (!ServletUtils.isCheckBoxEnabled((String)autorizzazioneScope) && pa.getScope() != null && pa.getScope().sizeScopeList() > 0) {
                    this.pd.setMessage("Non &egrave; possibile disabilitare l'autorizzazione token per scope senza prima eliminare gli scope registrati");
                    return false;
                }
                boolean disabilitatoGestioneToken = AutorizzazioneUtilities.STATO_DISABILITATO.equals(gestioneToken);
                boolean bl = modificataTokenPolicy = pa.getGestioneToken() != null && pa.getGestioneToken().getPolicy() != null && !pa.getGestioneToken().getPolicy().equals(policy);
                if (disabilitatoGestioneToken || modificataTokenPolicy) {
                    ConsoleSearch ricercaAll;
                    List<AttivazionePolicy> list;
                    Trasformazioni trasformazioni;
                    sbSoggetti = new StringBuilder();
                    if (sbCheckTrasformazioni == null && (trasformazioni = pa.getTrasformazioni()) != null) {
                        sbCheckTrasformazioni = new StringBuilder();
                        for (TrasformazioneRegola trasformazioneRegola : trasformazioni.getRegolaList()) {
                            if (trasformazioneRegola.getApplicabilita() == null) continue;
                            if (trasformazioneRegola.getApplicabilita().sizeSoggettoList() > 0) {
                                sbSoggetti.append("<br/>");
                                sbSoggetti.append("- ");
                                sbSoggetti.append(trasformazioneRegola.getNome());
                            }
                            if (trasformazioneRegola.getApplicabilita().sizeServizioApplicativoList() <= 0) continue;
                            sbCheckTrasformazioni.append("<br/>");
                            sbCheckTrasformazioni.append("- ");
                            sbCheckTrasformazioni.append(trasformazioneRegola.getNome());
                        }
                    }
                    if (sbSoggetti != null && sbSoggetti.length() > 0) {
                        this.pd.setMessage((disabilitatoGestioneToken ? CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TOKEN_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_SOGGETTI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY) + sbSoggetti.toString());
                        return false;
                    }
                    if (sbCheckTrasformazioni != null && sbCheckTrasformazioni.length() > 0) {
                        this.pd.setMessage((disabilitatoGestioneToken ? CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TOKEN_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_TRASFORMAZIONI_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY) + sbCheckTrasformazioni.toString());
                        return false;
                    }
                    if (sbCheckRateLimiting == null && (list = this.confCore.attivazionePolicyList(ricercaAll = new ConsoleSearch(true), RuoloPolicy.APPLICATIVA, pa.getNome())) != null && !list.isEmpty()) {
                        sbCheckRateLimiting = new StringBuilder();
                        for (AttivazionePolicy attivazionePolicy : list) {
                            if (attivazionePolicy.getFiltro() == null || attivazionePolicy.getFiltro().getServizioApplicativoFruitore() == null && attivazionePolicy.getFiltro().getNomeFruitore() == null) continue;
                            sbCheckRateLimiting.append("<br/>");
                            sbCheckRateLimiting.append("- ");
                            sbCheckRateLimiting.append(attivazionePolicy.getAlias() != null ? attivazionePolicy.getAlias() : attivazionePolicy.getIdActivePolicy());
                        }
                    }
                    if (sbCheckRateLimiting != null && sbCheckRateLimiting.length() > 0) {
                        this.pd.setMessage((disabilitatoGestioneToken ? CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_RATE_LIMITING_AUTENTICAZIONE_TOKEN_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_RATE_LIMITING_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY) + sbCheckRateLimiting.toString());
                        return false;
                    }
                    if (this.confCore.isConfigurazioneAllarmiEnabled()) {
                        List<ConfigurazioneAllarmeBean> list2;
                        if (sbCheckAllarmi == null && (list2 = this.confCore.allarmiList(ricercaAll = new ConsoleSearch(true), RuoloPorta.APPLICATIVA, pa.getNome())) != null && !list2.isEmpty()) {
                            sbCheckAllarmi = new StringBuilder();
                            for (ConfigurazioneAllarmeBean configurazioneAllarmeBean : list2) {
                                if (configurazioneAllarmeBean.getFiltro() == null || configurazioneAllarmeBean.getFiltro().getServizioApplicativoFruitore() == null && configurazioneAllarmeBean.getFiltro().getNomeFruitore() == null) continue;
                                sbCheckAllarmi.append("<br/>");
                                sbCheckAllarmi.append("- ");
                                sbCheckAllarmi.append(configurazioneAllarmeBean.getAlias() != null ? configurazioneAllarmeBean.getAlias() : configurazioneAllarmeBean.getNome());
                            }
                        }
                        if (sbCheckAllarmi != null && sbCheckAllarmi.length() > 0) {
                            this.pd.setMessage((disabilitatoGestioneToken ? CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_ALLARMI_AUTENTICAZIONE_TOKEN_MODIFICATA : CostantiControlStation.MESSAGGIO_ERRORE_APPLICATIVI_PRESENTI_ALLARMI_AUTENTICAZIONE_TOKEN_MODIFICATA_TOKEN_POLICY) + sbCheckAllarmi.toString());
                            return false;
                        }
                    }
                }
            }
            if (autorizzazione != null && autorizzazione.equals("custom")) {
                String autorizzazioneCustom = this.getParameter("autorizzazioneCustom");
                if (StringUtils.isEmpty((CharSequence)autorizzazioneCustom) || "--".equals(autorizzazioneCustom)) {
                    if (this.confCore.isConfigurazionePluginsEnabled()) {
                        this.pd.setMessage("Non \u00e8 stato selezionato nessun plugin da utilizzare come meccanismo di autorizzazione");
                        return false;
                    }
                    this.pd.setMessage("Tipo Personalizzato obbligatorio per il tipo di autorizzazione selezionato");
                    return false;
                }
                if (!this.checkLength255(autorizzazioneCustom, "Autorizzazione - controlli custom")) {
                    return false;
                }
            }
            if (autorizzazioneContenutiStato == null) return true;
            if (autorizzazioneContenutiStato.equals(StatoFunzionalita.DISABILITATO.getValue())) return true;
            if (autorizzazioneContenutiStato.equals(StatoFunzionalita.ABILITATO.getValue())) {
                if (autorizzazioneContenutiProperties == null || "".equals(autorizzazioneContenutiProperties)) {
                    this.pd.setMessage("Dati incompleti. Definire almeno un controllo di autorizzazione per il contenuto della richiesta");
                    return false;
                }
                if (autorizzazioneContenutiProperties != null) {
                    try (Scanner scanner = new Scanner(autorizzazioneContenutiProperties);){
                        while (scanner.hasNextLine()) {
                            String line = scanner.nextLine();
                            if (line == null || line.trim().equals("") || (line = line.trim()) != null && line.startsWith("#")) continue;
                            if (!line.contains("=")) {
                                this.pd.setMessage("I controlli di autorizzazione del contenuto in ogni riga devono essere indicati come coppia (risorsa=valore); non \u00e8 stato riscontrato il carattere separatore '=' nella linea " + line);
                                boolean sbCheckTrasformazioni = false;
                                return sbCheckTrasformazioni;
                            }
                            String[] tmp = line.split("=");
                            if (tmp == null || tmp.length < 1) {
                                this.pd.setMessage("I controlli di autorizzazione del contenuto in ogni riga devono essere indicati come coppia (risorsa=valore); non \u00e8 stato riscontrato il carattere separatore '=' nella linea " + line);
                                boolean sbCheckRateLimiting = false;
                                return sbCheckRateLimiting;
                            }
                            String key = tmp[0];
                            if (key == null || !key.contains("$")) {
                                this.pd.setMessage("I controlli di autorizzazione del contenuto in ogni riga devono essere indicati come coppia (risorsa=valore); non \u00e8 stato riscontrata l'indicazione di una risorsa, tramite espressioni dinamiche, nella linea " + line);
                                boolean sbCheckAllarmi = false;
                                return sbCheckAllarmi;
                            }
                            if (key.length() > 255) {
                                this.pd.setMessage("I controlli di autorizzazione del contenuto in ogni riga devono essere indicati come coppia (risorsa=valore); \u00e8 stata riscontrata una lunghezza superiore ai 255 caratteri per la risorsa indicata nella linea " + line);
                                boolean sbCheckAllarmi = false;
                                return sbCheckAllarmi;
                            }
                            if (tmp.length < 2 || tmp[1] == null || tmp[1].equals("")) {
                                this.pd.setMessage("I controlli di autorizzazione del contenuto in ogni riga devono essere indicati come coppia (risorsa=valore); non \u00e8 stato indicato un valore nella linea " + line);
                                boolean sbCheckAllarmi = false;
                                return sbCheckAllarmi;
                            }
                            String value = tmp[1];
                            if (value.length() <= 255) continue;
                            this.pd.setMessage("I controlli di autorizzazione del contenuto in ogni riga devono essere indicati come coppia (risorsa=valore); \u00e8 stata riscontrata una lunghezza superiore ai 255 caratteri per il valore indicato nella linea " + line);
                            boolean bl = false;
                            return bl;
                        }
                    }
                }
            }
            if (!autorizzazioneContenutiStato.equals("custom")) return true;
            if (!StringUtils.isEmpty((CharSequence)autorizzazioneContenuto) && !"--".equals(autorizzazioneContenuto)) {
                if (this.checkLength255(autorizzazioneContenuto, "Autorizzazione Contenuti - controlli custom")) return true;
                return false;
            }
            if (this.confCore.isConfigurazionePluginsEnabled()) {
                this.pd.setMessage("Non \u00e8 stato selezionato nessun plugin da utilizzare per autorizzare il contenuto della richiesta");
                return false;
            }
            this.pd.setMessage("Tipo Personalizzato obbligatorio per il tipo di autorizzazione selezionato");
            return false;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    private boolean checkAttributes(String[] attributeAuthoritySelezionate, String attributeAuthorityAttributi) {
        if (attributeAuthoritySelezionate != null && attributeAuthoritySelezionate.length > 1) {
            Properties properties = null;
            if (attributeAuthorityAttributi != null && StringUtils.isNotEmpty((CharSequence)attributeAuthorityAttributi)) {
                properties = PropertiesUtilities.convertTextToProperties((String)attributeAuthorityAttributi);
                if (properties != null && properties.size() > 0) {
                    for (Object oKey : properties.keySet()) {
                        if (!(oKey instanceof String)) continue;
                        String aaName = (String)oKey;
                        boolean find = false;
                        for (String aa : attributeAuthoritySelezionate) {
                            if (!aa.equals(aaName)) continue;
                            find = true;
                            break;
                        }
                        if (!find) {
                            this.pd.setMessage(MessageFormat.format("Attribute Authority ''{0}'' indicata nel campo ''{1}'' non esistente", aaName, "Attributi Richiesti"));
                            return false;
                        }
                        String p = properties.getProperty(aaName);
                        List attributi = DBUtils.convertToList((String)p);
                        if (attributi != null && !attributi.isEmpty()) continue;
                        this.pd.setMessage(MessageFormat.format("Non sono stati definiti degli attributi per l'Attribute Authority ''{0}'' indicata nel campo ''{1}''", aaName, "Attributi Richiesti"));
                        return false;
                    }
                } else {
                    this.pd.setMessage(MessageFormat.format("Attribute Authority ''{0}'' indicata nel campo ''{1}'' non esistente", attributeAuthorityAttributi, "Attributi Richiesti"));
                    return false;
                }
            }
        }
        return true;
    }

    public String getStatoMessageSecurityPortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        String statoMessageSecurity = paAssociata.getStatoMessageSecurity();
        return statoMessageSecurity;
    }

    public String getStatoDumpPortaApplicativa(PortaApplicativa paAssociata, boolean usePrefixDefault) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        DumpConfigurazione dumpConfigurazione = paAssociata.getDump();
        String statoDump = dumpConfigurazione == null ? this.getDumpLabelDefault(usePrefixDefault, true) : (this.isDumpConfigurazioneAbilitato(dumpConfigurazione) ? "abilitato" : "disabilitato");
        return statoDump;
    }

    public String getStatoDumpRichiestaPortaApplicativa(PortaApplicativa paAssociata, boolean usePrefixDefault) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        DumpConfigurazione dumpConfigurazione = paAssociata.getDump();
        String statoDump = dumpConfigurazione == null ? this.getDumpLabelDefault(usePrefixDefault, true) : (this.isDumpConfigurazioneAbilitato(dumpConfigurazione, false) ? "abilitato" : "disabilitato");
        return statoDump;
    }

    public String getStatoDumpRispostaPortaApplicativa(PortaApplicativa paAssociata, boolean usePrefixDefault) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        DumpConfigurazione dumpConfigurazione = paAssociata.getDump();
        String statoDump = dumpConfigurazione == null ? this.getDumpLabelDefault(usePrefixDefault, true) : (this.isDumpConfigurazioneAbilitato(dumpConfigurazione, true) ? "abilitato" : "disabilitato");
        return statoDump;
    }

    public String getStatoTracciamentoPortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        String statoTracciamento = "disabilitato";
        boolean isCorrelazioneApplicativaAbilitataReq = false;
        if (paAssociata.getCorrelazioneApplicativa() != null) {
            isCorrelazioneApplicativaAbilitataReq = paAssociata.getCorrelazioneApplicativa().sizeElementoList() > 0;
        }
        boolean isCorrelazioneApplicativaAbilitataRes = false;
        if (paAssociata.getCorrelazioneApplicativaRisposta() != null) {
            isCorrelazioneApplicativaAbilitataRes = paAssociata.getCorrelazioneApplicativaRisposta().sizeElementoList() > 0;
        }
        boolean tracciamento = false;
        if (paAssociata.getTracciamento() != null && (paAssociata.getTracciamento().getEsiti() != null && !("" + EsitiConfigUtils.TUTTI_ESITI_DISABILITATI).equals(paAssociata.getTracciamento().getEsiti()) || paAssociata.getTracciamento().getSeverita() != null)) {
            tracciamento = true;
        }
        statoTracciamento = tracciamento || isCorrelazioneApplicativaAbilitataReq || isCorrelazioneApplicativaAbilitataRes ? "abilitato" : "disabilitato";
        return statoTracciamento;
    }

    public boolean isRidefinitoTransazioniRegistratePortaApplicativa(PortaApplicativa paAssociata) {
        return paAssociata.getTracciamento() != null && paAssociata.getTracciamento().getEsiti() != null;
    }

    public String getStatoTransazioniRegistratePortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        if (paAssociata.getTracciamento() != null && paAssociata.getTracciamento().getEsiti() != null) {
            return "ridefinito";
        }
        return "default";
    }

    public boolean isRidefinitoMessaggiDiagnosticiPortaApplicativa(PortaApplicativa paAssociata) {
        return paAssociata.getTracciamento() != null && paAssociata.getTracciamento().getSeverita() != null;
    }

    public String getStatoMessaggiDiagnosticiPortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        if (paAssociata.getTracciamento() != null && paAssociata.getTracciamento().getSeverita() != null) {
            return paAssociata.getTracciamento().getSeverita().getValue();
        }
        return "default";
    }

    public boolean isEnabledCorrelazioneApplicativaPortaApplicativa(PortaApplicativa paAssociata) {
        boolean isCorrelazioneApplicativaAbilitataReq = false;
        if (paAssociata.getCorrelazioneApplicativa() != null) {
            isCorrelazioneApplicativaAbilitataReq = paAssociata.getCorrelazioneApplicativa().sizeElementoList() > 0;
        }
        boolean isCorrelazioneApplicativaAbilitataRes = false;
        if (paAssociata.getCorrelazioneApplicativaRisposta() != null) {
            isCorrelazioneApplicativaAbilitataRes = paAssociata.getCorrelazioneApplicativaRisposta().sizeElementoList() > 0;
        }
        return isCorrelazioneApplicativaAbilitataReq || isCorrelazioneApplicativaAbilitataRes;
    }

    public String getStatoCorrelazioneApplicativaPortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        boolean isCorrelazioneApplicativaAbilitataReq = false;
        if (paAssociata.getCorrelazioneApplicativa() != null) {
            isCorrelazioneApplicativaAbilitataReq = paAssociata.getCorrelazioneApplicativa().sizeElementoList() > 0;
        }
        boolean isCorrelazioneApplicativaAbilitataRes = false;
        if (paAssociata.getCorrelazioneApplicativaRisposta() != null) {
            boolean bl = isCorrelazioneApplicativaAbilitataRes = paAssociata.getCorrelazioneApplicativaRisposta().sizeElementoList() > 0;
        }
        if (isCorrelazioneApplicativaAbilitataReq && isCorrelazioneApplicativaAbilitataRes) {
            return "abilitato";
        }
        if (isCorrelazioneApplicativaAbilitataReq) {
            return "richiesta";
        }
        if (isCorrelazioneApplicativaAbilitataRes) {
            return "risposta";
        }
        return "disabilitato";
    }

    public String getStatoMTOMPortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        String statoMTOM = "disabilitato";
        boolean isMTOMAbilitatoReq = false;
        boolean isMTOMAbilitatoRes = false;
        if (paAssociata.getMtomProcessor() != null) {
            MTOMProcessorType mode;
            if (paAssociata.getMtomProcessor().getRequestFlow() != null && paAssociata.getMtomProcessor().getRequestFlow().getMode() != null && !(mode = paAssociata.getMtomProcessor().getRequestFlow().getMode()).equals((Object)MTOMProcessorType.DISABLE)) {
                isMTOMAbilitatoReq = true;
            }
            if (paAssociata.getMtomProcessor().getResponseFlow() != null && paAssociata.getMtomProcessor().getResponseFlow().getMode() != null && !(mode = paAssociata.getMtomProcessor().getResponseFlow().getMode()).equals((Object)MTOMProcessorType.DISABLE)) {
                isMTOMAbilitatoRes = true;
            }
        }
        statoMTOM = isMTOMAbilitatoReq || isMTOMAbilitatoRes ? "abilitato" : "disabilitato";
        return statoMTOM;
    }

    public MTOMProcessorType getProcessorTypeRequestMTOMPortaApplicativa(PortaApplicativa paAssociata) {
        if (paAssociata.getMtomProcessor() != null && paAssociata.getMtomProcessor().getRequestFlow() != null && paAssociata.getMtomProcessor().getRequestFlow().getMode() != null) {
            MTOMProcessorType mode = paAssociata.getMtomProcessor().getRequestFlow().getMode();
            return mode;
        }
        return null;
    }

    public MTOMProcessorType getProcessorTypeResponseMTOMPortaApplicativa(PortaApplicativa paAssociata) {
        if (paAssociata.getMtomProcessor() != null && paAssociata.getMtomProcessor().getResponseFlow() != null && paAssociata.getMtomProcessor().getResponseFlow().getMode() != null) {
            MTOMProcessorType mode = paAssociata.getMtomProcessor().getResponseFlow().getMode();
            return mode;
        }
        return null;
    }

    public String getStatoValidazionePortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        String statoValidazione = null;
        ValidazioneContenutiApplicativi vx = paAssociata.getValidazioneContenutiApplicativi();
        if (vx == null) {
            statoValidazione = PorteDelegateCostanti.DEFAULT_VALUE_PARAMETRO_PORTE_DELEGATE_VALIDAZIONE_DISABILITATO;
        } else {
            if (vx.getStato() != null) {
                statoValidazione = vx.getStato().toString();
            }
            if (statoValidazione == null || "".equals(statoValidazione)) {
                statoValidazione = PorteDelegateCostanti.DEFAULT_VALUE_PARAMETRO_PORTE_DELEGATE_VALIDAZIONE_DISABILITATO;
            }
        }
        return statoValidazione;
    }

    public String getTipoValidazionePortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        String tipoValidazione = null;
        ValidazioneContenutiApplicativi vx = paAssociata.getValidazioneContenutiApplicativi();
        if (vx != null && vx.getTipo() != null) {
            tipoValidazione = vx.getTipo().getValue();
        }
        return tipoValidazione;
    }

    public String getStatoResponseCachingPortaApplicativa(PortaApplicativa paAssociata, boolean usePrefixDefault) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        String stato = null;
        ResponseCachingConfigurazione rc = paAssociata.getResponseCaching();
        stato = rc == null ? this.getResponseCachingLabelDefault(usePrefixDefault) : (rc.getStato() != null ? rc.getStato().getValue() : PorteDelegateCostanti.DEFAULT_VALUE_PARAMETRO_PORTE_DELEGATE_VALIDAZIONE_DISABILITATO);
        return stato;
    }

    public String getStatoGestioneCorsPortaApplicativa(PortaApplicativa paAssociata, boolean usePrefixDefault) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        String stato = null;
        CorsConfigurazione cc = paAssociata.getGestioneCors();
        stato = cc == null ? this.getGestioneCorsLabelDefault(usePrefixDefault) : (cc.getStato() == null || StatoFunzionalita.DISABILITATO.equals((Object)cc.getStato()) ? StatoFunzionalita.DISABILITATO.getValue() : this.getLabelTipoGestioneCors(cc.getTipo()));
        return stato;
    }

    public String getStatoOpzioniAvanzatePortaDelegataDefault(PortaDelegata pdAssociata) throws DriverControlStationException {
        if (pdAssociata == null) {
            throw new DriverControlStationException("Param pdAssociata is null");
        }
        return this._getStatoOpzioniAvanzatePortaApplicativaDefault(pdAssociata.getOptions());
    }

    public String getStatoOpzioniAvanzatePortaApplicativaDefault(PortaApplicativa paAssociata) throws DriverControlStationException {
        if (paAssociata == null) {
            throw new DriverControlStationException("Param paAssociata is null");
        }
        return this._getStatoOpzioniAvanzatePortaApplicativaDefault(paAssociata.getOptions());
    }

    private String _getStatoOpzioniAvanzatePortaApplicativaDefault(String options) throws DriverControlStationException {
        String stato = null;
        Map props = null;
        try {
            props = PropertiesSerializator.convertoFromDBColumnValue((String)options);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        stato = props == null || props.size() <= 0 ? StatoFunzionalita.DISABILITATO.getValue() : StatoFunzionalita.ABILITATO.getValue();
        return stato;
    }

    public String getStatoControlloAccessiPortaApplicativa(String protocollo, PortaApplicativa paAssociata) throws DriverControlStationException, DriverControlStationNotFound {
        return this._getStatoControlloAccessiPortaApplicativa(protocollo, paAssociata, null);
    }

    public void setStatoControlloAccessiPortaApplicativa(String protocollo, PortaApplicativa paAssociata, DataElement de) throws DriverControlStationException, DriverControlStationNotFound {
        this._getStatoControlloAccessiPortaApplicativa(protocollo, paAssociata, de);
    }

    private String _getStatoControlloAccessiPortaApplicativa(String protocollo, PortaApplicativa paAssociata, DataElement de) throws DriverControlStationException, DriverControlStationNotFound {
        String autorizzazioneContenuti;
        boolean modipa;
        if (paAssociata == null) {
            throw new DriverControlStationException("Param paAssociata is null");
        }
        String gestioneToken = null;
        String gestioneTokenPolicy = null;
        String gestioneTokenOpzionale = "";
        GestioneToken gestioneTokenConfig = null;
        AutorizzazioneScope autorizzazioneScope = null;
        PortaDelegataAutorizzazioneToken autorizzazioneTokenPortaDelegata = null;
        PortaApplicativaAutorizzazioneToken autorizzazioneTokenPortaApplicativa = null;
        if (paAssociata.getGestioneToken() != null && paAssociata.getGestioneToken().getPolicy() != null && !"".equals(paAssociata.getGestioneToken().getPolicy()) && !"-".equals(paAssociata.getGestioneToken().getPolicy())) {
            gestioneToken = StatoFunzionalita.ABILITATO.getValue();
            gestioneTokenPolicy = paAssociata.getGestioneToken().getPolicy();
            if (paAssociata.getGestioneToken() != null && paAssociata.getGestioneToken().getTokenOpzionale() != null && paAssociata.getGestioneToken().getTokenOpzionale().equals((Object)StatoFunzionalita.ABILITATO)) {
                gestioneTokenOpzionale = "yes";
            }
            gestioneTokenConfig = paAssociata.getGestioneToken();
            autorizzazioneScope = paAssociata.getScope();
            autorizzazioneTokenPortaApplicativa = paAssociata.getAutorizzazioneToken();
        }
        if ((modipa = this.isProfiloModIPA(protocollo)) && autorizzazioneTokenPortaApplicativa == null) {
            autorizzazioneTokenPortaApplicativa = paAssociata.getAutorizzazioneToken();
        }
        String autenticazione = paAssociata.getAutenticazione();
        String autenticazioneCustom = null;
        if (autenticazione != null && !TipoAutenticazione.getValues().contains(autenticazione)) {
            autenticazioneCustom = autenticazione;
            autenticazione = "custom";
            Plugin plugin = null;
            try {
                plugin = this.confCore.getPlugin(TipoPlugin.AUTENTICAZIONE, autenticazioneCustom, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (plugin != null && plugin.getLabel() != null) {
                autenticazioneCustom = plugin.getLabel();
            }
        }
        String autenticazioneOpzionale = "";
        if (paAssociata.getAutenticazioneOpzionale() != null && paAssociata.getAutenticazioneOpzionale().equals((Object)StatoFunzionalita.ABILITATO)) {
            autenticazioneOpzionale = "yes";
        }
        String autorizzazione = null;
        String autorizzazioneCustom = null;
        int sizeApplicativi = 0;
        int sizeSoggetti = 0;
        int sizeRuoli = 0;
        if (paAssociata.getAutorizzazione() != null && !TipoAutorizzazione.getAllValues().contains(paAssociata.getAutorizzazione())) {
            autorizzazioneCustom = paAssociata.getAutorizzazione();
            autorizzazione = "custom";
            Plugin plugin = null;
            try {
                plugin = this.confCore.getPlugin(TipoPlugin.AUTORIZZAZIONE, autorizzazioneCustom, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (plugin != null && plugin.getLabel() != null) {
                autorizzazioneCustom = plugin.getLabel();
            }
        } else {
            autorizzazione = de != null ? paAssociata.getAutorizzazione() : AutorizzazioneUtilities.convertToStato(paAssociata.getAutorizzazione());
            autorizzazione = paAssociata.getAutorizzazione();
        }
        if (paAssociata.getServiziApplicativiAutorizzati() != null) {
            sizeApplicativi = paAssociata.getServiziApplicativiAutorizzati().sizeServizioApplicativoList();
        }
        if (paAssociata.getSoggetti() != null) {
            sizeSoggetti = paAssociata.getSoggetti().sizeSoggettoList();
        }
        if (paAssociata.getRuoli() != null) {
            sizeRuoli = paAssociata.getRuoli().sizeRuoloList();
        }
        if (StringUtils.isNotEmpty((CharSequence)(autorizzazioneContenuti = paAssociata.getAutorizzazioneContenuto())) && !"builtIn".equals(autorizzazioneContenuti)) {
            Plugin plugin = null;
            try {
                plugin = this.confCore.getPlugin(TipoPlugin.AUTORIZZAZIONE_CONTENUTI, autorizzazioneContenuti, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (plugin != null && plugin.getLabel() != null) {
                autorizzazioneContenuti = plugin.getLabel();
            }
        }
        List aa = paAssociata.getAttributeAuthorityList();
        ArrayList<String> attributeAuthority = new ArrayList<String>();
        if (aa != null && !aa.isEmpty()) {
            for (AttributeAuthority a : aa) {
                attributeAuthority.add(a.getNome());
            }
        }
        if (de != null) {
            this.setStatoControlloAccessi(de, false, gestioneToken, gestioneTokenOpzionale, gestioneTokenPolicy, gestioneTokenConfig, autenticazione, autenticazioneOpzionale, autenticazioneCustom, autorizzazione, autorizzazioneCustom, sizeApplicativi, sizeSoggetti, sizeRuoli, autorizzazioneTokenPortaDelegata, autorizzazioneTokenPortaApplicativa, autorizzazioneScope, autorizzazioneContenuti, protocollo, attributeAuthority);
            return null;
        }
        return this.getLabelStatoControlloAccessi(false, gestioneToken, gestioneTokenOpzionale, gestioneTokenPolicy, gestioneTokenConfig, autenticazione, autenticazioneOpzionale, autenticazioneCustom, autorizzazione, autorizzazioneCustom, sizeApplicativi, sizeSoggetti, sizeRuoli, autorizzazioneTokenPortaDelegata, autorizzazioneTokenPortaApplicativa, autorizzazioneScope, autorizzazioneContenuti, attributeAuthority);
    }

    public String getStatoGestioneTokenPortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        String gestioneToken = null;
        if (paAssociata.getGestioneToken() != null && paAssociata.getGestioneToken().getPolicy() != null && !"".equals(paAssociata.getGestioneToken().getPolicy()) && !"-".equals(paAssociata.getGestioneToken().getPolicy())) {
            gestioneToken = StatoFunzionalita.ABILITATO.getValue();
        }
        return this.getLabelStatoGestioneToken(gestioneToken);
    }

    public String getStatoAutenticazionePortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        String autenticazione = paAssociata.getAutenticazione();
        String autenticazioneCustom = null;
        if (autenticazione != null && !TipoAutenticazione.getValues().contains(autenticazione)) {
            autenticazioneCustom = autenticazione;
            autenticazione = "custom";
        }
        String autenticazioneOpzionale = "";
        if (paAssociata.getAutenticazioneOpzionale() != null && paAssociata.getAutenticazioneOpzionale().equals((Object)StatoFunzionalita.ABILITATO)) {
            autenticazioneOpzionale = "yes";
        }
        return this.getLabelStatoAutenticazione(autenticazione, autenticazioneOpzionale, autenticazioneCustom);
    }

    public String getStatoAutorizzazionePortaApplicativa(PortaApplicativa paAssociata) throws DriverConfigurazioneException {
        if (paAssociata == null) {
            throw new DriverConfigurazioneException("Param paAssociata is null");
        }
        String autorizzazioneContenuti = paAssociata.getAutorizzazioneContenuto();
        String autorizzazione = null;
        String autorizzazioneCustom = null;
        if (paAssociata.getAutorizzazione() != null && !TipoAutorizzazione.getAllValues().contains(paAssociata.getAutorizzazione())) {
            autorizzazioneCustom = paAssociata.getAutorizzazione();
            autorizzazione = "custom";
        } else {
            autorizzazione = AutorizzazioneUtilities.convertToStato(paAssociata.getAutorizzazione());
        }
        return this.getLabelStatoAutorizzazione(autorizzazione, autorizzazioneContenuti, autorizzazioneCustom);
    }

    public String getStatoDumpPortaDelegata(PortaDelegata pdAssociata, boolean usePrefixDefault) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (pdAssociata == null) {
            throw new DriverConfigurazioneException("Param pdAssociata is null");
        }
        DumpConfigurazione dumpConfigurazione = pdAssociata.getDump();
        String statoDump = dumpConfigurazione == null ? this.getDumpLabelDefault(usePrefixDefault, false) : (this.isDumpConfigurazioneAbilitato(dumpConfigurazione) ? "abilitato" : "disabilitato");
        return statoDump;
    }

    public String getStatoTracciamentoPortaDelegata(PortaDelegata pdAssociata) throws DriverConfigurazioneException {
        if (pdAssociata == null) {
            throw new DriverConfigurazioneException("Param pdAssociata is null");
        }
        String statoTracciamento = "disabilitato";
        boolean tracciamento = false;
        boolean isCorrelazioneApplicativaAbilitataReq = false;
        boolean isCorrelazioneApplicativaAbilitataRes = false;
        if (pdAssociata.getCorrelazioneApplicativa() != null) {
            boolean bl = isCorrelazioneApplicativaAbilitataReq = pdAssociata.getCorrelazioneApplicativa().sizeElementoList() > 0;
        }
        if (pdAssociata.getCorrelazioneApplicativaRisposta() != null) {
            boolean bl = isCorrelazioneApplicativaAbilitataRes = pdAssociata.getCorrelazioneApplicativaRisposta().sizeElementoList() > 0;
        }
        if (pdAssociata.getTracciamento() != null && (pdAssociata.getTracciamento().getEsiti() != null && !("" + EsitiConfigUtils.TUTTI_ESITI_DISABILITATI).equals(pdAssociata.getTracciamento().getEsiti()) || pdAssociata.getTracciamento().getSeverita() != null)) {
            tracciamento = true;
        }
        statoTracciamento = tracciamento || isCorrelazioneApplicativaAbilitataReq || isCorrelazioneApplicativaAbilitataRes ? "abilitato" : "disabilitato";
        return statoTracciamento;
    }

    public String getStatoMTOMPortaDelegata(PortaDelegata pdAssociata) throws DriverConfigurazioneException {
        if (pdAssociata == null) {
            throw new DriverConfigurazioneException("Param pdAssociata is null");
        }
        String statoMTOM = "disabilitato";
        boolean isMTOMAbilitatoReq = false;
        boolean isMTOMAbilitatoRes = false;
        if (pdAssociata.getMtomProcessor() != null) {
            MTOMProcessorType mode;
            if (pdAssociata.getMtomProcessor().getRequestFlow() != null && pdAssociata.getMtomProcessor().getRequestFlow().getMode() != null && !(mode = pdAssociata.getMtomProcessor().getRequestFlow().getMode()).equals((Object)MTOMProcessorType.DISABLE)) {
                isMTOMAbilitatoReq = true;
            }
            if (pdAssociata.getMtomProcessor().getResponseFlow() != null && pdAssociata.getMtomProcessor().getResponseFlow().getMode() != null && !(mode = pdAssociata.getMtomProcessor().getResponseFlow().getMode()).equals((Object)MTOMProcessorType.DISABLE)) {
                isMTOMAbilitatoRes = true;
            }
        }
        statoMTOM = isMTOMAbilitatoReq || isMTOMAbilitatoRes ? "abilitato" : "disabilitato";
        return statoMTOM;
    }

    public String getStatoMessageSecurityPortaDelegata(PortaDelegata pdAssociata) throws DriverConfigurazioneException {
        if (pdAssociata == null) {
            throw new DriverConfigurazioneException("Param pdAssociata is null");
        }
        String statoMessageSecurity = pdAssociata.getStatoMessageSecurity();
        return statoMessageSecurity;
    }

    public String getStatoValidazionePortaDelegata(PortaDelegata pdAssociata) throws DriverConfigurazioneException {
        if (pdAssociata == null) {
            throw new DriverConfigurazioneException("Param pdAssociata is null");
        }
        String statoValidazione = null;
        ValidazioneContenutiApplicativi vx = pdAssociata.getValidazioneContenutiApplicativi();
        if (vx == null) {
            statoValidazione = PorteDelegateCostanti.DEFAULT_VALUE_PARAMETRO_PORTE_DELEGATE_VALIDAZIONE_DISABILITATO;
        } else {
            if (vx.getStato() != null) {
                statoValidazione = vx.getStato().toString();
            }
            if (statoValidazione == null || "".equals(statoValidazione)) {
                statoValidazione = PorteDelegateCostanti.DEFAULT_VALUE_PARAMETRO_PORTE_DELEGATE_VALIDAZIONE_DISABILITATO;
            }
        }
        return statoValidazione;
    }

    public String getStatoResponseCachingPortaDelegata(PortaDelegata pdAssociata, boolean usePrefixDefault) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (pdAssociata == null) {
            throw new DriverConfigurazioneException("Param pdAssociata is null");
        }
        String stato = null;
        ResponseCachingConfigurazione rc = pdAssociata.getResponseCaching();
        stato = rc == null ? this.getResponseCachingLabelDefault(usePrefixDefault) : (rc.getStato() != null ? rc.getStato().getValue() : PorteDelegateCostanti.DEFAULT_VALUE_PARAMETRO_PORTE_DELEGATE_VALIDAZIONE_DISABILITATO);
        return stato;
    }

    public String getStatoGestioneCorsPortaDelegata(PortaDelegata pdAssociata, boolean usePrefixDefault) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        if (pdAssociata == null) {
            throw new DriverConfigurazioneException("Param pdAssociata is null");
        }
        String stato = null;
        CorsConfigurazione cc = pdAssociata.getGestioneCors();
        stato = cc == null ? this.getGestioneCorsLabelDefault(usePrefixDefault) : (cc.getStato() == null || StatoFunzionalita.DISABILITATO.equals((Object)cc.getStato()) ? StatoFunzionalita.DISABILITATO.getValue() : this.getLabelTipoGestioneCors(cc.getTipo()));
        return stato;
    }

    public String getStatoControlloAccessiPortaDelegata(String protocollo, PortaDelegata pdAssociata) throws DriverControlStationException, DriverControlStationNotFound {
        return this._getStatoControlloAccessiPortaDelegata(protocollo, pdAssociata, null);
    }

    public void setStatoControlloAccessiPortaDelegata(String protocollo, PortaDelegata pdAssociata, DataElement de) throws DriverControlStationException, DriverControlStationNotFound {
        this._getStatoControlloAccessiPortaDelegata(protocollo, pdAssociata, de);
    }

    private String _getStatoControlloAccessiPortaDelegata(String protocollo, PortaDelegata pdAssociata, DataElement de) throws DriverControlStationException, DriverControlStationNotFound {
        String autorizzazioneContenuti;
        if (pdAssociata == null) {
            throw new DriverControlStationException("Param pdAssociata is null");
        }
        String gestioneToken = null;
        String gestioneTokenPolicy = null;
        String gestioneTokenOpzionale = "";
        GestioneToken gestioneTokenConfig = null;
        AutorizzazioneScope autorizzazioneScope = null;
        PortaDelegataAutorizzazioneToken autorizzazioneTokenPortaDelegata = null;
        PortaApplicativaAutorizzazioneToken autorizzazioneTokenPortaApplicativa = null;
        if (pdAssociata.getGestioneToken() != null && pdAssociata.getGestioneToken().getPolicy() != null && !"".equals(pdAssociata.getGestioneToken().getPolicy()) && !"-".equals(pdAssociata.getGestioneToken().getPolicy())) {
            gestioneToken = StatoFunzionalita.ABILITATO.getValue();
            gestioneTokenPolicy = pdAssociata.getGestioneToken().getPolicy();
            if (pdAssociata.getGestioneToken() != null && pdAssociata.getGestioneToken().getTokenOpzionale() != null && pdAssociata.getGestioneToken().getTokenOpzionale().equals((Object)StatoFunzionalita.ABILITATO)) {
                gestioneTokenOpzionale = "yes";
            }
            gestioneTokenConfig = pdAssociata.getGestioneToken();
            autorizzazioneScope = pdAssociata.getScope();
            autorizzazioneTokenPortaDelegata = pdAssociata.getAutorizzazioneToken();
        }
        String autenticazione = pdAssociata.getAutenticazione();
        String autenticazioneCustom = null;
        if (autenticazione != null && !TipoAutenticazione.getValues().contains(autenticazione)) {
            autenticazioneCustom = autenticazione;
            autenticazione = "custom";
            Plugin plugin = null;
            try {
                plugin = this.confCore.getPlugin(TipoPlugin.AUTENTICAZIONE, autenticazioneCustom, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (plugin != null && plugin.getLabel() != null) {
                autenticazioneCustom = plugin.getLabel();
            }
        }
        String autenticazioneOpzionale = "";
        if (pdAssociata.getAutenticazioneOpzionale() != null && pdAssociata.getAutenticazioneOpzionale().equals((Object)StatoFunzionalita.ABILITATO)) {
            autenticazioneOpzionale = "yes";
        }
        String autorizzazione = null;
        String autorizzazioneCustom = null;
        int sizeApplicativi = 0;
        int sizeSoggetti = 0;
        int sizeRuoli = 0;
        if (pdAssociata.getAutorizzazione() != null && !TipoAutorizzazione.getAllValues().contains(pdAssociata.getAutorizzazione())) {
            autorizzazioneCustom = pdAssociata.getAutorizzazione();
            autorizzazione = "custom";
            Plugin plugin = null;
            try {
                plugin = this.confCore.getPlugin(TipoPlugin.AUTORIZZAZIONE, autorizzazioneCustom, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (plugin != null && plugin.getLabel() != null) {
                autorizzazioneCustom = plugin.getLabel();
            }
        } else {
            autorizzazione = de != null ? pdAssociata.getAutorizzazione() : AutorizzazioneUtilities.convertToStato(pdAssociata.getAutorizzazione());
        }
        sizeApplicativi = pdAssociata.sizeServizioApplicativoList();
        if (pdAssociata.getRuoli() != null) {
            sizeRuoli = pdAssociata.getRuoli().sizeRuoloList();
        }
        if (StringUtils.isNotEmpty((CharSequence)(autorizzazioneContenuti = pdAssociata.getAutorizzazioneContenuto())) && !"builtIn".equals(autorizzazioneContenuti)) {
            Plugin plugin = null;
            try {
                plugin = this.confCore.getPlugin(TipoPlugin.AUTORIZZAZIONE_CONTENUTI, autorizzazioneContenuti, false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (plugin != null && plugin.getLabel() != null) {
                autorizzazioneContenuti = plugin.getLabel();
            }
        }
        List aa = pdAssociata.getAttributeAuthorityList();
        ArrayList<String> attributeAuthority = new ArrayList<String>();
        if (aa != null && !aa.isEmpty()) {
            for (AttributeAuthority a : aa) {
                attributeAuthority.add(a.getNome());
            }
        }
        if (de != null) {
            this.setStatoControlloAccessi(de, true, gestioneToken, gestioneTokenOpzionale, gestioneTokenPolicy, gestioneTokenConfig, autenticazione, autenticazioneOpzionale, autenticazioneCustom, autorizzazione, autorizzazioneCustom, sizeApplicativi, sizeSoggetti, sizeRuoli, autorizzazioneTokenPortaDelegata, autorizzazioneTokenPortaApplicativa, autorizzazioneScope, autorizzazioneContenuti, protocollo, attributeAuthority);
            return null;
        }
        return this.getLabelStatoControlloAccessi(true, gestioneToken, gestioneTokenOpzionale, gestioneTokenPolicy, gestioneTokenConfig, autenticazione, autenticazioneOpzionale, autenticazioneCustom, autorizzazione, autorizzazioneCustom, sizeApplicativi, sizeSoggetti, sizeRuoli, autorizzazioneTokenPortaDelegata, autorizzazioneTokenPortaApplicativa, autorizzazioneScope, autorizzazioneContenuti, attributeAuthority);
    }

    public String getStatoAutenticazionePortaDelegata(PortaDelegata pdAssociata) throws DriverConfigurazioneException {
        if (pdAssociata == null) {
            throw new DriverConfigurazioneException("Param pdAssociata is null");
        }
        String autenticazione = pdAssociata.getAutenticazione();
        String autenticazioneCustom = null;
        if (autenticazione != null && !TipoAutenticazione.getValues().contains(autenticazione)) {
            autenticazioneCustom = autenticazione;
            autenticazione = "custom";
        }
        String autenticazioneOpzionale = "";
        if (pdAssociata.getAutenticazioneOpzionale() != null && pdAssociata.getAutenticazioneOpzionale().equals((Object)StatoFunzionalita.ABILITATO)) {
            autenticazioneOpzionale = "yes";
        }
        return this.getLabelStatoAutenticazione(autenticazione, autenticazioneOpzionale, autenticazioneCustom);
    }

    public String getStatoAutorizzazionePortaDelegata(PortaDelegata pdAssociata) throws DriverConfigurazioneException {
        if (pdAssociata == null) {
            throw new DriverConfigurazioneException("Param pdAssociata is null");
        }
        String autorizzazioneContenuti = pdAssociata.getAutorizzazioneContenuto();
        String autorizzazione = null;
        String autorizzazioneCustom = null;
        if (pdAssociata.getAutorizzazione() != null && !TipoAutorizzazione.getAllValues().contains(pdAssociata.getAutorizzazione())) {
            autorizzazioneCustom = pdAssociata.getAutorizzazione();
            autorizzazione = "custom";
        } else {
            autorizzazione = AutorizzazioneUtilities.convertToStato(pdAssociata.getAutorizzazione());
        }
        return this.getLabelStatoAutorizzazione(autorizzazione, autorizzazioneContenuti, autorizzazioneCustom);
    }

    public String getStatoGestioneTokenPortaDelegata(PortaDelegata pdAssociata) throws DriverConfigurazioneException {
        if (pdAssociata == null) {
            throw new DriverConfigurazioneException("Param pdAssociata is null");
        }
        String gestioneToken = null;
        if (pdAssociata.getGestioneToken() != null && pdAssociata.getGestioneToken().getPolicy() != null && !"".equals(pdAssociata.getGestioneToken().getPolicy()) && !"-".equals(pdAssociata.getGestioneToken().getPolicy())) {
            gestioneToken = StatoFunzionalita.ABILITATO.getValue();
        }
        return this.getLabelStatoGestioneToken(gestioneToken);
    }

    public String getLabelStatoControlloAccessi(boolean portaDelegata, String gestioneToken, String gestioneTokenOpzionale, String gestioneTokenPolicy, GestioneToken gestioneTokenConfig, String autenticazione, String autenticazioneOpzionale, String autenticazioneCustom, String autorizzazione, String autorizzazioneCustom, int sizeApplicativi, int sizeSoggetti, int sizeRuoli, PortaDelegataAutorizzazioneToken autorizzazioneTokenPortaDelegata, PortaApplicativaAutorizzazioneToken autorizzazioneTokenPortaApplicativa, AutorizzazioneScope autorizzazioneScope, String autorizzazioneContenuti, List<String> attributeAuthority) {
        if (gestioneToken != null && StatoFunzionalita.ABILITATO.getValue().equals(gestioneToken)) {
            return "abilitato";
        }
        if (autenticazione != null && !TipoAutenticazione.DISABILITATO.equals(autenticazione)) {
            return "abilitato";
        }
        if (autenticazioneOpzionale != null && ServletUtils.isCheckBoxEnabled((String)autenticazioneOpzionale)) {
            return "abilitato";
        }
        if (attributeAuthority != null && !attributeAuthority.isEmpty()) {
            return "abilitato";
        }
        if (!AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione)) {
            return "abilitato";
        }
        if (StringUtils.isNotEmpty((CharSequence)autorizzazioneContenuti)) {
            return "abilitato";
        }
        return "disabilitato";
    }

    public void setStatoControlloAccessi(DataElement de, boolean portaDelegata, String gestioneToken, String gestioneTokenOpzionale, String gestioneTokenPolicy, GestioneToken gestioneTokenConfig, String autenticazione, String autenticazioneOpzionale, String autenticazioneCustom, String autorizzazione, String autorizzazioneCustom, int sizeApplicativi, int sizeSoggetti, int sizeRuoli, PortaDelegataAutorizzazioneToken autorizzazioneTokenPortaDelegata, PortaApplicativaAutorizzazioneToken autorizzazioneTokenPortaApplicativa, AutorizzazioneScope autorizzazioneScope, String autorizzazioneContenuti, String protocollo, List<String> attributeAuthority) throws DriverControlStationException, DriverControlStationNotFound {
        StringBuilder bfToolTip;
        StringBuilder bf;
        boolean modipa = this.isProfiloModIPA(protocollo);
        de.setType(DataElementType.MULTI_SELECT);
        if (gestioneToken != null && StatoFunzionalita.ABILITATO.getValue().equals(gestioneToken)) {
            CheckboxStatusType statusGestioneToken = null;
            StringBuilder bf2 = new StringBuilder();
            StringBuilder bfToolTip2 = new StringBuilder();
            bf2.append("Autenticazione Token");
            bfToolTip2.append("Autenticazione Token");
            if (ServletUtils.isCheckBoxEnabled((String)gestioneTokenOpzionale)) {
                bfToolTip2.append(" (").append("Opzionale").append(") ");
                statusGestioneToken = CheckboxStatusType.CONFIG_WARNING;
            } else {
                statusGestioneToken = CheckboxStatusType.CONFIG_ENABLE;
            }
            bfToolTip2.append(": ").append(gestioneTokenPolicy);
            if (gestioneTokenConfig != null && gestioneTokenConfig.getAutenticazione() != null) {
                StringBuilder bfTokenAuth = new StringBuilder();
                if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenConfig.getAutenticazione().getIssuer())) {
                    if (bfTokenAuth.length() > 0) {
                        bfTokenAuth.append(", ");
                    }
                    bfTokenAuth.append("Issuer");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenConfig.getAutenticazione().getClientId())) {
                    if (bfTokenAuth.length() > 0) {
                        bfTokenAuth.append(", ");
                    }
                    bfTokenAuth.append("ClientId");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenConfig.getAutenticazione().getSubject())) {
                    if (bfTokenAuth.length() > 0) {
                        bfTokenAuth.append(", ");
                    }
                    bfTokenAuth.append("Subject");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenConfig.getAutenticazione().getUsername())) {
                    if (bfTokenAuth.length() > 0) {
                        bfTokenAuth.append(", ");
                    }
                    bfTokenAuth.append("Username");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)gestioneTokenConfig.getAutenticazione().getEmail())) {
                    if (bfTokenAuth.length() > 0) {
                        bfTokenAuth.append(", ");
                    }
                    bfTokenAuth.append("eMail");
                }
                if (bfTokenAuth.length() > 0) {
                    bfToolTip2.append("\n");
                }
                bfToolTip2.append("Required Claims");
                bfToolTip2.append(": ").append(bfTokenAuth.toString());
            }
            de.addStatus(bfToolTip2.toString(), bf2.toString(), statusGestioneToken);
        }
        if (autenticazione != null && !TipoAutenticazione.DISABILITATO.equals(autenticazione)) {
            bf = new StringBuilder();
            bfToolTip = new StringBuilder();
            boolean opzionale = false;
            String authTrasporto = autenticazione;
            if ("custom".equals(autenticazione)) {
                authTrasporto = autenticazioneCustom;
            }
            bf.append("Autenticazione");
            bfToolTip.append("Autenticazione");
            if (modipa && !portaDelegata) {
                bf.append(" ").append("Canale");
                bfToolTip.append(" ").append("Canale");
            } else {
                bf.append(" ").append("Trasporto");
                bfToolTip.append(" ").append("Trasporto");
            }
            if (ServletUtils.isCheckBoxEnabled((String)autenticazioneOpzionale)) {
                bfToolTip.append(" (").append("Opzionale").append(") ");
                opzionale = true;
            }
            bfToolTip.append(": ");
            if (TipoAutenticazione.contains((String)authTrasporto)) {
                String labelAuth = TipoAutenticazione.toEnumConstant((String)authTrasporto).getLabel();
                bf.append(" [ ").append(labelAuth).append(" ]");
                bfToolTip.append(labelAuth);
            } else {
                bf.append(" [ ").append("plugin").append(" '").append(authTrasporto).append("'").append(" ]");
                bfToolTip.append(authTrasporto);
            }
            CheckboxStatusType statusAutenticazione = null;
            statusAutenticazione = opzionale ? CheckboxStatusType.CONFIG_WARNING : CheckboxStatusType.CONFIG_ENABLE;
            de.addStatus(bfToolTip.toString(), bf.toString(), statusAutenticazione);
        }
        if (attributeAuthority != null && !attributeAuthority.isEmpty()) {
            bf = new StringBuilder();
            bfToolTip = new StringBuilder();
            bf.append("Attribute Authority");
            bfToolTip.append("Attribute Authority");
            bfToolTip.append(": ").append(attributeAuthority.toString());
            de.addStatus(bfToolTip.toString(), bf.toString(), CheckboxStatusType.CONFIG_ENABLE);
        }
        if (AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione) && modipa && !portaDelegata && sizeApplicativi > 0) {
            autorizzazione = AutorizzazioneUtilities.STATO_ABILITATO;
        }
        if (!AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione)) {
            Object tooltip;
            CheckboxStatusType statusAutorizzazione;
            bf = new StringBuilder();
            bfToolTip = new StringBuilder();
            StringBuilder bfToolTipNotValid = new StringBuilder();
            int rowsToolTip = 0;
            if (TipoAutorizzazione.isSignalHubPush((String)autorizzazione)) {
                String tooltip2 = "Autorizzazione SignalHub";
                de.addStatus(tooltip2, tooltip2, CheckboxStatusType.CONFIG_ENABLE);
            }
            Boolean validPuntuale = null;
            if (TipoAutorizzazione.isAuthenticationRequired((String)autorizzazione)) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                if (bf.length() <= 0) {
                    if (modipa && !portaDelegata) {
                        bf.append("Autorizzazione Canale");
                    } else {
                        bf.append("Autorizzazione Trasporto");
                    }
                    bf.append(" [ ");
                }
                bf.append(" ");
                bf.append("Richiedente");
                validPuntuale = modipa && !portaDelegata ? Boolean.valueOf(sizeSoggetti > 0) : Boolean.valueOf(sizeApplicativi > 0 || sizeSoggetti > 0);
                if (validPuntuale.booleanValue()) {
                    ++rowsToolTip;
                    if (bfToolTip.length() > 0) {
                        bfToolTip.append("\n");
                    }
                    bfToolTip.append("- ").append("Richiedente");
                    if (!portaDelegata) {
                        bfToolTip.append(" ").append("Soggetti").append(" (").append(sizeSoggetti).append(")");
                    }
                    if (!modipa || portaDelegata) {
                        if (!portaDelegata) {
                            bfToolTip.append(",");
                        }
                        bfToolTip.append(" ").append("Applicativi").append(" (").append(sizeApplicativi).append(")");
                    }
                } else {
                    if (bfToolTipNotValid.length() > 0) {
                        bfToolTipNotValid.append("\n");
                    }
                    if (!modipa || portaDelegata) {
                        bfToolTipNotValid.append(ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TRASPORTO_NO_FRUITORI);
                    } else {
                        bfToolTipNotValid.append(ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_CANALE_NO_FRUITORI);
                    }
                }
            }
            Boolean validRuoli = null;
            if (TipoAutorizzazione.isRolesRequired((String)autorizzazione)) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                if (bf.length() <= 0) {
                    if (modipa && !portaDelegata) {
                        bf.append("Autorizzazione Canale");
                    } else {
                        bf.append("Autorizzazione Trasporto");
                    }
                    bf.append(" [ ");
                }
                bf.append(" ");
                bf.append("Ruoli");
                validRuoli = sizeRuoli > 0;
                if (validRuoli.booleanValue()) {
                    ++rowsToolTip;
                    if (bfToolTip.length() > 0) {
                        bfToolTip.append("\n");
                    }
                    bfToolTip.append("- ").append("Ruoli");
                    bfToolTip.append(" (").append(sizeRuoli).append(")");
                } else {
                    if (bfToolTipNotValid.length() > 0) {
                        bfToolTipNotValid.append("\n");
                    }
                    if (!modipa || portaDelegata) {
                        bfToolTipNotValid.append(ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TRASPORTO_NO_RUOLI);
                    } else {
                        bfToolTipNotValid.append(ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_CANALE_NO_RUOLI);
                    }
                }
            }
            if (bf.length() > 0) {
                bf.append(" ]");
                CheckboxStatusType statusAutorizzazione2 = null;
                Object tooltip3 = null;
                if (bfToolTipNotValid.length() > 0) {
                    statusAutorizzazione2 = CheckboxStatusType.CONFIG_ERROR;
                    tooltip3 = bfToolTipNotValid.toString();
                } else {
                    if (bfToolTip.length() > 0) {
                        tooltip3 = modipa && !portaDelegata ? "Autorizzazione Canale" : "Autorizzazione Trasporto";
                        if (rowsToolTip > 0) {
                            tooltip3 = (String)tooltip3 + "\n";
                        }
                        tooltip3 = (String)tooltip3 + bfToolTip.toString();
                    }
                    statusAutorizzazione2 = CheckboxStatusType.CONFIG_ENABLE;
                }
                de.addStatus((String)tooltip3, bf.toString(), statusAutorizzazione2);
            }
            bf = new StringBuilder();
            bfToolTip = new StringBuilder();
            bfToolTipNotValid = new StringBuilder();
            rowsToolTip = 0;
            validPuntuale = null;
            boolean richiedenteToken = false;
            if (modipa && !portaDelegata) {
                richiedenteToken = autorizzazioneTokenPortaApplicativa != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneTokenPortaApplicativa.getAutorizzazioneApplicativi());
            } else if (gestioneToken != null && StatoFunzionalita.ABILITATO.getValue().equals(gestioneToken)) {
                boolean bl = portaDelegata ? autorizzazioneTokenPortaDelegata != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneTokenPortaDelegata.getAutorizzazioneApplicativi()) : (richiedenteToken = autorizzazioneTokenPortaApplicativa != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneTokenPortaApplicativa.getAutorizzazioneApplicativi()));
            }
            if (!richiedenteToken && modipa && !portaDelegata && sizeApplicativi > 0) {
                richiedenteToken = true;
            }
            if (richiedenteToken) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                if (bf.length() <= 0) {
                    if (modipa && !portaDelegata) {
                        bf.append("Autorizzazione Messaggio");
                    } else {
                        bf.append("Autorizzazione Token");
                    }
                    bf.append(" [ ");
                }
                bf.append(" ");
                bf.append("Richiedente");
                validPuntuale = modipa && !portaDelegata ? Boolean.valueOf(sizeApplicativi > 0) : (portaDelegata ? Boolean.valueOf(autorizzazioneTokenPortaDelegata.getServiziApplicativi() != null && autorizzazioneTokenPortaDelegata.getServiziApplicativi().sizeServizioApplicativoList() > 0) : Boolean.valueOf(autorizzazioneTokenPortaApplicativa.getServiziApplicativi() != null && autorizzazioneTokenPortaApplicativa.getServiziApplicativi().sizeServizioApplicativoList() > 0));
                if (validPuntuale.booleanValue()) {
                    ++rowsToolTip;
                    if (bfToolTip.length() > 0) {
                        bfToolTip.append("\n");
                    }
                    bfToolTip.append("- ").append("Richiedente");
                    int size = 0;
                    size = modipa && !portaDelegata ? sizeApplicativi : (portaDelegata ? autorizzazioneTokenPortaDelegata.getServiziApplicativi().sizeServizioApplicativoList() : autorizzazioneTokenPortaApplicativa.getServiziApplicativi().sizeServizioApplicativoList());
                    bfToolTip.append(" ").append("Applicativi").append(" (").append(size).append(")");
                } else {
                    if (bfToolTipNotValid.length() > 0) {
                        bfToolTipNotValid.append("\n");
                    }
                    if (!modipa || portaDelegata) {
                        bfToolTipNotValid.append(ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TOKEN_NO_FRUITORI);
                    } else {
                        bfToolTipNotValid.append(ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_MESSAGGIO_NO_FRUITORI);
                    }
                }
            }
            validRuoli = null;
            boolean ruoliToken = false;
            if (modipa && !portaDelegata) {
                ruoliToken = autorizzazioneTokenPortaApplicativa != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneTokenPortaApplicativa.getAutorizzazioneRuoli());
            } else if (gestioneToken != null && StatoFunzionalita.ABILITATO.getValue().equals(gestioneToken)) {
                boolean bl = portaDelegata ? autorizzazioneTokenPortaDelegata != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneTokenPortaDelegata.getAutorizzazioneRuoli()) : (ruoliToken = autorizzazioneTokenPortaApplicativa != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneTokenPortaApplicativa.getAutorizzazioneRuoli()));
            }
            if (ruoliToken) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                if (bf.length() <= 0) {
                    if (modipa && !portaDelegata) {
                        bf.append("Autorizzazione Messaggio");
                    } else {
                        bf.append("Autorizzazione Token");
                    }
                    bf.append(" [ ");
                }
                bf.append(" ");
                bf.append("Ruoli");
                validRuoli = portaDelegata ? Boolean.valueOf(autorizzazioneTokenPortaDelegata.getRuoli() != null && autorizzazioneTokenPortaDelegata.getRuoli().sizeRuoloList() > 0) : Boolean.valueOf(autorizzazioneTokenPortaApplicativa.getRuoli() != null && autorizzazioneTokenPortaApplicativa.getRuoli().sizeRuoloList() > 0);
                if (validRuoli.booleanValue()) {
                    ++rowsToolTip;
                    if (bfToolTip.length() > 0) {
                        bfToolTip.append("\n");
                    }
                    bfToolTip.append("- ").append("Ruoli");
                    int size = 0;
                    size = portaDelegata ? autorizzazioneTokenPortaDelegata.getRuoli().sizeRuoloList() : autorizzazioneTokenPortaApplicativa.getRuoli().sizeRuoloList();
                    bfToolTip.append(" (").append(size).append(")");
                } else {
                    if (bfToolTipNotValid.length() > 0) {
                        bfToolTipNotValid.append("\n");
                    }
                    if (!modipa || portaDelegata) {
                        bfToolTipNotValid.append(ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_TOKEN_NO_RUOLI);
                    } else {
                        bfToolTipNotValid.append(ErogazioniCostanti.ASPS_EROGAZIONI_ICONA_STATO_CONFIGURAZIONI_CONTROLLO_ACCESSO_AUTORIZZAZIONE_MESSAGGIO_NO_RUOLI);
                    }
                }
            }
            Boolean validScopes = null;
            if (gestioneToken != null && StatoFunzionalita.ABILITATO.getValue().equals(gestioneToken)) {
                if (autorizzazioneScope != null && StatoFunzionalita.ABILITATO.equals((Object)autorizzazioneScope.getStato())) {
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    if (bf.length() <= 0) {
                        if (modipa && !portaDelegata) {
                            bf.append("Autorizzazione Messaggio");
                        } else {
                            bf.append("Autorizzazione Token");
                        }
                        bf.append(" [ ");
                    }
                    bf.append(" ");
                    bf.append("Scope");
                    validScopes = autorizzazioneScope.sizeScopeList() > 0;
                    if (validScopes.booleanValue()) {
                        ++rowsToolTip;
                        if (bfToolTip.length() > 0) {
                            bfToolTip.append("\n");
                        }
                        bfToolTip.append("- ").append("Scope");
                        bfToolTip.append(" (").append(autorizzazioneScope.sizeScopeList()).append(")");
                    } else {
                        if (bfToolTipNotValid.length() > 0) {
                            bfToolTipNotValid.append("\n");
                        }
                        bfToolTipNotValid.append("Rilevato 'Controllo degli Accessi', con autorizzazione token per scope, senza alcun scope registrato");
                    }
                }
                if (gestioneTokenConfig != null && gestioneTokenConfig.getOptions() != null && !"".equals(gestioneTokenConfig.getOptions())) {
                    if (bf.length() > 0) {
                        bf.append(",");
                    }
                    if (bf.length() <= 0) {
                        if (modipa && !portaDelegata) {
                            bf.append("Autorizzazione Canale");
                        } else {
                            bf.append("Autorizzazione Token");
                        }
                        bf.append(" [ ");
                    }
                    bf.append(" ");
                    bf.append("Token Claims");
                    ++rowsToolTip;
                    if (bfToolTip.length() > 0) {
                        bfToolTip.append("\n");
                    }
                    String[] tmp = gestioneTokenConfig.getOptions().split("\n");
                    bfToolTip.append("- ").append("Token Claims");
                    bfToolTip.append(" (").append(tmp != null ? tmp.length : 0).append(")");
                }
            }
            if (bf.length() > 0) {
                bf.append(" ]");
                statusAutorizzazione = null;
                tooltip = null;
                if (bfToolTipNotValid.length() > 0) {
                    statusAutorizzazione = CheckboxStatusType.CONFIG_ERROR;
                    tooltip = bfToolTipNotValid.toString();
                } else {
                    if (bfToolTip.length() > 0) {
                        tooltip = modipa && !portaDelegata ? "Autorizzazione Messaggio" : "Autorizzazione Token";
                        if (rowsToolTip > 0) {
                            tooltip = (String)tooltip + "\n";
                        }
                        tooltip = (String)tooltip + bfToolTip.toString();
                    }
                    statusAutorizzazione = CheckboxStatusType.CONFIG_ENABLE;
                }
                de.addStatus((String)tooltip, bf.toString(), statusAutorizzazione);
            }
            bf = new StringBuilder();
            bfToolTip = new StringBuilder();
            bfToolTipNotValid = new StringBuilder();
            rowsToolTip = 0;
            if (TipoAutorizzazione.isXacmlPolicyRequired((String)autorizzazione)) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                if (bf.length() <= 0) {
                    if (modipa && !portaDelegata) {
                        bf.append("Autorizzazione Canale");
                    } else {
                        bf.append("Autorizzazione");
                    }
                    bf.append(" [ ");
                }
                bf.append(" ");
                bf.append("XACML Policy");
            }
            if ("custom".equals(autorizzazione)) {
                if (bf.length() > 0) {
                    bf.append(",");
                }
                if (bf.length() <= 0) {
                    if (modipa && !portaDelegata) {
                        bf.append("Autorizzazione Canale");
                    } else {
                        bf.append("Autorizzazione");
                    }
                    bf.append(" [ ");
                }
                bf.append(" ");
                bf.append("plugin").append(" '").append(autorizzazioneCustom).append("'");
                bfToolTip.append(": ").append(autorizzazioneCustom);
            }
            if (bf.length() > 0) {
                bf.append(" ]");
                statusAutorizzazione = null;
                tooltip = null;
                if (bfToolTipNotValid.length() > 0) {
                    statusAutorizzazione = CheckboxStatusType.CONFIG_ERROR;
                    tooltip = bfToolTipNotValid.toString();
                } else {
                    if (bfToolTip.length() > 0) {
                        tooltip = modipa && !portaDelegata ? "Autorizzazione Canale" : "Autorizzazione";
                        if (rowsToolTip > 0) {
                            tooltip = (String)tooltip + "\n";
                        }
                        tooltip = (String)tooltip + bfToolTip.toString();
                    }
                    statusAutorizzazione = CheckboxStatusType.CONFIG_ENABLE;
                }
                de.addStatus((String)tooltip, bf.toString(), statusAutorizzazione);
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)autorizzazioneContenuti)) {
            bf = new StringBuilder();
            bfToolTip = new StringBuilder();
            bf.append("Autorizzazione Contenuti");
            bfToolTip.append("Autorizzazione Contenuti");
            if (!"builtIn".equals(autorizzazioneContenuti)) {
                bf.append(" [ ").append("plugin").append(" '").append(autorizzazioneContenuti).append("'").append(" ]");
                bfToolTip.append(": ").append(autorizzazioneContenuti);
            }
            de.addStatus(bfToolTip.toString(), bf.toString(), CheckboxStatusType.CONFIG_ENABLE);
        }
        if (de.getStatusValuesAsList() == null || de.getStatusValuesAsList().size() <= 0) {
            de.addStatus(this.getUpperFirstChar("disabilitato"), CheckboxStatusType.CONFIG_DISABLE);
        }
    }

    public void setStatoRateLimiting(DataElement de, List<AttivazionePolicy> listaPolicy) throws DriverControlStationException, DriverControlStationNotFound {
        this.setStatoRateLimiting(de, listaPolicy, true);
    }

    public void setStatoRateLimiting(DataElement de, List<AttivazionePolicy> listaPolicy, boolean upperFirstChar) throws DriverControlStationException, DriverControlStationNotFound {
        de.setType(DataElementType.CHECKBOX);
        if (listaPolicy != null && listaPolicy.size() > 0) {
            HashMap<Object, Integer> mapActive = new HashMap<Object, Integer>();
            HashMap<Object, Integer> mapWarningOnly = new HashMap<Object, Integer>();
            for (AttivazionePolicy attivazionePolicy : listaPolicy) {
                if (!attivazionePolicy.getEnabled()) continue;
                ConfigurazionePolicy policy = this.confCore.getConfigurazionePolicy(attivazionePolicy.getIdPolicy());
                Object risorsa = policy.getRisorsa();
                boolean richiesteSimultanee = policy.isSimultanee();
                if (richiesteSimultanee) {
                    risorsa = (String)risorsa + "Simultanee";
                }
                Integer count = null;
                count = attivazionePolicy.isWarningOnly() ? (mapWarningOnly.containsKey(risorsa) ? (Integer)mapWarningOnly.remove(risorsa) : Integer.valueOf(0)) : (mapActive.containsKey(risorsa) ? (Integer)mapActive.remove(risorsa) : Integer.valueOf(0));
                Integer n = count;
                count = count + 1;
                if (attivazionePolicy.isWarningOnly()) {
                    mapWarningOnly.put(risorsa, count);
                    continue;
                }
                mapActive.put(risorsa, count);
            }
            if (mapActive.size() > 0 && mapWarningOnly.size() > 0) {
                de.setType(DataElementType.MULTI_SELECT);
            }
            if (mapActive.size() > 0 || mapWarningOnly.size() > 0) {
                Object value;
                Integer count;
                StringBuilder bf;
                if (mapActive.size() > 0) {
                    String string;
                    bf = new StringBuilder();
                    for (String risorsa : mapActive.keySet()) {
                        count = (Integer)mapActive.get(risorsa);
                        if (bf.length() > 0) {
                            bf.append(", ");
                        }
                        bf.append(risorsa);
                        if (count <= 1) continue;
                        bf.append("(").append(count).append(")");
                    }
                    String string2 = string = upperFirstChar ? this.getUpperFirstChar("abilitato") : "abilitato";
                    if (bf.length() > 0 && bf.length() < 80) {
                        value = string + " [ " + bf.toString() + " ]";
                        de.addStatus((String)value, CheckboxStatusType.CONFIG_ENABLE);
                    } else {
                        value = string;
                        de.addStatus(bf.toString(), (String)value, CheckboxStatusType.CONFIG_ENABLE);
                    }
                }
                if (mapWarningOnly.size() > 0) {
                    String string;
                    bf = new StringBuilder();
                    for (String risorsa : mapWarningOnly.keySet()) {
                        count = (Integer)mapWarningOnly.get(risorsa);
                        if (bf.length() > 0) {
                            bf.append(", ");
                        }
                        bf.append(risorsa);
                        if (count <= 1) continue;
                        bf.append("(").append(count).append(")");
                    }
                    String string3 = string = upperFirstChar ? this.getUpperFirstChar("warningOnly") : "warningOnly";
                    if (bf.length() > 0 && bf.length() < 80) {
                        value = string + " [ " + bf.toString() + " ]";
                        de.addStatus((String)value, CheckboxStatusType.CONFIG_WARNING);
                    } else {
                        value = string;
                        de.addStatus(bf.toString(), (String)value, CheckboxStatusType.CONFIG_WARNING);
                    }
                }
            } else {
                de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
                String vDisable = upperFirstChar ? this.getUpperFirstChar("disabilitato") : "disabilitato";
                de.setStatusValue(vDisable);
                de.setStatusToolTip("Sull'API sono registrate " + listaPolicy.size() + " politiche di Rate Limiting tutte con stato disabilitato");
            }
        } else {
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            String vDisable = upperFirstChar ? this.getUpperFirstChar("disabilitato") : "disabilitato";
            de.setStatusValue(vDisable);
        }
    }

    public void setStatoValidazioneContenuti(DataElement de, ValidazioneContenutiApplicativi val, FormatoSpecifica formatoSpecifica) throws DriverControlStationException, DriverControlStationNotFound {
        de.setType(DataElementType.CHECKBOX);
        if (val != null && !StatoFunzionalitaConWarning.DISABILITATO.equals((Object)val.getStato())) {
            String valore = null;
            if (StatoFunzionalitaConWarning.ABILITATO.equals((Object)val.getStato())) {
                de.setStatusType(CheckboxStatusType.CONFIG_ENABLE);
                valore = "abilitato";
            } else {
                de.setStatusType(CheckboxStatusType.CONFIG_WARNING);
                valore = "warningOnly";
            }
            String label = null;
            switch (val.getTipo()) {
                case INTERFACE: {
                    switch (formatoSpecifica) {
                        case OPEN_API_3: {
                            label = "Open API 3";
                            break;
                        }
                        case SWAGGER_2: {
                            label = "Swagger 2";
                            break;
                        }
                        case WSDL_11: {
                            label = "Wsdl 1.1";
                        }
                    }
                    break;
                }
                case XSD: {
                    label = "Schemi XSD";
                    break;
                }
                case OPENSPCOOP: {
                    label = "Registro API";
                }
            }
            de.setStatusValue(this.getUpperFirstChar(valore) + " [ " + label + " ]");
        } else {
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            de.setStatusValue(this.getUpperFirstChar("disabilitato"));
        }
    }

    public void setStatoGestioneCORS(DataElement de, CorsConfigurazione ccPorta, Configurazione configurazioneGenerale) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        de.setType(DataElementType.CHECKBOX);
        CheckboxStatusType statusType = null;
        Object statusValue = null;
        String statusTooltip = null;
        if (ccPorta == null) {
            CorsConfigurazione cc = configurazioneGenerale.getGestioneCors();
            if (cc == null || cc.getStato() == null || StatoFunzionalita.DISABILITATO.equals((Object)cc.getStato())) {
                statusType = CheckboxStatusType.CONFIG_DISABLE;
                statusValue = this.getUpperFirstChar("disabilitato");
            } else {
                statusType = CheckboxStatusType.CONFIG_ENABLE;
                statusValue = TipoGestioneCORS.GATEWAY.equals((Object)cc.getTipo()) ? this.getUpperFirstChar("abilitato") : this.getUpperFirstChar("abilitato") + " [ Gestione demandata all'implementazione dell'API ]";
            }
            statusTooltip = "Configurazione di default del Gateway";
        } else {
            if (ccPorta.getStato() == null || StatoFunzionalita.DISABILITATO.equals((Object)ccPorta.getStato())) {
                statusType = CheckboxStatusType.CONFIG_DISABLE;
                statusValue = this.getUpperFirstChar("disabilitato");
            } else {
                statusType = CheckboxStatusType.CONFIG_ENABLE;
                statusValue = TipoGestioneCORS.GATEWAY.equals((Object)ccPorta.getTipo()) ? this.getUpperFirstChar("abilitato") : this.getUpperFirstChar("abilitato") + " [ Gestione demandata all'implementazione dell'API ]";
            }
            statusTooltip = "Configurazione ridefinita per l'API";
        }
        de.setStatusType(statusType);
        de.setStatusValue((String)statusValue);
        de.setStatusToolTip(statusTooltip);
    }

    public CanaleConfigurazione getCanaleDefault(List<CanaleConfigurazione> canaleList) throws DriverConfigurazioneNotFound {
        CanaleConfigurazione canaleConfigurazioneDefault = null;
        if (canaleList != null && !canaleList.isEmpty()) {
            for (CanaleConfigurazione c : canaleList) {
                if (!c.isCanaleDefault()) continue;
                canaleConfigurazioneDefault = c;
                break;
            }
        }
        if (canaleConfigurazioneDefault == null) {
            throw new DriverConfigurazioneNotFound("Canale di default non trovato nella lista fornita '" + String.valueOf(canaleList) + "'");
        }
        return canaleConfigurazioneDefault;
    }

    public void setStatoCanale(DataElement de, String canaleNome, List<CanaleConfigurazione> canaleList) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        String canaleTooltip;
        de.setType(DataElementType.TEXT);
        if (canaleNome == null) {
            CanaleConfigurazione canaleConfigurazioneDefault = this.getCanaleDefault(canaleList);
            canaleNome = canaleConfigurazioneDefault.getNome();
            canaleTooltip = "Configurazione di default del Gateway";
        } else {
            canaleTooltip = "Configurazione ridefinita per l'API";
        }
        de.setValue(canaleNome);
        de.setToolTip(canaleTooltip);
    }

    public void setStatoCanalePorta(DataElement de, String canaleNome, String canaleAPINome, List<CanaleConfigurazione> canaleList, boolean erogazione) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        String canaleTooltip;
        de.setType(DataElementType.TEXT);
        if (canaleNome == null) {
            if (canaleAPINome == null) {
                CanaleConfigurazione canaleConfigurazioneDefault = this.getCanaleDefault(canaleList);
                canaleNome = canaleConfigurazioneDefault.getNome();
                canaleTooltip = "Configurazione di default del Gateway";
            } else {
                canaleNome = canaleAPINome;
                canaleTooltip = "Configurazione di default dell'API";
            }
        } else {
            canaleTooltip = erogazione ? "Configurazione ridefinita per l'erogazione" : "Configurazione ridefinita per la fruizione";
        }
        de.setValue(canaleNome);
        de.setToolTip(canaleTooltip);
    }

    public void setStatoAllarmi(DataElement de, List<ConfigurazioneAllarmeBean> listaAllarmi) throws DriverControlStationException, DriverControlStationNotFound, UtilsException {
        if (this.confCore.isShowAllarmiElenchiStatiAllarmi().booleanValue()) {
            this.setStatoAllarmi_showStati(de, listaAllarmi);
        } else {
            this.setStatoAllarmi_showTipi(de, listaAllarmi);
        }
    }

    public void setStatoAllarmi_showStati(DataElement de, List<ConfigurazioneAllarmeBean> listaAllarmi) throws DriverControlStationException, DriverControlStationNotFound {
        de.setType(DataElementType.CHECKBOX);
        if (listaAllarmi != null && listaAllarmi.size() > 0) {
            Integer countOk = 0;
            Integer countError = 0;
            Integer countWarn = 0;
            for (ConfigurazioneAllarmeBean allarme : listaAllarmi) {
                if (allarme.getEnabled() == 0) continue;
                StatoAllarme statoAllarme = AllarmiConverterUtils.toStatoAllarme((Integer)allarme.getStato());
                switch (statoAllarme) {
                    case OK: {
                        Integer n = countOk;
                        countOk = countOk + 1;
                        break;
                    }
                    case WARNING: {
                        Integer n = countWarn;
                        countWarn = countWarn + 1;
                        break;
                    }
                    case ERROR: {
                        Integer n = countError;
                        countError = countError + 1;
                    }
                }
            }
            int multi = 0;
            if (countOk > 0) {
                ++multi;
            }
            if (countError > 0) {
                ++multi;
            }
            if (countWarn > 0) {
                ++multi;
            }
            if (multi > 1) {
                de.setType(DataElementType.MULTI_SELECT);
            }
            if (countOk > 0 || countError > 0 || countWarn > 0) {
                StringBuilder bf;
                if (countOk > 0) {
                    bf = new StringBuilder();
                    bf.append("Ok");
                    bf.append(" (").append(countOk).append(")");
                    de.addStatus(bf.toString(), CheckboxStatusType.CONFIG_ENABLE);
                }
                if (countWarn > 0) {
                    bf = new StringBuilder();
                    bf.append("Warning");
                    bf.append(" (").append(countWarn).append(")");
                    de.addStatus(bf.toString(), CheckboxStatusType.CONFIG_WARNING);
                }
                if (countError > 0) {
                    bf = new StringBuilder();
                    bf.append("Error");
                    bf.append(" (").append(countError).append(")");
                    de.addStatus(bf.toString(), CheckboxStatusType.CONFIG_ERROR);
                }
            } else {
                de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
                de.setStatusValue(this.getUpperFirstChar("disabilitato"));
                de.setStatusToolTip("Sull'API sono registrati " + listaAllarmi.size() + " allarmi tutti con stato disabilitato");
            }
        } else {
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            de.setStatusValue(this.getUpperFirstChar("disabilitato"));
        }
    }

    public void setStatoAllarmi_showTipi(DataElement de, List<ConfigurazioneAllarmeBean> listaAllarmi) throws DriverControlStationException, DriverControlStationNotFound {
        de.setType(DataElementType.CHECKBOX);
        if (listaAllarmi != null && listaAllarmi.size() > 0) {
            Integer count;
            HashMap<String, Integer> mapActive = new HashMap<String, Integer>();
            for (ConfigurazioneAllarmeBean configurazioneAllarmeBean : listaAllarmi) {
                if (configurazioneAllarmeBean.getEnabled() == 0) continue;
                String tipoPlugin = configurazioneAllarmeBean.getPlugin().getTipo();
                count = null;
                count = mapActive.containsKey(tipoPlugin) ? (Integer)mapActive.remove(tipoPlugin) : Integer.valueOf(0);
                Integer n = count;
                count = count + 1;
                mapActive.put(tipoPlugin, count);
            }
            if (mapActive.size() > 0) {
                if (mapActive.size() > 0) {
                    StringBuilder bf = new StringBuilder();
                    for (String risorsa : mapActive.keySet()) {
                        count = (Integer)mapActive.get(risorsa);
                        if (bf.length() > 0) {
                            bf.append(", ");
                        }
                        bf.append(risorsa);
                        if (count <= 1) continue;
                        bf.append("(").append(count).append(")");
                    }
                    if (bf.length() > 0 && bf.length() < 80) {
                        String string = this.getUpperFirstChar("abilitato") + " [ " + bf.toString() + " ]";
                        de.addStatus(string, CheckboxStatusType.CONFIG_ENABLE);
                    } else {
                        String string = this.getUpperFirstChar("abilitato");
                        de.addStatus(bf.toString(), string, CheckboxStatusType.CONFIG_ENABLE);
                    }
                }
            } else {
                de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
                de.setStatusValue(this.getUpperFirstChar("disabilitato"));
                de.setStatusToolTip("Sull'API sono registrati " + listaAllarmi.size() + " allarmi tutti con stato disabilitato");
            }
        } else {
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            de.setStatusValue(this.getUpperFirstChar("disabilitato"));
        }
    }

    public void setStatoOpzioniAvanzatePortaDelegataDefault(DataElement de, String options) throws DriverControlStationException {
        this._setStatoOpzioniAvanzatePortaDefault(de, options);
    }

    public void setStatoOpzioniAvanzatePortaApplicativaDefault(DataElement de, String options) throws DriverControlStationException {
        this._setStatoOpzioniAvanzatePortaDefault(de, options);
    }

    private void _setStatoOpzioniAvanzatePortaDefault(DataElement de, String options) throws DriverControlStationException {
        de.setType(DataElementType.CHECKBOX);
        Map props = null;
        try {
            props = PropertiesSerializator.convertoFromDBColumnValue((String)options);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        StringBuilder bf = new StringBuilder();
        StringBuilder bfTooltip = new StringBuilder();
        if (props != null && props.size() > 0) {
            for (String key : props.keySet()) {
                List values = (List)props.get(key);
                if (values == null || values.isEmpty()) continue;
                for (String value : values) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append(key);
                    if (bfTooltip.length() > 0) {
                        bfTooltip.append(", ");
                    }
                    bfTooltip.append(key);
                    bfTooltip.append(" '");
                    bfTooltip.append(value);
                    bfTooltip.append("'");
                }
            }
        }
        if (bf.length() > 0) {
            de.setStatusType(CheckboxStatusType.CONFIG_ENABLE);
            de.setStatusValue(this.getUpperFirstChar("abilitato") + " [ " + bf.toString() + " ]");
            de.setStatusToolTip(bfTooltip.toString());
        } else {
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            de.setStatusValue(this.getUpperFirstChar("disabilitato"));
        }
    }

    public void setStatoCachingRisposta(DataElement de, ResponseCachingConfigurazione rcPorta, Configurazione configurazioneGenerale) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        de.setType(DataElementType.CHECKBOX);
        CheckboxStatusType statusType = null;
        String statusValue = null;
        String statusTooltip = null;
        if (rcPorta == null) {
            ResponseCachingConfigurazioneGenerale rg = configurazioneGenerale.getResponseCaching();
            if (rg == null || rg.getConfigurazione() == null || rg.getConfigurazione().getStato() == null || StatoFunzionalita.DISABILITATO.equals((Object)rg.getConfigurazione().getStato())) {
                statusType = CheckboxStatusType.CONFIG_DISABLE;
                statusValue = this.getUpperFirstChar("disabilitato");
            } else {
                statusType = CheckboxStatusType.CONFIG_ENABLE;
                statusValue = this.getUpperFirstChar("abilitato");
            }
            statusTooltip = "Configurazione di default del Gateway";
        } else {
            if (rcPorta.getStato() == null || StatoFunzionalita.DISABILITATO.equals((Object)rcPorta.getStato())) {
                statusType = CheckboxStatusType.CONFIG_DISABLE;
                statusValue = this.getUpperFirstChar("disabilitato");
            } else {
                statusType = CheckboxStatusType.CONFIG_ENABLE;
                statusValue = this.getUpperFirstChar("abilitato");
            }
            statusTooltip = "Configurazione ridefinita per l'API";
        }
        de.setStatusType(statusType);
        de.setStatusValue(statusValue);
        de.setStatusToolTip(statusTooltip);
    }

    public void setStatoSicurezzaMessaggio(DataElement de, MessageSecurity securityPorta, ConfigManager configManager, PropertiesSourceConfiguration propertiesSourceConfiguration) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        this.setStatoSicurezzaMessaggio(de, securityPorta, configManager, propertiesSourceConfiguration, true);
    }

    public void setStatoSicurezzaMessaggio(DataElement de, MessageSecurity securityPorta, ConfigManager configManager, PropertiesSourceConfiguration propertiesSourceConfiguration, boolean upperFirstChar) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        boolean response;
        boolean request = securityPorta != null && securityPorta.getRequestFlow() != null && securityPorta.getRequestFlow().getMode() != null && !"".equals(securityPorta.getRequestFlow().getMode()) && !"-".equals(securityPorta.getRequestFlow().getMode());
        boolean bl = response = securityPorta != null && securityPorta.getResponseFlow() != null && securityPorta.getResponseFlow().getMode() != null && !"".equals(securityPorta.getResponseFlow().getMode()) && !"-".equals(securityPorta.getResponseFlow().getMode());
        if (securityPorta == null || !request && !response) {
            de.setType(DataElementType.CHECKBOX);
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            String value = upperFirstChar ? this.getUpperFirstChar("disabilitato") : "disabilitato";
            de.setStatusValue(value);
        } else {
            String value;
            List labelConfigurazione;
            ArrayList<String> nome;
            String label;
            String tooltip;
            CheckboxStatusType type;
            de.setType(DataElementType.MULTI_SELECT);
            if (request) {
                type = securityPorta.getRequestFlow().sizeParameterList() > 0 ? CheckboxStatusType.CONFIG_ENABLE : CheckboxStatusType.CONFIG_ERROR;
                tooltip = securityPorta.getRequestFlow().sizeParameterList() > 0 ? null : "Configurazione della sicurezza incompleta";
                label = null;
                if ("default".equals(securityPorta.getRequestFlow().getMode())) {
                    label = "Configurazione Manuale";
                } else {
                    nome = new ArrayList<String>();
                    nome.add(securityPorta.getRequestFlow().getMode());
                    labelConfigurazione = configManager.convertToLabel(propertiesSourceConfiguration, nome);
                    label = (String)labelConfigurazione.get(0);
                }
                value = (upperFirstChar ? "Richiesta" : "Richiesta".toLowerCase()) + " [ " + label + " ]";
                de.addStatus(tooltip, value, type);
            }
            if (response) {
                type = securityPorta.getResponseFlow().sizeParameterList() > 0 ? CheckboxStatusType.CONFIG_ENABLE : CheckboxStatusType.CONFIG_ERROR;
                tooltip = securityPorta.getResponseFlow().sizeParameterList() > 0 ? null : "Configurazione della sicurezza incompleta";
                label = null;
                if ("default".equals(securityPorta.getResponseFlow().getMode())) {
                    label = "Configurazione Manuale";
                } else {
                    nome = new ArrayList();
                    nome.add(securityPorta.getResponseFlow().getMode());
                    labelConfigurazione = configManager.convertToLabel(propertiesSourceConfiguration, nome);
                    label = (String)labelConfigurazione.get(0);
                }
                value = (upperFirstChar ? "Risposta" : "Risposta".toLowerCase()) + " [ " + label + " ]";
                de.addStatus(tooltip, value, type);
            }
        }
    }

    public void setStatoMTOM(DataElement de, MtomProcessor mtomPorta) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        this.setStatoMTOM(de, mtomPorta, true);
    }

    public void setStatoMTOM(DataElement de, MtomProcessor mtomPorta, boolean upperFirstChar) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        boolean request = false;
        boolean response = false;
        if (mtomPorta != null) {
            MTOMProcessorType mode;
            if (mtomPorta.getRequestFlow() != null && mtomPorta.getRequestFlow().getMode() != null && !(mode = mtomPorta.getRequestFlow().getMode()).equals((Object)MTOMProcessorType.DISABLE)) {
                request = true;
            }
            if (mtomPorta.getResponseFlow() != null && mtomPorta.getResponseFlow().getMode() != null && !(mode = mtomPorta.getResponseFlow().getMode()).equals((Object)MTOMProcessorType.DISABLE)) {
                response = true;
            }
        }
        if (mtomPorta == null || !request && !response) {
            de.setType(DataElementType.CHECKBOX);
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            String vUpper = upperFirstChar ? this.getUpperFirstChar("disabilitato") : "disabilitato";
            de.setStatusValue(vUpper);
        } else {
            String value;
            String v;
            String tooltip;
            CheckboxStatusType type;
            de.setType(DataElementType.MULTI_SELECT);
            if (request) {
                type = null;
                tooltip = null;
                switch (mtomPorta.getRequestFlow().getMode()) {
                    case PACKAGING: 
                    case VERIFY: {
                        type = mtomPorta.getRequestFlow().sizeParameterList() > 0 ? CheckboxStatusType.CONFIG_ENABLE : CheckboxStatusType.CONFIG_ERROR;
                        tooltip = mtomPorta.getRequestFlow().sizeParameterList() > 0 ? null : "Configurazione incompleta";
                        break;
                    }
                    default: {
                        type = CheckboxStatusType.CONFIG_ENABLE;
                    }
                }
                v = mtomPorta.getRequestFlow().getMode().getValue();
                value = (upperFirstChar ? "Richiesta" : "Richiesta".toLowerCase()) + " [ " + this.getUpperFirstChar(v) + " ]";
                de.addStatus(tooltip, value, type);
            }
            if (response) {
                type = null;
                tooltip = null;
                switch (mtomPorta.getResponseFlow().getMode()) {
                    case PACKAGING: 
                    case VERIFY: {
                        type = mtomPorta.getResponseFlow().sizeParameterList() > 0 ? CheckboxStatusType.CONFIG_ENABLE : CheckboxStatusType.CONFIG_ERROR;
                        tooltip = mtomPorta.getResponseFlow().sizeParameterList() > 0 ? null : "Configurazione incompleta";
                        break;
                    }
                    default: {
                        type = CheckboxStatusType.CONFIG_ENABLE;
                    }
                }
                v = mtomPorta.getResponseFlow().getMode().getValue();
                value = (upperFirstChar ? "Risposta" : "Risposta".toLowerCase()) + " [ " + this.getUpperFirstChar(v) + " ]";
                de.addStatus(tooltip, value, type);
            }
        }
    }

    public void setStatoTrasformazioni(DataElement de, Trasformazioni trasformazioni, org.openspcoop2.message.constants.ServiceBinding serviceBindingMessage) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        this.setStatoTrasformazioni(de, trasformazioni, serviceBindingMessage, true);
    }

    public void setStatoTrasformazioni(DataElement de, Trasformazioni trasformazioni, org.openspcoop2.message.constants.ServiceBinding serviceBindingMessage, boolean upperFirstChar) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        de.setType(DataElementType.CHECKBOX);
        List listaTrasformazioni = null;
        if (trasformazioni != null) {
            listaTrasformazioni = trasformazioni.getRegolaList();
        }
        if (listaTrasformazioni == null || listaTrasformazioni.size() <= 0) {
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            String vDisabilitato = upperFirstChar ? this.getUpperFirstChar("disabilitato") : "disabilitato";
            de.setStatusValue(vDisabilitato);
        } else {
            StringBuilder bfToolTip = new StringBuilder();
            CheckboxStatusType type = null;
            int regoleAbilitate = 0;
            int regoleDisabilitate = 0;
            block0: for (TrasformazioneRegola trasformazioneRegola : listaTrasformazioni) {
                if (trasformazioneRegola.getStato() != null && StatoFunzionalita.DISABILITATO.equals((Object)trasformazioneRegola.getStato())) {
                    ++regoleDisabilitate;
                    continue;
                }
                ++regoleAbilitate;
                boolean richiestaDefinita = false;
                if (trasformazioneRegola.getRichiesta() != null) {
                    boolean bl = richiestaDefinita = trasformazioneRegola.getRichiesta().isConversione() || trasformazioneRegola.getRichiesta().sizeHeaderList() > 0 || trasformazioneRegola.getRichiesta().sizeParametroUrlList() > 0 || org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBindingMessage) && trasformazioneRegola.getRichiesta().getTrasformazioneRest() != null && (StringUtils.isNotEmpty((CharSequence)trasformazioneRegola.getRichiesta().getTrasformazioneRest().getMetodo()) || StringUtils.isNotEmpty((CharSequence)trasformazioneRegola.getRichiesta().getTrasformazioneRest().getPath()));
                }
                if (trasformazioneRegola.sizeRispostaList() > 0) {
                    for (TrasformazioneRegolaRisposta trasformazioneRegolaRisposta : trasformazioneRegola.getRispostaList()) {
                        boolean rispostaDefinita = false;
                        if (trasformazioneRegolaRisposta != null) {
                            boolean bl = rispostaDefinita = trasformazioneRegolaRisposta.isConversione() || trasformazioneRegolaRisposta.sizeHeaderList() > 0 || trasformazioneRegolaRisposta.getReturnCode() != null && StringUtils.isNotEmpty((CharSequence)trasformazioneRegolaRisposta.getReturnCode());
                        }
                        if (rispostaDefinita) continue;
                        type = CheckboxStatusType.CONFIG_ERROR;
                        if (bfToolTip.length() > 0) {
                            bfToolTip.append("\n");
                        }
                        if (trasformazioneRegolaRisposta != null) {
                            bfToolTip.append("La regola '" + trasformazioneRegola.getNome() + "' possiede una configurazione per la risposta ('" + trasformazioneRegolaRisposta.getNome() + "') senza alcuna trasformazione attiva");
                            continue block0;
                        }
                        bfToolTip.append("La regola '" + trasformazioneRegola.getNome() + "' non possiede una configurazione per la risposta");
                        continue block0;
                    }
                    continue;
                }
                if (richiestaDefinita) continue;
                type = CheckboxStatusType.CONFIG_ERROR;
                if (bfToolTip.length() > 0) {
                    bfToolTip.append("\n");
                }
                bfToolTip.append("La regola '" + trasformazioneRegola.getNome() + "' non effettua trasformazioni n\u00e8 della richiesta n\u00e8 della risposta");
            }
            if (regoleAbilitate == 0) {
                de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
                String vDisabilitato = upperFirstChar ? this.getUpperFirstChar("disabilitato") : "disabilitato";
                de.setStatusValue(vDisabilitato);
                if (regoleDisabilitate > 0) {
                    de.setStatusToolTip("Sono registrate, con stato disabilitato, " + regoleDisabilitate + " regole di trasformazione dei messaggi");
                }
            } else {
                if (type == null) {
                    type = CheckboxStatusType.CONFIG_ENABLE;
                }
                de.setStatusType(type);
                String vAbilitato = upperFirstChar ? this.getUpperFirstChar("abilitato") : "abilitato";
                de.setStatusValue(vAbilitato);
                if (bfToolTip.length() > 0) {
                    de.setStatusToolTip(bfToolTip.toString());
                } else if (listaTrasformazioni.size() > 1) {
                    de.setStatusToolTip("Sono attive " + regoleAbilitate + " regole di trasformazione dei messaggi");
                }
            }
        }
    }

    public void setStatoTracciamento(DataElement de, CorrelazioneApplicativa correlazioneApplicativa, CorrelazioneApplicativaRisposta correlazioneApplicativaRisposta, PortaTracciamento tracciamentoConfig, ConfigurazioneTracciamentoPorta configurazioneTracciamento, List<Proprieta> proprietaPorta, Configurazione configurazioneGenerale) throws DriverControlStationException {
        de.setType(DataElementType.MULTI_SELECT);
        String tooltipTransazioni = null;
        boolean transazioniDB = false;
        boolean transazioniFiletrace = false;
        if (tracciamentoConfig != null && tracciamentoConfig.getStato() != null && StatoFunzionalita.ABILITATO.equals((Object)tracciamentoConfig.getStato())) {
            tooltipTransazioni = "Configurazione ridefinita per l'API";
            boolean bl = transazioniDB = tracciamentoConfig.getDatabase() == null || tracciamentoConfig.getDatabase().getStato() == null || !StatoFunzionalitaConPersonalizzazione.DISABILITATO.equals((Object)tracciamentoConfig.getDatabase().getStato());
            if (transazioniDB && (tracciamentoConfig.getDatabase() == null || tracciamentoConfig.getDatabase().getFiltroEsiti() == null || StatoFunzionalita.ABILITATO.equals((Object)tracciamentoConfig.getDatabase().getFiltroEsiti()))) {
                transazioniDB = tracciamentoConfig.getEsiti() != null && !("" + EsitiConfigUtils.TUTTI_ESITI_DISABILITATI).equals(tracciamentoConfig.getEsiti());
            }
            boolean bl2 = transazioniFiletrace = tracciamentoConfig.getFiletrace() != null && tracciamentoConfig.getFiletrace().getStato() != null && !StatoFunzionalitaConPersonalizzazione.DISABILITATO.equals((Object)tracciamentoConfig.getFiletrace().getStato());
            if (transazioniFiletrace && tracciamentoConfig.getDatabase() != null && tracciamentoConfig.getDatabase().getFiltroEsiti() != null && StatoFunzionalita.ABILITATO.equals((Object)tracciamentoConfig.getDatabase().getFiltroEsiti())) {
                transazioniFiletrace = tracciamentoConfig.getEsiti() != null && !("" + EsitiConfigUtils.TUTTI_ESITI_DISABILITATI).equals(tracciamentoConfig.getEsiti());
            }
        } else {
            tooltipTransazioni = "Configurazione di default del Gateway";
            String esitiTransazioni = this.readConfigurazioneRegistrazioneEsitiFromHttpParameters(configurazioneTracciamento != null ? configurazioneTracciamento.getEsiti() : null, true);
            boolean bl = transazioniDB = configurazioneTracciamento == null || configurazioneTracciamento.getDatabase() == null || configurazioneTracciamento.getDatabase().getStato() == null || !StatoFunzionalitaConPersonalizzazione.DISABILITATO.equals((Object)configurazioneTracciamento.getDatabase().getStato());
            if (transazioniDB && (configurazioneTracciamento == null || configurazioneTracciamento.getDatabase() == null || configurazioneTracciamento.getDatabase().getFiltroEsiti() == null || StatoFunzionalita.ABILITATO.equals((Object)configurazioneTracciamento.getDatabase().getFiltroEsiti()))) {
                transazioniDB = esitiTransazioni != null && !("" + EsitiConfigUtils.TUTTI_ESITI_DISABILITATI).equals(esitiTransazioni);
            }
            boolean bl3 = transazioniFiletrace = configurazioneTracciamento != null && configurazioneTracciamento.getFiletrace() != null && configurazioneTracciamento.getFiletrace().getStato() != null && !StatoFunzionalitaConPersonalizzazione.DISABILITATO.equals((Object)configurazioneTracciamento.getFiletrace().getStato());
            if (configurazioneTracciamento != null && configurazioneTracciamento.getFiletrace() != null && StatoFunzionalitaConPersonalizzazione.CONFIGURAZIONE_ESTERNA.equals((Object)configurazioneTracciamento.getFiletrace().getStato())) {
                boolean bl4 = transazioniFiletrace = InitListener.getFileTraceGovWayState() != null ? InitListener.getFileTraceGovWayState().isEnabled() : transazioniFiletrace;
            }
            if (transazioniFiletrace && configurazioneTracciamento != null && configurazioneTracciamento.getFiletrace() != null && StatoFunzionalitaConPersonalizzazione.CONFIGURAZIONE_ESTERNA.equals((Object)configurazioneTracciamento.getFiletrace().getStato())) {
                transazioniFiletrace = CostantiProprieta.isFileTraceEnabled(proprietaPorta, (boolean)transazioniFiletrace);
            }
            if (transazioniFiletrace && configurazioneTracciamento != null && configurazioneTracciamento.getFiletrace() != null && configurazioneTracciamento.getFiletrace().getFiltroEsiti() != null && StatoFunzionalita.ABILITATO.equals((Object)configurazioneTracciamento.getFiletrace().getFiltroEsiti())) {
                transazioniFiletrace = esitiTransazioni != null && !("" + EsitiConfigUtils.TUTTI_ESITI_DISABILITATI).equals(esitiTransazioni);
            }
        }
        StringBuilder sbTransazioni = new StringBuilder();
        if (transazioniFiletrace) {
            sbTransazioni.append(" [ ");
            if (transazioniDB) {
                sbTransazioni.append("DB");
                if (transazioniFiletrace) {
                    sbTransazioni.append(",");
                }
            }
            if (transazioniFiletrace) {
                sbTransazioni.append("FileTrace");
            }
            sbTransazioni.append(" ]");
        }
        String suffixTooltipTransazioni = sbTransazioni.length() > 0 ? sbTransazioni.toString() : "";
        de.addStatus(tooltipTransazioni, "Transazioni" + suffixTooltipTransazioni, transazioniDB || transazioniFiletrace ? CheckboxStatusType.CONFIG_ENABLE : CheckboxStatusType.CONFIG_DISABLE);
        Object tooltipSeverita = null;
        boolean tracciamentoSeverita = false;
        if (tracciamentoConfig != null && tracciamentoConfig.getSeverita() != null) {
            tooltipSeverita = "Configurazione ridefinita per l'API\nLivello Severit\u00e0: " + tracciamentoConfig.getSeverita().getValue();
            tracciamentoSeverita = !"off".equals(tracciamentoConfig.getSeverita().getValue());
        } else {
            tooltipSeverita = "Configurazione di default del Gateway";
            if (configurazioneGenerale != null && configurazioneGenerale.getMessaggiDiagnostici() != null && configurazioneGenerale.getMessaggiDiagnostici().getSeverita() != null) {
                tooltipSeverita = (String)tooltipSeverita + "\nLivello Severit\u00e0: " + configurazioneGenerale.getMessaggiDiagnostici().getSeverita().getValue();
            }
            tracciamentoSeverita = configurazioneGenerale != null && configurazioneGenerale.getMessaggiDiagnostici() != null && configurazioneGenerale.getMessaggiDiagnostici().getSeverita() != null && !"off".equals(configurazioneGenerale.getMessaggiDiagnostici().getSeverita().getValue());
        }
        de.addStatus((String)tooltipSeverita, "Diagnostici", tracciamentoSeverita ? CheckboxStatusType.CONFIG_ENABLE : CheckboxStatusType.CONFIG_DISABLE);
        boolean isCorrelazioneApplicativaAbilitataReq = false;
        if (correlazioneApplicativa != null) {
            boolean bl = isCorrelazioneApplicativaAbilitataReq = correlazioneApplicativa.sizeElementoList() > 0;
        }
        if (isCorrelazioneApplicativaAbilitataReq) {
            de.addStatus(correlazioneApplicativa.sizeElementoList() > 1 ? "Sono attive " + correlazioneApplicativa.sizeElementoList() + " regole" : null, "Richiesta [ Correlazione Applicativa ]", CheckboxStatusType.CONFIG_ENABLE);
        }
        boolean isCorrelazioneApplicativaAbilitataRes = false;
        if (correlazioneApplicativaRisposta != null) {
            boolean bl = isCorrelazioneApplicativaAbilitataRes = correlazioneApplicativaRisposta.sizeElementoList() > 0;
        }
        if (isCorrelazioneApplicativaAbilitataRes) {
            de.addStatus(correlazioneApplicativaRisposta.sizeElementoList() > 1 ? "Sono attive " + correlazioneApplicativaRisposta.sizeElementoList() + " regole" : null, "Risposta [ Correlazione Applicativa ]", CheckboxStatusType.CONFIG_ENABLE);
        }
    }

    public void setStatoDump(DataElement de, DumpConfigurazione dumpConfigurazionePorta, Configurazione configurazioneGenerale, boolean portaApplicativa) {
        this.setStatoDump(de, dumpConfigurazionePorta, configurazioneGenerale, portaApplicativa, true);
    }

    public void setStatoDump(DataElement de, DumpConfigurazione dumpConfigurazionePorta, Configurazione configurazioneGenerale, boolean portaApplicativa, boolean upperFirstChar) {
        de.setType(DataElementType.MULTI_SELECT);
        DumpConfigurazione dumpConfigurazione = null;
        String tooltip = null;
        if (dumpConfigurazionePorta != null) {
            tooltip = "Configurazione ridefinita per l'API";
            dumpConfigurazione = dumpConfigurazionePorta;
        } else {
            tooltip = "Configurazione di default del Gateway";
            if (configurazioneGenerale != null && configurazioneGenerale.getDump() != null) {
                dumpConfigurazione = portaApplicativa ? configurazioneGenerale.getDump().getConfigurazionePortaApplicativa() : configurazioneGenerale.getDump().getConfigurazionePortaDelegata();
            }
        }
        StringBuilder bfRichiesta = new StringBuilder();
        StringBuilder bfRichiestaOptions = new StringBuilder();
        StringBuilder bfRisposta = new StringBuilder();
        StringBuilder bfRispostaOptions = new StringBuilder();
        if (dumpConfigurazione != null) {
            StringBuilder bf;
            if (dumpConfigurazione.getRichiestaIngresso() != null) {
                bf = new StringBuilder();
                if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaIngresso().getHeaders())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Headers");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaIngresso().getPayload())) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaIngresso().getPayloadParsing())) {
                        if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaIngresso().getBody())) {
                            if (bf.length() > 0) {
                                bf.append(", ");
                            }
                            bf.append("Body");
                        }
                        if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaIngresso().getAttachments())) {
                            if (bf.length() > 0) {
                                bf.append(", ");
                            }
                            bf.append("Attachments");
                        }
                    } else {
                        if (bf.length() > 0) {
                            bf.append(", ");
                        }
                        bf.append("Payload");
                    }
                }
                if (bf.length() > 0) {
                    if (bfRichiesta.length() > 0) {
                        bfRichiesta.append("\n");
                    }
                    bfRichiesta.append("Richiesta Ingresso").append(": ").append(bf.toString());
                    if (bfRichiestaOptions.length() > 0) {
                        bfRichiestaOptions.append(", ");
                    }
                    bfRichiestaOptions.append("Ingresso");
                }
            }
            if (dumpConfigurazione.getRichiestaUscita() != null) {
                bf = new StringBuilder();
                if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getHeaders())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Headers");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getPayload())) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getPayloadParsing())) {
                        if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getBody())) {
                            if (bf.length() > 0) {
                                bf.append(", ");
                            }
                            bf.append("Body");
                        }
                        if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getAttachments())) {
                            if (bf.length() > 0) {
                                bf.append(", ");
                            }
                            bf.append("Attachments");
                        }
                    } else {
                        if (bf.length() > 0) {
                            bf.append(", ");
                        }
                        bf.append("Payload");
                    }
                }
                if (bf.length() > 0) {
                    if (bfRichiesta.length() > 0) {
                        bfRichiesta.append("\n");
                    }
                    bfRichiesta.append("Richiesta Uscita").append(": ").append(bf.toString());
                    if (bfRichiestaOptions.length() > 0) {
                        bfRichiestaOptions.append(", ");
                    }
                    bfRichiestaOptions.append("Uscita");
                }
            }
            if (dumpConfigurazione.getRispostaIngresso() != null) {
                bf = new StringBuilder();
                if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getHeaders())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Headers");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getPayload())) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getPayloadParsing())) {
                        if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getBody())) {
                            if (bf.length() > 0) {
                                bf.append(", ");
                            }
                            bf.append("Body");
                        }
                        if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getAttachments())) {
                            if (bf.length() > 0) {
                                bf.append(", ");
                            }
                            bf.append("Attachments");
                        }
                    } else {
                        if (bf.length() > 0) {
                            bf.append(", ");
                        }
                        bf.append("Payload");
                    }
                }
                if (bf.length() > 0) {
                    if (bfRisposta.length() > 0) {
                        bfRisposta.append("\n");
                    }
                    bfRisposta.append("Risposta Ingresso").append(": ").append(bf.toString());
                    if (bfRispostaOptions.length() > 0) {
                        bfRispostaOptions.append(", ");
                    }
                    bfRispostaOptions.append("Ingresso");
                }
            }
            if (dumpConfigurazione.getRispostaUscita() != null) {
                bf = new StringBuilder();
                if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaUscita().getHeaders())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Headers");
                }
                if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaUscita().getPayload())) {
                    if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaUscita().getPayloadParsing())) {
                        if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaUscita().getBody())) {
                            if (bf.length() > 0) {
                                bf.append(", ");
                            }
                            bf.append("Body");
                        }
                        if (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaUscita().getAttachments())) {
                            if (bf.length() > 0) {
                                bf.append(", ");
                            }
                            bf.append("Attachments");
                        }
                    } else {
                        if (bf.length() > 0) {
                            bf.append(", ");
                        }
                        bf.append("Payload");
                    }
                }
                if (bf.length() > 0) {
                    if (bfRisposta.length() > 0) {
                        bfRisposta.append("\n");
                    }
                    bfRisposta.append("Risposta Uscita").append(": ").append(bf.toString());
                    if (bfRispostaOptions.length() > 0) {
                        bfRispostaOptions.append(", ");
                    }
                    bfRispostaOptions.append("Uscita");
                }
            }
        }
        if (bfRichiesta.length() > 0 || bfRisposta.length() > 0) {
            if (bfRichiesta.length() > 0) {
                de.addStatus(tooltip + "\n" + bfRichiesta.toString(), (upperFirstChar ? "Richiesta" : "Richiesta".toLowerCase()) + " [ " + bfRichiestaOptions.toString() + " ]", CheckboxStatusType.CONFIG_ENABLE);
            }
            if (bfRisposta.length() > 0) {
                de.addStatus(tooltip + "\n" + bfRisposta.toString(), (upperFirstChar ? "Risposta" : "Risposta".toLowerCase()) + " [ " + bfRispostaOptions.toString() + " ]", CheckboxStatusType.CONFIG_ENABLE);
            }
        } else {
            de.addStatus(tooltip, upperFirstChar ? this.getUpperFirstChar("disabilitato") : "disabilitato", CheckboxStatusType.CONFIG_DISABLE);
        }
    }

    public void setStatoProprieta(DataElement de, int size) {
        de.setType(DataElementType.CHECKBOX);
        if (size > 0) {
            de.setStatusType(CheckboxStatusType.CONFIG_ENABLE);
            de.setStatusValue(this.getUpperFirstChar("abilitato"));
            de.setStatusToolTip("Sono registrate " + size + " propriet\u00e0");
        } else {
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            de.setStatusValue(this.getUpperFirstChar("disabilitato"));
        }
    }

    public void setStatoOpzioniAvanzate(DataElement de, String protocollo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, StatoFunzionalita allegaBody, StatoFunzionalita scartaBody, String integrazione, String behaviour, List<Proprieta> proprietaRateLimiting, StatoFunzionalita stateless, PortaDelegataLocalForward localForward, StatoFunzionalita ricevutaAsincronaSimmetrica, StatoFunzionalita ricevutaAsincronaAsimmetrica, StatoFunzionalita gestioneManifest, ConfigurazionePortaHandler configPortaHandler) throws DriverRegistroServiziNotFound, DriverRegistroServiziException, DriverConfigurazioneException {
        this.setStatoOpzioniAvanzate(de, protocollo, serviceBinding, allegaBody, scartaBody, integrazione, behaviour, proprietaRateLimiting, stateless, localForward, ricevutaAsincronaSimmetrica, ricevutaAsincronaAsimmetrica, gestioneManifest, configPortaHandler, true);
    }

    public void setStatoOpzioniAvanzate(DataElement de, String protocollo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, StatoFunzionalita allegaBody, StatoFunzionalita scartaBody, String integrazione, String behaviour, List<Proprieta> proprietaRateLimiting, StatoFunzionalita stateless, PortaDelegataLocalForward localForward, StatoFunzionalita ricevutaAsincronaSimmetrica, StatoFunzionalita ricevutaAsincronaAsimmetrica, StatoFunzionalita gestioneManifest, ConfigurazionePortaHandler configPortaHandler, boolean upperFirstChar) throws DriverRegistroServiziNotFound, DriverRegistroServiziException, DriverConfigurazioneException {
        String[] tmp;
        boolean supportoAsincroni = this.core.isProfiloDiCollaborazioneAsincronoSupportatoDalProtocollo(protocollo, serviceBinding);
        boolean supportoGestioneManifest = this.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, FunzionalitaProtocollo.MANIFEST_ATTACHMENTS);
        de.setType(DataElementType.CHECKBOX);
        StringBuilder bf = new StringBuilder();
        StringBuilder bfTooltips = new StringBuilder();
        if (allegaBody != null && StatoFunzionalita.ABILITATO.equals((Object)allegaBody)) {
            if (bf.length() > 0) {
                bf.append(", ");
            }
            bf.append("Allega SOAPBody");
            if (bfTooltips.length() > 0) {
                bfTooltips.append("\n");
            }
            bfTooltips.append("Allega SOAP Body come Attachment");
        }
        if (scartaBody != null && StatoFunzionalita.ABILITATO.equals((Object)scartaBody)) {
            if (bf.length() > 0) {
                bf.append(", ");
            }
            bf.append("Scarta SOAPBody");
            if (bfTooltips.length() > 0) {
                bfTooltips.append("\n");
            }
            bfTooltips.append("Scarta SOAP Body");
        }
        if (integrazione != null && !"".equals(integrazione)) {
            tmp = integrazione.split(",");
            if (bf.length() > 0) {
                bf.append(", ");
            }
            bf.append("Metadati Integrazione");
            if (tmp.length > 1) {
                bf.append(" (").append(tmp.length).append(")");
            }
            if (bfTooltips.length() > 0) {
                bfTooltips.append("\n");
            }
            ArrayList<String> listGruppi = new ArrayList<String>();
            ArrayList<String> listPlugins = new ArrayList<String>();
            if (tmp.length > 0) {
                for (String tmpIntegrazione : tmp) {
                    if (tmpIntegrazione != null) {
                        String label;
                        TipoIntegrazione tipo = TipoIntegrazione.toEnumConstant((String)(tmpIntegrazione = tmpIntegrazione.trim()));
                        if (tipo != null) {
                            label = null;
                            label = tipo.getGroup() != null ? tipo.getGroup().getCompactLabel() : tipo.getLabel();
                            if (listGruppi.contains(label)) continue;
                            listGruppi.add(label);
                            continue;
                        }
                        listPlugins.add(tmpIntegrazione);
                        label = GruppoIntegrazione.PLUGIN.getCompactLabel();
                        if (listGruppi.contains(label)) continue;
                        listGruppi.add(label);
                        continue;
                    }
                    listPlugins.add(tmpIntegrazione);
                    String label = GruppoIntegrazione.PLUGIN.getCompactLabel();
                    if (listGruppi.contains(label)) continue;
                    listGruppi.add(label);
                }
            }
            StringBuilder integrazioneString = new StringBuilder("");
            if (!listGruppi.isEmpty()) {
                for (String gruppo : listGruppi) {
                    if (integrazioneString.length() > 0) {
                        integrazioneString.append(", ");
                    }
                    integrazioneString.append(gruppo);
                    if (!GruppoIntegrazione.PLUGIN.getCompactLabel().equals(gruppo) || listPlugins.isEmpty()) continue;
                    integrazioneString.append(" (");
                    for (int i = 0; i < listPlugins.size(); ++i) {
                        String plug = (String)listPlugins.get(i);
                        if (i > 0) {
                            integrazioneString.append(",");
                        }
                        integrazioneString.append(plug);
                    }
                    integrazioneString.append(")");
                }
            }
            bfTooltips.append("Metadati Integrazione").append(": ").append(integrazioneString.toString());
        }
        if (proprietaRateLimiting != null && !proprietaRateLimiting.isEmpty()) {
            try {
                PolicyConfiguration config = new PolicyConfiguration(proprietaRateLimiting, this.core.getControlloTrafficoPolicyRateLimitingTipiGestori(), false);
                if (!"default".equals(config.getSyncMode()) || !"default".equals(config.getHttpMode())) {
                    if (bf.length() > 0) {
                        bf.append(", ");
                    }
                    bf.append("Rate Limiting");
                    if (bfTooltips.length() > 0) {
                        bfTooltips.append("\n");
                    }
                    bfTooltips.append("Rate Limiting").append(": ");
                    if (!"default".equals(config.getSyncMode())) {
                        bfTooltips.append("Sincronizzazione").append(" ");
                        if ("locale".equals(config.getSyncMode())) {
                            bfTooltips.append("Locale");
                        } else if ("localePiuNodi".equals(config.getSyncMode())) {
                            bfTooltips.append("Locale - Quota divisa sui nodi");
                        } else if ("distribuita".equals(config.getSyncMode())) {
                            if (config.getType() != null) {
                                bfTooltips.append(config.getType().toLabel());
                            } else {
                                bfTooltips.append("Distribuita");
                            }
                        }
                        if (!"default".equals(config.getHttpMode())) {
                            bfTooltips.append(", ");
                        }
                    }
                    if (!"default".equals(config.getHttpMode())) {
                        bfTooltips.append("HTTP Headers");
                        if ("disabilitato".equals(config.getHttpMode())) {
                            bfTooltips.append(" ").append("disabilitati");
                        } else if ("ridefinito".equals(config.getHttpMode())) {
                            bfTooltips.append(" ").append("gestione personalizzata");
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), (Throwable)e);
            }
        }
        if (behaviour != null && !"".equals(behaviour)) {
            tmp = behaviour.split(",");
            if (bf.length() > 0) {
                bf.append(", ");
            }
            bf.append("Behaviour");
            if (tmp.length > 1) {
                bf.append(" (").append(tmp.length).append(")");
            }
            if (bfTooltips.length() > 0) {
                bfTooltips.append("\n");
            }
            bfTooltips.append("Behaviour").append(": ").append(behaviour);
        }
        if (stateless != null) {
            if (bf.length() > 0) {
                bf.append(", ");
            }
            if (bfTooltips.length() > 0) {
                bfTooltips.append("\n");
            }
            if (StatoFunzionalita.ABILITATO.equals((Object)stateless)) {
                bf.append("Gestione Stateless");
                bfTooltips.append("Gestione Stateless");
            } else {
                bf.append("Gestione Stateful");
                bfTooltips.append("Gestione Stateful");
            }
        }
        if (localForward != null && StatoFunzionalita.ABILITATO.equals((Object)localForward.getStato())) {
            if (bf.length() > 0) {
                bf.append(", ");
            }
            bf.append("Local Forward");
            if (bfTooltips.length() > 0) {
                bfTooltips.append("\n");
            }
            bfTooltips.append("Local Forward");
            if (localForward.getPortaApplicativa() != null) {
                bfTooltips.append(", ").append("Porta Inbound").append(": ").append(localForward.getPortaApplicativa());
            }
        }
        if (supportoAsincroni) {
            if (ricevutaAsincronaSimmetrica != null && StatoFunzionalita.ABILITATO.equals((Object)ricevutaAsincronaSimmetrica)) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Ricevuta Simmetrica");
                if (bfTooltips.length() > 0) {
                    bfTooltips.append("\n");
                }
                bfTooltips.append("Ricevuta Simmetrica");
            }
            if (ricevutaAsincronaAsimmetrica != null && StatoFunzionalita.ABILITATO.equals((Object)ricevutaAsincronaAsimmetrica)) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Ricevuta Asimmetrica");
                if (bfTooltips.length() > 0) {
                    bfTooltips.append("\n");
                }
                bfTooltips.append("Ricevuta Asimmetrica");
            }
        }
        if (supportoGestioneManifest && gestioneManifest != null && StatoFunzionalita.ABILITATO.equals((Object)gestioneManifest)) {
            if (bf.length() > 0) {
                bf.append(", ");
            }
            bf.append("Gestione Manifest");
            if (bfTooltips.length() > 0) {
                bfTooltips.append("\n");
            }
            bfTooltips.append("Gestione Manifest");
        }
        if (configPortaHandler != null) {
            StringBuilder sbRequest = new StringBuilder();
            if (configPortaHandler.getRequest() != null) {
                if (configPortaHandler.getRequest().sizePreInList() > 0) {
                    if (sbRequest.length() > 0) {
                        sbRequest.append(", ");
                    }
                    sbRequest.append("Pre-In").append(" (").append(configPortaHandler.getRequest().sizePreInList()).append(")");
                }
                if (configPortaHandler.getRequest().sizeInList() > 0) {
                    if (sbRequest.length() > 0) {
                        sbRequest.append(", ");
                    }
                    sbRequest.append("In").append(" (").append(configPortaHandler.getRequest().sizeInList()).append(")");
                }
                if (configPortaHandler.getRequest().sizeInProtocolInfoList() > 0) {
                    if (sbRequest.length() > 0) {
                        sbRequest.append(", ");
                    }
                    sbRequest.append("InProfileInfo").append(" (").append(configPortaHandler.getRequest().sizeInProtocolInfoList()).append(")");
                }
                if (configPortaHandler.getRequest().sizeOutList() > 0) {
                    if (sbRequest.length() > 0) {
                        sbRequest.append(", ");
                    }
                    sbRequest.append("Out").append(" (").append(configPortaHandler.getRequest().sizeOutList()).append(")");
                }
                if (configPortaHandler.getRequest().sizePostOutList() > 0) {
                    if (sbRequest.length() > 0) {
                        sbRequest.append(", ");
                    }
                    sbRequest.append("Post-Out").append(" (").append(configPortaHandler.getRequest().sizePostOutList()).append(")");
                }
            }
            StringBuilder sbResponse = new StringBuilder();
            if (configPortaHandler.getResponse() != null) {
                if (configPortaHandler.getResponse().sizePreInList() > 0) {
                    if (sbResponse.length() > 0) {
                        sbResponse.append(", ");
                    }
                    sbResponse.append("Pre-In").append(" (").append(configPortaHandler.getResponse().sizePreInList()).append(")");
                }
                if (configPortaHandler.getResponse().sizeInList() > 0) {
                    if (sbResponse.length() > 0) {
                        sbResponse.append(", ");
                    }
                    sbResponse.append("In").append(" (").append(configPortaHandler.getResponse().sizeInList()).append(")");
                }
                if (configPortaHandler.getResponse().sizeInProtocolInfoList() > 0) {
                    if (sbResponse.length() > 0) {
                        sbResponse.append(", ");
                    }
                    sbResponse.append("InProfileInfo").append(" (").append(configPortaHandler.getResponse().sizeInProtocolInfoList()).append(")");
                }
                if (configPortaHandler.getResponse().sizeOutList() > 0) {
                    if (sbResponse.length() > 0) {
                        sbResponse.append(", ");
                    }
                    sbResponse.append("Out").append(" (").append(configPortaHandler.getResponse().sizeOutList()).append(")");
                }
                if (configPortaHandler.getResponse().sizePostOutList() > 0) {
                    if (sbResponse.length() > 0) {
                        sbResponse.append(", ");
                    }
                    sbResponse.append("Post-Out").append(" (").append(configPortaHandler.getResponse().sizePostOutList()).append(")");
                }
            }
            if (sbRequest.length() > 0 || sbResponse.length() > 0) {
                if (bf.length() > 0) {
                    bf.append(", ");
                }
                bf.append("Message Handler");
                if (sbRequest.length() > 0) {
                    if (bfTooltips.length() > 0) {
                        bfTooltips.append("\n");
                    }
                    bfTooltips.append("Request Handler").append(": ").append(sbRequest.toString());
                }
                if (sbResponse.length() > 0) {
                    if (bfTooltips.length() > 0) {
                        bfTooltips.append("\n");
                    }
                    bfTooltips.append("Response Handler").append(": ").append(sbResponse.toString());
                }
            }
        }
        if (bf.length() > 0) {
            de.setStatusType(CheckboxStatusType.CONFIG_ENABLE);
            String vAbilitato = upperFirstChar ? this.getUpperFirstChar("abilitato") : "abilitato";
            de.setStatusValue(vAbilitato + " [ " + bf.toString() + " ]");
            de.setStatusToolTip(bfTooltips.toString());
        } else {
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            String vDisabilitato = upperFirstChar ? this.getUpperFirstChar("disabilitato") : "disabilitato";
            de.setStatusValue(vDisabilitato);
        }
    }

    public void setStatoExtendedList(DataElement de, int size, String stato, String statoTooltip) {
        this.setStatoExtendedList(de, size, stato, statoTooltip, true);
    }

    public void setStatoExtendedList(DataElement de, int size, String stato, String statoTooltip, boolean upperFirstChar) {
        de.setType(DataElementType.CHECKBOX);
        if (size > 0) {
            String vAbilitato;
            de.setStatusType(CheckboxStatusType.CONFIG_ENABLE);
            String string = vAbilitato = upperFirstChar ? this.getUpperFirstChar("abilitato") : "abilitato";
            if (stato != null) {
                de.setStatusValue(vAbilitato + " [" + stato + " ]");
            } else {
                de.setStatusValue(vAbilitato);
            }
            if (statoTooltip != null) {
                de.setStatusToolTip(statoTooltip);
            } else {
                de.setStatusToolTip("Sono registrate " + size + " propriet\u00e0");
            }
        } else {
            de.setStatusType(CheckboxStatusType.CONFIG_DISABLE);
            String vDisabilitato = upperFirstChar ? this.getUpperFirstChar("disabilitato") : "disabilitato";
            de.setStatusValue(vDisabilitato);
        }
    }

    public String getLabelStatoGestioneToken(String gestioneToken) {
        String label = "disabilitato";
        if (gestioneToken != null && StatoFunzionalita.ABILITATO.getValue().equals(gestioneToken)) {
            return "abilitato";
        }
        return label;
    }

    public String getLabelStatoAutenticazione(String autenticazione, String autenticazioneOpzionale, String autenticazioneCustom) {
        String label = "disabilitato";
        if (autenticazione != null && !TipoAutenticazione.DISABILITATO.equals(autenticazione)) {
            return "abilitato";
        }
        if (autenticazioneOpzionale != null && ServletUtils.isCheckBoxEnabled((String)autenticazioneOpzionale)) {
            return "abilitato";
        }
        return label;
    }

    public String getLabelStatoAutorizzazione(String autorizzazione, String autorizzazioneContenuti, String autorizzazioneCustom) {
        String label = "disabilitato";
        if (!AutorizzazioneUtilities.STATO_DISABILITATO.equals(autorizzazione)) {
            return "abilitato";
        }
        if (StringUtils.isNotEmpty((CharSequence)autorizzazioneContenuti)) {
            return "abilitato";
        }
        return label;
    }

    public DataElement getServiceBindingDataElement(org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws DriverControlStationException {
        return this.getServiceBindingDataElement(null, false, serviceBinding, true);
    }

    public DataElement getServiceBindingDataElement(IProtocolFactory<?> protocolFactory, boolean used, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws DriverControlStationException {
        return this.getServiceBindingDataElement(protocolFactory, used, serviceBinding, false);
    }

    public DataElement getServiceBindingDataElement(IProtocolFactory<?> protocolFactory, boolean used, org.openspcoop2.message.constants.ServiceBinding serviceBinding, boolean forceHidden) throws DriverControlStationException {
        DataElement de = null;
        if (!forceHidden) {
            try {
                List<org.openspcoop2.message.constants.ServiceBinding> serviceBindingList = this.core.getServiceBindingList(protocolFactory);
                de = new DataElement();
                de.setName("serviceBinding");
                de.setLabel("Tipo");
                if (serviceBindingList != null && serviceBindingList.size() > 1) {
                    if (used) {
                        de.setType(DataElementType.TEXT);
                        de.setValue(serviceBinding.toString());
                    } else {
                        de.setSelected(serviceBinding.toString());
                        de.setType(DataElementType.SELECT);
                        de.setPostBack(true);
                        String[] values = new String[serviceBindingList.size()];
                        String[] labels = new String[serviceBindingList.size()];
                        block5: for (int i = 0; i < serviceBindingList.size(); ++i) {
                            org.openspcoop2.message.constants.ServiceBinding serviceBinding2 = serviceBindingList.get(i);
                            switch (serviceBinding2) {
                                case REST: {
                                    labels[i] = "Rest";
                                    values[i] = "REST";
                                    continue block5;
                                }
                                default: {
                                    labels[i] = "Soap";
                                    values[i] = "SOAP";
                                }
                            }
                        }
                        de.setValues(values);
                        de.setLabels(labels);
                    }
                } else {
                    de.setValue(serviceBinding.toString());
                    de.setType(DataElementType.HIDDEN);
                }
                de.setSize(this.getSize());
            }
            catch (Exception e) {
                this.logError("Exception: " + e.getMessage(), e);
                throw new DriverControlStationException(e);
            }
        } else {
            de = new DataElement();
            de.setName("serviceBinding");
            de.setLabel("Tipo");
            de.setValue(serviceBinding != null ? serviceBinding.toString() : null);
            de.setType(DataElementType.HIDDEN);
        }
        return de;
    }

    public DataElement getMessageTypeDataElement(String parametroMessageType, IProtocolFactory<?> protocolFactory, org.openspcoop2.message.constants.ServiceBinding serviceBinding, MessageType value) throws DriverControlStationException {
        return this.getMessageTypeDataElement(parametroMessageType, protocolFactory, serviceBinding, value, this.isModalitaStandard());
    }

    public DataElement getMessageTypeDataElement(String parametroMessageType, IProtocolFactory<?> protocolFactory, org.openspcoop2.message.constants.ServiceBinding serviceBinding, MessageType value, boolean hidden) throws DriverControlStationException {
        DataElement de = null;
        try {
            List<MessageType> messageTypeList = this.core.getMessageTypeList(protocolFactory, serviceBinding);
            de = new DataElement();
            de.setName(parametroMessageType);
            de.setLabel("Tipo Messaggio");
            if (!hidden && messageTypeList != null && messageTypeList.size() > 1) {
                de.setSelected(value != null ? value.toString() : null);
                de.setType(DataElementType.SELECT);
                String[] values = new String[messageTypeList.size() + 1];
                String[] labels = new String[messageTypeList.size() + 1];
                labels[0] = "Default";
                values[0] = "D";
                block9: for (int i = 1; i <= messageTypeList.size(); ++i) {
                    MessageType type = messageTypeList.get(i - 1);
                    switch (type) {
                        case BINARY: {
                            labels[i] = "Binary";
                            values[i] = "BINARY";
                            continue block9;
                        }
                        case JSON: {
                            labels[i] = "Json";
                            values[i] = "JSON";
                            continue block9;
                        }
                        case MIME_MULTIPART: {
                            labels[i] = "MIME-Multipart";
                            values[i] = "MIME_MULTIPART";
                            continue block9;
                        }
                        case SOAP_11: {
                            labels[i] = "Soap 1.1";
                            values[i] = "SOAP_11";
                            continue block9;
                        }
                        case SOAP_12: {
                            labels[i] = "Soap 1.2";
                            values[i] = "SOAP_12";
                            continue block9;
                        }
                        default: {
                            labels[i] = "Xml";
                            values[i] = "XML";
                        }
                    }
                }
                de.setValues(values);
                de.setLabels(labels);
            } else {
                de.setValue(value != null ? value.toString() : null);
                de.setType(DataElementType.HIDDEN);
            }
            de.setSize(this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
        return de;
    }

    public DataElement getInterfaceTypeDataElement(TipoOperazione tipoOperazione, IProtocolFactory<?> protocolFactory, org.openspcoop2.message.constants.ServiceBinding serviceBinding, org.openspcoop2.protocol.manifest.constants.InterfaceType value) throws DriverControlStationException {
        DataElement de = null;
        try {
            List<org.openspcoop2.protocol.manifest.constants.InterfaceType> interfaceTypeList = this.core.getInterfaceTypeList(protocolFactory, serviceBinding);
            de = new DataElement();
            de.setName("interfaceType");
            de.setLabel("Formato Specifica");
            switch (tipoOperazione) {
                case ADD: {
                    if (interfaceTypeList != null && interfaceTypeList.size() > 1) {
                        de.setSelected(value != null ? value.toString() : null);
                        de.setType(DataElementType.SELECT);
                        de.setPostBack(true);
                        String[] values = new String[interfaceTypeList.size()];
                        String[] labels = new String[interfaceTypeList.size()];
                        block9: for (int i = 0; i < interfaceTypeList.size(); ++i) {
                            org.openspcoop2.protocol.manifest.constants.InterfaceType type = interfaceTypeList.get(i);
                            switch (type) {
                                case OPEN_API_3: {
                                    labels[i] = "Open API 3";
                                    values[i] = CostantiControlStation.VALUE_PARAMETRO_INTERFACE_TYPE_OPEN_API_3;
                                    continue block9;
                                }
                                case SWAGGER_2: {
                                    labels[i] = "Swagger 2";
                                    values[i] = CostantiControlStation.VALUE_PARAMETRO_INTERFACE_TYPE_SWAGGER_2;
                                    continue block9;
                                }
                                default: {
                                    labels[i] = "Wsdl 1.1";
                                    values[i] = CostantiControlStation.VALUE_PARAMETRO_INTERFACE_TYPE_WSDL_11;
                                }
                            }
                        }
                        de.setValues(values);
                        de.setLabels(labels);
                        break;
                    }
                    de.setValue(value != null ? value.toString() : null);
                    de.setType(DataElementType.HIDDEN);
                    break;
                }
                default: {
                    de.setValue(value != null ? value.toString() : null);
                    de.setType(DataElementType.HIDDEN);
                }
            }
            de.setSize(this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
        return de;
    }

    public boolean porteAppAzioneCheckData(TipoOperazione add, List<String> azioniOccupate, List<MappingErogazionePortaApplicativa> list) throws DriverControlStationException {
        String[] azionis = this.getParameterValues("azioni");
        if (azionis == null || azionis.length == 0) {
            this.pd.setMessage("Deve essere selezionata una Azione");
            return false;
        }
        for (String azione : azionis) {
            if (!azioniOccupate.contains(azione)) continue;
            this.pd.setMessage("L'azione scelta &egrave; gi&agrave; presente");
            return false;
        }
        return this.checkAzioniUtilizzateErogazione(list, azionis);
    }

    public boolean porteDelAzioneCheckData(TipoOperazione add, List<String> azioniOccupate, List<MappingFruizionePortaDelegata> list) throws DriverControlStationException {
        String[] azionis = this.getParameterValues("azioni");
        if (azionis == null || azionis.length == 0) {
            this.pd.setMessage("Deve essere selezionata una Azione");
            return false;
        }
        for (String azione : azionis) {
            if (!azioniOccupate.contains(azione)) continue;
            this.pd.setMessage("L'azione scelta &egrave; gi&agrave; presente");
            return false;
        }
        return this.checkAzioniUtilizzateFruizione(list, azionis);
    }

    public String getMessaggioConfermaModificaRegolaMapping(boolean fromAPI, boolean isDefault, List<String> listaAzioni, org.openspcoop2.message.constants.ServiceBinding serviceBinding, String gruppo, boolean abilitazione, boolean multiline, boolean listElement) throws DriverConfigurazioneException {
        String pre = "<p class=\"contenutoModal\"><span>";
        String post = "</span></p>";
        if (fromAPI) {
            return pre + (abilitazione ? "Procedere con l'abilitazione dell'API ?" : "Procedere con la disabilitazione dell'API ?") + post;
        }
        return pre + (abilitazione ? MessageFormat.format("Procedere con l''abilitazione del gruppo ''{0}''?", gruppo) : MessageFormat.format("Procedere con la disabilitazione del gruppo ''{0}''?", gruppo)) + post;
    }

    public String getLabelAzione(org.openspcoop2.message.constants.ServiceBinding serviceBinding) {
        return org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBinding) ? "Risorsa" : "Azione";
    }

    public String getLabelAzioni(org.openspcoop2.message.constants.ServiceBinding serviceBinding) {
        return org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBinding) ? "Risorse" : "Azioni";
    }

    public String getLabelAzioniDi(org.openspcoop2.message.constants.ServiceBinding serviceBinding) {
        return org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBinding) ? "Risorse di " : "Azioni di ";
    }

    public String getLabelAllAzioniRidefiniteTooltip(org.openspcoop2.message.constants.ServiceBinding serviceBinding) {
        return org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBinding) ? "Tutte le risorse sono state riassegnate" : "Tutte le azioni sono state riassegnate";
    }

    public String getLabelAllAzioniConfigurate(org.openspcoop2.message.constants.ServiceBinding serviceBinding) {
        return org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBinding) ? "Tutti le risorse disponibili sono gi\u00e0 state riassegnate in un gruppo" : "Tutti le azioni disponibili sono gi\u00e0 state riassegnate in un gruppo";
    }

    public List<DataElement> addPorteAzioneToDati(TipoOperazione add, List<DataElement> dati, String string, String[] azioniDisponibiliList, String[] azioniDisponibiliLabelList, String[] azioni, org.openspcoop2.message.constants.ServiceBinding serviceBinding) {
        String label = this.getLabelAzioni(serviceBinding);
        DataElement de = new DataElement();
        de.setLabel(label);
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel(label);
        de.setValues(azioniDisponibiliList);
        de.setLabels(azioniDisponibiliLabelList);
        de.setSelezionati(azioni);
        de.setType(DataElementType.MULTI_SELECT);
        de.setName("azioni");
        de.setRows(15);
        de.setRequired(true);
        dati.add(de);
        return dati;
    }

    public void preparePorteAzioneList(ISearch ricerca, List<String> listaAzioniParamDaPaginare, Integer parentConfigurazione, List<Parameter> lstParametriBreadcrumbs, String objectName, List<Parameter> listaParametriSessione, String labelPerPorta, org.openspcoop2.message.constants.ServiceBinding serviceBinding, AccordoServizioParteComuneSintetico aspc) throws DriverControlStationException {
        try {
            ServletUtils.addListElementIntoSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)objectName, listaParametriSessione);
            String label = this.getLabelAzione(serviceBinding);
            int idLista = -1;
            idLista = "porteDelegateAzione".equals(objectName) ? Liste.PORTE_DELEGATE_AZIONI : Liste.PORTE_APPLICATIVE_AZIONI;
            int limit = ricerca.getPageSize(idLista);
            int offset = ricerca.getIndexIniziale(idLista);
            String search = ServletUtils.getSearchFromSession((ISearch)ricerca, (int)idLista);
            HttpMethod httpMethod = null;
            if (!org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                String filterHttpMethod = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroHttpMethod");
                this.addFilterHttpMethod(filterHttpMethod, false);
                if (filterHttpMethod != null) {
                    httpMethod = HttpMethod.toEnumConstant((String)filterHttpMethod);
                }
            }
            HashMap<Object, ResourceSintetica> mapIdResourceToMethodPath = new HashMap<Object, ResourceSintetica>();
            ArrayList<String> listaAzioniPaginata = new ArrayList<String>();
            if (listaAzioniParamDaPaginare != null && !listaAzioniParamDaPaginare.isEmpty()) {
                int i;
                ArrayList<String> listaAzioniDopoSearch = new ArrayList<String>();
                if (org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                    for (i = 0; i < listaAzioniParamDaPaginare.size(); ++i) {
                        idRisorsa = listaAzioniParamDaPaginare.get(i);
                        if (search != null && !"".equals(search) && !((String)idRisorsa).toLowerCase().contains(search.toLowerCase())) continue;
                        listaAzioniDopoSearch.add((String)idRisorsa);
                    }
                } else {
                    for (i = 0; i < listaAzioniParamDaPaginare.size(); ++i) {
                        idRisorsa = listaAzioniParamDaPaginare.get(i);
                        ResourceSintetica risorsa = null;
                        for (ResourceSintetica resourceSintetica : aspc.getResource()) {
                            if (!resourceSintetica.getNome().equals(idRisorsa)) continue;
                            risorsa = resourceSintetica;
                            break;
                        }
                        if (risorsa == null) {
                            throw new DriverControlStationException("Risorsa con id '" + (String)idRisorsa + "' non esistente ?");
                        }
                        if (search != null && !"".equals(search) && (risorsa.getPath() == null || !risorsa.getPath().toLowerCase().contains(search.toLowerCase())) || httpMethod != null && (risorsa.getMethod() == null || !risorsa.getMethod().equals((Object)httpMethod))) continue;
                        listaAzioniDopoSearch.add((String)idRisorsa);
                        if (risorsa == null) continue;
                        mapIdResourceToMethodPath.put(idRisorsa, risorsa);
                    }
                }
                ricerca.setNumEntries(idLista, listaAzioniDopoSearch.size());
                if (listaAzioniDopoSearch != null && !listaAzioniDopoSearch.isEmpty()) {
                    for (i = 0; i < listaAzioniDopoSearch.size(); ++i) {
                        if (i < offset || i >= offset + limit) continue;
                        listaAzioniPaginata.add((String)listaAzioniDopoSearch.get(i));
                    }
                }
            } else {
                ricerca.setNumEntries(idLista, listaAzioniParamDaPaginare != null ? listaAzioniParamDaPaginare.size() : 0);
            }
            this.pd.setIndex(offset);
            this.pd.setPageSize(limit);
            this.pd.setNumEntries(ricerca.getNumEntries(idLista));
            if (org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                this.pd.setSearchLabel(this.getLabelAzione(serviceBinding));
            } else {
                this.pd.setSearchLabel("Path");
            }
            if (search != null && !search.equals("")) {
                ServletUtils.enabledPageDataSearch((PageData)this.pd, (String)label, (String)search);
            }
            ArrayList<Object> listaAzioni = new ArrayList<Object>();
            HashMap<CallSite, ResourceSintetica> mapToResource = new HashMap<CallSite, ResourceSintetica>();
            for (String azione : listaAzioniPaginata) {
                if (org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                    listaAzioni.add(azione);
                    continue;
                }
                ResourceSintetica risorsa = (ResourceSintetica)mapIdResourceToMethodPath.get(azione);
                String string = (risorsa.getPath() == null ? "*" : risorsa.getPath()) + " " + String.valueOf(risorsa.getMethod() == null ? "ALL" : risorsa.getMethod());
                listaAzioni.add(string);
                mapToResource.put((CallSite)((Object)string), risorsa);
            }
            Collections.sort(listaAzioni);
            lstParametriBreadcrumbs.add(new Parameter(labelPerPorta, null));
            ServletUtils.setPageDataTitle((PageData)this.pd, (Parameter[])lstParametriBreadcrumbs.toArray(new Parameter[lstParametriBreadcrumbs.size()]));
            String[] labels = null;
            labels = org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding) ? new String[]{label} : new String[]{"Method", "Path"};
            this.pd.setLabels(labels);
            ArrayList dati = new ArrayList();
            if (listaAzioni != null) {
                for (String string : listaAzioni) {
                    ArrayList<DataElement> e = new ArrayList<DataElement>();
                    if (org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                        DataElement de = new DataElement();
                        de.setValue(string);
                        de.setIdToRemove(string);
                        e.add(de);
                    } else {
                        ResourceSintetica risorsa = (ResourceSintetica)mapToResource.get(string);
                        String labelParametroApcResourcesHttpMethodQualsiasi = "Qualsiasi";
                        DataElement de = this.getDataElementHTTPMethodResource(risorsa, labelParametroApcResourcesHttpMethodQualsiasi);
                        e.add(de);
                        de = new DataElement();
                        if (risorsa.getPath() == null || "".equals(risorsa.getPath())) {
                            de.setValue("*");
                        } else {
                            de.setValue(risorsa.getPath());
                        }
                        de.setToolTip(risorsa.getNome());
                        de.setIdToRemove(risorsa.getNome());
                        e.add(de);
                    }
                    dati.add(e);
                }
            }
            this.pd.setDati(dati);
            this.pd.setAddButton(true);
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public DataElement getDataElementHTTPMethodResource(ResourceSintetica risorsa, String labelParametroApcResourcesHttpMethodQualsiasi) {
        return this.getDataElementHTTPMethodResource(risorsa.getMethod(), labelParametroApcResourcesHttpMethodQualsiasi, null);
    }

    public DataElement getDataElementHTTPMethodResource(Resource risorsa, String labelParametroApcResourcesHttpMethodQualsiasi, String detailURL) {
        return this.getDataElementHTTPMethodResource(risorsa.getMethod(), labelParametroApcResourcesHttpMethodQualsiasi, detailURL);
    }

    public DataElement getDataElementHTTPMethodResource(HttpMethod httpMethod, String labelParametroApcResourcesHttpMethodQualsiasi, String detailUrl) {
        DataElement de = new DataElement();
        Object styleClass = "resource-method-block resource-method-default";
        if (httpMethod == null) {
            de.setValue(labelParametroApcResourcesHttpMethodQualsiasi);
        } else {
            de.setValue(httpMethod.toString());
            switch (httpMethod) {
                case DELETE: {
                    styleClass = "resource-method-block resource-method-delete";
                    break;
                }
                case GET: {
                    styleClass = "resource-method-block resource-method-get";
                    break;
                }
                case HEAD: {
                    styleClass = "resource-method-block resource-method-head";
                    break;
                }
                case LINK: {
                    styleClass = "resource-method-block resource-method-link";
                    break;
                }
                case OPTIONS: {
                    styleClass = "resource-method-block resource-method-options";
                    break;
                }
                case PATCH: {
                    styleClass = "resource-method-block resource-method-patch";
                    break;
                }
                case POST: {
                    styleClass = "resource-method-block resource-method-post";
                    break;
                }
                case PUT: {
                    styleClass = "resource-method-block resource-method-put";
                    break;
                }
                case TRACE: {
                    styleClass = "resource-method-block resource-method-trace";
                    break;
                }
                case UNLINK: {
                    styleClass = "resource-method-block resource-method-unlink";
                    break;
                }
                default: {
                    styleClass = "resource-method-block resource-method-default";
                }
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)detailUrl)) {
            StringBuilder onClickFunction = new StringBuilder();
            onClickFunction.append("goToLocation('");
            onClickFunction.append(detailUrl);
            onClickFunction.append("')");
            de.setOnClick(onClickFunction.toString());
            styleClass = (String)styleClass + " resource-method-block-pointer";
        }
        de.setLabelStyleClass((String)styleClass);
        de.setWidthPx(75);
        return de;
    }

    public void addFilterServiceBinding(String serviceBinding, boolean postBack, boolean showAPISuffix) throws DriverControlStationException {
        try {
            org.openspcoop2.message.constants.ServiceBinding[] serviceBindings = org.openspcoop2.message.constants.ServiceBinding.values();
            String[] values = new String[serviceBindings.length + 1];
            String[] labels = new String[serviceBindings.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            block5: for (int i = 0; i < serviceBindings.length; ++i) {
                org.openspcoop2.message.constants.ServiceBinding serviceBinding2 = serviceBindings[i];
                switch (serviceBinding2) {
                    case REST: {
                        labels[i + 1] = "Rest";
                        values[i + 1] = "REST".toLowerCase();
                        continue block5;
                    }
                    default: {
                        labels[i + 1] = "Soap";
                        values[i + 1] = "SOAP".toLowerCase();
                    }
                }
            }
            String selectedValue = serviceBinding != null ? serviceBinding : "";
            String label = null;
            label = showAPISuffix ? "Tipo API" : "Tipo";
            this.pd.addFilter("filtroServiceBinding", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterStatoAccordo(String statoAccordo, boolean postBack) throws DriverControlStationException {
        try {
            String[] stati = StatiAccordo.toArray();
            String[] statiLabel = StatiAccordo.toLabel();
            String[] values = new String[stati.length + 1];
            String[] labels = new String[stati.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < stati.length; ++i) {
                labels[i + 1] = statiLabel[i];
                values[i + 1] = stati[i];
            }
            String selectedValue = statoAccordo != null ? statoAccordo : "";
            String label = "Stato";
            this.pd.addFilter("filtroStatoAccordo", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterHttpMethod(String httpMethod, boolean postBack) throws DriverControlStationException {
        try {
            String[] metodi;
            String[] metodiLabel = metodi = HttpMethod.toArray();
            String[] values = new String[metodi.length + 1];
            String[] labels = new String[metodi.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < metodi.length; ++i) {
                labels[i + 1] = metodiLabel[i];
                values[i + 1] = metodi[i];
            }
            String selectedValue = httpMethod != null ? httpMethod : "";
            String label = "HTTP Method";
            this.pd.addFilter("filtroHttpMethod", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterRuoloTipologia(String ruoloTipologia, boolean postBack) throws DriverControlStationException {
        try {
            String[] metodi = new String[]{RuoloTipologia.INTERNO.getValue(), RuoloTipologia.ESTERNO.getValue()};
            String[] metodiLabel = new String[]{"Registro", "Esterna"};
            String[] values = new String[metodi.length + 1];
            String[] labels = new String[metodi.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < metodi.length; ++i) {
                labels[i + 1] = metodiLabel[i];
                values[i + 1] = metodi[i];
            }
            String selectedValue = ruoloTipologia != null ? ruoloTipologia : "";
            String label = "Fonte";
            this.pd.addFilter("filtroRuoloTipologia", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterRuoloContesto(String ruoloContesto, boolean postBack) throws DriverControlStationException {
        try {
            String[] metodi = new String[]{RuoloContesto.PORTA_APPLICATIVA.getValue(), RuoloContesto.PORTA_DELEGATA.getValue()};
            String[] metodiLabel = new String[]{"Erogazione", "Fruizione"};
            String[] values = new String[metodi.length + 1];
            String[] labels = new String[metodi.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < metodi.length; ++i) {
                labels[i + 1] = metodiLabel[i];
                values[i + 1] = metodi[i];
            }
            String selectedValue = ruoloContesto != null ? ruoloContesto : "";
            String label = "Contesto";
            this.pd.addFilter("filtroRuoloContesto", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterScopeTipologia(String scopeTipologia, boolean postBack) throws DriverControlStationException {
        try {
            String[] metodi = new String[]{"interno", "esterno"};
            String[] metodiLabel = new String[]{"Registro", "Esterna"};
            String[] values = new String[metodi.length + 1];
            String[] labels = new String[metodi.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < metodi.length; ++i) {
                labels[i + 1] = metodiLabel[i];
                values[i + 1] = metodi[i];
            }
            String selectedValue = scopeTipologia != null ? scopeTipologia : "";
            String label = "Fonte";
            this.pd.addFilter("filtroScopeTipologia", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterScopeContesto(String scopeContesto, boolean postBack) throws DriverControlStationException {
        try {
            String[] metodi = new String[]{ScopeContesto.PORTA_APPLICATIVA.getValue(), ScopeContesto.PORTA_DELEGATA.getValue()};
            String[] metodiLabel = new String[]{"Erogazione", "Fruizione"};
            String[] values = new String[metodi.length + 1];
            String[] labels = new String[metodi.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < metodi.length; ++i) {
                labels[i + 1] = metodiLabel[i];
                values[i + 1] = metodi[i];
            }
            String selectedValue = scopeContesto != null ? scopeContesto : "";
            String label = "Contesto";
            this.pd.addFilter("filtroScopeContesto", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterDominio(String dominio, boolean postBack) throws DriverControlStationException {
        try {
            String[] sdValues = SoggettiCostanti.getSoggettiDominiValue();
            String[] sdLabels = SoggettiCostanti.getSoggettiDominiLabel();
            String[] values = new String[sdValues.length + 1];
            String[] labels = new String[sdValues.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < sdValues.length; ++i) {
                labels[i + 1] = sdLabels[i];
                values[i + 1] = sdValues[i];
            }
            String selectedValue = dominio != null ? dominio : "";
            this.pd.addFilter("filtroDominio", "Dominio", selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterRuolo(String ruolo, boolean postBack) throws DriverControlStationException {
        try {
            FiltroRicercaRuoli filtroRuoli = new FiltroRicercaRuoli();
            filtroRuoli.setContesto(RuoloContesto.QUALSIASI);
            filtroRuoli.setTipologia(RuoloTipologia.INTERNO);
            List<IDRuolo> listRuoli = this.ruoliCore.getAllIdRuoli(filtroRuoli);
            int length = 1;
            if (listRuoli != null && listRuoli.size() > 0) {
                length += listRuoli.size();
            }
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            if (listRuoli != null && listRuoli.size() > 0) {
                for (int i = 0; i < listRuoli.size(); ++i) {
                    labels[i + 1] = listRuoli.get(i).getNome();
                    values[i + 1] = listRuoli.get(i).getNome();
                }
            }
            this.pd.addFilter("filtroRuolo", "Ruolo", ruolo, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterTipoPolicy(String tipoPolicy, boolean postBack) throws DriverControlStationException {
        try {
            String selectedValue = tipoPolicy != null ? tipoPolicy : "qualsiasi";
            this.pd.addFilter("filtroTipoPolicy", "Tipo", selectedValue, CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_VALORI, CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_LABELS, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterGruppo(String filterProtocollo, String gruppo, boolean postBack) throws DriverControlStationException {
        try {
            boolean isFilterProtocollo = filterProtocollo != null && !"".equals(filterProtocollo);
            List<String> protocolli = this.core.getProtocolli(this.request, this.session);
            if (isFilterProtocollo) {
                protocolli.clear();
                protocolli.add(filterProtocollo);
            }
            FiltroRicercaGruppi filtroGruppi = new FiltroRicercaGruppi();
            filtroGruppi.setProtocolli(protocolli);
            List<IDGruppo> listGruppi = this.gruppiCore.getAllIdGruppi(filtroGruppi);
            int length = 1;
            if (listGruppi != null && listGruppi.size() > 0) {
                length += listGruppi.size();
            }
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            if (listGruppi != null && listGruppi.size() > 0) {
                for (int i = 0; i < listGruppi.size(); ++i) {
                    labels[i + 1] = listGruppi.get(i).getNome();
                    values[i + 1] = listGruppi.get(i).getNome();
                }
            }
            this.pd.addFilter("filtroGruppo", "Tag", gruppo, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterApi(String filterProtocollo, String filterTipoAccordo, String gruppo, String api, boolean postBack) throws DriverControlStationException {
        try {
            boolean isFilterProtocollo = filterProtocollo != null && !"".equals(filterProtocollo);
            List<String> protocolli = this.core.getProtocolli(this.request, this.session);
            if (isFilterProtocollo) {
                protocolli.clear();
                protocolli.add(filterProtocollo);
            }
            FiltroRicercaAccordi filtroRicerca = new FiltroRicercaAccordi();
            filtroRicerca.setOrder(true);
            filtroRicerca.setProtocolli(protocolli);
            if (gruppo != null && !"".equals(gruppo)) {
                IDGruppo idGruppo = new IDGruppo(gruppo);
                filtroRicerca.setIdGruppo(idGruppo);
            }
            if (filterTipoAccordo != null && !"".equals(filterTipoAccordo)) {
                filtroRicerca.setServiceBinding(ServiceBinding.toEnumConstant((String)filterTipoAccordo));
            }
            List<IDAccordo> listAccordi = null;
            try {
                listAccordi = this.apcCore.getAllIdAccordiServizio(filtroRicerca);
            }
            catch (DriverRegistroServiziNotFound notFound) {
                listAccordi = new ArrayList<IDAccordo>();
            }
            int length = 1;
            if (listAccordi != null && listAccordi.size() > 0) {
                length += listAccordi.size();
            }
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            if (listAccordi != null && listAccordi.size() > 0) {
                for (int i = 0; i < listAccordi.size(); ++i) {
                    labels[i + 1] = this.getLabelIdAccordo(listAccordi.get(i));
                    values[i + 1] = IDAccordoFactory.getInstance().getUriFromIDAccordo(listAccordi.get(i));
                }
            }
            this.pd.addFilter("filtroApi", "API", api, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterCanale(CanaliConfigurazione canali, String canale, boolean postBack) throws DriverControlStationException {
        try {
            int length = 1;
            if (canali != null && canali.sizeCanaleList() > 0) {
                length += canali.sizeCanaleList();
            }
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            if (canali != null && canali.sizeCanaleList() > 0) {
                for (int i = 0; i < canali.sizeCanaleList(); ++i) {
                    labels[i + 1] = canali.getCanale(i).getNome();
                    values[i + 1] = canali.getCanale(i).isCanaleDefault() ? "__DEFAULT__ " + canali.getCanale(i).getNome() : canali.getCanale(i).getNome();
                }
            }
            this.pd.addFilter("filtroCanale", "Canale", canale, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterApiContesto(String apiContesto, boolean postBack) throws DriverControlStationException {
        this._addFilterApiContesto(false, false, false, apiContesto, postBack);
    }

    public void addFilterApiContestoRuoli(String apiContesto, boolean postBack) throws DriverControlStationException {
        this._addFilterApiContesto(true, true, false, apiContesto, postBack);
    }

    private void _addFilterApiContesto(boolean soggetti, boolean applicativi, boolean erogazioneFruizione, String apiContesto, boolean postBack) throws DriverControlStationException {
        try {
            int size = 2;
            if (soggetti) {
                ++size;
            }
            if (applicativi) {
                ++size;
            }
            if (erogazioneFruizione) {
                ++size;
            }
            String[] metodi = new String[size];
            int index = 0;
            if (soggetti) {
                metodi[index++] = "Soggetti";
            }
            if (applicativi) {
                metodi[index++] = "Applicativi";
            }
            metodi[index++] = TipoPdD.APPLICATIVA.getTipo();
            metodi[index++] = TipoPdD.DELEGATA.getTipo();
            if (erogazioneFruizione) {
                metodi[index++] = "ErogazioneFruizione";
            }
            String[] metodiLabel = new String[size];
            index = 0;
            if (soggetti) {
                metodiLabel[index++] = "Soggetti";
            }
            if (applicativi) {
                metodiLabel[index++] = "Applicativi";
            }
            metodiLabel[index++] = "Erogazione";
            metodiLabel[index++] = "Fruizione";
            if (erogazioneFruizione) {
                metodi[index++] = "Erogazione/Fruizione";
            }
            String[] values = new String[metodi.length + 1];
            String[] labels = new String[metodi.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < metodi.length; ++i) {
                labels[i + 1] = metodiLabel[i];
                values[i + 1] = metodi[i];
            }
            String selectedValue = apiContesto != null ? apiContesto : "";
            String label = "Riferito in";
            this.pd.addFilter("filtroApiContesto", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterApiImplementazione(String filterProtocollo, String filterSoggetto, String filterGruppo, String filterApiContesto, String apiImplementazione, boolean postBack) throws DriverControlStationException {
        try {
            boolean isFruizione = TipoPdD.DELEGATA.getTipo().equals(filterApiContesto);
            boolean isErogazione = TipoPdD.APPLICATIVA.getTipo().equals(filterApiContesto);
            if (!isErogazione && !isFruizione) {
                return;
            }
            boolean isFilterProtocollo = filterProtocollo != null && !"".equals(filterProtocollo);
            boolean isFilterSoggetto = filterSoggetto != null && !"".equals(filterSoggetto);
            boolean isFilterGruppo = filterGruppo != null && !"".equals(filterGruppo);
            List<String> protocolli = this.core.getProtocolli(this.request, this.session);
            if (isFilterProtocollo) {
                protocolli.clear();
                protocolli.add(filterProtocollo);
            }
            String tipoSoggetto = null;
            String nomeSoggetto = null;
            String protocolloSelezionato = null;
            if (isFilterSoggetto) {
                tipoSoggetto = filterSoggetto.split("/")[0];
                nomeSoggetto = filterSoggetto.split("/")[1];
                protocolloSelezionato = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(tipoSoggetto);
            } else {
                protocolloSelezionato = protocolli.get(0);
            }
            String gruppo = null;
            if (isFilterGruppo) {
                gruppo = filterGruppo;
            }
            ArrayList<String> valuesL = new ArrayList<String>();
            ArrayList<String> labelsL = new ArrayList<String>();
            if (isFruizione) {
                List<IDFruizione> listFruizioni = this.apsCore.getFruizioni(protocolli, gruppo, tipoSoggetto, nomeSoggetto);
                if (listFruizioni != null && !listFruizioni.isEmpty()) {
                    for (IDFruizione idFruizione : listFruizioni) {
                        valuesL.add(idFruizione.toFormatString());
                        if (isFilterSoggetto) {
                            labelsL.add(this.getLabelIdServizio(idFruizione.getIdServizio()));
                            continue;
                        }
                        labelsL.add(this.getLabelServizioFruizione(protocolloSelezionato, idFruizione.getIdFruitore(), idFruizione.getIdServizio()));
                    }
                }
            } else {
                List<IDServizio> listErogazioni = this.apsCore.getErogazioni(protocolli, gruppo, tipoSoggetto, nomeSoggetto);
                if (listErogazioni != null && !listErogazioni.isEmpty()) {
                    for (IDServizio idServizio : listErogazioni) {
                        valuesL.add(idServizio.toFormatString());
                        if (isFilterSoggetto) {
                            labelsL.add(this.getLabelIdServizioSenzaErogatore(idServizio));
                            continue;
                        }
                        labelsL.add(this.getLabelIdServizio(idServizio));
                    }
                }
            }
            String[] values = new String[valuesL.size() + 1];
            String[] labels = new String[labelsL.size() + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < valuesL.size(); ++i) {
                labels[i + 1] = (String)labelsL.get(i);
                values[i + 1] = (String)valuesL.get(i);
            }
            String selectedValue = apiImplementazione != null ? apiImplementazione : "";
            String label = "Implementazione API";
            this.pd.addFilter("filtroApiImpl", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterApplicativo(String filterProtocollo, String filterSoggetto, String applicativo, boolean postBack) throws DriverControlStationException {
        try {
            boolean isFilterProtocollo = filterProtocollo != null && !"".equals(filterProtocollo);
            boolean isFilterSoggetto = filterSoggetto != null && !"".equals(filterSoggetto);
            List<String> protocolli = this.core.getProtocolli(this.request, this.session);
            if (isFilterProtocollo) {
                protocolli.clear();
                protocolli.add(filterProtocollo);
            }
            String filterSoggettoTipo = null;
            String filterSoggettoNome = null;
            String protocolloSelezionato = null;
            if (isFilterSoggetto) {
                filterSoggettoTipo = filterSoggetto.split("/")[0];
                filterSoggettoNome = filterSoggetto.split("/")[1];
                protocolloSelezionato = this.soggettiCore.getProtocolloAssociatoTipoSoggetto(filterSoggettoTipo);
            } else {
                protocolloSelezionato = protocolli.get(0);
            }
            ArrayList<String> valuesL = new ArrayList<String>();
            ArrayList<String> labelsL = new ArrayList<String>();
            List<IDServizioApplicativo> listApplicativi = this.confCore.getServiziApplicativi(null, protocolli, filterSoggettoTipo, filterSoggettoNome);
            if (listApplicativi != null && !listApplicativi.isEmpty()) {
                for (IDServizioApplicativo idApplicativo : listApplicativi) {
                    valuesL.add(idApplicativo.toFormatString());
                    if (isFilterSoggetto) {
                        labelsL.add(idApplicativo.getNome());
                        continue;
                    }
                    labelsL.add(this.getLabelServizioApplicativo(protocolloSelezionato, idApplicativo));
                }
            }
            String[] values = new String[valuesL.size() + 1];
            String[] labels = new String[labelsL.size() + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < valuesL.size(); ++i) {
                labels[i + 1] = (String)labelsL.get(i);
                values[i + 1] = (String)valuesL.get(i);
            }
            String selectedValue = applicativo != null ? applicativo : "";
            String label = "Applicativo";
            this.pd.addFilter("filtroSA", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterTipoCredenziali(String tipo, boolean postBack, boolean autenticazioneToken) throws DriverControlStationException {
        try {
            String[] tmp_labels = autenticazioneToken ? ConnettoriCostanti.CREDENZIALI_CON_TOKEN_LABELS : ConnettoriCostanti.CREDENZIALI_LABELS;
            String[] tmp_values = autenticazioneToken ? ConnettoriCostanti.CREDENZIALI_CON_TOKEN_VALUES : ConnettoriCostanti.CREDENZIALI_VALUES;
            String[] values = new String[tmp_values.length + 1];
            String[] labels = new String[tmp_labels.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < tmp_labels.length; ++i) {
                labels[i + 1] = tmp_labels[i];
                values[i + 1] = tmp_values[i];
            }
            String selectedValue = tipo != null ? tipo : "";
            String label = "Modalit&agrave; di Accesso";
            this.pd.addFilter("filtroTipoCredenziali", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterCredenziale(String tipoCredenziale, String credenziale) throws DriverControlStationException {
        try {
            String label = null;
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(tipoCredenziale)) {
                label = "X.509 Subject";
            } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(tipoCredenziale)) {
                label = "Basic Username";
            } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_PRINCIPAL.equals(tipoCredenziale)) {
                label = "Principal";
            } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_TOKEN.equals(tipoCredenziale)) {
                label = "Identificativo Client";
            }
            if (label != null) {
                this.pd.addTextFilter("filtroCredenziale", label, credenziale, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterCredenzialeIssuer(String tipoCredenziale, String credenziale) throws DriverControlStationException {
        try {
            if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_SSL.equals(tipoCredenziale)) {
                String label = "X.509 Issuer";
                this.pd.addTextFilter("filtroCredenzialeIssuer", label, credenziale, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<String> getTokenPolicyGestione(boolean forcePDND, boolean forceOAuth, boolean addElementNonSelezionatoSeMaggioreUno, String checkTokenPolicyConfigurataPresente, TipoOperazione tipoOperazione) throws DriverConfigurazioneException {
        return this.getTokenPolicy("gestionePolicyToken", forcePDND, forceOAuth, addElementNonSelezionatoSeMaggioreUno, checkTokenPolicyConfigurataPresente, tipoOperazione);
    }

    public List<String> getTokenPolicyNegoziazione(boolean forcePDND, boolean forceOAuth, boolean addElementNonSelezionatoSeMaggioreUno, String checkTokenPolicyConfigurataPresente, TipoOperazione tipoOperazione) throws DriverConfigurazioneException {
        return this.getTokenPolicy("retrievePolicyToken", forcePDND, forceOAuth, addElementNonSelezionatoSeMaggioreUno, checkTokenPolicyConfigurataPresente, tipoOperazione);
    }

    private List<String> getTokenPolicy(String tipologia, boolean forcePDND, boolean forceOAuth, boolean addElementNonSelezionatoSeMaggioreUno, String checkTokenPolicyConfigurataPresente, TipoOperazione tipoOperazione) throws DriverConfigurazioneException {
        List<GenericProperties> gestorePolicyTokenList = this.confCore.gestorePolicyTokenList(null, tipologia, null);
        boolean retrieve = "retrievePolicyToken".equals(tipologia);
        List<String> l = this.filterPolicy(retrieve, gestorePolicyTokenList, forcePDND, forceOAuth);
        ArrayList<String> returnList = new ArrayList<String>();
        if (!l.isEmpty()) {
            boolean forceValueNonSelezionato;
            boolean bl = forceValueNonSelezionato = TipoOperazione.CHANGE.equals((Object)tipoOperazione) && (checkTokenPolicyConfigurataPresente == null || StringUtils.isEmpty((CharSequence)checkTokenPolicyConfigurataPresente) || !l.contains(checkTokenPolicyConfigurataPresente));
            if (addElementNonSelezionatoSeMaggioreUno && l.size() > 1 || forceValueNonSelezionato) {
                returnList.add("-");
            }
            returnList.addAll(l);
        } else if (addElementNonSelezionatoSeMaggioreUno) {
            returnList.add("-");
        }
        return returnList;
    }

    private List<String> filterPolicy(boolean retrieve, List<GenericProperties> gestorePolicyTokenList, boolean forcePDND, boolean forceOAuth) {
        ArrayList<String> policyFiltered = new ArrayList<String>();
        for (int i = 0; i < gestorePolicyTokenList.size(); ++i) {
            GenericProperties genericProperties = gestorePolicyTokenList.get(i);
            String nome = genericProperties.getNome();
            if (forcePDND || forceOAuth) {
                if (retrieve) {
                    this.addFilteredPolicyNegoziazione(genericProperties.getPropertyList(), policyFiltered, nome, forcePDND, forceOAuth);
                    continue;
                }
                this.addFilteredPolicyGestione(policyFiltered, nome, forcePDND, forceOAuth);
                continue;
            }
            policyFiltered.add(nome);
        }
        return policyFiltered;
    }

    private void addFilteredPolicyGestione(List<String> policyFiltered, String nome, boolean forcePDND, boolean forceOAuth) {
        if (this.connettoriCore.isPolicyGestioneTokenPDND(nome)) {
            if (forcePDND) {
                policyFiltered.add(nome);
            }
        } else if (forceOAuth) {
            policyFiltered.add(nome);
        }
    }

    private void addFilteredPolicyNegoziazione(List<Property> gp, List<String> policyFiltered, String nome, boolean forcePDND, boolean forceOAuth) {
        boolean pdnd = false;
        if (gp != null && !gp.isEmpty()) {
            for (Property p : gp) {
                if (!"policy.retrieveToken.jwt.pdnd".equals(p.getNome())) continue;
                pdnd = "true".equalsIgnoreCase(p.getValore());
                break;
            }
        }
        if (pdnd) {
            if (forcePDND) {
                policyFiltered.add(nome);
            }
        } else if (forceOAuth) {
            policyFiltered.add(nome);
        }
    }

    public void addFilterCredenzialeTokenPolicy(String tokenPolicy, boolean postBack) throws DriverControlStationException {
        try {
            List<GenericProperties> gestorePolicyTokenList = this.confCore.gestorePolicyTokenList(null, "gestionePolicyToken", null);
            String[] policyLabels = new String[gestorePolicyTokenList.size() + 1];
            String[] policyValues = new String[gestorePolicyTokenList.size() + 1];
            policyLabels[0] = "Qualsiasi";
            policyValues[0] = "";
            for (int i = 0; i < gestorePolicyTokenList.size(); ++i) {
                GenericProperties genericProperties = gestorePolicyTokenList.get(i);
                policyLabels[i + 1] = genericProperties.getNome();
                policyValues[i + 1] = genericProperties.getNome();
            }
            String selectedValue = tokenPolicy != null ? tokenPolicy : "";
            String label = "Token Policy";
            this.pd.addFilter("filtroCredenzialeTokenPolicy", label, selectedValue, policyValues, policyLabels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterStato(String stato, boolean addStatiAllarme, boolean postBack) throws DriverControlStationException {
        try {
            String[] statiValues = new String[addStatiAllarme ? 5 : 2];
            statiValues[0] = "Abilitato";
            statiValues[1] = "Disabilitato";
            if (addStatiAllarme) {
                statiValues[2] = "Ok";
                statiValues[3] = "Warning";
                statiValues[4] = "Error";
            }
            String[] statiLabel = new String[addStatiAllarme ? 5 : 2];
            statiLabel[0] = "Abilitato";
            statiLabel[1] = "Disabilitato";
            if (addStatiAllarme) {
                statiLabel[2] = "Ok";
                statiLabel[3] = "Warning";
                statiLabel[4] = "Error";
            }
            String[] values = new String[statiValues.length + 1];
            String[] labels = new String[statiValues.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < statiValues.length; ++i) {
                labels[i + 1] = statiLabel[i];
                values[i + 1] = statiValues[i];
            }
            String selectedValue = stato != null ? stato : "";
            String label = "Stato";
            this.pd.addFilter("filtroStato", label, selectedValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public String getLabelTipoRisorsaPolicyAttiva(TipoRisorsaPolicyAttiva tipo) {
        return this.getLabelTipoRisorsaPolicyAttiva(tipo.getValue());
    }

    public String getLabelTipoRisorsaPolicyAttiva(String tipo) {
        String labelRisorsaPolicyAttiva = null;
        for (int j = 0; j < CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_RISORSE_VALORI.length; ++j) {
            if (!CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_RISORSE_VALORI[j].equals(tipo)) continue;
            labelRisorsaPolicyAttiva = CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_RISORSE_LABELS[j];
            break;
        }
        return labelRisorsaPolicyAttiva;
    }

    public void addFilterTipoRisorsaPolicy(List<TipoRisorsaPolicyAttiva> listaTipoRisorsa, String tipoRisorsaPolicy, boolean postBack) throws DriverControlStationException {
        try {
            if (listaTipoRisorsa != null && listaTipoRisorsa.size() > 1) {
                String selectedValue = null;
                selectedValue = tipoRisorsaPolicy != null ? tipoRisorsaPolicy : CostantiControlStation.DEFAULT_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_RISORSA_TIPO_VALUE.getValue();
                ArrayList<String> values = new ArrayList<String>();
                ArrayList<String> labels = new ArrayList<String>();
                for (int j = 0; j < CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_RISORSE_VALORI.length; ++j) {
                    TipoRisorsaPolicyAttiva check = TipoRisorsaPolicyAttiva.toEnumConstant((String)CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_CONTROLLO_TRAFFICO_POLICY_TIPI_RISORSE_VALORI[j]);
                    if (!listaTipoRisorsa.contains(check)) continue;
                    values.add(check.getValue());
                    labels.add(this.getLabelTipoRisorsaPolicyAttiva(check));
                }
                this.pd.addFilter("filtroTipoRisorsaPolicy", "Metrica", selectedValue, values.toArray(new String[1]), labels.toArray(new String[1]), postBack, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void removeFilterTipoRisorsaPolicy() throws DriverControlStationException {
        try {
            this.pd.removeFilter("filtroTipoRisorsaPolicy");
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterTipoTokenPolicy(String tipo, boolean postBack, List<String> nomiConfigurazioniPolicyGestioneToken, List<String> labelConfigurazioniPolicyGestioneToken) throws DriverControlStationException {
        try {
            if (nomiConfigurazioniPolicyGestioneToken != null) {
                int length = nomiConfigurazioniPolicyGestioneToken.size() + 1;
                String[] values = new String[length];
                String[] labels = new String[length];
                labels[0] = "Qualsiasi";
                values[0] = "";
                if (nomiConfigurazioniPolicyGestioneToken != null && nomiConfigurazioniPolicyGestioneToken.size() > 0) {
                    for (int i = 0; i < nomiConfigurazioniPolicyGestioneToken.size(); ++i) {
                        labels[i + 1] = labelConfigurazioniPolicyGestioneToken.get(i);
                        values[i + 1] = nomiConfigurazioniPolicyGestioneToken.get(i);
                    }
                }
                this.pd.addFilter("filtroTipoTokenPolicy", "Tipo", tipo, values, labels, postBack, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void setFilterRuoloServizioApplicativo(ISearch ricerca, int idLista) throws DriverControlStationException {
        if (this.core.isApplicativiServerEnabled(this)) {
            if (Liste.SERVIZIO_APPLICATIVO == idLista || Liste.SERVIZI_APPLICATIVI_BY_SOGGETTO == idLista) {
                ricerca.addFilter(idLista, "filtroTipoSA", "clientORserver");
            }
        } else if (!(this.isModalitaCompleta() || Liste.SERVIZIO_APPLICATIVO != idLista && Liste.SERVIZI_APPLICATIVI_BY_SOGGETTO != idLista)) {
            ricerca.addFilter(idLista, "filtroRuoloSA", "Fruitore");
        }
    }

    public void setFilterSelectedProtocol(ISearch ricerca, int idLista) throws DriverControlStationException {
        List<String> protocolli = null;
        try {
            protocolli = this.core.isUsedByApi() ? ProtocolFactoryManager.getInstance().getProtocolNamesAsList() : this.core.getProtocolli(this.request, this.session);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        if (protocolli != null && protocolli.size() > 0) {
            if (protocolli.size() == 1) {
                ricerca.addFilter(idLista, "filtroProtocollo", protocolli.get(0));
            } else {
                ricerca.addFilter(idLista, "filtroProtocolli", Filtri.convertToString(protocolli));
            }
        }
    }

    public String addFilterProtocol(ISearch ricerca, int idLista) throws DriverControlStationException {
        return this.addFilterProtocol(ricerca, idLista, false);
    }

    public String addFilterProtocol(ISearch ricerca, int idLista, boolean postBack) throws DriverControlStationException {
        List<String> protocolli = null;
        try {
            protocolli = this.core.getProtocolli(this.request, this.session);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        return this._addFilterProtocol(ricerca, idLista, protocolli, postBack);
    }

    public String addFilterProtocol(ISearch ricerca, int idLista, List<String> protocolli) throws DriverControlStationException {
        return this.addFilterProtocol(ricerca, idLista, protocolli, false);
    }

    public String addFilterProtocol(ISearch ricerca, int idLista, List<String> protocolli, boolean postBack) throws DriverControlStationException {
        return this._addFilterProtocol(ricerca, idLista, protocolli, postBack);
    }

    private String _addFilterProtocol(ISearch ricerca, int idLista, List<String> protocolli, boolean postBack) throws DriverControlStationException {
        if (protocolli != null && protocolli.size() > 1) {
            String filterProtocol = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroProtocollo");
            this.addFilterProtocollo(protocolli, filterProtocol, postBack);
            return filterProtocol;
        }
        return null;
    }

    private void addFilterProtocollo(List<String> protocolli, String protocolloSelected, boolean postBack) throws DriverControlStationException {
        try {
            if (protocolli != null && protocolli.size() > 1) {
                String[] values = new String[protocolli.size() + 1];
                String[] labels = new String[protocolli.size() + 1];
                labels[0] = "Qualsiasi";
                values[0] = "";
                for (int i = 0; i < protocolli.size(); ++i) {
                    String protocollo = protocolli.get(i);
                    labels[i + 1] = this.getLabelProtocollo(protocollo);
                    values[i + 1] = protocollo;
                }
                String selectedValue = protocolloSelected != null ? protocolloSelected : "";
                this.pd.addFilter("filtroProtocollo", "Profilo Interoperabilit\u00e0", selectedValue, values, labels, postBack, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterSoggetto(String soggetto, String protocollo, boolean soloSoggettiOperativi, boolean postBack) throws DriverControlStationException {
        try {
            String userLogin = ServletUtils.getUserLoginFromSession((HttpSession)this.session);
            ConsoleSearch searchSoggetti = new ConsoleSearch(true);
            searchSoggetti.addFilter(Liste.SOGGETTI, "filtroProtocollo", protocollo);
            if (soloSoggettiOperativi) {
                searchSoggetti.addFilter(Liste.SOGGETTI, "filtroDominio", SoggettiCostanti.SOGGETTO_DOMINIO_OPERATIVO_VALUE);
            }
            List<Soggetto> listSoggetti = null;
            listSoggetti = this.apsCore.isVisioneOggettiGlobale(userLogin) ? this.soggettiCore.soggettiRegistroList(null, (ISearch)searchSoggetti) : this.soggettiCore.soggettiRegistroList(userLogin, (ISearch)searchSoggetti);
            int length = 1;
            if (listSoggetti != null && listSoggetti.size() > 0) {
                length += listSoggetti.size();
            }
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            if (listSoggetti != null && listSoggetti.size() > 0) {
                for (int i = 0; i < listSoggetti.size(); ++i) {
                    IDSoggetto idSoggetto = new IDSoggetto(listSoggetti.get(i).getTipo(), listSoggetti.get(i).getNome());
                    labels[i + 1] = this.getLabelNomeSoggetto(idSoggetto);
                    values[i + 1] = idSoggetto.toString();
                }
            }
            this.pd.addFilter("filtroSoggetto", "Soggetto", soggetto, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterSoggettoErogatoreStringaLiberaContains(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            String soggettoErogatoreValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroSoggettoErogatoreContains");
            String filterLabel = "Soggetto Erogatore";
            this.pd.addTextFilter("filtroSoggettoErogatoreContains", filterLabel, soggettoErogatoreValue, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterSubtitle(String subtitleName, String subtitleLabel, boolean visualizzaSottosezioneAperta) throws DriverControlStationException {
        try {
            this.pd.addSubtitleFilter(subtitleName, subtitleLabel, visualizzaSottosezioneAperta);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void impostaAperturaSubtitle(String subtitleName) throws DriverControlStationException {
        try {
            this.pd.impostaAperturaSubtitle(subtitleName, null, this.getPostBackElementName());
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void impostaAperturaSubtitle(String subtitleName, boolean visualizzaSottosezioneAperta) throws DriverControlStationException {
        try {
            this.pd.impostaAperturaSubtitle(subtitleName, Boolean.valueOf(visualizzaSottosezioneAperta), this.getPostBackElementName());
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void addFilterHidden(String name, String value) throws DriverControlStationException {
        try {
            this.pd.addHiddenFilter(name, value, this.getSize());
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void addFilterStatoImplementazioneAPI(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            ArrayList<String> statoList = new ArrayList<String>();
            statoList.add("Abilitato");
            statoList.add("Disabilitato");
            int length = statoList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < statoList.size(); ++i) {
                labels[i + 1] = (String)statoList.get(i);
                values[i + 1] = (String)statoList.get(i);
            }
            String statoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneStato");
            this.pd.addFilter("filtroConfigurazioneStato", "Stato", statoValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterTipoAutenticazioneToken(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            List<GenericProperties> gestorePolicyTokenList = this.confCore.gestorePolicyTokenList(null, "gestionePolicyToken", null);
            if (gestorePolicyTokenList.size() > 0) {
                int length = gestorePolicyTokenList.size() + 1;
                String[] values = new String[length];
                String[] labels = new String[length];
                labels[0] = "Qualsiasi";
                values[0] = "";
                for (int i = 0; i < gestorePolicyTokenList.size(); ++i) {
                    GenericProperties genericProperties = gestorePolicyTokenList.get(i);
                    labels[i + 1] = genericProperties.getNome();
                    values[i + 1] = genericProperties.getNome();
                }
                String tokenPolicyValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroAutenticazioneTokenTipo");
                this.pd.addFilter("filtroAutenticazioneTokenTipo", "Autenticazione Token", tokenPolicyValue, values, labels, false, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public String addFilterTipoAutenticazioneTrasporto(ISearch ricerca, int idLista, boolean postBack, boolean modiErogazione, Boolean confPersParam) throws DriverControlStationException {
        String tipoAutenticazioneValue = "";
        try {
            List autenticazioneValues = TipoAutenticazione.getValues();
            List autenticazioneLabels = TipoAutenticazione.getLabels();
            boolean confPers = confPersParam != null && confPersParam != false;
            int length = autenticazioneValues.size() + 1;
            if (confPers) {
                ++length;
            }
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < autenticazioneValues.size(); ++i) {
                labels[i + 1] = (String)autenticazioneLabels.get(i);
                values[i + 1] = (String)autenticazioneValues.get(i);
            }
            if (confPers) {
                values[i + 1] = "custom";
                labels[i + 1] = "plugin";
            }
            tipoAutenticazioneValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroAutenticazioneTrasportoTipo");
            String label = modiErogazione ? "Autenticazione Canale" : "Autenticazione Trasporto";
            this.pd.addFilter("filtroAutenticazioneTrasportoTipo", label, tipoAutenticazioneValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
        return tipoAutenticazioneValue;
    }

    public void addFilterTipoAutenticazioneTrasportoPlugin(ISearch ricerca, int idLista, String tipoAutenticazione, boolean fruizioni) throws DriverControlStationException {
        try {
            if (tipoAutenticazione != null && tipoAutenticazione.equals("custom")) {
                String pluginValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroAutenticazioneTrasportoTipoPlugin");
                String pluginLabel = "";
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                String tipoAutenticazioneCustom = fruizioni ? "Fruizione" : "Erogazione";
                this.addCustomFieldSearchForm(TipoPlugin.AUTENTICAZIONE, tipoAutenticazioneCustom, null, "filtroAutenticazioneTrasportoTipo", "filtroAutenticazioneTrasportoTipoPlugin", pluginLabel, pluginValue, false, dati, false);
                DataElement dataElement = (DataElement)dati.get(0);
                if (dataElement.getValues() != null && dataElement.getValues().length > 0) {
                    this.pd.addFilter("filtroAutenticazioneTrasportoTipoPlugin", pluginLabel, pluginValue, dataElement.getValues(), dataElement.getLabels(), false, this.getSize());
                }
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConfigurazioneRateLimiting(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            ArrayList<String> statoList = new ArrayList<String>();
            statoList.add("Abilitato");
            statoList.add("Disabilitato");
            int length = statoList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < statoList.size(); ++i) {
                labels[i + 1] = (String)statoList.get(i);
                values[i + 1] = (String)statoList.get(i);
            }
            String statoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneRateLimitingStato");
            this.pd.addFilter("filtroConfigurazioneRateLimitingStato", "Rate Limiting", statoValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConfigurazioneValidazione(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            ArrayList<String> statoList = new ArrayList<String>();
            statoList.add("Abilitato");
            statoList.add("Disabilitato");
            int length = statoList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < statoList.size(); ++i) {
                labels[i + 1] = (String)statoList.get(i);
                values[i + 1] = (String)statoList.get(i);
            }
            String statoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneValidazioneStato");
            this.pd.addFilter("filtroConfigurazioneValidazioneStato", "Validazione", statoValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConfigurazioneCacheRisposta(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            ArrayList<String> statoList = new ArrayList<String>();
            statoList.add("Abilitato");
            statoList.add("Disabilitato");
            int length = statoList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < statoList.size(); ++i) {
                labels[i + 1] = (String)statoList.get(i);
                values[i + 1] = (String)statoList.get(i);
            }
            String statoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneCacheRispostaStato");
            this.pd.addFilter("filtroConfigurazioneCacheRispostaStato", "Caching Risposta", statoValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConfigurazioneMessageSecurity(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            ArrayList<String> statoList = new ArrayList<String>();
            statoList.add("Abilitato");
            statoList.add("Abilitato sulla richiesta");
            statoList.add("Abilitato sulla risposta");
            statoList.add("Disabilitato");
            int length = statoList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < statoList.size(); ++i) {
                labels[i + 1] = (String)statoList.get(i);
                values[i + 1] = (String)statoList.get(i);
            }
            String statoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneMessageSecurityStato");
            this.pd.addFilter("filtroConfigurazioneMessageSecurityStato", "Sicurezza Messaggio", statoValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConfigurazioneMTOM(ISearch ricerca, int idLista, String filterTipoAccordo) throws DriverControlStationException {
        try {
            if (filterTipoAccordo == null || "".equals(filterTipoAccordo) || "SOAP".toLowerCase().equals(filterTipoAccordo)) {
                ArrayList<String> statoList = new ArrayList<String>();
                statoList.add("Abilitato");
                statoList.add("Abilitato sulla richiesta");
                statoList.add("Abilitato sulla risposta");
                statoList.add("Disabilitato");
                int length = statoList.size() + 1;
                String[] values = new String[length];
                String[] labels = new String[length];
                labels[0] = "Qualsiasi";
                values[0] = "";
                for (int i = 0; i < statoList.size(); ++i) {
                    labels[i + 1] = (String)statoList.get(i);
                    values[i + 1] = (String)statoList.get(i);
                }
                String statoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneMTOMStato");
                this.pd.addFilter("filtroConfigurazioneMTOMStato", "MTOM", statoValue, values, labels, false, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConfigurazioneTrasformazione(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            ArrayList<String> statoList = new ArrayList<String>();
            statoList.add("Abilitato");
            statoList.add("Disabilitato");
            int length = statoList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < statoList.size(); ++i) {
                labels[i + 1] = (String)statoList.get(i);
                values[i + 1] = (String)statoList.get(i);
            }
            String statoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneTrasformazione");
            this.pd.addFilter("filtroConfigurazioneTrasformazione", "Trasformazione", statoValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public String addFilterConfigurazioneTransazioni(ISearch ricerca, int idLista, boolean postBack) throws DriverControlStationException {
        String configurazioneTransazioniTipoValue = "";
        try {
            ArrayList<String> tipoList = new ArrayList<String>();
            tipoList.add("Default");
            tipoList.add("Ridefinito (abilitato database o filetrace)");
            tipoList.add("Ridefinito (abilitato solo database)");
            tipoList.add("Ridefinito (abilitato solo filetrace)");
            tipoList.add("Ridefinito (abilitato sia database che filetrace)");
            tipoList.add("Ridefinito (disabilitato)");
            int length = tipoList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < tipoList.size(); ++i) {
                labels[i + 1] = (String)tipoList.get(i);
                values[i + 1] = (String)tipoList.get(i);
            }
            configurazioneTransazioniTipoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneTransazioni");
            this.pd.addFilter("filtroConfigurazioneTransazioni", "Tracciamento", configurazioneTransazioniTipoValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
        return configurazioneTransazioniTipoValue;
    }

    public void addFilterConfigurazioneCorrelazioneApplicativa(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            ArrayList<String> statoList = new ArrayList<String>();
            statoList.add("Abilitato");
            statoList.add("Abilitato sulla richiesta");
            statoList.add("Abilitato sulla risposta");
            statoList.add("Disabilitato");
            int length = statoList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < statoList.size(); ++i) {
                labels[i + 1] = (String)statoList.get(i);
                values[i + 1] = (String)statoList.get(i);
            }
            String statoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneCorrelazioneApplicativaStato");
            this.pd.addFilter("filtroConfigurazioneCorrelazioneApplicativaStato", "Correlazione Applicativa", statoValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public String addFilterConfigurazioneTipoDump(ISearch ricerca, int idLista, boolean postBack) throws DriverControlStationException {
        String configurazioneDumpTipoValue = "";
        try {
            ArrayList<String> tipoList = new ArrayList<String>();
            tipoList.add("Default");
            tipoList.add("Ridefinito (abilitato)");
            tipoList.add("Ridefinito (abilitato sulla richiesta)");
            tipoList.add("Ridefinito (abilitato sulla risposta)");
            tipoList.add("Ridefinito (abilitato sulla richiesta in ingresso)");
            tipoList.add("Ridefinito (abilitato sulla richiesta in uscita)");
            tipoList.add("Ridefinito (abilitato sulla risposta in ingresso)");
            tipoList.add("Ridefinito (abilitato sulla risposta in uscita)");
            tipoList.add("Ridefinito (solo header)");
            tipoList.add("Ridefinito (solo header della richiesta)");
            tipoList.add("Ridefinito (solo header della risposta)");
            tipoList.add("Ridefinito (solo header della richiesta in ingresso)");
            tipoList.add("Ridefinito (solo header della richiesta in uscita)");
            tipoList.add("Ridefinito (solo header della risposta in ingresso)");
            tipoList.add("Ridefinito (solo header della risposta in uscita)");
            tipoList.add("Ridefinito (disabilitato)");
            tipoList.add("Ridefinito (disabilitato sulla richiesta)");
            tipoList.add("Ridefinito (disabilitato sulla risposta)");
            int length = tipoList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < tipoList.size(); ++i) {
                labels[i + 1] = (String)tipoList.get(i);
                values[i + 1] = (String)tipoList.get(i);
            }
            configurazioneDumpTipoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneDumpTipo");
            this.pd.addFilter("filtroConfigurazioneDumpTipo", "Registrazione Messaggi", configurazioneDumpTipoValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
        return configurazioneDumpTipoValue;
    }

    public String addFilterConfigurazioneCORS(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            ArrayList<String> statoList = new ArrayList<String>();
            statoList.add("Default");
            statoList.add("Ridefinito (abilitato)");
            statoList.add("Ridefinito (disabilitato)");
            int length = statoList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < statoList.size(); ++i) {
                labels[i + 1] = (String)statoList.get(i);
                values[i + 1] = (String)statoList.get(i);
            }
            String statoValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneCorsTipo");
            this.pd.addFilter("filtroConfigurazioneCorsTipo", "Gestione CORS", statoValue, values, labels, true, this.getSize());
            return statoValue;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConfigurazioneCORSOrigin(ISearch ricerca, int idLista, String gestioneCORS) throws DriverControlStationException {
        try {
            if (gestioneCORS != null && "Ridefinito (abilitato)".equals(gestioneCORS)) {
                String corsOriginValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConfigurazioneCorsOrigin");
                this.pd.addTextFilter("filtroConfigurazioneCorsOrigin", "Allow Origins", corsOriginValue, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public String addFilterTipoConnettore(ISearch ricerca, int idLista, boolean visualizzaVoceIM) throws DriverControlStationException {
        return this.addFilterTipoConnettore(ricerca, idLista, visualizzaVoceIM, true);
    }

    public String addFilterTipoConnettore(ISearch ricerca, int idLista, boolean visualizzaVoceIM, boolean postBack) throws DriverControlStationException {
        String tipoConnettoreValue = "";
        try {
            Boolean confPers;
            List<String> connettoriList = Connettori.getList();
            int indexDisabled = -1;
            for (int i = 0; i < connettoriList.size(); ++i) {
                if (!TipiConnettore.DISABILITATO.getNome().equals(connettoriList.get(i))) continue;
                indexDisabled = i;
                break;
            }
            if (indexDisabled >= 0) {
                connettoriList.remove(indexDisabled);
            }
            if (!connettoriList.contains(TipiConnettore.HTTPS.toString())) {
                connettoriList.add(TipiConnettore.HTTPS.toString());
            }
            if ((confPers = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"ConfigurazioniPersonalizzate")) == null) {
                confPers = this.core != null ? this.core.isShowConfigurazioniPersonalizzate() : true;
            }
            TipologiaConnettori tipologiaConnettori = null;
            try {
                tipologiaConnettori = Utilities.getTipologiaConnettori(this.core);
            }
            catch (Exception e) {
                tipologiaConnettori = TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL;
            }
            if (confPers.booleanValue() && TipologiaConnettori.TIPOLOGIA_CONNETTORI_ALL.equals(tipologiaConnettori)) {
                connettoriList.add(TipiConnettore.CUSTOM.toString());
            }
            ArrayList<String> connettoriListLabels = new ArrayList<String>();
            for (String tipoConnettore : connettoriList) {
                TipiConnettore tipoC = TipiConnettore.toEnumFromName((String)tipoConnettore);
                if (tipoC != null) {
                    connettoriListLabels.add(tipoC.getLabel());
                    continue;
                }
                connettoriListLabels.add(tipoConnettore);
            }
            if (visualizzaVoceIM && this.core.isIntegrationManagerEnabled()) {
                connettoriList.add("IM");
                connettoriListLabels.add("im-message-box");
            }
            int length = connettoriList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < connettoriList.size(); ++i) {
                labels[i + 1] = (String)connettoriListLabels.get(i);
                values[i + 1] = connettoriList.get(i);
            }
            tipoConnettoreValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConnettoreTipo");
            this.pd.addFilter("filtroConnettoreTipo", "Tipo", tipoConnettoreValue, values, labels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
        return tipoConnettoreValue;
    }

    public void addFilterConnettorePlugin(ISearch ricerca, int idLista, String tipoConnettore) throws DriverControlStationException {
        try {
            if (tipoConnettore != null && tipoConnettore.equals(TipiConnettore.CUSTOM.toString())) {
                String pluginValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConnettoreTipoPlugin");
                String pluginLabel = "";
                ArrayList<DataElement> dati = new ArrayList<DataElement>();
                this.addCustomFieldSearchForm(TipoPlugin.CONNETTORE, null, null, "filtroConnettoreTipo", "filtroConnettoreTipoPlugin", pluginLabel, pluginValue, false, dati, false);
                DataElement dataElement = (DataElement)dati.get(0);
                if (dataElement.getValues() != null && dataElement.getValues().length > 0) {
                    this.pd.addFilter("filtroConnettoreTipoPlugin", pluginLabel, pluginValue, dataElement.getValues(), dataElement.getLabels(), false, this.getSize());
                }
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConnettoreTokenPolicy(ISearch ricerca, int idLista, String tipoConnettore) throws DriverControlStationException {
        try {
            List<GenericProperties> gestorePolicyTokenList;
            if (tipoConnettore != null && (tipoConnettore.equals("") || tipoConnettore.equals(TipiConnettore.HTTPS.toString()) || tipoConnettore.equals(TipiConnettore.HTTP.toString())) && (gestorePolicyTokenList = this.confCore.gestorePolicyTokenList(null, "retrievePolicyToken", null)).size() > 0) {
                int length = gestorePolicyTokenList.size() + 1;
                String[] values = new String[length];
                String[] labels = new String[length];
                labels[0] = "Qualsiasi";
                values[0] = "";
                for (int i = 0; i < gestorePolicyTokenList.size(); ++i) {
                    GenericProperties genericProperties = gestorePolicyTokenList.get(i);
                    labels[i + 1] = genericProperties.getNome();
                    values[i + 1] = genericProperties.getNome();
                }
                String tokenPolicyValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConnettoreTokenPolicy");
                this.pd.addFilter("filtroConnettoreTokenPolicy", "Token Policy", tokenPolicyValue, values, labels, false, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConnettoreEndpoint(ISearch ricerca, int idLista, String tipoConnettore) throws DriverControlStationException {
        try {
            if (tipoConnettore != null && (tipoConnettore.equals("") || tipoConnettore.equals(TipiConnettore.HTTPS.toString()) || tipoConnettore.equals(TipiConnettore.HTTP.toString()) || tipoConnettore.equals(TipiConnettore.JMS.toString()) || tipoConnettore.equals(TipiConnettore.FILE.toString()))) {
                String endpointValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConnettoreEndpoint");
                String filterLabel = "Endpoint";
                if (tipoConnettore.equals(TipiConnettore.JMS.toString())) {
                    filterLabel = "Parametri Jms";
                }
                if (tipoConnettore.equals(TipiConnettore.FILE.toString())) {
                    filterLabel = "File";
                }
                this.pd.addTextFilter("filtroConnettoreEndpoint", filterLabel, endpointValue, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConnettoreKeystore(ISearch ricerca, int idLista, String tipoConnettore) throws DriverControlStationException {
        try {
            if (tipoConnettore != null && tipoConnettore.equals(TipiConnettore.HTTPS.toString())) {
                String keystoreValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConnettoreKeystore");
                String filterLabel = "Keystore";
                this.pd.addTextFilter("filtroConnettoreKeystore", filterLabel, keystoreValue, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterConnettoreDebug(ISearch ricerca, int idLista, String tipoConnettore) throws DriverControlStationException {
        try {
            ArrayList<String> connettoriList = new ArrayList<String>();
            connettoriList.add("Abilitato");
            connettoriList.add("Disabilitato");
            int length = connettoriList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < connettoriList.size(); ++i) {
                labels[i + 1] = (String)connettoriList.get(i);
                values[i + 1] = (String)connettoriList.get(i);
            }
            String debugValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConnettoreDebug");
            this.pd.addFilter("filtroConnettoreDebug", "Debug", debugValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public String addFilterNomeConnettoreMultiplo(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            String nomeValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConnettoreMulNome");
            String filterLabel = "Nome";
            this.pd.addTextFilter("filtroConnettoreMulNome", filterLabel, nomeValue, this.getSize());
            return nomeValue;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterFiltroConnettoreMultiplo(ISearch ricerca, int idLista, boolean behaviourConFiltri) throws DriverControlStationException {
        try {
            if (behaviourConFiltri) {
                String filtroValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroConnettoreMulFiltro");
                String filterLabel = "Filtro";
                this.pd.addTextFilter("filtroConnettoreMulFiltro", filterLabel, filtroValue, this.getSize());
            }
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModIKeystorePath(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            String keystorePathValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiKeystorePath");
            String filterPathLabel = "KeyStore Path";
            this.pd.addTextFilter("filtroModiKeystorePath", filterPathLabel, keystorePathValue, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModIKeystoreSubject(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            String keystoreSubjectValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiKeystoreSubject");
            String filterSubjectLabel = "X.509 Subject";
            this.pd.addTextFilter("filtroModiKeystoreSubject", filterSubjectLabel, keystoreSubjectValue, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModIKeystoreIssuer(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            String keystoreIssuerValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiKeystoreIssuer");
            String filterIssuerLabel = "X.509 Issuer";
            this.pd.addTextFilter("filtroModiKeystoreIssuer", filterIssuerLabel, keystoreIssuerValue, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModITokenPolicy(ISearch ricerca, int idLista, boolean postBack) throws DriverControlStationException {
        try {
            List<GenericProperties> gestorePolicyTokenList = this.confCore.gestorePolicyTokenList(null, "gestionePolicyToken", null);
            String[] policyLabels = new String[gestorePolicyTokenList.size() + 1];
            String[] policyValues = new String[gestorePolicyTokenList.size() + 1];
            policyLabels[0] = "Qualsiasi";
            policyValues[0] = "";
            for (int i = 0; i < gestorePolicyTokenList.size(); ++i) {
                GenericProperties genericProperties = gestorePolicyTokenList.get(i);
                policyLabels[i + 1] = genericProperties.getNome();
                policyValues[i + 1] = genericProperties.getNome();
            }
            String tokenPolicyValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiTokenPolicy");
            String selectedValue = tokenPolicyValue != null ? tokenPolicyValue : "";
            String label = "Token Policy";
            this.pd.addFilter("filtroModiTokenPolicy", label, selectedValue, policyValues, policyLabels, postBack, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModITokenClientId(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            String tokenClientIdValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiTokenClientId");
            String tokenClientIdLabel = "Token ClientId";
            this.pd.addTextFilter("filtroModiTokenClientId", tokenClientIdLabel, tokenClientIdValue, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModIAudience(ISearch ricerca, int idLista, boolean applicativi, String filterTipoAccordo, String filterDominio) throws DriverControlStationException {
        try {
            String audienceValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiAudience");
            String filterLabel = null;
            filterLabel = applicativi ? (SoggettiCostanti.SOGGETTO_DOMINIO_ESTERNO_VALUE.equals(filterDominio) ? "Reply Audience/WSA-To" : "Authorization ModI ClientId") : ("REST".toLowerCase().equals(filterTipoAccordo) ? "Audience" : ("SOAP".toLowerCase().equals(filterTipoAccordo) ? "WSAddressing To" : "Audience/WSA-To"));
            this.pd.addTextFilter("filtroModiAudience", filterLabel, audienceValue, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModISicurezzaCanale(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            List<String> labelsList = this.getProfiloModIPAFiltroSicurezzaCanaleLabels();
            List<String> valuesList = this.getProfiloModIPAFiltroSicurezzaCanaleValues();
            int length = valuesList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < valuesList.size(); ++i) {
                labels[i + 1] = labelsList.get(i);
                values[i + 1] = valuesList.get(i);
            }
            String sicurezzaCanaleValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiSicCanale");
            this.pd.addFilter("filtroModiSicCanale", "Sicurezza Canale", sicurezzaCanaleValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModISicurezzaMessaggio(ISearch ricerca, int idLista, String serviceBindingValue) throws DriverControlStationException {
        try {
            List<String> labelsList = this.getProfiloModIPAFiltroSicurezzaMessaggioLabels(serviceBindingValue);
            List<String> valuesList = this.getProfiloModIPAFiltroSicurezzaMessaggioValues(serviceBindingValue);
            int length = valuesList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < valuesList.size(); ++i) {
                labels[i + 1] = labelsList.get(i);
                values[i + 1] = valuesList.get(i);
            }
            String sicurezzaCanaleValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiSicMessaggio");
            this.pd.addFilter("filtroModiSicMessaggio", "Sicurezza Messaggio", sicurezzaCanaleValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModIGenerazioneToken(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            String[] v = new String[]{"locale", "pdnd", "oauth"};
            List<String> valuesList = Arrays.asList(v);
            String[] l = new String[]{"Authorization ModI", "Authorization PDND", "Authorization OAuth"};
            List<String> labelsList = Arrays.asList(l);
            int length = valuesList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < valuesList.size(); ++i) {
                labels[i + 1] = labelsList.get(i);
                values[i + 1] = valuesList.get(i);
            }
            String generazioneTokenValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiGenToken");
            this.pd.addFilter("filtroModiGenToken", "Generazione Token", generazioneTokenValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public String addFilterModISicurezzaMessaggioSA(ISearch ricerca, int idLista, boolean postback) throws DriverControlStationException {
        try {
            String[] valueAbilitatoOnly = new String[]{StatoFunzionalita.ABILITATO.getValue()};
            List<String> valuesList = Arrays.asList(valueAbilitatoOnly);
            int length = valuesList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < valuesList.size(); ++i) {
                labels[i + 1] = valuesList.get(i);
                values[i + 1] = valuesList.get(i);
            }
            String sicurezzaMessaggioValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiSicMessaggio");
            this.pd.addFilter("filtroModiSicMessaggio", "Certificato", sicurezzaMessaggioValue, values, labels, postback, this.getSize());
            return sicurezzaMessaggioValue;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public String addFilterModISicurezzaTokenSA(ISearch ricerca, int idLista, boolean postback) throws DriverControlStationException {
        try {
            String[] valueAbilitatoOnly = new String[]{StatoFunzionalita.ABILITATO.getValue()};
            List<String> valuesList = Arrays.asList(valueAbilitatoOnly);
            int length = valuesList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < valuesList.size(); ++i) {
                labels[i + 1] = valuesList.get(i);
                values[i + 1] = valuesList.get(i);
            }
            String sicurezzaMessaggioValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiTokenStato");
            this.pd.addFilter("filtroModiTokenStato", "Authorization OAuth", sicurezzaMessaggioValue, values, labels, postback, this.getSize());
            return sicurezzaMessaggioValue;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModIDigestRichiesta(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            String[] valueAbilitatoOnly = new String[]{StatoFunzionalita.ABILITATO.getValue()};
            List<String> valuesList = Arrays.asList(valueAbilitatoOnly);
            int length = valuesList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < valuesList.size(); ++i) {
                labels[i + 1] = valuesList.get(i);
                values[i + 1] = valuesList.get(i);
            }
            String digestRichiestaValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiDigestRich");
            this.pd.addFilter("filtroModiDigestRich", "Digest Richiesta", digestRichiestaValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterModIInfoUtente(ISearch ricerca, int idLista) throws DriverControlStationException {
        try {
            String[] v = new String[]{"audit01", "audit02", "old"};
            List<String> valuesList = Arrays.asList(v);
            String[] l = new String[]{"AUDIT_REST_01", "AUDIT_REST_02", "AUDIT_LEGACY"};
            List<String> labelsList = Arrays.asList(l);
            int length = valuesList.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < valuesList.size(); ++i) {
                labels[i + 1] = labelsList.get(i);
                values[i + 1] = valuesList.get(i);
            }
            String infoUtenteValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroModiInfoUtente");
            this.pd.addFilter("filtroModiInfoUtente", "Informazioni Audit", infoUtenteValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<String> getProfiloModIPAFiltroSicurezzaCanaleValues() {
        try {
            ArrayList<String> values = new ArrayList<String>();
            values.add("idac01");
            values.add("idac02");
            return values;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public List<String> getProfiloModIPAFiltroSicurezzaCanaleLabels() {
        ArrayList<String> labels = null;
        try {
            labels = new ArrayList<String>();
            labels.add("ID_AUTH_CHANNEL_01");
            labels.add("ID_AUTH_CHANNEL_02");
            return labels;
        }
        catch (Exception t) {
            return labels;
        }
    }

    public List<String> getProfiloModIPAFiltroSicurezzaMessaggioValues(String serviceBindingValue) {
        ArrayList<String> values = null;
        try {
            values = new ArrayList<String>();
            values.add("idam01");
            values.add("idam02");
            values.add("idam0301");
            values.add("idam0302");
            if ("REST".toLowerCase().equals(serviceBindingValue) || !"SOAP".toLowerCase().equals(serviceBindingValue)) {
                values.add("idam0401");
                values.add("idam0402");
            }
            return values;
        }
        catch (Exception t) {
            return values;
        }
    }

    public List<String> getProfiloModIPAFiltroSicurezzaMessaggioLabels(String serviceBindingValue) {
        ArrayList<String> labels = null;
        try {
            labels = new ArrayList<String>();
            if ("REST".toLowerCase().equals(serviceBindingValue)) {
                labels.add("ID_AUTH_REST_01");
                labels.add("ID_AUTH_REST_02");
                labels.add("INTEGRITY_REST_01 con ID_AUTH_REST_01");
                labels.add("INTEGRITY_REST_01 con ID_AUTH_REST_02");
                labels.add("INTEGRITY_REST_02 con ID_AUTH_REST_01");
                labels.add("INTEGRITY_REST_02 con ID_AUTH_REST_02");
            } else if ("SOAP".toLowerCase().equals(serviceBindingValue)) {
                labels.add("ID_AUTH_SOAP_01");
                labels.add("ID_AUTH_SOAP_02");
                labels.add("INTEGRITY_SOAP_01 con ID_AUTH_SOAP_01");
                labels.add("INTEGRITY_SOAP_01 con ID_AUTH_SOAP_02");
            } else {
                labels.add("ID_AUTH_01");
                labels.add("ID_AUTH_02");
                labels.add("INTEGRITY_01 con ID_AUTH_01");
                labels.add("INTEGRITY_01 con ID_AUTH_02");
                labels.add("INTEGRITY_02 con ID_AUTH_01");
                labels.add("INTEGRITY_02 con ID_AUTH_02");
            }
            return labels;
        }
        catch (Exception t) {
            return labels;
        }
    }

    public void addFilterProprietaNome(ISearch ricerca, int idLista, List<String> nomiProprieta) throws DriverControlStationException {
        try {
            int length = nomiProprieta.size() + 1;
            String[] values = new String[length];
            String[] labels = new String[length];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < nomiProprieta.size(); ++i) {
                labels[i + 1] = nomiProprieta.get(i);
                values[i + 1] = nomiProprieta.get(i);
            }
            String nomeProprietaValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroPropNome");
            this.pd.addFilter("filtroPropNome", "Nome", nomeProprietaValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addFilterProprietaValore(ISearch ricerca, int idLista, List<String> nomiProprieta) throws DriverControlStationException {
        try {
            String valoreProprietaValue = SearchUtils.getFilter((ISearch)ricerca, (int)idLista, (String)"filtroPropValore");
            String filterLabel = "Valore";
            this.pd.addTextFilter("filtroPropValore", filterLabel, valoreProprietaValue, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<String> getLabelsProtocolli(List<String> protocolli) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelsProtocolli(protocolli);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelProtocollo(String protocollo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelProtocollo((String)protocollo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public static String _getLabelProtocollo(String protocollo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelProtocollo((String)protocollo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getDescrizioneProtocollo(String protocollo) throws DriverControlStationException {
        try {
            return NamingUtils.getDescrizioneProtocollo((String)protocollo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getWebSiteProtocollo(String protocollo) throws DriverControlStationException {
        try {
            return NamingUtils.getWebSiteProtocollo((String)protocollo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelNomeSoggetto(IDSoggetto idSoggetto) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelSoggetto((IDSoggetto)idSoggetto);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public static String _getLabelNomeSoggetto(IDSoggetto idSoggetto) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelSoggetto((IDSoggetto)idSoggetto);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelNomeSoggetto(String protocollo, IDSoggetto idSoggetto) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelSoggetto((String)protocollo, (IDSoggetto)idSoggetto);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelNomeSoggetto(String protocollo, String tipoSoggetto, String nomeSoggetto) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelSoggetto((String)protocollo, (String)tipoSoggetto, (String)nomeSoggetto);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelServizioApplicativo((IDServizioApplicativo)idServizioApplicativo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelServizioApplicativo(String protocollo, IDServizioApplicativo idServizioApplicativo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelServizioApplicativo((String)protocollo, (IDServizioApplicativo)idServizioApplicativo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelServizioApplicativoConDominioSoggetto(IDServizioApplicativo idServizioApplicativo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelServizioConDominioErogatore((String)idServizioApplicativo.getNome(), (String)NamingUtils.getLabelSoggetto((IDSoggetto)idServizioApplicativo.getIdSoggettoProprietario()));
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelServizioApplicativoConDominioSoggetto(String protocollo, IDServizioApplicativo idServizioApplicativo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelServizioConDominioErogatore((String)idServizioApplicativo.getNome(), (String)NamingUtils.getLabelSoggetto((String)protocollo, (IDSoggetto)idServizioApplicativo.getIdSoggettoProprietario()));
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdAccordo(AccordoServizioParteComune as) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteComune((AccordoServizioParteComune)as);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdAccordo(AccordoServizioParteComuneSintetico as) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteComune((AccordoServizioParteComuneSintetico)as);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdAccordo(IDAccordo idAccordo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteComune((IDAccordo)idAccordo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdAccordo(String protocollo, IDAccordo idAccordo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteComune((String)protocollo, (IDAccordo)idAccordo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdAccordoSenzaReferente(String protocollo, IDAccordo idAccordo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteComune((String)protocollo, (IDAccordo)idAccordo, (boolean)false);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelNomeServizio(String protocollo, String tipoServizio, String nomeServizio, Integer versioneInt) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)protocollo, (String)tipoServizio, (String)nomeServizio, (Integer)versioneInt);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdServizio(AccordoServizioParteSpecifica as) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteSpecifica((AccordoServizioParteSpecifica)as);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdServizio(IDServizio idServizio) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteSpecifica((IDServizio)idServizio);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdServizio(String protocollo, IDServizio idServizio) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteSpecifica((String)protocollo, (IDServizio)idServizio);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdServizioSenzaErogatore(String protocollo, IDServizio idServizio) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((String)protocollo, (IDServizio)idServizio);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdServizioSenzaErogatore(IDServizio idServizio) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoServizioParteSpecificaSenzaErogatore((IDServizio)idServizio);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelServizioFruizione(String protocollo, IDSoggetto idSoggettoFruitore, AccordoServizioParteSpecifica asps) throws DriverControlStationException {
        try {
            return this.getLabelServizioFruizione(protocollo, idSoggettoFruitore, this.idServizioFactory.getIDServizioFromAccordo(asps));
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelServizioFruizione(String protocollo, IDSoggetto idSoggettoFruitore, IDServizio idServizio) throws DriverControlStationException {
        boolean showSoggettoFruitoreInFruizioni;
        String servizio = this.getLabelIdServizioSenzaErogatore(protocollo, idServizio);
        String soggetto = this.getLabelNomeSoggetto(protocollo, idServizio.getSoggettoErogatore());
        String labelServizio = NamingUtils.getLabelServizioConDominioErogatore((String)servizio, (String)soggetto);
        boolean bl = showSoggettoFruitoreInFruizioni = this.core.isMultitenant() && !this.isSoggettoMultitenantSelezionato();
        if (showSoggettoFruitoreInFruizioni) {
            String labelFruitore = this.getLabelNomeSoggetto(protocollo, idSoggettoFruitore);
            return labelFruitore + " -> " + labelServizio;
        }
        return labelServizio;
    }

    public String getLabelServizioErogazione(String protocollo, AccordoServizioParteSpecifica asps) throws DriverControlStationException {
        try {
            return this.getLabelServizioErogazione(protocollo, this.idServizioFactory.getIDServizioFromAccordo(asps));
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelServizioErogazione(String protocollo, IDServizio idServizio) throws DriverControlStationException {
        boolean showSoggettoErogatoreInErogazioni;
        boolean bl = showSoggettoErogatoreInErogazioni = this.core.isMultitenant() && !this.isSoggettoMultitenantSelezionato();
        if (showSoggettoErogatoreInErogazioni) {
            String servizio = this.getLabelIdServizioSenzaErogatore(protocollo, idServizio);
            String soggetto = this.getLabelNomeSoggetto(protocollo, idServizio.getSoggettoErogatore());
            return NamingUtils.getLabelServizioConDominioErogatore((String)servizio, (String)soggetto);
        }
        return this.getLabelIdServizioSenzaErogatore(protocollo, idServizio);
    }

    public String getLabelServizio(IDSoggetto idSoggettoFruitore, boolean gestioneFruitori, IDServizio idServizio, String tipoProtocollo) throws DriverControlStationException {
        String labelServizio = null;
        labelServizio = gestioneFruitori ? this.getLabelServizioFruizione(tipoProtocollo, idSoggettoFruitore, idServizio) : this.getLabelServizioErogazione(tipoProtocollo, idServizio);
        return labelServizio;
    }

    public String getLabelServizio(IDSoggetto idSoggettoFruitore, boolean gestioneFruitori, AccordoServizioParteSpecifica asps, String tipoProtocollo) throws DriverControlStationException {
        String labelServizio = null;
        labelServizio = gestioneFruitori ? this.getLabelServizioFruizione(tipoProtocollo, idSoggettoFruitore, asps) : this.getLabelServizioErogazione(tipoProtocollo, asps);
        return labelServizio;
    }

    public String getLabelIdAccordoCooperazione(AccordoCooperazione ac) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoCooperazione((AccordoCooperazione)ac);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdAccordoCooperazione(IDAccordoCooperazione idAccordo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoCooperazione((IDAccordoCooperazione)idAccordo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public String getLabelIdAccordoCooperazione(String protocollo, IDAccordoCooperazione idAccordo) throws DriverControlStationException {
        try {
            return NamingUtils.getLabelAccordoCooperazione((String)protocollo, (IDAccordoCooperazione)idAccordo);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public void validazioneContenuti(TipoOperazione tipoOperazione, List<DataElement> dati, boolean isPortaDelegata, String xsd, String tipoValidazione, String applicaMTOM, org.openspcoop2.message.constants.ServiceBinding serviceBinding, FormatoSpecifica formatoSpecifica) throws DriverControlStationException {
        this.validazioneContenuti(tipoOperazione, dati, true, isPortaDelegata, xsd, tipoValidazione, applicaMTOM, serviceBinding, formatoSpecifica);
    }

    public void validazioneContenuti(TipoOperazione tipoOperazione, List<DataElement> dati, boolean addSezione, boolean isPortaDelegata, String xsd, String tipoValidazione, String applicaMTOM, org.openspcoop2.message.constants.ServiceBinding serviceBinding, FormatoSpecifica formatoSpecifica) {
        DataElement de = new DataElement();
        if (addSezione) {
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Validazione");
            dati.add(de);
        }
        String[] tipoXsd = new String[]{CostantiControlStation.DEFAULT_VALUE_PARAMETRO_PORTE_VALIDAZIONE_ABILITATO, CostantiControlStation.DEFAULT_VALUE_PARAMETRO_PORTE_VALIDAZIONE_DISABILITATO, CostantiControlStation.DEFAULT_VALUE_PARAMETRO_PORTE_VALIDAZIONE_WARNING_ONLY};
        de = new DataElement();
        de.setLabel("Stato");
        de.setType(DataElementType.SELECT);
        de.setName("xsd");
        de.setValues(tipoXsd);
        de.setPostBack(true);
        de.setSelected(xsd);
        dati.add(de);
        if (CostantiControlStation.DEFAULT_VALUE_PARAMETRO_PORTE_VALIDAZIONE_ABILITATO.equals(xsd) || CostantiControlStation.DEFAULT_VALUE_PARAMETRO_PORTE_VALIDAZIONE_WARNING_ONLY.equals(xsd)) {
            ArrayList<String> tipiValidazione = new ArrayList<String>();
            tipiValidazione.add(CostantiControlStation.DEFAULT_VALUE_PARAMETRO_PORTE_TIPO_VALIDAZIONE_INTERFACE);
            tipiValidazione.add(CostantiControlStation.DEFAULT_VALUE_PARAMETRO_PORTE_TIPO_VALIDAZIONE_XSD);
            if (!this.isModalitaStandard()) {
                tipiValidazione.add(CostantiControlStation.DEFAULT_VALUE_PARAMETRO_PORTE_TIPO_VALIDAZIONE_OPENSPCOOP);
            }
            ArrayList<String> labelTipiValidazione = new ArrayList<String>();
            switch (formatoSpecifica) {
                case OPEN_API_3: {
                    labelTipiValidazione.add("Open API 3");
                    break;
                }
                case SWAGGER_2: {
                    labelTipiValidazione.add("Swagger 2");
                    break;
                }
                case WSDL_11: {
                    labelTipiValidazione.add("Wsdl 1.1");
                }
            }
            labelTipiValidazione.add("Schemi XSD");
            if (!this.isModalitaStandard()) {
                labelTipiValidazione.add("Registro API");
            }
            de = new DataElement();
            de.setLabel("Tipo");
            de.setName("tipo_validazione");
            if (CostantiControlStation.DEFAULT_VALUE_PARAMETRO_PORTE_TIPO_VALIDAZIONE_OPENSPCOOP.equals(tipoValidazione) && this.isModalitaStandard()) {
                de.setType(DataElementType.HIDDEN);
                de.setValue(tipoValidazione);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(tipiValidazione);
                de.setLabels(labelTipiValidazione);
                de.setSelected(tipoValidazione);
            }
            dati.add(de);
            if (CostantiControlStation.DEFAULT_VALUE_PARAMETRO_PORTE_TIPO_VALIDAZIONE_OPENSPCOOP.equals(tipoValidazione) && this.isModalitaStandard()) {
                de = new DataElement();
                de.setLabel("Tipo");
                de.setName("tipo_validazione__label");
                de.setType(DataElementType.TEXT);
                de.setValue("Registro API");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Accetta MTOM");
            if (org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding)) {
                de.setType(DataElementType.CHECKBOX);
                if (ServletUtils.isCheckBoxEnabled((String)applicaMTOM) || CostantiRegistroServizi.ABILITATO.equals(applicaMTOM)) {
                    de.setSelected(true);
                }
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(applicaMTOM);
            }
            de.setName("applicaMTOMReq");
            dati.add(de);
        }
    }

    public boolean validazioneContenutiCheck(TipoOperazione tipoOperazione, boolean isPortaDelegata) throws DriverControlStationException {
        String xsd = this.getParameter("xsd");
        if (!(xsd.equals("abilitato") || xsd.equals("disabilitato") || xsd.equals("warningOnly"))) {
            this.pd.setMessage("Validazione XSD dev'essere abilitato, disabilitato o warningOnly");
            return false;
        }
        return true;
    }

    public void addFilterAzione(Map<String, String> azioni, String azione, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws DriverControlStationException {
        String[] azioniDisponibiliList = new String[]{};
        String[] azioniDisponibiliLabelList = new String[]{};
        if (azioni != null && azioni.size() > 0) {
            azioniDisponibiliList = new String[azioni.size()];
            azioniDisponibiliLabelList = new String[azioni.size()];
            int i = 0;
            Iterator<String> iterator = azioni.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                azioniDisponibiliList[i] = string = iterator.next();
                azioniDisponibiliLabelList[i] = azioni.get(string);
                if ("Qualsiasi".equals(azioniDisponibiliLabelList[i])) {
                    azioniDisponibiliLabelList[i] = "Method e Path Qualsiasi";
                }
                ++i;
            }
        }
        this.addFilterAzione(azioniDisponibiliList, azioniDisponibiliLabelList, azione, serviceBinding);
    }

    public void addFilterAzione(String[] azioni, String[] azioniLabels, String azione, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws DriverControlStationException {
        try {
            String[] values = new String[azioni.length + 1];
            String[] labels = new String[azioni.length + 1];
            labels[0] = "Qualsiasi";
            values[0] = "";
            for (int i = 0; i < azioni.length; ++i) {
                labels[i + 1] = azioniLabels[i];
                values[i + 1] = azioni[i];
            }
            String selectedValue = StringUtils.isNotEmpty((CharSequence)azione) ? azione : "";
            this.pd.addFilter("filtroAzione", this.getLabelAzione(serviceBinding), selectedValue, values, labels, false, this.getSize());
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public void addConfigurazioneDumpToDati(TipoOperazione tipoOperazione, List<DataElement> dati, boolean showStato, String statoDump, boolean showRealtime, String realtime, String statoDumpRichiesta, String statoDumpRisposta, String dumpRichiestaIngressoHeader, String dumpRichiestaIngressoPayload, String dumpRichiestaIngressoPayloadParsing, String dumpRichiestaIngressoBody, String dumpRichiestaIngressoAttachments, String dumpRichiestaUscitaHeader, String dumpRichiestaUscitaPayload, String dumpRichiestaUscitaPayloadParsing, String dumpRichiestaUscitaBody, String dumpRichiestaUscitaAttachments, String dumpRispostaIngressoHeader, String dumpRispostaIngressoPayload, String dumpRispostaIngressoPayloadParsing, String dumpRispostaIngressoBody, String dumpRispostaIngressoAttachments, String dumpRispostaUscitaHeader, String dumpRispostaUscitaPayload, String dumpRispostaUscitaPayloadParsing, String dumpRispostaUscitaBody, String dumpRispostaUscitaAttachments, boolean portaApplicativa) throws DriverControlStationException {
        DataElement de = new DataElement();
        de.setName("dumpConfigType");
        de.setType(DataElementType.HIDDEN);
        de.setValue(portaApplicativa ? TipoPdD.APPLICATIVA.getTipo() : TipoPdD.DELEGATA.getTipo());
        dati.add(de);
        if (showStato || showRealtime) {
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Generale");
            dati.add(de);
        }
        String[] valuesProp = new String[]{StatoFunzionalita.ABILITATO.getValue(), StatoFunzionalita.DISABILITATO.getValue()};
        String[] labelsProp = new String[]{"abilitato", "disabilitato"};
        de = new DataElement();
        de.setName("dumpStato");
        de.setLabel("Stato");
        if (showStato) {
            try {
                de.setType(DataElementType.SELECT);
                String[] valuesStato = new String[]{"default", "ridefinito"};
                String[] labelsStato = new String[]{this.getDumpLabelDefault(true, portaApplicativa), "ridefinito"};
                de.setSelected(statoDump);
                de.setLabels(labelsStato);
                de.setValues(valuesStato);
                de.setPostBack(true);
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(statoDump);
        }
        dati.add(de);
        if (!showStato || statoDump.equals("ridefinito")) {
            de = new DataElement();
            de.setName("dumpRealTime");
            de.setLabel("Realtime");
            if (showRealtime) {
                de.setType(DataElementType.SELECT);
                de.setSelected(realtime);
                de.setLabels(labelsProp);
                de.setValues(valuesProp);
            } else {
                de.setType(DataElementType.HIDDEN);
                de.setValue(realtime);
            }
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Richiesta");
            dati.add(de);
            de = new DataElement();
            de.setName("dumpStatoReq");
            de.setLabel("Stato");
            de.setType(DataElementType.SELECT);
            de.setSelected(statoDumpRichiesta);
            de.setLabels(labelsProp);
            de.setValues(valuesProp);
            de.setPostBack(true);
            dati.add(de);
            if (statoDumpRichiesta.equals(StatoFunzionalita.ABILITATO.getValue())) {
                try {
                    this.addSottoSezioneDump(dati, valuesProp, labelsProp, "Ingresso", "dumpReqInHead", "Headers", dumpRichiestaIngressoHeader, "dumpReqInPay", "Payload", dumpRichiestaIngressoPayload, "dumpReqInPars", "Multipart Parsing", dumpRichiestaIngressoPayloadParsing, "dumpReqInBody", "Body", dumpRichiestaIngressoBody, "dumpReqInAtt", "Attachments", dumpRichiestaIngressoAttachments);
                    this.addSottoSezioneDump(dati, valuesProp, labelsProp, "Uscita", "dumpReqOutHead", "Headers", dumpRichiestaUscitaHeader, "dumpReqOutPay", "Payload", dumpRichiestaUscitaPayload, "dumpReqOutPars", "Multipart Parsing", dumpRichiestaUscitaPayloadParsing, "dumpReqOutBody", "Body", dumpRichiestaUscitaBody, "dumpReqOutAtt", "Attachments", dumpRichiestaUscitaAttachments);
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
            }
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Risposta");
            dati.add(de);
            de = new DataElement();
            de.setName("dumpStatoRes");
            de.setLabel("Stato");
            de.setType(DataElementType.SELECT);
            de.setSelected(statoDumpRisposta);
            de.setLabels(labelsProp);
            de.setValues(valuesProp);
            de.setPostBack(true);
            dati.add(de);
            if (statoDumpRisposta.equals(StatoFunzionalita.ABILITATO.getValue())) {
                try {
                    this.addSottoSezioneDump(dati, valuesProp, labelsProp, "Ingresso", "dumpResInHead", "Headers", dumpRispostaIngressoHeader, "dumpResInPay", "Payload", dumpRispostaIngressoPayload, "dumpResInPars", "Multipart Parsing", dumpRispostaIngressoPayloadParsing, "dumpResInBody", "Body", dumpRispostaIngressoBody, "dumpResInAtt", "Attachments", dumpRispostaIngressoAttachments);
                    this.addSottoSezioneDump(dati, valuesProp, labelsProp, "Uscita", "dumpResOutHead", "Headers", dumpRispostaUscitaHeader, "dumpResOutPay", "Payload", dumpRispostaUscitaPayload, "dumpResOutPars", "Multipart Parsing", dumpRispostaUscitaPayloadParsing, "dumpResOutBody", "Body", dumpRispostaUscitaBody, "dumpResOutAtt", "Attachments", dumpRispostaUscitaAttachments);
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
            }
        }
    }

    private void addSottoSezioneDump(List<DataElement> dati, String[] valuesProp, String[] labelsProp, String labelSezione, String paramHeaders, String labelHeaders, String dumpHeader, String paramPayload, String labelPayload, String dumpPayload, String paramPayloadParsing, String labelPayloadParsing, String dumpPayloadParsing, String paramBody, String labelBody, String dumpBody, String paramAttachments, String labelAttachments, String dumpAttachments) throws UtilsException {
        DataElement de = new DataElement();
        de.setType(DataElementType.SUBTITLE);
        de.setLabel(labelSezione);
        dati.add(de);
        de = new DataElement();
        de.setName(paramHeaders);
        de.setLabel(labelHeaders);
        de.setType(DataElementType.SELECT);
        de.setSelected(dumpHeader);
        de.setLabels(labelsProp);
        de.setValues(valuesProp);
        dati.add(de);
        boolean multipartPayloadParsing = this.core.isRegistrazioneMessaggiMultipartPayloadParsingEnabled();
        if (!multipartPayloadParsing && StatoFunzionalita.ABILITATO.getValue().equals(dumpPayload) && StatoFunzionalita.ABILITATO.getValue().equals(dumpPayloadParsing)) {
            multipartPayloadParsing = true;
        }
        de = new DataElement();
        de.setName(paramPayload);
        de.setLabel(labelPayload);
        de.setType(DataElementType.SELECT);
        de.setSelected(dumpPayload);
        de.setLabels(labelsProp);
        de.setValues(valuesProp);
        if (multipartPayloadParsing) {
            de.setPostBack(true);
        }
        dati.add(de);
        de = new DataElement();
        de.setName(paramPayloadParsing);
        de.setLabel(labelPayloadParsing);
        de.setValue(dumpPayloadParsing);
        if (multipartPayloadParsing && dumpPayload != null && dumpPayload.equals(StatoFunzionalita.ABILITATO.getValue())) {
            de.setType(DataElementType.SELECT);
            de.setSelected(dumpPayloadParsing);
            de.setLabels(labelsProp);
            de.setValues(valuesProp);
            de.setPostBack(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
        }
        dati.add(de);
        de = new DataElement();
        de.setName(paramBody);
        de.setLabel(labelBody);
        de.setValue(dumpBody);
        if (multipartPayloadParsing && dumpPayloadParsing != null && dumpPayloadParsing.equals(StatoFunzionalita.ABILITATO.getValue())) {
            de.setType(DataElementType.SELECT);
            de.setSelected(dumpBody);
            de.setLabels(labelsProp);
            de.setValues(valuesProp);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
        }
        dati.add(de);
        de = new DataElement();
        de.setName(paramAttachments);
        de.setLabel(labelAttachments);
        de.setValue(dumpAttachments);
        if (multipartPayloadParsing && dumpPayloadParsing != null && dumpPayloadParsing.equals(StatoFunzionalita.ABILITATO.getValue())) {
            de.setType(DataElementType.SELECT);
            de.setSelected(dumpAttachments);
            de.setLabels(labelsProp);
            de.setValues(valuesProp);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(StatoFunzionalita.DISABILITATO.getValue());
        }
        dati.add(de);
    }

    protected String getGestioneCorsLabelDefault(boolean usePrefixDefault) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        CorsConfigurazione cc;
        StringBuilder bf = new StringBuilder();
        if (usePrefixDefault) {
            bf.append("default");
            bf.append(" (");
        }
        if ((cc = this.confCore.getConfigurazioneGenerale().getGestioneCors()) == null || cc.getStato() == null) {
            bf.append(StatoFunzionalita.DISABILITATO.getValue());
        } else if (StatoFunzionalita.DISABILITATO.equals((Object)cc.getStato())) {
            bf.append(cc.getStato().getValue());
        } else {
            bf.append(this.getLabelTipoGestioneCors(cc.getTipo()));
        }
        if (usePrefixDefault) {
            bf.append(")");
        }
        return bf.toString();
    }

    protected String getLabelTipoGestioneCors(TipoGestioneCORS tipo) {
        if (tipo == null || "".equals(tipo.toString())) {
            return "undefined";
        }
        if (TipoGestioneCORS.GATEWAY.equals((Object)tipo)) {
            return StatoFunzionalita.ABILITATO.getValue();
        }
        return StatoFunzionalita.ABILITATO.getValue() + " (applicativo)";
    }

    protected String getResponseCachingLabelDefault(boolean usePrefixDefault) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        ResponseCachingConfigurazioneGenerale rg;
        StringBuilder bf = new StringBuilder();
        if (usePrefixDefault) {
            bf.append("default");
            bf.append(" (");
        }
        if ((rg = this.confCore.getConfigurazioneGenerale().getResponseCaching()) == null || rg.getConfigurazione() == null || rg.getConfigurazione().getStato() == null) {
            bf.append(StatoFunzionalita.DISABILITATO.getValue());
        } else {
            bf.append(rg.getConfigurazione().getStato().getValue());
        }
        if (usePrefixDefault) {
            bf.append(")");
        }
        return bf.toString();
    }

    protected String getDumpLabelDefault(boolean usePrefixDefault, boolean portaApplicativa) throws DriverConfigurazioneNotFound, DriverConfigurazioneException {
        String labelDefault = "default";
        Dump dConfig = this.confCore.getConfigurazioneGenerale().getDump();
        DumpConfigurazione dumpConfigurazione = null;
        if (dConfig != null) {
            DumpConfigurazione dumpConfigurazione2 = dumpConfigurazione = portaApplicativa ? dConfig.getConfigurazionePortaApplicativa() : dConfig.getConfigurazionePortaDelegata();
        }
        if (dConfig == null || dumpConfigurazione == null) {
            labelDefault = usePrefixDefault ? "default (disabilitato)" : "disabilitato";
        } else {
            boolean risposta;
            boolean richiesta = dumpConfigurazione.getRichiestaIngresso() != null && (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaIngresso().getHeaders()) || StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaIngresso().getPayload()) && (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaIngresso().getBody()) || StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaIngresso().getAttachments()))) || dumpConfigurazione.getRichiestaUscita() != null && (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getHeaders()) || StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getPayload()) && (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getBody()) || StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRichiestaUscita().getAttachments())));
            boolean bl = risposta = dumpConfigurazione.getRispostaIngresso() != null && (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getHeaders()) || StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getPayload()) && (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getBody()) || StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaIngresso().getAttachments()))) || dumpConfigurazione.getRispostaUscita() != null && (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaUscita().getHeaders()) || StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaUscita().getPayload()) && (StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaUscita().getBody()) || StatoFunzionalita.ABILITATO.equals((Object)dumpConfigurazione.getRispostaUscita().getAttachments())));
            labelDefault = richiesta && risposta ? (usePrefixDefault ? "default (abilitato)" : "abilitato") : (richiesta ? (usePrefixDefault ? "default (abilitato richiesta)" : "abilitato richiesta") : (risposta ? (usePrefixDefault ? "default (abilitato risposta)" : "abilitato risposta") : (usePrefixDefault ? "default (disabilitato)" : "disabilitato")));
        }
        return labelDefault;
    }

    public void addConfigurazioneDumpToDatiAsHidden(TipoOperazione tipoOperazione, List<DataElement> dati, boolean showStato, String statoDump, boolean showRealtime, String realtime, String statoDumpRichiesta, String statoDumpRisposta, String dumpRichiestaIngressoHeader, String dumpRichiestaIngressoPayload, String dumpRichiestaIngressoPayloadParsing, String dumpRichiestaIngressoBody, String dumpRichiestaIngressoAttachments, String dumpRichiestaUscitaHeader, String dumpRichiestaUscitaPayload, String dumpRichiestaUscitaPayloadParsing, String dumpRichiestaUscitaBody, String dumpRichiestaUscitaAttachments, String dumpRispostaIngressoHeader, String dumpRispostaIngressoPayload, String dumpRispostaIngressoPayloadParsing, String dumpRispostaIngressoBody, String dumpRispostaIngressoAttachments, String dumpRispostaUscitaHeader, String dumpRispostaUscitaPayload, String dumpRispostaUscitaPayloadParsing, String dumpRispostaUscitaBody, String dumpRispostaUscitaAttachments, boolean portaApplicativa) throws DriverControlStationException {
        DataElement de = new DataElement();
        de.setName("dumpStato");
        de.setLabel("Stato");
        de.setType(DataElementType.HIDDEN);
        de.setValue(statoDump);
        dati.add(de);
        de = new DataElement();
        de.setName("dumpConfigType");
        de.setType(DataElementType.HIDDEN);
        de.setValue(portaApplicativa ? TipoPdD.APPLICATIVA.getTipo() : TipoPdD.DELEGATA.getTipo());
        dati.add(de);
        if (!showStato || statoDump.equals("ridefinito")) {
            de = new DataElement();
            de.setName("dumpRealTime");
            de.setLabel("Realtime");
            de.setType(DataElementType.HIDDEN);
            de.setValue(realtime);
            dati.add(de);
            de = new DataElement();
            de.setName("dumpStatoReq");
            de.setLabel("Stato");
            de.setType(DataElementType.HIDDEN);
            de.setValue(statoDumpRichiesta);
            dati.add(de);
            if (statoDumpRichiesta.equals(StatoFunzionalita.ABILITATO.getValue())) {
                this.addSottoSezioneDumpHidden(dati, "dumpReqInHead", "Headers", dumpRichiestaIngressoHeader, "dumpReqInPay", "Payload", dumpRichiestaIngressoPayload, "dumpReqInPars", "Multipart Parsing", dumpRichiestaIngressoPayloadParsing, "dumpReqInBody", "Body", dumpRichiestaIngressoBody, "dumpReqInAtt", "Attachments", dumpRichiestaIngressoAttachments);
                this.addSottoSezioneDumpHidden(dati, "dumpReqOutHead", "Headers", dumpRichiestaUscitaHeader, "dumpReqOutPay", "Payload", dumpRichiestaUscitaPayload, "dumpReqOutPars", "Multipart Parsing", dumpRichiestaUscitaPayloadParsing, "dumpReqOutBody", "Body", dumpRichiestaUscitaBody, "dumpReqOutAtt", "Attachments", dumpRichiestaUscitaAttachments);
            }
            de = new DataElement();
            de.setName("dumpStatoRes");
            de.setLabel("Stato");
            de.setType(DataElementType.HIDDEN);
            de.setValue(statoDumpRisposta);
            dati.add(de);
            if (statoDumpRisposta.equals(StatoFunzionalita.ABILITATO.getValue())) {
                this.addSottoSezioneDumpHidden(dati, "dumpResInHead", "Headers", dumpRispostaIngressoHeader, "dumpResInPay", "Payload", dumpRispostaIngressoPayload, "dumpResInPars", "Multipart Parsing", dumpRispostaIngressoPayloadParsing, "dumpResInBody", "Body", dumpRispostaIngressoBody, "dumpResInAtt", "Attachments", dumpRispostaIngressoAttachments);
                this.addSottoSezioneDumpHidden(dati, "dumpResOutHead", "Headers", dumpRispostaUscitaHeader, "dumpResOutPay", "Payload", dumpRispostaUscitaPayload, "dumpResOutPars", "Multipart Parsing", dumpRispostaUscitaPayloadParsing, "dumpResOutBody", "Body", dumpRispostaUscitaBody, "dumpResOutAtt", "Attachments", dumpRispostaUscitaAttachments);
            }
        }
    }

    private void addSottoSezioneDumpHidden(List<DataElement> dati, String paramHeaders, String labelHeaders, String dumpHeader, String paramPayload, String labelPayload, String dumpPayload, String paramPayloadParsing, String labelPayloadParsing, String dumpPayloadParsing, String paramBody, String labelBody, String dumpBody, String paramAttachments, String labelAttachments, String dumpAttachments) {
        DataElement de = new DataElement();
        de.setName(paramHeaders);
        de.setLabel(labelHeaders);
        de.setType(DataElementType.HIDDEN);
        de.setValue(dumpHeader);
        dati.add(de);
        de = new DataElement();
        de.setName(paramPayload);
        de.setLabel(labelPayload);
        de.setType(DataElementType.HIDDEN);
        de.setValue(dumpPayload);
        dati.add(de);
        de = new DataElement();
        de.setName(paramPayloadParsing);
        de.setLabel(labelPayloadParsing);
        de.setType(DataElementType.HIDDEN);
        de.setValue(dumpPayloadParsing);
        dati.add(de);
        de = new DataElement();
        de.setName(paramBody);
        de.setLabel(labelBody);
        de.setType(DataElementType.HIDDEN);
        de.setValue(dumpBody);
        dati.add(de);
        de = new DataElement();
        de.setName(paramAttachments);
        de.setLabel(labelAttachments);
        de.setType(DataElementType.HIDDEN);
        de.setValue(dumpAttachments);
        dati.add(de);
    }

    public boolean checkDataConfigurazioneDump(TipoOperazione tipoOperazione, boolean showStato, String statoDump, boolean showRealtime, String realtime, String statoDumpRichiesta, String statoDumpRisposta, String dumpRichiestaIngressoHeader, String dumpRichiestaIngressoPayload, String dumpRichiestaIngressoPayloadParsing, String dumpRichiestaIngressoBody, String dumpRichiestaIngressoAttachments, String dumpRichiestaUscitaHeader, String dumpRichiestaUscitaPayload, String dumpRichiestaUscitaPayloadParsing, String dumpRichiestaUscitaBody, String dumpRichiestaUscitaAttachments, String dumpRispostaIngressoHeader, String dumpRispostaIngressoPayload, String dumpRispostaIngressoPayloadParsing, String dumpRispostaIngressoBody, String dumpRispostaIngressoAttachments, String dumpRispostaUscitaHeader, String dumpRispostaUscitaPayload, String dumpRispostaUscitaPayloadParsing, String dumpRispostaUscitaBody, String dumpRispostaUscitaAttachments) throws DriverControlStationException {
        if (showStato && (StringUtils.isEmpty((CharSequence)statoDump) || !statoDump.equals("default") && !statoDump.equals("ridefinito"))) {
            this.pd.setMessage(MessageFormat.format("Valore del campo {0} non valido.", "Stato"));
            return false;
        }
        if (!showStato || statoDump.equals("ridefinito")) {
            if (StringUtils.isEmpty((CharSequence)realtime) || !realtime.equals(StatoFunzionalita.ABILITATO.getValue()) && !realtime.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                this.pd.setMessage(MessageFormat.format("Valore del campo {0} non valido.", "Realtime"));
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)statoDumpRichiesta) || !statoDumpRichiesta.equals(StatoFunzionalita.ABILITATO.getValue()) && !statoDumpRichiesta.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                this.pd.setMessage(MessageFormat.format("Valore del campo {0} della {1} non valido.", "Stato", "Richiesta"));
                return false;
            }
            if (statoDumpRichiesta.equals(StatoFunzionalita.ABILITATO.getValue())) {
                if (StringUtils.isEmpty((CharSequence)dumpRichiestaIngressoHeader) || !dumpRichiestaIngressoHeader.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRichiestaIngressoHeader.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Headers", "Ingresso", "Richiesta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRichiestaIngressoPayload) || !dumpRichiestaIngressoPayload.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRichiestaIngressoPayload.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Payload", "Ingresso", "Richiesta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRichiestaIngressoPayloadParsing) || !dumpRichiestaIngressoPayloadParsing.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRichiestaIngressoPayloadParsing.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Multipart Parsing", "Ingresso", "Richiesta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRichiestaIngressoBody) || !dumpRichiestaIngressoBody.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRichiestaIngressoBody.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Body", "Ingresso", "Richiesta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRichiestaIngressoAttachments) || !dumpRichiestaIngressoAttachments.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRichiestaIngressoAttachments.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Attachments", "Ingresso", "Richiesta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRichiestaUscitaHeader) || !dumpRichiestaUscitaHeader.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRichiestaUscitaHeader.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Headers", "Uscita", "Richiesta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRichiestaUscitaPayload) || !dumpRichiestaUscitaPayload.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRichiestaUscitaPayload.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Payload", "Uscita", "Richiesta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRichiestaUscitaPayloadParsing) || !dumpRichiestaUscitaPayloadParsing.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRichiestaUscitaPayloadParsing.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Multipart Parsing", "Uscita", "Richiesta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRichiestaUscitaBody) || !dumpRichiestaUscitaBody.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRichiestaUscitaBody.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Body", "Uscita", "Richiesta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRichiestaUscitaAttachments) || !dumpRichiestaUscitaAttachments.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRichiestaUscitaAttachments.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Attachments", "Uscita", "Richiesta"));
                    return false;
                }
                if (dumpRichiestaIngressoHeader.equals(StatoFunzionalita.DISABILITATO.getValue()) && dumpRichiestaIngressoPayload.equals(StatoFunzionalita.DISABILITATO.getValue()) && dumpRichiestaUscitaHeader.equals(StatoFunzionalita.DISABILITATO.getValue()) && dumpRichiestaUscitaPayload.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Impossibile abilitare la Registrazione dei messaggi di {0} senza specificare almeno una voce di Ingresso o Uscita", "Richiesta"));
                    return false;
                }
                if (dumpRichiestaIngressoPayload.equals(StatoFunzionalita.ABILITATO.getValue()) && dumpRichiestaIngressoPayloadParsing.equals(StatoFunzionalita.ABILITATO.getValue()) && dumpRichiestaIngressoBody.equals(StatoFunzionalita.DISABILITATO.getValue()) && dumpRichiestaIngressoAttachments.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Nella Registrazione dei messaggi di {0}, se si abilita la funzionalit\u00e0 Multipart Parsing deve essere abilitata almeno una voce tra Body o Attachments", "Richiesta Ingresso"));
                    return false;
                }
                if (dumpRichiestaUscitaPayload.equals(StatoFunzionalita.ABILITATO.getValue()) && dumpRichiestaUscitaPayloadParsing.equals(StatoFunzionalita.ABILITATO.getValue()) && dumpRichiestaUscitaBody.equals(StatoFunzionalita.DISABILITATO.getValue()) && dumpRichiestaUscitaAttachments.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Nella Registrazione dei messaggi di {0}, se si abilita la funzionalit\u00e0 Multipart Parsing deve essere abilitata almeno una voce tra Body o Attachments", "Richiesta Uscita"));
                    return false;
                }
            }
            if (StringUtils.isEmpty((CharSequence)statoDumpRisposta) || !statoDumpRisposta.equals(StatoFunzionalita.ABILITATO.getValue()) && !statoDumpRisposta.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                this.pd.setMessage(MessageFormat.format("Valore del campo {0} della {1} non valido.", "Stato", "Risposta"));
                return false;
            }
            if (statoDumpRisposta.equals(StatoFunzionalita.ABILITATO.getValue())) {
                if (StringUtils.isEmpty((CharSequence)dumpRispostaIngressoHeader) || !dumpRispostaIngressoHeader.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRispostaIngressoHeader.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Headers", "Ingresso", "Risposta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRispostaIngressoPayload) || !dumpRispostaIngressoPayload.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRispostaIngressoPayload.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Payload", "Ingresso", "Risposta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRispostaIngressoPayloadParsing) || !dumpRispostaIngressoPayloadParsing.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRispostaIngressoPayloadParsing.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Multipart Parsing", "Ingresso", "Risposta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRispostaIngressoBody) || !dumpRispostaIngressoBody.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRispostaIngressoBody.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Body", "Ingresso", "Risposta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRispostaIngressoAttachments) || !dumpRispostaIngressoAttachments.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRispostaIngressoAttachments.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Attachments", "Ingresso", "Risposta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRispostaUscitaHeader) || !dumpRispostaUscitaHeader.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRispostaUscitaHeader.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Headers", "Uscita", "Risposta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRispostaUscitaPayload) || !dumpRispostaUscitaPayload.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRispostaUscitaPayload.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Payload", "Uscita", "Risposta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRispostaUscitaPayloadParsing) || !dumpRispostaUscitaPayloadParsing.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRispostaUscitaPayloadParsing.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Multipart Parsing", "Uscita", "Risposta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRispostaUscitaBody) || !dumpRispostaUscitaBody.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRispostaUscitaBody.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Body", "Uscita", "Risposta"));
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)dumpRispostaUscitaAttachments) || !dumpRispostaUscitaAttachments.equals(StatoFunzionalita.ABILITATO.getValue()) && !dumpRispostaUscitaAttachments.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Valore del campo {0} {1} della {2} non valido.", "Attachments", "Uscita", "Risposta"));
                    return false;
                }
                if (dumpRispostaIngressoHeader.equals(StatoFunzionalita.DISABILITATO.getValue()) && dumpRispostaIngressoPayload.equals(StatoFunzionalita.DISABILITATO.getValue()) && dumpRispostaUscitaHeader.equals(StatoFunzionalita.DISABILITATO.getValue()) && dumpRispostaUscitaPayload.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Impossibile abilitare la Registrazione dei messaggi di {0} senza specificare almeno una voce di Ingresso o Uscita", "Risposta"));
                    return false;
                }
                if (dumpRispostaIngressoPayload.equals(StatoFunzionalita.ABILITATO.getValue()) && dumpRispostaIngressoPayloadParsing.equals(StatoFunzionalita.ABILITATO.getValue()) && dumpRispostaIngressoBody.equals(StatoFunzionalita.DISABILITATO.getValue()) && dumpRispostaIngressoAttachments.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Nella Registrazione dei messaggi di {0}, se si abilita la funzionalit\u00e0 Multipart Parsing deve essere abilitata almeno una voce tra Body o Attachments", "Risposta Ingresso"));
                    return false;
                }
                if (dumpRispostaUscitaPayload.equals(StatoFunzionalita.ABILITATO.getValue()) && dumpRispostaUscitaPayloadParsing.equals(StatoFunzionalita.ABILITATO.getValue()) && dumpRispostaUscitaBody.equals(StatoFunzionalita.DISABILITATO.getValue()) && dumpRispostaUscitaAttachments.equals(StatoFunzionalita.DISABILITATO.getValue())) {
                    this.pd.setMessage(MessageFormat.format("Nella Registrazione dei messaggi di {0}, se si abilita la funzionalit\u00e0 Multipart Parsing deve essere abilitata almeno una voce tra Body o Attachments", "Risposta Uscita"));
                    return false;
                }
            }
        }
        return true;
    }

    public DumpConfigurazione getConfigurazioneDump(TipoOperazione tipoOperazione, boolean showStato, String statoDump, boolean showRealtime, String realtime, String statoDumpRichiesta, String statoDumpRisposta, String dumpRichiestaIngressoHeader, String dumpRichiestaIngressoPayload, String dumpRichiestaIngressoPayloadParsing, String dumpRichiestaIngressoBody, String dumpRichiestaIngressoAttachments, String dumpRichiestaUscitaHeader, String dumpRichiestaUscitaPayload, String dumpRichiestaUscitaPayloadParsing, String dumpRichiestaUscitaBody, String dumpRichiestaUscitaAttachments, String dumpRispostaIngressoHeader, String dumpRispostaIngressoPayload, String dumpRispostaIngressoPayloadParsing, String dumpRispostaIngressoBody, String dumpRispostaIngressoAttachments, String dumpRispostaUscitaHeader, String dumpRispostaUscitaPayload, String dumpRispostaUscitaPayloadParsing, String dumpRispostaUscitaBody, String dumpRispostaUscitaAttachments) throws DriverControlStationException {
        DumpConfigurazione newConfigurazione = null;
        if (showStato && statoDump.equals("default")) {
            return newConfigurazione;
        }
        if (!showStato || statoDump.equals("ridefinito")) {
            newConfigurazione = new DumpConfigurazione();
            newConfigurazione.setRichiestaIngresso(new DumpConfigurazioneRegola());
            newConfigurazione.setRichiestaUscita(new DumpConfigurazioneRegola());
            newConfigurazione.setRispostaIngresso(new DumpConfigurazioneRegola());
            newConfigurazione.setRispostaUscita(new DumpConfigurazioneRegola());
            newConfigurazione.setRealtimeRawEnumValue(realtime);
            if (statoDumpRichiesta.equals(StatoFunzionalita.ABILITATO.getValue())) {
                newConfigurazione.getRichiestaIngresso().setHeadersRawEnumValue(dumpRichiestaIngressoHeader);
                newConfigurazione.getRichiestaIngresso().setPayloadRawEnumValue(dumpRichiestaIngressoPayload);
                if (StatoFunzionalita.ABILITATO.equals((Object)newConfigurazione.getRichiestaIngresso().getPayload())) {
                    newConfigurazione.getRichiestaIngresso().setPayloadParsingRawEnumValue(dumpRichiestaIngressoPayloadParsing);
                    if (StatoFunzionalita.ABILITATO.equals((Object)newConfigurazione.getRichiestaIngresso().getPayloadParsing())) {
                        newConfigurazione.getRichiestaIngresso().setBodyRawEnumValue(dumpRichiestaIngressoBody);
                        newConfigurazione.getRichiestaIngresso().setAttachmentsRawEnumValue(dumpRichiestaIngressoAttachments);
                    } else {
                        newConfigurazione.getRichiestaIngresso().setBody(StatoFunzionalita.DISABILITATO);
                        newConfigurazione.getRichiestaIngresso().setAttachments(StatoFunzionalita.DISABILITATO);
                    }
                } else {
                    newConfigurazione.getRichiestaIngresso().setPayloadParsing(StatoFunzionalita.DISABILITATO);
                    newConfigurazione.getRichiestaIngresso().setBody(StatoFunzionalita.DISABILITATO);
                    newConfigurazione.getRichiestaIngresso().setAttachments(StatoFunzionalita.DISABILITATO);
                }
                newConfigurazione.getRichiestaUscita().setHeadersRawEnumValue(dumpRichiestaUscitaHeader);
                newConfigurazione.getRichiestaUscita().setPayloadRawEnumValue(dumpRichiestaUscitaPayload);
                if (StatoFunzionalita.ABILITATO.equals((Object)newConfigurazione.getRichiestaUscita().getPayload())) {
                    newConfigurazione.getRichiestaUscita().setPayloadParsingRawEnumValue(dumpRichiestaUscitaPayloadParsing);
                    if (StatoFunzionalita.ABILITATO.equals((Object)newConfigurazione.getRichiestaUscita().getPayloadParsing())) {
                        newConfigurazione.getRichiestaUscita().setBodyRawEnumValue(dumpRichiestaUscitaBody);
                        newConfigurazione.getRichiestaUscita().setAttachmentsRawEnumValue(dumpRichiestaUscitaAttachments);
                    } else {
                        newConfigurazione.getRichiestaUscita().setBody(StatoFunzionalita.DISABILITATO);
                        newConfigurazione.getRichiestaUscita().setAttachments(StatoFunzionalita.DISABILITATO);
                    }
                } else {
                    newConfigurazione.getRichiestaUscita().setPayloadParsing(StatoFunzionalita.DISABILITATO);
                    newConfigurazione.getRichiestaUscita().setBody(StatoFunzionalita.DISABILITATO);
                    newConfigurazione.getRichiestaUscita().setAttachments(StatoFunzionalita.DISABILITATO);
                }
            } else {
                newConfigurazione.getRichiestaIngresso().setHeaders(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRichiestaIngresso().setPayload(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRichiestaIngresso().setPayloadParsing(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRichiestaIngresso().setBody(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRichiestaIngresso().setAttachments(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRichiestaUscita().setHeaders(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRichiestaUscita().setPayload(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRichiestaUscita().setPayloadParsing(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRichiestaUscita().setBody(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRichiestaUscita().setAttachments(StatoFunzionalita.DISABILITATO);
            }
            if (statoDumpRisposta.equals(StatoFunzionalita.ABILITATO.getValue())) {
                newConfigurazione.getRispostaIngresso().setHeadersRawEnumValue(dumpRispostaIngressoHeader);
                newConfigurazione.getRispostaIngresso().setPayloadRawEnumValue(dumpRispostaIngressoPayload);
                if (StatoFunzionalita.ABILITATO.equals((Object)newConfigurazione.getRispostaIngresso().getPayload())) {
                    newConfigurazione.getRispostaIngresso().setPayloadParsingRawEnumValue(dumpRispostaIngressoPayloadParsing);
                    if (StatoFunzionalita.ABILITATO.equals((Object)newConfigurazione.getRispostaIngresso().getPayloadParsing())) {
                        newConfigurazione.getRispostaIngresso().setBodyRawEnumValue(dumpRispostaIngressoBody);
                        newConfigurazione.getRispostaIngresso().setAttachmentsRawEnumValue(dumpRispostaIngressoAttachments);
                    } else {
                        newConfigurazione.getRispostaIngresso().setBody(StatoFunzionalita.DISABILITATO);
                        newConfigurazione.getRispostaIngresso().setAttachments(StatoFunzionalita.DISABILITATO);
                    }
                } else {
                    newConfigurazione.getRispostaIngresso().setPayloadParsing(StatoFunzionalita.DISABILITATO);
                    newConfigurazione.getRispostaIngresso().setBody(StatoFunzionalita.DISABILITATO);
                    newConfigurazione.getRispostaIngresso().setAttachments(StatoFunzionalita.DISABILITATO);
                }
                newConfigurazione.getRispostaUscita().setHeadersRawEnumValue(dumpRispostaUscitaHeader);
                newConfigurazione.getRispostaUscita().setPayloadRawEnumValue(dumpRispostaUscitaPayload);
                if (StatoFunzionalita.ABILITATO.equals((Object)newConfigurazione.getRispostaUscita().getPayload())) {
                    newConfigurazione.getRispostaUscita().setPayloadParsingRawEnumValue(dumpRispostaUscitaPayloadParsing);
                    if (StatoFunzionalita.ABILITATO.equals((Object)newConfigurazione.getRispostaUscita().getPayloadParsing())) {
                        newConfigurazione.getRispostaUscita().setBodyRawEnumValue(dumpRispostaUscitaBody);
                        newConfigurazione.getRispostaUscita().setAttachmentsRawEnumValue(dumpRispostaUscitaAttachments);
                    } else {
                        newConfigurazione.getRispostaUscita().setBody(StatoFunzionalita.DISABILITATO);
                        newConfigurazione.getRispostaUscita().setAttachments(StatoFunzionalita.DISABILITATO);
                    }
                } else {
                    newConfigurazione.getRispostaUscita().setPayloadParsing(StatoFunzionalita.DISABILITATO);
                    newConfigurazione.getRispostaUscita().setBody(StatoFunzionalita.DISABILITATO);
                    newConfigurazione.getRispostaUscita().setAttachments(StatoFunzionalita.DISABILITATO);
                }
            } else {
                newConfigurazione.getRispostaIngresso().setHeaders(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRispostaIngresso().setPayload(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRispostaIngresso().setPayloadParsing(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRispostaIngresso().setBody(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRispostaIngresso().setAttachments(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRispostaUscita().setHeaders(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRispostaUscita().setBody(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRispostaUscita().setPayload(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRispostaUscita().setPayloadParsing(StatoFunzionalita.DISABILITATO);
                newConfigurazione.getRispostaUscita().setAttachments(StatoFunzionalita.DISABILITATO);
            }
        }
        return newConfigurazione;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDumpConfigurazioneAbilitato(DumpConfigurazione configurazione, boolean isRisposta) {
        DumpConfigurazioneRegola richiestaUscita;
        boolean abilitato = false;
        if (configurazione == null) {
            return false;
        }
        if (isRisposta) {
            DumpConfigurazioneRegola rispostaUscita;
            DumpConfigurazioneRegola rispostaIngresso = configurazione.getRispostaIngresso();
            if (rispostaIngresso != null) {
                if (rispostaIngresso.getHeaders().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
                if (rispostaIngresso.getPayload().equals((Object)StatoFunzionalita.ABILITATO)) {
                    if (!rispostaIngresso.getPayloadParsing().equals((Object)StatoFunzionalita.ABILITATO)) return true;
                    if (rispostaIngresso.getBody().equals((Object)StatoFunzionalita.ABILITATO)) {
                        return true;
                    }
                    if (rispostaIngresso.getAttachments().equals((Object)StatoFunzionalita.ABILITATO)) {
                        return true;
                    }
                }
            }
            if ((rispostaUscita = configurazione.getRispostaUscita()) == null) return abilitato;
            if (rispostaUscita.getHeaders().equals((Object)StatoFunzionalita.ABILITATO)) {
                return true;
            }
            if (!rispostaUscita.getPayload().equals((Object)StatoFunzionalita.ABILITATO)) return abilitato;
            if (!rispostaUscita.getPayloadParsing().equals((Object)StatoFunzionalita.ABILITATO)) return true;
            if (rispostaUscita.getBody().equals((Object)StatoFunzionalita.ABILITATO)) {
                return true;
            }
            if (!rispostaUscita.getAttachments().equals((Object)StatoFunzionalita.ABILITATO)) return abilitato;
            return true;
        }
        DumpConfigurazioneRegola richiestaIngresso = configurazione.getRichiestaIngresso();
        if (richiestaIngresso != null) {
            if (richiestaIngresso.getHeaders().equals((Object)StatoFunzionalita.ABILITATO)) {
                return true;
            }
            if (richiestaIngresso.getPayload().equals((Object)StatoFunzionalita.ABILITATO)) {
                if (!richiestaIngresso.getPayloadParsing().equals((Object)StatoFunzionalita.ABILITATO)) return true;
                if (richiestaIngresso.getBody().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
                if (richiestaIngresso.getAttachments().equals((Object)StatoFunzionalita.ABILITATO)) {
                    return true;
                }
            }
        }
        if ((richiestaUscita = configurazione.getRichiestaUscita()) == null) return abilitato;
        if (richiestaUscita.getHeaders().equals((Object)StatoFunzionalita.ABILITATO)) {
            return true;
        }
        if (!richiestaUscita.getPayload().equals((Object)StatoFunzionalita.ABILITATO)) return abilitato;
        if (!richiestaUscita.getPayloadParsing().equals((Object)StatoFunzionalita.ABILITATO)) return true;
        if (richiestaUscita.getBody().equals((Object)StatoFunzionalita.ABILITATO)) {
            return true;
        }
        if (!richiestaUscita.getAttachments().equals((Object)StatoFunzionalita.ABILITATO)) return abilitato;
        return true;
    }

    public boolean isDumpConfigurazioneAbilitato(DumpConfigurazione configurazione) {
        return this.isDumpConfigurazioneAbilitato(configurazione, true) || this.isDumpConfigurazioneAbilitato(configurazione, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void aggiornaConfigurazioneProperties(ConfigBean configurazione) throws DriverControlStationException {
        ConfigBean oldConfigurazione = ServletUtils.readConfigurazioneBeanFromSession((HttpServletRequest)this.request, (HttpSession)this.session, (String)configurazione.getId());
        ExternalResources externalResources = new ExternalResources();
        externalResources.setLog(ControlStationCore.getLog());
        externalResources.setTipoDB(this.confCore.getTipoDatabase());
        Connection con = DBManager.getInstance().getConnection();
        try {
            externalResources.setConnection(con);
            for (String key : configurazione.getListakeys()) {
                Boolean oldItemVisible = oldConfigurazione != null ? oldConfigurazione.getItem(key).getVisible() : null;
                BaseItemBean o = configurazione.getItem(key);
                o.setOldVisible(oldItemVisible);
                try {
                    String parameterValue = null;
                    parameterValue = ItemType.LOCK.equals((Object)o.getItemType()) || ItemType.LOCK_HIDDEN.equals((Object)o.getItemType()) ? this.getLockedParameter(key) : this.getParameter(key);
                    o.setValueFromRequest(parameterValue, externalResources, this.confCore.getLockUtilities());
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                    return;
                }
            }
        }
        finally {
            DBManager.getInstance().releaseConnection(con);
        }
    }

    public List<DataElement> addPropertiesConfigToDati(TipoOperazione tipoOperazione, List<DataElement> dati, String configName, ConfigBean configurazioneBean) throws DriverControlStationException {
        return this.addPropertiesConfigToDati(tipoOperazione, dati, configName, configurazioneBean, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<DataElement> addPropertiesConfigToDati(TipoOperazione tipoOperazione, List<DataElement> dati, String configName, ConfigBean configurazioneBean, boolean addHiddenConfigName) throws DriverControlStationException {
        if (addHiddenConfigName) {
            DataElement de = new DataElement();
            de.setLabel("Nome");
            de.setValue(configName);
            de.setType(DataElementType.HIDDEN);
            de.setName("propertiesConfigName");
            dati.add(de);
        }
        if (configurazioneBean == null) return dati;
        ExternalResources externalResources = new ExternalResources();
        externalResources.setLog(ControlStationCore.getLog());
        externalResources.setTipoDB(this.confCore.getTipoDatabase());
        Connection con = DBManager.getInstance().getConnection();
        try {
            externalResources.setConnection(con);
            HashMap mapNameValue = new HashMap();
            for (BaseItemBean item : configurazioneBean.getListaItem()) {
                if (!item.isVisible()) continue;
                try {
                    dati.add(item.toDataElement(configurazioneBean, mapNameValue, externalResources, this.confCore.getLockUtilities()));
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                    return dati;
                }
            }
        }
        finally {
            DBManager.getInstance().releaseConnection(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkPropertiesConfigurationData(TipoOperazione tipoOperazione, ConfigBean configurazioneBean, String nome, String descrizione, Config config) throws DriverControlStationException {
        try {
            ExternalResources externalResources = new ExternalResources();
            externalResources.setLog(ControlStationCore.getLog());
            externalResources.setTipoDB(this.confCore.getTipoDatabase());
            Connection con = DBManager.getInstance().getConnection();
            try {
                externalResources.setConnection(con);
                configurazioneBean.validazioneInputUtente(nome, descrizione, config, externalResources);
            }
            finally {
                DBManager.getInstance().releaseConnection(con);
            }
            return true;
        }
        catch (UserInputValidationException e) {
            this.pd.setMessage(e.getMessage());
            return false;
        }
        catch (ProviderException e) {
            this.pd.setMessage("Si &egrave; verificato un errore durante la validazione, impossibile utilizzare il plugin di validazione previsto dalla configurazione");
            return false;
        }
        catch (ProviderValidationException e) {
            this.pd.setMessage(e.getMessage());
            return false;
        }
        catch (Throwable e) {
            this.pd.setMessage("Si &egrave; verificato un errore durante la validazione, impossibile caricare il plugin di validazione previsto dalla configurazione");
            return false;
        }
    }

    public boolean isFirstTimeFromHttpParameters(String firstTimeParameter) throws DriverControlStationException, ValidationException {
        String tmp = this.getParametroBoolean(firstTimeParameter);
        if (tmp != null && !"".equals(tmp.trim())) {
            return "true".equals(tmp.trim());
        }
        return true;
    }

    public void addToDatiFirstTimeDisabled(List<DataElement> dati, String firstTimeParameter) {
        DataElement de = new DataElement();
        de.setName(firstTimeParameter);
        de.setType(DataElementType.HIDDEN);
        de.setValue("false");
        dati.add(de);
    }

    public void addToDatiHiddenParameter(List<DataElement> dati, String name, String value) {
        DataElement de = new DataElement();
        de.setName(name);
        de.setType(DataElementType.HIDDEN);
        de.setValue(value);
        dati.add(de);
    }

    public boolean hasOnlyPermessiDiagnosticaReportistica(User user) {
        PermessiUtente pu = user.getPermessi();
        Boolean singlePdD = (Boolean)ServletUtils.getObjectFromSession((HttpServletRequest)this.request, (HttpSession)this.session, Boolean.class, (String)"singlePdD");
        if (singlePdD == null) {
            singlePdD = this.core != null ? this.core.isSinglePdD() : true;
        }
        String isServizi = pu.isServizi() ? "yes" : "no";
        String isDiagnostica = pu.isDiagnostica() ? "yes" : "no";
        String isReportistica = pu.isReportistica() ? "yes" : "no";
        String isSistema = pu.isSistema() ? "yes" : "no";
        String isMessaggi = pu.isCodeMessaggi() ? "yes" : "no";
        String isUtenti = pu.isUtenti() ? "yes" : "no";
        String isAuditing = pu.isAuditing() ? "yes" : "no";
        String isAccordiCooperazione = pu.isAccordiCooperazione() ? "yes" : "no";
        return this.hasOnlyPermessiDiagnosticaReportistica(isServizi, isDiagnostica, isReportistica, isSistema, isMessaggi, isUtenti, isAuditing, isAccordiCooperazione, singlePdD);
    }

    public boolean hasOnlyPermessiDiagnosticaReportistica(String isServizi, String isDiagnostica, String isReportistica, String isSistema, String isMessaggi, String isUtenti, String isAuditing, String isAccordiCooperazione, boolean singlePdD) {
        return !(isServizi != null && ServletUtils.isCheckBoxEnabled((String)isServizi) || singlePdD && !this.checkPermessiDiagnosticaReportistica(isDiagnostica, isReportistica, singlePdD) || isSistema != null && ServletUtils.isCheckBoxEnabled((String)isSistema) || isMessaggi != null && ServletUtils.isCheckBoxEnabled((String)isMessaggi) || isUtenti == null && ServletUtils.isCheckBoxEnabled((String)isUtenti) || isAuditing != null && ServletUtils.isCheckBoxEnabled((String)isAuditing) || isAccordiCooperazione != null && ServletUtils.isCheckBoxEnabled((String)isAccordiCooperazione));
    }

    private boolean checkPermessiDiagnosticaReportistica(String isDiagnostica, String isReportistica, boolean singlePdD) {
        return singlePdD && (isDiagnostica == null || ServletUtils.isCheckBoxEnabled((String)isDiagnostica)) || isReportistica == null || ServletUtils.isCheckBoxEnabled((String)isReportistica);
    }

    public String readConfigurazioneRegistrazioneEsitiFromHttpParameters(String configurazioneEsiti, boolean first) throws DriverControlStationException {
        StringBuilder bf = new StringBuilder();
        List esitiCodes = null;
        try {
            EsitiProperties esiti = EsitiConfigUtils.getEsitiPropertiesForConfiguration((Logger)ControlStationCore.getLog());
            esitiCodes = esiti.getEsitiCode();
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        if (esitiCodes != null) {
            for (Integer esito : esitiCodes) {
                String esitoParam = this.getParameter("RecEsitiStato_" + esito);
                boolean checked = ServletUtils.isCheckBoxEnabled((String)esitoParam);
                if (!checked) continue;
                if (bf.length() > 0) {
                    bf.append(",");
                }
                bf.append(esito);
            }
        }
        if (bf.length() > 0) {
            return bf.toString();
        }
        if (!first) {
            return null;
        }
        if (configurazioneEsiti == null || "".equals(configurazioneEsiti.trim())) {
            this.getRegistrazioneEsiti(configurazioneEsiti, bf);
            if (bf.length() > 0) {
                return bf.toString();
            }
            return null;
        }
        return configurazioneEsiti;
    }

    public List<String> getRegistrazioneEsiti(String configurazioneEsiti, StringBuilder bf) throws DriverControlStationException {
        try {
            EsitiProperties esiti = EsitiConfigUtils.getEsitiPropertiesForConfiguration((Logger)ControlStationCore.getLog());
            return EsitiConfigUtils.getRegistrazioneEsiti((String)configurazioneEsiti, (Logger)ControlStationCore.getLog(), (StringBuilder)bf, (EsitiProperties)esiti);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public boolean isCompleteEnabled(List<String> attivi, List<Integer> listCheck) {
        boolean all = true;
        for (int i = 0; i < listCheck.size(); ++i) {
            String okString = "" + listCheck.get(i);
            if (attivi.contains(okString)) continue;
            all = false;
            break;
        }
        return all;
    }

    public boolean isCompleteDisabled(List<String> attivi, List<Integer> listCheck) {
        for (int i = 0; i < listCheck.size(); ++i) {
            String okString = "" + listCheck.get(i);
            if (!attivi.contains(okString)) continue;
            return false;
        }
        return true;
    }

    public List<Integer> getListaEsitiFalliteSenza_RateLimiting_MaxThreads_Scartate(EsitiProperties esiti) throws ProtocolException {
        List listFallite = esiti.getEsitiCodeKo_senzaFaultApplicativo();
        ArrayList<Integer> listDaScartare = new ArrayList<Integer>();
        listDaScartare.addAll(esiti.getEsitiCodeRichiestaScartate());
        int esitoViolazioneRateLimiting = esiti.convertoToCode(EsitoTransazioneName.CONTROLLO_TRAFFICO_POLICY_VIOLATA);
        listDaScartare.add(esitoViolazioneRateLimiting);
        int esitoViolazione = esiti.convertoToCode(EsitoTransazioneName.CONTROLLO_TRAFFICO_MAX_THREADS);
        listDaScartare.add(esitoViolazione);
        ArrayList<Integer> listFalliteSenza_rateLimiting_e_max_e_scartate = new ArrayList<Integer>();
        for (int i = 0; i < listFallite.size(); ++i) {
            boolean statiConsegnaMultipla;
            boolean findDaScartare = false;
            for (Integer daScartare : listDaScartare) {
                if (((Integer)listFallite.get(i)).intValue() != daScartare.intValue()) continue;
                findDaScartare = true;
                break;
            }
            if (findDaScartare || (statiConsegnaMultipla = EsitoTransazioneName.isStatiConsegnaMultipla((EsitoTransazioneName)esiti.getEsitoTransazioneName((Integer)listFallite.get(i))))) continue;
            listFalliteSenza_rateLimiting_e_max_e_scartate.add((Integer)listFallite.get(i));
        }
        return listFalliteSenza_rateLimiting_e_max_e_scartate;
    }

    public List<Integer> getListaEsitiOkSenzaCors(EsitiProperties esiti) throws ProtocolException {
        List listOk = esiti.getEsitiCodeOk_senzaFaultApplicativo();
        int esitoCorsGateway = esiti.convertoToCode(EsitoTransazioneName.CORS_PREFLIGHT_REQUEST_VIA_GATEWAY);
        int esitoCorsTrasparente = esiti.convertoToCode(EsitoTransazioneName.CORS_PREFLIGHT_REQUEST_TRASPARENTE);
        ArrayList<Integer> listOkSenzaCors = new ArrayList<Integer>();
        for (int i = 0; i < listOk.size(); ++i) {
            boolean statiConsegnaMultipla = EsitoTransazioneName.isStatiConsegnaMultipla((EsitoTransazioneName)esiti.getEsitoTransazioneName((Integer)listOk.get(i)));
            if (statiConsegnaMultipla || (Integer)listOk.get(i) == esitoCorsGateway || (Integer)listOk.get(i) == esitoCorsTrasparente) continue;
            listOkSenzaCors.add((Integer)listOk.get(i));
        }
        return listOkSenzaCors;
    }

    public List<Integer> getListaEsitiCors(EsitiProperties esiti) throws ProtocolException {
        int esitoCorsGateway = esiti.convertoToCode(EsitoTransazioneName.CORS_PREFLIGHT_REQUEST_VIA_GATEWAY);
        int esitoCorsTrasparente = esiti.convertoToCode(EsitoTransazioneName.CORS_PREFLIGHT_REQUEST_TRASPARENTE);
        ArrayList<Integer> listCors = new ArrayList<Integer>();
        listCors.add(esitoCorsGateway);
        listCors.add(esitoCorsTrasparente);
        return listCors;
    }

    public void addToDatiTracciamentoTransazioni(List<DataElement> dati, TipoOperazione tipoOperazione, String tracciamentoStato, String servletName, List<Parameter> listParameter, String oldTracciamentoStato) {
        if (tipoOperazione != null) {
            // empty if block
        }
        DataElement de = new DataElement();
        de.setLabel("Transazioni");
        de.setName("TracConfAvanz");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("portaTrStato");
        de.setType(DataElementType.SELECT);
        String[] valuesStato = new String[]{"default", "ridefinito"};
        String[] labelsStato = new String[]{"default", "ridefinito"};
        de.setSelected(tracciamentoStato);
        de.setLabels(labelsStato);
        de.setValues(valuesStato);
        de.setPostBack_viaPOST(true);
        dati.add(de);
        if ("ridefinito".equals(oldTracciamentoStato)) {
            de = new DataElement();
            de.setType(DataElementType.LINK);
            listParameter.add(new Parameter("tipo_configurazione", "tracePort"));
            de.setUrl(servletName, listParameter.toArray(new Parameter[1]));
            de.setValue("Configurazione");
            dati.add(de);
        }
    }

    public void addToDatiRegistrazioneEsiti(List<DataElement> dati, TipoOperazione tipoOperazione, String nuovaConfigurazioneEsiti, boolean selectAll, String tracciamentoEsitiSelezionePersonalizzataOk, String tracciamentoEsitiSelezionePersonalizzataFault, String tracciamentoEsitiSelezionePersonalizzataFallite, String tracciamentoEsitiSelezionePersonalizzataScartate, String tracciamentoEsitiSelezionePersonalizzataRateLimiting, String tracciamentoEsitiSelezionePersonalizzataMax, String tracciamentoEsitiSelezionePersonalizzataCors, TracciamentoCompatibilitaFiltroEsiti tracciamentoCompatibilitaFiltroEsiti) throws DriverControlStationException {
        String[] tmp;
        String warningMsg;
        boolean filterEnabled;
        if (tipoOperazione != null) {
            // empty if block
        }
        if (tracciamentoCompatibilitaFiltroEsiti != null && !tracciamentoCompatibilitaFiltroEsiti.isTracciamentoEnabled()) {
            return;
        }
        boolean bl = filterEnabled = tracciamentoCompatibilitaFiltroEsiti == null || tracciamentoCompatibilitaFiltroEsiti.isFilterEnabled();
        if (!filterEnabled) {
            return;
        }
        DataElement de = new DataElement();
        de.setLabel("Transazioni Registrate");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setValue("Selezionare gli esiti che verranno registrati nello storico");
        de.setType(DataElementType.NOTE);
        dati.add(de);
        if (tracciamentoCompatibilitaFiltroEsiti != null && (warningMsg = tracciamentoCompatibilitaFiltroEsiti.getWarningMessageFilter()) != null && StringUtils.isNotEmpty((CharSequence)warningMsg)) {
            de = new DataElement();
            de.setValue(warningMsg);
            de.setLabel("Nota");
            de.setBold(true);
            de.setType(DataElementType.NOTE);
            dati.add(de);
        }
        ArrayList<String> attivi = new ArrayList<String>();
        if (nuovaConfigurazioneEsiti != null && (tmp = nuovaConfigurazioneEsiti.split(",")) != null) {
            for (int i = 0; i < tmp.length; ++i) {
                attivi.add(tmp[i].trim());
            }
        }
        EsitiProperties esiti = null;
        try {
            esiti = EsitiConfigUtils.getEsitiPropertiesForConfiguration((Logger)ControlStationCore.getLog());
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO);
        values.add(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO);
        values.add(ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO);
        ArrayList<String> valuesSenzaPersonalizzato = new ArrayList<String>();
        valuesSenzaPersonalizzato.add(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO);
        valuesSenzaPersonalizzato.add(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO);
        de = new DataElement();
        de.setLabelRight("Registra qualsiasi esito");
        de.setName("RecEsitiStatoAll");
        de.setType(DataElementType.CHECKBOX);
        de.setSelected(selectAll);
        de.setPostBack_viaPOST(true);
        dati.add(de);
        List<Integer> listOk = null;
        try {
            listOk = this.getListaEsitiOkSenzaCors(esiti);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        if (!selectAll) {
            de = new DataElement();
            de.setLabel("Completate con successo");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("RecEsitiStatoOk");
        if (!selectAll) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(tracciamentoEsitiSelezionePersonalizzataOk);
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setSelected(tracciamentoEsitiSelezionePersonalizzataOk);
        }
        dati.add(de);
        if (ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO.equals(tracciamentoEsitiSelezionePersonalizzataOk) || ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(tracciamentoEsitiSelezionePersonalizzataOk) || selectAll) {
            for (Integer esito : listOk) {
                try {
                    EsitoTransazioneName esitoTransactionName = esiti.getEsitoTransazioneName(esito);
                    boolean statiConsegnaMultipla = EsitoTransazioneName.isStatiConsegnaMultipla((EsitoTransazioneName)esitoTransactionName);
                    if (statiConsegnaMultipla) continue;
                    boolean integrationManagerSpecific = EsitoTransazioneName.isIntegrationManagerSpecific((EsitoTransazioneName)esitoTransactionName);
                    boolean integrationManagerSavedInMessageBox = EsitoTransazioneName.isSavedInMessageBox((EsitoTransazioneName)esitoTransactionName);
                    de = new DataElement();
                    if (EsitoTransazioneName.CONSEGNA_MULTIPLA.equals((Object)esitoTransactionName)) {
                        de.setLabelRight("Consegna Multipla");
                    } else {
                        de.setLabelRight(esiti.getEsitoLabel(esito));
                    }
                    de.setName("RecEsitiStato_" + esito);
                    if (!selectAll && ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO.equals(tracciamentoEsitiSelezionePersonalizzataOk)) {
                        if (integrationManagerSpecific && (this.isModalitaStandard() || !this.core.isIntegrationManagerTraceMessageBoxOperationEnabled()) || integrationManagerSavedInMessageBox && !this.core.isIntegrationManagerEnabled()) {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue("" + attivi.contains("" + esito));
                        } else {
                            de.setType(DataElementType.CHECKBOX);
                            de.setSelected(attivi.contains("" + esito));
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("true");
                    }
                    dati.add(de);
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
            }
        }
        List listFault = null;
        try {
            listFault = esiti.getEsitiCodeFaultApplicativo();
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        if (!selectAll) {
            de = new DataElement();
            de.setLabel("Fault Applicativo");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("RecEsitiStatoFault");
        if (!selectAll) {
            de.setType(DataElementType.SELECT);
            if (listFault.size() > 1) {
                de.setValues(values);
                de.setLabels(values);
            } else {
                de.setValues(valuesSenzaPersonalizzato);
                de.setLabels(valuesSenzaPersonalizzato);
            }
            de.setSelected(tracciamentoEsitiSelezionePersonalizzataFault);
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(tracciamentoEsitiSelezionePersonalizzataFault);
        }
        dati.add(de);
        if (ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO.equals(tracciamentoEsitiSelezionePersonalizzataFault) || ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(tracciamentoEsitiSelezionePersonalizzataFault) || selectAll) {
            for (Integer esito : listFault) {
                try {
                    de = new DataElement();
                    de.setLabelRight(esiti.getEsitoLabel(esito));
                    de.setName("RecEsitiStato_" + esito);
                    if (!selectAll && ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO.equals(tracciamentoEsitiSelezionePersonalizzataFault)) {
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(attivi.contains("" + esito));
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("true");
                    }
                    dati.add(de);
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
            }
        }
        List<Integer> listFalliteSenzaMaxThreadsScartate = null;
        try {
            listFalliteSenzaMaxThreadsScartate = this.getListaEsitiFalliteSenza_RateLimiting_MaxThreads_Scartate(esiti);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        if (!selectAll) {
            de = new DataElement();
            de.setLabel("Fallite");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("RecEsitiStatoFallite");
        if (!selectAll) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(tracciamentoEsitiSelezionePersonalizzataFallite);
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(tracciamentoEsitiSelezionePersonalizzataFallite);
        }
        dati.add(de);
        if (ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO.equals(tracciamentoEsitiSelezionePersonalizzataFallite) || ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(tracciamentoEsitiSelezionePersonalizzataFallite) || selectAll) {
            for (Integer esito : listFalliteSenzaMaxThreadsScartate) {
                try {
                    EsitoTransazioneName esitoTransactionName = esiti.getEsitoTransazioneName(esito);
                    boolean statiConsegnaMultipla = EsitoTransazioneName.isStatiConsegnaMultipla((EsitoTransazioneName)esitoTransactionName);
                    if (statiConsegnaMultipla) continue;
                    boolean integrationManagerSpecific = EsitoTransazioneName.isIntegrationManagerSpecific((EsitoTransazioneName)esitoTransactionName);
                    de = new DataElement();
                    de.setLabelRight(esiti.getEsitoLabel(esito));
                    de.setName("RecEsitiStato_" + esito);
                    if (!selectAll && ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO.equals(tracciamentoEsitiSelezionePersonalizzataFallite)) {
                        if (integrationManagerSpecific && (this.isModalitaStandard() || !this.core.isIntegrationManagerTraceMessageBoxOperationEnabled())) {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue("" + attivi.contains("" + esito));
                        } else {
                            de.setType(DataElementType.CHECKBOX);
                            de.setSelected(attivi.contains("" + esito));
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("true");
                    }
                    dati.add(de);
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
            }
        }
        List listScartate = null;
        try {
            listScartate = esiti.getEsitiCodeRichiestaScartate();
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        if (!selectAll) {
            de = new DataElement();
            de.setLabel("Scartate");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("RecEsitiStatoScartate");
        if (!selectAll) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(tracciamentoEsitiSelezionePersonalizzataScartate);
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(tracciamentoEsitiSelezionePersonalizzataScartate);
        }
        dati.add(de);
        if (ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO.equals(tracciamentoEsitiSelezionePersonalizzataScartate) || ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(tracciamentoEsitiSelezionePersonalizzataScartate) || selectAll) {
            for (Integer esito : listScartate) {
                try {
                    EsitoTransazioneName esitoTransactionName = esiti.getEsitoTransazioneName(esito);
                    boolean statiConsegnaMultipla = EsitoTransazioneName.isStatiConsegnaMultipla((EsitoTransazioneName)esitoTransactionName);
                    if (statiConsegnaMultipla) continue;
                    boolean integrationManagerSpecific = EsitoTransazioneName.isIntegrationManagerSpecific((EsitoTransazioneName)esitoTransactionName);
                    de = new DataElement();
                    de.setLabelRight(esiti.getEsitoLabel(esito));
                    de.setName("RecEsitiStato_" + esito);
                    if (!selectAll && ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO.equals(tracciamentoEsitiSelezionePersonalizzataScartate)) {
                        if (integrationManagerSpecific && (this.isModalitaStandard() || !this.core.isIntegrationManagerTraceMessageBoxOperationEnabled())) {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue("" + attivi.contains("" + esito));
                        } else {
                            de.setType(DataElementType.CHECKBOX);
                            de.setSelected(attivi.contains("" + esito));
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("true");
                    }
                    dati.add(de);
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
            }
        }
        if (!selectAll) {
            de = new DataElement();
            de.setLabel("Violazione Policy Rate Limiting");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        String esitoViolazioneRateLimitingAsString = null;
        try {
            esitoViolazioneRateLimitingAsString = "" + esiti.convertoToCode(EsitoTransazioneName.CONTROLLO_TRAFFICO_POLICY_VIOLATA);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("RecEsitiStatoRateLimit");
        if (!selectAll) {
            de.setType(DataElementType.SELECT);
            de.setValues(valuesSenzaPersonalizzato);
            de.setLabels(valuesSenzaPersonalizzato);
            de.setSelected(tracciamentoEsitiSelezionePersonalizzataRateLimiting);
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(tracciamentoEsitiSelezionePersonalizzataRateLimiting);
        }
        dati.add(de);
        if (ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(tracciamentoEsitiSelezionePersonalizzataRateLimiting) || selectAll) {
            de = new DataElement();
            de.setName("RecEsitiStato_" + esitoViolazioneRateLimitingAsString);
            de.setType(DataElementType.HIDDEN);
            de.setValue("true");
            dati.add(de);
        }
        if (!selectAll) {
            de = new DataElement();
            de.setLabel("Superamento Limite Richieste Complessive");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        String esitoViolazioneAsString = null;
        try {
            esitoViolazioneAsString = "" + esiti.convertoToCode(EsitoTransazioneName.CONTROLLO_TRAFFICO_MAX_THREADS);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("RecEsitiStatoMaxRequests");
        if (!selectAll) {
            de.setType(DataElementType.SELECT);
            de.setValues(valuesSenzaPersonalizzato);
            de.setLabels(valuesSenzaPersonalizzato);
            de.setSelected(tracciamentoEsitiSelezionePersonalizzataMax);
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(tracciamentoEsitiSelezionePersonalizzataMax);
        }
        dati.add(de);
        if (ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(tracciamentoEsitiSelezionePersonalizzataMax) || selectAll) {
            de = new DataElement();
            de.setName("RecEsitiStato_" + esitoViolazioneAsString);
            de.setType(DataElementType.HIDDEN);
            de.setValue("true");
            dati.add(de);
        }
        if (!selectAll) {
            de = new DataElement();
            de.setLabel("CORS Preflight");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("RecEsitiStatoCORS");
        if (!selectAll) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(tracciamentoEsitiSelezionePersonalizzataCors);
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(tracciamentoEsitiSelezionePersonalizzataCors);
        }
        dati.add(de);
        if (ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO.equals(tracciamentoEsitiSelezionePersonalizzataCors) || ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(tracciamentoEsitiSelezionePersonalizzataCors) || selectAll) {
            try {
                List<Integer> listCors = this.getListaEsitiCors(esiti);
                for (Integer esito : listCors) {
                    EsitoTransazioneName esitoTransactionName = esiti.getEsitoTransazioneName(esito);
                    boolean integrationManagerSpecific = EsitoTransazioneName.isIntegrationManagerSpecific((EsitoTransazioneName)esitoTransactionName);
                    de = new DataElement();
                    de.setLabelRight(esiti.getEsitoLabel(esito));
                    de.setName("RecEsitiStato_" + esito);
                    if (!selectAll && ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO.equals(tracciamentoEsitiSelezionePersonalizzataCors)) {
                        if (integrationManagerSpecific && (this.isModalitaStandard() || !this.core.isIntegrationManagerTraceMessageBoxOperationEnabled())) {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue("" + attivi.contains("" + esito));
                        } else {
                            de.setType(DataElementType.CHECKBOX);
                            de.setSelected(attivi.contains("" + esito));
                        }
                    } else {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("true");
                    }
                    dati.add(de);
                }
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        }
    }

    public void addToDatiRegistrazioneTransazione(List<DataElement> dati, TipoOperazione tipoOperazione, String transazioniTempiElaborazione, String transazioniToken) throws DriverControlStationException {
        if (!this.isModalitaStandard()) {
            DataElement de = new DataElement();
            de.setLabel("Informazioni Registrate");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO);
        values.add(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO);
        DataElement de = new DataElement();
        de.setLabel("Tempi Elaborazione");
        de.setName("TransazioneRecTempi");
        if (!this.isModalitaStandard()) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(transazioniTempiElaborazione);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(transazioniTempiElaborazione);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Token");
        de.setName("TransazioneRecToken");
        if (!this.isModalitaStandard()) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(transazioniToken);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(transazioniToken);
        }
        dati.add(de);
    }

    public void addToDatiRegistrazioneConfigurazioneFileTrace(List<DataElement> dati, String fileTraceStato, String fileTraceConfigFile, String fileTraceClient, String fileTraceClientHdr, String fileTraceClientBody, String fileTraceServer, String fileTraceServerHdr, String fileTraceServerBody, TracciamentoCompatibilitaFiltroEsiti tracciamentoCompatibilitaFiltroEsiti) {
        if (!tracciamentoCompatibilitaFiltroEsiti.isTracciamentoFileTraceEnabled()) {
            return;
        }
        if (!tracciamentoCompatibilitaFiltroEsiti.isTracciamentoFileTraceEnabled() || tracciamentoCompatibilitaFiltroEsiti.isTracciamentoFileTraceEnabledByExternalProperties()) {
            return;
        }
        DataElement de = new DataElement();
        de.setLabel("Configurazione FileTrace");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("fileTraceStato");
        de.setType(DataElementType.SELECT);
        String[] valuesStato = new String[]{"default", "ridefinito"};
        String[] labelsStato = new String[]{"default", "ridefinito"};
        de.setSelected(fileTraceStato);
        de.setLabels(labelsStato);
        de.setValues(valuesStato);
        de.setPostBack_viaPOST(true);
        dati.add(de);
        boolean ridefinito = "ridefinito".equals(fileTraceStato);
        de = new DataElement();
        de.setLabel("File Configurazione");
        de.setName("fileTraceConfig");
        de.setValue(fileTraceConfigFile);
        if (ridefinito) {
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(2);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        dati.add(de);
        if (ridefinito) {
            de = new DataElement();
            de.setLabel("Buffer dei Messaggi");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            de = new DataElement();
            de.setValue("Solamente se abilitato sar\u00e0 possibile accedere ai contenuti dei messaggi");
            de.setType(DataElementType.NOTE);
            dati.add(de);
        }
        ArrayList<String> values = new ArrayList<String>();
        values.add(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO);
        values.add(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO);
        de = new DataElement();
        de.setLabel("Scambiati con il client");
        de.setName("fileTraceClient");
        if (ridefinito) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(fileTraceClient);
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(fileTraceClient);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Header");
        de.setName("fileTraceClientHdr");
        if (ridefinito && ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceClient)) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(fileTraceClientHdr);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(fileTraceClientHdr);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Payload");
        de.setName("fileTraceClientBody");
        if (ridefinito && ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceClient)) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(fileTraceClientBody);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(fileTraceClientBody);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Scambiati con il server");
        de.setName("fileTraceServer");
        if (ridefinito) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(fileTraceServer);
            de.setPostBack_viaPOST(true);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(fileTraceServer);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Header");
        de.setName("fileTraceServerHdr");
        if (ridefinito && ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceServer)) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(fileTraceServerHdr);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(fileTraceServerHdr);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Payload");
        de.setName("fileTraceServerBody");
        if (ridefinito && ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO.equals(fileTraceServer)) {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            de.setLabels(values);
            de.setSelected(fileTraceServerBody);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(fileTraceServerBody);
        }
        dati.add(de);
    }

    public void addToDatiConfigurazioneAvanzataTracciamento(List<DataElement> dati, TipoOperazione tipoOperazione, String dbStato, String dbStatoReqIn, String dbStatoReqOut, String dbStatoResOut, String dbStatoResOutComplete, boolean dbFiltroEsiti, String fsStato, String fsStatoReqIn, String fsStatoReqOut, String fsStatoResOut, String fsStatoResOutComplete, boolean fsFiltroEsiti, boolean porta) {
        DataElement de = new DataElement();
        de.setLabel("Transazioni");
        de.setName("TracConfAvanz");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tracciamento DB");
        de.setName("TracConfAvanzDB");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        this.addTransazioniStatoElement(dati, "Stato", "TracConfAvanzDBStato", false, ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_AVANZATA_TRACCIAMENTO_DATABASE_STATO, dbStato, true, true, false);
        this.addTransazioniStatoElementBloccante(dati, "Richiesta ricevuta", "TracConfAvanzDBStatoReqIn", !StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(dbStato), ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_AVANZATA_TRACCIAMENTO_DATABASE_STATO_REQ_IN, dbStatoReqIn, true);
        this.addTransazioniStatoElementBloccante(dati, "Richiesta in consegna", "TracConfAvanzDBStatoReqOut", !StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(dbStato), ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_AVANZATA_TRACCIAMENTO_DATABASE_STATO_REQ_OUT, dbStatoReqOut, true);
        this.addTransazioniStatoElementBloccante(dati, "Risposta in consegna", "TracConfAvanzDBStatoResOut", !StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(dbStato), ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_AVANZATA_TRACCIAMENTO_DATABASE_STATO_RES_OUT, dbStatoResOut, true);
        if (this.core.isTracciamentoDatabaseRispostaConsegnataSelectEnabled()) {
            this.addTransazioniStatoElement(dati, "Risposta consegnata", "TracConfAvanzDBStatoResOutEnd", !StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(dbStato), ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_AVANZATA_TRACCIAMENTO_DATABASE_STATO_RES_OUT_COMPLETE, dbStatoResOutComplete, false);
        } else {
            boolean hidden;
            de = new DataElement();
            de.setLabel("Risposta consegnata");
            de.setName("TracConfAvanzDBStatoResOutEnd");
            boolean bl = hidden = !StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(dbStato);
            if (StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(dbStato)) {
                dbStatoResOutComplete = StatoFunzionalita.ABILITATO.getValue();
            }
            if (hidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.TEXT);
            }
            de.setValue(dbStatoResOutComplete);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Filtra per Esiti");
        de.setName("TracConfAvanzDBFiltroEsiti");
        if (StatoFunzionalitaConPersonalizzazione.DISABILITATO.getValue().equals(dbStato) || StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(dbStato) && (StatoFunzionalitaBloccante.ABILITATO.getValue().equals(dbStatoReqIn) || StatoFunzionalitaBloccante.NON_BLOCCANTE.getValue().equals(dbStatoReqIn))) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(null);
        } else {
            de.setType(DataElementType.CHECKBOX);
            de.setValoreDefaultCheckbox(true);
            de.setSelected(dbFiltroEsiti);
        }
        de.setPostBack_viaPOST(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tracciamento FileTrace");
        de.setName("TracConfAvanzFS");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        this.addTransazioniStatoElement(dati, "Stato", "TracConfAvanzFSStato", false, ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_AVANZATA_TRACCIAMENTO_FILETRACE_STATO, fsStato, true, true, !porta);
        this.addTransazioniStatoElementBloccante(dati, "Richiesta ricevuta", "TracConfAvanzFSStatoReqIn", !StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(fsStato), ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_AVANZATA_TRACCIAMENTO_FILETRACE_STATO_REQ_IN, fsStatoReqIn, true);
        this.addTransazioniStatoElementBloccante(dati, "Richiesta in consegna", "TracConfAvanzFSStatoReqOut", !StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(fsStato), ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_AVANZATA_TRACCIAMENTO_FILETRACE_STATO_REQ_OUT, fsStatoReqOut, true);
        this.addTransazioniStatoElementBloccante(dati, "Risposta in consegna", "TracConfAvanzFSStatoResOut", !StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(fsStato), ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_AVANZATA_TRACCIAMENTO_FILETRACE_STATO_RES_OUT, fsStatoResOut, true);
        this.addTransazioniStatoElement(dati, "Risposta consegnata", "TracConfAvanzFSStatoResOutEnd", !StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(fsStato), ConfigurazioneCostanti.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_AVANZATA_TRACCIAMENTO_FILETRACE_STATO_RES_OUT_COMPLETE, fsStatoResOutComplete, false);
        de = new DataElement();
        de.setLabel("Filtra per Esiti");
        de.setName("TracConfAvanzFSFiltroEsiti");
        if (StatoFunzionalitaConPersonalizzazione.DISABILITATO.getValue().equals(fsStato) || StatoFunzionalitaConPersonalizzazione.PERSONALIZZATO.getValue().equals(fsStato) && (StatoFunzionalitaBloccante.ABILITATO.getValue().equals(fsStatoReqIn) || StatoFunzionalitaBloccante.NON_BLOCCANTE.getValue().equals(fsStatoReqIn))) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(null);
        } else {
            de.setType(DataElementType.CHECKBOX);
            de.setValoreDefaultCheckbox(false);
            de.setSelected(fsFiltroEsiti);
        }
        de.setPostBack_viaPOST(true);
        dati.add(de);
    }

    private void addTransazioniStatoElement(List<DataElement> dati, String label, String name, boolean hidden, String defaultValue, String value, boolean postback) {
        this.addTransazioniStatoElement(dati, label, name, hidden, defaultValue, value, postback, false, false, false);
    }

    private void addTransazioniStatoElementBloccante(List<DataElement> dati, String label, String name, boolean hidden, String defaultValue, String value, boolean postback) {
        this.addTransazioniStatoElement(dati, label, name, hidden, defaultValue, value, postback, false, false, true);
    }

    private void addTransazioniStatoElement(List<DataElement> dati, String label, String name, boolean hidden, String defaultValue, String value, boolean postback, boolean personalizzato, boolean configurazioneEsterna) {
        this.addTransazioniStatoElement(dati, label, name, hidden, defaultValue, value, postback, personalizzato, configurazioneEsterna, false);
    }

    private void addTransazioniStatoElement(List<DataElement> dati, String label, String name, boolean hidden, String defaultValue, String value, boolean postback, boolean personalizzato, boolean configurazioneEsterna, boolean bloccante) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(ConfigurazioneCostanti.DEFAULT_VALUE_ABILITATO);
        if (bloccante) {
            values.add(ConfigurazioneCostanti.DEFAULT_VALUE_NON_BLOCCANTE);
        }
        values.add(ConfigurazioneCostanti.DEFAULT_VALUE_DISABILITATO);
        if (personalizzato) {
            values.add(ConfigurazioneCostanti.TRACCIAMENTO_ESITI_PERSONALIZZATO);
        }
        if (configurazioneEsterna) {
            values.add(ConfigurazioneCostanti.TRACCIAMENTO_ESITI_CONFIGURAZIONE_ESTERNA);
        }
        ArrayList<String> labels = null;
        if (bloccante) {
            labels = new ArrayList<String>();
            labels.add("abilitato (bloccante)");
            labels.add("abilitato (non bloccante)");
            labels.add("disabilitato");
        }
        DataElement de = new DataElement();
        de.setLabel(label);
        de.setName(name);
        if (hidden) {
            de.setType(DataElementType.HIDDEN);
            de.setValue(value);
        } else {
            de.setType(DataElementType.SELECT);
            de.setValues(values);
            if (labels != null) {
                de.setLabels(labels);
            }
            de.setValoreDefaultSelect(defaultValue);
            de.setPostBack_viaPOST(postback);
            de.setSelected(value);
        }
        dati.add(de);
    }

    public void addSeveritaMessaggiDiagnosticiToDati(String severita, String severita_log4j, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setLabel("Messaggi Diagnostici");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        String[] tipoMsg = new String[]{"off", "fatal", "errorProtocol", "errorIntegration", "infoProtocol", "infoIntegration", "debugLow", "debugMedium", "debugHigh", "all"};
        de = new DataElement();
        de.setLabel("Livello di Log su DB");
        de.setType(DataElementType.SELECT);
        de.setName("severita");
        de.setValues(tipoMsg);
        de.setSelected(severita);
        dati.add(de);
        de = new DataElement();
        de.setName("severita_log4j");
        de.setLabel("Livello di Log su File");
        if (this.core.isVisualizzazioneConfigurazioneDiagnosticaLog4J()) {
            de.setType(DataElementType.SELECT);
            de.setValues(tipoMsg);
            de.setSelected(severita_log4j);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(severita_log4j);
        }
        dati.add(de);
    }

    public void addPortaSeveritaMessaggiDiagnosticiToDati(String stato, String severita, List<DataElement> dati) {
        DataElement de = new DataElement();
        de.setLabel("Messaggi Diagnostici");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        de.setName("severitaRidefinito");
        de.setType(DataElementType.SELECT);
        String[] valuesStato = new String[]{"default", "ridefinito"};
        String[] labelsStato = new String[]{"default", "ridefinito"};
        de.setSelected(stato);
        de.setLabels(labelsStato);
        de.setValues(valuesStato);
        de.setPostBack(true);
        dati.add(de);
        if ("ridefinito".equals(stato)) {
            String[] tipoMsg = new String[]{"off", "fatal", "errorProtocol", "errorIntegration", "infoProtocol", "infoIntegration", "debugLow", "debugMedium", "debugHigh", "all"};
            de = new DataElement();
            de.setLabel("Livello di Log su DB");
            de.setType(DataElementType.SELECT);
            de.setName("severita");
            de.setValues(tipoMsg);
            de.setSelected(severita);
            dati.add(de);
        }
    }

    public List<DataElement> configurazioneCambiaNome(List<DataElement> dati, TipoOperazione other, String nomeGruppo, boolean isPortaDelegata) throws DriverControlStationException {
        DataElement de = new DataElement();
        de.setLabel("Nome Gruppo");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("nomeGruppo");
        de.setValue(nomeGruppo);
        de.setRequired(true);
        dati.add(de);
        return dati;
    }

    public boolean configurazioneCambiaNomeCheck(TipoOperazione other, String nomeGruppo, List<String> listaNomiGruppiOccupati, boolean isPortaDelegata) throws DriverControlStationException {
        if (StringUtils.isEmpty((CharSequence)nomeGruppo)) {
            this.pd.setMessage("Deve essere indicato un nome per il gruppo");
            return false;
        }
        for (String nomeOccupato : listaNomiGruppiOccupati) {
            if (!nomeOccupato.equalsIgnoreCase(nomeGruppo)) continue;
            this.pd.setMessage("Il nome gruppo indicato &egrave; gi&agrave; utilizzato in un'altra configurazione");
            return false;
        }
        return true;
    }

    public DataElement getDataElementNotCorrelazioneApplicativa() {
        DataElement de = new DataElement();
        de.setLabel("Attenzione");
        de.setBold(true);
        de.setValue(CostantiControlStation.getLABEL_PORTE_CORRELAZIONE_APPLICATIVA_ATTENZIONE_MESSAGGIO(this.core.getPortaCorrelazioneApplicativaMaxLength()));
        de.setType(DataElementType.NOTE);
        return de;
    }

    public static String normalizeLabel(String label, int maxWidth) {
        if (label.length() > maxWidth) {
            return label.substring(0, maxWidth - 3) + "...";
        }
        return label;
    }

    public void addConfigurazioneCorsPorteToDati(TipoOperazione tipoOperazione, List<DataElement> dati, boolean showStato, String statoCorsPorta, boolean corsStato, TipoGestioneCORS corsTipo, boolean corsAllAllowOrigins, boolean corsAllAllowHeaders, boolean corsAllAllowMethods, String corsAllowHeaders, String corsAllowOrigins, String corsAllowMethods, boolean corsAllowCredential, String corsExposeHeaders, boolean corsMaxAge, int corsMaxAgeSeconds) throws DriverControlStationException {
        DataElement de;
        if (showStato) {
            de = new DataElement();
            de.setLabel("Gestione CORS");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("corsStatoPorta");
        de.setLabel("Stato");
        if (showStato) {
            try {
                de.setType(DataElementType.SELECT);
                String[] valuesStato = new String[]{"default", "ridefinito"};
                String[] labelsStato = new String[]{this.getGestioneCorsLabelDefault(true), "ridefinito"};
                de.setSelected(statoCorsPorta);
                de.setLabels(labelsStato);
                de.setValues(valuesStato);
                de.setPostBack(true);
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(statoCorsPorta);
        }
        dati.add(de);
        if (!showStato || statoCorsPorta.equals("ridefinito")) {
            this.addConfigurazioneCorsToDati(dati, corsStato, corsTipo, corsAllAllowOrigins, corsAllAllowHeaders, corsAllAllowMethods, corsAllowHeaders, corsAllowOrigins, corsAllowMethods, corsAllowCredential, corsExposeHeaders, corsMaxAge, corsMaxAgeSeconds, false, false);
        }
    }

    public void addConfigurazioneCorsToDati(List<DataElement> dati, boolean corsStato, TipoGestioneCORS corsTipo, boolean corsAllAllowOrigins, boolean corsAllAllowHeaders, boolean corsAllAllowMethods, String corsAllowHeaders, String corsAllowOrigins, String corsAllowMethods, boolean corsAllowCredential, String corsExposeHeaders, boolean corsMaxAge, int corsMaxAgeSeconds, boolean addTitle, boolean allHidden) {
        DataElement de;
        if (!allHidden && addTitle) {
            de = new DataElement();
            de.setLabel("Gestione CORS");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel(addTitle ? "Stato" : "");
        de.setName("corsStato");
        if (allHidden) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.SELECT);
            de.setPostBack(true);
            de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA);
            de.setSelected(corsStato ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue());
        }
        de.setValue(corsStato ? CostantiConfigurazione.ABILITATO.getValue() : CostantiConfigurazione.DISABILITATO.getValue());
        dati.add(de);
        if (corsStato) {
            de = new DataElement();
            de.setLabel("Tipo");
            de.setName("corsTipo");
            de.setValue(corsTipo.getValue());
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else if (TipoGestioneCORS.TRASPARENTE.equals((Object)corsTipo) || !this.isModalitaStandard()) {
                String[] corsTipiValues = new String[]{TipoGestioneCORS.GATEWAY.getValue(), TipoGestioneCORS.TRASPARENTE.getValue()};
                String[] corsTipiLabels = new String[]{"Gestito dal Gateway", "Gestito dall'Applicativo"};
                de.setType(DataElementType.SELECT);
                de.setPostBack(true);
                de.setValues(corsTipiValues);
                de.setLabels(corsTipiLabels);
                de.setSelected(corsTipo.getValue());
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            dati.add(de);
            if (TipoGestioneCORS.GATEWAY.equals((Object)corsTipo)) {
                if (!allHidden) {
                    de = new DataElement();
                    de.setType(DataElementType.SUBTITLE);
                    de.setLabel("Access Control");
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("All Allow Origins");
                de.setName("corsAAllOrig");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(corsAllAllowOrigins);
                    de.setPostBack(true);
                }
                de.setValue("" + corsAllAllowOrigins);
                dati.add(de);
                if (!corsAllAllowOrigins) {
                    de = new DataElement();
                    de.setLabel("Allow Origins");
                    de.setName("corsAllOrig");
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setRequired(true);
                        de.enableTags();
                    }
                    de.setValue(corsAllowOrigins);
                    dati.add(de);
                } else {
                    corsAllAllowMethods = false;
                    corsAllAllowHeaders = false;
                }
                de = new DataElement();
                de.setLabel("All Allow Methods");
                de.setName("corsAAllMeth");
                if (allHidden || corsAllAllowOrigins) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(corsAllAllowMethods);
                    de.setPostBack(true);
                }
                de.setValue("" + corsAllAllowMethods);
                dati.add(de);
                if (!corsAllAllowMethods || corsAllAllowOrigins) {
                    de = new DataElement();
                    de.setLabel("Allow Methods");
                    de.setName("corsAllMeth");
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setRequired(true);
                        de.enableTags();
                    }
                    de.setValue(corsAllowMethods);
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("All Allow Request Headers");
                de.setName("corsAAllHdr");
                if (allHidden || corsAllAllowOrigins) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(corsAllAllowHeaders);
                    de.setPostBack(true);
                }
                de.setValue("" + corsAllAllowHeaders);
                dati.add(de);
                if (!corsAllAllowHeaders || corsAllAllowOrigins) {
                    de = new DataElement();
                    de.setLabel("Allow Request Headers");
                    de.setName("corsAllHead");
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setRequired(true);
                        de.enableTags();
                    }
                    de.setValue(corsAllowHeaders);
                    dati.add(de);
                }
                de = new DataElement();
                de.setLabel("Allow Credentials");
                de.setName("corsAllCred");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(corsAllowCredential);
                }
                de.setValue("" + corsAllowCredential);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Expose Response Headers");
                de.setName("corsExpHead");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setType(DataElementType.TEXT_EDIT);
                    de.enableTags();
                }
                de.setValue(corsExposeHeaders);
                dati.add(de);
                de = new DataElement();
                de.setLabel("Max Age");
                de.setName("corsMaxAge");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setType(DataElementType.CHECKBOX);
                    de.setSelected(corsMaxAge);
                    de.setPostBack(true);
                }
                de.setValue("" + corsMaxAge);
                dati.add(de);
                if (corsMaxAge) {
                    de = new DataElement();
                    de.setLabel("Max Age Seconds");
                    de.setName("corsMaxAgeSec");
                    de.setValue("" + corsMaxAgeSeconds);
                    if (allHidden) {
                        de.setType(DataElementType.HIDDEN);
                    } else {
                        de.setType(DataElementType.NUMBER);
                        de.setMinValue(Integer.valueOf(-1));
                        de.setMaxValue(Integer.valueOf(Integer.MAX_VALUE));
                        de.setNote("Utilizza il valore -1 per disabilitare il caching");
                    }
                    dati.add(de);
                }
            }
        }
    }

    public CorsConfigurazione getGestioneCors(boolean corsStato, TipoGestioneCORS corsTipo, boolean corsAllAllowOrigins, boolean corsAllAllowHeaders, boolean corsAllAllowMethods, String corsAllowHeaders, String corsAllowOrigins, String corsAllowMethods, boolean corsAllowCredential, String corsExposeHeaders, boolean corsMaxAge, int corsMaxAgeSeconds) {
        CorsConfigurazione gestioneCors = new CorsConfigurazione();
        gestioneCors.setStato(corsStato ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
        if (corsStato) {
            gestioneCors.setTipo(corsTipo);
            if (corsTipo.equals((Object)TipoGestioneCORS.GATEWAY)) {
                gestioneCors.setAccessControlAllAllowOrigins(corsAllAllowOrigins ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
                if (!corsAllAllowOrigins) {
                    CorsConfigurazioneOrigin accessControlAllowOrigins = new CorsConfigurazioneOrigin();
                    accessControlAllowOrigins.setOriginList(Arrays.asList(corsAllowOrigins.split(",")));
                    gestioneCors.setAccessControlAllowOrigins(accessControlAllowOrigins);
                }
                gestioneCors.setAccessControlAllAllowHeaders(corsAllAllowHeaders ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
                if (!corsAllAllowHeaders) {
                    CorsConfigurazioneHeaders accessControlAllowHeaders = new CorsConfigurazioneHeaders();
                    accessControlAllowHeaders.setHeaderList(Arrays.asList(corsAllowHeaders.split(",")));
                    gestioneCors.setAccessControlAllowHeaders(accessControlAllowHeaders);
                }
                gestioneCors.setAccessControlAllAllowMethods(corsAllAllowMethods ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
                if (!corsAllAllowMethods) {
                    CorsConfigurazioneMethods accessControlAllowMethods = new CorsConfigurazioneMethods();
                    accessControlAllowMethods.setMethodList(Arrays.asList(corsAllowMethods.split(",")));
                    gestioneCors.setAccessControlAllowMethods(accessControlAllowMethods);
                }
                gestioneCors.setAccessControlAllowCredentials(corsAllowCredential ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
                CorsConfigurazioneHeaders accessControlExposeHeaders = new CorsConfigurazioneHeaders();
                accessControlExposeHeaders.setHeaderList(Arrays.asList(corsExposeHeaders.split(",")));
                gestioneCors.setAccessControlExposeHeaders(accessControlExposeHeaders);
                gestioneCors.setAccessControlMaxAge(corsMaxAge ? Integer.valueOf(corsMaxAgeSeconds) : null);
            }
        }
        return gestioneCors;
    }

    public boolean checkDataConfigurazioneCorsPorta(TipoOperazione tipoOperazione, boolean showStato, String statoCorsPorta) throws DriverControlStationException, ValidationException {
        if (showStato && (StringUtils.isEmpty((CharSequence)statoCorsPorta) || !statoCorsPorta.equals("default") && !statoCorsPorta.equals("ridefinito"))) {
            this.pd.setMessage(MessageFormat.format("Valore del campo {0} non valido.", "Stato"));
            return false;
        }
        if (!showStato || statoCorsPorta.equals("ridefinito")) {
            return this.checkDataCors();
        }
        return true;
    }

    public boolean checkDataURLInvocazione() throws DriverControlStationException {
        String urlInvocazionePA = this.getParameter("protocolConfigUrlPA");
        if (StringUtils.isEmpty((CharSequence)urlInvocazionePA)) {
            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Base URL"));
            return false;
        }
        if (urlInvocazionePA.contains(" ")) {
            this.pd.setMessage(MessageFormat.format("Non inserire spazi bianchi nei valori del campo {0}", "Base URL"));
            return false;
        }
        if (!this.checkLength(urlInvocazionePA, "Base URL", 1, 255)) {
            return false;
        }
        try {
            RegExpUtilities.validateUrl((String)urlInvocazionePA);
        }
        catch (Exception e) {
            this.pd.setMessage("Base URL non correttamente formata: " + e.getMessage());
            return false;
        }
        String urlInvocazionePD = this.getParameter("protocolConfigUrlPD");
        if (!StringUtils.isEmpty((CharSequence)urlInvocazionePD)) {
            if (urlInvocazionePD.contains(" ")) {
                this.pd.setMessage(MessageFormat.format("Non inserire spazi bianchi nei valori del campo {0}", "Base URL Fruizione"));
                return false;
            }
            if (!this.checkLength(urlInvocazionePD, "Base URL Fruizione", 1, 255)) {
                return false;
            }
            try {
                RegExpUtilities.validateUrl((String)urlInvocazionePD);
            }
            catch (Exception e) {
                this.pd.setMessage("Base URL Fruizione non correttamente formata: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public boolean checkDataCors() throws DriverControlStationException, ValidationException {
        String corsStatoTmp = this.getParameter("corsStato");
        boolean corsStato = ServletUtils.isCheckBoxEnabled((String)corsStatoTmp);
        if (corsStato) {
            TipoGestioneCORS corsTipo;
            String corsTipoTmp = this.getParameter("corsTipo");
            TipoGestioneCORS tipoGestioneCORS = corsTipo = corsTipoTmp != null ? TipoGestioneCORS.toEnumConstant((String)corsTipoTmp) : TipoGestioneCORS.GATEWAY;
            if (corsTipo.equals((Object)TipoGestioneCORS.GATEWAY)) {
                String corsExposeHeaders;
                List<String> asList;
                String corsAllAllowMethodsTmp;
                boolean corsAllAllowMethods;
                String corsAllAllowHeadersTmp;
                boolean corsAllAllowHeaders;
                String corsAllAllowOriginsTmp = this.getParameter("corsAAllOrig");
                boolean corsAllAllowOrigins = ServletUtils.isCheckBoxEnabled((String)corsAllAllowOriginsTmp);
                if (!corsAllAllowOrigins) {
                    String corsAllowOrigins = this.getParameter("corsAllOrig");
                    if (StringUtils.isNotEmpty((CharSequence)corsAllowOrigins)) {
                        List<String> asList2 = Arrays.asList(corsAllowOrigins.split(","));
                        for (String string : asList2) {
                            if (!string.contains(" ")) continue;
                            this.pd.setMessage(MessageFormat.format("Non inserire spazi bianchi nei valori del campo {0}", "Allow Origins"));
                            return false;
                        }
                    } else {
                        this.pd.setMessage(MessageFormat.format("Inserire almeno un valore nel campo {0}", "Allow Origins"));
                        return false;
                    }
                }
                if ((corsAllAllowHeaders = ServletUtils.isCheckBoxEnabled((String)(corsAllAllowHeadersTmp = this.getParameter("corsAAllHdr")))) && corsAllAllowOrigins) {
                    this.pd.setMessage(MessageFormat.format("Non \u00e8 consentito abilitare entrambe le modalit\u00e0 {0} e {1}", "All Allow Origins", "All Allow Request Headers"));
                    return false;
                }
                if (!corsAllAllowHeaders) {
                    String corsAllowHeaders = this.getParameter("corsAllHead");
                    if (StringUtils.isNotEmpty((CharSequence)corsAllowHeaders)) {
                        List<String> asList3 = Arrays.asList(corsAllowHeaders.split(","));
                        for (String string : asList3) {
                            if (!string.contains(" ")) continue;
                            this.pd.setMessage(MessageFormat.format("Non inserire spazi bianchi nei valori del campo {0}", "Allow Request Headers"));
                            return false;
                        }
                    } else {
                        this.pd.setMessage(MessageFormat.format("Inserire almeno un valore nel campo {0}", "Allow Request Headers"));
                        return false;
                    }
                }
                if ((corsAllAllowMethods = ServletUtils.isCheckBoxEnabled((String)(corsAllAllowMethodsTmp = this.getParameter("corsAAllMeth")))) && corsAllAllowOrigins) {
                    this.pd.setMessage(MessageFormat.format("Non \u00e8 consentito abilitare entrambe le modalit\u00e0 {0} e {1}", "All Allow Origins", "All Allow Methods"));
                    return false;
                }
                if (!corsAllAllowMethods) {
                    String corsAllowMethods = this.getParametroCorsAllowMethods("corsAllMeth");
                    if (StringUtils.isNotEmpty((CharSequence)corsAllowMethods)) {
                        asList = Arrays.asList(corsAllowMethods.split(","));
                        for (String string : asList) {
                            if (string.contains(" ")) {
                                this.pd.setMessage(MessageFormat.format("Non inserire spazi bianchi nei valori del campo {0}", "Allow Methods"));
                                return false;
                            }
                            try {
                                Enum.valueOf(HttpRequestMethod.class, string.toUpperCase());
                            }
                            catch (Exception e) {
                                this.pd.setMessage(MessageFormat.format("Il valore {0} indicato per il campo {1} non rappresenta un HTTP-Method valido", string, "Allow Methods"));
                                return false;
                            }
                        }
                    } else {
                        this.pd.setMessage(MessageFormat.format("Inserire almeno un valore nel campo {0}", "Allow Methods"));
                        return false;
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(corsExposeHeaders = this.getParameter("corsExpHead")))) {
                    asList = Arrays.asList(corsExposeHeaders.split(","));
                    for (String string : asList) {
                        if (!string.contains(" ")) continue;
                        this.pd.setMessage(MessageFormat.format("Non inserire spazi bianchi nei valori del campo {0}", "Expose Response Headers"));
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public void addDescrizioneVerificaConnettoreToDati(List<DataElement> dati, String server, String labelConnettore, Connettore connettore, boolean registro, String aliasConnettore) throws DriverControlStationException {
        ArrayList<Parameter> downloadCertServerParameters = new ArrayList<Parameter>();
        downloadCertServerParameters.add(new Parameter("idConn", "" + connettore.getId()));
        this.addDescrizioneVerificaConnettivitaToDati(dati, connettore, server, false, aliasConnettore, downloadCertServerParameters, false, false);
    }

    public void addVerificaConnettoreSceltaAlias(List<String> aliases, List<DataElement> dati) throws DriverControlStationException {
        DataElement de = new DataElement();
        de.setType(DataElementType.SELECT);
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> labels = new ArrayList<String>();
        values.add("Verifica su tutti i nodi");
        labels.add("Verifica su tutti i nodi");
        values.addAll(this.confCore.getJmxPdDAliases());
        for (String alias : this.confCore.getJmxPdDAliases()) {
            try {
                labels.add(this.confCore.getJmxPdDDescrizione(alias));
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        }
        de.setValues(values);
        de.setLabels(labels);
        de.setName("aliasNodo");
        de.setLabel("ID Cluster");
        de.setSize(this.getSize());
        dati.add(de);
    }

    public void addVerificaConnettoreHidden(List<DataElement> dati, String id, String idsogg, String idAsps, String idFruizione, long idConnettore, boolean accessoDaGruppi, boolean connettoreRegistro) throws DriverControlStationException {
        DataElement de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("id");
        de.setValue(id);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("idsogg");
        de.setValue(idsogg);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("idAsps");
        de.setValue(idAsps);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("myId");
        de.setValue(idFruizione);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("connettoreId");
        de.setValue("" + idConnettore);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("connettoreAccessoDaGruppi");
        de.setValue("" + accessoDaGruppi);
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.HIDDEN);
        de.setName("connettoreRegistro");
        de.setValue("" + connettoreRegistro);
        dati.add(de);
    }

    public boolean isConnettoreRidefinito(PortaApplicativa paDefault, PortaApplicativaServizioApplicativo paSADefault, PortaApplicativa paCurrent, PortaApplicativaServizioApplicativo paSACurrent, List<PortaApplicativaServizioApplicativo> list_paSACurrent) throws DriverControlStationException {
        boolean connettoreRidefinito;
        if (paDefault == null) {
            throw new DriverControlStationException("Param paDefault is null");
        }
        if (paCurrent == null) {
            throw new DriverControlStationException("Param paCurrent is null");
        }
        boolean bl = connettoreRidefinito = paDefault.getServizioApplicativoDefault() == null && (paCurrent.getServizioApplicativoDefault() != null || paSACurrent.getNome().equals(paCurrent.getNome())) || paDefault.getServizioApplicativoDefault() != null && (paCurrent.getServizioApplicativoDefault() == null || !paDefault.getServizioApplicativoDefault().equals(paCurrent.getServizioApplicativoDefault()) || paDefault.sizeServizioApplicativoList() != paCurrent.sizeServizioApplicativoList() || paDefault.sizeServizioApplicativoList() == 1 && paCurrent.sizeServizioApplicativoList() == 1 && !paDefault.getServizioApplicativo(0).getNome().equals(paCurrent.getServizioApplicativo(0).getNome()));
        if (!connettoreRidefinito) {
            boolean connettoreMultiploEnabled;
            boolean bl2 = connettoreMultiploEnabled = paCurrent.getBehaviour() != null;
            if (connettoreMultiploEnabled && paDefault.getServizioApplicativoDefault() == null && paCurrent.getServizioApplicativoDefault() == null && list_paSACurrent != null && !list_paSACurrent.isEmpty() && list_paSACurrent.size() > 1) {
                for (PortaApplicativaServizioApplicativo portaApplicativaServizioApplicativo : list_paSACurrent) {
                    if (!portaApplicativaServizioApplicativo.getNome().equals(paCurrent.getNome())) continue;
                    connettoreRidefinito = true;
                    break;
                }
            }
        }
        return connettoreRidefinito;
    }

    public String getTooltipConnettore(ServizioApplicativo sa, InvocazioneServizio is, boolean addExtInfo) throws DriverControlStationException {
        if (sa == null) {
            throw new DriverControlStationException("Param sa is null");
        }
        StringBuilder sbCon = new StringBuilder();
        if ("server".equals(sa.getTipo())) {
            sbCon.append("Applicativo Server");
            sbCon.append(": ");
            sbCon.append(sa.getNome());
            sbCon.append("&#10;");
        }
        sbCon.append(this.getLabelConnettore(is, addExtInfo, true));
        return sbCon.toString();
    }

    public String getClipBoardUrlConnettore(ServizioApplicativo sa, InvocazioneServizio is) throws DriverControlStationException {
        if (sa == null) {
            throw new DriverControlStationException("Param sa is null");
        }
        StringBuilder sbCon = new StringBuilder();
        sbCon.append(this.getClipBoardUrlConnettore(is));
        return sbCon.toString();
    }

    public String getClipBoardUrlConnettore(InvocazioneServizio is) throws DriverControlStationException {
        if (is == null) {
            throw new DriverControlStationException("Param is is null");
        }
        return this.getLabelConnettoreInternal(is.getConnettore(), false, false, false);
    }

    public String getClipBoardUrlConnettore(org.openspcoop2.core.registry.Connettore connettore) throws DriverControlStationException {
        if (connettore == null) {
            throw new DriverControlStationException("Param connettore is null");
        }
        return this.getLabelConnettoreInternal(connettore.mappingIntoConnettoreConfigurazione(), false, false, false);
    }

    public String getLabelConnettore(ServizioApplicativo sa, InvocazioneServizio is, boolean addExtInfo) throws DriverControlStationException {
        if (sa == null) {
            throw new DriverControlStationException("Param sa is null");
        }
        StringBuilder sbCon = new StringBuilder();
        sbCon.append(this.getLabelConnettore(is, addExtInfo, false));
        return sbCon.toString();
    }

    public String getLabelConnettore(InvocazioneServizio is, boolean addExtInfo, boolean tooltip) throws DriverControlStationException {
        if (is == null) {
            throw new DriverControlStationException("Param is is null");
        }
        Object urlConnettore = this.getLabelConnettore(is.getConnettore(), addExtInfo, tooltip);
        if (is.getGetMessage() != null && StatoFunzionalita.ABILITATO.equals((Object)is.getGetMessage())) {
            urlConnettore = (String)urlConnettore + " [MessageBox]";
        }
        return urlConnettore;
    }

    public String getLabelConnettore(org.openspcoop2.core.registry.Connettore connettore, boolean addExtInfo, boolean tooltip) throws DriverControlStationException {
        if (connettore == null) {
            throw new DriverControlStationException("Param connettore is null");
        }
        return this.getLabelConnettore(connettore.mappingIntoConnettoreConfigurazione(), addExtInfo, tooltip);
    }

    public String getLabelConnettore(Connettore connettore, boolean addExtInfo, boolean tooltip) throws DriverControlStationException {
        return this.getLabelConnettoreInternal(connettore, addExtInfo, tooltip, true);
    }

    private String getLabelConnettoreInternal(Connettore connettore, boolean addExtInfo, boolean tooltip, boolean addPrefix) throws DriverControlStationException {
        Object tipoLabel;
        if (connettore == null) {
            throw new DriverControlStationException("Param connettore is null");
        }
        Object urlConnettore = "";
        List cp = connettore.getPropertyList();
        String tipo = connettore.getTipo();
        TipiConnettore tipoC = TipiConnettore.toEnumFromName((String)connettore.getTipo());
        String labelC = connettore.getTipo();
        if (tipoC != null) {
            labelC = tipoC.getLabel();
        }
        Object object = tipoLabel = addPrefix ? "[" + labelC + "] " : "";
        if (connettore.getCustom() != null && connettore.getCustom().booleanValue() && !connettore.getTipo().equals(CostantiDB.CONNETTORE_TIPO_HTTPS) && !connettore.getTipo().equals(CostantiDB.CONNETTORE_TIPO_FILE) && !connettore.getTipo().equals(CostantiDB.CONNETTORE_TIPO_STATUS)) {
            tipo = "custom";
        }
        if (tipo.equals("custom")) {
            if (this.connettoriCore.isConfigurazionePluginsEnabled()) {
                tipoLabel = addPrefix ? "[" + TipiConnettore.CUSTOM.getLabel() + "] " : "";
                Plugin plugin = null;
                try {
                    plugin = this.confCore.getPlugin(TipoPlugin.CONNETTORE, connettore.getTipo(), false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                urlConnettore = plugin != null ? (String)tipoLabel + plugin.getLabel() : (String)tipoLabel + connettore.getTipo();
            } else {
                urlConnettore = (String)tipoLabel + "Personalizzato";
            }
        } else if (tipo.equals(TipiConnettore.DISABILITATO.getNome())) {
            urlConnettore = "disabilitato";
        } else if (tipo.equals(TipiConnettore.NULL.getNome())) {
            urlConnettore = (String)tipoLabel + "govway://dev/null";
        } else if (tipo.equals(TipiConnettore.NULLECHO.getNome())) {
            urlConnettore = (String)tipoLabel + "govway://echo";
        } else if (tipo.equals(TipiConnettore.STATUS.getNome())) {
            urlConnettore = (String)tipoLabel + "govway://status";
        } else {
            Property singlecp;
            int i;
            String propertyName = "location";
            if (tipo.equals(TipiConnettore.FILE.getNome())) {
                propertyName = "outputFile";
            }
            Object token = "";
            if (addExtInfo && (tipo.equals(TipiConnettore.HTTP.getNome()) || tipo.equals(TipiConnettore.HTTPS.getNome()))) {
                for (i = 0; i < connettore.sizePropertyList(); ++i) {
                    singlecp = (Property)cp.get(i);
                    if (!singlecp.getNome().equals("tokenPolicy") || singlecp.getValore() == null || !StringUtils.isNotEmpty((CharSequence)singlecp.getValore())) continue;
                    token = tooltip ? "[token: " + singlecp.getValore() + "]\n" : "[token] ";
                }
            }
            for (i = 0; i < connettore.sizePropertyList(); ++i) {
                singlecp = (Property)cp.get(i);
                if (!singlecp.getNome().equals(propertyName)) continue;
                if (!tipo.equals(TipiConnettore.HTTP.getNome()) && !tipo.equals(TipiConnettore.HTTPS.getNome())) {
                    urlConnettore = (String)tipoLabel + singlecp.getValore();
                    break;
                }
                urlConnettore = (String)token + singlecp.getValore();
                break;
            }
        }
        return urlConnettore;
    }

    public void addConfigurazioneResponseCachingPorteToDati(TipoOperazione tipoOperazione, List<DataElement> dati, boolean showStato, String statoResponseCachingPorta, boolean responseCachingEnabled, int responseCachingSeconds, boolean responseCachingMaxResponseSize, long responseCachingMaxResponseSizeBytes, boolean responseCachingDigestUrlInvocazione, boolean responseCachingDigestHeaders, boolean responseCachingDigestPayload, String responseCachingDigestHeadersNomiHeaders, StatoFunzionalitaCacheDigestQueryParameter responseCachingDigestQueryParameter, String responseCachingDigestNomiParametriQuery, boolean responseCachingCacheControlNoCache, boolean responseCachingCacheControlMaxAge, boolean responseCachingCacheControlNoStore, boolean visualizzaLinkConfigurazioneRegola, String servletResponseCachingConfigurazioneRegolaList, List<Parameter> paramsResponseCachingConfigurazioneRegolaList, int numeroResponseCachingConfigurazioneRegola) throws DriverControlStationException {
        DataElement de;
        if (showStato) {
            de = new DataElement();
            de.setLabel("Caching Risposta");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setName("resCacheStatoPorta");
        de.setLabel("Stato");
        if (showStato) {
            try {
                de.setType(DataElementType.SELECT);
                String[] valuesStato = new String[]{"default", "ridefinito"};
                String[] labelsStato = new String[]{this.getResponseCachingLabelDefault(true), "ridefinito"};
                de.setSelected(statoResponseCachingPorta);
                de.setLabels(labelsStato);
                de.setValues(valuesStato);
                de.setPostBack(true);
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(statoResponseCachingPorta);
        }
        dati.add(de);
        if (!showStato || statoResponseCachingPorta.equals("ridefinito")) {
            this.addResponseCachingToDati(dati, responseCachingEnabled, responseCachingSeconds, responseCachingMaxResponseSize, responseCachingMaxResponseSizeBytes, responseCachingDigestUrlInvocazione, responseCachingDigestHeaders, responseCachingDigestPayload, false, responseCachingDigestHeadersNomiHeaders, responseCachingDigestQueryParameter, responseCachingDigestNomiParametriQuery, responseCachingCacheControlNoCache, responseCachingCacheControlMaxAge, responseCachingCacheControlNoStore, visualizzaLinkConfigurazioneRegola, servletResponseCachingConfigurazioneRegolaList, paramsResponseCachingConfigurazioneRegolaList, numeroResponseCachingConfigurazioneRegola, false);
        }
    }

    public void addResponseCachingToDati(List<DataElement> dati, boolean responseCachingEnabled, int responseCachingSeconds, boolean responseCachingMaxResponseSize, long responseCachingMaxResponseSizeBytes, boolean responseCachingDigestUrlInvocazione, boolean responseCachingDigestHeaders, boolean responseCachingDigestPayload, boolean addTitle, String responseCachingDigestHeadersNomiHeaders, StatoFunzionalitaCacheDigestQueryParameter responseCachingDigestQueryParameter, String responseCachingDigestNomiParametriQuery, boolean responseCachingCacheControlNoCache, boolean responseCachingCacheControlMaxAge, boolean responseCachingCacheControlNoStore, boolean visualizzaLinkConfigurazioneRegola, String servletResponseCachingConfigurazioneRegolaList, List<Parameter> paramsResponseCachingConfigurazioneRegolaList, int numeroResponseCachingConfigurazioneRegola, boolean allHidden) {
        DataElement de;
        if (!allHidden && addTitle) {
            de = new DataElement();
            de.setLabel("Caching Risposta");
            de.setType(DataElementType.TITLE);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel(addTitle ? "Stato" : "");
        de.setName("resCacheStato");
        if (allHidden) {
            de.setType(DataElementType.HIDDEN);
        } else {
            de.setType(DataElementType.SELECT);
            de.setPostBack(true);
            de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA);
            de.setSelected(responseCachingEnabled ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
        }
        de.setValue(responseCachingEnabled ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
        dati.add(de);
        if (responseCachingEnabled) {
            de = new DataElement();
            de.setLabel("Cache Timeout (secondi)");
            de.setName("resCacheTimeout");
            de.setValue("" + responseCachingSeconds);
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.NUMBER);
                de.setMinValue(Integer.valueOf(1));
                de.setMaxValue(Integer.valueOf(Integer.MAX_VALUE));
            }
            dati.add(de);
            de = new DataElement();
            de.setLabel("Dimensione Max Risposta");
            de.setName("resCacheMaxResSize");
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(responseCachingMaxResponseSize);
                de.setPostBack(true);
            }
            de.setValue("" + responseCachingMaxResponseSize);
            dati.add(de);
            if (responseCachingMaxResponseSize) {
                de = new DataElement();
                de.setLabel("Dimensione Max (kb)");
                de.setName("resCacheMaxResSizeB");
                de.setValue("" + responseCachingMaxResponseSizeBytes);
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setType(DataElementType.NUMBER);
                    de.setMinValue(Integer.valueOf(1));
                    de.setMaxValue(Integer.valueOf(Integer.MAX_VALUE));
                }
                dati.add(de);
            }
            if (!allHidden) {
                de = new DataElement();
                de.setType(DataElementType.SUBTITLE);
                de.setLabel("Generazione Hash");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("URL di Richiesta");
            de.setName("resCacheDUri");
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA);
                de.setSelected(responseCachingDigestUrlInvocazione ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
            }
            de.setValue(responseCachingDigestUrlInvocazione ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
            dati.add(de);
            de = new DataElement();
            de.setLabel("URL Parameters");
            de.setName("resCacheDQueryPar");
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA_RESPONSE_CACHING_DIGEST_QUERY_PARAMETERS);
                if (responseCachingDigestQueryParameter != null) {
                    de.setSelected(responseCachingDigestQueryParameter.getValue());
                }
                de.setPostBack(true);
            }
            if (responseCachingDigestQueryParameter != null) {
                de.setValue(responseCachingDigestQueryParameter.getValue());
            }
            dati.add(de);
            if (StatoFunzionalitaCacheDigestQueryParameter.SELEZIONE_PUNTUALE.equals((Object)responseCachingDigestQueryParameter)) {
                de = new DataElement();
                de.setName("resCacheDQueryParNomi");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setType(DataElementType.TEXT_EDIT);
                    de.enableTags();
                    de.setNote("Indicare i parametri della URL da utilizzare per il calcolo dell'Hash");
                }
                de.setValue(responseCachingDigestNomiParametriQuery);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Payload");
            de.setName("resCacheDpay");
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA);
                de.setSelected(responseCachingDigestPayload ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
            }
            de.setValue(responseCachingDigestPayload ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
            dati.add(de);
            de = new DataElement();
            de.setLabel("Headers");
            de.setName("resCacheDHead");
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.SELECT);
                de.setValues(CostantiControlStation.SELECT_VALUES_STATO_FUNZIONALITA);
                de.setSelected(responseCachingDigestHeaders ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
                de.setPostBack(true);
            }
            de.setValue(responseCachingDigestHeaders ? StatoFunzionalita.ABILITATO.getValue() : StatoFunzionalita.DISABILITATO.getValue());
            dati.add(de);
            if (responseCachingDigestHeaders) {
                de = new DataElement();
                de.setName("resCacheDHeadNomiH");
                if (allHidden) {
                    de.setType(DataElementType.HIDDEN);
                } else {
                    de.setType(DataElementType.TEXT_EDIT);
                    de.enableTags();
                    de.setNote("Indicare gli Headers da utilizzare per il calcolo dell'Hash");
                }
                de.setValue(responseCachingDigestHeadersNomiHeaders);
                dati.add(de);
            }
            if (!allHidden) {
                de = new DataElement();
                de.setType(DataElementType.SUBTITLE);
                de.setLabel("Cache Control");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("No Cache");
            de.setName("resCacheCCNoC");
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(responseCachingCacheControlNoCache);
            }
            de.setValue("" + responseCachingCacheControlNoCache);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Max Age");
            de.setName("resCacheCCMA");
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(responseCachingCacheControlMaxAge);
            }
            de.setValue("" + responseCachingCacheControlMaxAge);
            dati.add(de);
            de = new DataElement();
            de.setLabel("No Store");
            de.setName("resCacheCCNoS");
            if (allHidden) {
                de.setType(DataElementType.HIDDEN);
            } else {
                de.setType(DataElementType.CHECKBOX);
                de.setSelected(responseCachingCacheControlNoStore);
            }
            de.setValue("" + responseCachingCacheControlNoStore);
            dati.add(de);
            if (!allHidden && visualizzaLinkConfigurazioneRegola) {
                boolean contaListeFromSession;
                de = new DataElement();
                de.setType(DataElementType.SUBTITLE);
                de.setLabel("Configurazione Avanzata");
                dati.add(de);
                de = new DataElement();
                de.setType(DataElementType.LINK);
                boolean bl = contaListeFromSession = ServletUtils.getContaListeFromSession((HttpSession)this.session) != null ? ServletUtils.getContaListeFromSession((HttpSession)this.session) : false;
                if (contaListeFromSession) {
                    de.setValue("Regole (" + numeroResponseCachingConfigurazioneRegola + ")");
                } else {
                    de.setValue("Regole");
                }
                de.setUrl(servletResponseCachingConfigurazioneRegolaList, paramsResponseCachingConfigurazioneRegolaList.toArray(new Parameter[paramsResponseCachingConfigurazioneRegolaList.size()]));
                dati.add(de);
            }
        }
    }

    public ResponseCachingConfigurazione getResponseCaching(boolean responseCachingEnabled, int responseCachingSeconds, boolean responseCachingMaxResponseSize, long responseCachingMaxResponseSizeBytes, boolean responseCachingDigestUrlInvocazione, boolean responseCachingDigestHeaders, boolean responseCachingDigestPayload, String responseCachingDigestHeadersNomiHeaders, StatoFunzionalitaCacheDigestQueryParameter responseCachingDigestQueryParameter, String responseCachingDigestNomiParametriQuery, boolean responseCachingCacheControlNoCache, boolean responseCachingCacheControlMaxAge, boolean responseCachingCacheControlNoStore, List<ResponseCachingConfigurazioneRegola> listaRegoleCachingConfigurazione) {
        ResponseCachingConfigurazione responseCaching = new ResponseCachingConfigurazione();
        responseCaching.setStato(responseCachingEnabled ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
        if (responseCachingEnabled) {
            responseCaching.setCacheTimeoutSeconds(Integer.valueOf(responseCachingSeconds));
            if (responseCachingMaxResponseSize) {
                responseCaching.setMaxMessageSize(Long.valueOf(responseCachingMaxResponseSizeBytes));
            }
            if (responseCachingDigestUrlInvocazione || responseCachingDigestHeaders || responseCachingDigestPayload) {
                ResponseCachingConfigurazioneHashGenerator hashGenerator = new ResponseCachingConfigurazioneHashGenerator();
                hashGenerator.setPayload(responseCachingDigestPayload ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
                hashGenerator.setRequestUri(responseCachingDigestUrlInvocazione ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
                hashGenerator.setQueryParameters(responseCachingDigestQueryParameter);
                if (StringUtils.isNotEmpty((CharSequence)responseCachingDigestNomiParametriQuery)) {
                    hashGenerator.setQueryParameterList(Arrays.asList(responseCachingDigestNomiParametriQuery.split(",")));
                }
                hashGenerator.setHeaders(responseCachingDigestHeaders ? StatoFunzionalita.ABILITATO : StatoFunzionalita.DISABILITATO);
                if (StringUtils.isNotEmpty((CharSequence)responseCachingDigestHeadersNomiHeaders)) {
                    hashGenerator.setHeaderList(Arrays.asList(responseCachingDigestHeadersNomiHeaders.split(",")));
                }
                responseCaching.setHashGenerator(hashGenerator);
            }
            ResponseCachingConfigurazioneControl control = new ResponseCachingConfigurazioneControl();
            control.setNoCache(responseCachingCacheControlNoCache);
            control.setMaxAge(responseCachingCacheControlMaxAge);
            control.setNoStore(responseCachingCacheControlNoStore);
            responseCaching.setControl(control);
            if (listaRegoleCachingConfigurazione != null) {
                for (ResponseCachingConfigurazioneRegola regola : listaRegoleCachingConfigurazione) {
                    responseCaching.addRegola(regola);
                }
            }
        }
        return responseCaching;
    }

    public boolean isResponseCachingAbilitato(ResponseCachingConfigurazione configurazione) {
        boolean abilitato = false;
        if (configurazione == null) {
            return false;
        }
        if (configurazione.getStato().equals((Object)StatoFunzionalita.ABILITATO)) {
            return true;
        }
        return abilitato;
    }

    public int numeroRegoleResponseCaching(ResponseCachingConfigurazione configurazione) {
        if (configurazione == null) {
            return 0;
        }
        if (configurazione.getStato().equals((Object)StatoFunzionalita.ABILITATO)) {
            return configurazione.sizeRegolaList();
        }
        return 0;
    }

    public int numeroRegoleProxyPass(ConfigurazioneUrlInvocazione configurazione) {
        if (configurazione == null) {
            return 0;
        }
        return configurazione.sizeRegolaList();
    }

    public int numeroPluginsRegistroArchivi() throws DriverControlStationException {
        try {
            return this.confCore.numeroPluginsArchiviList();
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public int numeroPluginsRegistroClassi() throws DriverControlStationException {
        try {
            return this.confCore.numeroPluginsClassiList();
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
    }

    public boolean isCorsAbilitato(CorsConfigurazione configurazione) {
        boolean abilitato = false;
        if (configurazione == null) {
            return false;
        }
        if (configurazione.getStato().equals((Object)StatoFunzionalita.ABILITATO)) {
            return true;
        }
        return abilitato;
    }

    public int numeroCanali(CanaliConfigurazione configurazione) {
        if (configurazione == null || configurazione.getStato() == null) {
            return 0;
        }
        if (configurazione.getStato().equals((Object)StatoFunzionalita.ABILITATO)) {
            return configurazione.sizeCanaleList();
        }
        return 0;
    }

    public int numeroNodi(CanaliConfigurazione configurazione) {
        if (configurazione == null || configurazione.getStato() == null) {
            return 0;
        }
        if (configurazione.getStato().equals((Object)StatoFunzionalita.ABILITATO)) {
            return configurazione.sizeNodoList();
        }
        return 0;
    }

    public boolean checkDataConfigurazioneResponseCachingPorta(TipoOperazione tipoOperazione, boolean showStato, String statoResponseCachingPorta) throws DriverControlStationException {
        if (showStato && (StringUtils.isEmpty((CharSequence)statoResponseCachingPorta) || !statoResponseCachingPorta.equals("default") && !statoResponseCachingPorta.equals("ridefinito"))) {
            this.pd.setMessage(MessageFormat.format("Valore del campo {0} non valido.", "Stato"));
            return false;
        }
        if (!showStato || statoResponseCachingPorta.equals("ridefinito")) {
            return this.checkDataResponseCaching();
        }
        return true;
    }

    public boolean checkDataResponseCaching() throws DriverControlStationException {
        String responseCachingDigestHeadersTmp;
        boolean responseCachingDigestHeaders;
        String responseCachingDigestQueryTmp = this.getParameter("resCacheDQueryPar");
        StatoFunzionalitaCacheDigestQueryParameter stato = null;
        if (responseCachingDigestQueryTmp != null) {
            try {
                stato = StatoFunzionalitaCacheDigestQueryParameter.toEnumConstant((String)responseCachingDigestQueryTmp, (boolean)true);
            }
            catch (Exception e) {
                throw new DriverControlStationException(e.getMessage(), e);
            }
        }
        if (StatoFunzionalitaCacheDigestQueryParameter.SELEZIONE_PUNTUALE.equals(stato)) {
            String responseCachingDigestNomiQueryParameters = this.getParameter("resCacheDQueryParNomi");
            if (StringUtils.isNotEmpty((CharSequence)responseCachingDigestNomiQueryParameters)) {
                List<String> asList = Arrays.asList(responseCachingDigestNomiQueryParameters.split(","));
                for (String string : asList) {
                    if (!string.contains(" ")) continue;
                    this.pd.setMessage(MessageFormat.format("Non inserire spazi bianchi nei valori del campo {0}", "URL Parameters"));
                    return false;
                }
            } else {
                this.pd.setMessage(MessageFormat.format("Inserire almeno un valore nel campo {0}", "URL Parameters"));
                return false;
            }
        }
        if (responseCachingDigestHeaders = ServletUtils.isCheckBoxEnabled((String)(responseCachingDigestHeadersTmp = this.getParameter("resCacheDHead")))) {
            String responseCachingDigestHeadersNomiHeaders = this.getParameter("resCacheDHeadNomiH");
            if (StringUtils.isNotEmpty((CharSequence)responseCachingDigestHeadersNomiHeaders)) {
                List<String> asList = Arrays.asList(responseCachingDigestHeadersNomiHeaders.split(","));
                for (String string : asList) {
                    if (!string.contains(" ")) continue;
                    this.pd.setMessage(MessageFormat.format("Non inserire spazi bianchi nei valori del campo {0}", "Headers"));
                    return false;
                }
            } else {
                this.pd.setMessage(MessageFormat.format("Inserire almeno un valore nel campo {0}", "Headers"));
                return false;
            }
        }
        return true;
    }

    public boolean checkRegolaResponseCaching() throws DriverControlStationException {
        String returnCode = this.getParameter("resCacheCCRegCode");
        String statusMinS = this.getParameter("resCacheCCRegMinCode");
        String statusMaxS = this.getParameter("resCacheCCRegMaxCode");
        String faultS = this.getParameter("resCacheCCRegFault");
        String cacheSecondsS = this.getParameter("resCacheCCRegTimeout");
        if (!this._checkReturnCode(returnCode, statusMinS, statusMaxS, "Codice Risposta", "Min", "Max")) {
            return false;
        }
        Integer cacheSeconds = null;
        if (StringUtils.isNotEmpty((CharSequence)cacheSecondsS)) {
            try {
                cacheSeconds = Integer.parseInt(cacheSecondsS);
                if (cacheSeconds < 1) {
                    this.pd.setMessage("Il valore inserito nel campo Cache Timeout (Secondi) non &egrave; valido, sono ammessi valori compresi tra 1 e 999.");
                    return false;
                }
            }
            catch (Exception e) {
                this.pd.setMessage("Il formato del campo Cache Timeout (Secondi) non &egrave; valido.");
                return false;
            }
        }
        return true;
    }

    public boolean _checkReturnCode(String returnCode, String statusMinS, String statusMaxS, String labelReturnCode, String labelReturnCodeMin, String labelReturnCodeMax) throws DriverControlStationException {
        Integer statusMin = null;
        Integer statusMax = null;
        if (!returnCode.equals("qualsiasi")) {
            if (returnCode.equals("esatto") && StringUtils.isEmpty((CharSequence)statusMinS)) {
                this.pd.setMessage("Il campo " + labelReturnCode + " &egrave; obbligatorio.");
                return false;
            }
            if (returnCode.equals("intervallo") && (StringUtils.isEmpty((CharSequence)statusMinS) || StringUtils.isEmpty((CharSequence)statusMaxS))) {
                this.pd.setMessage("Tutt gli intervalli del campo " + labelReturnCode + " sono obbligatori.");
                return false;
            }
            if (StringUtils.isNotEmpty((CharSequence)statusMinS)) {
                try {
                    statusMin = Integer.parseInt(statusMinS);
                    if (statusMin < 200 || statusMin > 599) {
                        if (returnCode.equals("esatto")) {
                            this.pd.setMessage("Il valore inserito nel campo " + labelReturnCode + " non &egrave; valido, sono ammessi valori compresi tra 200 e 599.");
                        } else {
                            this.pd.setMessage("Il valore inserito nell'intervallo sinistro non &egrave; valido, sono ammessi valori compresi tra 200 e 599.");
                        }
                        return false;
                    }
                    if (returnCode.equals("esatto")) {
                        statusMax = statusMin;
                    }
                }
                catch (Exception e) {
                    this.pd.setMessage("Il formato del campo " + labelReturnCodeMin + " non &egrave; valido.");
                    return false;
                }
            }
            if (returnCode.equals("intervallo") && StringUtils.isNotEmpty((CharSequence)statusMaxS)) {
                try {
                    statusMax = Integer.parseInt(statusMaxS);
                    if (statusMax < 200 || statusMax > 599) {
                        this.pd.setMessage("Il valore inserito nell'intervallo destro non &egrave; valido, sono ammessi valori compresi tra 200 e 599.");
                        return false;
                    }
                }
                catch (Exception e) {
                    this.pd.setMessage("Il formato del campo " + labelReturnCodeMax + " non &egrave; valido.");
                    return false;
                }
            }
            if (returnCode.equals("intervallo") && statusMax != null && statusMin != null && statusMin >= statusMax) {
                this.pd.setMessage("Il valore inserito nell'intervallo sinistro deve essere minore del valore inserito nell'intervallo destro.");
                return false;
            }
        }
        return true;
    }

    public List<DataElement> addResponseCachingConfigurazioneRegola(TipoOperazione tipoOP, String returnCode, String statusMin, String statusMax, String fault, String cacheSeconds, List<DataElement> dati) {
        DataElement dataElement = new DataElement();
        dataElement.setLabel("Regola");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        DataElement de = new DataElement();
        de.setLabel("Codice Risposta");
        de.setLabels(CostantiControlStation.SELECT_LABELS_CONFIGURAZIONE_RETURN_CODE);
        de.setValues(CostantiControlStation.SELECT_VALUES_CONFIGURAZIONE_RETURN_CODE);
        de.setType(DataElementType.SELECT);
        de.setName("resCacheCCRegCode");
        de.setPostBack(true);
        de.setSelected(returnCode);
        dati.add(de);
        if (!"qualsiasi".equals(returnCode)) {
            if ("esatto".equals(returnCode)) {
                de = this.getHttpReturnCodeDataElement("&nbsp;", "resCacheCCRegMinCode", statusMin, true);
                dati.add(de);
            }
            if ("intervallo".equals(returnCode)) {
                de = this.getHttpReturnCodeIntervallDataElement("&nbsp;", "resCacheCCRegMinCode", "resCacheCCRegMaxCode", statusMin, statusMax, true);
                dati.add(de);
            }
        }
        de = new DataElement();
        de.setLabel("Cache Timeout (Secondi)");
        de.setValue(cacheSeconds);
        de.setType(DataElementType.NUMBER);
        de.setName("resCacheCCRegTimeout");
        de.setSize(this.getSize());
        de.setMinValue(Integer.valueOf(1));
        de.reloadMinValue(false);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Fault");
        de.setName("resCacheCCRegFault");
        de.setType(DataElementType.CHECKBOX);
        de.setSelected(fault);
        de.setValue(fault);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addTrasformazioneRispostaToDatiOpAdd(String protocollo, List<DataElement> dati, String idTrasformazione, ServiceBinding serviceBinding, String nome, String returnCode, String statusMin, String statusMax, String pattern, String contentType) throws DriverControlStationException {
        return this.addTrasformazioneRispostaToDati(TipoOperazione.ADD, protocollo, dati, 0L, null, false, idTrasformazione, null, serviceBinding, nome, returnCode, statusMin, statusMax, pattern, contentType, null, null, 0, false, false, false, false, null, null, null, null, null, null, false, null, null, null, null);
    }

    public List<DataElement> addTrasformazioneRispostaToDati(TipoOperazione tipoOP, String protocollo, List<DataElement> dati, long idPorta, TrasformazioneRegolaRisposta risposta, boolean isPortaDelegata, String idTrasformazione, String idTrasformazioneRisposta, ServiceBinding serviceBindingParam, String nome, String returnCode, String statusMin, String statusMax, String pattern, String contentType, String servletTrasformazioniRispostaHeadersList, List<Parameter> parametriInvocazioneServletTrasformazioniRispostaHeaders, int numeroTrasformazioniRispostaHeaders, boolean trasformazioneContenutoRichiestaAbilitato, boolean trasformazioneRichiestaRestAbilitato, boolean trasformazioneRichiestaSoapAbilitato, boolean trasformazioneContenutoRispostaAbilitato, TipoTrasformazione trasformazioneContenutoRispostaTipo, BinaryParameter trasformazioneContenutoRispostaTemplate, String trasformazioneContenutoRispostaTipoCheck, String trasformazioneContenutoRispostaContentType, String trasformazioneContenutoRispostaReturnCode, org.openspcoop2.message.constants.ServiceBinding serviceBindingMessage, boolean trasformazioneRispostaSoapAbilitatoParam, String trasformazioneRispostaSoapEnvelope, TipoTrasformazione trasformazioneRispostaSoapEnvelopeTipo, BinaryParameter trasformazioneRispostaSoapEnvelopeTemplate, String trasformazioneRispostaSoapEnvelopeTipoCheck) throws DriverControlStationException {
        ServiceBinding infoServiceBinding = serviceBindingParam;
        if (trasformazioneRichiestaRestAbilitato) {
            infoServiceBinding = ServiceBinding.REST;
        } else if (trasformazioneRichiestaSoapAbilitato) {
            infoServiceBinding = ServiceBinding.SOAP;
        }
        DataElementInfo dInfoPatternTrasporto = new DataElementInfo("Valore");
        dInfoPatternTrasporto.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
        if (ServiceBinding.REST.equals((Object)infoServiceBinding)) {
            dInfoPatternTrasporto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_REST_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
        } else {
            dInfoPatternTrasporto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_SOAP_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
        }
        DataElement de = new DataElement();
        de.setLabel("Trasformazione");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("trResNome");
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Applicabilit&agrave;");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasf");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazione);
        dati.add(de);
        de = new DataElement();
        de.setValue("first");
        de.setType(DataElementType.HIDDEN);
        de.setName("trFirst");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasfRes");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazioneRisposta);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Codice Risposta");
        de.setLabels(CostantiControlStation.SELECT_LABELS_CONFIGURAZIONE_RETURN_CODE);
        de.setValues(CostantiControlStation.SELECT_VALUES_CONFIGURAZIONE_RETURN_CODE);
        de.setType(DataElementType.SELECT);
        de.setName("trResAppStat");
        de.setPostBack(true);
        de.setSelected(returnCode);
        dati.add(de);
        if (!"qualsiasi".equals(returnCode)) {
            if ("esatto".equals(returnCode)) {
                de = this.getHttpReturnCodeDataElement("&nbsp;", "trResAppStatMin", statusMin, true);
                dati.add(de);
            }
            if ("intervallo".equals(returnCode)) {
                de = this.getHttpReturnCodeIntervallDataElement("&nbsp;", "trResAppStatMin", "trResAppStatMax", statusMin, statusMax, true);
                dati.add(de);
            }
        }
        de = new DataElement();
        de.setLabel("Content Type");
        de.setName("trResAppCT");
        de.setType(DataElementType.TEXT_EDIT);
        de.setValue(contentType);
        de.enableTags();
        DataElementInfo dInfoCT = new DataElementInfo("Applicabilit&agrave; - Content Type");
        dInfoCT.setHeaderBody("Lista di Content-Type per i quali la regola di trasformazione verr\u00e0 utilizzata; di seguito i formati utilizzabili:");
        dInfoCT.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_TRASFORMAZIONI_APPLICABILITA_INFO_CONTENT_TYPE_VALORI);
        de.setInfo(dInfoCT);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Pattern");
        de.setName("trResAppPat");
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(3);
        de.setSize(this.getSize());
        de.setValue(pattern);
        DataElementInfo dInfoPattern = new DataElementInfo("Applicabilit&agrave; - Pattern");
        if (ServiceBinding.REST.equals((Object)infoServiceBinding)) {
            dInfoPattern.setHeaderBody("Espressione da applicare sul messaggio di risposta; se si ha un match la regola di trasformazione verr\u00e0 utilizzata.<br/>I tipi di espressione utilizzabili sono:");
            dInfoPattern.setListBody(CostantiControlStation.LABEL_CONFIGURAZIONE_TRASFORMAZIONI_APPLICABILITA_INFO_PATTERN_VALORI_REST);
        } else {
            dInfoPattern.setBody("Espressione XPath da applicare sul messaggio di risposta; se si ha un match la regola di trasformazione verr\u00e0 utilizzata.");
        }
        de.setInfo(dInfoPattern);
        dati.add(de);
        if (tipoOP.equals((Object)TipoOperazione.CHANGE)) {
            boolean contaListeFromSession;
            String postbackElement = this.getPostBackElementName();
            boolean old_trasformazioneRispostaContenutoTemplate = false;
            boolean old_trasformazioneRispostaSoapEnvelopeTemplate = false;
            de = new DataElement();
            de.setLabel("Regole di Trasformazione");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Trasporto");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Codice Risposta");
            de.setValue(trasformazioneContenutoRispostaReturnCode);
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("trResRetCode");
            de.setSize(this.getSize());
            de.setInfo(dInfoPatternTrasporto);
            de.setRequired(false);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            boolean bl = contaListeFromSession = ServletUtils.getContaListeFromSession((HttpSession)this.session) != null ? ServletUtils.getContaListeFromSession((HttpSession)this.session) : false;
            if (contaListeFromSession) {
                de.setValue("HTTP Headers (" + numeroTrasformazioniRispostaHeaders + ")");
            } else {
                de.setValue("HTTP Headers");
            }
            de.setUrl(servletTrasformazioniRispostaHeadersList, parametriInvocazioneServletTrasformazioniRispostaHeaders.toArray(new Parameter[parametriInvocazioneServletTrasformazioniRispostaHeaders.size()]));
            dati.add(de);
            de = new DataElement();
            de.setLabel("Contenuto");
            de.setType(DataElementType.SUBTITLE);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Abilitato");
            de.setName("trResConvEn");
            de.setType(DataElementType.CHECKBOX);
            de.setSelected(trasformazioneContenutoRispostaAbilitato);
            de.setPostBack(true);
            de.setValue("" + trasformazioneContenutoRispostaAbilitato);
            dati.add(de);
            if (trasformazioneContenutoRispostaAbilitato) {
                de = new DataElement();
                de.setLabel("Tipo Conversione");
                de.setLabels(TipoTrasformazione.toLabelList((org.openspcoop2.message.constants.ServiceBinding)serviceBindingMessage, (boolean)false));
                de.setValues(TipoTrasformazione.toStringList((org.openspcoop2.message.constants.ServiceBinding)serviceBindingMessage, (boolean)false));
                de.setType(DataElementType.SELECT);
                de.setName("trResConvTp");
                de.setPostBack(true);
                de.setSelected(trasformazioneContenutoRispostaTipo.getValue());
                this.setTemplateInfo(de, "Tipo Conversione", trasformazioneContenutoRispostaTipo, infoServiceBinding, true, protocollo, isPortaDelegata);
                dati.add(de);
                if (trasformazioneContenutoRispostaTipo.isTemplateRequired()) {
                    boolean templateRequired = true;
                    if (risposta != null) {
                        TipoTrasformazione oldTrasformazioneRispostaContenutoTipo;
                        old_trasformazioneRispostaContenutoTemplate = risposta.getConversioneTemplate() != null && risposta.getConversioneTemplate().length > 0;
                        TipoTrasformazione tipoTrasformazione = oldTrasformazioneRispostaContenutoTipo = StringUtils.isNotEmpty((CharSequence)risposta.getConversioneTipo()) ? TipoTrasformazione.toEnumConstant((String)risposta.getConversioneTipo()) : TipoTrasformazione.EMPTY;
                        if (trasformazioneContenutoRispostaTipo.equals((Object)oldTrasformazioneRispostaContenutoTipo)) {
                            templateRequired = false;
                        }
                    }
                    if (postbackElement != null && postbackElement.equals("trResConvTp")) {
                        old_trasformazioneRispostaContenutoTemplate = false;
                        templateRequired = true;
                    }
                    de = new DataElement();
                    de.setLabel("");
                    de.setName("trResConvTpChk");
                    de.setType(DataElementType.HIDDEN);
                    de.setValue(trasformazioneContenutoRispostaTipoCheck);
                    dati.add(de);
                    if (StringUtils.isNotEmpty((CharSequence)trasformazioneContenutoRispostaTipoCheck) && trasformazioneContenutoRispostaTipoCheck.equals("updateTipo")) {
                        templateRequired = true;
                    }
                    String trasformazioneRispostaContenutoLabel = "Template";
                    if (old_trasformazioneRispostaContenutoTemplate && StringUtils.isEmpty((CharSequence)trasformazioneContenutoRispostaTipoCheck)) {
                        trasformazioneRispostaContenutoLabel = "";
                        DataElement saveAs = new DataElement();
                        saveAs.setValue("Download Template Attuale");
                        saveAs.setType(DataElementType.LINK);
                        Parameter pIdTrasformazioneRegola = new Parameter("idTrasf", idTrasformazione);
                        Parameter pIdTrasformazioneRegolaRisposta = new Parameter("idTrasfRes", idTrasformazioneRisposta);
                        Parameter pIdAccordo = new Parameter("idAccordo", "" + idPorta);
                        Parameter pTipoAllegato = new Parameter("tipoDocumento", isPortaDelegata ? "pd" : "pa");
                        Parameter pTipoDoc = new Parameter("tipoDocumentoDaScaricare", isPortaDelegata ? "trasfResConvTemplate" : "trasfResConvTemplate");
                        saveAs.setUrl("downloadDocumento", new Parameter[]{pIdAccordo, pTipoAllegato, pTipoDoc, pIdTrasformazioneRegola, pIdTrasformazioneRegolaRisposta});
                        saveAs.setDisabilitaAjaxStatus();
                        dati.add(saveAs);
                    }
                    DataElement trasformazioneContenutoTemplateDataElement = trasformazioneContenutoRispostaTemplate.getFileDataElement(trasformazioneRispostaContenutoLabel, "", this.getSize());
                    trasformazioneContenutoTemplateDataElement.setRequired(templateRequired);
                    dati.add(trasformazioneContenutoTemplateDataElement);
                    dati.addAll(trasformazioneContenutoRispostaTemplate.getFileNameDataElement());
                    dati.add(trasformazioneContenutoRispostaTemplate.getFileIdDataElement());
                }
                boolean contentTypePerAttachmentSOAP = false;
                if (trasformazioneContenutoRispostaTipo.isTrasformazioneProtocolloEnabled() && trasformazioneRichiestaRestAbilitato && !TipoTrasformazione.EMPTY.equals((Object)trasformazioneContenutoRispostaTipo) && "2".equals(trasformazioneRispostaSoapEnvelope)) {
                    contentTypePerAttachmentSOAP = true;
                }
                if (!contentTypePerAttachmentSOAP && trasformazioneContenutoRispostaTipo.isContentTypeEnabled()) {
                    de = new DataElement();
                    de.setLabel("Content Type");
                    de.setName("trResCT");
                    de.setType(DataElementType.TEXT_EDIT);
                    de.setValue(StringEscapeUtils.escapeHtml4((String)trasformazioneContenutoRispostaContentType));
                    if (trasformazioneRichiestaRestAbilitato) {
                        de.setType(DataElementType.HIDDEN);
                        de.setValue("");
                    } else {
                        de.setInfo(dInfoPatternTrasporto);
                    }
                    dati.add(de);
                }
                if (trasformazioneContenutoRispostaTipo.isTrasformazioneProtocolloEnabled() && trasformazioneRichiestaRestAbilitato && !TipoTrasformazione.EMPTY.equals((Object)trasformazioneContenutoRispostaTipo)) {
                    boolean trasformazioneRispostaSoapAbilitato = trasformazioneRispostaSoapAbilitatoParam;
                    trasformazioneRispostaSoapAbilitato = true;
                    de = new DataElement();
                    de.setLabel("Trasformazione SOAP");
                    de.setType(DataElementType.SUBTITLE);
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Abilitato");
                    de.setName("trResSoapTr");
                    de.setType(DataElementType.HIDDEN);
                    de.setValue("" + trasformazioneRispostaSoapAbilitato);
                    dati.add(de);
                    de = new DataElement();
                    de.setLabel("Imbustamento SOAP");
                    de.setName("trResSoapEnv");
                    de.setLabels(CostantiControlStation.SELECT_LABELS_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_SOAP_ENVELOPE);
                    de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_SOAP_ENVELOPE);
                    de.setType(DataElementType.SELECT);
                    de.setSelected(trasformazioneRispostaSoapEnvelope);
                    de.setPostBack(true);
                    dati.add(de);
                    if (trasformazioneRispostaSoapEnvelope != null && "2".equals(trasformazioneRispostaSoapEnvelope)) {
                        de = new DataElement();
                        de.setLabel("Content Type Attachment");
                        de.setName("trResCT");
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setValue(trasformazioneContenutoRispostaContentType);
                        de.setInfo(dInfoPatternTrasporto);
                        de.setRequired(true);
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel("SOAP Body");
                        de.setType(DataElementType.SUBTITLE);
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel("Tipo Conversione");
                        de.setLabels(TipoTrasformazione.toLabelList((org.openspcoop2.message.constants.ServiceBinding)org.openspcoop2.message.constants.ServiceBinding.SOAP, (boolean)true));
                        de.setValues(TipoTrasformazione.toStringList((org.openspcoop2.message.constants.ServiceBinding)org.openspcoop2.message.constants.ServiceBinding.SOAP, (boolean)true));
                        de.setType(DataElementType.SELECT);
                        de.setName("trResSoapTp");
                        if (trasformazioneRispostaSoapEnvelopeTipo != null) {
                            de.setSelected(trasformazioneRispostaSoapEnvelopeTipo.getValue());
                        }
                        de.setPostBack(true);
                        this.setTemplateInfo(de, "Tipo Conversione", trasformazioneRispostaSoapEnvelopeTipo, infoServiceBinding, true, protocollo, isPortaDelegata);
                        dati.add(de);
                        if (trasformazioneRispostaSoapEnvelopeTipo != null && trasformazioneRispostaSoapEnvelopeTipo.isTemplateRequired()) {
                            boolean templateRequired = true;
                            if (risposta != null) {
                                TipoTrasformazione oldTrasformazioneSoapEnvelopeTipo;
                                TrasformazioneSoapRisposta oldTrasformazioneSoapRisposta = risposta.getTrasformazioneSoap();
                                old_trasformazioneRispostaSoapEnvelopeTemplate = oldTrasformazioneSoapRisposta != null && oldTrasformazioneSoapRisposta.getEnvelopeBodyConversioneTemplate() != null && oldTrasformazioneSoapRisposta.getEnvelopeBodyConversioneTemplate().length > 0;
                                String oldTrasformazioneSoapEnvelopeTipoS = oldTrasformazioneSoapRisposta != null ? oldTrasformazioneSoapRisposta.getEnvelopeBodyConversioneTipo() : null;
                                TipoTrasformazione tipoTrasformazione = oldTrasformazioneSoapEnvelopeTipo = StringUtils.isNotEmpty((CharSequence)oldTrasformazioneSoapEnvelopeTipoS) ? TipoTrasformazione.toEnumConstant((String)oldTrasformazioneSoapEnvelopeTipoS) : TipoTrasformazione.EMPTY;
                                if (trasformazioneRispostaSoapEnvelopeTipo.equals((Object)oldTrasformazioneSoapEnvelopeTipo)) {
                                    templateRequired = false;
                                }
                            }
                            if (postbackElement != null && postbackElement.equals("trResSoapTp")) {
                                old_trasformazioneRispostaSoapEnvelopeTemplate = false;
                                templateRequired = true;
                            }
                            de = new DataElement();
                            de.setLabel("");
                            de.setName("trResSoapTpChk");
                            de.setType(DataElementType.HIDDEN);
                            de.setValue(trasformazioneRispostaSoapEnvelopeTipoCheck);
                            dati.add(de);
                            if (StringUtils.isNotEmpty((CharSequence)trasformazioneRispostaSoapEnvelopeTipoCheck) && trasformazioneRispostaSoapEnvelopeTipoCheck.equals("updateTipo")) {
                                templateRequired = true;
                            }
                            String trasformazioneSoapEnvelopeTemplateLabel = "Template";
                            if (old_trasformazioneRispostaSoapEnvelopeTemplate && StringUtils.isEmpty((CharSequence)trasformazioneRispostaSoapEnvelopeTipoCheck)) {
                                trasformazioneSoapEnvelopeTemplateLabel = "";
                                DataElement saveAs = new DataElement();
                                saveAs.setValue("Download Template Attuale");
                                saveAs.setType(DataElementType.LINK);
                                Parameter pIdTrasformazioneRegola = new Parameter("idTrasf", idTrasformazione);
                                Parameter pIdTrasformazioneRegolaRisposta = new Parameter("idTrasfRes", idTrasformazioneRisposta);
                                Parameter pIdAccordo = new Parameter("idAccordo", "" + idPorta);
                                Parameter pTipoAllegato = new Parameter("tipoDocumento", isPortaDelegata ? "pd" : "pa");
                                Parameter pTipoDoc = new Parameter("tipoDocumentoDaScaricare", isPortaDelegata ? "trasfResSoapEnvTemp" : "trasfResSoapEnvTemp");
                                saveAs.setUrl("downloadDocumento", new Parameter[]{pIdAccordo, pTipoAllegato, pTipoDoc, pIdTrasformazioneRegola, pIdTrasformazioneRegolaRisposta});
                                dati.add(saveAs);
                            }
                            DataElement trasformazioneSoapEnvelopeTemplateDataElement = trasformazioneRispostaSoapEnvelopeTemplate.getFileDataElement(trasformazioneSoapEnvelopeTemplateLabel, "", this.getSize());
                            trasformazioneSoapEnvelopeTemplateDataElement.setRequired(templateRequired);
                            dati.add(trasformazioneSoapEnvelopeTemplateDataElement);
                            dati.addAll(trasformazioneRispostaSoapEnvelopeTemplate.getFileNameDataElement());
                            dati.add(trasformazioneRispostaSoapEnvelopeTemplate.getFileIdDataElement());
                        }
                    }
                }
            }
        }
        return dati;
    }

    public boolean trasformazioniCheckData(TipoOperazione tipoOp, long idPorta, String nome, TrasformazioneRegola regolaDBCheck_criteri, TrasformazioneRegola trasformazioneDBCheck_nome, TrasformazioneRegola oldRegola, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws DriverControlStationException {
        try {
            String pattern;
            if (nome == null || "".equals(nome)) {
                this.pd.setMessage("Indicare un valore nel campo 'Nome'");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.ADD)) {
                if (regolaDBCheck_criteri != null) {
                    this.pd.setMessage("&Egrave; gi&agrave; presente una regola di trasformazione con i parametri di applicabilit&agrave; indicati.");
                    return false;
                }
                if (trasformazioneDBCheck_nome != null) {
                    this.pd.setMessage("&Egrave; gi&agrave; presente una regola di trasformazione con il nome indicato.");
                    return false;
                }
            } else {
                if (regolaDBCheck_criteri != null && regolaDBCheck_criteri.getId().longValue() != oldRegola.getId().longValue()) {
                    this.pd.setMessage("&Egrave; gi&agrave; presente una regola di trasformazione con i parametri di applicabilit&agrave; indicati.");
                    return false;
                }
                if (trasformazioneDBCheck_nome != null && trasformazioneDBCheck_nome.getId().longValue() != oldRegola.getId().longValue()) {
                    this.pd.setMessage("&Egrave; gi&agrave; presente una regola di trasformazione con il nome indicato.");
                    return false;
                }
            }
            return (pattern = this.getParameter("trAppPat")) == null || !StringUtils.isNotEmpty((CharSequence)pattern) || !(org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding) ? !this.checkXPath(pattern, "Pattern") : !this.checkXPathOrJsonPath(pattern, "Pattern"));
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean trasformazioniRichiestaCheckData(TipoOperazione tipoOp, TrasformazioneRegola oldRegola, org.openspcoop2.message.constants.ServiceBinding serviceBindingMessage) throws DriverControlStationException {
        try {
            boolean trasformazioneContenutoAbilitato;
            String trasformazioneContenutoAbilitatoS = this.getParameter("trReqConvEn");
            boolean bl = trasformazioneContenutoAbilitato = trasformazioneContenutoAbilitatoS != null ? ServletUtils.isCheckBoxEnabled((String)trasformazioneContenutoAbilitatoS) : false;
            if (trasformazioneContenutoAbilitato) {
                TipoTrasformazione trasformazioneContenutoTipo;
                String trasformazioneContenutoTipoS = this.getParameter("trReqConvTp");
                TipoTrasformazione tipoTrasformazione = trasformazioneContenutoTipo = trasformazioneContenutoTipoS != null ? TipoTrasformazione.toEnumConstant((String)trasformazioneContenutoTipoS) : TipoTrasformazione.EMPTY;
                if (trasformazioneContenutoTipo.isTemplateRequired()) {
                    BinaryParameter trasformazioneContenutoTemplate = this.getBinaryParameter("trReqConvTem");
                    String trasformazioneContenutoTipoCheck = this.getParameter("trReqConvTpChk");
                    if (StringUtils.isNotEmpty((CharSequence)trasformazioneContenutoTipoCheck)) {
                        if (trasformazioneContenutoTemplate.getValue() == null || trasformazioneContenutoTemplate.getValue().length == 0) {
                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Template"));
                            return false;
                        }
                    } else if (oldRegola.getRichiesta() == null || oldRegola.getRichiesta().getConversioneTemplate() == null) {
                        this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Template"));
                        return false;
                    }
                }
                String trasformazioneRichiestaContentType = this.getParameter("trReqCT");
                switch (serviceBindingMessage) {
                    case REST: {
                        boolean trasformazioneSoapAbilitato;
                        String trasformazioneSoapAbilitatoS = this.getParameter("trSoapTr");
                        boolean bl2 = trasformazioneSoapAbilitato = trasformazioneSoapAbilitatoS != null ? ServletUtils.isCheckBoxEnabled((String)trasformazioneSoapAbilitatoS) : false;
                        if (trasformazioneSoapAbilitato) {
                            TipoTrasformazione trasformazioneSoapEnvelopeTipo;
                            String trasformazioneSoapEnvelope;
                            String trasformazioneSoapAction = this.getParameter("trSoapAc");
                            if (!this.checkLength255(trasformazioneSoapAction, "SOAP Action")) {
                                return false;
                            }
                            if (trasformazioneSoapAction != null && !"".equals(trasformazioneSoapAction)) {
                                try {
                                    DynamicUtils.validate((String)"SOAP Action", (String)trasformazioneSoapAction, (boolean)false);
                                }
                                catch (Exception e) {
                                    this.pd.setMessage("Il valore indicato nel parametro 'SOAP Action' non risulta corretto: " + e.getMessage());
                                    return false;
                                }
                            }
                            if (!"2".equals(trasformazioneSoapEnvelope = this.getParameter("trSoapEnv"))) break;
                            if (StringUtils.isEmpty((CharSequence)trasformazioneRichiestaContentType)) {
                                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Content Type Attachment"));
                                return false;
                            }
                            if (!this.checkLength255(trasformazioneRichiestaContentType, "Content Type Attachment")) {
                                return false;
                            }
                            String trasformazioneSoapEnvelopeTipoS = this.getParameter("trSoapTp");
                            TipoTrasformazione tipoTrasformazione2 = trasformazioneSoapEnvelopeTipo = trasformazioneSoapEnvelopeTipoS != null ? TipoTrasformazione.toEnumConstant((String)trasformazioneSoapEnvelopeTipoS) : TipoTrasformazione.EMPTY;
                            if (!trasformazioneSoapEnvelopeTipo.isTemplateRequired()) break;
                            BinaryParameter trasformazioneSoapEnvelopeTemplate = this.getBinaryParameter("trSoapEnvTemp");
                            String trasformazioneSoapEnvelopeTipoCheck = this.getParameter("trSoapTpChk");
                            if (StringUtils.isNotEmpty((CharSequence)trasformazioneSoapEnvelopeTipoCheck)) {
                                if (trasformazioneSoapEnvelopeTemplate.getValue() != null && trasformazioneSoapEnvelopeTemplate.getValue().length != 0) break;
                                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Template"));
                                return false;
                            }
                            if (oldRegola.getRichiesta() != null && oldRegola.getRichiesta().getTrasformazioneSoap() != null && oldRegola.getRichiesta().getTrasformazioneSoap().getEnvelopeBodyConversioneTemplate() != null) break;
                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Template"));
                            return false;
                        }
                        if (this.checkLength255(trasformazioneRichiestaContentType, "Content Type")) break;
                        return false;
                    }
                    case SOAP: {
                        boolean trasformazioneRestAbilitato;
                        String trasformazioneRestAbilitatoS = this.getParameter("trRestTr");
                        boolean bl3 = trasformazioneRestAbilitato = trasformazioneRestAbilitatoS != null ? ServletUtils.isCheckBoxEnabled((String)trasformazioneRestAbilitatoS) : false;
                        if (!trasformazioneRestAbilitato) break;
                        if (trasformazioneContenutoTipo.isContentTypeEnabled() && StringUtils.isEmpty((CharSequence)trasformazioneRichiestaContentType)) {
                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Content Type"));
                            return false;
                        }
                        if (!this.checkLength255(trasformazioneRichiestaContentType, "Content Type")) {
                            return false;
                        }
                        String trasformazioneRestMethod = this.getParametroHttpMethod("trRestMet");
                        if (StringUtils.isEmpty((CharSequence)trasformazioneRestMethod)) {
                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "HTTP Method"));
                            return false;
                        }
                        String trasformazioneRestPath = this.getParametroResourcePath("trRestPath");
                        if (StringUtils.isEmpty((CharSequence)trasformazioneRestPath)) {
                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Path"));
                            return false;
                        }
                        if (this.checkLength4000(trasformazioneRestPath, "Path")) break;
                        return false;
                    }
                }
            }
            if (org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBindingMessage)) {
                String trasformazioneRestMethod = this.getParameter("trRestMet");
                if (!StringUtils.isEmpty((CharSequence)trasformazioneRestMethod) && !this.checkLength255(trasformazioneRestMethod, "HTTP Method")) {
                    return false;
                }
                String trasformazioneRestPath = this.getParameter("trRestPath");
                if (!StringUtils.isEmpty((CharSequence)trasformazioneRestPath) && !this.checkLength4000(trasformazioneRestPath, "Path")) {
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean trasformazioniRispostaCheckData(TipoOperazione tipoOp, TrasformazioneRegola regolaRichiesta, TrasformazioneRegolaRisposta oldRegolaRisposta, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws DriverControlStationException {
        try {
            String statusMaxS;
            String statusMinS;
            String nome = this.getParameter("trResNome");
            if (nome == null || "".equals(nome)) {
                this.pd.setMessage("Indicare un valore nel campo 'Nome'");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            String returnCode = this.getParameter("trResAppStat");
            if (!this._checkReturnCode(returnCode, statusMinS = this.getParameter("trResAppStatMin"), statusMaxS = this.getParameter("trResAppStatMax"), "Codice Risposta", "Min", "Max")) {
                return false;
            }
            String pattern = this.getParameter("trResAppPat");
            if (pattern != null && StringUtils.isNotEmpty((CharSequence)pattern) && (org.openspcoop2.message.constants.ServiceBinding.SOAP.equals((Object)serviceBinding) ? !this.checkXPath(pattern, "Pattern") : !this.checkXPathOrJsonPath(pattern, "Pattern"))) {
                return false;
            }
            if (tipoOp.equals((Object)TipoOperazione.CHANGE)) {
                String trasformazioneContenutoRispostaAbilitatoS;
                boolean trasformazioneContenutoRispostaAbilitato;
                boolean trasformazioneRichiestaRestAbilitato = false;
                if (regolaRichiesta.getRichiesta() != null) {
                    trasformazioneRichiestaRestAbilitato = regolaRichiesta.getRichiesta().getTrasformazioneRest() != null;
                }
                boolean bl = trasformazioneContenutoRispostaAbilitato = (trasformazioneContenutoRispostaAbilitatoS = this.getParameter("trResConvEn")) != null ? ServletUtils.isCheckBoxEnabled((String)trasformazioneContenutoRispostaAbilitatoS) : false;
                if (trasformazioneContenutoRispostaAbilitato) {
                    TipoTrasformazione trasformazioneContenutoRispostaTipo;
                    String trasformazioneContenutoRispostaTipoS = this.getParameter("trResConvTp");
                    TipoTrasformazione tipoTrasformazione = trasformazioneContenutoRispostaTipo = trasformazioneContenutoRispostaTipoS != null ? TipoTrasformazione.toEnumConstant((String)trasformazioneContenutoRispostaTipoS) : TipoTrasformazione.EMPTY;
                    if (trasformazioneContenutoRispostaTipo.isTemplateRequired()) {
                        BinaryParameter trasformazioneContenutoTemplate = this.getBinaryParameter("trResConvTem");
                        String trasformazioneContenutoRispostaTipoCheck = this.getParameter("trResConvTpChk");
                        if (StringUtils.isNotEmpty((CharSequence)trasformazioneContenutoRispostaTipoCheck)) {
                            if (trasformazioneContenutoTemplate.getValue() == null || trasformazioneContenutoTemplate.getValue().length == 0) {
                                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Template"));
                                return false;
                            }
                        } else if (oldRegolaRisposta.getConversioneTemplate() == null) {
                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Template"));
                            return false;
                        }
                    }
                    String trasformazioneRispostaContentType = this.getParameter("trResCT");
                    String trasformazioneRispostaReturnCode = this.getParameter("trResRetCode");
                    if (trasformazioneRispostaReturnCode != null && StringUtils.isNotEmpty((CharSequence)trasformazioneRispostaReturnCode) && !trasformazioneRispostaReturnCode.contains("${")) {
                        try {
                            int returnCodeEsatto = Integer.parseInt(trasformazioneRispostaReturnCode);
                            if (returnCodeEsatto < 200) {
                                this.pd.setMessage("Il valore inserito nel campo Codice Risposta non &egrave; valido, sono ammessi valori compresi tra 200 e 599.");
                                return false;
                            }
                            if (returnCodeEsatto > 599) {
                                this.pd.setMessage("Il valore inserito nel campo Codice Risposta non &egrave; valido, sono ammessi valori compresi tra 200 e 599.");
                                return false;
                            }
                        }
                        catch (Exception e) {
                            this.pd.setMessage("Il formato del campo Codice Risposta non &egrave; valido.");
                            return false;
                        }
                    }
                    if (trasformazioneContenutoRispostaTipo.isTrasformazioneProtocolloEnabled() && trasformazioneRichiestaRestAbilitato) {
                        boolean trasformazioneSoapAbilitato;
                        String trasformazioneSoapAbilitatoS = this.getParameter("trResSoapTr");
                        boolean bl2 = trasformazioneSoapAbilitato = trasformazioneSoapAbilitatoS != null ? ServletUtils.isCheckBoxEnabled((String)trasformazioneSoapAbilitatoS) : false;
                        if (trasformazioneSoapAbilitato) {
                            String trasformazioneSoapEnvelope = this.getParameter("trResSoapEnv");
                            if ("2".equals(trasformazioneSoapEnvelope)) {
                                TipoTrasformazione trasformazioneSoapEnvelopeTipo;
                                if (StringUtils.isEmpty((CharSequence)trasformazioneRispostaContentType)) {
                                    this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Content Type Attachment"));
                                    return false;
                                }
                                if (!this.checkLength255(trasformazioneRispostaContentType, "Content Type Attachment")) {
                                    return false;
                                }
                                String trasformazioneSoapEnvelopeTipoS = this.getParameter("trResSoapTp");
                                TipoTrasformazione tipoTrasformazione2 = trasformazioneSoapEnvelopeTipo = trasformazioneSoapEnvelopeTipoS != null ? TipoTrasformazione.toEnumConstant((String)trasformazioneSoapEnvelopeTipoS) : TipoTrasformazione.EMPTY;
                                if (trasformazioneSoapEnvelopeTipo.isTemplateRequired()) {
                                    BinaryParameter trasformazioneSoapEnvelopeTemplate = this.getBinaryParameter("trResSoapEnvTemp");
                                    String trasformazioneSoapEnvelopeTipoCheck = this.getParameter("trResSoapTpChk");
                                    if (StringUtils.isNotEmpty((CharSequence)trasformazioneSoapEnvelopeTipoCheck)) {
                                        if (trasformazioneSoapEnvelopeTemplate.getValue() == null || trasformazioneSoapEnvelopeTemplate.getValue().length == 0) {
                                            this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Template"));
                                            return false;
                                        }
                                    } else if (oldRegolaRisposta.getTrasformazioneSoap().getEnvelopeBodyConversioneTemplate() == null) {
                                        this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Template"));
                                        return false;
                                    }
                                }
                            }
                        } else if (!this.checkLength255(trasformazioneRispostaContentType, "Content Type")) {
                            return false;
                        }
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addTrasformazioneToDatiOpAdd(List<DataElement> dati, Object oggetto, String nome, String stato, boolean azioniAll, String[] azioniDisponibiliList, String[] azioniDisponibiliLabelList, String[] azioni, String pattern, String contentType, String[] connettoriDisponibiliList, String[] connettoriDisponibiliLabelList, String[] connettori, ServiceBinding serviceBinding, boolean isPortaDelegata) throws DriverControlStationException {
        return this.addTrasformazioneToDati(TipoOperazione.ADD, dati, oggetto, null, nome, stato, azioniAll, azioniDisponibiliList, azioniDisponibiliLabelList, azioni, pattern, contentType, connettoriDisponibiliList, connettoriDisponibiliLabelList, connettori, serviceBinding, null, null, null, null, 0, isPortaDelegata, null, null, 0, null, null, 0);
    }

    public List<DataElement> addTrasformazioneToDati(TipoOperazione tipoOP, List<DataElement> dati, Object oggetto, String idTrasformazione, String nome, String stato, boolean azioniAll, String[] azioniDisponibiliList, String[] azioniDisponibiliLabelList, String[] azioni, String pattern, String contentType, String[] connettoriDisponibiliList, String[] connettoriDisponibiliLabelList, String[] connettori, ServiceBinding serviceBinding, String servletTrasformazioniRichiesta, List<Parameter> parametriInvocazioneServletTrasformazioniRichiesta, String servletTrasformazioniRispostaList, List<Parameter> parametriInvocazioneServletTrasformazioniRisposta, int numeroTrasformazioniRisposte, boolean isPortaDelegata, String servletTrasformazioniAutorizzazioneAutenticati, List<Parameter> parametriInvocazioneServletTrasformazioniAutorizzazioneAutenticati, int numAutenticati, String servletTrasformazioniApplicativiAutenticati, List<Parameter> parametriInvocazioneServletTrasformazioniApplicativiAutenticati, int numApplicativiAutenticati) throws DriverControlStationException {
        DataElement de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasf");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazione);
        dati.add(de);
        de = new DataElement();
        de.setValue("first");
        de.setType(DataElementType.HIDDEN);
        de.setName("trFirst");
        dati.add(de);
        de = new DataElement();
        de.setLabel("Trasformazione");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("trNome");
        de.setRequired(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        if (stato == null || "".equals(stato)) {
            stato = StatoFunzionalita.ABILITATO.getValue();
        }
        de.setSelected(stato);
        de.setType(DataElementType.SELECT);
        de.setName("trStato");
        de.setValues(ConfigurazioneCostanti.STATI);
        de.setLabels(ConfigurazioneCostanti.LABEL_CONFIGURAZIONE_STATI);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Applicabilit&agrave;");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setName("trAppAzioniAll");
        de.setPostBack(true);
        de.setValues(CostantiControlStation.PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_APPLICABILITA_AZIONI_ALL_VALUES);
        if (ServiceBinding.REST.equals((Object)serviceBinding)) {
            de.setLabels(CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_APPLICABILITA_RISORSE_ALL_VALUES);
        } else {
            de.setLabels(CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_APPLICABILITA_AZIONI_ALL_VALUES);
        }
        if (azioniAll) {
            de.setSelected("yes");
        } else {
            de.setSelected("no");
        }
        if (ServiceBinding.REST.equals((Object)serviceBinding)) {
            de.setLabel("Risorse");
        } else {
            de.setLabel("Azioni");
        }
        de.setType(DataElementType.SELECT);
        dati.add(de);
        if (!azioniAll) {
            de = new DataElement();
            de.setLabel("");
            de.setValues(azioniDisponibiliList);
            de.setLabels(azioniDisponibiliLabelList);
            de.setSelezionati(azioni);
            de.setType(DataElementType.MULTI_SELECT);
            de.setName("trAppAzioni");
            de.setRows(15);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Content Type");
        de.setName("trAppCT");
        de.setType(DataElementType.TEXT_EDIT);
        de.setValue(contentType);
        de.enableTags();
        DataElementInfo dInfoCT = new DataElementInfo("Applicabilit&agrave; - Content Type");
        dInfoCT.setHeaderBody("Lista di Content-Type per i quali la regola di trasformazione verr\u00e0 utilizzata; di seguito i formati utilizzabili:");
        dInfoCT.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_TRASFORMAZIONI_APPLICABILITA_INFO_CONTENT_TYPE_VALORI);
        de.setInfo(dInfoCT);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Pattern");
        de.setName("trAppPat");
        de.setType(DataElementType.TEXT_AREA);
        de.setRows(3);
        de.setSize(this.getSize());
        de.setValue(pattern);
        DataElementInfo dInfoPattern = new DataElementInfo("Applicabilit&agrave; - Pattern");
        if (ServiceBinding.REST.equals((Object)serviceBinding)) {
            dInfoPattern.setHeaderBody("Espressione da applicare sul messaggio di richiesta; se si ha un match la regola di trasformazione verr\u00e0 utilizzata.<br/>I tipi di espressione utilizzabili sono:");
            dInfoPattern.setListBody(CostantiControlStation.LABEL_CONFIGURAZIONE_TRASFORMAZIONI_APPLICABILITA_INFO_PATTERN_VALORI_REST);
        } else {
            dInfoPattern.setBody("Espressione XPath da applicare sul messaggio di richiesta; se si ha un match la regola di trasformazione verr\u00e0 utilizzata.");
        }
        de.setInfo(dInfoPattern);
        dati.add(de);
        if (connettoriDisponibiliList != null && connettoriDisponibiliList.length > 0) {
            de = new DataElement();
            de.setLabel("Connettori");
            de.setValues(connettoriDisponibiliList);
            de.setLabels(connettoriDisponibiliLabelList);
            de.setSelezionati(connettori);
            de.setType(DataElementType.MULTI_SELECT);
            de.setName("trAppConn");
            de.setRows(10);
            dati.add(de);
        }
        if (tipoOP.equals((Object)TipoOperazione.CHANGE)) {
            boolean contaListeFromSession;
            boolean isSupportatoAutenticazione;
            Boolean contaListe = ServletUtils.getContaListeFromSession((HttpSession)this.session);
            boolean autenticazione = false;
            String protocollo = null;
            boolean autenticazioneToken = false;
            TrasformazioneRegola tr = null;
            if (isPortaDelegata) {
                PortaDelegata pd = (PortaDelegata)oggetto;
                if (pd != null) {
                    autenticazione = !TipoAutenticazione.DISABILITATO.equals(pd.getAutenticazione());
                }
                isSupportatoAutenticazione = true;
                if (pd != null && pd.getServizio() != null && pd.getServizio().getTipo() != null) {
                    try {
                        protocollo = this.apsCore.getProtocolloAssociatoTipoServizio(pd.getServizio().getTipo());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                }
                if (pd != null && pd.getTrasformazioni() != null && pd.getTrasformazioni().sizeRegolaList() > 0) {
                    for (TrasformazioneRegola trCheck : pd.getTrasformazioni().getRegolaList()) {
                        if (!trCheck.getNome().equals(nome)) continue;
                        tr = trCheck;
                        break;
                    }
                }
                if (pd != null) {
                    autenticazioneToken = pd.getGestioneToken() != null && pd.getGestioneToken().getPolicy() != null;
                }
            } else {
                PortaApplicativa pa = (PortaApplicativa)oggetto;
                if (pa != null) {
                    boolean bl = autenticazione = !TipoAutenticazione.DISABILITATO.equals(pa.getAutenticazione());
                }
                if (pa != null && pa.getServizio() != null && pa.getServizio().getTipo() != null) {
                    try {
                        protocollo = this.apsCore.getProtocolloAssociatoTipoServizio(pa.getServizio().getTipo());
                    }
                    catch (Exception e) {
                        throw new DriverControlStationException(e.getMessage(), e);
                    }
                }
                try {
                    isSupportatoAutenticazione = this.soggettiCore.isSupportatoAutenticazioneApplicativiErogazione(protocollo);
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
                if (pa != null && pa.getTrasformazioni() != null && pa.getTrasformazioni().sizeRegolaList() > 0) {
                    for (TrasformazioneRegola trCheck : pa.getTrasformazioni().getRegolaList()) {
                        if (!trCheck.getNome().equals(nome)) continue;
                        tr = trCheck;
                        break;
                    }
                }
                if (pa != null) {
                    boolean bl = autenticazioneToken = pa.getGestioneToken() != null && pa.getGestioneToken().getPolicy() != null;
                }
            }
            if (servletTrasformazioniAutorizzazioneAutenticati != null && (autenticazione || autenticazioneToken)) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl(servletTrasformazioniAutorizzazioneAutenticati, parametriInvocazioneServletTrasformazioniAutorizzazioneAutenticati.toArray(new Parameter[parametriInvocazioneServletTrasformazioniAutorizzazioneAutenticati.size()]));
                if (isPortaDelegata) {
                    String labelApplicativi = "Servizi Applicativi";
                    if (!this.isModalitaCompleta()) {
                        labelApplicativi = "Applicativi";
                    }
                    if (contaListe.booleanValue()) {
                        ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi, (Long)Long.valueOf(numAutenticati));
                    } else {
                        ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi);
                    }
                } else if (contaListe.booleanValue()) {
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Soggetti", (Long)Long.valueOf(numAutenticati));
                } else {
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)"Soggetti");
                }
                dati.add(de);
            }
            boolean showLinkApplicativi = false;
            if (!isPortaDelegata && servletTrasformazioniApplicativiAutenticati != null) {
                if (autenticazioneToken) {
                    showLinkApplicativi = true;
                } else {
                    boolean bl = showLinkApplicativi = autenticazione && isSupportatoAutenticazione;
                }
            }
            if (showLinkApplicativi) {
                de = new DataElement();
                de.setType(DataElementType.LINK);
                de.setUrl(servletTrasformazioniApplicativiAutenticati, parametriInvocazioneServletTrasformazioniApplicativiAutenticati.toArray(new Parameter[parametriInvocazioneServletTrasformazioniApplicativiAutenticati.size()]));
                String labelApplicativi = "Servizi Applicativi";
                if (!this.isModalitaCompleta()) {
                    labelApplicativi = "Applicativi";
                }
                if (contaListe.booleanValue()) {
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi, (Long)Long.valueOf(numApplicativiAutenticati));
                } else {
                    ServletUtils.setDataElementCustomLabel((DataElement)de, (String)labelApplicativi);
                }
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Regole di Trasformazione");
            de.setType(DataElementType.TITLE);
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            StringBuilder sb = new StringBuilder();
            if (tr != null && tr.getRichiesta() != null) {
                if (tr.getRichiesta().sizeHeaderList() > 0 || tr.getRichiesta().sizeParametroUrlList() > 0 || ServiceBinding.REST.equals((Object)serviceBinding) && tr.getRichiesta().getTrasformazioneRest() != null && (tr.getRichiesta().getTrasformazioneRest().getMetodo() != null && StringUtils.isNotEmpty((CharSequence)tr.getRichiesta().getTrasformazioneRest().getMetodo()) || tr.getRichiesta().getTrasformazioneRest().getPath() != null && StringUtils.isNotEmpty((CharSequence)tr.getRichiesta().getTrasformazioneRest().getPath()))) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append("Trasporto".toLowerCase());
                }
                if (tr.getRichiesta().getConversioneTemplate() != null) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append("Contenuto".toLowerCase());
                }
                if (ServiceBinding.REST.equals((Object)serviceBinding) && tr.getRichiesta().getTrasformazioneSoap() != null) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append("Trasformazione SOAP".toLowerCase());
                }
                if (ServiceBinding.SOAP.equals((Object)serviceBinding) && tr.getRichiesta().getTrasformazioneRest() != null) {
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append("Trasformazione Rest".toLowerCase());
                }
            }
            if (sb.length() > 0) {
                de.setValue("Richiesta (" + CostantiConfigurazione.ABILITATO.getValue().toLowerCase() + ")");
            } else {
                de.setValue("Richiesta (" + CostantiConfigurazione.DISABILITATO.getValue().toLowerCase() + ")");
            }
            de.setUrl(servletTrasformazioniRichiesta, parametriInvocazioneServletTrasformazioniRichiesta.toArray(new Parameter[parametriInvocazioneServletTrasformazioniRichiesta.size()]));
            dati.add(de);
            de = new DataElement();
            de.setType(DataElementType.LINK);
            boolean bl = contaListeFromSession = ServletUtils.getContaListeFromSession((HttpSession)this.session) != null ? ServletUtils.getContaListeFromSession((HttpSession)this.session) : false;
            if (contaListeFromSession) {
                de.setValue("Risposte (" + numeroTrasformazioniRisposte + ")");
            } else {
                de.setValue("Risposte");
            }
            de.setUrl(servletTrasformazioniRispostaList, parametriInvocazioneServletTrasformazioniRisposta.toArray(new Parameter[parametriInvocazioneServletTrasformazioniRisposta.size()]));
            dati.add(de);
        }
        return dati;
    }

    public List<DataElement> addTrasformazioneRichiestaHeaderToDati(TipoOperazione tipoOP, String protocollo, boolean isPortaDelegata, List<DataElement> dati, String idTrasformazione, String idTrasformazioneRichiestaHeader, String nome, String tipo, String valore, String identificazione, ServiceBinding serviceBinding) {
        DataElementInfo dInfoPattern;
        DataElement de = new DataElement();
        de.setLabel("HTTP Header");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasf");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazione);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasfReqHead");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazioneRichiestaHeader);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Operazione");
        de.setName("trReqHeadTipo");
        de.setLabels(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO);
        de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO);
        de.setType(DataElementType.SELECT);
        de.setSelected(tipo);
        de.setRequired(true);
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setName("trReqHeadNome");
        de.setType(DataElementType.TEXT_EDIT);
        de.setRequired(true);
        de.setValue(nome);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Valore");
        de.setName("trReqHeadVal");
        if (!CostantiControlStation.VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_DELETE.equals(tipo)) {
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(3);
            de.setSize(this.getSize());
            de.setRequired(true);
            dInfoPattern = new DataElementInfo("Valore");
            dInfoPattern.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
            if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                dInfoPattern.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_REST_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
            } else {
                dInfoPattern.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_SOAP_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
            }
            de.setInfo(dInfoPattern);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(valore);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Identificazione Fallita");
        de.setName("trReqHeadIden");
        if (!CostantiControlStation.VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_DELETE.equals(tipo)) {
            de.setLabels(CostantiControlStation.SELECT_LABELS_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_IDENTIFICAZIONE_FALLITA_HEADER);
            de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_IDENTIFICAZIONE_FALLITA);
            de.setType(DataElementType.SELECT);
            de.setSelected(identificazione);
            dInfoPattern = new DataElementInfo("Identificazione Fallita");
            dInfoPattern.setHeaderBody("Permette di definire il comportamento del Gateway quando non riesce a risolvere parti dinamiche contenute nel valore indicato.<br/>Le configurazioni utilizzabili sono:");
            dInfoPattern.setListBody(CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_NOTE_VALORI_HEADER);
            de.setInfo(dInfoPattern);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(identificazione);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addTrasformazioneRichiestaUrlParameterToDati(TipoOperazione tipoOP, String protocollo, boolean isPortaDelegata, List<DataElement> dati, String idTrasformazione, String idTrasformazioneRichiestaUrlParameter, String nome, String tipo, String valore, String identificazione, ServiceBinding serviceBinding) {
        DataElementInfo dInfoPattern;
        DataElement de = new DataElement();
        de.setLabel("URL Parameter");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasf");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazione);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasfReqParam");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazioneRichiestaUrlParameter);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Operazione");
        de.setName("trReqParTipo");
        de.setLabels(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO);
        de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO);
        de.setType(DataElementType.SELECT);
        de.setSelected(tipo);
        de.setRequired(true);
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setName("trReqParNome");
        de.setType(DataElementType.TEXT_EDIT);
        de.setRequired(true);
        de.setValue(nome);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Valore");
        de.setName("trReqParVal");
        if (!CostantiControlStation.VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_DELETE.equals(tipo)) {
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(3);
            de.setSize(this.getSize());
            de.setRequired(true);
            dInfoPattern = new DataElementInfo("Valore");
            dInfoPattern.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
            if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                dInfoPattern.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_REST_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
            } else {
                dInfoPattern.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_SOAP_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
            }
            de.setInfo(dInfoPattern);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(valore);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Identificazione Fallita");
        de.setName("trReqParIden");
        if (!CostantiControlStation.VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_DELETE.equals(tipo)) {
            de.setLabels(CostantiControlStation.SELECT_LABELS_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_IDENTIFICAZIONE_FALLITA_PARAMETRO);
            de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_IDENTIFICAZIONE_FALLITA);
            de.setType(DataElementType.SELECT);
            de.setSelected(identificazione);
            dInfoPattern = new DataElementInfo("Identificazione Fallita");
            dInfoPattern.setHeaderBody("Permette di definire il comportamento del Gateway quando non riesce a risolvere parti dinamiche contenute nel valore indicato.<br/>Le configurazioni utilizzabili sono:");
            dInfoPattern.setListBody(CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_NOTE_VALORI_PARAMETRO);
            de.setInfo(dInfoPattern);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(identificazione);
        dati.add(de);
        return dati;
    }

    public List<DataElement> addTrasformazioneRispostaHeaderToDati(TipoOperazione tipoOP, String protocollo, boolean isPortaDelegata, List<DataElement> dati, String idTrasformazione, String idTrasformazioneRisposta, String idTrasformazioneRispostaHeader, String nome, String tipo, String valore, String identificazione, ServiceBinding serviceBinding) {
        DataElementInfo dInfoPattern;
        DataElement de = new DataElement();
        de.setLabel("HTTP Header");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasf");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazione);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasfRes");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazioneRisposta);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasfResHead");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazioneRispostaHeader);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Operazione");
        de.setName("trResHeadTipo");
        de.setLabels(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO);
        de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO);
        de.setType(DataElementType.SELECT);
        de.setSelected(tipo);
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setName("trResHeadNome");
        de.setType(DataElementType.TEXT_EDIT);
        de.setRequired(true);
        de.setValue(nome);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Valore");
        de.setName("trResHeadVal");
        if (!CostantiControlStation.VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_DELETE.equals(tipo)) {
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(3);
            de.setRequired(true);
            dInfoPattern = new DataElementInfo("Valore");
            dInfoPattern.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
            if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                dInfoPattern.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_REST_VALORI_CON_RISPOSTE((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
            } else {
                dInfoPattern.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_SOAP_VALORI_CON_RISPOSTE((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
            }
            de.setInfo(dInfoPattern);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(valore);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Identificazione Fallita");
        de.setName("trResHeadIden");
        if (!CostantiControlStation.VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_DELETE.equals(tipo)) {
            de.setLabels(CostantiControlStation.SELECT_LABELS_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_IDENTIFICAZIONE_FALLITA_HEADER);
            de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_IDENTIFICAZIONE_FALLITA);
            de.setType(DataElementType.SELECT);
            de.setSelected(identificazione);
            dInfoPattern = new DataElementInfo("Identificazione Fallita");
            dInfoPattern.setHeaderBody("Permette di definire il comportamento del Gateway quando non riesce a risolvere parti dinamiche contenute nel valore indicato.<br/>Le configurazioni utilizzabili sono:");
            dInfoPattern.setListBody(CostantiControlStation.LABEL_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_NOTE_VALORI_HEADER);
            de.setInfo(dInfoPattern);
        } else {
            de.setType(DataElementType.HIDDEN);
        }
        de.setValue(identificazione);
        dati.add(de);
        return dati;
    }

    public DataElement getHttpMethodDataElementTrasformazione(TipoOperazione tipoOperazione, String httpMethod) {
        return this.getHttpMethodDataElement(tipoOperazione, httpMethod, "HTTP Method", "trRestMet", false, null, null);
    }

    public List<DataElement> addTrasformazioneRichiestaToDati(TipoOperazione tipoOP, String protocollo, List<DataElement> dati, long idPorta, TrasformazioneRegolaRichiesta richiesta, boolean isPortaDelegata, String idTrasformazione, boolean trasformazioneContenutoAbilitato, TipoTrasformazione trasformazioneContenutoTipo, BinaryParameter trasformazioneContenutoTemplate, String trasformazioneContenutoTipoCheck, String trasformazioneRichiestaContentType, org.openspcoop2.message.constants.ServiceBinding serviceBindingMessage, boolean trasformazioneRestAbilitato, String trasformazioneRestMethod, String trasformazioneRestPath, boolean trasformazioneSoapAbilitato, String trasformazioneSoapAction, String trasformazioneSoapVersion, String trasformazioneSoapEnvelope, TipoTrasformazione trasformazioneSoapEnvelopeTipo, BinaryParameter trasformazioneSoapEnvelopeTemplate, String trasformazioneSoapEnvelopeTipoCheck, String servletTrasformazioniRichiestaHeadersList, List<Parameter> parametriInvocazioneServletTrasformazioniRichiestaHeaders, int numeroTrasformazioniRichiestaHeaders, String servletTrasformazioniRichiestaParametriList, List<Parameter> parametriInvocazioneServletTrasformazioniRichiestaParametri, int numeroTrasformazioniRichiestaParametri, ServiceBinding serviceBinding) throws DriverControlStationException {
        boolean contaListeFromSession;
        DataElementInfo dInfoPatternTrasporto = new DataElementInfo("Valore");
        dInfoPatternTrasporto.setHeaderBody("Il valore pu\u00f2 essere definito come costante o contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
        if (ServiceBinding.REST.equals((Object)serviceBinding)) {
            dInfoPatternTrasporto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_REST_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
        } else {
            dInfoPatternTrasporto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_SOAP_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
        }
        DataElement de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasf");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazione);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Trasformazione");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Trasporto");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        if (ServiceBinding.REST.equals((Object)serviceBinding) && !trasformazioneSoapAbilitato) {
            de = new DataElement();
            de.setLabel("HTTP Method");
            de.setValue(trasformazioneRestMethod);
            de.setType(DataElementType.TEXT_EDIT);
            de.setName("trRestMet");
            de.setSize(this.getSize());
            de.setInfo(dInfoPatternTrasporto);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Path");
            de.setValue(trasformazioneRestPath);
            de.setType(DataElementType.TEXT_AREA);
            de.setRows(1);
            de.setName("trRestPath");
            de.setSize(this.getSize());
            de.setInfo(dInfoPatternTrasporto);
            de.setNote("Ridefinire il Method e/o il Path solamente per modificarli rispetto alla richiesta originale");
            dati.add(de);
        }
        de = new DataElement();
        de.setType(DataElementType.LINK);
        boolean bl = contaListeFromSession = ServletUtils.getContaListeFromSession((HttpSession)this.session) != null ? ServletUtils.getContaListeFromSession((HttpSession)this.session) : false;
        if (contaListeFromSession) {
            de.setValue("HTTP Headers (" + numeroTrasformazioniRichiestaHeaders + ")");
        } else {
            de.setValue("HTTP Headers");
        }
        de.setUrl(servletTrasformazioniRichiestaHeadersList, parametriInvocazioneServletTrasformazioniRichiestaHeaders.toArray(new Parameter[parametriInvocazioneServletTrasformazioniRichiestaHeaders.size()]));
        dati.add(de);
        de = new DataElement();
        de.setType(DataElementType.LINK);
        if (contaListeFromSession) {
            de.setValue("URL Parameters (" + numeroTrasformazioniRichiestaParametri + ")");
        } else {
            de.setValue("URL Parameters");
        }
        de.setUrl(servletTrasformazioniRichiestaParametriList, parametriInvocazioneServletTrasformazioniRichiestaParametri.toArray(new Parameter[parametriInvocazioneServletTrasformazioniRichiestaParametri.size()]));
        dati.add(de);
        de = new DataElement();
        de.setLabel("Contenuto");
        de.setType(DataElementType.SUBTITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Abilitato");
        de.setName("trReqConvEn");
        de.setType(DataElementType.CHECKBOX);
        de.setSelected(trasformazioneContenutoAbilitato);
        de.setValue("" + trasformazioneContenutoAbilitato);
        de.setPostBack(true);
        dati.add(de);
        String postbackElement = this.getPostBackElementName();
        boolean old_trasformazioneContenutoTemplate = false;
        boolean old_trasformazioneSoapEnvelopeTemplate = false;
        if (trasformazioneContenutoAbilitato) {
            de = new DataElement();
            de.setLabel("Tipo Conversione");
            ArrayList<String> labels = TipoTrasformazione.toLabelList((org.openspcoop2.message.constants.ServiceBinding)serviceBindingMessage, (boolean)false);
            if (trasformazioneRestAbilitato) {
                newLabels = new ArrayList<String>();
                payloadVuotoSoap = TipoTrasformazione.EMPTY.getLabel(org.openspcoop2.message.constants.ServiceBinding.SOAP);
                for (String l : labels) {
                    if (l.equals(payloadVuotoSoap)) {
                        newLabels.add(TipoTrasformazione.EMPTY.getLabel(org.openspcoop2.message.constants.ServiceBinding.REST));
                        continue;
                    }
                    newLabels.add(l);
                }
                labels = newLabels;
            } else if (trasformazioneSoapAbilitato) {
                newLabels = new ArrayList();
                payloadVuotoSoap = TipoTrasformazione.EMPTY.getLabel(org.openspcoop2.message.constants.ServiceBinding.REST);
                for (String l : labels) {
                    if (l.equals(payloadVuotoSoap)) {
                        newLabels.add(TipoTrasformazione.EMPTY.getLabel(org.openspcoop2.message.constants.ServiceBinding.SOAP));
                        continue;
                    }
                    newLabels.add(l);
                }
                labels = newLabels;
            }
            de.setLabels((List)labels);
            de.setValues(TipoTrasformazione.toStringList((org.openspcoop2.message.constants.ServiceBinding)serviceBindingMessage, (boolean)false));
            de.setType(DataElementType.SELECT);
            de.setName("trReqConvTp");
            de.setPostBack(true);
            de.setSelected(trasformazioneContenutoTipo.getValue());
            this.setTemplateInfo(de, "Tipo Conversione", trasformazioneContenutoTipo, serviceBinding, false, protocollo, isPortaDelegata);
            dati.add(de);
            if (trasformazioneContenutoTipo.isTemplateRequired()) {
                boolean templateRequired = true;
                if (richiesta != null) {
                    TipoTrasformazione oldTrasformazioneContenutoTipo;
                    old_trasformazioneContenutoTemplate = richiesta.getConversioneTemplate() != null && richiesta.getConversioneTemplate().length > 0;
                    TipoTrasformazione tipoTrasformazione = oldTrasformazioneContenutoTipo = StringUtils.isNotEmpty((CharSequence)richiesta.getConversioneTipo()) ? TipoTrasformazione.toEnumConstant((String)richiesta.getConversioneTipo()) : TipoTrasformazione.EMPTY;
                    if (trasformazioneContenutoTipo.equals((Object)oldTrasformazioneContenutoTipo)) {
                        templateRequired = false;
                    }
                }
                if (postbackElement != null && postbackElement.equals("trReqConvTp")) {
                    old_trasformazioneContenutoTemplate = false;
                    templateRequired = true;
                }
                de = new DataElement();
                de.setLabel("");
                de.setName("trReqConvTpChk");
                de.setType(DataElementType.HIDDEN);
                de.setValue(trasformazioneContenutoTipoCheck);
                dati.add(de);
                if (StringUtils.isNotEmpty((CharSequence)trasformazioneContenutoTipoCheck) && trasformazioneContenutoTipoCheck.equals("updateTipo")) {
                    templateRequired = true;
                }
                String trasformazioneContenutoLabel = "Template";
                if (old_trasformazioneContenutoTemplate && StringUtils.isEmpty((CharSequence)trasformazioneContenutoTipoCheck)) {
                    trasformazioneContenutoLabel = "";
                    DataElement saveAs = new DataElement();
                    saveAs.setValue("Download Template Attuale");
                    saveAs.setType(DataElementType.LINK);
                    Parameter pIdTrasformazioneRegola = new Parameter("idTrasf", idTrasformazione);
                    Parameter pIdAccordo = new Parameter("idAccordo", "" + idPorta);
                    Parameter pTipoAllegato = new Parameter("tipoDocumento", isPortaDelegata ? "pd" : "pa");
                    Parameter pTipoDoc = new Parameter("tipoDocumentoDaScaricare", isPortaDelegata ? "trasfReqConvTemplate" : "trasfReqConvTemplate");
                    saveAs.setUrl("downloadDocumento", new Parameter[]{pIdAccordo, pTipoAllegato, pTipoDoc, pIdTrasformazioneRegola});
                    saveAs.setDisabilitaAjaxStatus();
                    dati.add(saveAs);
                }
                DataElement trasformazioneContenutoTemplateDataElement = trasformazioneContenutoTemplate.getFileDataElement(trasformazioneContenutoLabel, "", this.getSize());
                trasformazioneContenutoTemplateDataElement.setRequired(templateRequired);
                dati.add(trasformazioneContenutoTemplateDataElement);
                dati.addAll(trasformazioneContenutoTemplate.getFileNameDataElement());
                dati.add(trasformazioneContenutoTemplate.getFileIdDataElement());
            }
            boolean contentTypePerAttachmentSOAP = false;
            if (trasformazioneContenutoTipo.isTrasformazioneProtocolloEnabled() && org.openspcoop2.message.constants.ServiceBinding.REST.equals((Object)serviceBindingMessage) && trasformazioneSoapAbilitato && !TipoTrasformazione.EMPTY.equals((Object)trasformazioneContenutoTipo) && "2".equals(trasformazioneSoapEnvelope)) {
                contentTypePerAttachmentSOAP = true;
            }
            if (!contentTypePerAttachmentSOAP && trasformazioneContenutoTipo.isContentTypeEnabled()) {
                de = new DataElement();
                de.setLabel("Content Type");
                de.setName("trReqCT");
                de.setType(DataElementType.TEXT_EDIT);
                de.setValue(StringEscapeUtils.escapeHtml4((String)trasformazioneRichiestaContentType));
                switch (serviceBindingMessage) {
                    case REST: {
                        if (trasformazioneSoapAbilitato) {
                            de.setType(DataElementType.HIDDEN);
                            de.setValue("");
                            break;
                        }
                        de.setInfo(dInfoPatternTrasporto);
                        break;
                    }
                    case SOAP: {
                        de.setInfo(dInfoPatternTrasporto);
                        if (!trasformazioneRestAbilitato) break;
                        de.setRequired(true);
                    }
                }
                dati.add(de);
            }
            if (trasformazioneContenutoTipo.isTrasformazioneProtocolloEnabled()) {
                switch (serviceBindingMessage) {
                    case REST: {
                        de = new DataElement();
                        de.setLabel("Trasformazione SOAP");
                        de.setType(DataElementType.SUBTITLE);
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel("Abilitato");
                        de.setName("trSoapTr");
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(trasformazioneSoapAbilitato);
                        de.setValue("" + trasformazioneSoapAbilitato);
                        de.setPostBack(true);
                        dati.add(de);
                        if (!trasformazioneSoapAbilitato) break;
                        de = new DataElement();
                        de.setLabel("Versione");
                        String[] soapVersionLabels = new String[]{"SOAP 1.1", "SOAP 1.2"};
                        String[] soapVersionValues = new String[]{CostantiControlStation.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_RICHIESTA_SOAP_VERSION_11, CostantiControlStation.DEFAULT_VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_RICHIESTA_SOAP_VERSION_12};
                        de.setLabels(soapVersionLabels);
                        de.setValues(soapVersionValues);
                        de.setType(DataElementType.SELECT);
                        de.setName("trSoapVers");
                        de.setSelected(trasformazioneSoapVersion);
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel("SOAP Action");
                        de.setName("trSoapAc");
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setValue(trasformazioneSoapAction);
                        de.setInfo(dInfoPatternTrasporto);
                        dati.add(de);
                        if (TipoTrasformazione.EMPTY.equals((Object)trasformazioneContenutoTipo)) break;
                        de = new DataElement();
                        de.setLabel("Imbustamento SOAP");
                        de.setName("trSoapEnv");
                        de.setLabels(CostantiControlStation.SELECT_LABELS_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_SOAP_ENVELOPE);
                        de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_SOAP_ENVELOPE);
                        de.setType(DataElementType.SELECT);
                        de.setSelected(trasformazioneSoapEnvelope);
                        de.setPostBack(true);
                        dati.add(de);
                        if (!"2".equals(trasformazioneSoapEnvelope)) break;
                        de = new DataElement();
                        de.setLabel("Content Type Attachment");
                        de.setName("trReqCT");
                        de.setType(DataElementType.TEXT_EDIT);
                        de.setValue(trasformazioneRichiestaContentType);
                        de.setInfo(dInfoPatternTrasporto);
                        de.setRequired(true);
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel("SOAP Body");
                        de.setType(DataElementType.SUBTITLE);
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel("Tipo Conversione");
                        de.setLabels(TipoTrasformazione.toLabelList((org.openspcoop2.message.constants.ServiceBinding)org.openspcoop2.message.constants.ServiceBinding.SOAP, (boolean)true));
                        de.setValues(TipoTrasformazione.toStringList((org.openspcoop2.message.constants.ServiceBinding)org.openspcoop2.message.constants.ServiceBinding.SOAP, (boolean)true));
                        de.setType(DataElementType.SELECT);
                        de.setName("trSoapTp");
                        de.setSelected(trasformazioneSoapEnvelopeTipo.getValue());
                        de.setPostBack(true);
                        this.setTemplateInfo(de, "Tipo Conversione", trasformazioneSoapEnvelopeTipo, serviceBinding, false, protocollo, isPortaDelegata);
                        dati.add(de);
                        if (!trasformazioneSoapEnvelopeTipo.isTemplateRequired()) break;
                        boolean templateRequired = true;
                        if (richiesta != null) {
                            TipoTrasformazione oldTrasformazioneSoapEnvelopeTipo;
                            TrasformazioneSoap oldTrasformazioneSoap = richiesta.getTrasformazioneSoap();
                            old_trasformazioneSoapEnvelopeTemplate = oldTrasformazioneSoap != null && oldTrasformazioneSoap.getEnvelopeBodyConversioneTemplate() != null && oldTrasformazioneSoap.getEnvelopeBodyConversioneTemplate().length > 0;
                            String oldTrasformazioneSoapEnvelopeTipoS = oldTrasformazioneSoap != null ? oldTrasformazioneSoap.getEnvelopeBodyConversioneTipo() : null;
                            TipoTrasformazione tipoTrasformazione = oldTrasformazioneSoapEnvelopeTipo = StringUtils.isNotEmpty((CharSequence)oldTrasformazioneSoapEnvelopeTipoS) ? TipoTrasformazione.toEnumConstant((String)oldTrasformazioneSoapEnvelopeTipoS) : TipoTrasformazione.EMPTY;
                            if (trasformazioneSoapEnvelopeTipo.equals((Object)oldTrasformazioneSoapEnvelopeTipo)) {
                                templateRequired = false;
                            }
                        }
                        if (postbackElement != null && postbackElement.equals("trSoapTp")) {
                            old_trasformazioneSoapEnvelopeTemplate = false;
                            templateRequired = true;
                        }
                        de = new DataElement();
                        de.setLabel("");
                        de.setName("trSoapTpChk");
                        de.setType(DataElementType.HIDDEN);
                        de.setValue(trasformazioneSoapEnvelopeTipoCheck);
                        dati.add(de);
                        if (StringUtils.isNotEmpty((CharSequence)trasformazioneSoapEnvelopeTipoCheck) && trasformazioneSoapEnvelopeTipoCheck.equals("updateTipo")) {
                            templateRequired = true;
                        }
                        String trasformazioneSoapEnvelopeTemplateLabel = "Template";
                        if (old_trasformazioneSoapEnvelopeTemplate && StringUtils.isEmpty((CharSequence)trasformazioneSoapEnvelopeTipoCheck)) {
                            trasformazioneSoapEnvelopeTemplateLabel = "";
                            DataElement saveAs = new DataElement();
                            saveAs.setValue("Download Template Attuale");
                            saveAs.setType(DataElementType.LINK);
                            Parameter pIdTrasformazioneRegola = new Parameter("idTrasf", idTrasformazione);
                            Parameter pIdAccordo = new Parameter("idAccordo", "" + idPorta);
                            Parameter pTipoAllegato = new Parameter("tipoDocumento", isPortaDelegata ? "pd" : "pa");
                            Parameter pTipoDoc = new Parameter("tipoDocumentoDaScaricare", isPortaDelegata ? "trasfReqSoapEnvTemp" : "trasfReqSoapEnvTemp");
                            saveAs.setUrl("downloadDocumento", new Parameter[]{pIdAccordo, pTipoAllegato, pTipoDoc, pIdTrasformazioneRegola});
                            dati.add(saveAs);
                        }
                        DataElement trasformazioneSoapEnvelopeTemplateDataElement = trasformazioneSoapEnvelopeTemplate.getFileDataElement(trasformazioneSoapEnvelopeTemplateLabel, "", this.getSize());
                        trasformazioneSoapEnvelopeTemplateDataElement.setRequired(templateRequired);
                        dati.add(trasformazioneSoapEnvelopeTemplateDataElement);
                        dati.addAll(trasformazioneSoapEnvelopeTemplate.getFileNameDataElement());
                        dati.add(trasformazioneSoapEnvelopeTemplate.getFileIdDataElement());
                        break;
                    }
                    default: {
                        de = new DataElement();
                        de.setLabel("Trasformazione Rest");
                        de.setType(DataElementType.SUBTITLE);
                        dati.add(de);
                        de = new DataElement();
                        de.setLabel("Abilitato");
                        de.setName("trRestTr");
                        de.setType(DataElementType.CHECKBOX);
                        de.setSelected(trasformazioneRestAbilitato);
                        de.setValue("" + trasformazioneRestAbilitato);
                        de.setPostBack(true);
                        dati.add(de);
                        if (!trasformazioneRestAbilitato) break;
                        de = new DataElement();
                        de.setLabel("Path");
                        de.setValue(trasformazioneRestPath);
                        de.setType(DataElementType.TEXT_AREA);
                        de.setRows(3);
                        de.setName("trRestPath");
                        de.setSize(this.getSize());
                        de.setRequired(true);
                        de.setInfo(dInfoPatternTrasporto);
                        dati.add(de);
                        de = this.getHttpMethodDataElementTrasformazione(tipoOP, trasformazioneRestMethod);
                        dati.add(de);
                    }
                }
            }
        }
        return dati;
    }

    private void setTemplateInfo(DataElement de, String label, TipoTrasformazione trasformazioneContenutoTipo, ServiceBinding serviceBinding, boolean risposta, String protocollo, boolean isPortaDelegata) throws DriverControlStationException {
        if (trasformazioneContenutoTipo == null) {
            throw new DriverControlStationException("Param trasformazioneContenutoTipo is null");
        }
        switch (trasformazioneContenutoTipo) {
            case TEMPLATE: {
                DataElementInfo dInfoPatternContenuto = new DataElementInfo(label);
                dInfoPatternContenuto.setHeaderBody("Il template fornito pu\u00f2 contenere parti dinamiche risolte a runtime dal Gateway.<br/>Le espressioni utilizzabili sono:");
                if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                    if (risposta) {
                        dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_REST_VALORI_CON_RISPOSTE((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                    } else {
                        dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_REST_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                    }
                } else if (risposta) {
                    dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_SOAP_VALORI_CON_RISPOSTE((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                } else {
                    dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_TRASFORMAZIONI_TRASPORTO_SOAP_VALORI((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                }
                de.setInfo(dInfoPatternContenuto);
                break;
            }
            case FREEMARKER_TEMPLATE: 
            case CONTEXT_FREEMARKER_TEMPLATE: 
            case FREEMARKER_TEMPLATE_ZIP: {
                DataElementInfo dInfoPatternContenuto = new DataElementInfo(label);
                if (TipoTrasformazione.FREEMARKER_TEMPLATE.equals((Object)trasformazioneContenutoTipo) || TipoTrasformazione.CONTEXT_FREEMARKER_TEMPLATE.equals((Object)trasformazioneContenutoTipo)) {
                    dInfoPatternContenuto.setHeaderBody("Il file fornito deve rispettare la sintassi del template engine 'Freemarker'.<br/>\u00c8 possiile accedere ai seguenti oggetti resi disponibili a runtime dal Gateway:");
                } else {
                    dInfoPatternContenuto.setHeaderBody("Il file fornito deve essere un archivio zip contenenti dei files che rispettano la sintassi del template engine 'Freemarker'.<br/>GovWay richiede la presenza, all'interno dell'archivio zip, di un file indice che deve possedere il nome 'index.ftl'.<br/>\u00c8 possiile accedere ai seguenti oggetti resi disponibili a runtime dal Gateway:");
                }
                if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                    if (risposta) {
                        dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_OBJECT_REST_VALORI_CON_RISPOSTE_FREEMARKER((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                    } else {
                        dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_OBJECT_REST_VALORI_FREEMARKER((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                    }
                } else if (risposta) {
                    dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_OBJECT_SOAP_VALORI_CON_RISPOSTE_FREEMARKER((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                } else {
                    dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_OBJECT_SOAP_VALORI_FREEMARKER((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                }
                de.setInfo(dInfoPatternContenuto);
                break;
            }
            case VELOCITY_TEMPLATE: 
            case CONTEXT_VELOCITY_TEMPLATE: 
            case VELOCITY_TEMPLATE_ZIP: {
                DataElementInfo dInfoPatternContenuto = new DataElementInfo(label);
                if (TipoTrasformazione.VELOCITY_TEMPLATE.equals((Object)trasformazioneContenutoTipo) || TipoTrasformazione.CONTEXT_VELOCITY_TEMPLATE.equals((Object)trasformazioneContenutoTipo)) {
                    dInfoPatternContenuto.setHeaderBody("Il file fornito deve rispettare la sintassi del template engine 'Velocity'.<br/>\u00c8 possiile accedere ai seguenti oggetti resi disponibili a runtime dal Gateway:");
                } else {
                    dInfoPatternContenuto.setHeaderBody("Il file fornito deve essere un archivio zip contenenti dei files che rispettano la sintassi del template engine 'Velocity'.<br/>GovWay richiede la presenza, all'interno dell'archivio zip, di un file indice che deve possedere il nome 'index.vm'.<br/>\u00c8 possiile accedere ai seguenti oggetti resi disponibili a runtime dal Gateway:");
                }
                if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                    if (risposta) {
                        dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_OBJECT_REST_VALORI_CON_RISPOSTE_VELOCITY((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                    } else {
                        dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_OBJECT_REST_VALORI_VELOCITY((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                    }
                } else if (risposta) {
                    dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_OBJECT_SOAP_VALORI_CON_RISPOSTE_VELOCITY((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                } else {
                    dInfoPatternContenuto.setListBody(DynamicHelperCostanti.getLABEL_CONFIGURAZIONE_INFO_OBJECT_SOAP_VALORI_VELOCITY((boolean)this.isProfiloModIPA(protocollo), (boolean)isPortaDelegata, (boolean)false));
                }
                de.setInfo(dInfoPatternContenuto);
                break;
            }
            case ZIP: 
            case TGZ: 
            case TAR: {
                DataElementInfo dInfoPatternContenuto = new DataElementInfo(label);
                dInfoPatternContenuto.setHeaderBody("Il file fornito deve contenere propriet\u00e0 indicate come nome=valore in ogni linea.<BR/>Il nome della propriet\u00e0 corrisponde all'entry name all'interno dell'archivio (es. dir/subDir/entryName1).<BR/>Il valore della propriet\u00e0 corrisponde al contenuto dell'entry.<BR/><br/>\u00c8 possibile selezionare parti del messaggio, per associarle come contenuto dell'entry, utilizzando le seguenti espressioni dinamiche risolte a runtime dal Gateway:");
                if (ServiceBinding.REST.equals((Object)serviceBinding)) {
                    if (risposta) {
                        dInfoPatternContenuto.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_INFO_TEMPLATE_COMPRESS_REST_VALORI_CON_RISPOSTE);
                    } else {
                        dInfoPatternContenuto.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_INFO_TEMPLATE_COMPRESS_REST_VALORI);
                    }
                } else if (risposta) {
                    dInfoPatternContenuto.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_INFO_TEMPLATE_COMPRESS_SOAP_VALORI_CON_RISPOSTE);
                } else {
                    dInfoPatternContenuto.setListBody(DynamicHelperCostanti.LABEL_CONFIGURAZIONE_INFO_TEMPLATE_COMPRESS_SOAP_VALORI);
                }
                de.setInfo(dInfoPatternContenuto);
                break;
            }
        }
    }

    public boolean trasformazioniRispostaHeaderCheckData(TipoOperazione tipoOp) throws DriverControlStationException {
        try {
            String tipo = this.getParameter("trResHeadTipo");
            String nome = this.getParameter("trResHeadNome");
            String valore = this.getParameter("trResHeadVal");
            if (StringUtils.isEmpty((CharSequence)nome)) {
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Nome"));
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo Nome");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)tipo)) {
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Operazione"));
                return false;
            }
            if (!this.checkLength255(tipo, "Operazione")) {
                return false;
            }
            if (!CostantiControlStation.VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_DELETE.equals(tipo)) {
                if (StringUtils.isEmpty((CharSequence)valore)) {
                    this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Valore"));
                    return false;
                }
                try {
                    DynamicUtils.validate((String)"Valore", (String)valore, (boolean)false);
                }
                catch (Exception e) {
                    this.pd.setMessage("Il valore indicato nel parametro 'Valore' non risulta corretto: " + e.getMessage());
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean trasformazioniRichiestaHeaderCheckData(TipoOperazione tipoOp) throws DriverControlStationException {
        try {
            String tipo = this.getParameter("trReqHeadTipo");
            String nome = this.getParameter("trReqHeadNome");
            String valore = this.getParameter("trReqHeadVal");
            if (StringUtils.isEmpty((CharSequence)nome)) {
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Nome"));
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo Nome");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)tipo)) {
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Operazione"));
                return false;
            }
            if (!this.checkLength255(tipo, "Operazione")) {
                return false;
            }
            if (!CostantiControlStation.VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_DELETE.equals(tipo)) {
                if (StringUtils.isEmpty((CharSequence)valore)) {
                    this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Valore"));
                    return false;
                }
                try {
                    DynamicUtils.validate((String)"Valore", (String)valore, (boolean)false);
                }
                catch (Exception e) {
                    this.pd.setMessage("Il valore indicato nel parametro 'Valore' non risulta corretto: " + e.getMessage());
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public boolean trasformazioniRichiestaUrlParameterCheckData(TipoOperazione tipoOp) throws DriverControlStationException {
        try {
            String tipo = this.getParameter("trReqParTipo");
            String nome = this.getParameter("trReqParNome");
            String valore = this.getParameter("trReqParVal");
            if (StringUtils.isEmpty((CharSequence)nome)) {
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Nome"));
                return false;
            }
            if (nome.indexOf(" ") != -1) {
                this.pd.setMessage("Non inserire spazi nel campo Nome");
                return false;
            }
            if (!this.checkLength255(nome, "Nome")) {
                return false;
            }
            if (StringUtils.isEmpty((CharSequence)tipo)) {
                this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Operazione"));
                return false;
            }
            if (!this.checkLength255(tipo, "Operazione")) {
                return false;
            }
            if (!CostantiControlStation.VALUE_PARAMETRO_CONFIGURAZIONE_TRASFORMAZIONI_PARAMETRO_DELETE.equals(tipo)) {
                if (StringUtils.isEmpty((CharSequence)valore)) {
                    this.pd.setMessage(MessageFormat.format("Dati incompleti. &Egrave; necessario indicare: {0}", "Valore"));
                    return false;
                }
                try {
                    DynamicUtils.validate((String)"Valore", (String)valore, (boolean)false);
                }
                catch (Exception e) {
                    this.pd.setMessage("Il valore indicato nel parametro 'Valore' non risulta corretto: " + e.getMessage());
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            this.logError("Exception: " + e.getMessage(), e);
            throw new DriverControlStationException(e);
        }
    }

    public List<DataElement> addPorteTrasformazioniServizioApplicativoToDati(TipoOperazione tipoOp, List<DataElement> dati, String idTrasformazione, boolean fromList, String servizioApplicativo, String[] servizioApplicativoList, int sizeAttuale, boolean addMsgServiziApplicativoNonDisponibili, boolean addTitle) {
        DataElement de;
        if (fromList) {
            de = new DataElement();
            de.setName("trAppList");
            de.setType(DataElementType.HIDDEN);
            de.setValue("" + fromList);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasf");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazione);
        dati.add(de);
        if (servizioApplicativoList != null && servizioApplicativoList.length > 0) {
            String labelApplicativo = "Servizio Applicativo";
            if (!this.isModalitaCompleta()) {
                labelApplicativo = "Applicativo";
            }
            if (addTitle) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel(labelApplicativo);
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Nome");
            de.setType(DataElementType.SELECT);
            de.setName("servizioApplicativo");
            de.setValues(servizioApplicativoList);
            de.setSelected(servizioApplicativo);
            dati.add(de);
        } else if (addMsgServiziApplicativoNonDisponibili) {
            if (sizeAttuale > 0) {
                this.pd.setMessage("Non esistono ulteriori servizi applicativi associabili alla trasformazione", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            } else {
                this.pd.setMessage("Non esistono servizi applicativi associabili alla trasformazione", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            }
            this.pd.disableEditMode();
        }
        return dati;
    }

    public List<DataElement> addPorteTrasformazioniSoggettoToDati(TipoOperazione tipoOp, List<DataElement> dati, String idTrasformazione, boolean fromList, String[] soggettiLabelList, String[] soggettiList, String soggetto, int sizeAttuale, boolean addMsgSoggettiNonDisponibili, boolean addTitle) {
        DataElement de;
        if (fromList) {
            de = new DataElement();
            de.setName("trAppList");
            de.setType(DataElementType.HIDDEN);
            de.setValue("" + fromList);
            dati.add(de);
        }
        de = new DataElement();
        de.setLabel("Id");
        de.setName("idTrasf");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idTrasformazione);
        dati.add(de);
        if (soggettiList != null && soggettiList.length > 0) {
            if (addTitle) {
                de = new DataElement();
                de.setType(DataElementType.TITLE);
                de.setLabel("Soggetto");
                dati.add(de);
            }
            de = new DataElement();
            de.setLabel("Nome");
            de.setType(DataElementType.SELECT);
            de.setName("soggt");
            de.setLabels(soggettiLabelList);
            de.setValues(soggettiList);
            de.setSelected(soggetto);
            dati.add(de);
        } else if (addMsgSoggettiNonDisponibili) {
            if (sizeAttuale > 0) {
                this.pd.setMessage("Non esistono ulteriori soggetti associabili", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            } else {
                this.pd.setMessage("Non esistono soggetti associabili", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            }
            this.pd.disableEditMode();
        }
        return dati;
    }

    public List<DataElement> addPorteTrasformazioniServizioApplicativoAutorizzatiToDati(TipoOperazione tipoOp, List<DataElement> dati, String idTrasformazione, boolean fromList, String[] soggettiLabelList, String[] soggettiList, String soggetto, int sizeAttuale, Map<String, List<IDServizioApplicativoDB>> listServiziApplicativi, String sa, boolean addMsgApplicativiNonDisponibili) {
        DataElement de;
        if (fromList) {
            de = new DataElement();
            de.setName("trAppList");
            de.setType(DataElementType.HIDDEN);
            de.setValue("" + fromList);
            dati.add(de);
        }
        if (soggettiList != null && soggettiList.length > 0 && listServiziApplicativi != null && listServiziApplicativi.size() > 0) {
            de = new DataElement();
            de.setType(DataElementType.TITLE);
            de.setLabel("Applicativo");
            dati.add(de);
            de = new DataElement();
            de.setLabel("Id");
            de.setName("idTrasf");
            de.setType(DataElementType.HIDDEN);
            de.setValue(idTrasformazione);
            dati.add(de);
            de = new DataElement();
            de.setLabel("Soggetto");
            de.setName("soggt");
            de.setValue(soggetto);
            if (this.core.isMultitenant()) {
                de.setType(DataElementType.SELECT);
                de.setLabels(soggettiLabelList);
                de.setValues(soggettiList);
                de.setSelected(soggetto);
                de.setPostBack(true);
            } else {
                de.setType(DataElementType.HIDDEN);
            }
            dati.add(de);
            List<IDServizioApplicativoDB> listSA = null;
            if (soggetto != null && !"".equals(soggetto)) {
                listSA = listServiziApplicativi.get(soggetto);
            }
            if (listSA != null && !listSA.isEmpty()) {
                String[] saValues = new String[listSA.size()];
                String[] saLabels = new String[listSA.size()];
                int index = 0;
                for (IDServizioApplicativoDB saObject : listSA) {
                    saValues[index] = "" + saObject.getId();
                    saLabels[index] = saObject.getNome();
                    ++index;
                }
                de = new DataElement();
                de.setLabel("Nome");
                de.setType(DataElementType.SELECT);
                de.setName("saAuthz");
                de.setLabels(saLabels);
                de.setValues(saValues);
                de.setSelected(sa);
                dati.add(de);
            } else {
                this.pd.setMessage("Non esistono applicativi associabili per il soggetto selezionato", org.openspcoop2.web.lib.mvc.MessageType.INFO);
                this.pd.disableEditMode();
            }
        } else if (addMsgApplicativiNonDisponibili) {
            if (sizeAttuale > 0) {
                this.pd.setMessage("Non esistono ulteriori applicativi associabili", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            } else {
                this.pd.setMessage("Non esistono applicativi associabili", org.openspcoop2.web.lib.mvc.MessageType.INFO);
            }
            this.pd.disableEditMode();
        }
        return dati;
    }

    public DataElement getHttpMethodDataElement(TipoOperazione tipoOperazione, String httpMethod, String label, String name, boolean addQualsiasi, String labelQualsiasi, String valueQualsiasi) {
        DataElement de = new DataElement();
        de.setLabel(label);
        de.setSelected(httpMethod);
        de.setType(DataElementType.SELECT);
        de.setName(name);
        de.setSize(this.getSize());
        de.setPostBack(true);
        HttpMethod[] httpMethods = HttpMethod.values();
        int numeroOptions = !addQualsiasi ? httpMethods.length : httpMethods.length + 1;
        String[] values = new String[numeroOptions];
        String[] labels = new String[numeroOptions];
        if (addQualsiasi) {
            labels[0] = labelQualsiasi;
            values[0] = valueQualsiasi;
        }
        for (int i = 0; i < httpMethods.length; ++i) {
            HttpMethod method = httpMethods[i];
            labels[addQualsiasi ? i + 1 : i] = method.name();
            values[addQualsiasi ? i + 1 : i] = method.name();
        }
        de.setLabels(labels);
        de.setValues(values);
        return de;
    }

    public boolean checkAzioniUtilizzateErogazione(AccordiServizioParteSpecificaPorteApplicativeMappingInfo mappingInfo, String[] azioni) throws DriverControlStationException {
        List<MappingErogazionePortaApplicativa> list = mappingInfo.getListaMappingErogazione();
        return this.checkAzioniUtilizzateErogazione(list, azioni);
    }

    public boolean checkAzioniUtilizzateErogazione(List<MappingErogazionePortaApplicativa> list, String[] azioni) throws DriverControlStationException {
        if (azioni == null || azioni.length <= 0) {
            return true;
        }
        if (list != null && !list.isEmpty()) {
            for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : list) {
                IDPortaApplicativa idPA = mappingErogazionePortaApplicativa.getIdPortaApplicativa();
                List<AttivazionePolicy> listPolicies = this.confCore.attivazionePolicyList(null, RuoloPolicy.APPLICATIVA, idPA.getNome());
                List<ConfigurazioneAllarmeBean> listAllarmi = null;
                if (this.confCore.isConfigurazioneAllarmiEnabled()) {
                    listAllarmi = this.confCore.allarmiList(new ConsoleSearch(true), RuoloPorta.APPLICATIVA, idPA.getNome());
                }
                try {
                    PortaApplicativa pa = this.porteApplicativeCore.getPortaApplicativa(idPA);
                    if (this._checkAzioniUtilizzate(listPolicies, listAllarmi, pa.getTrasformazioni(), azioni, mappingErogazionePortaApplicativa.getDescrizione(), list.size())) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
            }
        }
        return true;
    }

    public boolean checkAzioniUtilizzateFruizione(AccordiServizioParteSpecificaFruitoriPorteDelegateMappingInfo mappingInfo, String[] azioni) throws DriverControlStationException {
        List<MappingFruizionePortaDelegata> list = mappingInfo.getListaMappingFruizione();
        return this.checkAzioniUtilizzateFruizione(list, azioni);
    }

    public boolean checkAzioniUtilizzateFruizione(List<MappingFruizionePortaDelegata> list, String[] azioni) throws DriverControlStationException {
        if (azioni == null || azioni.length <= 0) {
            return true;
        }
        if (list != null && !list.isEmpty()) {
            for (MappingFruizionePortaDelegata mappingFruizionePortaDelegata : list) {
                IDPortaDelegata idPD = mappingFruizionePortaDelegata.getIdPortaDelegata();
                List<AttivazionePolicy> listPolicies = this.confCore.attivazionePolicyList(null, RuoloPolicy.DELEGATA, idPD.getNome());
                List<ConfigurazioneAllarmeBean> listAllarmi = null;
                if (this.confCore.isConfigurazioneAllarmiEnabled()) {
                    listAllarmi = this.confCore.allarmiList(new ConsoleSearch(true), RuoloPorta.DELEGATA, idPD.getNome());
                }
                try {
                    PortaDelegata pd = this.porteDelegateCore.getPortaDelegata(idPD);
                    if (this._checkAzioniUtilizzate(listPolicies, listAllarmi, pd.getTrasformazioni(), azioni, mappingFruizionePortaDelegata.getDescrizione(), list.size())) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
            }
        }
        return true;
    }

    private boolean _checkAzioniUtilizzate(List<AttivazionePolicy> listPolicies, List<ConfigurazioneAllarmeBean> listAllarmi, Trasformazioni trasformazioni, String[] azioni, String descrizioneGruppo, int sizeGruppi) {
        String[] tmp;
        if (listPolicies != null && !listPolicies.isEmpty()) {
            for (AttivazionePolicy attivazionePolicy : listPolicies) {
                if (attivazionePolicy.getFiltro() == null || attivazionePolicy.getFiltro().getAzione() == null) continue;
                for (String azioneTmp : azioni) {
                    tmp = attivazionePolicy.getFiltro().getAzione().split(",");
                    if (tmp == null || tmp.length <= 0) continue;
                    for (String az : tmp) {
                        if (!azioneTmp.equals(az)) continue;
                        String nomePolicy = attivazionePolicy.getAlias();
                        if (nomePolicy == null || "".equals(nomePolicy)) {
                            nomePolicy = attivazionePolicy.getIdActivePolicy();
                        }
                        if (sizeGruppi > 1) {
                            this.pd.setMessage(MessageFormat.format("Operazione {0} non assegnabile poich&egrave; utilizzata come filtro della policy di rate limiting ''{1}'' (gruppo: {2})", azioneTmp, nomePolicy, descrizioneGruppo));
                        } else {
                            this.pd.setMessage(MessageFormat.format("Operazione {0} non assegnabile poich&egrave; utilizzata come filtro della policy di rate limiting ''{1}''", azioneTmp, nomePolicy, descrizioneGruppo));
                        }
                        return false;
                    }
                }
            }
        }
        if (listAllarmi != null && !listAllarmi.isEmpty()) {
            for (Allarme allarme : listAllarmi) {
                if (allarme.getFiltro() == null || allarme.getFiltro().getAzione() == null) continue;
                for (String azioneTmp : azioni) {
                    tmp = allarme.getFiltro().getAzione().split(",");
                    if (tmp == null || tmp.length <= 0) continue;
                    for (String az : tmp) {
                        if (!azioneTmp.equals(az)) continue;
                        String nomeAllarme = allarme.getAlias();
                        if (nomeAllarme == null || "".equals(nomeAllarme)) {
                            nomeAllarme = allarme.getNome();
                        }
                        if (sizeGruppi > 1) {
                            this.pd.setMessage(MessageFormat.format("Operazione {0} non assegnabile poich&egrave; utilizzata come filtro dell'allarme ''{1}'' (gruppo: {2})", azioneTmp, nomeAllarme, descrizioneGruppo));
                        } else {
                            this.pd.setMessage(MessageFormat.format("Operazione {0} non assegnabile poich&egrave; utilizzata come filtro dell'allarme ''{1}''", azioneTmp, nomeAllarme, descrizioneGruppo));
                        }
                        return false;
                    }
                }
            }
        }
        List trasformazione = null;
        if (trasformazioni != null) {
            trasformazione = trasformazioni.getRegolaList();
        }
        if (trasformazione != null && !trasformazione.isEmpty()) {
            for (TrasformazioneRegola regola : trasformazione) {
                if (regola.getApplicabilita() == null || regola.getApplicabilita().sizeAzioneList() <= 0) continue;
                List azioniTrasf = regola.getApplicabilita().getAzioneList();
                for (String azioneTmp : azioni) {
                    if (!azioniTrasf.contains(azioneTmp)) continue;
                    String nomeRegola = regola.getNome();
                    if (sizeGruppi > 1) {
                        this.pd.setMessage(MessageFormat.format("Operazione {0} non assegnabile poich&egrave; utilizzata nel criterio di applicabilit\u00e0 della regola di trasformazione ''{1}'' (gruppo: {2})", azioneTmp, nomeRegola, descrizioneGruppo));
                    } else {
                        this.pd.setMessage(MessageFormat.format("Operazione {0} non assegnabile poich&egrave; utilizzata nel criterio di applicabilit\u00e0 della regola di trasformazione ''{1}''", azioneTmp, nomeRegola, descrizioneGruppo));
                    }
                    return false;
                }
            }
        }
        return true;
    }

    public DataElement getHttpReturnCodeDataElement(String label, String name, String value, boolean required) {
        DataElement de = new DataElement();
        de.setLabel(label);
        de.setValue(value);
        de.setType(DataElementType.NUMBER);
        de.setName(name);
        de.setMinValue(Integer.valueOf(200));
        de.setMaxValue(Integer.valueOf(599));
        de.setSize(this.getSize());
        de.reloadMinValue(false);
        de.setRequired(required);
        return de;
    }

    public DataElement getHttpReturnCodeIntervallDataElement(String label, String nameMin, String nameMax, String valueMin, String valueMax, boolean required) {
        DataElement de = new DataElement();
        de.setLabel("&nbsp;");
        de.setValues(Arrays.asList(valueMin, valueMax));
        de.setType(DataElementType.INTERVAL_NUMBER);
        de.setNames(Arrays.asList(nameMin, nameMax));
        de.setMinValue(Integer.valueOf(200));
        de.setMaxValue(Integer.valueOf(599));
        de.setSize(this.getSize());
        de.reloadMinValue(false);
        de.setRequired(required);
        return de;
    }

    public DataElement getVersionDataElement(String label, String name, String value, boolean required) {
        DataElement de = new DataElement();
        de.setLabel(label);
        de.setValue(value);
        de.setType(DataElementType.NUMBER);
        de.setName(name);
        de.setMinValue(Integer.valueOf(1));
        de.setMaxValue(Integer.valueOf(999));
        de.setSize(this.getSize());
        de.setRequired(required);
        return de;
    }

    public String getUpperFirstChar(String value) {
        return ("" + value.charAt(0)).toUpperCase() + value.substring(1);
    }

    public boolean isFunzionalitaProtocolloSupportataDalProtocollo(String protocollo, org.openspcoop2.message.constants.ServiceBinding serviceBinding, FunzionalitaProtocollo funzionalitaProtocollo) throws DriverRegistroServiziNotFound, DriverRegistroServiziException, DriverConfigurazioneException {
        if (serviceBinding == null) {
            List<org.openspcoop2.message.constants.ServiceBinding> serviceBindingListProtocollo = this.core.getServiceBindingListProtocollo(protocollo);
            boolean supportato = true;
            if (serviceBindingListProtocollo != null && serviceBindingListProtocollo.size() > 0) {
                for (org.openspcoop2.message.constants.ServiceBinding serviceBinding2 : serviceBindingListProtocollo) {
                    boolean supportatoTmp = this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding2, funzionalitaProtocollo);
                    supportato = supportato || supportatoTmp;
                }
            }
            return supportato;
        }
        return this.core.isFunzionalitaProtocolloSupportataDalProtocollo(protocollo, serviceBinding, funzionalitaProtocollo);
    }

    public List<DataElement> addProprietaAutorizzazioneCustomToDati(List<DataElement> dati, TipoOperazione tipoOp, String nome, String valore) {
        DataElement de = new DataElement();
        de.setLabel("Propriet&agrave;");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (TipoOperazione.ADD.equals((Object)tipoOp)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nome");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Valore");
        de.setName("valore");
        this.core.getLockUtilities().lockProperty(de, valore);
        de.setRequired(true);
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }

    public List<DataElement> addProprietaAutenticazioneCustomToDati(List<DataElement> dati, TipoOperazione tipoOp, String nome, String valore) {
        DataElement de = new DataElement();
        de.setLabel("Propriet&agrave;");
        de.setType(DataElementType.TITLE);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        if (TipoOperazione.ADD.equals((Object)tipoOp)) {
            de.setType(DataElementType.TEXT_EDIT);
            de.setRequired(true);
        } else {
            de.setType(DataElementType.TEXT);
        }
        de.setName("nome");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Valore");
        de.setName("valore");
        this.core.getLockUtilities().lockProperty(de, valore);
        de.setRequired(true);
        de.setSize(this.getSize());
        dati.add(de);
        return dati;
    }

    public boolean isProfiloModIPA(String protocollo) {
        return this.core.isProfiloModIPA(protocollo);
    }

    public boolean forceHttpsProfiloModiPA() {
        return true;
    }

    public void readModIConfiguration(BooleanNullable forceHttpsClient, BooleanNullable forcePDND, BooleanNullable forceOAuth, IDAccordo idAccordoParteComune, String portType, List<String> azioneGruppo) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        AccordoServizioParteComune aspc = this.apcCore.getAccordoServizioFull(idAccordoParteComune, false);
        this.readForceHttpsClient(aspc, forceHttpsClient);
        String propertyNameSicurezzaRidefinita = "modipaSecurityMessageProfileActionMode";
        BooleanNullable forcePDNDApi = null;
        BooleanNullable forceOAuthApi = null;
        if (azioneGruppo == null || azioneGruppo.isEmpty()) {
            this.readForceTokenPolicy(aspc.getProtocolPropertyList(), forcePDND, forceOAuth);
            if (forcePDND.getValue() != null && forceOAuth.getValue() != null) {
                return;
            }
        } else {
            forcePDNDApi = BooleanNullable.NULL();
            forceOAuthApi = BooleanNullable.NULL();
            this.readForceTokenPolicy(aspc.getProtocolPropertyList(), forcePDNDApi, forceOAuthApi);
        }
        if (ServiceBinding.SOAP.equals((Object)aspc.getServiceBinding())) {
            this.readForceTokenPolicySoap(forcePDND, forceOAuth, aspc, portType, azioneGruppo, propertyNameSicurezzaRidefinita, forcePDNDApi, forceOAuthApi);
        } else {
            this.readForceTokenPolicyRest(forcePDND, forceOAuth, aspc, azioneGruppo, propertyNameSicurezzaRidefinita, forcePDNDApi, forceOAuthApi);
        }
        if (forcePDND.getValue() == null) {
            forcePDND.setValue(Boolean.valueOf(false));
        }
        if (forceOAuth.getValue() == null) {
            forceOAuth.setValue(Boolean.valueOf(false));
        }
    }

    private void readForceHttpsClient(AccordoServizioParteComune aspc, BooleanNullable forceHttpsClient) {
        String propertyName = "modipaSecurityChannelProfile";
        for (ProtocolProperty pp : aspc.getProtocolPropertyList()) {
            if (!pp.getName().equals(propertyName)) continue;
            String value = pp.getValue();
            if (!"idac02".equals(value)) break;
            forceHttpsClient.setValue(Boolean.valueOf(true));
            return;
        }
        forceHttpsClient.setValue(Boolean.valueOf(false));
    }

    private void readForceTokenPolicySoap(BooleanNullable forcePDND, BooleanNullable forceOAuth, AccordoServizioParteComune aspc, String portType, List<String> azioneGruppo, String propertyNameSicurezzaRidefinita, BooleanNullable forcePDNDApi, BooleanNullable forceOAuthApi) {
        if (portType != null) {
            if (aspc.sizePortTypeList() > 0) {
                for (PortType pt : aspc.getPortTypeList()) {
                    if (!portType.equals(pt.getNome()) || pt.sizeAzioneList() <= 0) continue;
                    this.readForceTokenPolicySoapOperation(forcePDND, forceOAuth, pt, azioneGruppo, propertyNameSicurezzaRidefinita, forcePDNDApi, forceOAuthApi);
                }
            }
        } else {
            this.readForceTokenPolicySoapAzione(forcePDND, forceOAuth, aspc, azioneGruppo, propertyNameSicurezzaRidefinita, forcePDNDApi, forceOAuthApi);
        }
    }

    private void readForceTokenPolicySoapOperation(BooleanNullable forcePDND, BooleanNullable forceOAuth, PortType pt, List<String> azioneGruppo, String propertyNameSicurezzaRidefinita, BooleanNullable forcePDNDApi, BooleanNullable forceOAuthApi) {
        for (Operation op : pt.getAzioneList()) {
            if (azioneGruppo != null && !azioneGruppo.contains(op.getNome())) continue;
            this.readForceTokenPolicy(op.getProtocolPropertyList(), forcePDND, forceOAuth, propertyNameSicurezzaRidefinita, forcePDNDApi, forceOAuthApi);
            if (forcePDND.getValue() == null || forceOAuth.getValue() == null) continue;
            return;
        }
    }

    private void readForceTokenPolicySoapAzione(BooleanNullable forcePDND, BooleanNullable forceOAuth, AccordoServizioParteComune aspc, List<String> azioneGruppo, String propertyNameSicurezzaRidefinita, BooleanNullable forcePDNDApi, BooleanNullable forceOAuthApi) {
        if (aspc.sizeAzioneList() > 0) {
            for (Azione az : aspc.getAzioneList()) {
                if (azioneGruppo != null && !azioneGruppo.contains(az.getNome())) continue;
                this.readForceTokenPolicy(az.getProtocolPropertyList(), forcePDND, forceOAuth, propertyNameSicurezzaRidefinita, forcePDNDApi, forceOAuthApi);
                if (forcePDND.getValue() == null || forceOAuth.getValue() == null) continue;
                return;
            }
        }
    }

    private void readForceTokenPolicyRest(BooleanNullable forcePDND, BooleanNullable forceOAuth, AccordoServizioParteComune aspc, List<String> azioneGruppo, String propertyNameSicurezzaRidefinita, BooleanNullable forcePDNDApi, BooleanNullable forceOAuthApi) {
        if (aspc.sizeResourceList() > 0) {
            for (Resource res : aspc.getResource()) {
                if (azioneGruppo != null && !azioneGruppo.contains(res.getNome())) continue;
                this.readForceTokenPolicy(res.getProtocolPropertyList(), forcePDND, forceOAuth, propertyNameSicurezzaRidefinita, forcePDNDApi, forceOAuthApi);
                if (forcePDND.getValue() == null || forceOAuth.getValue() == null) continue;
                return;
            }
        }
    }

    private void readForceTokenPolicy(List<ProtocolProperty> list, BooleanNullable forcePDND, BooleanNullable forceOAuth, String propertyNameSicurezzaRidefinita, BooleanNullable forcePDNDApi, BooleanNullable forceOAuthApi) {
        if (list != null && !list.isEmpty()) {
            boolean leggiSorgente = true;
            if (propertyNameSicurezzaRidefinita != null) {
                leggiSorgente = false;
                for (ProtocolProperty pp : list) {
                    if (!pp.getName().equals(propertyNameSicurezzaRidefinita)) continue;
                    if ("ridefinisci".equals(pp.getValue())) {
                        leggiSorgente = true;
                        continue;
                    }
                    if (forcePDNDApi != null && forcePDNDApi.getValue() != null) {
                        forcePDND.setValue(forcePDNDApi.getValue());
                    }
                    if (forceOAuthApi == null || forceOAuthApi.getValue() == null) continue;
                    forceOAuth.setValue(forceOAuthApi.getValue());
                }
            }
            if (leggiSorgente) {
                this.readForceTokenPolicy(list, forcePDND, forceOAuth);
            }
        }
    }

    private void readForceTokenPolicy(List<ProtocolProperty> list, BooleanNullable forcePDND, BooleanNullable forceOAuth) {
        String propertyNameSorgenteToken = "modipaSecurityMessageSorgenteToken";
        for (ProtocolProperty pp : list) {
            if (!pp.getName().equals(propertyNameSorgenteToken)) continue;
            String value = pp.getValue();
            this.setForceTokenPolicy(forcePDND, forceOAuth, value);
            if (forcePDND.getValue() == null || forceOAuth.getValue() == null) continue;
            break;
        }
    }

    private void setForceTokenPolicy(BooleanNullable forcePDND, BooleanNullable forceOAuth, String value) {
        if ("pdnd".equals(value)) {
            forcePDND.setValue(Boolean.valueOf(true));
        } else if ("oauth".equals(value)) {
            forceOAuth.setValue(Boolean.valueOf(true));
        }
    }

    public List<DataElement> addProxyPassConfigurazioneRegola(TipoOperazione tipoOp, List<DataElement> dati, String idRegolaS, String nome, String descrizione, String stato, boolean regExpr, String regolaText, String contestoEsterno, String baseUrl, String protocollo, List<String> protocolli, String soggetto, List<IDSoggetto> soggetti, String ruolo, String serviceBinding, boolean multiTenant) throws DriverControlStationException {
        DataElement dataElement = new DataElement();
        dataElement.setLabel("Regola");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        DataElement de = new DataElement();
        de.setName("ppId");
        de.setType(DataElementType.HIDDEN);
        de.setValue(idRegolaS);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Nome");
        de.setValue(nome);
        de.setType(DataElementType.TEXT_EDIT);
        de.setRequired(true);
        de.setName("ppNome");
        de.setSize(this.getSize());
        dati.add(de);
        de = new DataElement();
        de.setLabel("Stato");
        String[] labelsStato = new String[]{StatoFunzionalita.ABILITATO.toString(), StatoFunzionalita.DISABILITATO.toString()};
        String[] valuesStato = new String[]{StatoFunzionalita.ABILITATO.toString(), StatoFunzionalita.DISABILITATO.toString()};
        de.setLabels(labelsStato);
        de.setValues(valuesStato);
        de.setType(DataElementType.SELECT);
        de.setName("ppStato");
        de.setSelected(stato);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Descrizione");
        de.setValue(descrizione);
        de.setType(DataElementType.TEXT_AREA);
        de.setName("ppDescr");
        de.setSize(this.getSize());
        dati.add(de);
        dataElement = new DataElement();
        dataElement.setLabel("Criteri di Applicabilit\u00e0");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        de = new DataElement();
        de.setLabel("Espressione Regolare");
        de.setName("ppRegExpr");
        de.setType(DataElementType.CHECKBOX);
        de.setSelected(regExpr);
        de.setValue("" + regExpr);
        de.setPostBack(true);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Regola");
        de.setValue(regolaText);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("ppRegText");
        de.setSize(this.getSize());
        de.setRequired(true);
        DataElementInfo deInfo = new DataElementInfo("Regola");
        if (regExpr) {
            deInfo.setHeaderBody("Espressione Regolare utilizzata per individuare l'applicabilit\u00e0 della regola.<BR/>L'espressione viene verificata sull contesto dell'API (url di invocazione senza la Base URL)");
        } else {
            deInfo.setHeaderBody("Stringa utilizzata per individuare l'applicabilit\u00e0 della regola.<BR/>Si ha un'applicabilit\u00e0 se il contesto dell'API (url di invocazione senza la Base URL) inizia con la stringa fornita");
        }
        de.setInfo(deInfo);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Profilo");
        String[] labelsProfili = new String[protocolli.size() + 1];
        String[] valuesProfili = new String[protocolli.size() + 1];
        labelsProfili[0] = "Qualsiasi";
        valuesProfili[0] = "";
        int i = 1;
        for (String protocolloS : protocolli) {
            labelsProfili[i] = ConsoleHelper._getLabelProtocollo(protocolloS);
            valuesProfili[i] = protocolloS;
            ++i;
        }
        de.setLabels(labelsProfili);
        de.setValues(valuesProfili);
        de.setType(DataElementType.SELECT);
        de.setName("ppProfilo");
        de.setPostBack(true);
        de.setSelected(protocollo);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Soggetto");
        de.setName("ppSogg");
        if (!"".equals(protocollo) && multiTenant) {
            String[] labelsSoggetti = new String[soggetti.size() + 1];
            String[] valuesSoggetti = new String[soggetti.size() + 1];
            labelsSoggetti[0] = "Qualsiasi";
            valuesSoggetti[0] = "";
            i = 1;
            for (IDSoggetto idSoggetto : soggetti) {
                labelsSoggetti[i] = ConsoleHelper._getLabelNomeSoggetto(idSoggetto);
                valuesSoggetti[i] = idSoggetto.toString();
                ++i;
            }
            de.setLabels(labelsSoggetti);
            de.setValues(valuesSoggetti);
            de.setType(DataElementType.SELECT);
            de.setSelected(soggetto);
        } else {
            de.setType(DataElementType.HIDDEN);
            de.setValue(soggetto);
        }
        dati.add(de);
        de = new DataElement();
        de.setLabel("Ruolo");
        de.setLabels(CostantiControlStation.SELECT_LABELS_PARAMETRO_PROXY_PASS_REGOLA_RUOLO);
        de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_PROXY_PASS_REGOLA_RUOLO);
        de.setType(DataElementType.SELECT);
        de.setName("ppRuolo");
        de.setSelected(ruolo);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Tipo API");
        de.setLabels(CostantiControlStation.SELECT_LABELS_PARAMETRO_PROXY_PASS_REGOLA_SERVICE_BINDING);
        de.setValues(CostantiControlStation.SELECT_VALUES_PARAMETRO_PROXY_PASS_REGOLA_SERVICE_BINDING);
        de.setType(DataElementType.SELECT);
        de.setName("ppServB");
        de.setSelected(serviceBinding);
        dati.add(de);
        dataElement = new DataElement();
        dataElement.setLabel("Nuova URL di Invocazione");
        dataElement.setType(DataElementType.TITLE);
        dati.add(dataElement);
        StringBuilder sb = new StringBuilder();
        if (regExpr) {
            sb.append("<BR/><BR/>\u00c8 possibile utilizzare la keyword '${posizione}' per impostare un valore dinamico individuato tramite l'espressione regolare fornita.<BR/>Il primo match, all'interno dell'espressione regolare, \u00e8 rappresentata da '${0}'.<BR/>Ad esempio: http://server:8080/${0}/altro/${1}/");
        }
        CanaliConfigurazione canali = null;
        try {
            canali = this.confCore.getCanaliConfigurazione(false);
        }
        catch (Exception e) {
            throw new DriverControlStationException(e.getMessage(), e);
        }
        if (canali != null && StatoFunzionalita.ABILITATO.equals((Object)canali.getStato())) {
            sb.append("<BR/><BR/>\u00c8 possibile utilizzare la keyword '${canale}' per utilizzare l'identificativo del canale associato all'API.<BR/>Ad esempio: http://server:8080/${canale}/");
        }
        sb.append("<BR/><BR/>\u00c8 possibile utilizzare la keyword '${tag}' per utilizzare l'identificativo del tag associato all'API. Poich\u00e8 ad un'API \u00e8 possibile associare pi\u00f9 tag, nel caso precedente verr\u00e0 utilizzato quello alla prima posizione, altrimenti \u00e8 selezionabile il tag desiderato tramite l'espressione ${tag[posizione]}.<BR/>Il primo tag, all'interno della lista, \u00e8 rappresentata da '${tag[0]}'.<BR/>Ad esempio: http://server:8080/${tag[0]}/");
        de = new DataElement();
        de.setLabel("Base URL");
        de.setValue(baseUrl);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("ppBaseUrl");
        de.setSize(this.getSize());
        deInfo = new DataElementInfo("Base URL");
        deInfo.setHeaderBody("Permette di ridefinire la Base URL utilizzata rispetto a quanto definito nella configurazione generale");
        deInfo.setHeaderBody(deInfo.getHeaderBody() + sb.toString());
        de.setInfo(deInfo);
        dati.add(de);
        de = new DataElement();
        de.setLabel("Contesto");
        de.setValue(contestoEsterno);
        de.setType(DataElementType.TEXT_EDIT);
        de.setName("ppCE");
        de.setSize(this.getSize());
        de.setRequired(false);
        deInfo = new DataElementInfo("Contesto");
        deInfo.setHeaderBody("Indica il contesto da utilizzare dopo la Base URL");
        deInfo.setHeaderBody(deInfo.getHeaderBody() + sb.toString());
        de.setInfo(deInfo);
        dati.add(de);
        return dati;
    }

    public String getStatoConnettoriMultipliPortaApplicativa(PortaApplicativa paAssociata) throws DriverControlStationException, DriverControlStationNotFound {
        if (paAssociata == null) {
            throw new DriverControlStationException("Param paAssociata is null");
        }
        boolean connettoreMultiploEnabled = paAssociata.getBehaviour() != null;
        return connettoreMultiploEnabled ? CostantiConfigurazione.ABILITATO.toString() : CostantiConfigurazione.DISABILITATO.toString();
    }

    public String getNomiConnettoriMultipliPortaApplicativa(PortaApplicativa paAssociata) throws DriverControlStationException, DriverControlStationNotFound, NotFoundException {
        StringBuilder sbConnettoriMultipli = new StringBuilder();
        TipoBehaviour behaviourType = TipoBehaviour.toEnumConstant((String)paAssociata.getBehaviour().getNome());
        switch (behaviourType) {
            case CONSEGNA_LOAD_BALANCE: {
                String loadBalanceStrategia = ConfigurazioneLoadBalancer.readLoadBalancerType((PortaApplicativaBehaviour)paAssociata.getBehaviour());
                LoadBalancerType type = LoadBalancerType.toEnumConstant((String)loadBalanceStrategia, (boolean)true);
                sbConnettoriMultipli.append(behaviourType.getLabel()).append(" '");
                if (StickyUtils.isConfigurazioneSticky((PortaApplicativa)paAssociata, (Logger)ControlStationLogger.getPddConsoleCoreLogger())) {
                    sbConnettoriMultipli.append("Sticky").append(" ");
                }
                sbConnettoriMultipli.append(type.getLabel()).append("'");
                boolean condizionale = ConditionalUtils.isConfigurazioneCondizionale((PortaApplicativa)paAssociata, (Logger)ControlStationLogger.getPddConsoleCoreLogger());
                if (!condizionale) break;
                sbConnettoriMultipli.append(" ").append(" (consegna condizionale)");
                break;
            }
            case CONSEGNA_MULTIPLA: {
                sbConnettoriMultipli.append(behaviourType.getLabel());
                boolean condizionale = ConditionalUtils.isConfigurazioneCondizionale((PortaApplicativa)paAssociata, (Logger)ControlStationLogger.getPddConsoleCoreLogger());
                if (!condizionale) break;
                sbConnettoriMultipli.append(" ").append(" (consegna condizionale)");
                break;
            }
            case CONSEGNA_CON_NOTIFICHE: {
                sbConnettoriMultipli.append(behaviourType.getLabel());
                boolean condizionale = ConditionalUtils.isConfigurazioneCondizionale((PortaApplicativa)paAssociata, (Logger)ControlStationLogger.getPddConsoleCoreLogger());
                if (!condizionale) break;
                sbConnettoriMultipli.append(" ").append(" (notifiche condizionali)");
                break;
            }
            case CONSEGNA_CONDIZIONALE: {
                sbConnettoriMultipli.append(behaviourType.getLabel());
                break;
            }
            case CUSTOM: {
                String customLabel = paAssociata.getBehaviour().getNome();
                Plugin plugin = null;
                try {
                    plugin = this.confCore.getPlugin(TipoPlugin.BEHAVIOUR, customLabel, false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (plugin != null) {
                    customLabel = plugin.getLabel();
                }
                sbConnettoriMultipli.append("Consegna Personalizzata '" + customLabel + "'");
            }
        }
        return sbConnettoriMultipli.toString();
    }

    public String getToolTipConnettoriMultipliPortaApplicativa(PortaApplicativa paAssociata) throws DriverControlStationException, DriverControlStationNotFound {
        StringBuilder sbConnettoriMultipli = new StringBuilder();
        for (PortaApplicativaServizioApplicativo paSA : paAssociata.getServizioApplicativoList()) {
            if (sbConnettoriMultipli.length() > 0) {
                sbConnettoriMultipli.append(", ");
            }
            if (paSA.getDatiConnettore() == null) {
                sbConnettoriMultipli.append("Default");
                continue;
            }
            sbConnettoriMultipli.append(paSA.getDatiConnettore().getNome());
        }
        return sbConnettoriMultipli.toString();
    }

    public List<DataElement> addInformazioniGruppiAsHiddenToDati(TipoOperazione tipoOp, List<DataElement> dati, String idTabGruppo, String idTabConnettoriMultipli, String accessoDaAPS, String connettoreAccessoDaGruppi, String connettoreRegistro, String connettoreAccessoDaListaConnettoriMultipli) {
        DataElement de;
        if (idTabGruppo != null) {
            de = new DataElement();
            de.setName("idTab");
            de.setType(DataElementType.HIDDEN);
            de.setValue(idTabGruppo);
            dati.add(de);
        }
        if (idTabConnettoriMultipli != null) {
            de = new DataElement();
            de.setName("idConnTab");
            de.setType(DataElementType.HIDDEN);
            de.setValue(idTabConnettoriMultipli);
            dati.add(de);
        }
        if (accessoDaAPS != null) {
            de = new DataElement();
            de.setName("connettoreDaListaAps");
            de.setType(DataElementType.HIDDEN);
            de.setValue(accessoDaAPS);
            dati.add(de);
        }
        if (connettoreAccessoDaGruppi != null) {
            de = new DataElement();
            de.setName("connettoreAccessoDaGruppi");
            de.setType(DataElementType.HIDDEN);
            de.setValue(connettoreAccessoDaGruppi);
            dati.add(de);
        }
        if (connettoreRegistro != null) {
            de = new DataElement();
            de.setName("connettoreRegistro");
            de.setType(DataElementType.HIDDEN);
            de.setValue(connettoreRegistro);
            dati.add(de);
        }
        if (connettoreAccessoDaListaConnettoriMultipli != null) {
            de = new DataElement();
            de.setName("connettoreAccessoDaCM");
            de.setType(DataElementType.HIDDEN);
            de.setValue(connettoreAccessoDaListaConnettoriMultipli);
            dati.add(de);
        }
        return dati;
    }

    public boolean isConnettoreDefault(PortaApplicativaServizioApplicativo paSA) {
        return paSA.getDatiConnettore() != null ? !paSA.getDatiConnettore().isNotifica() : true;
    }

    public String getLabelNomePortaApplicativaServizioApplicativo(PortaApplicativaServizioApplicativo paSA) {
        String nomePaSA = paSA != null && paSA.getDatiConnettore() != null ? paSA.getDatiConnettore().getNome() : "Default";
        return nomePaSA;
    }

    public int getIdxNuovoConnettoreMultiplo(PortaApplicativa pa) {
        int idxConfigurazione = 0;
        int listaMappingErogazioneSize = pa.sizeServizioApplicativoList();
        for (int i = 0; i < listaMappingErogazioneSize; ++i) {
            PortaApplicativaServizioApplicativo paSA = pa.getServizioApplicativo(i);
            int idx = paSA.getNome().indexOf("__SA");
            if (idx <= -1) continue;
            String idxTmp = paSA.getNome().substring(idx + "__SA".length());
            int idxMax = -1;
            try {
                idxMax = Integer.parseInt(idxTmp);
            }
            catch (Exception e) {
                idxMax = 0;
            }
            idxConfigurazione = Math.max(idxConfigurazione, idxMax);
        }
        return ++idxConfigurazione;
    }

    public boolean allActionsRedefinedMappingErogazione(List<String> azioni, List<MappingErogazionePortaApplicativa> lista) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        boolean all = true;
        if (azioni != null && azioni.size() > 0) {
            for (String azione : azioni) {
                if (lista == null || lista.size() <= 0) {
                    all = false;
                    break;
                }
                boolean found = false;
                for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : lista) {
                    PortaApplicativa paAssociata = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
                    if (paAssociata.getAzione() == null || !paAssociata.getAzione().getAzioneDelegataList().contains(azione)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                all = false;
                break;
            }
        }
        return all;
    }

    public List<String> getAllActionsNotRedefinedMappingErogazione(List<String> azioni, List<MappingErogazionePortaApplicativa> lista) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ArrayList<String> l = new ArrayList<String>();
        if (lista == null || lista.size() <= 0) {
            return azioni;
        }
        l.addAll(azioni);
        for (MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa : lista) {
            PortaApplicativa paAssociata = this.porteApplicativeCore.getPortaApplicativa(mappingErogazionePortaApplicativa.getIdPortaApplicativa());
            if (paAssociata.getAzione() == null || paAssociata.getAzione().getAzioneDelegataList().isEmpty()) continue;
            for (String azPA : paAssociata.getAzione().getAzioneDelegataList()) {
                l.remove(azPA);
            }
        }
        return l;
    }

    public boolean isSoapOneWay(PortaApplicativa portaApplicativa, MappingErogazionePortaApplicativa mappingErogazionePortaApplicativa, AccordoServizioParteSpecifica asps, AccordoServizioParteComuneSintetico as, org.openspcoop2.message.constants.ServiceBinding serviceBinding) throws DriverControlStationException, DriverRegistroServiziException, DriverConfigurazioneException, DriverConfigurazioneNotFound {
        boolean isSoapOneWay = false;
        if (serviceBinding.equals((Object)org.openspcoop2.message.constants.ServiceBinding.SOAP)) {
            if (mappingErogazionePortaApplicativa.isDefault()) {
                Map<String, String> azioni = null;
                try {
                    azioni = this.porteApplicativeCore.getAzioniConLabel(asps, as, false, true, new ArrayList<String>());
                }
                catch (Exception e) {
                    throw new DriverControlStationException(e.getMessage(), e);
                }
                IDServizio idServizio2 = IDServizioFactory.getInstance().getIDServizioFromAccordo(asps);
                List<MappingErogazionePortaApplicativa> lista = this.apsCore.mappingServiziPorteAppList(idServizio2, asps.getId(), null);
                boolean allActionRedefined = false;
                List<String> actionNonRidefinite = null;
                ArrayList<String> azioniL = new ArrayList<String>();
                if (azioni != null && azioni.size() > 0) {
                    azioniL.addAll(azioni.keySet());
                }
                if (!(allActionRedefined = this.allActionsRedefinedMappingErogazione(azioniL, lista))) {
                    actionNonRidefinite = this.getAllActionsNotRedefinedMappingErogazione(azioniL, lista);
                    isSoapOneWay = this.porteApplicativeCore.azioniTutteOneway(asps, as, actionNonRidefinite);
                } else {
                    isSoapOneWay = false;
                }
            } else {
                ArrayList<String> listaAzioni = portaApplicativa.getAzione() != null ? portaApplicativa.getAzione().getAzioneDelegataList() : new ArrayList();
                isSoapOneWay = this.porteApplicativeCore.azioniTutteOneway(asps, as, listaAzioni);
            }
        } else {
            isSoapOneWay = false;
        }
        return isSoapOneWay;
    }

    public DataElement newDataElementVisualizzaInNuovoTab(DataElement deParam, String url, String tooltip) {
        DataElement de = deParam;
        if (de == null) {
            de = new DataElement();
        }
        de.setUrl(url);
        de.setTarget(TargetType.BLANK);
        if (tooltip != null) {
            de.setToolTip(MessageFormat.format("Visualizza {0}", tooltip));
        } else {
            de.setToolTip("Visualizza");
        }
        de.setIcon("&#xE89E;");
        de.setDisabilitaAjaxStatus();
        de.setVisualizzaLinkApriNuovaFinestra(true);
        return de;
    }

    public void setSecretPleaseCopy(String secret_password, String secret_user, boolean appId, String tipoAuth, OggettoDialogEnum oggettoDialog, String nome) {
        Dialog.BodyElement password;
        Object nomeP = nome != null ? " " + nome : "";
        Object tipoOggetto = null;
        switch (oggettoDialog) {
            case UTENTE: {
                tipoOggetto = "all'utente" + (String)nomeP;
                break;
            }
            case SOGGETTO: {
                tipoOggetto = "al soggetto" + (String)nomeP;
                break;
            }
            case APPLICATIVO: {
                tipoOggetto = "all'applicativo" + (String)nomeP;
                break;
            }
            case EROGAZIONE: {
                tipoOggetto = "all'erogazione";
                break;
            }
            case CONNETTORE_MULTIPLO: {
                tipoOggetto = "al connettore" + (String)nomeP + " dell'erogazione";
            }
        }
        Object header1 = "";
        Dialog.BodyElement utente = Dialog.newBodyElement();
        if (utente != null) {
            utente.setVisualizzaCopyAction(true);
        }
        if ((password = Dialog.newBodyElement()) != null) {
            password.setVisualizzaCopyAction(true);
        }
        if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_BASIC.equals(tipoAuth)) {
            if (utente != null) {
                utente.setLabel("Utente");
                utente.setType(DataElementType.TEXT_EDIT);
                utente.setValue(StringEscapeUtils.escapeHtml4((String)secret_user));
                utente.setTooltipCopyAction(MessageFormat.format("Copia {0}", "Utente"));
            }
            if (password != null) {
                password.setLabel("Password");
                password.setType(DataElementType.TEXT_EDIT);
                password.setValue(StringEscapeUtils.escapeHtml4((String)secret_password));
                password.setTooltipCopyAction(MessageFormat.format("Copia {0}", "Password"));
            }
            header1 = "Utente e Password generata";
        } else if (ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(tipoAuth)) {
            if (appId) {
                if (utente != null) {
                    utente.setLabel("App ID");
                    utente.setType(DataElementType.TEXT_EDIT);
                    utente.setValue(StringEscapeUtils.escapeHtml4((String)secret_user));
                    utente.setTooltipCopyAction(MessageFormat.format("Copia {0}", "App ID"));
                }
            } else {
                utente = null;
            }
            if (password != null) {
                password.setLabel("Api Key");
                password.setType(DataElementType.TEXT_AREA);
                password.setValue(StringEscapeUtils.escapeHtml4((String)secret_password));
                password.setTooltipCopyAction(MessageFormat.format("Copia {0}", "Api Key"));
                password.setCols(44);
            }
            header1 = "Api Key generata";
            if (appId) {
                header1 = "App ID e " + (String)header1;
            }
        }
        boolean unaCredenziale = ConnettoriCostanti.AUTENTICAZIONE_TIPO_APIKEY.equals(tipoAuth) && !appId;
        String singolare = unaCredenziale ? "a" : "e";
        String verbo = unaCredenziale ? "viene" : "vengono";
        String oggetto = unaCredenziale ? "la chiave" : "le credenziali";
        String intestazione = StringEscapeUtils.escapeHtml4((String)("Di seguito " + verbo + " riportat" + singolare + " " + oggetto + " associat" + singolare + " " + (String)tipoOggetto + ".")) + "<br/>" + StringEscapeUtils.escapeHtml4((String)"L'informazione viene visualizzata in questo avviso e successivamente non sar\u00e0 pi\u00f9 consultabile.");
        String attenzione = StringEscapeUtils.escapeHtml4((String)("Si prega di copiarl" + singolare + " e custodirl" + singolare + " attentamente."));
        Dialog dialog = new Dialog();
        dialog.setTitolo("Attenzione");
        dialog.setHeaderRiga1((String)header1);
        dialog.setHeaderRiga2(intestazione);
        if (utente != null) {
            dialog.addBodyElement(utente);
        }
        if (password != null) {
            dialog.addBodyElement(password);
        }
        dialog.setNotaFinale(attenzione);
        String[][] bottoni = new String[][]{{"Chiudi", ""}};
        this.pd.setBottoni(bottoni);
        this.pd.setDialog(dialog);
    }

    public void addInUsoButtonVisualizzazioneClassica(List<DataElement> e, String titolo, String id, InUsoType inUsoType) {
        this.addInUsoButton(e, DataElementType.BUTTON, titolo, id, inUsoType, "Visualizza riferimenti", "&#xE880;", "Risultati della ricerca", true, true);
    }

    public void addInUsoButton(List<DataElement> e, String titolo, String id, InUsoType inUsoType) {
        this.addInUsoButton(e, DataElementType.IMAGE, titolo, id, inUsoType, "Visualizza riferimenti", "&#xE880;", "Risultati della ricerca", true, true);
    }

    public void addInUsoInfoButton(List<DataElement> e, String titolo, String id, InUsoType inUsoType) {
        this.addInUsoButton(e, DataElementType.IMAGE, titolo, id, inUsoType, "Visualizza dettagli della configurazione", "&#xE88E;", "Dettagli della configurazione", true, true);
    }

    private void addInUsoButton(List<DataElement> e, DataElementType deType, String titolo, String id, InUsoType inUsoType, String tooltip, String icon, String headerRiga1, Boolean resizable, Boolean draggable) {
        ServletUtils.addInUsoButton((String)"informazioniUtilizzoOggettoRegistro", e, (DataElementType)deType, (String)titolo, (String)id, (String)inUsoType.toString(), (String)tooltip, (String)icon, (String)headerRiga1, (Boolean)resizable, (Boolean)draggable, (boolean)true);
    }

    public void addComandoInUsoButton(String titolo, String id, InUsoType inUsoType) {
        this.addComandoInUsoElementoButton(titolo, id, inUsoType, "Visualizza riferimenti", "&#xE880;", "Risultati della ricerca", true, true);
    }

    public void addComandoInUsoInfoButton(String titolo, String id, InUsoType inUsoType) {
        this.addComandoInUsoElementoButton(titolo, id, inUsoType, "Visualizza dettagli della configurazione", "&#xE88E;", "Dettagli della configurazione", true, true);
    }

    private void addComandoInUsoElementoButton(String titolo, String id, InUsoType inUsoType, String tooltip, String icon, String headerRiga1, Boolean resizable, Boolean draggable) {
        this.pd.addComandoInUsoElementoButton("informazioniUtilizzoOggettoRegistro", titolo, id, inUsoType.toString(), tooltip, icon, headerRiga1, resizable, draggable);
    }

    public void addProprietaOggettoButtonVisualizzazioneClassica(List<DataElement> e, String titolo, String id, InUsoType inUsoType) {
        this.addProprietaOggettoButton(e, DataElementType.BUTTON, titolo, id, inUsoType, "Propriet\u00e0", "&#xE880;", "Propriet\u00e0", true, true);
    }

    public void addProprietaOggettoButton(List<DataElement> e, String titolo, String id, InUsoType inUsoType) {
        this.addProprietaOggettoButton(e, DataElementType.IMAGE, titolo, id, inUsoType, "Propriet\u00e0", "&#xE880;", "Propriet\u00e0", true, true);
    }

    public void addProprietaOggettoInfoButton(List<DataElement> e, String titolo, String id, InUsoType inUsoType) {
        this.addProprietaOggettoButton(e, DataElementType.IMAGE, titolo, id, inUsoType, "Visualizza propriet\u00e0 della configurazione", "&#xE88E;", "Propriet\u00e0 della configurazione", true, true);
    }

    private void addProprietaOggettoButton(List<DataElement> e, DataElementType deType, String titolo, String id, InUsoType inUsoType, String tooltip, String icon, String headerRiga1, Boolean resizable, Boolean draggable) {
        ServletUtils.addInUsoButton((String)"proprietaOggettoRegistro", e, (DataElementType)deType, (String)titolo, (String)id, (String)inUsoType.toString(), (String)tooltip, (String)icon, (String)headerRiga1, (Boolean)resizable, (Boolean)draggable, (boolean)true);
    }

    public void addComandoProprietaOggettoButton(String titolo, String id, InUsoType inUsoType) {
        this.addComandoProprietaOggettoElementoButton(titolo, id, inUsoType, "Propriet\u00e0", "&#xE880;", "Propriet\u00e0", true, true);
    }

    public void addComandoProprietaOggettoInfoButton(String titolo, String id, InUsoType inUsoType) {
        this.addComandoProprietaOggettoElementoButton(titolo, id, inUsoType, "Visualizza propriet\u00e0 della configurazione", "&#xE88E;", "Propriet\u00e0 della configurazione", true, true);
    }

    private void addComandoProprietaOggettoElementoButton(String titolo, String id, InUsoType inUsoType, String tooltip, String icon, String headerRiga1, Boolean resizable, Boolean draggable) {
        this.pd.addComandoInUsoElementoButton("proprietaOggettoRegistro", titolo, id, inUsoType.toString(), tooltip, icon, headerRiga1, resizable, draggable);
    }

    public void addComandoResetCacheElementoButton(boolean utilizzaServizioCondiviso, String servletName, List<Parameter> parameters, InUsoType inUsoType) {
        if (utilizzaServizioCondiviso) {
            String titoloModale = "";
            String bodyModale = "";
            this.addComandoResetCacheCheUtilizzaServizioCondivisoButton(titoloModale, bodyModale, "cacheManager", parameters, inUsoType);
        } else {
            this.pd.addComandoResetCacheElementoButton(servletName, parameters);
        }
    }

    public void addComandoResetCacheCheUtilizzaServizioCondivisoButton(String titoloModale, String bodyModale, String servletName, List<Parameter> parameters, InUsoType inUsoType) {
        this.pd.addComandoElementoCheUtilizzaServizioCondivisoButton("&#xE863;", "Rimuovi dalla cache", titoloModale, bodyModale, servletName, parameters, inUsoType.toString());
    }

    public void addComandoVerificaCertificatiElementoButton(boolean utilizzaServizioCondiviso, String servletName, List<Parameter> parameters, InUsoType inUsoType) {
        if (utilizzaServizioCondiviso) {
            String titoloModale = "";
            String bodyModale = "";
            this.addComandoVerificaCertificatiCheUtilizzaServizioCondivisoButton(titoloModale, bodyModale, "verificaCertificati", parameters, inUsoType);
        } else {
            this.pd.addComandoVerificaCertificatiElementoButton(servletName, parameters);
        }
    }

    public void addComandoVerificaCertificatiCheUtilizzaServizioCondivisoButton(String titoloModale, String bodyModale, String servletName, List<Parameter> parameters, InUsoType inUsoType) {
        this.pd.addComandoElementoCheUtilizzaServizioCondivisoButton("&#xEA17;", "Verifica certificati", titoloModale, bodyModale, servletName, parameters, inUsoType.toString());
    }

    protected boolean existsProprietaOggetto(ProprietaOggettoSintetico p, String descrizione) {
        return p != null && (p.getUtenteRichiedente() != null && StringUtils.isNotEmpty((CharSequence)p.getUtenteRichiedente()) || p.getDataCreazione() != null || p.getUtenteUltimaModifica() != null && StringUtils.isNotEmpty((CharSequence)p.getUtenteUltimaModifica()) || p.getDataUltimaModifica() != null) || descrizione != null && StringUtils.isNotEmpty((CharSequence)descrizione);
    }

    protected boolean existsProprietaOggetto(org.openspcoop2.core.registry.ProprietaOggetto p, String descrizione) {
        return p != null && (p.getUtenteRichiedente() != null && StringUtils.isNotEmpty((CharSequence)p.getUtenteRichiedente()) || p.getDataCreazione() != null || p.getUtenteUltimaModifica() != null && StringUtils.isNotEmpty((CharSequence)p.getUtenteUltimaModifica()) || p.getDataUltimaModifica() != null) || descrizione != null && StringUtils.isNotEmpty((CharSequence)descrizione);
    }

    protected boolean existsProprietaOggetto(ProprietaOggetto p, String descrizione) {
        return p != null && (p.getUtenteRichiedente() != null && StringUtils.isNotEmpty((CharSequence)p.getUtenteRichiedente()) || p.getDataCreazione() != null || p.getUtenteUltimaModifica() != null && StringUtils.isNotEmpty((CharSequence)p.getUtenteUltimaModifica()) || p.getDataUltimaModifica() != null) || descrizione != null && StringUtils.isNotEmpty((CharSequence)descrizione);
    }

    public void addComandoVerificaCertificatiButton(List<DataElement> e, String nomeElementoSuCuiEffettuareLaVerifica, String servletName, List<Parameter> parameters) {
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        if (nomeElementoSuCuiEffettuareLaVerifica != null) {
            // empty if block
        }
        this.addAzioneButton(e, DataElementType.IMAGE, "Verifica certificati", "&#xEA17;", servletName, parameters);
    }

    public void addComandoResetCacheButton(List<DataElement> e, String nomeElementoSuCuiEffettuareIlReset, String servletName, List<Parameter> parameters) {
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
        }
        parameters.add(new Parameter("rmElFromCache", "true"));
        if (nomeElementoSuCuiEffettuareIlReset != null) {
            // empty if block
        }
        this.addAzioneButton(e, DataElementType.IMAGE, "Rimuovi dalla cache", "&#xE863;", servletName, parameters);
    }

    public void addVerificaCertificatiButton(List<DataElement> e, String servletName, List<Parameter> parameters) {
        this.addAzioneButton(e, DataElementType.IMAGE, MessageFormat.format("Verifica {0}", "Certificati".toLowerCase()), "&#xEA17;", servletName, parameters);
    }

    public void addVerificaConnettivitaButton(List<DataElement> e, String servletName, List<Parameter> parameters) {
        this.addAzioneButton(e, DataElementType.IMAGE, MessageFormat.format("Verifica {0}", "Connettivit\u00e0".toLowerCase()), "&#xE8BE;", servletName, parameters);
    }

    protected void addAzioneButton(List<DataElement> e, DataElementType deType, String tooltip, String icon, String servletName, List<Parameter> parameters) {
        DataElement de = new DataElement();
        de.setType(deType);
        de.setToolTip(tooltip);
        if (parameters != null && !parameters.isEmpty()) {
            de.setUrl(servletName, parameters.toArray(new Parameter[parameters.size()]));
        } else {
            de.setUrl(servletName);
        }
        de.setIcon(icon);
        e.add(de);
    }

    public void addCanaleToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String canaleStato, String canale, String canaleAPI, List<CanaleConfigurazione> canaleList, boolean gestioneCanaliEnabled) throws DriverConfigurazioneNotFound {
        this.addCanaleToDati(dati, tipoOperazione, canaleStato, canale, canaleAPI, canaleList, gestioneCanaliEnabled, true);
    }

    public void addCanaleToDati(List<DataElement> dati, TipoOperazione tipoOperazione, String canaleStato, String canale, String canaleAPI, List<CanaleConfigurazione> canaleList, boolean gestioneCanaliEnabled, boolean addTitle) throws DriverConfigurazioneNotFound {
        if (gestioneCanaliEnabled) {
            if (addTitle) {
                DataElement dataElement = new DataElement();
                dataElement.setLabel("Canale");
                dataElement.setType(DataElementType.TITLE);
                dati.add(dataElement);
            }
            DataElement de = new DataElement();
            de.setLabel("Canale");
            de.setValues(CostantiControlStation.VALUES_PARAMETRO_CONFIGURAZIONE_CANALI_CANALE_STATO);
            ArrayList<String> labelsCanaleStato = new ArrayList<String>();
            CanaleConfigurazione canaleConfigurazioneDefault = this.getCanaleDefault(canaleList);
            String nomeCanaleDefault = MessageFormat.format("default ({0})", canaleConfigurazioneDefault.getNome());
            if (canaleAPI != null) {
                nomeCanaleDefault = MessageFormat.format("default API ({0})", canaleAPI);
            }
            labelsCanaleStato.add(nomeCanaleDefault);
            labelsCanaleStato.add("ridefinito");
            de.setLabels(labelsCanaleStato);
            de.setType(DataElementType.SELECT);
            de.setSelected(canaleStato);
            de.setName("canaleStato");
            de.setSize(this.getSize());
            de.setPostBack(true);
            dati.add(de);
            if ("ridefinito".equals(canaleStato)) {
                de = new DataElement();
                de.setLabel("");
                List canaliListValues = canaleList.stream().map(CanaleConfigurazione::getNome).collect(Collectors.toList());
                de.setValues(canaliListValues);
                de.setLabels(canaliListValues);
                de.setType(DataElementType.SELECT);
                de.setSelected(canale);
                de.setName("canale");
                de.setSize(this.getSize());
                dati.add(de);
            }
        }
    }

    public void addCanaleToDatiAsHidden(List<DataElement> dati, TipoOperazione tipoOperazione, String canaleStato, String canale, boolean gestioneCanaliEnabled) {
        if (gestioneCanaliEnabled) {
            DataElement de = new DataElement();
            de.setLabel("Canale");
            de.setType(DataElementType.HIDDEN);
            de.setValue(canaleStato);
            de.setName("canaleStato");
            de.setSize(this.getSize());
            dati.add(de);
            if ("ridefinito".equals(canaleStato)) {
                de = new DataElement();
                de.setLabel("");
                de.setType(DataElementType.HIDDEN);
                de.setValue(canale);
                de.setName("canale");
                de.setSize(this.getSize());
                dati.add(de);
            }
        }
    }

    public boolean canaleCheckData(String canaleStato, String canale, boolean gestioneCanaliEnabled) throws DriverControlStationException {
        return !gestioneCanaliEnabled || !"ridefinito".equals(canaleStato) || this.checkNCName(canale, "Canale");
    }

    public void addCustomFieldSearchForm(TipoPlugin tipoPlugin, String ruolo, String fase, String nomeParametroSelezioneTipo, String nomeParametro, String label, String value, boolean hidden, List<DataElement> dati, boolean postBack_viaPOST) throws DriverControlStationException {
        this.addCustomField(tipoPlugin, ruolo, fase, nomeParametroSelezioneTipo, nomeParametro, label, value, null, false, hidden, dati, postBack_viaPOST, false, null, null, true, null, null);
    }

    public void addCustomField(TipoPlugin tipoPlugin, String ruolo, String fase, String nomeParametroSelezioneTipo, String nomeParametro, String label, String value, boolean hidden, List<DataElement> dati, boolean postBack_viaPOST) throws DriverControlStationException {
        this.addCustomFieldConValoreDefault(tipoPlugin, ruolo, fase, nomeParametroSelezioneTipo, nomeParametro, label, value, hidden, dati, postBack_viaPOST, null);
    }

    public void addCustom