/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.web.ctrlstat.core;

import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipoAutorizzazione;
import org.openspcoop2.core.registry.constants.RuoloTipologia;

public class AutorizzazioneUtilities {
    public static final String STATO_ABILITATO = StatoFunzionalita.ABILITATO.getValue();
    public static final String STATO_DISABILITATO = StatoFunzionalita.DISABILITATO.getValue();
    public static final String STATO_XACML_POLICY = "xacml-Policy";
    public static final String STATO_SIGNAL_HUB_PUSH_SIGNALS = "signal-Hub";

    private AutorizzazioneUtilities() {
    }

    public static List<String> getStati(boolean signalHub) {
        ArrayList<String> l = new ArrayList<String>();
        l.add(STATO_DISABILITATO);
        l.add(STATO_ABILITATO);
        l.add(STATO_XACML_POLICY);
        if (signalHub) {
            l.add(STATO_SIGNAL_HUB_PUSH_SIGNALS);
        }
        return l;
    }

    public static String convertToStato(String autorizzazione) {
        return AutorizzazioneUtilities.convertToStato(TipoAutorizzazione.toEnumConstant((String)autorizzazione));
    }

    public static String convertToStato(TipoAutorizzazione autorizzazione) {
        if (TipoAutorizzazione.isXacmlPolicyRequired((TipoAutorizzazione)autorizzazione)) {
            return STATO_XACML_POLICY;
        }
        if (TipoAutorizzazione.DISABILITATO.equals((Object)autorizzazione)) {
            return STATO_DISABILITATO;
        }
        if (TipoAutorizzazione.TOKEN.equals((Object)autorizzazione)) {
            return STATO_ABILITATO;
        }
        if (TipoAutorizzazione.SIGNAL_HUB_PUSH.equals((Object)autorizzazione)) {
            return STATO_SIGNAL_HUB_PUSH_SIGNALS;
        }
        return STATO_ABILITATO;
    }

    public static RuoloTipologia convertToRuoloTipologia(String autorizzazione) {
        return AutorizzazioneUtilities.convertToRuoloTipologia(TipoAutorizzazione.toEnumConstant((String)autorizzazione));
    }

    public static RuoloTipologia convertToRuoloTipologia(TipoAutorizzazione autorizzazione) {
        if (autorizzazione == null) {
            return RuoloTipologia.QUALSIASI;
        }
        switch (autorizzazione) {
            case AUTHENTICATED_EXTERNAL_ROLES: 
            case EXTERNAL_ROLES: 
            case EXTERNAL_XACML_POLICY: {
                return RuoloTipologia.ESTERNO;
            }
            case AUTHENTICATED_INTERNAL_ROLES: 
            case INTERNAL_ROLES: 
            case INTERNAL_XACML_POLICY: {
                return RuoloTipologia.INTERNO;
            }
            case AUTHENTICATED_ROLES: 
            case ROLES: 
            case XACML_POLICY: {
                return RuoloTipologia.QUALSIASI;
            }
        }
        return RuoloTipologia.QUALSIASI;
    }

    public static TipoAutorizzazione convertToTipoAutorizzazione(String stato, boolean authenticated, boolean roles, boolean tokenAuthenticated, boolean tokenRoles, boolean scopes, String autorizzazioneTokenOptions, RuoloTipologia tipologia) {
        if (STATO_DISABILITATO.equals(stato)) {
            return TipoAutorizzazione.DISABILITATO;
        }
        if (STATO_XACML_POLICY.equals(stato)) {
            switch (tipologia) {
                case ESTERNO: {
                    return TipoAutorizzazione.EXTERNAL_XACML_POLICY;
                }
                case INTERNO: {
                    return TipoAutorizzazione.INTERNAL_XACML_POLICY;
                }
                case QUALSIASI: {
                    return TipoAutorizzazione.XACML_POLICY;
                }
            }
        } else {
            if (STATO_SIGNAL_HUB_PUSH_SIGNALS.equals(stato)) {
                return TipoAutorizzazione.SIGNAL_HUB_PUSH;
            }
            if (roles) {
                switch (tipologia) {
                    case ESTERNO: {
                        if (authenticated) {
                            return TipoAutorizzazione.AUTHENTICATED_EXTERNAL_ROLES;
                        }
                        return TipoAutorizzazione.EXTERNAL_ROLES;
                    }
                    case INTERNO: {
                        if (authenticated) {
                            return TipoAutorizzazione.AUTHENTICATED_INTERNAL_ROLES;
                        }
                        return TipoAutorizzazione.INTERNAL_ROLES;
                    }
                    case QUALSIASI: {
                        if (authenticated) {
                            return TipoAutorizzazione.AUTHENTICATED_ROLES;
                        }
                        return TipoAutorizzazione.ROLES;
                    }
                }
            } else {
                if (authenticated) {
                    return TipoAutorizzazione.AUTHENTICATED;
                }
                if (tokenAuthenticated || tokenRoles || scopes || autorizzazioneTokenOptions != null && !"".equals(autorizzazioneTokenOptions)) {
                    return TipoAutorizzazione.TOKEN;
                }
            }
        }
        return TipoAutorizzazione.DISABILITATO;
    }

    public static String convertToTipoAutorizzazioneAsString(String stato, boolean authenticated, boolean roles, boolean tokenAuthenticated, boolean tokenRoles, boolean scopes, String autorizzazioneTokenOptions, RuoloTipologia tipologia) {
        return AutorizzazioneUtilities.convertToTipoAutorizzazione(stato, authenticated, roles, tokenAuthenticated, tokenRoles, scopes, autorizzazioneTokenOptions, tipologia).getValue();
    }
}

