/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.utils;

import jakarta.xml.bind.ValidationEventHandler;
import java.net.MalformedURLException;
import java.util.List;
import javax.xml.validation.Schema;
import org.herasaf.xacml.core.utils.SchemaConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class JAXBMarshallerConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JAXBMarshallerConfiguration.class);
    private boolean formattedOutput;
    private boolean fragment;
    private SchemaConfiguration schemaConfiguration = new SchemaConfiguration();
    private boolean writeSchemaLocation;
    private boolean validateParsing;
    private boolean validateWriting;
    private ValidationEventHandler validationEventHandler;

    public ValidationEventHandler getValidationEventHandler() {
        return this.validationEventHandler;
    }

    public void setValidationEventHandler(ValidationEventHandler validationEventHandler) {
        this.validationEventHandler = validationEventHandler;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public void setFragment(boolean fragment) {
        this.fragment = fragment;
    }

    public Schema getSchema() {
        return this.schemaConfiguration.getSchema();
    }

    public void setSchemaByPath(String ... schemaPaths) throws SAXException, MalformedURLException {
        try {
            this.schemaConfiguration.setSchemaByPath(schemaPaths);
        }
        catch (SAXException e) {
            this.setValidateParsing(false);
            this.setValidateWriting(false);
            logger.warn("Validating turned off because schema could not be initialized.");
        }
    }

    public String getSchemaLocationAsString() {
        return this.schemaConfiguration.getSchemaLocationAsString();
    }

    public void setSchemaLocation(List<String> schemaLocation) {
        this.schemaConfiguration.setSchemaLocation(schemaLocation);
    }

    public boolean isValidateParsing() {
        return this.validateParsing;
    }

    public void setValidateParsing(boolean validate) {
        this.validateParsing = validate;
    }

    public boolean isValidateWriting() {
        return this.validateWriting;
    }

    public void setValidateWriting(boolean validateWriting) {
        this.validateWriting = validateWriting;
    }

    public boolean isWriteSchemaLocation() {
        return this.writeSchemaLocation;
    }

    public void setWriteSchemaLocation(boolean writeSchemaLocation) {
        this.writeSchemaLocation = writeSchemaLocation;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        builder.append("formattedOutput = ");
        builder.append(this.isFormattedOutput());
        builder.append(", ");
        builder.append("fragment = ");
        builder.append(this.isFormattedOutput());
        builder.append(", ");
        builder.append("validateParsing = ");
        builder.append(this.isValidateParsing());
        builder.append(", ");
        builder.append("validateWriting = ");
        builder.append(this.isValidateWriting());
        builder.append(", ");
        builder.append("schemaConfiguraiton = {");
        builder.append(this.schemaConfiguration.toString());
        builder.append("}, ");
        builder.append("writeSchemaLocation = ");
        builder.append(this.isWriteSchemaLocation());
        builder.append("}");
        return builder.toString();
    }
}

