/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.herasaf.xacml.core.SyntaxException;

public class YearMonthDuration
implements Comparable<YearMonthDuration> {
    private Period period;
    private boolean negative = false;

    public YearMonthDuration(String durationString) throws SyntaxException {
        durationString = durationString.trim();
        if (durationString.startsWith("-")) {
            this.negative = true;
            durationString = durationString.substring(1);
        }
        try {
            this.period = Period.parse(durationString);
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        return this.negative ? "-" + this.period : this.period.toString();
    }

    @Override
    public int compareTo(YearMonthDuration o) {
        return LocalDate.now().plus(this.getDuration()).compareTo(LocalDate.now().plus(o.getDuration()));
    }

    public int hashCode() {
        return Objects.hash(this.period, this.negative);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        YearMonthDuration other = (YearMonthDuration)obj;
        if (!Objects.equals(this.period, other.period)) {
            return false;
        }
        return this.negative == other.negative;
    }

    public Period getDuration() {
        return this.period;
    }

    public boolean isNegative() {
        return this.negative;
    }
}

