/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.types;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Base64Binary {
    private static final Set<Character> BASE64CHARS = new HashSet<Character>();
    private static final Set<Character> IGNORED_WHITESPACE;
    private static final char PADDING_CHAR = '=';
    private final String base64String;

    public Base64Binary(String stringRepresentation) {
        char[] characters = stringRepresentation.toCharArray();
        int relevantCharsCount = 0;
        boolean isPreviousPaddingCharacter = false;
        for (int i = 0; i < characters.length; ++i) {
            char character = characters[i];
            boolean isWhitespaceCharacter = IGNORED_WHITESPACE.contains(Character.valueOf(character));
            if (isWhitespaceCharacter) continue;
            ++relevantCharsCount;
            isPreviousPaddingCharacter = this.verifyCharacter(character, isPreviousPaddingCharacter);
        }
        this.verifyLength(relevantCharsCount);
        this.base64String = stringRepresentation;
    }

    private boolean verifyCharacter(char character, boolean isPreviousPaddingCharacter) {
        boolean isPaddingCharacter;
        boolean bl = isPaddingCharacter = '=' == character;
        if (isPreviousPaddingCharacter && !isPaddingCharacter) {
            throw new IllegalArgumentException("Encountered non-padding character.");
        }
        if (!isPaddingCharacter) {
            this.verifyBase64Character(character);
        }
        return isPaddingCharacter;
    }

    private void verifyBase64Character(char character) {
        boolean isBase64Character = BASE64CHARS.contains(Character.valueOf(character));
        if (!isBase64Character) {
            String message = String.format("Base64 string contains '%s' which is not a valid Base64 character.", Character.valueOf(character));
            throw new IllegalArgumentException(message);
        }
    }

    private void verifyLength(int relevantCharsCount) {
        boolean hasNoRelevantCharacters;
        boolean isNotMultipleOfFour = relevantCharsCount % 4 != 0;
        boolean bl = hasNoRelevantCharacters = relevantCharsCount == 0;
        if (isNotMultipleOfFour || hasNoRelevantCharacters) {
            throw new IllegalArgumentException("A Base64Binary string's length must be a multiple of four.");
        }
    }

    public int hashCode() {
        return this.base64String.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().isAssignableFrom(Base64Binary.class)) {
            return ((Base64Binary)obj).getValue().equals(this.base64String);
        }
        return false;
    }

    public String toString() {
        return this.base64String;
    }

    public String getValue() {
        return this.base64String;
    }

    static {
        Collections.addAll(BASE64CHARS, Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('X'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('g'), Character.valueOf('h'), Character.valueOf('i'), Character.valueOf('j'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('p'), Character.valueOf('q'), Character.valueOf('r'), Character.valueOf('s'), Character.valueOf('t'), Character.valueOf('u'), Character.valueOf('v'), Character.valueOf('w'), Character.valueOf('x'), Character.valueOf('y'), Character.valueOf('z'), Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('+'), Character.valueOf('/'));
        IGNORED_WHITESPACE = new HashSet<Character>();
        Collections.addAll(IGNORED_WHITESPACE, Character.valueOf('\t'), Character.valueOf('\n'), Character.valueOf('\r'), Character.valueOf(' '), Character.valueOf('\u00a0'), Character.valueOf('\u2007'), Character.valueOf('\u202f'));
    }
}

