/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.simplePDP;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.herasaf.xacml.core.InitializationException;
import org.herasaf.xacml.core.api.PDP;
import org.herasaf.xacml.core.api.PolicyRetrievalPoint;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyCombiningAlgorithm;
import org.herasaf.xacml.core.simplePDP.SimplePDP;
import org.herasaf.xacml.core.simplePDP.SimplePDPConfiguration;
import org.herasaf.xacml.core.simplePDP.initializers.InitializerExecutor;
import org.herasaf.xacml.core.simplePDP.initializers.api.Initializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SimplePDPFactory {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(SimplePDPFactory.class);

    private SimplePDPFactory() {
    }

    public static Set<Initializer> getDefaultInitializers() {
        return InitializerExecutor.getDefaultInitializers();
    }

    public static void setInitalizers(Set<Initializer> initalizers) {
        LOGGER.info("Custom initializers are in use.");
        InitializerExecutor.setInitalizers(initalizers);
    }

    public static void resetInitializers() {
        InitializerExecutor.resetInitializers();
    }

    public static PDP getSimplePDP(SimplePDPConfiguration simplePDPConfiguration) {
        InitializerExecutor.runInitializers(simplePDPConfiguration);
        return new SimplePDP(simplePDPConfiguration);
    }

    public static PDP getSimplePDP(SimplePDPConfiguration simplePDPConfiguration, Class<? extends SimplePDP> customPDP) {
        InitializerExecutor.runInitializers(simplePDPConfiguration);
        try {
            Constructor<? extends SimplePDP> constructor = customPDP.getConstructor(SimplePDPConfiguration.class);
            SimplePDP pdp = constructor.newInstance(simplePDPConfiguration);
            return pdp;
        }
        catch (SecurityException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        catch (NoSuchMethodException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        catch (IllegalArgumentException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        catch (InstantiationException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        catch (IllegalAccessException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
        catch (InvocationTargetException e) {
            InitializationException ie = new InitializationException("Cannot create custom PDP: " + customPDP.getCanonicalName(), e);
            LOGGER.error(ie.getMessage());
            throw ie;
        }
    }

    public static PDP getSimplePDP(PolicyCombiningAlgorithm rootCombiningAlgorithm) {
        SimplePDPConfiguration simplePDPConfiguration = new SimplePDPConfiguration();
        simplePDPConfiguration.setRootCombiningAlgorithm(rootCombiningAlgorithm);
        return SimplePDPFactory.getSimplePDP(simplePDPConfiguration);
    }

    public static PDP getSimplePDP(PolicyRetrievalPoint policyRetrievalPoint) {
        SimplePDPConfiguration simplePDPConfiguration = new SimplePDPConfiguration();
        simplePDPConfiguration.setPolicyRetrievalPoint(policyRetrievalPoint);
        return SimplePDPFactory.getSimplePDP(simplePDPConfiguration);
    }

    public static PDP getSimplePDP(PolicyCombiningAlgorithm rootCombiningAlgorithm, PolicyRetrievalPoint policyRetrievalPoint) {
        SimplePDPConfiguration simplePDPConfiguration = new SimplePDPConfiguration();
        simplePDPConfiguration.setRootCombiningAlgorithm(rootCombiningAlgorithm);
        simplePDPConfiguration.setPolicyRetrievalPoint(policyRetrievalPoint);
        return SimplePDPFactory.getSimplePDP(simplePDPConfiguration);
    }

    public static PDP getSimplePDP() {
        return SimplePDPFactory.getSimplePDP(new SimplePDPConfiguration());
    }
}

