/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.converter;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.HashMap;
import java.util.Map;
import org.herasaf.xacml.core.NotInitializedException;
import org.herasaf.xacml.core.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionsJAXBTypeAdapter
extends XmlAdapter<String, Function> {
    private static final Logger logger = LoggerFactory.getLogger(FunctionsJAXBTypeAdapter.class);
    private static Map<String, Function> functions = new HashMap<String, Function>();

    public static void addFunctions(Map<String, Function> functions) {
        FunctionsJAXBTypeAdapter.functions.putAll(functions);
    }

    public String marshal(Function function) {
        String functionString;
        try {
            functionString = function.toString();
        }
        catch (NullPointerException e) {
            logger.error("Argument function must not be null: ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return functionString;
    }

    public Function unmarshal(String functionId) {
        Function func;
        try {
            func = functions.get(functionId);
        }
        catch (NullPointerException e) {
            logger.error("FunctionsJAXBTypeAdapter not properly initialized.");
            throw new NotInitializedException(e);
        }
        if (func != null) {
            return func;
        }
        throw new IllegalArgumentException("Function " + functionId + " unknown.");
    }
}

