/*
 * Decompiled with CFR 0.152.
 */
package org.herasaf.xacml.core.combiningAlgorithm.policy.impl;

import java.util.ArrayList;
import java.util.List;
import org.herasaf.xacml.core.combiningAlgorithm.CombiningAlgorithm;
import org.herasaf.xacml.core.combiningAlgorithm.policy.PolicyUnorderedCombiningAlgorithm;
import org.herasaf.xacml.core.context.EvaluationContext;
import org.herasaf.xacml.core.context.StatusCode;
import org.herasaf.xacml.core.context.XACMLDefaultStatusCode;
import org.herasaf.xacml.core.context.impl.DecisionType;
import org.herasaf.xacml.core.context.impl.RequestType;
import org.herasaf.xacml.core.policy.Evaluatable;
import org.herasaf.xacml.core.policy.impl.EffectType;
import org.herasaf.xacml.core.policy.impl.IdReferenceType;
import org.herasaf.xacml.core.policy.impl.ObligationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class PolicyDenyOverridesAlgorithm
extends PolicyUnorderedCombiningAlgorithm {
    public static final String ID = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:deny-overrides";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(PolicyDenyOverridesAlgorithm.class);

    @Override
    public DecisionType evaluateEvaluatableList(RequestType request, List<Evaluatable> possiblePolicies, EvaluationContext evaluationContext) {
        if (possiblePolicies == null) {
            logger.error("The possiblePolicies list was null. This is an illegal state.");
            evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
            return DecisionType.INDETERMINATE;
        }
        ArrayList<ObligationType> obligationsOfApplicableEvals = new ArrayList<ObligationType>();
        boolean atLeastOnePermit = false;
        boolean atLeastOneDeny = false;
        boolean atLeastOneError = false;
        ArrayList<StatusCode> statusCodes = new ArrayList<StatusCode>();
        for (int i = 0; i < possiblePolicies.size(); ++i) {
            DecisionType decision;
            CombiningAlgorithm combiningAlg;
            Evaluatable eval = possiblePolicies.get(i);
            if (eval instanceof IdReferenceType) {
                eval = evaluationContext.getPolicyRetrievalPoint().getEvaluatable(eval.getId());
            }
            if (eval == null) {
                logger.error("The list of possible policies must not contain any null values.");
                evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
                return DecisionType.INDETERMINATE;
            }
            if (atLeastOneDeny && evaluationContext.isRespectAbandonedEvaluatables() && !eval.hasObligations()) break;
            evaluationContext.resetStatus();
            if (logger.isDebugEnabled()) {
                MDC.put((String)"org:herasaf:xacml:evaluation:evaluatableid", (String)eval.getId().toString());
                logger.debug("Starting evaluation of: {}", (Object)eval.getId().toString());
            }
            if ((combiningAlg = eval.getCombiningAlg()) == null) {
                logger.error("Unable to locate combining algorithm for policy {}", (Object)eval.getId());
                evaluationContext.updateStatusCode(XACMLDefaultStatusCode.SYNTAX_ERROR);
                decision = DecisionType.INDETERMINATE;
            } else {
                decision = combiningAlg.evaluate(request, eval, evaluationContext);
            }
            if (logger.isDebugEnabled()) {
                MDC.put((String)"org:herasaf:xacml:evaluation:evaluatableid", (String)eval.getId().toString());
                logger.debug("Evaluation of {} was: {}", (Object)eval.getId().toString(), (Object)decision.toString());
                MDC.remove((String)"org:herasaf:xacml:evaluation:evaluatableid");
            }
            if (decision == DecisionType.PERMIT || decision == DecisionType.DENY) {
                obligationsOfApplicableEvals.addAll(eval.getContainedObligations(EffectType.fromValue(decision.toString())));
                obligationsOfApplicableEvals.addAll(evaluationContext.getObligations().getObligations());
            }
            switch (decision) {
                case DENY: {
                    if (!evaluationContext.isRespectAbandonedEvaluatables()) {
                        evaluationContext.clearObligations();
                        evaluationContext.addObligations(obligationsOfApplicableEvals, EffectType.DENY);
                        return DecisionType.DENY;
                    }
                    atLeastOneDeny = true;
                    break;
                }
                case PERMIT: {
                    atLeastOnePermit = true;
                    break;
                }
                case INDETERMINATE: {
                    statusCodes.add(evaluationContext.getStatusCode());
                    atLeastOneError = true;
                    break;
                }
            }
            evaluationContext.clearObligations();
        }
        if (atLeastOneDeny) {
            evaluationContext.resetStatus();
            evaluationContext.addObligations(obligationsOfApplicableEvals, EffectType.DENY);
            return DecisionType.DENY;
        }
        if (atLeastOneError) {
            evaluationContext.resetStatus();
            return DecisionType.DENY;
        }
        if (atLeastOnePermit) {
            evaluationContext.addObligations(obligationsOfApplicableEvals, EffectType.PERMIT);
            evaluationContext.resetStatus();
            return DecisionType.PERMIT;
        }
        evaluationContext.clearObligations();
        return DecisionType.NOT_APPLICABLE;
    }

    @Override
    public String getCombiningAlgorithmId() {
        return ID;
    }
}

