/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.expression.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openspcoop2.generic_project.beans.ComplexField;
import org.openspcoop2.generic_project.beans.ConstantField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.IModel;
import org.openspcoop2.generic_project.exception.ExpressionException;
import org.openspcoop2.generic_project.exception.ExpressionNotFoundException;
import org.openspcoop2.generic_project.exception.ExpressionNotImplementedException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.Index;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.expression.impl.AbstractBaseExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.BetweenExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.Comparator;
import org.openspcoop2.generic_project.expression.impl.ComparatorExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.ConjunctionExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.DateTimePartExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.DayFormatExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.InExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.LikeExpressionImpl;
import org.openspcoop2.generic_project.expression.impl.OrderedField;
import org.openspcoop2.generic_project.expression.impl.formatter.IObjectFormatter;
import org.openspcoop2.generic_project.expression.impl.formatter.ObjectFormatter;
import org.openspcoop2.utils.UtilsRuntimeException;
import org.openspcoop2.utils.sql.DateTimePartEnum;
import org.openspcoop2.utils.sql.DayFormatEnum;

public class ExpressionImpl
implements IExpression {
    private static final String FIELD_IS_NULL = "Field is null";
    private static final String FIELD_TYPE_CONSTANT_CANNOT_BE_USED = "The field type 'ConstantField' can not be used with this method";
    private boolean throwExpressionNotInitialized = false;
    protected IObjectFormatter objectFormatter;
    protected boolean andLogicOperator = true;
    protected AbstractBaseExpressionImpl expressionEngine;
    protected boolean notOperator = false;
    private SortOrder sortOrderEngine = SortOrder.UNSORTED;
    protected List<OrderedField> orderedFields = new ArrayList<OrderedField>();
    protected List<IField> groupByFields = new ArrayList<IField>();
    protected List<Index> forceIndexes = new ArrayList<Index>();
    protected Map<String, Object> properties = new HashMap<String, Object>();

    public IObjectFormatter getObjectFormatter() {
        return this.objectFormatter;
    }

    public void setObjectFormatter(IObjectFormatter objectFormatter) {
        this.objectFormatter = objectFormatter;
    }

    public ExpressionImpl() throws ExpressionException {
        this.objectFormatter = new ObjectFormatter();
    }

    public ExpressionImpl(IObjectFormatter objectFormatter) throws ExpressionException {
        if (objectFormatter == null) {
            throw new ExpressionException("IObjectFormatter parameter is null");
        }
        this.objectFormatter = objectFormatter;
    }

    public ExpressionImpl(ExpressionImpl expr) {
        this.andLogicOperator = expr.andLogicOperator;
        this.expressionEngine = expr.expressionEngine;
        this.notOperator = expr.notOperator;
        this.objectFormatter = expr.objectFormatter;
        this.orderedFields = expr.orderedFields;
        this.sortOrderEngine = expr.getSortOrder();
        this.groupByFields = expr.groupByFields;
        this.throwExpressionNotInitialized = expr.throwExpressionNotInitialized;
        this.forceIndexes = expr.forceIndexes;
    }

    public AbstractBaseExpressionImpl getExpressionEngine() {
        return this.expressionEngine;
    }

    @Override
    public IExpression not() throws ExpressionNotImplementedException, ExpressionException {
        this.notOperator = true;
        if (this.expressionEngine != null) {
            this.expressionEngine.setNot(true);
        }
        return this;
    }

    @Override
    public IExpression and() throws ExpressionNotImplementedException, ExpressionException {
        this.andLogicOperator = true;
        if (this.expressionEngine instanceof ConjunctionExpressionImpl) {
            ((ConjunctionExpressionImpl)this.expressionEngine).setAndConjunction(this.andLogicOperator);
        }
        return this;
    }

    @Override
    public IExpression or() throws ExpressionNotImplementedException, ExpressionException {
        this.andLogicOperator = false;
        if (this.expressionEngine instanceof ConjunctionExpressionImpl) {
            ((ConjunctionExpressionImpl)this.expressionEngine).setAndConjunction(this.andLogicOperator);
        }
        return this;
    }

    protected Comparator getCorrectComparator(Comparator comparator) {
        return comparator;
    }

    @Override
    public IExpression equals(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, this.getCorrectComparator(Comparator.EQUALS));
        return this;
    }

    @Override
    public IExpression notEquals(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, this.getCorrectComparator(Comparator.NOT_EQUALS));
        return this;
    }

    @Override
    public IExpression allEquals(Map<IField, Object> propertyNameValues) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(propertyNameValues);
        this.buildComparatorExpression(propertyNameValues, this.getCorrectComparator(Comparator.EQUALS), true);
        return this;
    }

    @Override
    public IExpression allNotEquals(Map<IField, Object> propertyNameValues) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(propertyNameValues);
        this.buildComparatorExpression(propertyNameValues, this.getCorrectComparator(Comparator.NOT_EQUALS), true);
        return this;
    }

    @Override
    public IExpression allEquals(Map<IField, Object> propertyNameValues, boolean andConjunction) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(propertyNameValues);
        this.buildComparatorExpression(propertyNameValues, this.getCorrectComparator(Comparator.EQUALS), andConjunction);
        return this;
    }

    @Override
    public IExpression allNotEquals(Map<IField, Object> propertyNameValues, boolean andConjunction) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(propertyNameValues);
        this.buildComparatorExpression(propertyNameValues, this.getCorrectComparator(Comparator.NOT_EQUALS), andConjunction);
        return this;
    }

    @Override
    public IExpression greaterThan(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, this.getCorrectComparator(Comparator.GREATER_THAN));
        return this;
    }

    @Override
    public IExpression greaterEquals(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, this.getCorrectComparator(Comparator.GREATER_EQUALS));
        return this;
    }

    @Override
    public IExpression lessThan(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, this.getCorrectComparator(Comparator.LESS_THAN));
        return this;
    }

    @Override
    public IExpression lessEquals(IField field, Object value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildComparatorExpression(field, value, this.getCorrectComparator(Comparator.LESS_EQUALS));
        return this;
    }

    @Override
    public IExpression isNull(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        this.buildComparatorExpression(field, null, this.getCorrectComparator(Comparator.IS_NULL));
        return this;
    }

    @Override
    public IExpression isNotNull(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        this.buildComparatorExpression(field, null, this.getCorrectComparator(Comparator.IS_NOT_NULL));
        return this;
    }

    @Override
    public IExpression isEmpty(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        this.buildComparatorExpression(field, null, this.getCorrectComparator(Comparator.IS_EMPTY));
        return this;
    }

    @Override
    public IExpression isNotEmpty(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        this.buildComparatorExpression(field, null, this.getCorrectComparator(Comparator.IS_NOT_EMPTY));
        return this;
    }

    @Override
    public IExpression between(IField field, Object lower, Object high) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, lower, high);
        this.buildBeetweenExpression(field, lower, high);
        return this;
    }

    @Override
    public IExpression like(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildLikeExpression(field, value, LikeMode.ANYWHERE, false);
        return this;
    }

    @Override
    public IExpression like(IField field, String value, LikeMode mode) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildLikeExpression(field, value, mode, false);
        return this;
    }

    @Override
    public IExpression ilike(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildLikeExpression(field, value, LikeMode.ANYWHERE, true);
        return this;
    }

    @Override
    public IExpression ilike(IField field, String value, LikeMode mode) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildLikeExpression(field, value, mode, true);
        return this;
    }

    @Override
    public IExpression isYear(IField field, int value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, "" + value, DateTimePartEnum.YEAR);
        return this;
    }

    @Override
    public IExpression isYear(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, value, DateTimePartEnum.YEAR);
        return this;
    }

    @Override
    public IExpression isMonth(IField field, int value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, "" + value, DateTimePartEnum.MONTH);
        return this;
    }

    @Override
    public IExpression isMonth(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, value, DateTimePartEnum.MONTH);
        return this;
    }

    @Override
    public IExpression isDayOfMonth(IField field, int value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, "" + value, DateTimePartEnum.DAY);
        return this;
    }

    @Override
    public IExpression isDayOfMonth(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, value, DateTimePartEnum.DAY);
        return this;
    }

    @Override
    public IExpression isDayOfYear(IField field, int value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDayFormatExpression(field, "" + value, DayFormatEnum.DAY_OF_YEAR);
        return this;
    }

    @Override
    public IExpression isDayOfYear(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDayFormatExpression(field, value, DayFormatEnum.DAY_OF_YEAR);
        return this;
    }

    @Override
    public IExpression isDayOfWeek(IField field, int value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDayFormatExpression(field, "" + value, DayFormatEnum.DAY_OF_WEEK);
        return this;
    }

    @Override
    public IExpression isDayOfWeek(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDayFormatExpression(field, value, DayFormatEnum.DAY_OF_WEEK);
        return this;
    }

    @Override
    public IExpression isHour(IField field, int value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, "" + value, DateTimePartEnum.HOUR);
        return this;
    }

    @Override
    public IExpression isHour(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, value, DateTimePartEnum.HOUR);
        return this;
    }

    @Override
    public IExpression isMinute(IField field, int value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, "" + value, DateTimePartEnum.MINUTE);
        return this;
    }

    @Override
    public IExpression isMinute(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, value, DateTimePartEnum.MINUTE);
        return this;
    }

    @Override
    public IExpression isSecond(IField field, int value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, "" + value, DateTimePartEnum.SECOND);
        return this;
    }

    @Override
    public IExpression isSecond(IField field, double value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, "" + value, DateTimePartEnum.SECOND);
        return this;
    }

    @Override
    public IExpression isSecond(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDateTimePartExpression(field, value, DateTimePartEnum.SECOND);
        return this;
    }

    @Override
    public IExpression isFullDayName(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDayFormatExpression(field, value, DayFormatEnum.FULL_DAY_NAME);
        return this;
    }

    @Override
    public IExpression isShortDayName(IField field, String value) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, value);
        this.buildDayFormatExpression(field, value, DayFormatEnum.SHORT_DAY_NAME);
        return this;
    }

    @Override
    public IExpression in(IField field, Object ... values) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, values);
        this.buildInExpression(field, values);
        return this;
    }

    @Override
    public IExpression in(IField field, Collection<?> values) throws ExpressionNotImplementedException, ExpressionException {
        if (values == null) {
            throw new ExpressionException("Values is null");
        }
        this.checkArgoments(field, values.toArray(new Object[1]));
        this.buildInExpression(field, values.toArray(new Object[1]));
        return this;
    }

    @Override
    public IExpression and(IExpression exp1, IExpression exp2) throws ExpressionNotImplementedException, ExpressionException {
        IExpression[] expr = new IExpression[]{exp1, exp2};
        return this.and(expr);
    }

    @Override
    public IExpression and(IExpression ... expressions) throws ExpressionNotImplementedException, ExpressionException {
        this.checkConjunctionOperation(expressions);
        this.buildConjunctionExpression(true, expressions);
        return this;
    }

    @Override
    public IExpression or(IExpression exp1, IExpression exp2) throws ExpressionNotImplementedException, ExpressionException {
        IExpression[] expr = new IExpression[]{exp1, exp2};
        return this.or(expr);
    }

    @Override
    public IExpression or(IExpression ... expressions) throws ExpressionNotImplementedException, ExpressionException {
        this.checkConjunctionOperation(expressions);
        this.buildConjunctionExpression(false, expressions);
        return this;
    }

    @Override
    public IExpression not(IExpression expression) throws ExpressionNotImplementedException, ExpressionException {
        if (!(expression instanceof ExpressionImpl)) {
            throw new ExpressionException("Expression has wrong type expect: " + ExpressionImpl.class.getName() + "  found: " + expression.getClass().getName());
        }
        this.buildNotExpression(((ExpressionImpl)expression).expressionEngine);
        return this;
    }

    @Override
    public IExpression sortOrder(SortOrder sortOrder) throws ExpressionNotImplementedException, ExpressionException {
        this.sortOrderEngine = sortOrder;
        return this;
    }

    @Override
    public IExpression addOrder(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        if (this.sortOrderEngine == null || SortOrder.UNSORTED.equals((Object)this.sortOrderEngine)) {
            throw new ExpressionException("To add order by conditions must first be defined the sort order (by sortOrder method)");
        }
        this.orderedFields.add(new OrderedField(field, this.sortOrderEngine));
        return this;
    }

    @Override
    public IExpression addOrder(IField field, SortOrder sortOrder) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        if (sortOrder == null) {
            throw new ExpressionException("Sort order parameter undefined");
        }
        if (SortOrder.UNSORTED.equals((Object)sortOrder)) {
            throw new ExpressionException("Sort order parameter not valid (use ASC or DESC)");
        }
        this.orderedFields.add(new OrderedField(field, sortOrder));
        return this;
    }

    public List<OrderedField> getOrderedFields() {
        return this.orderedFields;
    }

    public SortOrder getSortOrder() {
        if ((this.sortOrderEngine == null || SortOrder.UNSORTED.equals((Object)this.sortOrderEngine)) && this.orderedFields != null && !this.orderedFields.isEmpty()) {
            return this.orderedFields.get(0).getSortOrder();
        }
        return this.sortOrderEngine;
    }

    @Override
    public IExpression addGroupBy(IField field) throws ExpressionNotImplementedException, ExpressionException {
        this.checkArgoments(field, false);
        this.groupByFields.add(field);
        return this;
    }

    public List<IField> getGroupByFields() {
        return this.groupByFields;
    }

    @Override
    public boolean inUseField(IField field, boolean checkOnlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        boolean check;
        if (this.expressionEngine == null && checkOnlyWhereCondition) {
            return false;
        }
        if (this.expressionEngine != null && this.expressionEngine.inUseField(field)) {
            return true;
        }
        return !checkOnlyWhereCondition && (check = this.checkUseField(field));
    }

    private boolean checkUseField(IField field) {
        int i;
        if (this.orderedFields != null) {
            for (i = 0; i < this.orderedFields.size(); ++i) {
                if (!field.equals(this.orderedFields.get(i).getField())) continue;
                return true;
            }
        }
        if (this.groupByFields != null) {
            for (i = 0; i < this.groupByFields.size(); ++i) {
                if (!field.equals(this.groupByFields.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean inUseModel(IModel<?> model, boolean checkOnlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        if (this.expressionEngine == null && checkOnlyWhereCondition) {
            return false;
        }
        if (this.expressionEngine != null && this.expressionEngine.inUseModel(model)) {
            return true;
        }
        if (!checkOnlyWhereCondition) {
            String modeClassName;
            ComplexField c;
            boolean inUseModel;
            IField field;
            int i;
            if (this.orderedFields != null) {
                for (i = 0; i < this.orderedFields.size(); ++i) {
                    field = this.orderedFields.get(i).getField();
                    inUseModel = false;
                    if (model.getBaseField() != null) {
                        if (field instanceof ComplexField) {
                            c = (ComplexField)field;
                            inUseModel = c.getFather().equals(model.getBaseField());
                        } else {
                            modeClassName = model.getModeledClass().getName();
                            inUseModel = modeClassName.equals(field.getClassType().getName());
                        }
                    } else {
                        modeClassName = model.getModeledClass().getName();
                        inUseModel = modeClassName.equals(field.getClassType().getName());
                    }
                    if (!inUseModel) continue;
                    return true;
                }
            }
            if (this.groupByFields != null) {
                for (i = 0; i < this.groupByFields.size(); ++i) {
                    field = this.groupByFields.get(i);
                    inUseModel = false;
                    if (model.getBaseField() != null) {
                        if (field instanceof ComplexField) {
                            c = (ComplexField)field;
                            inUseModel = c.getFather().equals(model.getBaseField());
                        } else {
                            modeClassName = model.getModeledClass().getName();
                            inUseModel = modeClassName.equals(field.getClassType().getName());
                        }
                    } else {
                        modeClassName = model.getModeledClass().getName();
                        inUseModel = modeClassName.equals(field.getClassType().getName());
                    }
                    if (!inUseModel) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<IField> getFields(boolean onlyWhereCondition) throws ExpressionNotImplementedException, ExpressionException {
        List<IField> o;
        List<IField> list = o = this.expressionEngine != null ? this.expressionEngine.getFields() : null;
        if (!onlyWhereCondition) {
            o = this.addFieldByOrderBy(o);
            o = this.addFieldByGroupBy(o);
        }
        return o;
    }

    private List<IField> addFieldByOrderBy(List<IField> o) {
        if (this.orderedFields != null) {
            for (int i = 0; i < this.orderedFields.size(); ++i) {
                IField field = this.orderedFields.get(i).getField();
                if (o == null) {
                    o = new ArrayList<IField>();
                }
                if (o.contains(field)) continue;
                o.add(field);
            }
        }
        return o;
    }

    private List<IField> addFieldByGroupBy(List<IField> o) {
        if (this.groupByFields != null) {
            for (int i = 0; i < this.groupByFields.size(); ++i) {
                IField field = this.groupByFields.get(i);
                if (o == null) {
                    o = new ArrayList<IField>();
                }
                if (o.contains(field)) continue;
                o.add(field);
            }
        }
        return o;
    }

    @Override
    public List<Object> getWhereConditionFieldValues(IField field) throws ExpressionNotImplementedException, ExpressionNotFoundException, ExpressionException {
        if (this.expressionEngine == null) {
            throw new ExpressionNotFoundException("Field is not used in expression (Expression is empty)");
        }
        if (!this.inUseField(field, true)) {
            throw new ExpressionNotFoundException("Field is not used in expression [" + field.toString() + "]");
        }
        List<Object> o = this.expressionEngine.getFieldValues(field);
        if (o == null) {
            throw new ExpressionNotFoundException("Field is not used in expression [" + field.toString() + "] (null??)");
        }
        return o;
    }

    @Override
    public boolean isWhereConditionsPresent() throws ExpressionNotImplementedException, ExpressionException {
        return this.expressionEngine == null;
    }

    @Override
    public IExpression addForceIndex(Index index) throws ExpressionNotImplementedException, ExpressionException {
        this.forceIndexes.add(index);
        return this;
    }

    public List<Index> getForceIndexes() {
        return this.forceIndexes;
    }

    @Override
    public void addProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public String toString() {
        return this.toString(true);
    }

    protected String toString(boolean printForceIndex) {
        int index;
        String s = super.toString();
        if (s == null) {
            return s;
        }
        if (this.throwExpressionNotInitialized) {
            throw new UtilsRuntimeException("Expression is not initialized");
        }
        StringBuilder bf = new StringBuilder();
        if (this.expressionEngine == null) {
            bf.append("");
        } else {
            bf.append(this.expressionEngine.toString());
        }
        if (!this.groupByFields.isEmpty()) {
            bf.append(" GROUP BY ");
            index = 0;
            for (IField field : this.groupByFields) {
                if (index > 0) {
                    bf.append(" , ");
                }
                if (field instanceof ComplexField) {
                    ComplexField cf = (ComplexField)field;
                    if (cf.getFather() != null) {
                        bf.append(cf.getFather().getFieldName());
                    } else {
                        bf.append(field.getClassName());
                    }
                } else {
                    bf.append(field.getClassName());
                }
                bf.append(".");
                bf.append(field.getFieldName());
                ++index;
            }
        }
        if (!SortOrder.UNSORTED.equals((Object)this.getSortOrder())) {
            bf.append(" ORDER BY ");
            if (!this.orderedFields.isEmpty()) {
                index = 0;
                for (OrderedField orderedField : this.orderedFields) {
                    IField field;
                    if (index > 0) {
                        bf.append(" , ");
                    }
                    if ((field = orderedField.getField()) instanceof ComplexField) {
                        ComplexField cf = (ComplexField)field;
                        if (cf.getFather() != null) {
                            bf.append(cf.getFather().getFieldName());
                        } else {
                            bf.append(field.getClassName());
                        }
                    } else {
                        bf.append(field.getClassName());
                    }
                    bf.append(".");
                    bf.append(field.getFieldName());
                    bf.append(" ");
                    bf.append(orderedField.getSortOrder().name());
                    ++index;
                }
            } else {
                bf.append(" DEFAULT_ORDER_FIELD");
                bf.append(" ");
                bf.append(this.getSortOrder().name());
            }
        }
        if (printForceIndex) {
            this.printForceIndex(bf);
        }
        return bf.toString();
    }

    protected void printForceIndex(StringBuilder bf) {
        if (!this.forceIndexes.isEmpty()) {
            for (Index forceIndex : this.forceIndexes) {
                String forceIndexSql = "/*+ index(" + forceIndex.getModel().getModeledClass().getSimpleName() + " " + forceIndex.getName() + ") */";
                bf.append(" ");
                bf.append(forceIndexSql);
            }
        }
    }

    protected ComparatorExpressionImpl getComparatorExpression(IField field, Object value, Comparator c) {
        return new ComparatorExpressionImpl(this.objectFormatter, field, value, c);
    }

    protected BetweenExpressionImpl getBetweenExpression(IField field, Object lower, Object high) {
        return new BetweenExpressionImpl(this.objectFormatter, field, lower, high);
    }

    protected InExpressionImpl getInExpression(IField field, Object ... values) {
        ArrayList<Object> lista = new ArrayList<Object>();
        if (values != null && values.length > 0) {
            lista.addAll(Arrays.asList(values));
        }
        return new InExpressionImpl(this.objectFormatter, field, lista);
    }

    protected LikeExpressionImpl getLikeExpression(IField field, String value, LikeMode mode, boolean caseInsensitive) {
        return new LikeExpressionImpl(this.objectFormatter, field, value, mode, caseInsensitive);
    }

    protected DateTimePartExpressionImpl getDateTimePartExpression(IField field, String value, DateTimePartEnum dateTimePartEnum) {
        return new DateTimePartExpressionImpl(this.objectFormatter, field, value, dateTimePartEnum);
    }

    protected DayFormatExpressionImpl getDayFormatExpression(IField field, String value, DayFormatEnum dayFormatEnum) {
        return new DayFormatExpressionImpl(this.objectFormatter, field, value, dayFormatEnum);
    }

    protected ConjunctionExpressionImpl getConjunctionExpression() {
        return new ConjunctionExpressionImpl(this.objectFormatter);
    }

    protected void buildComparatorExpression(IField field, Object value, Comparator c) {
        ComparatorExpressionImpl cExp = this.getComparatorExpression(field, value, c);
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildComparatorExpression(Map<IField, Object> propertyNameValues, Comparator c, boolean and) {
        Iterator<IField> fieldsIt = propertyNameValues.keySet().iterator();
        ConjunctionExpressionImpl newConjunctionExpr = this.getConjunctionExpression();
        newConjunctionExpr.setAndConjunction(and);
        while (fieldsIt.hasNext()) {
            IField field = fieldsIt.next();
            Object value = propertyNameValues.get(field);
            newConjunctionExpr.addExpression(this.getComparatorExpression(field, value, c));
        }
        this.conjunctionWithInternalInstance(newConjunctionExpr);
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildBeetweenExpression(IField field, Object lower, Object high) {
        BetweenExpressionImpl cExp = this.getBetweenExpression(field, lower, high);
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildInExpression(IField field, Object ... values) {
        InExpressionImpl cExp = this.getInExpression(field, values);
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildLikeExpression(IField field, String value, LikeMode mode, boolean caseInsensitive) {
        LikeExpressionImpl cExp = this.getLikeExpression(field, value, mode, caseInsensitive);
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildDateTimePartExpression(IField field, String value, DateTimePartEnum dateTimePartEnum) {
        DateTimePartExpressionImpl cExp = this.getDateTimePartExpression(field, value, dateTimePartEnum);
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildDayFormatExpression(IField field, String value, DayFormatEnum dayFormatEnum) {
        DayFormatExpressionImpl cExp = this.getDayFormatExpression(field, value, dayFormatEnum);
        if (this.expressionEngine == null) {
            this.expressionEngine = cExp;
        } else {
            this.conjunctionWithInternalInstance(cExp);
        }
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void buildNotExpression(AbstractBaseExpressionImpl expr) {
        expr.setNot(true);
        if (this.expressionEngine == null) {
            this.expressionEngine = expr;
        } else {
            String s2;
            String s1 = this.expressionEngine.toString();
            if (s1.equals(s2 = expr.toString())) {
                this.expressionEngine = expr;
            } else {
                this.conjunctionWithInternalInstance(expr);
            }
        }
    }

    protected void buildConjunctionExpression(boolean and, IExpression ... expressions) {
        ConjunctionExpressionImpl cExp = this.getConjunctionExpression();
        cExp.setAndConjunction(and);
        boolean add = false;
        for (int i = 0; i < expressions.length; ++i) {
            ExpressionImpl xmlExpression = (ExpressionImpl)expressions[i];
            if (xmlExpression.expressionEngine == null) continue;
            cExp.addExpression(xmlExpression.expressionEngine);
            add = true;
        }
        if (add) {
            if (this.expressionEngine == null) {
                this.expressionEngine = cExp;
            } else {
                this.conjunctionWithInternalInstance(cExp);
            }
            this.expressionEngine.setNot(this.notOperator);
        }
    }

    protected void conjunctionWithInternalInstance(AbstractBaseExpressionImpl newExpr) {
        ConjunctionExpressionImpl newConjunctionExpr = this.getConjunctionExpression();
        newConjunctionExpr.setAndConjunction(this.andLogicOperator);
        if (this.expressionEngine != null) {
            if (!(this.expressionEngine instanceof ConjunctionExpressionImpl)) {
                newConjunctionExpr.addExpression(this.expressionEngine);
            } else {
                boolean simpleConjunction = true;
                ConjunctionExpressionImpl cTest = (ConjunctionExpressionImpl)this.expressionEngine;
                if (cTest.isAndConjunction() != this.andLogicOperator) {
                    simpleConjunction = false;
                }
                if (simpleConjunction) {
                    for (AbstractBaseExpressionImpl expr : cTest.getLista()) {
                        if (!(expr instanceof ConjunctionExpressionImpl)) continue;
                        simpleConjunction = false;
                        break;
                    }
                }
                if (simpleConjunction) {
                    for (AbstractBaseExpressionImpl expr : cTest.getLista()) {
                        newConjunctionExpr.addExpression(expr);
                    }
                } else {
                    newConjunctionExpr.addExpression(cTest);
                }
            }
        }
        newConjunctionExpr.addExpression(newExpr);
        this.expressionEngine = newConjunctionExpr;
        this.expressionEngine.setNot(this.notOperator);
    }

    protected void checkArgoments(IField field) throws ExpressionException {
        this.checkArgoments(field, true);
    }

    protected void checkArgoments(IField field, boolean constantPermit) throws ExpressionException {
        if (field == null) {
            throw new ExpressionException(FIELD_IS_NULL);
        }
        if (!constantPermit && field instanceof ConstantField) {
            throw new ExpressionException(FIELD_TYPE_CONSTANT_CANNOT_BE_USED);
        }
    }

    protected void checkArgoments(IField field, Object value) throws ExpressionException {
        this.checkArgoments(field, value, true);
    }

    protected void checkArgoments(IField field, Object value, boolean constantPermit) throws ExpressionException {
        if (field == null) {
            throw new ExpressionException(FIELD_IS_NULL);
        }
        if (value == null) {
            throw new ExpressionException("Value is null for field: " + field.toString());
        }
        try {
            this.objectFormatter.isSupported(value);
        }
        catch (Exception e) {
            throw new ExpressionException("[Value] " + e.getMessage(), e);
        }
        if (!constantPermit && field instanceof ConstantField) {
            throw new ExpressionException(FIELD_TYPE_CONSTANT_CANNOT_BE_USED);
        }
    }

    protected void checkArgoments(IField field, Object[] values) throws ExpressionException {
        this.checkArgoments(field, values, true);
    }

    protected void checkArgoments(IField field, Object[] values, boolean constantPermit) throws ExpressionException {
        if (field == null) {
            throw new ExpressionException(FIELD_IS_NULL);
        }
        if (values == null) {
            throw new ExpressionException("Values is null");
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) {
                throw new ExpressionException("Values[" + i + "] is null for field: " + field.toString());
            }
            try {
                this.objectFormatter.isSupported(values[i]);
                continue;
            }
            catch (Exception e) {
                throw new ExpressionException("[Value[" + i + "]] " + e.getMessage(), e);
            }
        }
        if (!constantPermit && field instanceof ConstantField) {
            throw new ExpressionException(FIELD_TYPE_CONSTANT_CANNOT_BE_USED);
        }
    }

    protected void checkArgoments(IField field, Object lower, Object high) throws ExpressionException {
        this.checkArgoments(field, lower, high, true);
    }

    protected void checkArgoments(IField field, Object lower, Object high, boolean constantPermit) throws ExpressionException {
        if (field == null) {
            throw new ExpressionException(FIELD_IS_NULL);
        }
        if (lower == null) {
            throw new ExpressionException("Lower is null for field: " + field.toString());
        }
        if (high == null) {
            throw new ExpressionException("High is null for field: " + field.toString());
        }
        try {
            this.objectFormatter.isSupported(lower);
        }
        catch (Exception e) {
            throw new ExpressionException("[Lower] " + e.getMessage(), e);
        }
        try {
            this.objectFormatter.isSupported(high);
        }
        catch (Exception e) {
            throw new ExpressionException("[High] " + e.getMessage(), e);
        }
        if (!constantPermit && field instanceof ConstantField) {
            throw new ExpressionException(FIELD_TYPE_CONSTANT_CANNOT_BE_USED);
        }
    }

    protected void checkArgoments(Map<IField, Object> propertyNameValues) throws ExpressionException {
        this.checkArgoments(propertyNameValues, true);
    }

    protected void checkArgoments(Map<IField, Object> propertyNameValues, boolean constantPermit) throws ExpressionException {
        if (propertyNameValues == null) {
            throw new ExpressionException("PropertyNameValues is null");
        }
        for (IField iField : propertyNameValues.keySet()) {
            if (iField == null) {
                throw new ExpressionException(FIELD_IS_NULL);
            }
            if (propertyNameValues.get(iField) == null) {
                throw new ExpressionException("Value for Field[" + String.valueOf(iField) + "] is null");
            }
            try {
                this.objectFormatter.isSupported(propertyNameValues.get(iField));
            }
            catch (Exception e) {
                throw new ExpressionException("[Value for Field[" + String.valueOf(iField) + "]] " + e.getMessage(), e);
            }
            if (constantPermit || !(iField instanceof ConstantField)) continue;
            throw new ExpressionException(FIELD_TYPE_CONSTANT_CANNOT_BE_USED);
        }
    }

    protected void checkConjunctionOperation(IExpression ... expressions) throws ExpressionException {
        if (expressions == null || expressions.length <= 0) {
            throw new ExpressionException("Expressions is null or is empty");
        }
        for (int i = 0; i < expressions.length; ++i) {
            if (expressions[i] == null) {
                throw new ExpressionException("Expression[" + i + "] is null");
            }
            if (expressions[i] instanceof ExpressionImpl) continue;
            throw new ExpressionException("Expression[" + i + "] has wrong type expect: " + ExpressionImpl.class.getName() + "  found: " + expressions[i].getClass().getName());
        }
    }
}

