/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.generic_project.dao.jdbc.utils;

import org.openspcoop2.generic_project.dao.jdbc.utils.JDBC_DB2SQLQueryObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBC_DerbyQueryObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBC_HyperQueryObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBC_MySQLQueryObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBC_OracleQueryObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBC_PostgreSQLQueryObject;
import org.openspcoop2.generic_project.dao.jdbc.utils.JDBC_SQLServerQueryObject;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLQueryObjectCore;
import org.openspcoop2.utils.sql.SQLQueryObjectException;

public class JDBC_SQLObjectFactory {
    private boolean selectForUpdate = false;

    public boolean isSelectForUpdate() {
        return this.selectForUpdate;
    }

    public void setSelectForUpdate(boolean selectForUpdate) {
        this.selectForUpdate = selectForUpdate;
    }

    public ISQLQueryObject createSQLQueryObject(TipiDatabase tipoDatabase) throws SQLQueryObjectException {
        Object sqlQueryObject = null;
        switch (tipoDatabase) {
            case POSTGRESQL: {
                sqlQueryObject = new JDBC_PostgreSQLQueryObject(this);
                break;
            }
            case MYSQL: {
                sqlQueryObject = new JDBC_MySQLQueryObject(this);
                break;
            }
            case ORACLE: {
                sqlQueryObject = new JDBC_OracleQueryObject(this);
                break;
            }
            case HSQL: {
                sqlQueryObject = new JDBC_HyperQueryObject(this);
                break;
            }
            case DERBY: {
                sqlQueryObject = new JDBC_DerbyQueryObject(this);
                break;
            }
            case SQLSERVER: {
                sqlQueryObject = new JDBC_SQLServerQueryObject(this);
                break;
            }
            case DB2: {
                sqlQueryObject = new JDBC_DB2SQLQueryObject(this);
                break;
            }
            case DEFAULT: {
                throw new SQLQueryObjectException("Tipo database non gestito [" + String.valueOf(tipoDatabase) + "]");
            }
        }
        if (sqlQueryObject == null) {
            throw new SQLQueryObjectException("Tipo database non gestito");
        }
        sqlQueryObject.setSelectForUpdate(this.selectForUpdate);
        ((SQLQueryObjectCore)sqlQueryObject).setForceSelectForUpdateDisabledForNotQueryMethod(true);
        return sqlQueryObject;
    }
}

