/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.validator;

import org.openspcoop2.core.registry.AccordoCooperazione;
import org.openspcoop2.core.registry.AccordoServizioParteComune;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.protocol.basic.validator.ValidazioneAccordi;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.validator.ValidazioneResult;
import org.openspcoop2.protocol.spcoop.sica.SICAtoOpenSPCoopContext;

public class SPCoopValidazioneAccordi
extends ValidazioneAccordi {
    public SPCoopValidazioneAccordi(IProtocolFactory<?> factory) throws ProtocolException {
        super(factory);
    }

    public ValidazioneResult valida(AccordoServizioParteComune accordoServizioParteComune) {
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(false);
        try {
            SICAtoOpenSPCoopContext context = SICAtoOpenSPCoopContext.getInstance();
            if (context.isSICAClient_nomeAccordo_32CaratteriMax() && accordoServizioParteComune.getNome().length() > 32) {
                result.setMessaggioErrore("Il nome dell'accordo di servizio parte comune deve essere formato da non piu' di 32 caratteri");
                return result;
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("Durante la validazione dell'accordo \u00e8 stata generata una eccezione non prevista: " + e.getMessage());
            result.setException(e);
            return result;
        }
        result.setEsito(true);
        return result;
    }

    public ValidazioneResult valida(AccordoServizioParteSpecifica accordoServizioParteSpecifica) {
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(false);
        try {
            SICAtoOpenSPCoopContext context = SICAtoOpenSPCoopContext.getInstance();
            if (context.isSICAClient_nomeAccordo_32CaratteriMax() && accordoServizioParteSpecifica.getNome().length() > 32) {
                result.setMessaggioErrore("Il nome dell'accordo di servizio parte specifica deve essere formato da non piu' di 32 caratteri");
                return result;
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("Durante la validazione dell'accordo \u00e8 stata generata una eccezione non prevista: " + e.getMessage());
            result.setException(e);
            return result;
        }
        result.setEsito(true);
        return result;
    }

    public ValidazioneResult valida(AccordoCooperazione accordoCooperazione) {
        ValidazioneResult result = new ValidazioneResult();
        result.setEsito(false);
        try {
            SICAtoOpenSPCoopContext context = SICAtoOpenSPCoopContext.getInstance();
            if (context.isSICAClient_nomeAccordo_32CaratteriMax() && accordoCooperazione.getNome().length() > 32) {
                result.setMessaggioErrore("Il nome dell'accordo di cooperazione deve essere formato da non piu' di 32 caratteri");
                return result;
            }
        }
        catch (Exception e) {
            result.setMessaggioErrore("Durante la validazione dell'accordo \u00e8 stata generata una eccezione non prevista: " + e.getMessage());
            result.setException(e);
            return result;
        }
        result.setEsito(true);
        return result;
    }
}

