/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.tracciamento;

import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPFactory;
import jakarta.xml.soap.SOAPHeaderElement;
import java.io.ByteArrayOutputStream;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.soap.SoapUtils;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.protocol.basic.tracciamento.TracciaSerializer;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.BustaRawContent;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.constants.TipoSerializzazione;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.tracciamento.Traccia;
import org.openspcoop2.protocol.spcoop.SPCoopBustaRawContent;
import org.openspcoop2.protocol.spcoop.builder.SPCoopImbustamento;
import org.w3c.dom.Element;

public class SPCoopTracciaSerializer
extends TracciaSerializer
implements ITracciaSerializer {
    private SPCoopImbustamento imbustamento = null;

    public SPCoopTracciaSerializer(IProtocolFactory<SOAPHeaderElement> factory) throws ProtocolException {
        super(factory);
        this.imbustamento = new SPCoopImbustamento(factory, null);
    }

    public SOAPElement toElement(Traccia tracciaObject) throws ProtocolException {
        try {
            SOAPFactory sf = SoapUtils.getSoapFactory((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)MessageType.SOAP_11);
            SOAPElement traccia = sf.createElement("traccia", "eGov_IT_Trac", "http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/");
            SOAPElement GDO = traccia.addChildElement("GDO", "eGov_IT_Trac", "http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/");
            if (tracciaObject.getGdo() == null) {
                GDO.setValue(this.protocolFactory.createTraduttore().getDate_protocolFormat());
            } else {
                GDO.setValue(this.protocolFactory.createTraduttore().getDate_protocolFormat(tracciaObject.getGdo()));
            }
            SOAPElement IdentificativoPorta = traccia.addChildElement("IdentificativoPorta", "eGov_IT_Trac", "http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/");
            IdentificativoPorta.setValue(tracciaObject.getIdSoggetto().getCodicePorta());
            SOAPElement TipoMessaggio = traccia.addChildElement("TipoMessaggio", "eGov_IT_Trac", "http://www.cnipa.it/schemas/2003/eGovIT/Tracciamento1_0/");
            TipoMessaggio.setValue(tracciaObject.getTipoMessaggio().toString());
            SOAPElement hdrEGov = null;
            Busta busta = tracciaObject.getBusta();
            BustaRawContent bustaInDom = tracciaObject.getBustaAsRawContent();
            String bustaAsString = tracciaObject.getBustaAsString();
            byte[] bustaInByte = tracciaObject.getBustaAsByteArray();
            if (bustaInDom != null) {
                hdrEGov = (SOAPElement)((SPCoopBustaRawContent)bustaInDom).getElement();
            } else if (bustaAsString != null) {
                hdrEGov = OpenSPCoop2MessageFactory.createSOAPElement((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)MessageType.SOAP_11, (byte[])bustaAsString.getBytes());
            } else if (bustaInByte != null) {
                hdrEGov = OpenSPCoop2MessageFactory.createSOAPElement((OpenSPCoop2MessageFactory)OpenSPCoop2MessageFactory.getDefaultMessageFactory(), (MessageType)MessageType.SOAP_11, (byte[])bustaInByte);
            } else if (busta != null) {
                hdrEGov = this.imbustamento.build_eGovHeader(null, busta, false, true);
            } else {
                throw new NullPointerException("Busta non fornita in alcun modo");
            }
            if (hdrEGov == null) {
                throw new ProtocolException("XMLBuilder.buildElement_Tracciamento fallito");
            }
            traccia.addChildElement(hdrEGov);
            return traccia;
        }
        catch (Exception e) {
            this.log.error("TracciaSerializer.toElement error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("TracciaSerializer.toElement error: " + e.getMessage(), (Throwable)e);
        }
    }

    protected ByteArrayOutputStream toByteArrayOutputStream(Traccia traccia, TipoSerializzazione tipoSerializzazione) throws ProtocolException {
        try {
            switch (tipoSerializzazione) {
                case XML: 
                case DEFAULT: {
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    bout.write(MessageXMLUtils.DEFAULT.toByteArray((Element)this.toElement(traccia)));
                    bout.flush();
                    bout.close();
                    return bout;
                }
            }
            throw new Exception("Tipo Serializzazione [" + String.valueOf(tipoSerializzazione) + "] Non gestito");
        }
        catch (Exception e) {
            this.log.error("DiagnosticSerializer.toString error: " + e.getMessage(), (Throwable)e);
            throw new ProtocolException("DiagnosticSerializer.toString error: " + e.getMessage(), (Throwable)e);
        }
    }
}

