/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop.config;

import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.Servizio;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.constants.ProfiloDiCollaborazione;
import org.openspcoop2.protocol.sdk.constants.StatoFunzionalitaProtocollo;
import org.openspcoop2.protocol.spcoop.config.SPCoopProtocolManager;

public class SPCoopProtocolVersionManager
extends SPCoopProtocolManager
implements IProtocolVersionManager {
    protected String versione;

    public SPCoopProtocolVersionManager(IProtocolFactory<?> protocolFactory, String versione) throws ProtocolException {
        super(protocolFactory);
        this.versione = versione;
    }

    public StatoFunzionalitaProtocollo getFiltroDuplicati(Busta busta) {
        return this._getFiltroDuplicati();
    }

    public StatoFunzionalitaProtocollo getFiltroDuplicati(Servizio infoServizio) {
        return this._getFiltroDuplicati();
    }

    private StatoFunzionalitaProtocollo _getFiltroDuplicati() {
        if ("eGov1.1-lineeGuida1.1".equals(this.versione)) {
            return StatoFunzionalitaProtocollo.ABILITATA;
        }
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public StatoFunzionalitaProtocollo getConsegnaAffidabile(Busta busta) {
        return this._getConsegnaAffidabile();
    }

    public StatoFunzionalitaProtocollo getConsegnaAffidabile(Servizio infoServizio) {
        return this._getConsegnaAffidabile();
    }

    private StatoFunzionalitaProtocollo _getConsegnaAffidabile() {
        if ("eGov1.1-lineeGuida1.1".equals(this.versione)) {
            return StatoFunzionalitaProtocollo.DISABILITATA;
        }
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public StatoFunzionalitaProtocollo getConsegnaInOrdine(Busta busta) {
        return this._getConsegnaInOrdine();
    }

    public StatoFunzionalitaProtocollo getConsegnaInOrdine(Servizio infoServizio) {
        return this._getConsegnaInOrdine();
    }

    private StatoFunzionalitaProtocollo _getConsegnaInOrdine() {
        if ("eGov1.1-lineeGuida1.1".equals(this.versione)) {
            return StatoFunzionalitaProtocollo.DISABILITATA;
        }
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public StatoFunzionalitaProtocollo getCollaborazione(Busta busta) {
        return this._getCollaborazione(busta.getProfiloDiCollaborazione());
    }

    public StatoFunzionalitaProtocollo getCollaborazione(Servizio infoServizio) {
        return this._getCollaborazione(infoServizio.getProfiloDiCollaborazione());
    }

    private StatoFunzionalitaProtocollo _getCollaborazione(ProfiloDiCollaborazione profiloCollaborazione) {
        if ("eGov1.1-lineeGuida1.1".equals(this.versione)) {
            if (profiloCollaborazione == null || ProfiloDiCollaborazione.UNKNOWN.equals((Object)profiloCollaborazione)) {
                return StatoFunzionalitaProtocollo.REGISTRO;
            }
            if (profiloCollaborazione.equals((Object)ProfiloDiCollaborazione.ONEWAY) || profiloCollaborazione.equals((Object)ProfiloDiCollaborazione.SINCRONO)) {
                return StatoFunzionalitaProtocollo.DISABILITATA;
            }
            return StatoFunzionalitaProtocollo.ABILITATA;
        }
        return StatoFunzionalitaProtocollo.REGISTRO;
    }

    public StatoFunzionalitaProtocollo getIdRiferimentoRichiesta(Busta busta) {
        return this._getIdRiferimentoRichiesta();
    }

    public StatoFunzionalitaProtocollo getIdRiferimentoRichiesta(Servizio infoServizio) {
        return this._getIdRiferimentoRichiesta();
    }

    private StatoFunzionalitaProtocollo _getIdRiferimentoRichiesta() {
        return StatoFunzionalitaProtocollo.DISABILITATA;
    }

    public boolean isCorrelazioneRichiestaPresenteRispostaAsincronaSimmetrica() {
        return !"eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isCorrelazioneRichiestaPresenteRichiestaStatoAsincronaAsimmetrica() {
        return !"eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isGenerazioneInformazioniServizioCorrelatoAsincronoSimmetrico() {
        return !"eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isGenerazioneInformazioniServizioCorrelatoAsincronoAsimmetrico() {
        return !"eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public String getIdCorrelazioneAsincrona(Busta richiesta) {
        if ("eGov1.1-lineeGuida1.1".equals(this.versione)) {
            return richiesta.getCollaborazione();
        }
        return richiesta.getRiferimentoMessaggio();
    }

    public String getIdCorrelazioneAsincrona(String rifMsg, String collaborazione) {
        if ("eGov1.1-lineeGuida1.1".equalsIgnoreCase(this.versione)) {
            if (rifMsg != null) {
                return rifMsg;
            }
            if (collaborazione != null) {
                return collaborazione;
            }
        } else {
            return rifMsg;
        }
        return null;
    }

    public boolean isEccezioniLivelloInfoAbilitato() {
        return "eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isIgnoraEccezioniLivelloNonGrave() {
        return "eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isGenerazioneBusteErrore_strutturaMalformataHeaderProtocollo() {
        return this.spcoopProperties.isGenerazioneBustaErrore_strutturaMalformataHeaderProtocollo();
    }

    public boolean isGenerazioneErroreMessaggioOnewayDuplicato() {
        return "eGov1.1-lineeGuida1.1".equals(this.versione);
    }

    public boolean isUtilizzoIndirizzoSoggettoPresenteBusta() {
        return !"eGov1.1-lineeGuida1.1".equalsIgnoreCase(this.versione);
    }
}

