/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.protocol.spcoop;

import jakarta.xml.soap.SOAPHeaderElement;
import java.util.HashMap;
import java.util.Map;
import org.openspcoop2.protocol.basic.BasicFactory;
import org.openspcoop2.protocol.basic.BasicStaticInstanceConfig;
import org.openspcoop2.protocol.manifest.Openspcoop2;
import org.openspcoop2.protocol.sdk.ConfigurazionePdD;
import org.openspcoop2.protocol.sdk.IProtocolFactory;
import org.openspcoop2.protocol.sdk.ProtocolException;
import org.openspcoop2.protocol.sdk.archive.IArchive;
import org.openspcoop2.protocol.sdk.builder.IErroreApplicativoBuilder;
import org.openspcoop2.protocol.sdk.builder.IEsitoBuilder;
import org.openspcoop2.protocol.sdk.config.IProtocolConfiguration;
import org.openspcoop2.protocol.sdk.config.IProtocolManager;
import org.openspcoop2.protocol.sdk.config.IProtocolVersionManager;
import org.openspcoop2.protocol.sdk.config.ITraduttore;
import org.openspcoop2.protocol.sdk.diagnostica.IDiagnosticSerializer;
import org.openspcoop2.protocol.sdk.state.IState;
import org.openspcoop2.protocol.sdk.tracciamento.ITracciaSerializer;
import org.openspcoop2.protocol.sdk.validator.IValidatoreErrori;
import org.openspcoop2.protocol.sdk.validator.IValidazioneAccordi;
import org.openspcoop2.protocol.sdk.validator.IValidazioneConSchema;
import org.openspcoop2.protocol.sdk.validator.IValidazioneDocumenti;
import org.openspcoop2.protocol.sdk.validator.IValidazioneSemantica;
import org.openspcoop2.protocol.spcoop.archive.SPCoopArchive;
import org.openspcoop2.protocol.spcoop.builder.SPCoopBustaBuilder;
import org.openspcoop2.protocol.spcoop.builder.SPCoopErroreApplicativoBuilder;
import org.openspcoop2.protocol.spcoop.builder.SPCoopEsitoBuilder;
import org.openspcoop2.protocol.spcoop.config.SPCoopProperties;
import org.openspcoop2.protocol.spcoop.config.SPCoopProtocolConfiguration;
import org.openspcoop2.protocol.spcoop.config.SPCoopProtocolManager;
import org.openspcoop2.protocol.spcoop.config.SPCoopProtocolVersionManager;
import org.openspcoop2.protocol.spcoop.config.SPCoopTraduttore;
import org.openspcoop2.protocol.spcoop.diagnostica.SPCoopDiagnosticSerializer;
import org.openspcoop2.protocol.spcoop.tracciamento.SPCoopTracciaSerializer;
import org.openspcoop2.protocol.spcoop.validator.SPCoopValidatoreErrori;
import org.openspcoop2.protocol.spcoop.validator.SPCoopValidazioneAccordi;
import org.openspcoop2.protocol.spcoop.validator.SPCoopValidazioneConSchema;
import org.openspcoop2.protocol.spcoop.validator.SPCoopValidazioneDocumenti;
import org.openspcoop2.protocol.spcoop.validator.SPCoopValidazioneSemantica;
import org.openspcoop2.protocol.spcoop.validator.SPCoopValidazioneSintattica;
import org.openspcoop2.protocol.utils.EsitiProperties;
import org.openspcoop2.utils.MapKey;
import org.slf4j.Logger;

public class SPCoopFactory
extends BasicFactory<SOAPHeaderElement> {
    private static final long serialVersionUID = -4246311511752079753L;
    private static IErroreApplicativoBuilder staticInstanceErroreApplicativoBuilder = null;
    private static IEsitoBuilder staticInstanceEsitoBuilder = null;
    private static IProtocolManager staticInstanceProtocolManager = null;
    private static Map<String, IProtocolVersionManager> staticInstanceProtocolVersionManager = null;
    private static ITraduttore staticInstanceTraduttore = null;
    private static IProtocolConfiguration staticInstanceProtocolConfiguration = null;

    public void init(Logger log, String protocol, ConfigurazionePdD configPdD, Openspcoop2 manifest) throws ProtocolException {
        super.init(log, protocol, configPdD, manifest);
        SPCoopProperties.initialize(configPdD.getConfigurationDir(), log);
        SPCoopProperties properties = SPCoopProperties.getInstance(log);
        properties.validaConfigurazione(configPdD.getLoader());
        BasicStaticInstanceConfig staticInstanceConfig = properties.getStaticInstanceConfig();
        super.initStaticInstance(staticInstanceConfig);
        if (staticInstanceConfig != null) {
            if (staticInstanceConfig.isStaticConfig()) {
                staticInstanceProtocolManager = new SPCoopProtocolManager((IProtocolFactory<?>)this);
                staticInstanceProtocolVersionManager = new HashMap<String, IProtocolVersionManager>();
                staticInstanceTraduttore = new SPCoopTraduttore((IProtocolFactory<?>)this);
                staticInstanceProtocolConfiguration = new SPCoopProtocolConfiguration((IProtocolFactory<?>)this);
            }
            if (staticInstanceConfig.isStaticErrorBuilder()) {
                staticInstanceErroreApplicativoBuilder = new SPCoopErroreApplicativoBuilder((IProtocolFactory<?>)this);
            }
            if (staticInstanceConfig.isStaticEsitoBuilder() && EsitiProperties.isInitializedProtocol((MapKey)this.getProtocolMapKey())) {
                staticInstanceEsitoBuilder = new SPCoopEsitoBuilder((IProtocolFactory<?>)this);
            }
        }
    }

    public void initStaticInstance() throws ProtocolException {
        super.initStaticInstance();
        if (this.staticInstanceConfig != null && this.staticInstanceConfig.isStaticEsitoBuilder() && staticInstanceEsitoBuilder == null && EsitiProperties.isInitializedProtocol((MapKey)this.getProtocolMapKey())) {
            SPCoopFactory.initStaticInstanceEsitoBuilder(this);
        }
    }

    public SPCoopBustaBuilder createBustaBuilder(IState state) throws ProtocolException {
        return new SPCoopBustaBuilder((IProtocolFactory<SOAPHeaderElement>)this, state);
    }

    public IErroreApplicativoBuilder createErroreApplicativoBuilder() throws ProtocolException {
        return staticInstanceErroreApplicativoBuilder != null ? staticInstanceErroreApplicativoBuilder : new SPCoopErroreApplicativoBuilder((IProtocolFactory<?>)this);
    }

    private static synchronized void initStaticInstanceEsitoBuilder(SPCoopFactory spcoopFactory) throws ProtocolException {
        if (staticInstanceEsitoBuilder == null) {
            staticInstanceEsitoBuilder = new SPCoopEsitoBuilder((IProtocolFactory<?>)spcoopFactory);
        }
    }

    public IEsitoBuilder createEsitoBuilder() throws ProtocolException {
        return staticInstanceEsitoBuilder != null ? staticInstanceEsitoBuilder : new SPCoopEsitoBuilder((IProtocolFactory<?>)this);
    }

    public IValidatoreErrori createValidatoreErrori(IState state) throws ProtocolException {
        return new SPCoopValidatoreErrori((IProtocolFactory<?>)this, state);
    }

    public SPCoopValidazioneSintattica createValidazioneSintattica(IState state) throws ProtocolException {
        return new SPCoopValidazioneSintattica((IProtocolFactory<SOAPHeaderElement>)this, state);
    }

    public IValidazioneSemantica createValidazioneSemantica(IState state) throws ProtocolException {
        return new SPCoopValidazioneSemantica((IProtocolFactory<?>)this, state);
    }

    public IValidazioneConSchema createValidazioneConSchema(IState state) throws ProtocolException {
        return new SPCoopValidazioneConSchema((IProtocolFactory<?>)this, state);
    }

    public IValidazioneDocumenti createValidazioneDocumenti() throws ProtocolException {
        return new SPCoopValidazioneDocumenti((IProtocolFactory<?>)this);
    }

    public IValidazioneAccordi createValidazioneAccordi() throws ProtocolException {
        return new SPCoopValidazioneAccordi((IProtocolFactory<?>)this);
    }

    public IDiagnosticSerializer createDiagnosticSerializer() throws ProtocolException {
        return new SPCoopDiagnosticSerializer((IProtocolFactory<?>)this);
    }

    public ITracciaSerializer createTracciaSerializer() throws ProtocolException {
        return new SPCoopTracciaSerializer((IProtocolFactory<SOAPHeaderElement>)this);
    }

    public IArchive createArchive() throws ProtocolException {
        return new SPCoopArchive(this.getLogger(), (IProtocolFactory<?>)this);
    }

    public IProtocolManager createProtocolManager() throws ProtocolException {
        return staticInstanceProtocolManager != null ? staticInstanceProtocolManager : new SPCoopProtocolManager((IProtocolFactory<?>)this);
    }

    public IProtocolVersionManager createProtocolVersionManager(String version) throws ProtocolException {
        if (staticInstanceProtocolVersionManager != null) {
            if (!staticInstanceProtocolVersionManager.containsKey(version)) {
                this.initProtocolVersionManager(version);
            }
            return staticInstanceProtocolVersionManager.get(version);
        }
        return new SPCoopProtocolVersionManager((IProtocolFactory<?>)this, version);
    }

    private synchronized void initProtocolVersionManager(String version) throws ProtocolException {
        if (!staticInstanceProtocolVersionManager.containsKey(version)) {
            staticInstanceProtocolVersionManager.put(version, new SPCoopProtocolVersionManager((IProtocolFactory<?>)this, version));
        }
    }

    public ITraduttore createTraduttore() throws ProtocolException {
        return staticInstanceTraduttore != null ? staticInstanceTraduttore : new SPCoopTraduttore((IProtocolFactory<?>)this);
    }

    public IProtocolConfiguration createProtocolConfiguration() throws ProtocolException {
        return staticInstanceProtocolConfiguration != null ? staticInstanceProtocolConfiguration : new SPCoopProtocolConfiguration((IProtocolFactory<?>)this);
    }
}

