/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.openspcoop2.core.config.AccessoRegistroRegistro;
import org.openspcoop2.core.config.constants.RegistroTipo;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.utils.PdDConfig;
import org.openspcoop2.core.registry.driver.utils.XMLDataConverter;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Semaphore;
import org.openspcoop2.utils.SemaphoreLock;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class XMLDataConverterMainProcessor {
    private static Semaphore semaphoreResetEffettuata = new Semaphore("TestXMLDataConverterRegistryReset");
    private static Boolean resetEffettuata = false;

    public static void main(String[] argoments) throws Exception {
        if (argoments.length < 9) {
            String errorMsg = "ERROR, Usage:  java XMLDataConverterMainProcessor sorgenteXML tipoRegistroCRUD proprietaRegistroCRUD reset tipoConversione gestioneSoggetti mantieniFruitori deleteMappingErogazioneFruizione statoAccordiImportati protocolloDefault [[logger] [nomePddOperativa logger]]";
            System.err.println(errorMsg);
            throw new Exception(errorMsg);
        }
        String args_sorgenteXML = argoments[0].trim();
        String args_tipoRegistroCRUD = argoments[1].trim();
        String args_proprietaRegistroCRUD = argoments[2].trim();
        String args_reset = argoments[3].trim();
        String args_tipoConversione = argoments[4].trim();
        String args_gestioneSoggetti = argoments[5].trim();
        String args_mantieniFruitori = argoments[6].trim();
        String argsdeleteEngineMappingErogazioneFruizione = argoments[7].trim();
        String args_statoAccordiImportati = argoments[8].trim();
        String args_protocolloDefault = argoments[9].trim();
        String args_nomePddOperativa = null;
        String args_logger = null;
        if (argoments.length == 11) {
            args_logger = argoments[10].trim();
        } else {
            args_nomePddOperativa = argoments[10].trim();
            args_logger = argoments[11].trim();
        }
        String loggerValue = null;
        try {
            if (args_logger != null) {
                LoggerWrapperFactory.setLogConfiguration((String)args_logger);
            } else {
                URL url = XMLDataConverterMainProcessor.class.getResource("/xml2backend.log4j2.properties");
                if (url != null) {
                    LoggerWrapperFactory.setLogConfiguration((URL)url);
                } else {
                    File logFile = FileSystemUtilities.createTempFile((String)"testXMLDataConverterRegistro_", (String)".log");
                    System.out.println("LogMessages write in " + logFile.getAbsolutePath());
                    LoggerWrapperFactory.setDefaultLogConfiguration((Level)Level.ALL, (boolean)false, null, (File)logFile, (String)"%p <%d{dd-MM-yyyy HH:mm:ss}> %C.%M(%L): %m %n %n");
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "Errore durante il caricamento del file di log loggerValue[" + loggerValue + "] : " + e.getMessage();
            System.err.println(errorMsg);
            System.out.println("Args.length: " + argoments.length);
            for (int i = 0; i < argoments.length; ++i) {
                System.out.println("Arg[" + i + "]=[" + argoments[i] + "]");
            }
            throw new Exception(errorMsg, e);
        }
        Logger log = LoggerWrapperFactory.getLogger((String)"gestoreDatiRegistro");
        String statoAccordo = args_statoAccordiImportati;
        if (!(StatiAccordo.bozza.toString().equals(statoAccordo) || StatiAccordo.operativo.toString().equals(statoAccordo) || StatiAccordo.finale.toString().equals(statoAccordo))) {
            String errorMsg = "Opzione 'statoAccordiImportati' non valida (" + statoAccordo + "), valori possibili sono: " + StatiAccordo.bozza.toString() + "," + StatiAccordo.operativo.toString() + "," + StatiAccordo.finale.toString();
            System.err.println(errorMsg);
            throw new Exception(errorMsg);
        }
        StatiAccordo statoAccordoObject = StatiAccordo.valueOf(statoAccordo);
        String protocolloDefault = args_protocolloDefault;
        boolean reset = Boolean.parseBoolean(args_reset);
        boolean gestioneSoggetti = Boolean.parseBoolean(args_gestioneSoggetti);
        boolean mantieniFruitori = Boolean.parseBoolean(args_mantieniFruitori);
        boolean deleteMappingErogazioneFruizione = Boolean.parseBoolean(argsdeleteEngineMappingErogazioneFruizione);
        Properties reader = new Properties();
        try (FileInputStream fin = new FileInputStream(args_proprietaRegistroCRUD);){
            reader.load(fin);
        }
        catch (IOException e) {
            String errorMsg = "Errore durante il caricamento del file di properties [" + args_proprietaRegistroCRUD + "] : " + e.getMessage();
            log.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        AccessoRegistroRegistro acCRUD = new AccessoRegistroRegistro();
        String superUser = null;
        boolean connectionDB = false;
        String connection = null;
        String username = null;
        String password = null;
        String driver = null;
        String tipoDatabase = null;
        try {
            acCRUD.setTipo(RegistroTipo.toEnumConstant(args_tipoRegistroCRUD));
            superUser = reader.getProperty("openspcoop2.superuser");
            if (superUser != null) {
                superUser = superUser.trim();
            }
            if ("db".equals(args_tipoRegistroCRUD)) {
                tipoDatabase = reader.getProperty("openspcoop2.registroServizi.db.tipo");
                if (tipoDatabase == null) {
                    throw new Exception("Non e' stato definito il tipo di database");
                }
                tipoDatabase = tipoDatabase.trim();
                String dataSource = reader.getProperty("openspcoop2.registroServizi.db.dataSource");
                if (dataSource != null) {
                    dataSource = dataSource.trim();
                    Properties context = Utilities.readProperties((String)"openspcoop2.registroServizi.db.context.", (Properties)reader);
                    acCRUD.setLocation(dataSource);
                    acCRUD.setTipoDatabase(tipoDatabase);
                    Enumeration<Object> keys = context.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        String value = context.getProperty(key);
                        acCRUD.putGenericProperties(key, value);
                    }
                } else {
                    connectionDB = true;
                    connection = reader.getProperty("openspcoop2.registroServizi.db.url");
                    if (connection == null) {
                        throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                    }
                    connection = connection.trim();
                    driver = reader.getProperty("openspcoop2.registroServizi.db.driver");
                    if (driver == null) {
                        throw new Exception("Connessione diretta: non e' stato definito il Driver");
                    }
                    driver = driver.trim();
                    username = reader.getProperty("openspcoop2.registroServizi.db.user");
                    password = reader.getProperty("openspcoop2.registroServizi.db.password");
                    if (username != null) {
                        username = username.trim();
                    }
                    if (password != null) {
                        password = password.trim();
                    }
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la lettura del file di properties [" + args_proprietaRegistroCRUD + "] : " + e.getMessage();
            log.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        Connection connectionSQL = null;
        try {
            File fSorgente = new File(args_sorgenteXML);
            if (connectionDB) {
                Loader.getInstance().newInstance(driver);
                connectionSQL = username != null && password != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
            }
            XMLDataConverterMainProcessor.letturaSorgenti(fSorgente, connectionDB, connectionSQL, tipoDatabase, log, superUser, acCRUD, statoAccordoObject, protocolloDefault, args_tipoConversione, args_nomePddOperativa, gestioneSoggetti, reset, mantieniFruitori, deleteMappingErogazioneFruizione);
        }
        catch (Exception e) {
            String errorMsg = "Errore durante la conversione XML dei dati: " + e.getMessage();
            log.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        finally {
            try {
                if (connectionSQL != null) {
                    connectionSQL.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private static boolean reset(boolean b) {
        if (b) {
            SemaphoreLock lock = semaphoreResetEffettuata.acquireThrowRuntime("reset");
            try {
                if (!resetEffettuata.booleanValue()) {
                    resetEffettuata = true;
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                semaphoreResetEffettuata.release(lock, "reset");
            }
        }
        return false;
    }

    private static void letturaSorgenti(File fSorgente, boolean connectionDB, Connection connectionSQL, String tipoDatabase, Logger log, String superUser, AccessoRegistroRegistro acCRUD, StatiAccordo statoAccordoObject, String protocolloDefault, String tipoConversione, String nomePddOperativa, boolean gestioneSoggetti, boolean reset, boolean mantieniFruitori, boolean deleteMappingErogazioneFruizione) throws Exception {
        if (fSorgente.isFile()) {
            if (!fSorgente.canRead()) {
                throw new Exception("Sorgente XML [" + fSorgente.getAbsolutePath() + "] non accessibile in lettura");
            }
            if (fSorgente.getName().endsWith(".xml")) {
                XMLDataConverterMainProcessor.converti(fSorgente, connectionDB, connectionSQL, tipoDatabase, log, superUser, acCRUD, statoAccordoObject, protocolloDefault, tipoConversione, nomePddOperativa, gestioneSoggetti, reset, mantieniFruitori, deleteMappingErogazioneFruizione);
            } else {
                log.debug("File [" + fSorgente.getAbsolutePath() + "] ignorato. Non possiede l'estensione .xml");
            }
        } else if (fSorgente.isDirectory()) {
            if (!fSorgente.canRead()) {
                throw new Exception("Directory contenente gli XML [" + fSorgente.getAbsolutePath() + "] non accessibile in lettura");
            }
            File[] f = fSorgente.listFiles();
            if (f == null || f.length <= 0) {
                throw new Exception("Directory [" + fSorgente.getAbsolutePath() + "] non contiene XML");
            }
            for (int i = 0; i < f.length; ++i) {
                XMLDataConverterMainProcessor.letturaSorgenti(f[i], connectionDB, connectionSQL, tipoDatabase, log, superUser, acCRUD, statoAccordoObject, protocolloDefault, tipoConversione, nomePddOperativa, gestioneSoggetti, reset, mantieniFruitori, deleteMappingErogazioneFruizione);
            }
        }
    }

    private static void converti(File f, boolean connectionDB, Connection connectionSQL, String tipoDatabase, Logger log, String superUser, AccessoRegistroRegistro acCRUD, StatiAccordo statoAccordoObject, String protocolloDefault, String tipoConversione, String nomePddOperativa, boolean gestioneSoggetti, boolean reset, boolean mantieniFruitori, boolean deleteMappingErogazioneFruizione) throws Exception {
        Logger logDriver = null;
        XMLDataConverter dataConverter = null;
        dataConverter = connectionDB ? new XMLDataConverter(f.getAbsolutePath(), connectionSQL, tipoDatabase, superUser, protocolloDefault, log, logDriver) : new XMLDataConverter(f.getAbsolutePath(), acCRUD, superUser, protocolloDefault, log, logDriver);
        if ("insertUpdate".equals(tipoConversione)) {
            log.info("Inizio conversione...");
            if (nomePddOperativa != null) {
                PdDConfig pddConfig = new PdDConfig();
                String pddOperativa = nomePddOperativa;
                pddConfig.setPddOperativaCtrlstatSinglePdd(pddOperativa);
                dataConverter.convertXML(XMLDataConverterMainProcessor.reset(reset), pddConfig, mantieniFruitori, gestioneSoggetti, statoAccordoObject);
            } else {
                dataConverter.convertXML(XMLDataConverterMainProcessor.reset(reset), mantieniFruitori, gestioneSoggetti, statoAccordoObject);
            }
            log.info("Conversione terminata.");
        } else if ("delete".equals(tipoConversione)) {
            log.info("Inizio conversione...");
            dataConverter.delete(gestioneSoggetti, deleteMappingErogazioneFruizione);
            log.info("Conversione terminata.");
        } else {
            throw new Exception("Valore opzione 'tipoConversioneRegistroServizi' non gestito (valori possibili insertUpdate/delete): " + tipoConversione);
        }
    }
}

