/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.openspcoop2.core.registry.RegistroServizi;
import org.openspcoop2.core.registry.driver.ValidazioneSemantica;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.xml.DriverRegistroServiziXML;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.resources.FileSystemUtilities;
import org.openspcoop2.utils.resources.Loader;
import org.slf4j.Logger;

public class ValidazioneSemanticaMainProcessor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) throws Exception {
        if (args.length < 4) {
            String errorMsg = "ERROR, Usage:  java ValidazioneSemanticaMainProcessor commonProperties tipoRegistro proprietaRegistro checkURI";
            System.err.println(errorMsg);
            throw new Exception(errorMsg);
        }
        try {
            if (args.length == 5) {
                LoggerWrapperFactory.setLogConfiguration((String)args[4]);
            } else {
                URL url = ValidazioneSemanticaMainProcessor.class.getResource("/validator.log4j2.properties");
                if (url != null) {
                    LoggerWrapperFactory.setLogConfiguration((URL)url);
                } else {
                    File logFile = FileSystemUtilities.createTempFile((String)"testValidazioneSemanticaRegistro_", (String)".log");
                    System.out.println("LogMessages write in " + logFile.getAbsolutePath());
                    LoggerWrapperFactory.setDefaultLogConfiguration((Level)Level.ALL, (boolean)false, null, (File)logFile, (String)"%p <%d{dd-MM-yyyy HH:mm:ss}> %C.%M(%L): %m %n %n");
                }
            }
        }
        catch (Exception e) {
            String errorMsg = "Errore durante il caricamento del file di log args4[" + args[4] + "] : " + e.getMessage();
            System.err.println(errorMsg);
            System.out.println("Args.length: " + args.length);
            for (int i = 0; i < args.length; ++i) {
                System.out.println("Arg[" + i + "]=[" + args[i] + "]");
            }
            throw new Exception(errorMsg, e);
        }
        Logger log = LoggerWrapperFactory.getLogger((String)"validatoreDatiRegistro");
        Properties commonProperties = new Properties();
        try (FileInputStream fin = new FileInputStream(args[0]);){
            commonProperties.load(fin);
        }
        catch (IOException e) {
            String errorMsg = "Errore durante il caricamento del file di properties [" + args[0] + "] : " + e.getMessage();
            log.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        Properties reader = new Properties();
        try (FileInputStream fin = new FileInputStream(args[2]);){
            reader.load(fin);
        }
        catch (IOException e) {
            String errorMsg = "Errore durante il caricamento del file di properties [" + args[2] + "] : " + e.getMessage();
            log.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg, e);
        }
        RegistroServizi registro = null;
        Connection connectionDB = null;
        String tipoRegistro = args[1];
        boolean checkURI = Boolean.parseBoolean(args[3]);
        if ("xml".equals(tipoRegistro)) {
            String path = reader.getProperty("openspcoop2.registroServizi.xml");
            if (path == null) {
                throw new Exception("Non e' stato definito il path dove localizzare il registro servizi xml");
            }
            path = path.trim();
            DriverRegistroServiziXML driver = new DriverRegistroServiziXML(path, log);
            if (!driver.create) {
                throw new Exception("RegistroServizi XML non inizializzato");
            }
            log.info("Inizializzato Registro dei Servizi XML");
            registro = driver.getImmagineCompletaRegistroServizi();
        } else {
            if (!"db".equals(tipoRegistro)) throw new Exception("Tipo di registro servizi [" + tipoRegistro + "] non gestito");
            String tipoDatabase = reader.getProperty("openspcoop2.registroServizi.db.tipo");
            if (tipoDatabase == null) {
                throw new Exception("Non e' stato definito il tipo di database");
            }
            tipoDatabase = tipoDatabase.trim();
            String dataSource = reader.getProperty("openspcoop2.registroServizi.db.dataSource");
            if (dataSource != null) {
                dataSource = dataSource.trim();
                Properties context = Utilities.readProperties((String)"openspcoop2.registroServizi.db.context.", (Properties)reader);
                DriverRegistroServiziDB driver = new DriverRegistroServiziDB(dataSource, context, log, tipoDatabase);
                if (!driver.create) {
                    throw new Exception("RegistroServizi DB non inizializzato");
                }
                log.info("Inizializzato Registro dei Servizi DB");
                registro = driver.getImmagineCompletaRegistroServizi();
            } else {
                String connection = reader.getProperty("openspcoop2.registroServizi.db.url");
                if (connection == null) {
                    throw new Exception("Non e' stata definita una destinazione ne attraverso un datasource, ne attraverso una connessione diretta");
                }
                connection = connection.trim();
                String driverJDBC = reader.getProperty("openspcoop2.registroServizi.db.driver");
                if (driverJDBC == null) {
                    throw new Exception("Connessione diretta: non e' stato definito il Driver");
                }
                driverJDBC = driverJDBC.trim();
                String username = reader.getProperty("openspcoop2.registroServizi.db.user");
                String password = reader.getProperty("openspcoop2.registroServizi.db.password");
                if (username != null) {
                    username = username.trim();
                }
                if (password != null) {
                    password = password.trim();
                }
                Loader.getInstance().newInstance(driverJDBC);
                try {
                    connectionDB = username != null ? DriverManager.getConnection(connection, username, password) : DriverManager.getConnection(connection);
                    DriverRegistroServiziDB driver = new DriverRegistroServiziDB(connectionDB, log, tipoDatabase);
                    if (!driver.create) {
                        throw new Exception("RegistroServizi DB non inizializzato");
                    }
                    log.info("Inizializzato Registro dei Servizi DB");
                    registro = driver.getImmagineCompletaRegistroServizi();
                }
                finally {
                    try {
                        JDBCUtilities.closeConnection((Logger)DriverRegistroServiziDB.getCheckLogger(), (Connection)connectionDB, (boolean)DriverRegistroServiziDB.isCheckAutocommit(), (boolean)DriverRegistroServiziDB.isCheckIsClosed());
                    }
                    catch (Exception driver) {}
                }
            }
        }
        try {
            String tipiConnettori = commonProperties.getProperty("openspcoop2.tipiConnettori");
            if (tipiConnettori == null) {
                throw new Exception("Non sono stati definiti i tipi di connettori supportati");
            }
            tipiConnettori = tipiConnettori.trim();
            String[] tipoConnettoriArray = tipiConnettori.split(",");
            for (int i = 0; i < tipoConnettoriArray.length; ++i) {
                tipoConnettoriArray[i] = tipoConnettoriArray[i].trim();
            }
            String tipiSoggetti = commonProperties.getProperty("openspcoop2.tipiSoggetti");
            if (tipiSoggetti == null) {
                throw new Exception("Non sono stati definiti i tipi di soggetti supportati");
            }
            tipiSoggetti = tipiSoggetti.trim();
            String[] tipoSoggettiArray = tipiSoggetti.split(",");
            for (int i = 0; i < tipoSoggettiArray.length; ++i) {
                tipoSoggettiArray[i] = tipoSoggettiArray[i].trim();
            }
            String tipiServiziSoap = commonProperties.getProperty("openspcoop2.tipiServizi.soap");
            if (tipiServiziSoap == null) {
                throw new Exception("Non sono stati definiti i tipi di Servizi supportati");
            }
            tipiServiziSoap = tipiServiziSoap.trim();
            String[] tipoServiziArraySoap = tipiServiziSoap.split(",");
            for (int i = 0; i < tipoServiziArraySoap.length; ++i) {
                tipoServiziArraySoap[i] = tipoServiziArraySoap[i].trim();
            }
            String tipiServiziRest = commonProperties.getProperty("openspcoop2.tipiServizi.rest");
            if (tipiServiziRest == null) {
                throw new Exception("Non sono stati definiti i tipi di Servizi supportati");
            }
            tipiServiziRest = tipiServiziRest.trim();
            String[] tipoServiziArrayRest = tipiServiziRest.split(",");
            for (int i = 0; i < tipoServiziArrayRest.length; ++i) {
                tipoServiziArrayRest[i] = tipoServiziArrayRest[i].trim();
            }
            ValidazioneSemantica validatore = new ValidazioneSemantica(registro, checkURI, tipoConnettoriArray, tipoSoggettiArray, tipoServiziArraySoap, tipoServiziArrayRest, log);
            validatore.validazioneSemantica(true);
            return;
        }
        catch (Exception e) {
            log.error("Errore: " + e.getMessage());
            throw e;
        }
    }
}

