/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.registry.AccordoServizioParteSpecifica;
import org.openspcoop2.core.registry.Fruitore;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.Soggetto;
import org.openspcoop2.core.registry.constants.CostantiRegistroServizi;
import org.openspcoop2.core.registry.constants.CredenzialeTipo;
import org.openspcoop2.core.registry.constants.PddTipologia;
import org.openspcoop2.core.registry.constants.StatiAccordo;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziException;
import org.openspcoop2.core.registry.driver.DriverRegistroServiziNotFound;
import org.openspcoop2.core.registry.driver.ValidazioneStatoPackageException;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB;
import org.openspcoop2.core.registry.driver.db.DriverRegistroServiziDB_LIB;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverRegistroServiziDB_accordiParteSpecificaFruitoreDriver {
    private DriverRegistroServiziDB driver = null;

    protected DriverRegistroServiziDB_accordiParteSpecificaFruitoreDriver(DriverRegistroServiziDB driver) {
        this.driver = driver;
    }

    protected long getServizioFruitore(IDServizio idServizio, long idSogg) throws DriverRegistroServiziException {
        Connection connection;
        long idFru = 0L;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("getServizioFruitore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioWithSoggettoAccordoServCorr] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            long idServ = 0L;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi.id");
            sqlQueryObject.addWhereCondition("servizi.nome_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi.tipo_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi.versione_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
            sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setString(1, idServizio.getNome());
            stm.setString(2, idServizio.getTipo());
            stm.setInt(3, idServizio.getVersione());
            stm.setString(4, idServizio.getSoggettoErogatore().getNome());
            stm.setString(5, idServizio.getSoggettoErogatore().getTipo());
            rs = stm.executeQuery();
            if (rs.next()) {
                idServ = rs.getLong("id");
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idServ);
            stm.setLong(2, idSogg);
            rs = stm.executeQuery();
            if (rs.next()) {
                idFru = rs.getLong("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return idFru;
    }

    protected long getServizioFruitoreSoggettoFruitoreID(long idServizioFruitore) throws DriverRegistroServiziException {
        Connection connection;
        long idSoggFru = 0L;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("getServizioFruitoreSoggettoFruitoreID");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioFruitoreSoggettoFruitoreID] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idServizioFruitore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idSoggFru = rs.getLong("id_soggetto");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return idSoggFru;
    }

    protected long getServizioFruitoreServizioID(long idServizioFruitore) throws DriverRegistroServiziException {
        Connection connection;
        long idServ = 0L;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("getServizioFruitoreServizioID");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getServizioFruitoreServizioID] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("id_servizio");
            sqlQueryObject.addWhereCondition("id = ?");
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idServizioFruitore);
            rs = stm.executeQuery();
            if (rs.next()) {
                idServ = rs.getLong("id_servizio");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return idServ;
    }

    protected boolean existFruizioniServiziSoggettoWithoutConnettore(long idSoggetto, boolean escludiSoggettiEsterni) throws DriverRegistroServiziException {
        boolean bl;
        if (idSoggetto <= 0L) {
            throw new DriverRegistroServiziException("idSoggetto non valido.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean trovatoServ = false;
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("existFruizioniWithoutConnettore");
                }
                catch (Exception e) {
                    throw new DriverRegistroServiziException("Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("pdd");
            }
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("connettori", "cservizio");
            sqlQueryObject.addFromTable("connettori", "cfruizione");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addWhereCondition("servizi.id_soggetto = ?");
            sqlQueryObject.addWhereCondition("servizi.id_connettore = cservizio.id");
            sqlQueryObject.addWhereCondition("cservizio.endpointtype = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereIsNotNullCondition("soggetti.server");
                sqlQueryObject.addWhereCondition("soggetti.server = pdd.nome");
                sqlQueryObject.addWhereCondition(false, new String[]{"pdd.tipo = ?", "pdd.tipo = ?"});
            }
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_connettore = cfruizione.id");
            sqlQueryObject.addWhereCondition("cfruizione.endpointtype = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            stm.setLong(index++, idSoggetto);
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.DISABILITATO));
            if (escludiSoggettiEsterni) {
                stm.setString(index++, PddTipologia.OPERATIVO.toString());
                stm.setString(index++, PddTipologia.NONOPERATIVO.toString());
            }
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.DISABILITATO));
            rs = stm.executeQuery();
            if (rs.next()) {
                trovatoServ = true;
            }
            bl = trovatoServ;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("Errore durante existFruizioniWithoutConnettore: " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return bl;
    }

    protected boolean existFruizioniServizioWithoutConnettore(long idServizio, boolean escludiSoggettiEsterni) throws DriverRegistroServiziException {
        boolean bl;
        if (idServizio <= 0L) {
            throw new DriverRegistroServiziException("idServizio non valido.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        boolean trovatoServ = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("existFruizioniServizioWithoutConnettore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("pdd");
            }
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("servizi");
            sqlQueryObject.addFromTable("connettori", "cfruizione");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addWhereCondition("servizi.id = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = servizi.id");
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereIsNotNullCondition("soggetti.server");
                sqlQueryObject.addWhereCondition("soggetti.server = pdd.nome");
                sqlQueryObject.addWhereCondition(false, new String[]{"pdd.tipo = ?", "pdd.tipo = ?"});
            }
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_connettore = cfruizione.id");
            sqlQueryObject.addWhereCondition("cfruizione.endpointtype = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            stm.setLong(index++, idServizio);
            if (escludiSoggettiEsterni) {
                stm.setString(index++, PddTipologia.OPERATIVO.toString());
                stm.setString(index++, PddTipologia.NONOPERATIVO.toString());
            }
            stm.setString(index++, DriverRegistroServiziDB_LIB.getValue(CostantiRegistroServizi.DISABILITATO));
            rs = stm.executeQuery();
            if (rs.next()) {
                trovatoServ = true;
            }
            bl = trovatoServ;
        }
        catch (Exception qe) {
            try {
                throw new DriverRegistroServiziException("Errore durante existFruizioniServizioWithoutConnettore: " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return bl;
    }

    protected List<AccordoServizioParteSpecifica> servizioWithSoggettoFruitore(IDSoggetto idSoggetto) throws DriverRegistroServiziException {
        String nomeMetodo = "servizioWithSoggettoFruitore";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> idServizi = new ArrayList<AccordoServizioParteSpecifica>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("servizioWithSoggettoFruitore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObjectSoggetti = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectSoggetti.addFromTable("soggetti");
            sqlQueryObjectSoggetti.addFromTable("servizi_fruitori");
            sqlQueryObjectSoggetti.addFromTable("servizi");
            sqlQueryObjectSoggetti.setSelectDistinct(true);
            sqlQueryObjectSoggetti.addSelectAliasField("servizi", "id", "idServizio");
            sqlQueryObjectSoggetti.addWhereCondition("servizi_fruitori.id_servizio=servizi.id");
            sqlQueryObjectSoggetti.addWhereCondition("servizi_fruitori.id_soggetto=soggetti.id");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.tipo_soggetto=?");
            sqlQueryObjectSoggetti.addWhereCondition("soggetti.nome_soggetto=?");
            sqlQueryObjectSoggetti.setANDLogicOperator(true);
            String queryString = sqlQueryObjectSoggetti.createSQLQuery();
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(queryString, new Object[0]));
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, idSoggetto.getTipo());
            stmt.setString(2, idSoggetto.getNome());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                long idServizioLong = risultato.getLong("idServizio");
                AccordoServizioParteSpecifica serv = this.driver.getAccordoServizioParteSpecifica(idServizioLong);
                Soggetto s = this.driver.getSoggetto(serv.getIdSoggetto());
                serv.setTipoSoggettoErogatore(s.getTipo());
                serv.setNomeSoggettoErogatore(s.getNome());
                idServizi.add(serv);
            }
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return idServizi;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Fruitore getAccordoErogatoreFruitore(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Fruitore fruitore;
        this.driver.logDebug("richiesto getAccordoErogatoreFruitore: " + id);
        if (id <= 0L) {
            return null;
        }
        Fruitore fruitore2 = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAccordoErogatoreFruitore") : this.driver.globalConnection;
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            fruitore2 = new Fruitore();
            fruitore2.setId(id);
            fruitore2.setTipo(rs.getString("soggetti.tipo_soggetto"));
            fruitore2.setNome(rs.getString("soggetti.nome_soggetto"));
            long idConnettore = rs.getLong("soggettiid_connettore");
            fruitore2.setConnettore(this.driver.getConnettore(idConnettore, con));
            fruitore = fruitore2;
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] SQLException :" + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getAccordoErogatoreFruitore] Exception :" + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return fruitore;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Fruitore getErogatoreFruitore(long id) throws DriverRegistroServiziException, DriverRegistroServiziNotFound {
        Fruitore fruitore;
        this.driver.logDebug("richiesto getErogatoreFruitore: " + id);
        if (id <= 0L) {
            return null;
        }
        Fruitore fruitore2 = null;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.id_connettore");
            sqlQueryObject.addSelectField("servizi_fruitori.stato");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getErogatoreFruitore") : this.driver.globalConnection;
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, id);
            this.driver.logDebug("eseguo query : " + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            rs = stm.executeQuery();
            if (!rs.next()) {
                throw new DriverRegistroServiziNotFound("[DriverRegistroServiziDB::getErogatoreFruitore] rs.next non ha restituito valori con la seguente interrogazione :\n" + DriverRegistroServiziDB_LIB.formatSQLString(sqlQuery, id));
            }
            fruitore2 = new Fruitore();
            fruitore2.setId(id);
            fruitore2.setTipo(rs.getString("tipo_soggetto"));
            fruitore2.setNome(rs.getString("nome_soggetto"));
            fruitore2.setStatoPackage(rs.getString("stato"));
            long idConnettore = rs.getLong("id_connettore");
            fruitore2.setConnettore(this.driver.getConnettore(idConnettore, con));
            fruitore = fruitore2;
        }
        catch (SQLException se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getErogatoreFruitore] SQLException :" + se.getMessage(), se);
                catch (DriverRegistroServiziNotFound e) {
                    throw e;
                }
                catch (Exception se2) {
                    throw new DriverRegistroServiziException("[DriverRegistroServiziDB::getErogatoreFruitore] Exception :" + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return fruitore;
    }

    protected Fruitore getServizioFruitore(long idServFru) throws DriverRegistroServiziException {
        Fruitore fruitore;
        String nomeMetodo = "getServizioFruitore";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getServizioFruitore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
            sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
            sqlQueryObject.addSelectField("servizi_fruitori.id_connettore");
            sqlQueryObject.addSelectField("servizi_fruitori.wsdl_implementativo_erogatore");
            sqlQueryObject.addSelectField("servizi_fruitori.wsdl_implementativo_fruitore");
            sqlQueryObject.addSelectField("servizi_fruitori.stato");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id = ?");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServFru);
            risultato = stmt.executeQuery();
            Fruitore f = null;
            if (risultato.next()) {
                f = new Fruitore();
                f.setId(risultato.getLong("id"));
                f.setIdSoggetto(risultato.getLong("id_soggetto"));
                f.setIdServizio(risultato.getLong("id_servizio"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                long idConnettore = risultato.getLong("id_connettore");
                f.setConnettore(this.driver.getConnettore(idConnettore, con));
                f.setByteWsdlImplementativoErogatore(risultato.getString("wsdl_implementativo_erogatore") != null && !risultato.getString("wsdl_implementativo_erogatore").trim().equals("") ? risultato.getString("wsdl_implementativo_erogatore").trim().getBytes() : null);
                f.setByteWsdlImplementativoFruitore(risultato.getString("wsdl_implementativo_fruitore") != null && !risultato.getString("wsdl_implementativo_fruitore").trim().equals("") ? risultato.getString("wsdl_implementativo_fruitore").trim().getBytes() : null);
                f.setStatoPackage(risultato.getString("stato"));
                try {
                    List<ProtocolProperty> listPP = DriverRegistroServiziDB_LIB.getListaProtocolProperty(f.getId(), ProprietariProtocolProperty.FRUITORE, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
                    if (listPP != null && !listPP.isEmpty()) {
                        for (ProtocolProperty protocolProperty : listPP) {
                            f.addProtocolProperty(protocolProperty);
                        }
                    }
                }
                catch (DriverRegistroServiziNotFound driverRegistroServiziNotFound) {
                    // empty catch block
                }
            }
            fruitore = f;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return fruitore;
    }

    protected List<Fruitore> serviziFruitoriList(long idServizi, ISearch ricerca) throws DriverRegistroServiziException {
        ArrayList<Fruitore> arrayList;
        String nomeMetodo = "serviziFruitoriList";
        int idLista = Liste.SERVIZI_FRUITORI;
        int limit = ricerca.getPageSize(idLista);
        int offset = ricerca.getIndexIniziale(idLista);
        String search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        String filterStatoAccordo = SearchUtils.getFilter(ricerca, idLista, "filtroStatoAccordo");
        this.driver.logDebug("search : " + search);
        this.driver.logDebug("filterStatoAccordo : " + filterStatoAccordo);
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("serviziFruitoriList");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
        try {
            String queryString;
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true)});
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject.addWhereCondition("servizi_fruitori.stato = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectCountField("*", "cont");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject.addWhereCondition("servizi_fruitori.stato = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setLong(index++, idServizi);
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                stmt.setString(index++, filterStatoAccordo);
            }
            if ((risultato = stmt.executeQuery()).next()) {
                ricerca.setNumEntries(idLista, risultato.getInt(1));
            }
            risultato.close();
            stmt.close();
            if (limit == 0) {
                limit = 1000;
            }
            if (!search.equals("")) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "stato", "statoFruitore");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("soggetti.nome_soggetto", search, true, true)});
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject.addWhereCondition("servizi_fruitori.stato = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            } else {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_fruitori");
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "id", "idFruitore");
                sqlQueryObject.addSelectAliasField("servizi_fruitori", "stato", "statoFruitore");
                sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
                sqlQueryObject.addSelectField("soggetti.nome_soggetto");
                sqlQueryObject.addSelectField("servizi_fruitori.id_servizio");
                sqlQueryObject.addSelectField("servizi_fruitori.id_soggetto");
                sqlQueryObject.addSelectField("soggetti.id");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
                sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
                if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                    sqlQueryObject.addWhereCondition("servizi_fruitori.stato = ?");
                }
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
                sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
                sqlQueryObject.setSortType(true);
                sqlQueryObject.setLimit(limit);
                sqlQueryObject.setOffset(offset);
                queryString = sqlQueryObject.createSQLQuery();
            }
            stmt = con.prepareStatement(queryString);
            index = 1;
            stmt.setLong(index++, idServizi);
            if (filterStatoAccordo != null && !filterStatoAccordo.equals("")) {
                stmt.setString(index++, filterStatoAccordo);
            }
            risultato = stmt.executeQuery();
            lista = new ArrayList<Fruitore>();
            while (risultato.next()) {
                Fruitore f = new Fruitore();
                f.setId(risultato.getLong("idFruitore"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                f.setIdSoggetto(risultato.getLong("id_soggetto"));
                f.setIdServizio(risultato.getLong("id_servizio"));
                f.setStatoPackage(risultato.getString("statoFruitore"));
                lista.add(f);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected long getIdServizioFruitore(long idServizio, long idSoggetto) throws DriverRegistroServiziException {
        Connection connection;
        long idFru = 0L;
        PreparedStatement stm = null;
        ResultSet rs = null;
        if (this.driver.atomica) {
            try {
                connection = this.driver.getConnectionFromDatasource("getIdServizioFruitore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("DriverRegistroServiziDB::getIdServizioFruitore] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            connection = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addSelectField("servizi_fruitori.id");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            stm = connection.prepareStatement(sqlQuery);
            stm.setLong(1, idServizio);
            stm.setLong(2, idSoggetto);
            rs = stm.executeQuery();
            if (rs.next()) {
                idFru = rs.getLong("id");
            }
            rs.close();
            stm.close();
        }
        catch (Exception e) {
            try {
                throw new DriverRegistroServiziException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(connection);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(connection);
        return idFru;
    }

    protected List<Fruitore> getServiziFruitoriWithServizio(long idServizio) throws DriverRegistroServiziException {
        ArrayList<Fruitore> arrayList;
        String nomeMetodo = "getServiziFruitoriWithServizio";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getServiziFruitoriWithServizio");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("soggetti.id = servizi_fruitori.id_soggetto");
            sqlQueryObject.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idServizio);
            risultato = stmt.executeQuery();
            lista = new ArrayList<Fruitore>();
            while (risultato.next()) {
                Fruitore f = new Fruitore();
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                lista.add(f);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<AccordoServizioParteSpecifica> getServiziByFruitore(Fruitore fruitore) throws DriverRegistroServiziException {
        ArrayList<AccordoServizioParteSpecifica> arrayList;
        String nomeMetodo = "getServiziByFruitore";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<AccordoServizioParteSpecifica> lista = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getServiziByFruitore");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
        try {
            long idFruitore = DBUtils.getIdSoggetto(fruitore.getNome(), fruitore.getTipo(), con, this.driver.tipoDB);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_fruitori");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idFruitore);
            risultato = stmt.executeQuery();
            lista = new ArrayList<AccordoServizioParteSpecifica>();
            while (risultato.next()) {
                long id = risultato.getLong("id");
                AccordoServizioParteSpecifica se = this.driver.getAccordoServizioParteSpecifica(id, con);
                lista.add(se);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<Fruitore> getSoggettiWithServizioNotFruitori(long idServizio, boolean escludiSoggettiEsterni, CredenzialeTipo credenzialeTipo) throws DriverRegistroServiziException {
        ArrayList<Fruitore> arrayList;
        String nomeMetodo = "getSoggettiWithServizioNotFruitori";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<Fruitore> lista = new ArrayList<Fruitore>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getSoggettiWithServizioNotFruitori");
            }
            catch (Exception e) {
                throw new DriverRegistroServiziException("[DriverRegistroServiziDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObjectWhere = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectWhere.addFromTable("servizi_fruitori");
            sqlQueryObjectWhere.addSelectField("*");
            sqlQueryObjectWhere.addWhereCondition("servizi_fruitori.id_soggetto = soggetti.id");
            sqlQueryObjectWhere.addWhereCondition("servizi_fruitori.id_servizio = ?");
            sqlQueryObjectWhere.setANDLogicOperator(true);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("soggetti");
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addFromTable("pdd");
            }
            sqlQueryObject.addSelectField("soggetti.id");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            if (escludiSoggettiEsterni) {
                sqlQueryObject.addWhereIsNotNullCondition("soggetti.server");
                sqlQueryObject.addWhereCondition("soggetti.server = pdd.nome");
                sqlQueryObject.addWhereCondition(false, new String[]{"pdd.tipo = ?", "pdd.tipo = ?"});
            }
            if (credenzialeTipo != null) {
                sqlQueryObject.addWhereCondition("soggetti.tipoauth = ?");
            }
            sqlQueryObject.addWhereExistsCondition(true, sqlQueryObjectWhere);
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("soggetti.tipo_soggetto");
            sqlQueryObject.addOrderBy("soggetti.nome_soggetto");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (escludiSoggettiEsterni) {
                stmt.setString(index++, PddTipologia.OPERATIVO.toString());
                stmt.setString(index++, PddTipologia.NONOPERATIVO.toString());
            }
            if (credenzialeTipo != null) {
                stmt.setString(index++, credenzialeTipo.getValue());
            }
            stmt.setLong(index++, idServizio);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Fruitore f = new Fruitore();
                f.setId(risultato.getLong("id"));
                f.setNome(risultato.getString("nome_soggetto"));
                f.setTipo(risultato.getString("tipo_soggetto"));
                lista.add(f);
            }
            arrayList = lista;
        }
        catch (Exception se) {
            try {
                throw new DriverRegistroServiziException("[DriverControlStationDB::" + nomeMetodo + "] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected void validaStatoFruitoreServizio(Fruitore fruitore, AccordoServizioParteSpecifica serv) throws ValidazioneStatoPackageException {
        ValidazioneStatoPackageException erroreValidazione = new ValidazioneStatoPackageException("FruitoreServizio", fruitore.getStatoPackage(), null);
        try {
            if (!StatiAccordo.bozza.toString().equals(fruitore.getStatoPackage())) {
                String uriAPS = this.driver.idServizioFactory.getUriFromAccordo(serv);
                if (StatiAccordo.operativo.toString().equals(fruitore.getStatoPackage())) {
                    if (!StatiAccordo.finale.toString().equals(serv.getStatoPackage()) && !StatiAccordo.operativo.toString().equals(serv.getStatoPackage())) {
                        erroreValidazione.addErroreValidazione("servizio riferito [" + uriAPS + "] possiede lo stato [" + serv.getStatoPackage() + "]");
                    }
                } else if (StatiAccordo.finale.toString().equals(fruitore.getStatoPackage()) && !StatiAccordo.finale.toString().equals(serv.getStatoPackage())) {
                    erroreValidazione.addErroreValidazione("servizio [" + uriAPS + "] in uno stato non finale [" + serv.getStatoPackage() + "]");
                }
            }
        }
        catch (Exception e) {
            throw new ValidazioneStatoPackageException(e);
        }
        if (erroreValidazione.sizeErroriValidazione() > 0) {
            throw erroreValidazione;
        }
    }
}

