/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.registry;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.openspcoop2.core.registry.ProtocolProperty;
import org.openspcoop2.core.registry.ResourceRequest;
import org.openspcoop2.core.registry.ResourceResponse;
import org.openspcoop2.core.registry.constants.HttpMethod;
import org.openspcoop2.core.registry.constants.MessageType;
import org.openspcoop2.core.registry.constants.StatoFunzionalita;
import org.openspcoop2.utils.beans.BaseBeanWithId;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="resource", propOrder={"request", "response", "protocolProperty"})
@XmlRootElement(name="resource")
public class Resource
extends BaseBeanWithId
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="request", required=false, nillable=false)
    protected ResourceRequest request;
    @XmlElement(name="response", required=true, nillable=false)
    private List<ResourceResponse> response = new ArrayList<ResourceResponse>();
    @XmlElement(name="protocol-property", required=true, nillable=false)
    private List<ProtocolProperty> protocolProperty = new ArrayList<ProtocolProperty>();
    @XmlSchemaType(name="string")
    @XmlAttribute(name="prof-azione", required=false)
    protected String profAzione;
    @XmlTransient
    protected Long idAccordo;
    @XmlSchemaType(name="string")
    @XmlAttribute(name="nome", required=true)
    protected String nome;
    @XmlSchemaType(name="string")
    @XmlAttribute(name="descrizione", required=false)
    protected String descrizione;
    @XmlSchemaType(name="string")
    @XmlAttribute(name="path", required=false)
    protected String path;
    @XmlTransient
    protected String methodRawEnumValue;
    @XmlAttribute(name="method", required=false)
    protected HttpMethod method;
    @XmlTransient
    protected String messageTypeRawEnumValue;
    @XmlAttribute(name="message-type", required=false)
    protected MessageType messageType;
    @XmlTransient
    protected String requestMessageTypeRawEnumValue;
    @XmlAttribute(name="request-message-type", required=false)
    protected MessageType requestMessageType;
    @XmlTransient
    protected String responseMessageTypeRawEnumValue;
    @XmlAttribute(name="response-message-type", required=false)
    protected MessageType responseMessageType;
    @XmlTransient
    protected String filtroDuplicatiRawEnumValue;
    @XmlAttribute(name="filtro-duplicati", required=false)
    protected StatoFunzionalita filtroDuplicati;
    @XmlTransient
    protected String confermaRicezioneRawEnumValue;
    @XmlAttribute(name="conferma-ricezione", required=false)
    protected StatoFunzionalita confermaRicezione;
    @XmlTransient
    protected String idCollaborazioneRawEnumValue;
    @XmlAttribute(name="id-collaborazione", required=false)
    protected StatoFunzionalita idCollaborazione;
    @XmlTransient
    protected String idRiferimentoRichiestaRawEnumValue;
    @XmlAttribute(name="id-riferimento-richiesta", required=false)
    protected StatoFunzionalita idRiferimentoRichiesta;
    @XmlTransient
    protected String consegnaInOrdineRawEnumValue;
    @XmlAttribute(name="consegna-in-ordine", required=false)
    protected StatoFunzionalita consegnaInOrdine;
    @XmlSchemaType(name="string")
    @XmlAttribute(name="scadenza", required=false)
    protected String scadenza;

    public ResourceRequest getRequest() {
        return this.request;
    }

    public void setRequest(ResourceRequest request) {
        this.request = request;
    }

    public void addResponse(ResourceResponse response) {
        this.response.add(response);
    }

    public ResourceResponse getResponse(int index) {
        return this.response.get(index);
    }

    public ResourceResponse removeResponse(int index) {
        return this.response.remove(index);
    }

    public List<ResourceResponse> getResponseList() {
        return this.response;
    }

    public void setResponseList(List<ResourceResponse> response) {
        this.response = response;
    }

    public int sizeResponseList() {
        return this.response.size();
    }

    public void addProtocolProperty(ProtocolProperty protocolProperty) {
        this.protocolProperty.add(protocolProperty);
    }

    public ProtocolProperty getProtocolProperty(int index) {
        return this.protocolProperty.get(index);
    }

    public ProtocolProperty removeProtocolProperty(int index) {
        return this.protocolProperty.remove(index);
    }

    public List<ProtocolProperty> getProtocolPropertyList() {
        return this.protocolProperty;
    }

    public void setProtocolPropertyList(List<ProtocolProperty> protocolProperty) {
        this.protocolProperty = protocolProperty;
    }

    public int sizeProtocolPropertyList() {
        return this.protocolProperty.size();
    }

    public String getProfAzione() {
        return this.profAzione;
    }

    public void setProfAzione(String profAzione) {
        this.profAzione = profAzione;
    }

    public Long getIdAccordo() {
        return this.idAccordo;
    }

    public void setIdAccordo(Long idAccordo) {
        this.idAccordo = idAccordo;
    }

    public String getNome() {
        return this.nome;
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public String getDescrizione() {
        return this.descrizione;
    }

    public void setDescrizione(String descrizione) {
        this.descrizione = descrizione;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethodRawEnumValue(String value) {
        this.method = (HttpMethod)HttpMethod.toEnumConstantFromString(value);
    }

    public String getMethodRawEnumValue() {
        if (this.method == null) {
            return null;
        }
        return this.method.toString();
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public void setMessageTypeRawEnumValue(String value) {
        this.messageType = (MessageType)MessageType.toEnumConstantFromString(value);
    }

    public String getMessageTypeRawEnumValue() {
        if (this.messageType == null) {
            return null;
        }
        return this.messageType.toString();
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public void setRequestMessageTypeRawEnumValue(String value) {
        this.requestMessageType = (MessageType)MessageType.toEnumConstantFromString(value);
    }

    public String getRequestMessageTypeRawEnumValue() {
        if (this.requestMessageType == null) {
            return null;
        }
        return this.requestMessageType.toString();
    }

    public MessageType getRequestMessageType() {
        return this.requestMessageType;
    }

    public void setRequestMessageType(MessageType requestMessageType) {
        this.requestMessageType = requestMessageType;
    }

    public void setResponseMessageTypeRawEnumValue(String value) {
        this.responseMessageType = (MessageType)MessageType.toEnumConstantFromString(value);
    }

    public String getResponseMessageTypeRawEnumValue() {
        if (this.responseMessageType == null) {
            return null;
        }
        return this.responseMessageType.toString();
    }

    public MessageType getResponseMessageType() {
        return this.responseMessageType;
    }

    public void setResponseMessageType(MessageType responseMessageType) {
        this.responseMessageType = responseMessageType;
    }

    public void setFiltroDuplicatiRawEnumValue(String value) {
        this.filtroDuplicati = (StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString(value);
    }

    public String getFiltroDuplicatiRawEnumValue() {
        if (this.filtroDuplicati == null) {
            return null;
        }
        return this.filtroDuplicati.toString();
    }

    public StatoFunzionalita getFiltroDuplicati() {
        return this.filtroDuplicati;
    }

    public void setFiltroDuplicati(StatoFunzionalita filtroDuplicati) {
        this.filtroDuplicati = filtroDuplicati;
    }

    public void setConfermaRicezioneRawEnumValue(String value) {
        this.confermaRicezione = (StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString(value);
    }

    public String getConfermaRicezioneRawEnumValue() {
        if (this.confermaRicezione == null) {
            return null;
        }
        return this.confermaRicezione.toString();
    }

    public StatoFunzionalita getConfermaRicezione() {
        return this.confermaRicezione;
    }

    public void setConfermaRicezione(StatoFunzionalita confermaRicezione) {
        this.confermaRicezione = confermaRicezione;
    }

    public void setIdCollaborazioneRawEnumValue(String value) {
        this.idCollaborazione = (StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString(value);
    }

    public String getIdCollaborazioneRawEnumValue() {
        if (this.idCollaborazione == null) {
            return null;
        }
        return this.idCollaborazione.toString();
    }

    public StatoFunzionalita getIdCollaborazione() {
        return this.idCollaborazione;
    }

    public void setIdCollaborazione(StatoFunzionalita idCollaborazione) {
        this.idCollaborazione = idCollaborazione;
    }

    public void setIdRiferimentoRichiestaRawEnumValue(String value) {
        this.idRiferimentoRichiesta = (StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString(value);
    }

    public String getIdRiferimentoRichiestaRawEnumValue() {
        if (this.idRiferimentoRichiesta == null) {
            return null;
        }
        return this.idRiferimentoRichiesta.toString();
    }

    public StatoFunzionalita getIdRiferimentoRichiesta() {
        return this.idRiferimentoRichiesta;
    }

    public void setIdRiferimentoRichiesta(StatoFunzionalita idRiferimentoRichiesta) {
        this.idRiferimentoRichiesta = idRiferimentoRichiesta;
    }

    public void setConsegnaInOrdineRawEnumValue(String value) {
        this.consegnaInOrdine = (StatoFunzionalita)StatoFunzionalita.toEnumConstantFromString(value);
    }

    public String getConsegnaInOrdineRawEnumValue() {
        if (this.consegnaInOrdine == null) {
            return null;
        }
        return this.consegnaInOrdine.toString();
    }

    public StatoFunzionalita getConsegnaInOrdine() {
        return this.consegnaInOrdine;
    }

    public void setConsegnaInOrdine(StatoFunzionalita consegnaInOrdine) {
        this.consegnaInOrdine = consegnaInOrdine;
    }

    public String getScadenza() {
        return this.scadenza;
    }

    public void setScadenza(String scadenza) {
        this.scadenza = scadenza;
    }

    public List<ResourceResponse> getResponse() {
        return this.getResponseList();
    }

    public void setResponse(List<ResourceResponse> response) {
        this.setResponseList(response);
    }

    public int sizeResponse() {
        return this.sizeResponseList();
    }

    public List<ProtocolProperty> getProtocolProperty() {
        return this.getProtocolPropertyList();
    }

    public void setProtocolProperty(List<ProtocolProperty> protocolProperty) {
        this.setProtocolPropertyList(protocolProperty);
    }

    public int sizeProtocolProperty() {
        return this.sizeProtocolPropertyList();
    }
}

