/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.plugins.utils.serializer;

import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.openspcoop2.core.plugins.ConfigurazioneFiltro;
import org.openspcoop2.core.plugins.ConfigurazioneServizio;
import org.openspcoop2.core.plugins.ConfigurazioneServizioAzione;
import org.openspcoop2.core.plugins.ElencoConfigurazioneFiltro;
import org.openspcoop2.core.plugins.ElencoConfigurazioneServizio;
import org.openspcoop2.core.plugins.ElencoIdConfigurazioneFiltro;
import org.openspcoop2.core.plugins.ElencoIdConfigurazioneServizio;
import org.openspcoop2.core.plugins.ElencoIdPlugin;
import org.openspcoop2.core.plugins.ElencoPlugin;
import org.openspcoop2.core.plugins.IdConfigurazioneFiltro;
import org.openspcoop2.core.plugins.IdConfigurazioneServizio;
import org.openspcoop2.core.plugins.IdConfigurazioneServizioAzione;
import org.openspcoop2.core.plugins.IdPlugin;
import org.openspcoop2.core.plugins.Plugin;
import org.openspcoop2.core.plugins.PluginProprietaCompatibilita;
import org.openspcoop2.core.plugins.PluginServizioAzioneCompatibilita;
import org.openspcoop2.core.plugins.PluginServizioCompatibilita;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, IdConfigurazioneFiltro idConfigurazioneFiltro) throws SerializerException {
        this.objToXml(fileName, IdConfigurazioneFiltro.class, (Object)idConfigurazioneFiltro, false);
    }

    public void write(String fileName, IdConfigurazioneFiltro idConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdConfigurazioneFiltro.class, (Object)idConfigurazioneFiltro, prettyPrint);
    }

    public void write(File file, IdConfigurazioneFiltro idConfigurazioneFiltro) throws SerializerException {
        this.objToXml(file, IdConfigurazioneFiltro.class, (Object)idConfigurazioneFiltro, false);
    }

    public void write(File file, IdConfigurazioneFiltro idConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdConfigurazioneFiltro.class, (Object)idConfigurazioneFiltro, prettyPrint);
    }

    public void write(OutputStream out, IdConfigurazioneFiltro idConfigurazioneFiltro) throws SerializerException {
        this.objToXml(out, IdConfigurazioneFiltro.class, (Object)idConfigurazioneFiltro, false);
    }

    public void write(OutputStream out, IdConfigurazioneFiltro idConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdConfigurazioneFiltro.class, (Object)idConfigurazioneFiltro, prettyPrint);
    }

    public byte[] toByteArray(IdConfigurazioneFiltro idConfigurazioneFiltro) throws SerializerException {
        return this.objToXml(IdConfigurazioneFiltro.class, idConfigurazioneFiltro, false).toByteArray();
    }

    public byte[] toByteArray(IdConfigurazioneFiltro idConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdConfigurazioneFiltro.class, idConfigurazioneFiltro, prettyPrint).toByteArray();
    }

    public String toString(IdConfigurazioneFiltro idConfigurazioneFiltro) throws SerializerException {
        return this.objToXml(IdConfigurazioneFiltro.class, idConfigurazioneFiltro, false).toString();
    }

    public String toString(IdConfigurazioneFiltro idConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdConfigurazioneFiltro.class, idConfigurazioneFiltro, prettyPrint).toString();
    }

    public void write(String fileName, ElencoIdConfigurazioneFiltro elencoIdConfigurazioneFiltro) throws SerializerException {
        this.objToXml(fileName, ElencoIdConfigurazioneFiltro.class, (Object)elencoIdConfigurazioneFiltro, false);
    }

    public void write(String fileName, ElencoIdConfigurazioneFiltro elencoIdConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ElencoIdConfigurazioneFiltro.class, (Object)elencoIdConfigurazioneFiltro, prettyPrint);
    }

    public void write(File file, ElencoIdConfigurazioneFiltro elencoIdConfigurazioneFiltro) throws SerializerException {
        this.objToXml(file, ElencoIdConfigurazioneFiltro.class, (Object)elencoIdConfigurazioneFiltro, false);
    }

    public void write(File file, ElencoIdConfigurazioneFiltro elencoIdConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ElencoIdConfigurazioneFiltro.class, (Object)elencoIdConfigurazioneFiltro, prettyPrint);
    }

    public void write(OutputStream out, ElencoIdConfigurazioneFiltro elencoIdConfigurazioneFiltro) throws SerializerException {
        this.objToXml(out, ElencoIdConfigurazioneFiltro.class, (Object)elencoIdConfigurazioneFiltro, false);
    }

    public void write(OutputStream out, ElencoIdConfigurazioneFiltro elencoIdConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ElencoIdConfigurazioneFiltro.class, (Object)elencoIdConfigurazioneFiltro, prettyPrint);
    }

    public byte[] toByteArray(ElencoIdConfigurazioneFiltro elencoIdConfigurazioneFiltro) throws SerializerException {
        return this.objToXml(ElencoIdConfigurazioneFiltro.class, elencoIdConfigurazioneFiltro, false).toByteArray();
    }

    public byte[] toByteArray(ElencoIdConfigurazioneFiltro elencoIdConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoIdConfigurazioneFiltro.class, elencoIdConfigurazioneFiltro, prettyPrint).toByteArray();
    }

    public String toString(ElencoIdConfigurazioneFiltro elencoIdConfigurazioneFiltro) throws SerializerException {
        return this.objToXml(ElencoIdConfigurazioneFiltro.class, elencoIdConfigurazioneFiltro, false).toString();
    }

    public String toString(ElencoIdConfigurazioneFiltro elencoIdConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoIdConfigurazioneFiltro.class, elencoIdConfigurazioneFiltro, prettyPrint).toString();
    }

    public void write(String fileName, Plugin plugin) throws SerializerException {
        this.objToXml(fileName, Plugin.class, (Object)plugin, false);
    }

    public void write(String fileName, Plugin plugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Plugin.class, (Object)plugin, prettyPrint);
    }

    public void write(File file, Plugin plugin) throws SerializerException {
        this.objToXml(file, Plugin.class, (Object)plugin, false);
    }

    public void write(File file, Plugin plugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Plugin.class, (Object)plugin, prettyPrint);
    }

    public void write(OutputStream out, Plugin plugin) throws SerializerException {
        this.objToXml(out, Plugin.class, (Object)plugin, false);
    }

    public void write(OutputStream out, Plugin plugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Plugin.class, (Object)plugin, prettyPrint);
    }

    public byte[] toByteArray(Plugin plugin) throws SerializerException {
        return this.objToXml(Plugin.class, plugin, false).toByteArray();
    }

    public byte[] toByteArray(Plugin plugin, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Plugin.class, plugin, prettyPrint).toByteArray();
    }

    public String toString(Plugin plugin) throws SerializerException {
        return this.objToXml(Plugin.class, plugin, false).toString();
    }

    public String toString(Plugin plugin, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Plugin.class, plugin, prettyPrint).toString();
    }

    public void write(String fileName, ElencoPlugin elencoPlugin) throws SerializerException {
        this.objToXml(fileName, ElencoPlugin.class, (Object)elencoPlugin, false);
    }

    public void write(String fileName, ElencoPlugin elencoPlugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ElencoPlugin.class, (Object)elencoPlugin, prettyPrint);
    }

    public void write(File file, ElencoPlugin elencoPlugin) throws SerializerException {
        this.objToXml(file, ElencoPlugin.class, (Object)elencoPlugin, false);
    }

    public void write(File file, ElencoPlugin elencoPlugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ElencoPlugin.class, (Object)elencoPlugin, prettyPrint);
    }

    public void write(OutputStream out, ElencoPlugin elencoPlugin) throws SerializerException {
        this.objToXml(out, ElencoPlugin.class, (Object)elencoPlugin, false);
    }

    public void write(OutputStream out, ElencoPlugin elencoPlugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ElencoPlugin.class, (Object)elencoPlugin, prettyPrint);
    }

    public byte[] toByteArray(ElencoPlugin elencoPlugin) throws SerializerException {
        return this.objToXml(ElencoPlugin.class, elencoPlugin, false).toByteArray();
    }

    public byte[] toByteArray(ElencoPlugin elencoPlugin, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoPlugin.class, elencoPlugin, prettyPrint).toByteArray();
    }

    public String toString(ElencoPlugin elencoPlugin) throws SerializerException {
        return this.objToXml(ElencoPlugin.class, elencoPlugin, false).toString();
    }

    public String toString(ElencoPlugin elencoPlugin, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoPlugin.class, elencoPlugin, prettyPrint).toString();
    }

    public void write(String fileName, ConfigurazioneServizioAzione configurazioneServizioAzione) throws SerializerException {
        this.objToXml(fileName, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, false);
    }

    public void write(String fileName, ConfigurazioneServizioAzione configurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, prettyPrint);
    }

    public void write(File file, ConfigurazioneServizioAzione configurazioneServizioAzione) throws SerializerException {
        this.objToXml(file, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, false);
    }

    public void write(File file, ConfigurazioneServizioAzione configurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, prettyPrint);
    }

    public void write(OutputStream out, ConfigurazioneServizioAzione configurazioneServizioAzione) throws SerializerException {
        this.objToXml(out, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, false);
    }

    public void write(OutputStream out, ConfigurazioneServizioAzione configurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ConfigurazioneServizioAzione.class, (Object)configurazioneServizioAzione, prettyPrint);
    }

    public byte[] toByteArray(ConfigurazioneServizioAzione configurazioneServizioAzione) throws SerializerException {
        return this.objToXml(ConfigurazioneServizioAzione.class, configurazioneServizioAzione, false).toByteArray();
    }

    public byte[] toByteArray(ConfigurazioneServizioAzione configurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ConfigurazioneServizioAzione.class, configurazioneServizioAzione, prettyPrint).toByteArray();
    }

    public String toString(ConfigurazioneServizioAzione configurazioneServizioAzione) throws SerializerException {
        return this.objToXml(ConfigurazioneServizioAzione.class, configurazioneServizioAzione, false).toString();
    }

    public String toString(ConfigurazioneServizioAzione configurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ConfigurazioneServizioAzione.class, configurazioneServizioAzione, prettyPrint).toString();
    }

    public void write(String fileName, IdConfigurazioneServizio idConfigurazioneServizio) throws SerializerException {
        this.objToXml(fileName, IdConfigurazioneServizio.class, (Object)idConfigurazioneServizio, false);
    }

    public void write(String fileName, IdConfigurazioneServizio idConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdConfigurazioneServizio.class, (Object)idConfigurazioneServizio, prettyPrint);
    }

    public void write(File file, IdConfigurazioneServizio idConfigurazioneServizio) throws SerializerException {
        this.objToXml(file, IdConfigurazioneServizio.class, (Object)idConfigurazioneServizio, false);
    }

    public void write(File file, IdConfigurazioneServizio idConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdConfigurazioneServizio.class, (Object)idConfigurazioneServizio, prettyPrint);
    }

    public void write(OutputStream out, IdConfigurazioneServizio idConfigurazioneServizio) throws SerializerException {
        this.objToXml(out, IdConfigurazioneServizio.class, (Object)idConfigurazioneServizio, false);
    }

    public void write(OutputStream out, IdConfigurazioneServizio idConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdConfigurazioneServizio.class, (Object)idConfigurazioneServizio, prettyPrint);
    }

    public byte[] toByteArray(IdConfigurazioneServizio idConfigurazioneServizio) throws SerializerException {
        return this.objToXml(IdConfigurazioneServizio.class, idConfigurazioneServizio, false).toByteArray();
    }

    public byte[] toByteArray(IdConfigurazioneServizio idConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdConfigurazioneServizio.class, idConfigurazioneServizio, prettyPrint).toByteArray();
    }

    public String toString(IdConfigurazioneServizio idConfigurazioneServizio) throws SerializerException {
        return this.objToXml(IdConfigurazioneServizio.class, idConfigurazioneServizio, false).toString();
    }

    public String toString(IdConfigurazioneServizio idConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdConfigurazioneServizio.class, idConfigurazioneServizio, prettyPrint).toString();
    }

    public void write(String fileName, ConfigurazioneServizio configurazioneServizio) throws SerializerException {
        this.objToXml(fileName, ConfigurazioneServizio.class, (Object)configurazioneServizio, false);
    }

    public void write(String fileName, ConfigurazioneServizio configurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ConfigurazioneServizio.class, (Object)configurazioneServizio, prettyPrint);
    }

    public void write(File file, ConfigurazioneServizio configurazioneServizio) throws SerializerException {
        this.objToXml(file, ConfigurazioneServizio.class, (Object)configurazioneServizio, false);
    }

    public void write(File file, ConfigurazioneServizio configurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ConfigurazioneServizio.class, (Object)configurazioneServizio, prettyPrint);
    }

    public void write(OutputStream out, ConfigurazioneServizio configurazioneServizio) throws SerializerException {
        this.objToXml(out, ConfigurazioneServizio.class, (Object)configurazioneServizio, false);
    }

    public void write(OutputStream out, ConfigurazioneServizio configurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ConfigurazioneServizio.class, (Object)configurazioneServizio, prettyPrint);
    }

    public byte[] toByteArray(ConfigurazioneServizio configurazioneServizio) throws SerializerException {
        return this.objToXml(ConfigurazioneServizio.class, configurazioneServizio, false).toByteArray();
    }

    public byte[] toByteArray(ConfigurazioneServizio configurazioneServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ConfigurazioneServizio.class, configurazioneServizio, prettyPrint).toByteArray();
    }

    public String toString(ConfigurazioneServizio configurazioneServizio) throws SerializerException {
        return this.objToXml(ConfigurazioneServizio.class, configurazioneServizio, false).toString();
    }

    public String toString(ConfigurazioneServizio configurazioneServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ConfigurazioneServizio.class, configurazioneServizio, prettyPrint).toString();
    }

    public void write(String fileName, IdConfigurazioneServizioAzione idConfigurazioneServizioAzione) throws SerializerException {
        this.objToXml(fileName, IdConfigurazioneServizioAzione.class, (Object)idConfigurazioneServizioAzione, false);
    }

    public void write(String fileName, IdConfigurazioneServizioAzione idConfigurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdConfigurazioneServizioAzione.class, (Object)idConfigurazioneServizioAzione, prettyPrint);
    }

    public void write(File file, IdConfigurazioneServizioAzione idConfigurazioneServizioAzione) throws SerializerException {
        this.objToXml(file, IdConfigurazioneServizioAzione.class, (Object)idConfigurazioneServizioAzione, false);
    }

    public void write(File file, IdConfigurazioneServizioAzione idConfigurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdConfigurazioneServizioAzione.class, (Object)idConfigurazioneServizioAzione, prettyPrint);
    }

    public void write(OutputStream out, IdConfigurazioneServizioAzione idConfigurazioneServizioAzione) throws SerializerException {
        this.objToXml(out, IdConfigurazioneServizioAzione.class, (Object)idConfigurazioneServizioAzione, false);
    }

    public void write(OutputStream out, IdConfigurazioneServizioAzione idConfigurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdConfigurazioneServizioAzione.class, (Object)idConfigurazioneServizioAzione, prettyPrint);
    }

    public byte[] toByteArray(IdConfigurazioneServizioAzione idConfigurazioneServizioAzione) throws SerializerException {
        return this.objToXml(IdConfigurazioneServizioAzione.class, idConfigurazioneServizioAzione, false).toByteArray();
    }

    public byte[] toByteArray(IdConfigurazioneServizioAzione idConfigurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdConfigurazioneServizioAzione.class, idConfigurazioneServizioAzione, prettyPrint).toByteArray();
    }

    public String toString(IdConfigurazioneServizioAzione idConfigurazioneServizioAzione) throws SerializerException {
        return this.objToXml(IdConfigurazioneServizioAzione.class, idConfigurazioneServizioAzione, false).toString();
    }

    public String toString(IdConfigurazioneServizioAzione idConfigurazioneServizioAzione, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdConfigurazioneServizioAzione.class, idConfigurazioneServizioAzione, prettyPrint).toString();
    }

    public void write(String fileName, ConfigurazioneFiltro configurazioneFiltro) throws SerializerException {
        this.objToXml(fileName, ConfigurazioneFiltro.class, (Object)configurazioneFiltro, false);
    }

    public void write(String fileName, ConfigurazioneFiltro configurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ConfigurazioneFiltro.class, (Object)configurazioneFiltro, prettyPrint);
    }

    public void write(File file, ConfigurazioneFiltro configurazioneFiltro) throws SerializerException {
        this.objToXml(file, ConfigurazioneFiltro.class, (Object)configurazioneFiltro, false);
    }

    public void write(File file, ConfigurazioneFiltro configurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ConfigurazioneFiltro.class, (Object)configurazioneFiltro, prettyPrint);
    }

    public void write(OutputStream out, ConfigurazioneFiltro configurazioneFiltro) throws SerializerException {
        this.objToXml(out, ConfigurazioneFiltro.class, (Object)configurazioneFiltro, false);
    }

    public void write(OutputStream out, ConfigurazioneFiltro configurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ConfigurazioneFiltro.class, (Object)configurazioneFiltro, prettyPrint);
    }

    public byte[] toByteArray(ConfigurazioneFiltro configurazioneFiltro) throws SerializerException {
        return this.objToXml(ConfigurazioneFiltro.class, configurazioneFiltro, false).toByteArray();
    }

    public byte[] toByteArray(ConfigurazioneFiltro configurazioneFiltro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ConfigurazioneFiltro.class, configurazioneFiltro, prettyPrint).toByteArray();
    }

    public String toString(ConfigurazioneFiltro configurazioneFiltro) throws SerializerException {
        return this.objToXml(ConfigurazioneFiltro.class, configurazioneFiltro, false).toString();
    }

    public String toString(ConfigurazioneFiltro configurazioneFiltro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ConfigurazioneFiltro.class, configurazioneFiltro, prettyPrint).toString();
    }

    public void write(String fileName, ElencoConfigurazioneFiltro elencoConfigurazioneFiltro) throws SerializerException {
        this.objToXml(fileName, ElencoConfigurazioneFiltro.class, (Object)elencoConfigurazioneFiltro, false);
    }

    public void write(String fileName, ElencoConfigurazioneFiltro elencoConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ElencoConfigurazioneFiltro.class, (Object)elencoConfigurazioneFiltro, prettyPrint);
    }

    public void write(File file, ElencoConfigurazioneFiltro elencoConfigurazioneFiltro) throws SerializerException {
        this.objToXml(file, ElencoConfigurazioneFiltro.class, (Object)elencoConfigurazioneFiltro, false);
    }

    public void write(File file, ElencoConfigurazioneFiltro elencoConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ElencoConfigurazioneFiltro.class, (Object)elencoConfigurazioneFiltro, prettyPrint);
    }

    public void write(OutputStream out, ElencoConfigurazioneFiltro elencoConfigurazioneFiltro) throws SerializerException {
        this.objToXml(out, ElencoConfigurazioneFiltro.class, (Object)elencoConfigurazioneFiltro, false);
    }

    public void write(OutputStream out, ElencoConfigurazioneFiltro elencoConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ElencoConfigurazioneFiltro.class, (Object)elencoConfigurazioneFiltro, prettyPrint);
    }

    public byte[] toByteArray(ElencoConfigurazioneFiltro elencoConfigurazioneFiltro) throws SerializerException {
        return this.objToXml(ElencoConfigurazioneFiltro.class, elencoConfigurazioneFiltro, false).toByteArray();
    }

    public byte[] toByteArray(ElencoConfigurazioneFiltro elencoConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoConfigurazioneFiltro.class, elencoConfigurazioneFiltro, prettyPrint).toByteArray();
    }

    public String toString(ElencoConfigurazioneFiltro elencoConfigurazioneFiltro) throws SerializerException {
        return this.objToXml(ElencoConfigurazioneFiltro.class, elencoConfigurazioneFiltro, false).toString();
    }

    public String toString(ElencoConfigurazioneFiltro elencoConfigurazioneFiltro, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoConfigurazioneFiltro.class, elencoConfigurazioneFiltro, prettyPrint).toString();
    }

    public void write(String fileName, PluginServizioAzioneCompatibilita pluginServizioAzioneCompatibilita) throws SerializerException {
        this.objToXml(fileName, PluginServizioAzioneCompatibilita.class, (Object)pluginServizioAzioneCompatibilita, false);
    }

    public void write(String fileName, PluginServizioAzioneCompatibilita pluginServizioAzioneCompatibilita, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, PluginServizioAzioneCompatibilita.class, (Object)pluginServizioAzioneCompatibilita, prettyPrint);
    }

    public void write(File file, PluginServizioAzioneCompatibilita pluginServizioAzioneCompatibilita) throws SerializerException {
        this.objToXml(file, PluginServizioAzioneCompatibilita.class, (Object)pluginServizioAzioneCompatibilita, false);
    }

    public void write(File file, PluginServizioAzioneCompatibilita pluginServizioAzioneCompatibilita, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, PluginServizioAzioneCompatibilita.class, (Object)pluginServizioAzioneCompatibilita, prettyPrint);
    }

    public void write(OutputStream out, PluginServizioAzioneCompatibilita pluginServizioAzioneCompatibilita) throws SerializerException {
        this.objToXml(out, PluginServizioAzioneCompatibilita.class, (Object)pluginServizioAzioneCompatibilita, false);
    }

    public void write(OutputStream out, PluginServizioAzioneCompatibilita pluginServizioAzioneCompatibilita, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, PluginServizioAzioneCompatibilita.class, (Object)pluginServizioAzioneCompatibilita, prettyPrint);
    }

    public byte[] toByteArray(PluginServizioAzioneCompatibilita pluginServizioAzioneCompatibilita) throws SerializerException {
        return this.objToXml(PluginServizioAzioneCompatibilita.class, pluginServizioAzioneCompatibilita, false).toByteArray();
    }

    public byte[] toByteArray(PluginServizioAzioneCompatibilita pluginServizioAzioneCompatibilita, boolean prettyPrint) throws SerializerException {
        return this.objToXml(PluginServizioAzioneCompatibilita.class, pluginServizioAzioneCompatibilita, prettyPrint).toByteArray();
    }

    public String toString(PluginServizioAzioneCompatibilita pluginServizioAzioneCompatibilita) throws SerializerException {
        return this.objToXml(PluginServizioAzioneCompatibilita.class, pluginServizioAzioneCompatibilita, false).toString();
    }

    public String toString(PluginServizioAzioneCompatibilita pluginServizioAzioneCompatibilita, boolean prettyPrint) throws SerializerException {
        return this.objToXml(PluginServizioAzioneCompatibilita.class, pluginServizioAzioneCompatibilita, prettyPrint).toString();
    }

    public void write(String fileName, IdPlugin idPlugin) throws SerializerException {
        this.objToXml(fileName, IdPlugin.class, (Object)idPlugin, false);
    }

    public void write(String fileName, IdPlugin idPlugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, IdPlugin.class, (Object)idPlugin, prettyPrint);
    }

    public void write(File file, IdPlugin idPlugin) throws SerializerException {
        this.objToXml(file, IdPlugin.class, (Object)idPlugin, false);
    }

    public void write(File file, IdPlugin idPlugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, IdPlugin.class, (Object)idPlugin, prettyPrint);
    }

    public void write(OutputStream out, IdPlugin idPlugin) throws SerializerException {
        this.objToXml(out, IdPlugin.class, (Object)idPlugin, false);
    }

    public void write(OutputStream out, IdPlugin idPlugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, IdPlugin.class, (Object)idPlugin, prettyPrint);
    }

    public byte[] toByteArray(IdPlugin idPlugin) throws SerializerException {
        return this.objToXml(IdPlugin.class, idPlugin, false).toByteArray();
    }

    public byte[] toByteArray(IdPlugin idPlugin, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdPlugin.class, idPlugin, prettyPrint).toByteArray();
    }

    public String toString(IdPlugin idPlugin) throws SerializerException {
        return this.objToXml(IdPlugin.class, idPlugin, false).toString();
    }

    public String toString(IdPlugin idPlugin, boolean prettyPrint) throws SerializerException {
        return this.objToXml(IdPlugin.class, idPlugin, prettyPrint).toString();
    }

    public void write(String fileName, ElencoIdPlugin elencoIdPlugin) throws SerializerException {
        this.objToXml(fileName, ElencoIdPlugin.class, (Object)elencoIdPlugin, false);
    }

    public void write(String fileName, ElencoIdPlugin elencoIdPlugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ElencoIdPlugin.class, (Object)elencoIdPlugin, prettyPrint);
    }

    public void write(File file, ElencoIdPlugin elencoIdPlugin) throws SerializerException {
        this.objToXml(file, ElencoIdPlugin.class, (Object)elencoIdPlugin, false);
    }

    public void write(File file, ElencoIdPlugin elencoIdPlugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ElencoIdPlugin.class, (Object)elencoIdPlugin, prettyPrint);
    }

    public void write(OutputStream out, ElencoIdPlugin elencoIdPlugin) throws SerializerException {
        this.objToXml(out, ElencoIdPlugin.class, (Object)elencoIdPlugin, false);
    }

    public void write(OutputStream out, ElencoIdPlugin elencoIdPlugin, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ElencoIdPlugin.class, (Object)elencoIdPlugin, prettyPrint);
    }

    public byte[] toByteArray(ElencoIdPlugin elencoIdPlugin) throws SerializerException {
        return this.objToXml(ElencoIdPlugin.class, elencoIdPlugin, false).toByteArray();
    }

    public byte[] toByteArray(ElencoIdPlugin elencoIdPlugin, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoIdPlugin.class, elencoIdPlugin, prettyPrint).toByteArray();
    }

    public String toString(ElencoIdPlugin elencoIdPlugin) throws SerializerException {
        return this.objToXml(ElencoIdPlugin.class, elencoIdPlugin, false).toString();
    }

    public String toString(ElencoIdPlugin elencoIdPlugin, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoIdPlugin.class, elencoIdPlugin, prettyPrint).toString();
    }

    public void write(String fileName, PluginServizioCompatibilita pluginServizioCompatibilita) throws SerializerException {
        this.objToXml(fileName, PluginServizioCompatibilita.class, (Object)pluginServizioCompatibilita, false);
    }

    public void write(String fileName, PluginServizioCompatibilita pluginServizioCompatibilita, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, PluginServizioCompatibilita.class, (Object)pluginServizioCompatibilita, prettyPrint);
    }

    public void write(File file, PluginServizioCompatibilita pluginServizioCompatibilita) throws SerializerException {
        this.objToXml(file, PluginServizioCompatibilita.class, (Object)pluginServizioCompatibilita, false);
    }

    public void write(File file, PluginServizioCompatibilita pluginServizioCompatibilita, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, PluginServizioCompatibilita.class, (Object)pluginServizioCompatibilita, prettyPrint);
    }

    public void write(OutputStream out, PluginServizioCompatibilita pluginServizioCompatibilita) throws SerializerException {
        this.objToXml(out, PluginServizioCompatibilita.class, (Object)pluginServizioCompatibilita, false);
    }

    public void write(OutputStream out, PluginServizioCompatibilita pluginServizioCompatibilita, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, PluginServizioCompatibilita.class, (Object)pluginServizioCompatibilita, prettyPrint);
    }

    public byte[] toByteArray(PluginServizioCompatibilita pluginServizioCompatibilita) throws SerializerException {
        return this.objToXml(PluginServizioCompatibilita.class, pluginServizioCompatibilita, false).toByteArray();
    }

    public byte[] toByteArray(PluginServizioCompatibilita pluginServizioCompatibilita, boolean prettyPrint) throws SerializerException {
        return this.objToXml(PluginServizioCompatibilita.class, pluginServizioCompatibilita, prettyPrint).toByteArray();
    }

    public String toString(PluginServizioCompatibilita pluginServizioCompatibilita) throws SerializerException {
        return this.objToXml(PluginServizioCompatibilita.class, pluginServizioCompatibilita, false).toString();
    }

    public String toString(PluginServizioCompatibilita pluginServizioCompatibilita, boolean prettyPrint) throws SerializerException {
        return this.objToXml(PluginServizioCompatibilita.class, pluginServizioCompatibilita, prettyPrint).toString();
    }

    public void write(String fileName, PluginProprietaCompatibilita pluginProprietaCompatibilita) throws SerializerException {
        this.objToXml(fileName, PluginProprietaCompatibilita.class, (Object)pluginProprietaCompatibilita, false);
    }

    public void write(String fileName, PluginProprietaCompatibilita pluginProprietaCompatibilita, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, PluginProprietaCompatibilita.class, (Object)pluginProprietaCompatibilita, prettyPrint);
    }

    public void write(File file, PluginProprietaCompatibilita pluginProprietaCompatibilita) throws SerializerException {
        this.objToXml(file, PluginProprietaCompatibilita.class, (Object)pluginProprietaCompatibilita, false);
    }

    public void write(File file, PluginProprietaCompatibilita pluginProprietaCompatibilita, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, PluginProprietaCompatibilita.class, (Object)pluginProprietaCompatibilita, prettyPrint);
    }

    public void write(OutputStream out, PluginProprietaCompatibilita pluginProprietaCompatibilita) throws SerializerException {
        this.objToXml(out, PluginProprietaCompatibilita.class, (Object)pluginProprietaCompatibilita, false);
    }

    public void write(OutputStream out, PluginProprietaCompatibilita pluginProprietaCompatibilita, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, PluginProprietaCompatibilita.class, (Object)pluginProprietaCompatibilita, prettyPrint);
    }

    public byte[] toByteArray(PluginProprietaCompatibilita pluginProprietaCompatibilita) throws SerializerException {
        return this.objToXml(PluginProprietaCompatibilita.class, pluginProprietaCompatibilita, false).toByteArray();
    }

    public byte[] toByteArray(PluginProprietaCompatibilita pluginProprietaCompatibilita, boolean prettyPrint) throws SerializerException {
        return this.objToXml(PluginProprietaCompatibilita.class, pluginProprietaCompatibilita, prettyPrint).toByteArray();
    }

    public String toString(PluginProprietaCompatibilita pluginProprietaCompatibilita) throws SerializerException {
        return this.objToXml(PluginProprietaCompatibilita.class, pluginProprietaCompatibilita, false).toString();
    }

    public String toString(PluginProprietaCompatibilita pluginProprietaCompatibilita, boolean prettyPrint) throws SerializerException {
        return this.objToXml(PluginProprietaCompatibilita.class, pluginProprietaCompatibilita, prettyPrint).toString();
    }

    public void write(String fileName, ElencoIdConfigurazioneServizio elencoIdConfigurazioneServizio) throws SerializerException {
        this.objToXml(fileName, ElencoIdConfigurazioneServizio.class, (Object)elencoIdConfigurazioneServizio, false);
    }

    public void write(String fileName, ElencoIdConfigurazioneServizio elencoIdConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ElencoIdConfigurazioneServizio.class, (Object)elencoIdConfigurazioneServizio, prettyPrint);
    }

    public void write(File file, ElencoIdConfigurazioneServizio elencoIdConfigurazioneServizio) throws SerializerException {
        this.objToXml(file, ElencoIdConfigurazioneServizio.class, (Object)elencoIdConfigurazioneServizio, false);
    }

    public void write(File file, ElencoIdConfigurazioneServizio elencoIdConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ElencoIdConfigurazioneServizio.class, (Object)elencoIdConfigurazioneServizio, prettyPrint);
    }

    public void write(OutputStream out, ElencoIdConfigurazioneServizio elencoIdConfigurazioneServizio) throws SerializerException {
        this.objToXml(out, ElencoIdConfigurazioneServizio.class, (Object)elencoIdConfigurazioneServizio, false);
    }

    public void write(OutputStream out, ElencoIdConfigurazioneServizio elencoIdConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ElencoIdConfigurazioneServizio.class, (Object)elencoIdConfigurazioneServizio, prettyPrint);
    }

    public byte[] toByteArray(ElencoIdConfigurazioneServizio elencoIdConfigurazioneServizio) throws SerializerException {
        return this.objToXml(ElencoIdConfigurazioneServizio.class, elencoIdConfigurazioneServizio, false).toByteArray();
    }

    public byte[] toByteArray(ElencoIdConfigurazioneServizio elencoIdConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoIdConfigurazioneServizio.class, elencoIdConfigurazioneServizio, prettyPrint).toByteArray();
    }

    public String toString(ElencoIdConfigurazioneServizio elencoIdConfigurazioneServizio) throws SerializerException {
        return this.objToXml(ElencoIdConfigurazioneServizio.class, elencoIdConfigurazioneServizio, false).toString();
    }

    public String toString(ElencoIdConfigurazioneServizio elencoIdConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoIdConfigurazioneServizio.class, elencoIdConfigurazioneServizio, prettyPrint).toString();
    }

    public void write(String fileName, ElencoConfigurazioneServizio elencoConfigurazioneServizio) throws SerializerException {
        this.objToXml(fileName, ElencoConfigurazioneServizio.class, (Object)elencoConfigurazioneServizio, false);
    }

    public void write(String fileName, ElencoConfigurazioneServizio elencoConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ElencoConfigurazioneServizio.class, (Object)elencoConfigurazioneServizio, prettyPrint);
    }

    public void write(File file, ElencoConfigurazioneServizio elencoConfigurazioneServizio) throws SerializerException {
        this.objToXml(file, ElencoConfigurazioneServizio.class, (Object)elencoConfigurazioneServizio, false);
    }

    public void write(File file, ElencoConfigurazioneServizio elencoConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ElencoConfigurazioneServizio.class, (Object)elencoConfigurazioneServizio, prettyPrint);
    }

    public void write(OutputStream out, ElencoConfigurazioneServizio elencoConfigurazioneServizio) throws SerializerException {
        this.objToXml(out, ElencoConfigurazioneServizio.class, (Object)elencoConfigurazioneServizio, false);
    }

    public void write(OutputStream out, ElencoConfigurazioneServizio elencoConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ElencoConfigurazioneServizio.class, (Object)elencoConfigurazioneServizio, prettyPrint);
    }

    public byte[] toByteArray(ElencoConfigurazioneServizio elencoConfigurazioneServizio) throws SerializerException {
        return this.objToXml(ElencoConfigurazioneServizio.class, elencoConfigurazioneServizio, false).toByteArray();
    }

    public byte[] toByteArray(ElencoConfigurazioneServizio elencoConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoConfigurazioneServizio.class, elencoConfigurazioneServizio, prettyPrint).toByteArray();
    }

    public String toString(ElencoConfigurazioneServizio elencoConfigurazioneServizio) throws SerializerException {
        return this.objToXml(ElencoConfigurazioneServizio.class, elencoConfigurazioneServizio, false).toString();
    }

    public String toString(ElencoConfigurazioneServizio elencoConfigurazioneServizio, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ElencoConfigurazioneServizio.class, elencoConfigurazioneServizio, prettyPrint).toString();
    }
}

