/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.mvc.properties.utils.serializer;

import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.openspcoop2.core.mvc.properties.Collection;
import org.openspcoop2.core.mvc.properties.Compatibility;
import org.openspcoop2.core.mvc.properties.Condition;
import org.openspcoop2.core.mvc.properties.Conditions;
import org.openspcoop2.core.mvc.properties.Config;
import org.openspcoop2.core.mvc.properties.Defined;
import org.openspcoop2.core.mvc.properties.Equals;
import org.openspcoop2.core.mvc.properties.Item;
import org.openspcoop2.core.mvc.properties.ItemValue;
import org.openspcoop2.core.mvc.properties.ItemValues;
import org.openspcoop2.core.mvc.properties.Properties;
import org.openspcoop2.core.mvc.properties.Property;
import org.openspcoop2.core.mvc.properties.Section;
import org.openspcoop2.core.mvc.properties.Selected;
import org.openspcoop2.core.mvc.properties.Subsection;
import org.openspcoop2.core.mvc.properties.Tags;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, Defined defined) throws SerializerException {
        this.objToXml(fileName, Defined.class, (Object)defined, false);
    }

    public void write(String fileName, Defined defined, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Defined.class, (Object)defined, prettyPrint);
    }

    public void write(File file, Defined defined) throws SerializerException {
        this.objToXml(file, Defined.class, (Object)defined, false);
    }

    public void write(File file, Defined defined, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Defined.class, (Object)defined, prettyPrint);
    }

    public void write(OutputStream out, Defined defined) throws SerializerException {
        this.objToXml(out, Defined.class, (Object)defined, false);
    }

    public void write(OutputStream out, Defined defined, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Defined.class, (Object)defined, prettyPrint);
    }

    public byte[] toByteArray(Defined defined) throws SerializerException {
        return this.objToXml(Defined.class, defined, false).toByteArray();
    }

    public byte[] toByteArray(Defined defined, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Defined.class, defined, prettyPrint).toByteArray();
    }

    public String toString(Defined defined) throws SerializerException {
        return this.objToXml(Defined.class, defined, false).toString();
    }

    public String toString(Defined defined, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Defined.class, defined, prettyPrint).toString();
    }

    public void write(String fileName, Conditions conditions) throws SerializerException {
        this.objToXml(fileName, Conditions.class, (Object)conditions, false);
    }

    public void write(String fileName, Conditions conditions, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Conditions.class, (Object)conditions, prettyPrint);
    }

    public void write(File file, Conditions conditions) throws SerializerException {
        this.objToXml(file, Conditions.class, (Object)conditions, false);
    }

    public void write(File file, Conditions conditions, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Conditions.class, (Object)conditions, prettyPrint);
    }

    public void write(OutputStream out, Conditions conditions) throws SerializerException {
        this.objToXml(out, Conditions.class, (Object)conditions, false);
    }

    public void write(OutputStream out, Conditions conditions, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Conditions.class, (Object)conditions, prettyPrint);
    }

    public byte[] toByteArray(Conditions conditions) throws SerializerException {
        return this.objToXml(Conditions.class, conditions, false).toByteArray();
    }

    public byte[] toByteArray(Conditions conditions, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Conditions.class, conditions, prettyPrint).toByteArray();
    }

    public String toString(Conditions conditions) throws SerializerException {
        return this.objToXml(Conditions.class, conditions, false).toString();
    }

    public String toString(Conditions conditions, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Conditions.class, conditions, prettyPrint).toString();
    }

    public void write(String fileName, Subsection subsection) throws SerializerException {
        this.objToXml(fileName, Subsection.class, (Object)subsection, false);
    }

    public void write(String fileName, Subsection subsection, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Subsection.class, (Object)subsection, prettyPrint);
    }

    public void write(File file, Subsection subsection) throws SerializerException {
        this.objToXml(file, Subsection.class, (Object)subsection, false);
    }

    public void write(File file, Subsection subsection, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Subsection.class, (Object)subsection, prettyPrint);
    }

    public void write(OutputStream out, Subsection subsection) throws SerializerException {
        this.objToXml(out, Subsection.class, (Object)subsection, false);
    }

    public void write(OutputStream out, Subsection subsection, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Subsection.class, (Object)subsection, prettyPrint);
    }

    public byte[] toByteArray(Subsection subsection) throws SerializerException {
        return this.objToXml(Subsection.class, subsection, false).toByteArray();
    }

    public byte[] toByteArray(Subsection subsection, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Subsection.class, subsection, prettyPrint).toByteArray();
    }

    public String toString(Subsection subsection) throws SerializerException {
        return this.objToXml(Subsection.class, subsection, false).toString();
    }

    public String toString(Subsection subsection, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Subsection.class, subsection, prettyPrint).toString();
    }

    public void write(String fileName, Item item) throws SerializerException {
        this.objToXml(fileName, Item.class, (Object)item, false);
    }

    public void write(String fileName, Item item, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Item.class, (Object)item, prettyPrint);
    }

    public void write(File file, Item item) throws SerializerException {
        this.objToXml(file, Item.class, (Object)item, false);
    }

    public void write(File file, Item item, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Item.class, (Object)item, prettyPrint);
    }

    public void write(OutputStream out, Item item) throws SerializerException {
        this.objToXml(out, Item.class, (Object)item, false);
    }

    public void write(OutputStream out, Item item, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Item.class, (Object)item, prettyPrint);
    }

    public byte[] toByteArray(Item item) throws SerializerException {
        return this.objToXml(Item.class, item, false).toByteArray();
    }

    public byte[] toByteArray(Item item, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Item.class, item, prettyPrint).toByteArray();
    }

    public String toString(Item item) throws SerializerException {
        return this.objToXml(Item.class, item, false).toString();
    }

    public String toString(Item item, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Item.class, item, prettyPrint).toString();
    }

    public void write(String fileName, Selected selected) throws SerializerException {
        this.objToXml(fileName, Selected.class, (Object)selected, false);
    }

    public void write(String fileName, Selected selected, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Selected.class, (Object)selected, prettyPrint);
    }

    public void write(File file, Selected selected) throws SerializerException {
        this.objToXml(file, Selected.class, (Object)selected, false);
    }

    public void write(File file, Selected selected, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Selected.class, (Object)selected, prettyPrint);
    }

    public void write(OutputStream out, Selected selected) throws SerializerException {
        this.objToXml(out, Selected.class, (Object)selected, false);
    }

    public void write(OutputStream out, Selected selected, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Selected.class, (Object)selected, prettyPrint);
    }

    public byte[] toByteArray(Selected selected) throws SerializerException {
        return this.objToXml(Selected.class, selected, false).toByteArray();
    }

    public byte[] toByteArray(Selected selected, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Selected.class, selected, prettyPrint).toByteArray();
    }

    public String toString(Selected selected) throws SerializerException {
        return this.objToXml(Selected.class, selected, false).toString();
    }

    public String toString(Selected selected, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Selected.class, selected, prettyPrint).toString();
    }

    public void write(String fileName, ItemValue itemValue) throws SerializerException {
        this.objToXml(fileName, ItemValue.class, (Object)itemValue, false);
    }

    public void write(String fileName, ItemValue itemValue, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ItemValue.class, (Object)itemValue, prettyPrint);
    }

    public void write(File file, ItemValue itemValue) throws SerializerException {
        this.objToXml(file, ItemValue.class, (Object)itemValue, false);
    }

    public void write(File file, ItemValue itemValue, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ItemValue.class, (Object)itemValue, prettyPrint);
    }

    public void write(OutputStream out, ItemValue itemValue) throws SerializerException {
        this.objToXml(out, ItemValue.class, (Object)itemValue, false);
    }

    public void write(OutputStream out, ItemValue itemValue, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ItemValue.class, (Object)itemValue, prettyPrint);
    }

    public byte[] toByteArray(ItemValue itemValue) throws SerializerException {
        return this.objToXml(ItemValue.class, itemValue, false).toByteArray();
    }

    public byte[] toByteArray(ItemValue itemValue, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ItemValue.class, itemValue, prettyPrint).toByteArray();
    }

    public String toString(ItemValue itemValue) throws SerializerException {
        return this.objToXml(ItemValue.class, itemValue, false).toString();
    }

    public String toString(ItemValue itemValue, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ItemValue.class, itemValue, prettyPrint).toString();
    }

    public void write(String fileName, ItemValues itemValues) throws SerializerException {
        this.objToXml(fileName, ItemValues.class, (Object)itemValues, false);
    }

    public void write(String fileName, ItemValues itemValues, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, ItemValues.class, (Object)itemValues, prettyPrint);
    }

    public void write(File file, ItemValues itemValues) throws SerializerException {
        this.objToXml(file, ItemValues.class, (Object)itemValues, false);
    }

    public void write(File file, ItemValues itemValues, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, ItemValues.class, (Object)itemValues, prettyPrint);
    }

    public void write(OutputStream out, ItemValues itemValues) throws SerializerException {
        this.objToXml(out, ItemValues.class, (Object)itemValues, false);
    }

    public void write(OutputStream out, ItemValues itemValues, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, ItemValues.class, (Object)itemValues, prettyPrint);
    }

    public byte[] toByteArray(ItemValues itemValues) throws SerializerException {
        return this.objToXml(ItemValues.class, itemValues, false).toByteArray();
    }

    public byte[] toByteArray(ItemValues itemValues, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ItemValues.class, itemValues, prettyPrint).toByteArray();
    }

    public String toString(ItemValues itemValues) throws SerializerException {
        return this.objToXml(ItemValues.class, itemValues, false).toString();
    }

    public String toString(ItemValues itemValues, boolean prettyPrint) throws SerializerException {
        return this.objToXml(ItemValues.class, itemValues, prettyPrint).toString();
    }

    public void write(String fileName, Equals equals) throws SerializerException {
        this.objToXml(fileName, Equals.class, (Object)equals, false);
    }

    public void write(String fileName, Equals equals, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Equals.class, (Object)equals, prettyPrint);
    }

    public void write(File file, Equals equals) throws SerializerException {
        this.objToXml(file, Equals.class, (Object)equals, false);
    }

    public void write(File file, Equals equals, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Equals.class, (Object)equals, prettyPrint);
    }

    public void write(OutputStream out, Equals equals) throws SerializerException {
        this.objToXml(out, Equals.class, (Object)equals, false);
    }

    public void write(OutputStream out, Equals equals, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Equals.class, (Object)equals, prettyPrint);
    }

    public byte[] toByteArray(Equals equals) throws SerializerException {
        return this.objToXml(Equals.class, equals, false).toByteArray();
    }

    public byte[] toByteArray(Equals equals, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Equals.class, equals, prettyPrint).toByteArray();
    }

    public String toString(Equals equals) throws SerializerException {
        return this.objToXml(Equals.class, equals, false).toString();
    }

    public String toString(Equals equals, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Equals.class, equals, prettyPrint).toString();
    }

    public void write(String fileName, Compatibility compatibility) throws SerializerException {
        this.objToXml(fileName, Compatibility.class, (Object)compatibility, false);
    }

    public void write(String fileName, Compatibility compatibility, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Compatibility.class, (Object)compatibility, prettyPrint);
    }

    public void write(File file, Compatibility compatibility) throws SerializerException {
        this.objToXml(file, Compatibility.class, (Object)compatibility, false);
    }

    public void write(File file, Compatibility compatibility, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Compatibility.class, (Object)compatibility, prettyPrint);
    }

    public void write(OutputStream out, Compatibility compatibility) throws SerializerException {
        this.objToXml(out, Compatibility.class, (Object)compatibility, false);
    }

    public void write(OutputStream out, Compatibility compatibility, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Compatibility.class, (Object)compatibility, prettyPrint);
    }

    public byte[] toByteArray(Compatibility compatibility) throws SerializerException {
        return this.objToXml(Compatibility.class, compatibility, false).toByteArray();
    }

    public byte[] toByteArray(Compatibility compatibility, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Compatibility.class, compatibility, prettyPrint).toByteArray();
    }

    public String toString(Compatibility compatibility) throws SerializerException {
        return this.objToXml(Compatibility.class, compatibility, false).toString();
    }

    public String toString(Compatibility compatibility, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Compatibility.class, compatibility, prettyPrint).toString();
    }

    public void write(String fileName, Config config) throws SerializerException {
        this.objToXml(fileName, Config.class, (Object)config, false);
    }

    public void write(String fileName, Config config, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Config.class, (Object)config, prettyPrint);
    }

    public void write(File file, Config config) throws SerializerException {
        this.objToXml(file, Config.class, (Object)config, false);
    }

    public void write(File file, Config config, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Config.class, (Object)config, prettyPrint);
    }

    public void write(OutputStream out, Config config) throws SerializerException {
        this.objToXml(out, Config.class, (Object)config, false);
    }

    public void write(OutputStream out, Config config, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Config.class, (Object)config, prettyPrint);
    }

    public byte[] toByteArray(Config config) throws SerializerException {
        return this.objToXml(Config.class, config, false).toByteArray();
    }

    public byte[] toByteArray(Config config, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Config.class, config, prettyPrint).toByteArray();
    }

    public String toString(Config config) throws SerializerException {
        return this.objToXml(Config.class, config, false).toString();
    }

    public String toString(Config config, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Config.class, config, prettyPrint).toString();
    }

    public void write(String fileName, Properties properties) throws SerializerException {
        this.objToXml(fileName, Properties.class, (Object)properties, false);
    }

    public void write(String fileName, Properties properties, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Properties.class, (Object)properties, prettyPrint);
    }

    public void write(File file, Properties properties) throws SerializerException {
        this.objToXml(file, Properties.class, (Object)properties, false);
    }

    public void write(File file, Properties properties, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Properties.class, (Object)properties, prettyPrint);
    }

    public void write(OutputStream out, Properties properties) throws SerializerException {
        this.objToXml(out, Properties.class, (Object)properties, false);
    }

    public void write(OutputStream out, Properties properties, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Properties.class, (Object)properties, prettyPrint);
    }

    public byte[] toByteArray(Properties properties) throws SerializerException {
        return this.objToXml(Properties.class, properties, false).toByteArray();
    }

    public byte[] toByteArray(Properties properties, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Properties.class, properties, prettyPrint).toByteArray();
    }

    public String toString(Properties properties) throws SerializerException {
        return this.objToXml(Properties.class, properties, false).toString();
    }

    public String toString(Properties properties, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Properties.class, properties, prettyPrint).toString();
    }

    public void write(String fileName, Section section) throws SerializerException {
        this.objToXml(fileName, Section.class, (Object)section, false);
    }

    public void write(String fileName, Section section, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Section.class, (Object)section, prettyPrint);
    }

    public void write(File file, Section section) throws SerializerException {
        this.objToXml(file, Section.class, (Object)section, false);
    }

    public void write(File file, Section section, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Section.class, (Object)section, prettyPrint);
    }

    public void write(OutputStream out, Section section) throws SerializerException {
        this.objToXml(out, Section.class, (Object)section, false);
    }

    public void write(OutputStream out, Section section, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Section.class, (Object)section, prettyPrint);
    }

    public byte[] toByteArray(Section section) throws SerializerException {
        return this.objToXml(Section.class, section, false).toByteArray();
    }

    public byte[] toByteArray(Section section, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Section.class, section, prettyPrint).toByteArray();
    }

    public String toString(Section section) throws SerializerException {
        return this.objToXml(Section.class, section, false).toString();
    }

    public String toString(Section section, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Section.class, section, prettyPrint).toString();
    }

    public void write(String fileName, Property property) throws SerializerException {
        this.objToXml(fileName, Property.class, (Object)property, false);
    }

    public void write(String fileName, Property property, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Property.class, (Object)property, prettyPrint);
    }

    public void write(File file, Property property) throws SerializerException {
        this.objToXml(file, Property.class, (Object)property, false);
    }

    public void write(File file, Property property, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Property.class, (Object)property, prettyPrint);
    }

    public void write(OutputStream out, Property property) throws SerializerException {
        this.objToXml(out, Property.class, (Object)property, false);
    }

    public void write(OutputStream out, Property property, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Property.class, (Object)property, prettyPrint);
    }

    public byte[] toByteArray(Property property) throws SerializerException {
        return this.objToXml(Property.class, property, false).toByteArray();
    }

    public byte[] toByteArray(Property property, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Property.class, property, prettyPrint).toByteArray();
    }

    public String toString(Property property) throws SerializerException {
        return this.objToXml(Property.class, property, false).toString();
    }

    public String toString(Property property, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Property.class, property, prettyPrint).toString();
    }

    public void write(String fileName, Tags tags) throws SerializerException {
        this.objToXml(fileName, Tags.class, (Object)tags, false);
    }

    public void write(String fileName, Tags tags, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Tags.class, (Object)tags, prettyPrint);
    }

    public void write(File file, Tags tags) throws SerializerException {
        this.objToXml(file, Tags.class, (Object)tags, false);
    }

    public void write(File file, Tags tags, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Tags.class, (Object)tags, prettyPrint);
    }

    public void write(OutputStream out, Tags tags) throws SerializerException {
        this.objToXml(out, Tags.class, (Object)tags, false);
    }

    public void write(OutputStream out, Tags tags, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Tags.class, (Object)tags, prettyPrint);
    }

    public byte[] toByteArray(Tags tags) throws SerializerException {
        return this.objToXml(Tags.class, tags, false).toByteArray();
    }

    public byte[] toByteArray(Tags tags, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Tags.class, tags, prettyPrint).toByteArray();
    }

    public String toString(Tags tags) throws SerializerException {
        return this.objToXml(Tags.class, tags, false).toString();
    }

    public String toString(Tags tags, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Tags.class, tags, prettyPrint).toString();
    }

    public void write(String fileName, Collection collection) throws SerializerException {
        this.objToXml(fileName, Collection.class, (Object)collection, false);
    }

    public void write(String fileName, Collection collection, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Collection.class, (Object)collection, prettyPrint);
    }

    public void write(File file, Collection collection) throws SerializerException {
        this.objToXml(file, Collection.class, (Object)collection, false);
    }

    public void write(File file, Collection collection, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Collection.class, (Object)collection, prettyPrint);
    }

    public void write(OutputStream out, Collection collection) throws SerializerException {
        this.objToXml(out, Collection.class, (Object)collection, false);
    }

    public void write(OutputStream out, Collection collection, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Collection.class, (Object)collection, prettyPrint);
    }

    public byte[] toByteArray(Collection collection) throws SerializerException {
        return this.objToXml(Collection.class, collection, false).toByteArray();
    }

    public byte[] toByteArray(Collection collection, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Collection.class, collection, prettyPrint).toByteArray();
    }

    public String toString(Collection collection) throws SerializerException {
        return this.objToXml(Collection.class, collection, false).toString();
    }

    public String toString(Collection collection, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Collection.class, collection, prettyPrint).toString();
    }

    public void write(String fileName, Condition condition) throws SerializerException {
        this.objToXml(fileName, Condition.class, (Object)condition, false);
    }

    public void write(String fileName, Condition condition, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Condition.class, (Object)condition, prettyPrint);
    }

    public void write(File file, Condition condition) throws SerializerException {
        this.objToXml(file, Condition.class, (Object)condition, false);
    }

    public void write(File file, Condition condition, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Condition.class, (Object)condition, prettyPrint);
    }

    public void write(OutputStream out, Condition condition) throws SerializerException {
        this.objToXml(out, Condition.class, (Object)condition, false);
    }

    public void write(OutputStream out, Condition condition, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Condition.class, (Object)condition, prettyPrint);
    }

    public byte[] toByteArray(Condition condition) throws SerializerException {
        return this.objToXml(Condition.class, condition, false).toByteArray();
    }

    public byte[] toByteArray(Condition condition, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Condition.class, condition, prettyPrint).toByteArray();
    }

    public String toString(Condition condition) throws SerializerException {
        return this.objToXml(Condition.class, condition, false).toString();
    }

    public String toString(Condition condition, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Condition.class, condition, prettyPrint).toString();
    }
}

