/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.mvc.properties.provider;

import org.openspcoop2.core.mvc.properties.provider.ProviderValidationException;

public class InputValidationUtils {
    private InputValidationUtils() {
    }

    public static void validateTextInput(String input, String fieldName) throws ProviderValidationException {
        InputValidationUtils.validateTextAreaInput(input, fieldName, true, false, false);
    }

    public static void validateTextInput(String input, String fieldName, boolean spaceEnabled) throws ProviderValidationException {
        InputValidationUtils.validateTextAreaInput(input, fieldName, spaceEnabled, false, false);
    }

    public static void validateTextAreaInput(String input, String fieldName) throws ProviderValidationException {
        InputValidationUtils.validateTextAreaInput(input, fieldName, false, false, false);
    }

    public static void validateTextAreaInput(String input, String fieldName, boolean spaceEnabled) throws ProviderValidationException {
        InputValidationUtils.validateTextAreaInput(input, fieldName, spaceEnabled, false, false);
    }

    public static void validateTextAreaInput(String input, String fieldName, boolean spaceEnabled, boolean tabEnabled, boolean newLineEnabled) throws ProviderValidationException {
        String prefix = "Il valore indicato nel campo '";
        if (input == null || "".equals(input)) {
            throw new ProviderValidationException("Non \u00e8 stato fornito un valore nel campo '" + fieldName + "'");
        }
        if (spaceEnabled) {
            if (input.startsWith(" ")) {
                throw new ProviderValidationException(prefix + fieldName + "' non deve iniziare con uno spazio");
            }
            if (input.endsWith(" ")) {
                throw new ProviderValidationException(prefix + fieldName + "' non deve terminare con uno spazio");
            }
        } else if (input.contains(" ")) {
            throw new ProviderValidationException(prefix + fieldName + "' non deve contenere spazi");
        }
        if (!tabEnabled && input.contains("\t")) {
            throw new ProviderValidationException(prefix + fieldName + "' non deve contenere tab (\\t)");
        }
        if (!newLineEnabled && (input.contains("\n") || input.contains("\r"))) {
            throw new ProviderValidationException(prefix + fieldName + "' non deve contenere ritorni a capo (\\n o \\r)");
        }
    }
}

