/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.id;

import java.io.Serializable;
import org.openspcoop2.core.id.IDException;

public class IDSoggetto
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected String tipo;
    protected String nome;
    protected String codicePorta;

    public IDSoggetto(String tipo, String nome) {
        this.tipo = tipo;
        this.nome = nome;
    }

    public IDSoggetto(String tipo, String nome, String codicePorta) {
        this.tipo = tipo;
        this.nome = nome;
        this.codicePorta = codicePorta;
    }

    public IDSoggetto() {
    }

    public void setNome(String nome) {
        this.nome = nome;
    }

    public void setTipo(String tipo) {
        this.tipo = tipo;
    }

    public void setCodicePorta(String codicePorta) {
        this.codicePorta = codicePorta;
    }

    public String getNome() {
        return this.nome;
    }

    public String getTipo() {
        return this.tipo;
    }

    public String getCodicePorta() {
        return this.codicePorta;
    }

    public String toString() {
        return this.tipo + "/" + this.nome;
    }

    public boolean equals(Object soggetto) {
        return this.equalsEngine(soggetto, true);
    }

    protected boolean equalsEngine(Object soggetto, boolean verifyClass) {
        String objectClassName;
        if (soggetto == null) {
            return false;
        }
        if (verifyClass && !(objectClassName = soggetto.getClass().getName()).equals(this.getClass().getName())) {
            return false;
        }
        IDSoggetto id = (IDSoggetto)soggetto;
        return this.equasEngine(id);
    }

    private boolean equasEngine(IDSoggetto id) {
        if (this.getTipo() == null ? id.getTipo() != null : !this.getTipo().equals(id.getTipo())) {
            return false;
        }
        return !(this.getNome() == null ? id.getNome() != null : !this.getNome().equals(id.getNome()));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public IDSoggetto clone() {
        IDSoggetto clone = null;
        try {
            clone = (IDSoggetto)super.clone();
        }
        catch (Exception t) {
            clone = new IDSoggetto();
        }
        clone.setCodicePorta(this.codicePorta != null ? this.codicePorta : null);
        clone.setTipo(this.tipo != null ? this.tipo : null);
        clone.setNome(this.nome != null ? this.nome : null);
        return clone;
    }

    public String toFormatString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tipo);
        sb.append("/");
        sb.append(this.nome);
        return sb.toString();
    }

    public static IDSoggetto toIDSoggetto(String formatString) throws IDException {
        String[] tmp = formatString.split("/");
        if (tmp.length != 2) {
            throw new IDException("Formato non supportato, attesi 2 valori, trovati " + tmp.length);
        }
        String tipo = tmp[0];
        String nome = tmp[1];
        IDSoggetto idSoggetto = new IDSoggetto();
        idSoggetto.tipo = tipo;
        idSoggetto.nome = nome;
        return idSoggetto;
    }
}

