/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.eventi.utils.serializer;

import jakarta.xml.bind.JAXBElement;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.openspcoop2.core.eventi.DatiEventoGenerico;
import org.openspcoop2.core.eventi.Evento;
import org.openspcoop2.generic_project.exception.SerializerException;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;

public abstract class AbstractSerializer {
    protected abstract WriteToSerializerType getType();

    protected void _objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws Exception {
        if (object instanceof JAXBElement) {
            JaxbUtils.objToXml((OutputStream)out, c, (Object)object, (boolean)prettyPrint);
        } else {
            Method m = c.getMethod("writeTo", OutputStream.class, WriteToSerializerType.class);
            m.invoke(object, out, this.getType());
        }
    }

    protected void objToXml(OutputStream out, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this._objToXml(out, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                out.flush();
            }
            catch (Exception exception) {}
        }
    }

    protected void objToXml(String fileName, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        try {
            this.objToXml(new File(fileName), c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
    }

    protected void objToXml(File file, Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            this._objToXml(fout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (fout != null) {
                    fout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected ByteArrayOutputStream objToXml(Class<?> c, Object object, boolean prettyPrint) throws SerializerException {
        ByteArrayOutputStream bout = null;
        try {
            bout = new ByteArrayOutputStream();
            this._objToXml(bout, c, object, prettyPrint);
        }
        catch (Exception e) {
            throw new SerializerException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                if (bout != null) {
                    bout.flush();
                }
            }
            catch (Exception exception) {}
            try {
                if (bout != null) {
                    bout.close();
                }
            }
            catch (Exception exception) {}
        }
        return bout;
    }

    public void write(String fileName, Evento evento) throws SerializerException {
        this.objToXml(fileName, Evento.class, (Object)evento, false);
    }

    public void write(String fileName, Evento evento, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, Evento.class, (Object)evento, prettyPrint);
    }

    public void write(File file, Evento evento) throws SerializerException {
        this.objToXml(file, Evento.class, (Object)evento, false);
    }

    public void write(File file, Evento evento, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, Evento.class, (Object)evento, prettyPrint);
    }

    public void write(OutputStream out, Evento evento) throws SerializerException {
        this.objToXml(out, Evento.class, (Object)evento, false);
    }

    public void write(OutputStream out, Evento evento, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, Evento.class, (Object)evento, prettyPrint);
    }

    public byte[] toByteArray(Evento evento) throws SerializerException {
        return this.objToXml(Evento.class, evento, false).toByteArray();
    }

    public byte[] toByteArray(Evento evento, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Evento.class, evento, prettyPrint).toByteArray();
    }

    public String toString(Evento evento) throws SerializerException {
        return this.objToXml(Evento.class, evento, false).toString();
    }

    public String toString(Evento evento, boolean prettyPrint) throws SerializerException {
        return this.objToXml(Evento.class, evento, prettyPrint).toString();
    }

    public void write(String fileName, DatiEventoGenerico datiEventoGenerico) throws SerializerException {
        this.objToXml(fileName, DatiEventoGenerico.class, (Object)datiEventoGenerico, false);
    }

    public void write(String fileName, DatiEventoGenerico datiEventoGenerico, boolean prettyPrint) throws SerializerException {
        this.objToXml(fileName, DatiEventoGenerico.class, (Object)datiEventoGenerico, prettyPrint);
    }

    public void write(File file, DatiEventoGenerico datiEventoGenerico) throws SerializerException {
        this.objToXml(file, DatiEventoGenerico.class, (Object)datiEventoGenerico, false);
    }

    public void write(File file, DatiEventoGenerico datiEventoGenerico, boolean prettyPrint) throws SerializerException {
        this.objToXml(file, DatiEventoGenerico.class, (Object)datiEventoGenerico, prettyPrint);
    }

    public void write(OutputStream out, DatiEventoGenerico datiEventoGenerico) throws SerializerException {
        this.objToXml(out, DatiEventoGenerico.class, (Object)datiEventoGenerico, false);
    }

    public void write(OutputStream out, DatiEventoGenerico datiEventoGenerico, boolean prettyPrint) throws SerializerException {
        this.objToXml(out, DatiEventoGenerico.class, (Object)datiEventoGenerico, prettyPrint);
    }

    public byte[] toByteArray(DatiEventoGenerico datiEventoGenerico) throws SerializerException {
        return this.objToXml(DatiEventoGenerico.class, datiEventoGenerico, false).toByteArray();
    }

    public byte[] toByteArray(DatiEventoGenerico datiEventoGenerico, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DatiEventoGenerico.class, datiEventoGenerico, prettyPrint).toByteArray();
    }

    public String toString(DatiEventoGenerico datiEventoGenerico) throws SerializerException {
        return this.objToXml(DatiEventoGenerico.class, datiEventoGenerico, false).toString();
    }

    public String toString(DatiEventoGenerico datiEventoGenerico, boolean prettyPrint) throws SerializerException {
        return this.objToXml(DatiEventoGenerico.class, datiEventoGenerico, prettyPrint).toString();
    }
}

