/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.eccezione.errore_applicativo.utils;

import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPFault;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.openspcoop2.core.eccezione.errore_applicativo.DatiCooperazione;
import org.openspcoop2.core.eccezione.errore_applicativo.Dominio;
import org.openspcoop2.core.eccezione.errore_applicativo.Eccezione;
import org.openspcoop2.core.eccezione.errore_applicativo.ErroreApplicativo;
import org.openspcoop2.core.eccezione.errore_applicativo.Servizio;
import org.openspcoop2.core.eccezione.errore_applicativo.Soggetto;
import org.openspcoop2.core.eccezione.errore_applicativo.utils.XMLUtilsException;
import org.openspcoop2.core.eccezione.errore_applicativo.utils.serializer.JsonJacksonDeserializer;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2RestJsonMessage;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.beans.WriteToSerializerType;
import org.openspcoop2.utils.xml.JaxbUtils;
import org.slf4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLUtils {
    static ValidatoreXSD validatoreXSD = null;

    private static synchronized void initValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            validatoreXSD = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), log, XMLUtils.class.getResourceAsStream("/openspcoopErroreApplicativo.xsd"));
        }
    }

    public static ValidatoreXSD getValidatoreXSD(Logger log) throws Exception {
        if (validatoreXSD == null) {
            XMLUtils.initValidatoreXSD(log);
        }
        return validatoreXSD;
    }

    public static boolean validate(ErroreApplicativo erroreApplicativo, StringBuilder motivoErroreValidazione) {
        int size = motivoErroreValidazione.length();
        if (erroreApplicativo.getDomain() == null) {
            motivoErroreValidazione.append("Dominio non definito\n");
        } else {
            XMLUtils.validate(erroreApplicativo.getDomain(), motivoErroreValidazione);
        }
        if (erroreApplicativo.getTimestamp() == null) {
            motivoErroreValidazione.append("OraRegistrazione non definita\n");
        }
        if (erroreApplicativo.getService() != null) {
            XMLUtils.validate(erroreApplicativo.getService(), motivoErroreValidazione);
        }
        XMLUtils.validate(erroreApplicativo.getException(), motivoErroreValidazione);
        return motivoErroreValidazione.length() == size;
    }

    private static void validate(Dominio dominio, StringBuilder motivoErroreValidazione) {
        if (dominio.getId() == null) {
            motivoErroreValidazione.append("Dominio.id non definito\n");
        }
        if (dominio.getRole() == null) {
            motivoErroreValidazione.append("Dominio.funzione non definito\n");
        }
        if (dominio.getModule() == null) {
            motivoErroreValidazione.append("Dominio.modulo non definito\n");
        }
        if (dominio.getOrganization() == null) {
            motivoErroreValidazione.append("Dominio.soggetto non definita\n");
        } else {
            if (dominio.getOrganization().getType() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.tipo non definita\n");
            }
            if (dominio.getOrganization().getBase() == null) {
                motivoErroreValidazione.append("Dominio.soggetto.nome non definita\n");
            }
        }
    }

    private static void validate(DatiCooperazione datiCooperazione, StringBuilder motivoErroreValidazione) {
        if (datiCooperazione.getSender() != null) {
            XMLUtils.validate(datiCooperazione.getSender(), motivoErroreValidazione, "mittente");
        }
        if (datiCooperazione.getProvider() != null) {
            XMLUtils.validate(datiCooperazione.getProvider(), motivoErroreValidazione, "destinatario");
        }
        if (datiCooperazione.getService() != null) {
            XMLUtils.validate(datiCooperazione.getService(), motivoErroreValidazione);
        }
    }

    private static void validate(Soggetto soggetto, StringBuilder motivoErroreValidazione, String tipo) {
        if (soggetto.getId() == null) {
            motivoErroreValidazione.append("DatiCooperazione." + tipo + ".identificativo non definita\n");
        } else {
            if (soggetto.getId().getType() == null) {
                motivoErroreValidazione.append("DatiCooperazione." + tipo + ".identificativo.tipo non definita\n");
            }
            if (soggetto.getId().getBase() == null) {
                motivoErroreValidazione.append("DatiCooperazione." + tipo + ".identificativo.base non definita\n");
            }
        }
        if (soggetto.getDomainId() == null) {
            motivoErroreValidazione.append("DatiCooperazione." + tipo + ".identificativoPorta non definita\n");
        }
    }

    private static void validate(Servizio servizio, StringBuilder motivoErroreValidazione) {
        if (servizio.getBase() == null) {
            motivoErroreValidazione.append("DatiCooperazione.servizio.base non definita\n");
        }
        if (servizio.getType() == null) {
            motivoErroreValidazione.append("DatiCooperazione.servizio.tipo non definita\n");
        }
    }

    private static void validate(Eccezione eccezione, StringBuilder motivoErroreValidazione) {
        if (eccezione == null) {
            motivoErroreValidazione.append("Eccezione non definita\n");
        } else {
            if (eccezione.getCode() == null) {
                motivoErroreValidazione.append("Eccezione.codice non definito\n");
            } else {
                if (eccezione.getCode().getBase() == null) {
                    motivoErroreValidazione.append("Eccezione.codice.base non definito\n");
                }
                if (eccezione.getCode().getType() == null) {
                    motivoErroreValidazione.append("Eccezione.codice.tipo non definito\n");
                }
            }
            if (eccezione.getDescription() == null) {
                motivoErroreValidazione.append("Eccezione.descrizione non definito\n");
            }
            if (eccezione.getType() == null) {
                motivoErroreValidazione.append("Eccezione.tipo non definito\n");
            }
        }
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, byte[] m) throws XMLUtilsException {
        ByteArrayInputStream bin = null;
        try {
            bin = new ByteArrayInputStream(m);
            ErroreApplicativo erroreApplicativo = XMLUtils.getErroreApplicativo(log, bin);
            return erroreApplicativo;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (bin != null) {
                    bin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, File m) throws XMLUtilsException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(m);
            ErroreApplicativo erroreApplicativo = XMLUtils.getErroreApplicativo(log, fin);
            return erroreApplicativo;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, String m) throws XMLUtilsException {
        return XMLUtils.getErroreApplicativo(log, m.getBytes());
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, InputStream m) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] reads = new byte[1024];
            int letti = 0;
            while ((letti = m.read(reads)) != -1) {
                bout.write(reads, 0, letti);
            }
            bout.flush();
            bout.close();
            byte[] xml = bout.toByteArray();
            ByteArrayInputStream binValidazione = new ByteArrayInputStream(xml);
            ValidatoreXSD validatoreXSD = XMLUtils.getValidatoreXSD(log);
            validatoreXSD.valida((InputStream)binValidazione);
            ByteArrayInputStream binTrasformazione = new ByteArrayInputStream(xml);
            return (ErroreApplicativo)JaxbUtils.xmlToObj((InputStream)binTrasformazione, ErroreApplicativo.class);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static ErroreApplicativo getErroreApplicativoFromJson(Logger log, InputStream is) throws XMLUtilsException {
        try {
            JsonJacksonDeserializer deserializer = new JsonJacksonDeserializer();
            return deserializer.readErroreApplicativo(is);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateErroreApplicativo(ErroreApplicativo eccezione, File out) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)out.getName(), (byte[])XMLUtils.generateErroreApplicativo_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateErroreApplicativo(ErroreApplicativo eccezione, String fileName) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            JaxbUtils.objToXml((String)fileName, (byte[])XMLUtils.generateErroreApplicativo_engine(eccezione));
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static byte[] generateErroreApplicativo(ErroreApplicativo eccezione) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateErroreApplicativo_engine(eccezione);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static String generateErroreApplicativoAsJson(ErroreApplicativo eccezione) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            return XMLUtils.generateErroreApplicativoAsJson_engine(eccezione);
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static void generateErroreApplicativo(ErroreApplicativo eccezione, OutputStream out) throws XMLUtilsException {
        try {
            StringBuilder risultatoValidazione = new StringBuilder();
            if (!XMLUtils.validate(eccezione, risultatoValidazione)) {
                throw new Exception(risultatoValidazione.toString());
            }
            out.write(XMLUtils.generateErroreApplicativo_engine(eccezione));
            out.flush();
            out.close();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static byte[] generateErroreApplicativo_engine(ErroreApplicativo eccezione) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            JaxbUtils.objToXml((OutputStream)bout, ErroreApplicativo.class, (Object)eccezione);
            bout.flush();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    private static String generateErroreApplicativoAsJson_engine(ErroreApplicativo eccezione) throws XMLUtilsException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            eccezione.writeTo(bout, WriteToSerializerType.JSON_JACKSON);
            bout.flush();
            bout.close();
            return bout.toString();
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, OpenSPCoop2Message msg) throws XMLUtilsException {
        switch (msg.getMessageType()) {
            case SOAP_11: 
            case SOAP_12: {
                try {
                    return XMLUtils.getErroreApplicativo(log, msg.castAsSoap());
                }
                catch (XMLUtilsException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new XMLUtilsException(e.getMessage(), e);
                }
            }
            case XML: {
                try {
                    Element element;
                    OpenSPCoop2RestXmlMessage rest = msg.castAsRestXml();
                    if (rest.hasContent() && XMLUtils.isErroreApplicativo(element = (Element)rest.getContent())) {
                        MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
                        byte[] xml = xmlUtils.toByteArray(element);
                        ErroreApplicativo errore = XMLUtils.getErroreApplicativo(log, xml);
                        return errore;
                    }
                    return null;
                }
                catch (XMLUtilsException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new XMLUtilsException(e.getMessage(), e);
                }
            }
            case JSON: {
                try {
                    OpenSPCoop2RestJsonMessage rest = msg.castAsRestJson();
                    if (rest.hasContent()) {
                        String json = (String)rest.getContent();
                        try {
                            ErroreApplicativo errore = XMLUtils.getErroreApplicativoFromJson(log, new ByteArrayInputStream(json.getBytes()));
                            return errore;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new XMLUtilsException(e.getMessage(), e);
                }
            }
        }
        return null;
    }

    public static ErroreApplicativo getErroreApplicativo(Logger log, OpenSPCoop2SoapMessage msg) throws XMLUtilsException {
        try {
            if (msg == null) {
                throw new XMLUtilsException("Messaggio non presente");
            }
            SOAPBody soapBody = msg.getSOAPBody();
            if (soapBody == null) {
                throw new XMLUtilsException("SOAPBody non presente");
            }
            SOAPFault faultOriginale = null;
            if (!soapBody.hasFault()) {
                return null;
            }
            faultOriginale = soapBody.getFault();
            if (faultOriginale == null) {
                throw new XMLUtilsException("SOAPFault is null");
            }
            QName nameDetail = new QName("detail");
            Iterator itSF = faultOriginale.getChildElements(nameDetail);
            SOAPElement detailsFaultOriginale = null;
            if (itSF.hasNext()) {
                detailsFaultOriginale = (SOAPElement)itSF.next();
            }
            msg.saveChanges();
            if (detailsFaultOriginale != null) {
                Iterator it = detailsFaultOriginale.getChildElements();
                while (it.hasNext()) {
                    Object o = it.next();
                    if (!(o instanceof SOAPElement)) continue;
                    SOAPElement elem = (SOAPElement)o;
                    try {
                        if (!XMLUtils.isErroreApplicativo((Element)elem)) continue;
                        MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
                        byte[] xml = xmlUtils.toByteArray((Element)elem);
                        ErroreApplicativo de = XMLUtils.getErroreApplicativo(log, xml);
                        return de;
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new XMLUtilsException(e.getMessage(), e);
        }
    }

    public static boolean isErroreApplicativo(byte[] doc) {
        try {
            MessageXMLUtils xmlUtils = MessageXMLUtils.DEFAULT;
            Document docXML = xmlUtils.newDocument(doc);
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isErroreApplicativo_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isErroreApplicativo(Document docXML) {
        try {
            Element elemXML = docXML.getDocumentElement();
            return XMLUtils.isErroreApplicativo_engine(elemXML);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isErroreApplicativo(Element elemXML) {
        return XMLUtils.isErroreApplicativo_engine(elemXML);
    }

    public static boolean isErroreApplicativo(Node nodeXml) {
        return XMLUtils.isErroreApplicativo_engine(nodeXml);
    }

    private static boolean isErroreApplicativo_engine(Node nodeXml) {
        try {
            return "fault".equals(nodeXml.getLocalName()) && "http://govway.org/integration/fault".equals(nodeXml.getNamespaceURI());
        }
        catch (Exception e) {
            return false;
        }
    }
}

