/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.controllo_traffico.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.commons.ISearch;
import org.openspcoop2.core.commons.Liste;
import org.openspcoop2.core.commons.Search;
import org.openspcoop2.core.commons.SearchUtils;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicy;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyFiltro;
import org.openspcoop2.core.controllo_traffico.AttivazionePolicyRaggruppamento;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneGenerale;
import org.openspcoop2.core.controllo_traffico.ConfigurazionePolicy;
import org.openspcoop2.core.controllo_traffico.ConfigurazioneRateLimitingProprieta;
import org.openspcoop2.core.controllo_traffico.IdActivePolicy;
import org.openspcoop2.core.controllo_traffico.IdPolicy;
import org.openspcoop2.core.controllo_traffico.beans.InfoPolicy;
import org.openspcoop2.core.controllo_traffico.constants.RuoloPolicy;
import org.openspcoop2.core.controllo_traffico.constants.TipoApplicabilita;
import org.openspcoop2.core.controllo_traffico.constants.TipoControlloPeriodo;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoRealtime;
import org.openspcoop2.core.controllo_traffico.constants.TipoPeriodoStatistico;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsa;
import org.openspcoop2.core.controllo_traffico.constants.TipoRisorsaPolicyAttiva;
import org.openspcoop2.core.controllo_traffico.dao.IDBAttivazionePolicyServiceSearch;
import org.openspcoop2.core.controllo_traffico.dao.IDBConfigurazionePolicyServiceSearch;
import org.openspcoop2.core.controllo_traffico.dao.jdbc.JDBCServiceManager;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.generic_project.beans.Function;
import org.openspcoop2.generic_project.beans.FunctionField;
import org.openspcoop2.generic_project.beans.IField;
import org.openspcoop2.generic_project.beans.NonNegativeNumber;
import org.openspcoop2.generic_project.dao.jdbc.utils.GenericJDBCUtilities;
import org.openspcoop2.generic_project.exception.NotFoundException;
import org.openspcoop2.generic_project.exception.ServiceException;
import org.openspcoop2.generic_project.expression.IExpression;
import org.openspcoop2.generic_project.expression.IPaginatedExpression;
import org.openspcoop2.generic_project.expression.LikeMode;
import org.openspcoop2.generic_project.expression.SortOrder;
import org.openspcoop2.generic_project.utils.ServiceManagerProperties;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.JDBCParameterUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.LikeConfig;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.slf4j.Logger;

public class ControlloTrafficoDriverUtils {
    private static String FREE_COUNTER_SEPARATOR_CHAR = "@";
    private static int FREE_COUNTER_SEPARATOR_CHAR_PAD = 19;

    public static ConfigurazioneGenerale getConfigurazioneControlloTraffico(Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getConfigurazioneControlloTraffico";
        ConfigurazioneGenerale config = null;
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            try {
                config = (ConfigurazioneGenerale)serviceManager.getConfigurazioneGeneraleServiceSearch().get();
            }
            catch (NotFoundException e) {
                throw new NotFoundException("[" + nomeMetodo + "] Configurazione non presente.");
            }
        }
        catch (Exception se) {
            throw new ServiceException("[" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        return config;
    }

    public static void updateConfigurazioneControlloTraffico(ConfigurazioneGenerale configurazioneControlloTraffico, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "updateConfigurazioneControlloTraffico";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            serviceManager.getConfigurazioneGeneraleService().update(configurazioneControlloTraffico);
        }
        catch (Exception se) {
            throw new ServiceException("[" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
    }

    public static List<Proprieta> getProprietaRateLimiting(Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getProprietaRateLimiting";
        ArrayList<Proprieta> list = new ArrayList<Proprieta>();
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            List l = serviceManager.getConfigurazioneRateLimitingProprietaServiceSearch().findAll(serviceManager.getConfigurazioneRateLimitingProprietaServiceSearch().newPaginatedExpression());
            if (l != null && !l.isEmpty()) {
                for (ConfigurazioneRateLimitingProprieta configurazioneRateLimitingProprieta : l) {
                    Proprieta p = new Proprieta();
                    p.setNome(configurazioneRateLimitingProprieta.getNome());
                    p.setValore(configurazioneRateLimitingProprieta.getValore());
                    list.add(p);
                }
            }
        }
        catch (Exception se) {
            throw new ServiceException("[" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        return list;
    }

    public static long countConfigurazioneControlloTrafficoConfigurazionePolicy(ISearch ricerca, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "countConfigurazioneControlloTrafficoConfigurazionePolicy";
        int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIGURAZIONE_POLICY;
        String search = null;
        String filterTipoPolicy = null;
        if (ricerca != null) {
            search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
            filterTipoPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroTipoPolicy");
            log.debug("search : " + search);
            log.debug("filterTipoPolicy : " + filterTipoPolicy);
        }
        long count = 0L;
        try {
            NonNegativeNumber nnn;
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expr = serviceManager.getConfigurazionePolicyServiceSearch().newExpression();
            if ("built-in".equals(filterTipoPolicy)) {
                expr.equals(ConfigurazionePolicy.model().BUILT_IN, (Object)true);
            } else if ("utente".equals(filterTipoPolicy)) {
                expr.equals(ConfigurazionePolicy.model().BUILT_IN, (Object)false);
            }
            if (search != null && !"".equals(search)) {
                expr.ilike(ConfigurazionePolicy.model().ID_POLICY, search, LikeMode.ANYWHERE);
            }
            count = (nnn = serviceManager.getConfigurazionePolicyServiceSearch().count(expr)) != null ? nnn.longValue() : 0L;
        }
        catch (Exception se) {
            throw new ServiceException("[" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        return count;
    }

    public static long countConfigurazioneControlloTrafficoAttivazionePolicy(ISearch ricerca, RuoloPolicy ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "countConfigurazioneControlloTrafficoAttivazionePolicy";
        int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ATTIVAZIONE_POLICY;
        String search = null;
        if (ricerca != null) {
            search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
        }
        long count = 0L;
        try {
            NonNegativeNumber nnn;
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expr = serviceManager.getAttivazionePolicyServiceSearch().newExpression();
            if (ruoloPorta != null && nomePorta != null) {
                expr.equals(AttivazionePolicy.model().FILTRO.RUOLO_PORTA, (Object)ruoloPorta);
                expr.equals(AttivazionePolicy.model().FILTRO.NOME_PORTA, (Object)nomePorta);
            } else {
                expr.isNull(AttivazionePolicy.model().FILTRO.NOME_PORTA);
            }
            if (search != null && !"".equals(search)) {
                expr.ilike(AttivazionePolicy.model().ID_POLICY, search, LikeMode.ANYWHERE);
            }
            count = (nnn = serviceManager.getAttivazionePolicyServiceSearch().count(expr)) != null ? nnn.longValue() : 0L;
        }
        catch (Exception se) {
            throw new ServiceException("[" + nomeMetodo + "] Exception: " + se.getMessage(), (Throwable)se);
        }
        return count;
    }

    public static List<ConfigurazionePolicy> configurazioneControlloTrafficoConfigurazionePolicyList(ISearch ricerca, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "configurazioneControlloTrafficoConfigurazionePolicyList";
        int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_CONFIGURAZIONE_POLICY;
        String search = null;
        int offset = 0;
        int limit = 0;
        if (ricerca != null) {
            search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
            limit = ricerca.getPageSize(idLista);
            offset = ricerca.getIndexIniziale(idLista);
        }
        if (limit == 0) {
            limit = 1000;
        }
        String filterTipoPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroTipoPolicy");
        log.debug("search : " + search);
        log.debug("filterTipoPolicy : " + filterTipoPolicy);
        ArrayList<ConfigurazionePolicy> listaPolicy = new ArrayList();
        long count = 0L;
        try {
            NonNegativeNumber nn;
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expr = serviceManager.getConfigurazionePolicyServiceSearch().newExpression();
            if ("built-in".equals(filterTipoPolicy)) {
                expr.equals(ConfigurazionePolicy.model().BUILT_IN, (Object)true);
            } else if ("utente".equals(filterTipoPolicy)) {
                expr.equals(ConfigurazionePolicy.model().BUILT_IN, (Object)false);
            }
            if (search != null && !"".equals(search)) {
                expr.ilike(ConfigurazionePolicy.model().ID_POLICY, search, LikeMode.ANYWHERE);
            }
            if (ricerca != null && (nn = serviceManager.getConfigurazionePolicyServiceSearch().count(expr)) != null) {
                count = nn.longValue();
            }
            IPaginatedExpression pagExpr = serviceManager.getConfigurazionePolicyServiceSearch().toPaginatedExpression(expr);
            pagExpr.offset(offset).limit(limit);
            pagExpr.sortOrder(SortOrder.ASC);
            pagExpr.addOrder(ConfigurazionePolicy.model().BUILT_IN);
            pagExpr.addOrder(ConfigurazionePolicy.model().ID_POLICY);
            listaPolicy = serviceManager.getConfigurazionePolicyServiceSearch().findAll(pagExpr);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        if (ricerca != null) {
            ricerca.setNumEntries(idLista, (int)count);
        }
        return listaPolicy;
    }

    public static List<ConfigurazionePolicy> configurazioneControlloTrafficoConfigurazionePolicyList_conApplicabilitaAllarme(String idAllarme, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "configurazioneControlloTrafficoConfigurazionePolicyList_conApplicabilitaAllarme";
        ArrayList<ConfigurazionePolicy> listaPolicy = new ArrayList();
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expr = serviceManager.getConfigurazionePolicyServiceSearch().newExpression();
            expr.equals(ConfigurazionePolicy.model().APPLICABILITA_STATO_ALLARME, (Object)true);
            expr.equals(ConfigurazionePolicy.model().ALLARME_NOME, (Object)idAllarme);
            IPaginatedExpression pagExpr = serviceManager.getConfigurazionePolicyServiceSearch().toPaginatedExpression(expr);
            pagExpr.sortOrder(SortOrder.ASC);
            pagExpr.addOrder(ConfigurazionePolicy.model().ID_POLICY);
            listaPolicy = serviceManager.getConfigurazionePolicyServiceSearch().findAll(pagExpr);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        return listaPolicy;
    }

    public static List<AttivazionePolicy> configurazioneControlloTrafficoAttivazionePolicyList(ISearch ricerca, RuoloPolicy ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws ServiceException {
        return (List)ControlloTrafficoDriverUtils._configurazioneControlloTrafficoAttivazionePolicyList(ricerca, ruoloPorta, nomePorta, con, log, tipoDB, false, "configurazioneControlloTrafficoAttivazionePolicyList", null, null, null, null, null, null, null);
    }

    public static List<AttivazionePolicy> configurazioneControlloTrafficoAttivazionePolicyListByFilter(ISearch ricerca, RuoloPolicy ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws ServiceException {
        return (List)ControlloTrafficoDriverUtils._configurazioneControlloTrafficoAttivazionePolicyList(ricerca, ruoloPorta, nomePorta, con, log, tipoDB, false, "configurazioneControlloTrafficoAttivazionePolicyListByFilter", filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
    }

    public static List<TipoRisorsaPolicyAttiva> configurazioneControlloTrafficoAttivazionePolicyTipoRisorsaList(ISearch ricerca, RuoloPolicy ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws ServiceException {
        return (List)ControlloTrafficoDriverUtils._configurazioneControlloTrafficoAttivazionePolicyList(ricerca, ruoloPorta, nomePorta, con, log, tipoDB, true, "configurazioneControlloTrafficoAttivazionePolicyTipoRisorsaList", null, null, null, null, null, null, null);
    }

    public static Object _configurazioneControlloTrafficoAttivazionePolicyList(ISearch ricerca, RuoloPolicy ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB, boolean tipoRisorsa, String nomeMetodo, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws ServiceException {
        String filterTipoRisorsaPolicy;
        int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ATTIVAZIONE_POLICY;
        String search = null;
        int offset = 0;
        int limit = 0;
        if (ricerca != null) {
            if (!tipoRisorsa) {
                search = "undefined".equals(ricerca.getSearchString(idLista)) ? "" : ricerca.getSearchString(idLista);
            }
            limit = ricerca.getPageSize(idLista);
            offset = ricerca.getIndexIniziale(idLista);
        }
        if (limit == 0) {
            limit = 1000;
        }
        TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva = null;
        if (!tipoRisorsa && ricerca != null && (filterTipoRisorsaPolicy = SearchUtils.getFilter(ricerca, idLista, "filtroTipoRisorsaPolicy")) != null && !"".equals(filterTipoRisorsaPolicy)) {
            try {
                tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.toEnumConstant(filterTipoRisorsaPolicy, true);
            }
            catch (Exception e) {
                throw new ServiceException(e.getMessage(), (Throwable)e);
            }
        }
        log.debug("search : " + search);
        log.debug("filterTipoRisorsaPolicy : " + String.valueOf(tipoRisorsaPolicyAttiva));
        ArrayList<AttivazionePolicy> listaPolicy = new ArrayList<AttivazionePolicy>();
        ArrayList<TipoRisorsaPolicyAttiva> listaTipoRisorsa = new ArrayList<TipoRisorsaPolicyAttiva>();
        long count = 0L;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            if (ricerca != null) {
                ISQLQueryObject sqlQueryObject = ControlloTrafficoDriverUtils._prepareSqlQueryObjectPolicyAttive(tipoDB, ruoloPorta, nomePorta, search, tipoRisorsaPolicyAttiva, filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
                sqlQueryObject.addSelectCountField("active_policy_id", "policies");
                String query = sqlQueryObject.createSQLQuery();
                pstmt = con.prepareStatement(query);
                ControlloTrafficoDriverUtils._prepareStatementPolicyAttive(tipoDB, (PreparedStatement)pstmt, ruoloPorta, nomePorta, search, tipoRisorsaPolicyAttiva, filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
                rs = pstmt.executeQuery();
                if (rs.next()) {
                    count = rs.getLong("policies");
                }
                rs.close();
                pstmt.close();
            }
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            ISQLQueryObject sqlQueryObject = ControlloTrafficoDriverUtils._prepareSqlQueryObjectPolicyAttive(tipoDB, ruoloPorta, nomePorta, search, tipoRisorsaPolicyAttiva, filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
            sqlQueryObject.addSelectField("ct_active_policy", "active_policy_id");
            sqlQueryObject.addSelectField("ct_active_policy", "policy_posizione");
            sqlQueryObject.addSelectField("ct_config_policy", "rt_risorsa");
            sqlQueryObject.addSelectField("ct_config_policy", "rt_simultanee");
            sqlQueryObject.setOffset(offset);
            sqlQueryObject.setLimit(limit);
            sqlQueryObject.addOrderBy("ct_config_policy.rt_risorsa", true);
            sqlQueryObject.addOrderBy("ct_config_policy.rt_simultanee", true);
            sqlQueryObject.addOrderBy("ct_active_policy.policy_posizione", true);
            String query = sqlQueryObject.createSQLQuery();
            pstmt = con.prepareStatement(query);
            ControlloTrafficoDriverUtils._prepareStatementPolicyAttive(tipoDB, (PreparedStatement)pstmt, ruoloPorta, nomePorta, search, tipoRisorsaPolicyAttiva, filtroSoggettoFruitore, filtroApplicativoFruitore, filtroRuoloFruitore, filtroSoggettoErogatore, filtroRuoloErogatore, filtroServizioAzione, filtroRuolo);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (tipoRisorsa) {
                    JDBCParameterUtilities utils;
                    boolean simultanee;
                    String risorsa = rs.getString("rt_risorsa");
                    TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttivaActivePolicy = TipoRisorsaPolicyAttiva.getTipo(risorsa, simultanee = (utils = new JDBCParameterUtilities(TipiDatabase.toEnumConstant((String)tipoDB))).readBooleanParameter(rs, "rt_simultanee").booleanValue());
                    if (listaTipoRisorsa.contains(tipoRisorsaPolicyAttivaActivePolicy)) continue;
                    listaTipoRisorsa.add(tipoRisorsaPolicyAttivaActivePolicy);
                    continue;
                }
                String idActivePolicy = rs.getString("active_policy_id");
                IdActivePolicy idActivePolicyAsObject = new IdActivePolicy();
                idActivePolicyAsObject.setNome(idActivePolicy);
                AttivazionePolicy policy = (AttivazionePolicy)serviceManager.getAttivazionePolicyServiceSearch().get(idActivePolicyAsObject);
                listaPolicy.add(policy);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            catch (Exception exception) {}
        }
        if (ricerca != null) {
            ricerca.setNumEntries(idLista, (int)count);
        }
        if (tipoRisorsa) {
            return listaTipoRisorsa;
        }
        return listaPolicy;
    }

    private static ISQLQueryObject _prepareSqlQueryObjectPolicyAttive(String tipoDB, RuoloPolicy ruoloPorta, String nomePorta, String search, TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws Exception {
        ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
        sqlQueryObject.setANDLogicOperator(true);
        sqlQueryObject.addFromTable("ct_active_policy");
        sqlQueryObject.addFromTable("ct_config_policy");
        sqlQueryObject.addWhereCondition("ct_active_policy.policy_id=ct_config_policy.policy_id");
        if (ruoloPorta != null && nomePorta != null) {
            sqlQueryObject.addWhereCondition("filtro_ruolo=?");
            sqlQueryObject.addWhereCondition("filtro_porta=?");
        } else if (ruoloPorta != null) {
            sqlQueryObject.addWhereCondition("filtro_ruolo=?");
        } else {
            sqlQueryObject.addWhereIsNullCondition("filtro_porta");
        }
        if (search != null && !"".equals(search)) {
            sqlQueryObject.addWhereCondition(false, new String[]{sqlQueryObject.getWhereLikeCondition("policy_alias", search, false, true, true)});
        }
        if (tipoRisorsaPolicyAttiva != null) {
            sqlQueryObject.addWhereCondition("ct_config_policy.rt_risorsa=?");
            sqlQueryObject.addWhereCondition("ct_config_policy.rt_simultanee=?");
        }
        if (filtroSoggettoFruitore != null) {
            if (filtroSoggettoFruitore.getTipo() != null) {
                sqlQueryObject.addWhereCondition("filtro_tipo_fruitore=?");
            }
            if (filtroSoggettoFruitore.getNome() != null) {
                sqlQueryObject.addWhereCondition("filtro_nome_fruitore=?");
            }
        }
        if (filtroApplicativoFruitore != null) {
            if (filtroApplicativoFruitore.getIdSoggettoProprietario() != null) {
                if (filtroApplicativoFruitore.getIdSoggettoProprietario().getTipo() != null) {
                    sqlQueryObject.addWhereCondition("filtro_tipo_fruitore=?");
                }
                if (filtroApplicativoFruitore.getIdSoggettoProprietario().getNome() != null) {
                    sqlQueryObject.addWhereCondition("filtro_nome_fruitore=?");
                }
            }
            if (filtroApplicativoFruitore.getNome() != null) {
                sqlQueryObject.addWhereCondition("filtro_sa_fruitore=?");
            }
        }
        if (filtroRuoloFruitore != null) {
            sqlQueryObject.addWhereCondition("filtro_ruolo_fruitore=?");
        }
        if (filtroSoggettoErogatore != null) {
            if (filtroSoggettoErogatore.getTipo() != null) {
                sqlQueryObject.addWhereCondition("filtro_tipo_erogatore=?");
            }
            if (filtroSoggettoErogatore.getNome() != null) {
                sqlQueryObject.addWhereCondition("filtro_nome_erogatore=?");
            }
        }
        if (filtroRuoloErogatore != null) {
            sqlQueryObject.addWhereCondition("filtro_ruolo_erogatore=?");
        }
        if (filtroServizioAzione != null) {
            if (filtroServizioAzione.getSoggettoErogatore() != null) {
                if (filtroServizioAzione.getSoggettoErogatore().getTipo() != null) {
                    sqlQueryObject.addWhereCondition("filtro_tipo_erogatore=?");
                }
                if (filtroServizioAzione.getSoggettoErogatore().getNome() != null) {
                    sqlQueryObject.addWhereCondition("filtro_nome_erogatore=?");
                }
            }
            if (filtroServizioAzione.getTipo() != null) {
                sqlQueryObject.addWhereCondition("filtro_tipo_servizio=?");
            }
            if (filtroServizioAzione.getNome() != null) {
                sqlQueryObject.addWhereCondition("filtro_nome_servizio=?");
            }
            if (filtroServizioAzione.getVersione() != null) {
                sqlQueryObject.addWhereCondition("filtro_versione_servizio=?");
            }
            if (filtroServizioAzione.getAzione() != null) {
                ISQLQueryObject sqlQueryObjectOr = SQLObjectFactory.createSQLQueryObject((String)tipoDB);
                sqlQueryObjectOr.setANDLogicOperator(false);
                sqlQueryObjectOr.addWhereLikeCondition("ct_active_policy.filtro_azione", filtroServizioAzione.getAzione(), false, false);
                sqlQueryObjectOr.addWhereLikeCondition("ct_active_policy.filtro_azione", filtroServizioAzione.getAzione() + ",", LikeConfig.startsWith((boolean)false));
                sqlQueryObjectOr.addWhereLikeCondition("ct_active_policy.filtro_azione", "," + filtroServizioAzione.getAzione(), LikeConfig.endsWith((boolean)false));
                sqlQueryObjectOr.addWhereLikeCondition("ct_active_policy.filtro_azione", "," + filtroServizioAzione.getAzione() + ",", true, false);
                sqlQueryObject.addWhereCondition(sqlQueryObjectOr.createSQLConditions());
            }
        }
        if (filtroRuolo != null) {
            sqlQueryObject.addWhereCondition(false, new String[]{"filtro_ruolo_fruitore=?", "filtro_ruolo_erogatore=?"});
        }
        return sqlQueryObject;
    }

    private static void _prepareStatementPolicyAttive(String tipoDB, PreparedStatement pstmt, RuoloPolicy ruoloPorta, String nomePorta, String search, TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva, IDSoggetto filtroSoggettoFruitore, IDServizioApplicativo filtroApplicativoFruitore, String filtroRuoloFruitore, IDSoggetto filtroSoggettoErogatore, String filtroRuoloErogatore, IDServizio filtroServizioAzione, String filtroRuolo) throws Exception {
        int index = 1;
        if (ruoloPorta != null && nomePorta != null) {
            pstmt.setString(index++, ruoloPorta.getValue());
            pstmt.setString(index++, nomePorta);
        } else if (ruoloPorta != null) {
            pstmt.setString(index++, ruoloPorta.getValue());
        }
        if (tipoRisorsaPolicyAttiva != null) {
            JDBCParameterUtilities utils = new JDBCParameterUtilities(TipiDatabase.toEnumConstant((String)tipoDB));
            if (TipoRisorsaPolicyAttiva.NUMERO_RICHIESTE_SIMULTANEE.equals(tipoRisorsaPolicyAttiva)) {
                pstmt.setString(index++, TipoRisorsa.NUMERO_RICHIESTE.getValue());
                utils.setParameter(pstmt, index++, (Object)true, Boolean.TYPE);
            } else {
                pstmt.setString(index++, tipoRisorsaPolicyAttiva.getValue());
                utils.setParameter(pstmt, index++, (Object)false, Boolean.TYPE);
            }
        }
        if (filtroSoggettoFruitore != null) {
            if (filtroSoggettoFruitore.getTipo() != null) {
                pstmt.setString(index++, filtroSoggettoFruitore.getTipo());
            }
            if (filtroSoggettoFruitore.getNome() != null) {
                pstmt.setString(index++, filtroSoggettoFruitore.getNome());
            }
        }
        if (filtroApplicativoFruitore != null) {
            if (filtroApplicativoFruitore.getIdSoggettoProprietario() != null) {
                if (filtroApplicativoFruitore.getIdSoggettoProprietario().getTipo() != null) {
                    pstmt.setString(index++, filtroApplicativoFruitore.getIdSoggettoProprietario().getTipo());
                }
                if (filtroApplicativoFruitore.getIdSoggettoProprietario().getNome() != null) {
                    pstmt.setString(index++, filtroApplicativoFruitore.getIdSoggettoProprietario().getNome());
                }
            }
            if (filtroApplicativoFruitore.getNome() != null) {
                pstmt.setString(index++, filtroApplicativoFruitore.getNome());
            }
        }
        if (filtroRuoloFruitore != null) {
            pstmt.setString(index++, filtroRuoloFruitore);
        }
        if (filtroSoggettoErogatore != null) {
            if (filtroSoggettoErogatore.getTipo() != null) {
                pstmt.setString(index++, filtroSoggettoErogatore.getTipo());
            }
            if (filtroSoggettoErogatore.getNome() != null) {
                pstmt.setString(index++, filtroSoggettoErogatore.getNome());
            }
        }
        if (filtroRuoloErogatore != null) {
            pstmt.setString(index++, filtroRuoloErogatore);
        }
        if (filtroServizioAzione != null) {
            if (filtroServizioAzione.getSoggettoErogatore() != null) {
                if (filtroServizioAzione.getSoggettoErogatore().getTipo() != null) {
                    pstmt.setString(index++, filtroServizioAzione.getSoggettoErogatore().getTipo());
                }
                if (filtroServizioAzione.getSoggettoErogatore().getNome() != null) {
                    pstmt.setString(index++, filtroServizioAzione.getSoggettoErogatore().getNome());
                }
            }
            if (filtroServizioAzione.getTipo() != null) {
                pstmt.setString(index++, filtroServizioAzione.getTipo());
            }
            if (filtroServizioAzione.getNome() != null) {
                pstmt.setString(index++, filtroServizioAzione.getNome());
            }
            if (filtroServizioAzione.getVersione() != null) {
                pstmt.setInt(index++, filtroServizioAzione.getVersione());
            }
            if (filtroServizioAzione.getAzione() != null) {
                // empty if block
            }
        }
        if (filtroRuolo != null) {
            pstmt.setString(index++, filtroRuolo);
            pstmt.setString(index++, filtroRuolo);
        }
    }

    public static AttivazionePolicy getAttivazionePolicy(String alias, RuoloPolicy ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "configurazioneControlloTrafficoAttivazionePolicyList";
        AttivazionePolicy policy = null;
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expr = serviceManager.getAttivazionePolicyServiceSearch().newExpression();
            expr.equals(AttivazionePolicy.model().FILTRO.RUOLO_PORTA, (Object)ruoloPorta);
            expr.equals(AttivazionePolicy.model().FILTRO.NOME_PORTA, (Object)nomePorta);
            expr.equals(AttivazionePolicy.model().ALIAS, (Object)alias);
            policy = (AttivazionePolicy)serviceManager.getAttivazionePolicyServiceSearch().find(expr);
            if (policy == null) {
                throw GenericJDBCUtilities.newNotFoundException();
            }
        }
        catch (NotFoundException notFound) {
            throw notFound;
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        return policy;
    }

    public static List<InfoPolicy> getInfoPolicyList(Boolean builtIn, String idPolicyParam, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "getInfoPolicyList";
        int offset = 0;
        int limit = 1000;
        ArrayList<InfoPolicy> listaPolicy = new ArrayList<InfoPolicy>();
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expr = serviceManager.getConfigurazionePolicyServiceSearch().newExpression();
            if (idPolicyParam != null && !"".equals(idPolicyParam)) {
                expr.equals(ConfigurazionePolicy.model().ID_POLICY, (Object)idPolicyParam);
            }
            if (builtIn != null) {
                expr.equals(ConfigurazionePolicy.model().BUILT_IN, (Object)builtIn);
            }
            IPaginatedExpression pagExpr = serviceManager.getConfigurazionePolicyServiceSearch().toPaginatedExpression(expr);
            pagExpr.offset(offset).limit(limit);
            pagExpr.sortOrder(SortOrder.ASC);
            pagExpr.addOrder(ConfigurazionePolicy.model().ID_POLICY);
            List mapList = null;
            try {
                mapList = serviceManager.getConfigurazionePolicyServiceSearch().select(pagExpr, new IField[]{ConfigurazionePolicy.model().ID_POLICY, ConfigurazionePolicy.model().RISORSA, ConfigurazionePolicy.model().BUILT_IN, ConfigurazionePolicy.model().DESCRIZIONE, ConfigurazionePolicy.model().VALORE, ConfigurazionePolicy.model().VALORE_2, ConfigurazionePolicy.model().SIMULTANEE, ConfigurazionePolicy.model().MODALITA_CONTROLLO, ConfigurazionePolicy.model().TIPO_INTERVALLO_OSSERVAZIONE_REALTIME, ConfigurazionePolicy.model().TIPO_INTERVALLO_OSSERVAZIONE_STATISTICO, ConfigurazionePolicy.model().TIPO_APPLICABILITA, ConfigurazionePolicy.model().APPLICABILITA_CON_CONGESTIONE, ConfigurazionePolicy.model().APPLICABILITA_DEGRADO_PRESTAZIONALE, ConfigurazionePolicy.model().DEGRADO_AVG_TIME_MODALITA_CONTROLLO});
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (mapList != null) {
                if (idPolicyParam != null && !"".equals(idPolicyParam) && mapList.size() > 1) {
                    throw new Exception("More than one results (" + mapList.size() + ")");
                }
                for (Map map : mapList) {
                    TipoApplicabilita tipoApplicabilita;
                    Object app;
                    Object simultanee;
                    Object v2;
                    Object v;
                    Object descr;
                    String idPolicy = (String)map.get(ConfigurazionePolicy.model().ID_POLICY.getFieldName());
                    String resource = (String)map.get(ConfigurazionePolicy.model().RISORSA.getFieldName());
                    InfoPolicy info = new InfoPolicy();
                    info.setIdPolicy(idPolicy);
                    info.setTipoRisorsa(TipoRisorsa.toEnumConstant(resource, true));
                    Object builtInValue = map.get(ConfigurazionePolicy.model().BUILT_IN.getFieldName());
                    if (builtInValue != null && builtInValue instanceof Boolean) {
                        info.setBuiltIn((Boolean)builtInValue);
                    }
                    if ((descr = map.get(ConfigurazionePolicy.model().DESCRIZIONE.getFieldName())) != null && descr instanceof String) {
                        info.setDescrizione((String)descr);
                    }
                    if ((v = map.get(ConfigurazionePolicy.model().VALORE.getFieldName())) != null && v instanceof Long) {
                        info.setValore((Long)v);
                    }
                    if ((v2 = map.get(ConfigurazionePolicy.model().VALORE_2.getFieldName())) != null && v2 instanceof Long) {
                        info.setValore2((Long)v2);
                    }
                    if ((simultanee = map.get(ConfigurazionePolicy.model().SIMULTANEE.getFieldName())) != null && simultanee instanceof Boolean) {
                        Object controllo;
                        boolean simultaneeBoolean = (Boolean)simultanee;
                        info.setCheckRichiesteSimultanee(simultaneeBoolean);
                        if (!simultaneeBoolean && (controllo = map.get(ConfigurazionePolicy.model().MODALITA_CONTROLLO.getFieldName())) != null && controllo instanceof String) {
                            Object tipoPeriodo;
                            TipoControlloPeriodo tipo = TipoControlloPeriodo.toEnumConstant((String)controllo, true);
                            info.setIntervalloUtilizzaRisorseStatistiche(TipoControlloPeriodo.STATISTIC.equals(tipo));
                            info.setIntervalloUtilizzaRisorseRealtime(TipoControlloPeriodo.REALTIME.equals(tipo));
                            if (info.isIntervalloUtilizzaRisorseStatistiche() && (tipoPeriodo = map.get(ConfigurazionePolicy.model().TIPO_INTERVALLO_OSSERVAZIONE_STATISTICO.getFieldName())) != null) {
                                info.setIntervalloUtilizzaRisorseStatisticheTipoPeriodo(TipoPeriodoStatistico.toEnumConstant((String)tipoPeriodo, true));
                            }
                            if (info.isIntervalloUtilizzaRisorseRealtime() && (tipoPeriodo = map.get(ConfigurazionePolicy.model().TIPO_INTERVALLO_OSSERVAZIONE_REALTIME.getFieldName())) != null) {
                                info.setIntervalloUtilizzaRisorseRealtimeTipoPeriodo(TipoPeriodoRealtime.toEnumConstant((String)tipoPeriodo, true));
                            }
                        }
                    }
                    if ((app = map.get(ConfigurazionePolicy.model().TIPO_APPLICABILITA.getFieldName())) != null && app instanceof String && TipoApplicabilita.CONDIZIONALE.equals(tipoApplicabilita = TipoApplicabilita.toEnumConstant((String)app, true))) {
                        Object controllo;
                        Object enabledCongestione = map.get(ConfigurazionePolicy.model().APPLICABILITA_CON_CONGESTIONE.getFieldName());
                        boolean congestione = false;
                        if (enabledCongestione != null && enabledCongestione instanceof Boolean) {
                            congestione = (Boolean)enabledCongestione;
                        }
                        if (congestione) {
                            info.setControlloCongestione(true);
                        }
                        Object enabled = map.get(ConfigurazionePolicy.model().APPLICABILITA_DEGRADO_PRESTAZIONALE.getFieldName());
                        boolean degrado = false;
                        if (enabled != null && enabled instanceof Boolean) {
                            degrado = (Boolean)enabled;
                        }
                        if (degrado && (controllo = map.get(ConfigurazionePolicy.model().DEGRADO_AVG_TIME_MODALITA_CONTROLLO.getFieldName())) != null && controllo instanceof String) {
                            TipoControlloPeriodo tipo = TipoControlloPeriodo.toEnumConstant((String)controllo, true);
                            info.setDegradoPrestazionaleUtilizzaRisorseStatistiche(TipoControlloPeriodo.STATISTIC.equals(tipo));
                            info.setDegradoPrestazionaleUtilizzaRisorseRealtime(TipoControlloPeriodo.REALTIME.equals(tipo));
                            info.setDegradoPrestazione(true);
                        }
                    }
                    listaPolicy.add(info);
                }
            }
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        return listaPolicy;
    }

    public static List<AttivazionePolicy> findInUseAttivazioni(String idPolicy, boolean escludiDisabilitate, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "findInUseAttivazioni";
        int offset = 0;
        int limit = 10000;
        ArrayList<AttivazionePolicy> listaPolicy = new ArrayList();
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expr = serviceManager.getAttivazionePolicyServiceSearch().newExpression();
            expr.equals(AttivazionePolicy.model().ID_POLICY, (Object)idPolicy);
            if (escludiDisabilitate) {
                expr.equals(AttivazionePolicy.model().ENABLED, (Object)true);
            }
            IPaginatedExpression pagExpr = serviceManager.getAttivazionePolicyServiceSearch().toPaginatedExpression(expr);
            pagExpr.offset(offset).limit(limit);
            pagExpr.sortOrder(SortOrder.ASC);
            pagExpr.addOrder(AttivazionePolicy.model().ALIAS);
            pagExpr.addOrder(AttivazionePolicy.model().ID_POLICY);
            listaPolicy = serviceManager.getAttivazionePolicyServiceSearch().findAll(pagExpr);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        return listaPolicy;
    }

    public static long countInUseAttivazioni(String idPolicy, boolean escludiDisabilitate, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "countInUseAttivazioni";
        try {
            NonNegativeNumber nnn;
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expr = serviceManager.getAttivazionePolicyServiceSearch().newExpression();
            expr.equals(AttivazionePolicy.model().ID_POLICY, (Object)idPolicy);
            if (escludiDisabilitate) {
                expr.equals(AttivazionePolicy.model().ENABLED, (Object)true);
            }
            return (nnn = serviceManager.getAttivazionePolicyServiceSearch().count(expr)) != null ? nnn.longValue() : 0L;
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static ConfigurazionePolicy getConfigurazionePolicy(long id, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getConfigurazionePolicy";
        ConfigurazionePolicy policy = null;
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            policy = (ConfigurazionePolicy)((IDBConfigurazionePolicyServiceSearch)serviceManager.getConfigurazionePolicyServiceSearch()).get(id);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("[" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        return policy;
    }

    public static ConfigurazionePolicy getConfigurazionePolicy(String nomePolicy, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getConfigurazionePolicy";
        ConfigurazionePolicy policy = null;
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IdPolicy id = new IdPolicy();
            id.setNome(nomePolicy);
            policy = (ConfigurazionePolicy)serviceManager.getConfigurazionePolicyServiceSearch().get(id);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("[" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        return policy;
    }

    public static void createConfigurazionePolicy(ConfigurazionePolicy policy, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "createConfigurazionePolicy";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            serviceManager.getConfigurazionePolicyService().create(policy);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void createAttivazionePolicy(AttivazionePolicy policy, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "createAttivazionePolicy";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            serviceManager.getAttivazionePolicyService().create(policy);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void updateConfigurazionePolicy(ConfigurazionePolicy policy, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "updateConfigurazionePolicy";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IdPolicy idToUpdate = new IdPolicy();
            if (policy.getOldIdPolicy() != null) {
                idToUpdate.setNome(policy.getOldIdPolicy().getNome());
            } else {
                idToUpdate.setNome(policy.getIdPolicy());
            }
            List<AttivazionePolicy> listPolicyAttiveConStatoDisabilitato = ControlloTrafficoDriverUtils.findInUseAttivazioni(idToUpdate.getNome(), true, con, log, tipoDB);
            if (listPolicyAttiveConStatoDisabilitato != null && listPolicyAttiveConStatoDisabilitato.size() > 0) {
                IdActivePolicy idActivePolicy;
                HashMap<String, Boolean> mapStati = new HashMap<String, Boolean>();
                for (AttivazionePolicy ap : listPolicyAttiveConStatoDisabilitato) {
                    idActivePolicy = new IdActivePolicy();
                    idActivePolicy.setNome(ap.getIdActivePolicy());
                    mapStati.put(ap.getIdActivePolicy(), ap.isEnabled());
                    ap.setEnabled(false);
                    serviceManager.getAttivazionePolicyService().update(idActivePolicy, ap);
                }
                for (AttivazionePolicy ap : listPolicyAttiveConStatoDisabilitato) {
                    idActivePolicy = new IdActivePolicy();
                    idActivePolicy.setNome(ap.getIdActivePolicy());
                    ap.setEnabled((Boolean)mapStati.get(ap.getIdActivePolicy()));
                    serviceManager.getAttivazionePolicyService().update(idActivePolicy, ap);
                }
            }
            serviceManager.getConfigurazionePolicyService().update(idToUpdate, policy);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("[" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void updateAttivazionePolicy(AttivazionePolicy policy, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "updateAttivazionePolicy";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IdActivePolicy id = new IdActivePolicy();
            id.setNome(policy.getIdActivePolicy());
            serviceManager.getAttivazionePolicyService().update(id, policy);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("[" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void deleteConfigurazionePolicy(ConfigurazionePolicy policy, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "deleteConfigurazionePolicy";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            serviceManager.getConfigurazionePolicyService().delete(policy);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void deleteAttivazionePolicy(AttivazionePolicy policy, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "deleteAttivazionePolicy";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            serviceManager.getAttivazionePolicyService().delete(policy);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static AttivazionePolicy getAttivazionePolicy(long id, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getAttivazionePolicy";
        AttivazionePolicy policy = null;
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            policy = (AttivazionePolicy)((IDBAttivazionePolicyServiceSearch)serviceManager.getAttivazionePolicyServiceSearch()).get(id);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("[" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        return policy;
    }

    public static AttivazionePolicy getAttivazionePolicy(String nomePolicy, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getAttivazionePolicy";
        AttivazionePolicy policy = null;
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IdActivePolicy idPolicy = new IdActivePolicy();
            idPolicy.setNome(nomePolicy);
            policy = (AttivazionePolicy)serviceManager.getAttivazionePolicyServiceSearch().get(idPolicy);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("[" + nomeMetodo + "] Configurazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
        return policy;
    }

    public static String buildIdActivePolicy(String idPolicy, String serialId) {
        String idActive = idPolicy + FREE_COUNTER_SEPARATOR_CHAR + serialId;
        return idActive;
    }

    private static String normalizePolicyInstanceSerialId(int value) {
        return StringUtils.leftPad((String)("" + value), (int)FREE_COUNTER_SEPARATOR_CHAR_PAD, (String)"0");
    }

    public static String incrementPolicyInstanceSerialId(String value) {
        int valueInt = 0;
        if (value != null && !"".equals(value)) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if ('0' == c && sb.length() <= 0) continue;
                sb.append(c);
            }
            valueInt = Integer.valueOf(sb.toString());
        }
        return StringUtils.leftPad((String)("" + ++valueInt), (int)FREE_COUNTER_SEPARATOR_CHAR_PAD, (String)"0");
    }

    public static String getNextPolicyInstanceSerialId(String policyId, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "getNextPolicyInstanceSerialId";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression pagExpr = serviceManager.getAttivazionePolicyServiceSearch().newExpression();
            pagExpr.and();
            pagExpr.equals(AttivazionePolicy.model().ID_POLICY, (Object)policyId);
            FunctionField ff = new FunctionField(AttivazionePolicy.model().ID_ACTIVE_POLICY, Function.MAX, "maxIdActivePolicy");
            Object maxValue = null;
            try {
                maxValue = serviceManager.getAttivazionePolicyServiceSearch().aggregate(pagExpr, ff);
            }
            catch (NotFoundException notFoundException) {
                // empty catch block
            }
            if (maxValue != null && maxValue instanceof String) {
                String s = (String)maxValue;
                if (s.contains(FREE_COUNTER_SEPARATOR_CHAR)) {
                    int last = s.lastIndexOf(FREE_COUNTER_SEPARATOR_CHAR);
                    if (last < s.length() - 1) {
                        String actualMaxValue = s.substring(s.lastIndexOf(FREE_COUNTER_SEPARATOR_CHAR) + 1, s.length());
                        return ControlloTrafficoDriverUtils.incrementPolicyInstanceSerialId(actualMaxValue);
                    }
                } else {
                    pagExpr.like(AttivazionePolicy.model().ID_ACTIVE_POLICY, FREE_COUNTER_SEPARATOR_CHAR, LikeMode.ANYWHERE);
                    maxValue = null;
                    try {
                        maxValue = serviceManager.getAttivazionePolicyServiceSearch().aggregate(pagExpr, ff);
                    }
                    catch (NotFoundException last) {
                        // empty catch block
                    }
                    if (maxValue != null && maxValue instanceof String && (s = (String)maxValue).contains(FREE_COUNTER_SEPARATOR_CHAR) && (last = s.lastIndexOf(FREE_COUNTER_SEPARATOR_CHAR)) < s.length() - 1) {
                        String actualMaxValue = s.substring(s.lastIndexOf(FREE_COUNTER_SEPARATOR_CHAR) + 1, s.length());
                        return ControlloTrafficoDriverUtils.incrementPolicyInstanceSerialId(actualMaxValue);
                    }
                }
            }
            return ControlloTrafficoDriverUtils.normalizePolicyInstanceSerialId(1);
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static AttivazionePolicy getPolicy(String policyId, AttivazionePolicyFiltro filtroParam, AttivazionePolicyRaggruppamento groupBy, RuoloPolicy ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getPolicy";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expression = serviceManager.getAttivazionePolicyServiceSearch().newExpression();
            expression.and();
            expression.equals(AttivazionePolicy.model().ID_POLICY, (Object)policyId);
            AttivazionePolicyFiltro filtro = filtroParam;
            if (ruoloPorta != null && nomePorta != null) {
                filtro.setEnabled(true);
                filtro.setRuoloPorta(ruoloPorta);
                filtro.setNomePorta(nomePorta);
            } else {
                expression.isNull(AttivazionePolicy.model().FILTRO.NOME_PORTA);
            }
            expression.equals(AttivazionePolicy.model().FILTRO.ENABLED, (Object)filtro.isEnabled());
            if (filtro.isEnabled()) {
                if (filtro.getRuoloPorta() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.RUOLO_PORTA, (Object)filtro.getRuoloPorta());
                } else {
                    expression.equals(AttivazionePolicy.model().FILTRO.RUOLO_PORTA, (Object)RuoloPolicy.ENTRAMBI);
                }
                if (filtro.getNomePorta() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.NOME_PORTA, (Object)filtro.getNomePorta());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.NOME_PORTA);
                }
                if (filtro.getProtocollo() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.PROTOCOLLO, (Object)filtro.getProtocollo());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.PROTOCOLLO);
                }
                if (filtro.getRuoloErogatore() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.RUOLO_EROGATORE, (Object)filtro.getRuoloErogatore());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.RUOLO_EROGATORE);
                }
                if (filtro.getTipoErogatore() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.TIPO_EROGATORE, (Object)filtro.getTipoErogatore());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.TIPO_EROGATORE);
                }
                if (filtro.getNomeErogatore() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.NOME_EROGATORE, (Object)filtro.getNomeErogatore());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.NOME_EROGATORE);
                }
                if (filtro.getTag() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.TAG, (Object)filtro.getTag());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.TAG);
                }
                if (filtro.getTipoServizio() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.TIPO_SERVIZIO, (Object)filtro.getTipoServizio());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.TIPO_SERVIZIO);
                }
                if (filtro.getNomeServizio() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.NOME_SERVIZIO, (Object)filtro.getNomeServizio());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.NOME_SERVIZIO);
                }
                if (filtro.getVersioneServizio() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.VERSIONE_SERVIZIO, (Object)filtro.getVersioneServizio());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.VERSIONE_SERVIZIO);
                }
                if (filtro.getAzione() != null && !"".equals(filtro.getAzione())) {
                    expression.like(AttivazionePolicy.model().FILTRO.AZIONE, filtro.getAzione(), LikeMode.EXACT);
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.AZIONE);
                }
                if (filtro.getServizioApplicativoErogatore() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.SERVIZIO_APPLICATIVO_EROGATORE, (Object)filtro.getServizioApplicativoErogatore());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.SERVIZIO_APPLICATIVO_EROGATORE);
                }
                if (filtro.getRuoloFruitore() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.RUOLO_FRUITORE, (Object)filtro.getRuoloFruitore());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.RUOLO_FRUITORE);
                }
                if (filtro.getTipoFruitore() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.TIPO_FRUITORE, (Object)filtro.getTipoFruitore());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.TIPO_FRUITORE);
                }
                if (filtro.getNomeFruitore() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.NOME_FRUITORE, (Object)filtro.getNomeFruitore());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.NOME_FRUITORE);
                }
                if (filtro.getServizioApplicativoFruitore() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.SERVIZIO_APPLICATIVO_FRUITORE, (Object)filtro.getServizioApplicativoFruitore());
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.SERVIZIO_APPLICATIVO_FRUITORE);
                }
                if (filtro.getTokenClaims() != null) {
                    expression.like(AttivazionePolicy.model().FILTRO.TOKEN_CLAIMS, filtro.getTokenClaims(), LikeMode.EXACT);
                } else {
                    expression.isNull(AttivazionePolicy.model().FILTRO.TOKEN_CLAIMS);
                }
                expression.equals(AttivazionePolicy.model().FILTRO.INFORMAZIONE_APPLICATIVA_ENABLED, (Object)filtro.isInformazioneApplicativaEnabled());
                if (filtro.isInformazioneApplicativaEnabled() && filtro.getInformazioneApplicativaTipo() != null && filtro.getInformazioneApplicativaNome() != null && filtro.getInformazioneApplicativaValore() != null) {
                    expression.equals(AttivazionePolicy.model().FILTRO.INFORMAZIONE_APPLICATIVA_TIPO, (Object)filtro.getInformazioneApplicativaTipo());
                    expression.like(AttivazionePolicy.model().FILTRO.INFORMAZIONE_APPLICATIVA_NOME, filtro.getInformazioneApplicativaNome(), LikeMode.EXACT);
                    expression.like(AttivazionePolicy.model().FILTRO.INFORMAZIONE_APPLICATIVA_VALORE, filtro.getInformazioneApplicativaValore(), LikeMode.EXACT);
                }
            }
            expression.equals(AttivazionePolicy.model().GROUP_BY.ENABLED, (Object)groupBy.isEnabled());
            if (groupBy.isEnabled()) {
                expression.equals(AttivazionePolicy.model().GROUP_BY.RUOLO_PORTA, (Object)groupBy.isRuoloPorta());
                expression.equals(AttivazionePolicy.model().GROUP_BY.PROTOCOLLO, (Object)groupBy.isProtocollo());
                expression.equals(AttivazionePolicy.model().GROUP_BY.EROGATORE, (Object)groupBy.isErogatore());
                expression.equals(AttivazionePolicy.model().GROUP_BY.SERVIZIO, (Object)groupBy.isServizio());
                expression.equals(AttivazionePolicy.model().GROUP_BY.AZIONE, (Object)groupBy.isAzione());
                expression.equals(AttivazionePolicy.model().GROUP_BY.SERVIZIO_APPLICATIVO_EROGATORE, (Object)groupBy.isServizioApplicativoErogatore());
                expression.equals(AttivazionePolicy.model().GROUP_BY.FRUITORE, (Object)groupBy.isFruitore());
                expression.equals(AttivazionePolicy.model().GROUP_BY.SERVIZIO_APPLICATIVO_FRUITORE, (Object)groupBy.isServizioApplicativoFruitore());
                expression.equals(AttivazionePolicy.model().GROUP_BY.IDENTIFICATIVO_AUTENTICATO, (Object)groupBy.isIdentificativoAutenticato());
                if (groupBy.getToken() == null) {
                    expression.isNull(AttivazionePolicy.model().GROUP_BY.TOKEN);
                } else {
                    expression.like(AttivazionePolicy.model().GROUP_BY.TOKEN, groupBy.getToken(), LikeMode.EXACT);
                }
                expression.equals(AttivazionePolicy.model().GROUP_BY.INFORMAZIONE_APPLICATIVA_ENABLED, (Object)groupBy.isInformazioneApplicativaEnabled());
                if (groupBy.isInformazioneApplicativaEnabled() && groupBy.getInformazioneApplicativaTipo() != null && groupBy.getInformazioneApplicativaNome() != null) {
                    expression.equals(AttivazionePolicy.model().GROUP_BY.INFORMAZIONE_APPLICATIVA_TIPO, (Object)groupBy.getInformazioneApplicativaTipo());
                    expression.like(AttivazionePolicy.model().GROUP_BY.INFORMAZIONE_APPLICATIVA_NOME, groupBy.getInformazioneApplicativaNome(), LikeMode.EXACT);
                }
            }
            return (AttivazionePolicy)serviceManager.getAttivazionePolicyServiceSearch().find(expression);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("[" + nomeMetodo + "] Attivazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static AttivazionePolicy getPolicyByAlias(String alias, RuoloPolicy ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getPolicyByAlias";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expression = serviceManager.getAttivazionePolicyServiceSearch().newExpression();
            expression.and();
            expression.ilike(AttivazionePolicy.model().ALIAS, alias, LikeMode.EXACT);
            if (ruoloPorta != null && nomePorta != null) {
                expression.equals(AttivazionePolicy.model().FILTRO.ENABLED, (Object)true);
                expression.equals(AttivazionePolicy.model().FILTRO.RUOLO_PORTA, (Object)ruoloPorta);
                expression.equals(AttivazionePolicy.model().FILTRO.NOME_PORTA, (Object)nomePorta);
            } else {
                expression.isNull(AttivazionePolicy.model().FILTRO.NOME_PORTA);
            }
            return (AttivazionePolicy)serviceManager.getAttivazionePolicyServiceSearch().find(expression);
        }
        catch (NotFoundException e) {
            throw new NotFoundException("[" + nomeMetodo + "] Attivazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static List<AttivazionePolicy> getPolicyByServizioApplicativo(IDServizioApplicativo idServizioApplicativo, Connection con, Logger log, String tipoDB) throws ServiceException, NotFoundException {
        String nomeMetodo = "getPolicyByServizioApplicativo";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IPaginatedExpression expression = serviceManager.getAttivazionePolicyServiceSearch().newPaginatedExpression();
            expression.limit(100000);
            expression.or();
            HashMap<IField, String> propertyNameValuesFruitore = new HashMap<IField, String>();
            propertyNameValuesFruitore.put(AttivazionePolicy.model().FILTRO.TIPO_FRUITORE, idServizioApplicativo.getIdSoggettoProprietario().getTipo());
            propertyNameValuesFruitore.put(AttivazionePolicy.model().FILTRO.NOME_FRUITORE, idServizioApplicativo.getIdSoggettoProprietario().getNome());
            propertyNameValuesFruitore.put(AttivazionePolicy.model().FILTRO.SERVIZIO_APPLICATIVO_FRUITORE, idServizioApplicativo.getNome());
            expression.allEquals(propertyNameValuesFruitore, true);
            HashMap<IField, String> propertyNameValuesErogatore = new HashMap<IField, String>();
            propertyNameValuesErogatore.put(AttivazionePolicy.model().FILTRO.TIPO_EROGATORE, idServizioApplicativo.getIdSoggettoProprietario().getTipo());
            propertyNameValuesErogatore.put(AttivazionePolicy.model().FILTRO.NOME_EROGATORE, idServizioApplicativo.getIdSoggettoProprietario().getNome());
            propertyNameValuesErogatore.put(AttivazionePolicy.model().FILTRO.SERVIZIO_APPLICATIVO_EROGATORE, idServizioApplicativo.getNome());
            expression.allEquals(propertyNameValuesErogatore, true);
            List l = serviceManager.getAttivazionePolicyServiceSearch().findAll(expression);
            if (l == null || l.isEmpty()) {
                throw new NotFoundException("Non presenti");
            }
            return l;
        }
        catch (NotFoundException e) {
            throw new NotFoundException("[" + nomeMetodo + "] Attivazione Policy non presente.");
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static boolean usedInConfigurazioneControlloTrafficoAttivazionePolicy(RuoloPolicy ruoloPorta, String nomePorta, String azione, Connection con, Logger log, String tipoDB) throws ServiceException {
        String nomeMetodo = "usedInConfigurazioneControlloTrafficoAttivazionePolicy";
        try {
            ServiceManagerProperties properties = new ServiceManagerProperties();
            properties.setDatabaseType(tipoDB);
            properties.setShowSql(true);
            JDBCServiceManager serviceManager = new JDBCServiceManager(con, properties, log);
            IExpression expr = serviceManager.getAttivazionePolicyServiceSearch().newExpression();
            if (ruoloPorta != null && nomePorta != null) {
                expr.equals(AttivazionePolicy.model().FILTRO.RUOLO_PORTA, (Object)ruoloPorta);
                expr.equals(AttivazionePolicy.model().FILTRO.NOME_PORTA, (Object)nomePorta);
            }
            expr.like(AttivazionePolicy.model().FILTRO.AZIONE, azione, LikeMode.ANYWHERE);
            IPaginatedExpression pagExpr = serviceManager.getAttivazionePolicyServiceSearch().toPaginatedExpression(expr);
            pagExpr.offset(0).limit(1000);
            pagExpr.sortOrder(SortOrder.ASC);
            pagExpr.addOrder(AttivazionePolicy.model().ALIAS);
            pagExpr.addOrder(AttivazionePolicy.model().ID_POLICY);
            List list = serviceManager.getAttivazionePolicyServiceSearch().findAll(pagExpr);
            if (list == null || list.isEmpty()) {
                return false;
            }
            for (AttivazionePolicy attivazionePolicy : list) {
                String[] tmp;
                if (attivazionePolicy.getFiltro() == null || attivazionePolicy.getFiltro().getAzione() == null) continue;
                String checkAz = attivazionePolicy.getFiltro().getAzione();
                if (azione.equals(checkAz)) {
                    return true;
                }
                if (!checkAz.contains(",") || (tmp = checkAz.split(",")) == null || tmp.length <= 0) continue;
                for (int i = 0; i < tmp.length; ++i) {
                    if (!azione.equals(tmp[i])) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception qe) {
            throw new ServiceException("[" + nomeMetodo + "] Errore : " + qe.getMessage(), (Throwable)qe);
        }
    }

    public static void updatePosizioneAttivazionePolicy(InfoPolicy infoPolicy, AttivazionePolicy policy, RuoloPolicy ruoloPorta, String nomePorta, Connection con, Logger log, String tipoDB) throws Exception {
        int idLista = Liste.CONFIGURAZIONE_CONTROLLO_TRAFFICO_ATTIVAZIONE_POLICY;
        Search ricercaTipoRisorsa = new Search(true);
        TipoRisorsaPolicyAttiva tipoRisorsaPolicyAttiva = TipoRisorsaPolicyAttiva.getTipo(infoPolicy.getTipoRisorsa(), infoPolicy.isCheckRichiesteSimultanee());
        ricercaTipoRisorsa.addFilter(idLista, "filtroTipoRisorsaPolicy", tipoRisorsaPolicyAttiva.getValue());
        List<AttivazionePolicy> listaPolicyConTipoRisorsa = ControlloTrafficoDriverUtils.configurazioneControlloTrafficoAttivazionePolicyList(ricercaTipoRisorsa, ruoloPorta, nomePorta, con, log, tipoDB);
        int posizione = 1;
        if (listaPolicyConTipoRisorsa != null && !listaPolicyConTipoRisorsa.isEmpty()) {
            for (AttivazionePolicy check : listaPolicyConTipoRisorsa) {
                if (check.getPosizione() < posizione) continue;
                posizione = check.getPosizione() + 1;
            }
        }
        policy.setPosizione(posizione);
    }
}

