/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.constants;

import org.openspcoop2.utils.UtilsException;

public enum TransferLengthModes {
    TRANSFER_ENCODING_CHUNKED("transfer-encoding-chunked"),
    CONTENT_LENGTH("content-length"),
    WEBSERVER_DEFAULT("webserver-default");

    private final String nome;

    private TransferLengthModes(String nome) {
        this.nome = nome;
    }

    public String getNome() {
        return this.nome;
    }

    public static TransferLengthModes getTransferLengthModes(String value) throws UtilsException {
        if (TRANSFER_ENCODING_CHUNKED.toString().equals(value)) {
            return TRANSFER_ENCODING_CHUNKED;
        }
        if (CONTENT_LENGTH.toString().equals(value)) {
            return CONTENT_LENGTH;
        }
        if (WEBSERVER_DEFAULT.toString().equals(value)) {
            return WEBSERVER_DEFAULT;
        }
        throw new UtilsException("Unknown type '" + value + "' (supported values: " + TransferLengthModes.stringValues() + "): " + value);
    }

    public static String stringValues() {
        StringBuilder res = new StringBuilder();
        int i = 0;
        for (TransferLengthModes tmp : TransferLengthModes.values()) {
            if (i > 0) {
                res.append(",");
            }
            res.append(tmp.getNome());
            ++i;
        }
        return res.toString();
    }

    public static String[] toStringArray() {
        String[] res = new String[TransferLengthModes.values().length];
        int i = 0;
        for (TransferLengthModes tmp : TransferLengthModes.values()) {
            res[i] = tmp.getNome();
            ++i;
        }
        return res;
    }

    public String toString() {
        return this.nome;
    }

    public boolean equals(String tlm) {
        if (tlm == null) {
            return false;
        }
        return this.toString().equals(tlm);
    }
}

