/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openspcoop2.core.commons.CoreException;
import org.openspcoop2.core.commons.IMonitoraggioRisorsa;
import org.openspcoop2.core.config.AccessoConfigurazione;
import org.openspcoop2.core.config.AccessoDatiAttributeAuthority;
import org.openspcoop2.core.config.AccessoDatiAutenticazione;
import org.openspcoop2.core.config.AccessoDatiAutorizzazione;
import org.openspcoop2.core.config.AccessoDatiConsegnaApplicativi;
import org.openspcoop2.core.config.AccessoDatiGestioneToken;
import org.openspcoop2.core.config.AccessoDatiKeystore;
import org.openspcoop2.core.config.AccessoDatiRichieste;
import org.openspcoop2.core.config.AccessoRegistro;
import org.openspcoop2.core.config.CanaliConfigurazione;
import org.openspcoop2.core.config.Configurazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazione;
import org.openspcoop2.core.config.ConfigurazioneUrlInvocazioneRegola;
import org.openspcoop2.core.config.GenericProperties;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.Openspcoop2;
import org.openspcoop2.core.config.PortaApplicativa;
import org.openspcoop2.core.config.PortaApplicativaServizioApplicativo;
import org.openspcoop2.core.config.PortaDelegata;
import org.openspcoop2.core.config.RegistroPlugin;
import org.openspcoop2.core.config.RegistroPluginArchivio;
import org.openspcoop2.core.config.RegistroPlugins;
import org.openspcoop2.core.config.RoutingTable;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.StatoServiziPdd;
import org.openspcoop2.core.config.SystemProperties;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaSoggetto;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.PortaApplicativaAzioneIdentificazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.BeanUtilities;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteApplicative;
import org.openspcoop2.core.config.driver.FiltroRicercaPorteDelegate;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.config.driver.FiltroRicercaSoggetti;
import org.openspcoop2.core.config.driver.IDServizioUtils;
import org.openspcoop2.core.config.driver.IDriverConfigurazioneGet;
import org.openspcoop2.core.config.driver.ValidazioneSemantica;
import org.openspcoop2.core.config.utils.serializer.JaxbDeserializer;
import org.openspcoop2.core.id.IDConnettore;
import org.openspcoop2.core.id.IDPortaApplicativa;
import org.openspcoop2.core.id.IDPortaDelegata;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.core.id.IdentificativiErogazione;
import org.openspcoop2.core.id.IdentificativiFruizione;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.xml.ValidatoreXSD;
import org.openspcoop2.utils.LoggerWrapperFactory;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.transport.http.HttpResponse;
import org.openspcoop2.utils.transport.http.HttpUtilities;
import org.slf4j.Logger;

public class DriverConfigurazioneXML
extends BeanUtilities
implements IDriverConfigurazioneGet,
IMonitoraggioRisorsa {
    public boolean create = false;
    private String configuration_path;
    private Openspcoop2 openspcoop;
    private ValidatoreXSD validatoreConfigurazione = null;
    private long lastModified = 0L;
    private Logger log = null;
    private static final int timeoutRefresh = 30;
    private static boolean buildXsdValidator = true;
    private boolean validazioneSemanticaDuranteModificaXML = false;
    private String[] tipiConnettori = null;
    private String[] tipiSoggetti = null;
    private String[] tipiServiziSoap = null;
    private String[] tipiServiziRest = null;
    private String[] tipoMsgDiagnosticiAppender = null;
    private String[] tipoTracciamentoAppender = null;
    private String[] tipoDumpAppender = null;
    private String[] tipoAutenticazionePortaDelegata = null;
    private String[] tipoAutenticazionePortaApplicativa = null;
    private String[] tipoAutorizzazionePortaDelegata = null;
    private String[] tipoAutorizzazionePortaApplicativa = null;
    private String[] tipoAutorizzazioneContenutoPortaDelegata = null;
    private String[] tipoAutorizzazioneContenutoPortaApplicativa = null;
    private String[] tipoIntegrazionePD = null;
    private String[] tipoIntegrazionePA = null;

    private void parsingXMLConfigurazione() throws DriverConfigurazioneException {
        if (buildXsdValidator) {
            FileInputStream fXML = null;
            try {
                if (this.configuration_path.startsWith("http://") || this.configuration_path.startsWith("file://")) {
                    this.validatoreConfigurazione.valida(this.configuration_path);
                } else {
                    fXML = new FileInputStream(this.configuration_path);
                    this.validatoreConfigurazione.valida((InputStream)fXML);
                }
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante la validazione XSD della configurazione XML di OpenSPCoop: " + e.getMessage());
            }
            finally {
                if (fXML != null) {
                    try {
                        fXML.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        InputStream iStream = null;
        if (this.configuration_path.startsWith("http://") || this.configuration_path.startsWith("file://")) {
            block35: {
                try {
                    HttpResponse response = HttpUtilities.getHTTPResponse((String)this.configuration_path);
                    if (response == null) {
                        throw new UtilsException("Response null");
                    }
                    if (response.getContentStream() != null) {
                        iStream = response.getContentStream();
                        break block35;
                    }
                    if (response.getContent() != null && response.getContent().length > 0) {
                        iStream = new ByteArrayInputStream(response.getContent());
                        break block35;
                    }
                    throw new UtilsException("Response empty");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream della configurazione (HTTP) : \n\n" + e.getMessage());
                }
            }
            this.lastModified = DateManager.getTimeMillis();
        } else {
            try {
                iStream = new FileInputStream(this.configuration_path);
            }
            catch (FileNotFoundException e) {
                throw new DriverConfigurazioneException("Riscontrato errore durante la creazione dell'inputStream della configurazione (FILE) : \n\n" + e.getMessage());
            }
            try {
                this.lastModified = new File(this.configuration_path).lastModified();
            }
            catch (Exception e) {
                try {
                    iStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new DriverConfigurazioneException("Riscontrato errore durante la lettura del file dove e' allocato la configurazione: " + e.getMessage());
            }
        }
        try {
            JaxbDeserializer deserializer = new JaxbDeserializer();
            this.openspcoop = deserializer.readOpenspcoop2(iStream);
        }
        catch (Exception e) {
            try {
                if (iStream != null) {
                    iStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new DriverConfigurazioneException("Riscontrato errore durante l'unmarshall del file di configurazione: " + e.getMessage());
        }
        try {
            if (iStream != null) {
                iStream.close();
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("Riscontrato errore durante la chiusura dell'Input Stream: " + e.getMessage());
        }
    }

    public static void disableBuildXsdValidator() {
        buildXsdValidator = false;
    }

    public DriverConfigurazioneXML(String path, Logger alog) {
        this.log = alog == null ? LoggerWrapperFactory.getLogger(DriverConfigurazioneXML.class) : alog;
        if (path == null) {
            this.log.error("DriverConfigurazione: Riscontrato errore durante la creazione: url/path is null");
            this.create = false;
            return;
        }
        this.configuration_path = path;
        try {
            if (buildXsdValidator) {
                this.validatoreConfigurazione = new ValidatoreXSD(OpenSPCoop2MessageFactory.getDefaultMessageFactory(), this.log, DriverConfigurazioneXML.class.getResourceAsStream("/config.xsd"));
            }
        }
        catch (Exception e) {
            this.log.info("Riscontrato errore durante l'inizializzazione dello schema della configurazione di OpenSPCoop: " + e.getMessage(), (Throwable)e);
            return;
        }
        try {
            this.parsingXMLConfigurazione();
        }
        catch (Exception e) {
            this.log.error("DriverConfigurazione: " + e.getMessage(), (Throwable)e);
            this.create = false;
            return;
        }
        this.create = true;
    }

    private void forzaRefreshConfigurazioneXML() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML(true);
    }

    public void refreshConfigurazioneXML() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML(false);
    }

    private synchronized void refreshConfigurazioneXML(boolean refreshForzato) throws DriverConfigurazioneException {
        File fTest = null;
        boolean refresh = refreshForzato;
        if (!refreshForzato) {
            if (this.configuration_path.startsWith("http://") || this.configuration_path.startsWith("file://")) {
                long now = DateManager.getTimeMillis();
                if (now - this.lastModified > 30000L) {
                    refresh = true;
                }
            } else {
                fTest = new File(this.configuration_path);
                if (this.lastModified != fTest.lastModified()) {
                    refresh = true;
                }
            }
        }
        if (refresh) {
            try {
                this.parsingXMLConfigurazione();
            }
            catch (Exception e) {
                this.log.error("DriverConfigurazione refreshError: " + e.getMessage());
                throw new DriverConfigurazioneException("DriverConfigurazione refreshError: " + e.getMessage());
            }
            if (!this.configuration_path.startsWith("http://") && !this.configuration_path.startsWith("file://")) {
                this.log.warn("Reloaded configuration context.");
            }
            if (this.validazioneSemanticaDuranteModificaXML) {
                ValidazioneSemantica validazioneSemantica = new ValidazioneSemantica(this.openspcoop, this.tipiConnettori, this.tipiSoggetti, this.tipiServiziSoap, this.tipiServiziRest, this.tipoMsgDiagnosticiAppender, this.tipoTracciamentoAppender, this.tipoDumpAppender, this.tipoAutenticazionePortaDelegata, this.tipoAutenticazionePortaApplicativa, this.tipoAutorizzazionePortaDelegata, this.tipoAutorizzazionePortaApplicativa, this.tipoAutorizzazioneContenutoPortaDelegata, this.tipoAutorizzazioneContenutoPortaApplicativa, this.tipoIntegrazionePD, this.tipoIntegrazionePA, true, this.log);
                try {
                    validazioneSemantica.validazioneSemantica(false);
                }
                catch (Exception e) {
                    this.log.error("DriverConfigurazione refreshError(ValidazioneSemantica): " + e.getMessage());
                    throw new DriverConfigurazioneException("DriverConfigurazione refreshError(ValidazioneSemantica): " + e.getMessage());
                }
            }
        }
        if (this.openspcoop == null) {
            this.log.error("DriverConfigurazione refreshError: istanza della configurazione is null dopo il refresh");
            throw new DriverConfigurazioneException("DriverConfigurazione refreshError: istanza della configurazione is null dopo il refresh");
        }
    }

    public void abilitazioneValidazioneSemanticaDuranteModificaXML(String[] tipiConnettori, String[] tipiSoggetti, String[] tipiServiziSoap, String[] tipiServiziRest, String[] tipoMsgDiagnosticiAppender, String[] tipoTracciamentoAppender, String[] tipoDumpAppender, String[] tipoAutenticazionePortaDelegata, String[] tipoAutenticazionePortaApplicativa, String[] tipoAutorizzazionePortaDelegata, String[] tipoAutorizzazionePortaApplicativa, String[] tipoAutorizzazioneContenutoPortaDelegata, String[] tipoAutorizzazioneContenutoPortaApplicativa, String[] tipoIntegrazionePD, String[] tipoIntegrazionePA) {
        this.validazioneSemanticaDuranteModificaXML = true;
        this.tipiConnettori = tipiConnettori;
        this.tipiSoggetti = tipiSoggetti;
        this.tipiServiziSoap = tipiServiziSoap;
        this.tipiServiziRest = tipiServiziRest;
        this.tipoMsgDiagnosticiAppender = tipoMsgDiagnosticiAppender;
        this.tipoTracciamentoAppender = tipoTracciamentoAppender;
        this.tipoDumpAppender = tipoDumpAppender;
        this.tipoAutenticazionePortaDelegata = tipoAutenticazionePortaDelegata;
        this.tipoAutenticazionePortaApplicativa = tipoAutenticazionePortaApplicativa;
        this.tipoAutorizzazionePortaDelegata = tipoAutorizzazionePortaDelegata;
        this.tipoAutorizzazionePortaApplicativa = tipoAutorizzazionePortaApplicativa;
        this.tipoAutorizzazioneContenutoPortaDelegata = tipoAutorizzazioneContenutoPortaDelegata;
        this.tipoAutorizzazioneContenutoPortaApplicativa = tipoAutorizzazioneContenutoPortaApplicativa;
        this.tipoIntegrazionePD = tipoIntegrazionePD;
        this.tipoIntegrazionePA = tipoIntegrazionePA;
    }

    @Override
    public Soggetto getSoggetto(IDSoggetto aSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aSoggetto == null || aSoggetto.getNome() == null || aSoggetto.getTipo() == null) {
            throw new DriverConfigurazioneException("[getSoggetto] Parametri Non Validi");
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            if (!aSoggetto.getNome().equals(soggetto.getNome()) || !aSoggetto.getTipo().equals(soggetto.getTipo())) continue;
            return soggetto;
        }
        throw new DriverConfigurazioneNotFound("[getSoggetto] Soggetto " + aSoggetto.toString() + " non Esistente");
    }

    @Override
    public Soggetto getRouter() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            if (!this.openspcoop.getSoggetto(i).getRouter()) continue;
            return this.openspcoop.getSoggetto(i);
        }
        throw new DriverConfigurazioneNotFound("[getRouter] Router non esistente");
    }

    @Override
    public List<IDSoggetto> getSoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDSoggetto> lista = new ArrayList<IDSoggetto>();
        try {
            for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
                Soggetto soggetto = this.openspcoop.getSoggetto(i);
                for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    IDSoggetto soggettoVirtuale;
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    if (pa.getSoggettoVirtuale() == null || pa.getSoggettoVirtuale().getTipo() == null || pa.getSoggettoVirtuale().getNome() == null || lista.contains(soggettoVirtuale = new IDSoggetto(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome()))) continue;
                    this.log.info("aggiunto Soggetto " + String.valueOf(soggettoVirtuale) + " alla lista dei Soggetti Virtuali");
                    lista.add(soggettoVirtuale);
                }
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("[getSoggettiVirtuali] Inizializzazione lista dei soggetti virtuali non riuscita: " + e.getMessage());
        }
        if (lista.size() == 0) {
            throw new DriverConfigurazioneNotFound("[getSoggettiVirtuali] Soggetti virtuali non esistenti");
        }
        return lista;
    }

    @Override
    public List<IDServizio> getServiziSoggettiVirtuali() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDServizio> lista = new ArrayList<IDServizio>();
        HashSet<String> unique = new HashSet<String>();
        try {
            for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
                Soggetto soggetto = this.openspcoop.getSoggetto(i);
                for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                    IDServizio s;
                    PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                    if (pa.getSoggettoVirtuale() == null || pa.getSoggettoVirtuale().getTipo() == null || pa.getSoggettoVirtuale().getNome() == null || unique.contains((s = IDServizioUtils.buildIDServizio(pa.getServizio().getTipo(), pa.getServizio().getNome(), new IDSoggetto(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome()), pa.getServizio().getVersione())).toString())) continue;
                    lista.add(s);
                    unique.add(s.toString());
                }
            }
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException("[getServiziSoggettiVirtuali] Inizializzazione lista servizi dei soggetti virtuali non riuscita: " + e.getMessage());
        }
        if (lista.isEmpty()) {
            throw new DriverConfigurazioneNotFound("[getServiziSoggettiVirtuali] Servizi erogati da Soggetti virtuali non esistenti");
        }
        return lista;
    }

    @Override
    public List<IDSoggetto> getAllIdSoggetti(FiltroRicercaSoggetti filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDSoggetto> listIDSoggetti = new ArrayList<IDSoggetto>();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    if (soggetto.getOraRegistrazione() == null) {
                        this.log.debug("[getAllIdSoggetti](FiltroByMinDate) Soggetto [" + soggetto.getTipo() + "/" + soggetto.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                        continue;
                    }
                    if (soggetto.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    if (soggetto.getOraRegistrazione() == null) {
                        this.log.debug("[getAllIdSoggetti](FiltroByMaxDate) Soggetto [" + soggetto.getTipo() + "/" + soggetto.getNome() + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                        continue;
                    }
                    if (soggetto.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                }
                if (filtroRicerca.getTipo() != null && !soggetto.getTipo().equals(filtroRicerca.getTipo()) || filtroRicerca.getNome() != null && !soggetto.getNome().equals(filtroRicerca.getNome())) continue;
            }
            listIDSoggetti.add(new IDSoggetto(soggetto.getTipo(), soggetto.getNome()));
        }
        if (listIDSoggetti.size() <= 0) {
            if (filtroRicerca != null) {
                throw new DriverConfigurazioneNotFound("Soggetti non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverConfigurazioneNotFound("Soggetti non trovati");
        }
        return listIDSoggetti;
    }

    private IDPortaDelegata convertToIDPortaDelegata(PortaDelegata pd) throws DriverConfigurazioneException {
        IDPortaDelegata idPD = new IDPortaDelegata();
        idPD.setNome(pd.getNome());
        IdentificativiFruizione idFruizione = new IdentificativiFruizione();
        IDSoggetto soggettoFruitore = new IDSoggetto(pd.getTipoSoggettoProprietario(), pd.getNomeSoggettoProprietario());
        idFruizione.setSoggettoFruitore(soggettoFruitore);
        try {
            IDServizio idServizio = IDServizioUtils.buildIDServizio(pd.getServizio().getTipo(), pd.getServizio().getNome(), new IDSoggetto(pd.getSoggettoErogatore().getTipo(), pd.getSoggettoErogatore().getNome()), pd.getServizio().getVersione());
            if (pd.getAzione() != null && pd.getAzione().getNome() != null && !"".equals(pd.getAzione().getNome())) {
                idServizio.setAzione(pd.getAzione().getNome());
            }
            idFruizione.setIdServizio(idServizio);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
        idPD.setIdentificativiFruizione(idFruizione);
        return idPD;
    }

    @Override
    public IDPortaDelegata getIDPortaDelegata(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (nome == null) {
            throw new DriverConfigurazioneException("[getIDPortaDelegata] Parametro Non Validi");
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                PortaDelegata pd = soggetto.getPortaDelegata(j);
                if (!nome.equals(pd.getNome())) continue;
                pd.setTipoSoggettoProprietario(soggetto.getTipo());
                pd.setNomeSoggettoProprietario(soggetto.getNome());
                return this.convertToIDPortaDelegata(pd);
            }
        }
        throw new DriverConfigurazioneNotFound("Porta Delegata [" + nome + "] non esistente");
    }

    @Override
    public PortaDelegata getPortaDelegata(IDPortaDelegata idPD) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPD == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata] Parametro idPD Non Validi");
        }
        String nome = idPD.getNome();
        if (nome == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata] Parametri non Validi");
        }
        IDPortaDelegata id = this.getIDPortaDelegata(nome);
        IDSoggetto soggettoProprietario = id.getIdentificativiFruizione().getSoggettoFruitore();
        Soggetto soggetto = null;
        try {
            soggetto = this.getSoggetto(soggettoProprietario);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[getPortaDelegata] Soggetto fruitore [" + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + "] non esistente");
        }
        for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
            PortaDelegata pd = soggetto.getPortaDelegata(j);
            if (!nome.equals(pd.getNome())) continue;
            pd.setTipoSoggettoProprietario(soggetto.getTipo());
            pd.setNomeSoggettoProprietario(soggetto.getNome());
            return pd;
        }
        throw new DriverConfigurazioneNotFound("PortaDelegata [" + nome + "] non esistente");
    }

    @Override
    public List<IDPortaDelegata> getAllIdPorteDelegate(FiltroRicercaPorteDelegate filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDPortaDelegata> listIDPorteDelegate = new ArrayList<IDPortaDelegata>();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggetto.sizePortaDelegataList(); ++j) {
                PortaDelegata pd = soggetto.getPortaDelegata(j);
                String id = pd.getNome();
                if (filtroRicerca != null) {
                    TrasformazioneRegola regola;
                    int z;
                    boolean contains;
                    boolean porteDelegatePerAzioni = false;
                    if (filtroRicerca.getNomePortaDelegante() != null) {
                        porteDelegatePerAzioni = true;
                    }
                    if (filtroRicerca.getMinDate() != null) {
                        if (pd.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDelegate](FiltroByMinDate) PortaDelegata [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pd.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (soggetto.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteDelegate](FiltroByMaxDate) PortaDelegata [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (soggetto.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipoSoggetto() != null && !soggetto.getTipo().equals(filtroRicerca.getTipoSoggetto()) || filtroRicerca.getNomeSoggetto() != null && !soggetto.getNome().equals(filtroRicerca.getNomeSoggetto()) || filtroRicerca.getTipoSoggettoErogatore() != null && !pd.getSoggettoErogatore().getTipo().equals(filtroRicerca.getTipoSoggettoErogatore()) || filtroRicerca.getNomeSoggettoErogatore() != null && (pd.getSoggettoErogatore().getNome() == null || !pd.getSoggettoErogatore().getNome().equals(filtroRicerca.getNomeSoggettoErogatore())) || filtroRicerca.getTipoServizio() != null && !pd.getServizio().getTipo().equals(filtroRicerca.getTipoServizio()) || filtroRicerca.getNomeServizio() != null && (pd.getServizio().getNome() == null || !pd.getServizio().getNome().equals(filtroRicerca.getNomeServizio())) || filtroRicerca.getVersioneServizio() != null && (pd.getServizio().getVersione() == null || pd.getServizio().getVersione().intValue() != filtroRicerca.getVersioneServizio().intValue()) || !porteDelegatePerAzioni && filtroRicerca.getAzione() != null && (pd.getAzione().getNome() == null || !pd.getAzione().getNome().equals(filtroRicerca.getAzione()))) continue;
                    if (filtroRicerca.getIdRuolo() != null && filtroRicerca.getIdRuolo().getNome() != null) {
                        if (pd.getRuoli() == null) continue;
                        contains = false;
                        for (z = 0; z < pd.getRuoli().sizeRuoloList(); ++z) {
                            if (!filtroRicerca.getIdRuolo().getNome().equals(pd.getRuoli().getRuolo(z).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getIdScope() != null && filtroRicerca.getIdScope().getNome() != null) {
                        if (pd.getScope() == null) continue;
                        contains = false;
                        for (z = 0; z < pd.getScope().sizeScopeList(); ++z) {
                            if (!filtroRicerca.getIdScope().getNome().equals(pd.getScope().getScope(z).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getNomeServizioApplicativo() != null) {
                        if (pd.sizeServizioApplicativoList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pd.sizeServizioApplicativoList(); ++z) {
                            if (!filtroRicerca.getNomeServizioApplicativo().equals(pd.getServizioApplicativo(z).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getNomeServizioApplicativoToken() != null) {
                        if (pd.getAutorizzazioneToken() == null || pd.getAutorizzazioneToken().getServiziApplicativi() == null || pd.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pd.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList(); ++z) {
                            if (!filtroRicerca.getNomeServizioApplicativoToken().equals(pd.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativo(z).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getIdRuoloToken() != null && filtroRicerca.getIdRuoloToken().getNome() != null) {
                        if (pd.getAutorizzazioneToken() == null || pd.getAutorizzazioneToken().getRuoli() == null || pd.getAutorizzazioneToken().getRuoli().sizeRuoloList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pd.getAutorizzazioneToken().getRuoli().sizeRuoloList(); ++z) {
                            if (!filtroRicerca.getIdRuoloToken().getNome().equals(pd.getAutorizzazioneToken().getRuoli().getRuolo(z).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getNomeServizioApplicativoRiferitoApplicabilitaTrasformazione() != null) {
                        if (pd.getTrasformazioni() == null || pd.getTrasformazioni().sizeRegolaList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pd.getTrasformazioni().sizeRegolaList(); ++z) {
                            regola = pd.getTrasformazioni().getRegola(z);
                            if (regola.getApplicabilita() == null || regola.getApplicabilita().sizeServizioApplicativoList() <= 0) continue;
                            for (TrasformazioneRegolaApplicabilitaServizioApplicativo tSA : regola.getApplicabilita().getServizioApplicativoList()) {
                                if (!filtroRicerca.getNomeServizioApplicativoRiferitoApplicabilitaTrasformazione().equals(tSA.getNome())) continue;
                                contains = true;
                                break;
                            }
                            if (contains) break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getNomeServizioApplicativoTokenRiferitoApplicabilitaTrasformazione() != null) {
                        if (pd.getTrasformazioni() == null || pd.getTrasformazioni().sizeRegolaList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pd.getTrasformazioni().sizeRegolaList(); ++z) {
                            regola = pd.getTrasformazioni().getRegola(z);
                            if (regola.getApplicabilita() == null || regola.getApplicabilita().sizeServizioApplicativoList() <= 0) continue;
                            for (TrasformazioneRegolaApplicabilitaServizioApplicativo tSA : regola.getApplicabilita().getServizioApplicativoList()) {
                                if (!filtroRicerca.getNomeServizioApplicativoTokenRiferitoApplicabilitaTrasformazione().equals(tSA.getNome())) continue;
                                contains = true;
                                break;
                            }
                            if (contains) break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getStato() != null && (pd.getStato() != null ? !pd.getStato().equals(filtroRicerca.getStato()) : !StatoFunzionalita.ABILITATO.equals(filtroRicerca.getStato()))) continue;
                    if (porteDelegatePerAzioni && (pd.getAzione() == null || pd.getAzione().getNomePortaDelegante() == null || !pd.getAzione().getNomePortaDelegante().equals(filtroRicerca.getNomePortaDelegante()) || filtroRicerca.getAzione() != null && (pd.getAzione().getAzioneDelegataList().size() <= 0 || !pd.getAzione().getAzioneDelegataList().contains(filtroRicerca.getAzione())))) continue;
                }
                pd.setTipoSoggettoProprietario(soggetto.getTipo());
                pd.setNomeSoggettoProprietario(soggetto.getNome());
                listIDPorteDelegate.add(this.convertToIDPortaDelegata(pd));
            }
        }
        if (listIDPorteDelegate.size() <= 0) {
            if (filtroRicerca != null) {
                throw new DriverConfigurazioneNotFound("PorteDelegate non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverConfigurazioneNotFound("PorteDelegate non trovate");
        }
        return listIDPorteDelegate;
    }

    private IDPortaApplicativa convertToIDPortaApplicativa(PortaApplicativa pa) throws DriverConfigurazioneException {
        IDPortaApplicativa idPA = new IDPortaApplicativa();
        idPA.setNome(pa.getNome());
        IdentificativiErogazione idErogazione = new IdentificativiErogazione();
        if (pa.getSoggettoVirtuale() != null) {
            IDSoggetto soggettoVirtuale = new IDSoggetto(pa.getSoggettoVirtuale().getTipo(), pa.getSoggettoVirtuale().getNome());
            idErogazione.setSoggettoVirtuale(soggettoVirtuale);
        }
        try {
            IDServizio idServizio = IDServizioUtils.buildIDServizio(pa.getServizio().getTipo(), pa.getServizio().getNome(), new IDSoggetto(pa.getTipoSoggettoProprietario(), pa.getNomeSoggettoProprietario()), pa.getServizio().getVersione());
            if (pa.getAzione() != null && pa.getAzione().getNome() != null && !"".equals(pa.getAzione().getNome())) {
                idServizio.setAzione(pa.getAzione().getNome());
            }
            idErogazione.setIdServizio(idServizio);
        }
        catch (Exception e) {
            throw new DriverConfigurazioneException(e.getMessage(), e);
        }
        idPA.setIdentificativiErogazione(idErogazione);
        return idPA;
    }

    @Override
    public IDPortaApplicativa getIDPortaApplicativa(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (nome == null) {
            throw new DriverConfigurazioneException("[getIDPortaApplicativa] Parametro Non Validi");
        }
        this.refreshConfigurazioneXML();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                if (!nome.equals(pa.getNome())) continue;
                pa.setTipoSoggettoProprietario(soggetto.getTipo());
                pa.setNomeSoggettoProprietario(soggetto.getNome());
                return this.convertToIDPortaApplicativa(pa);
            }
        }
        throw new DriverConfigurazioneNotFound("Porta Applicativa [" + nome + "] non esistente");
    }

    @Override
    public PortaApplicativa getPortaApplicativa(IDPortaApplicativa idPA) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idPA == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametro idPA Non Validi");
        }
        String nome = idPA.getNome();
        if (nome == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri non Validi");
        }
        IDPortaApplicativa id = this.getIDPortaApplicativa(nome);
        IDSoggetto soggettoProprietario = id.getIdentificativiErogazione().getIdServizio().getSoggettoErogatore();
        Soggetto soggetto = null;
        try {
            soggetto = this.getSoggetto(soggettoProprietario);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Soggetto fruitore [" + soggettoProprietario.getTipo() + "/" + soggettoProprietario.getNome() + "] non esistente");
        }
        for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
            PortaApplicativa pa = soggetto.getPortaApplicativa(j);
            if (!nome.equals(pa.getNome())) continue;
            pa.setTipoSoggettoProprietario(soggetto.getTipo());
            pa.setNomeSoggettoProprietario(soggetto.getNome());
            return pa;
        }
        throw new DriverConfigurazioneNotFound("PortaApplicativa [" + nome + "] non esistente");
    }

    @Override
    public List<PortaApplicativa> getPorteApplicative(IDServizio idServizio, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEnginePorteApplicative_engine(idServizio, null, ricercaPuntuale);
    }

    @Override
    public List<PortaApplicativa> getPorteApplicativeVirtuali(IDSoggetto soggettoVirtuale, IDServizio idServizio, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEnginePorteApplicative_engine(idServizio, soggettoVirtuale, ricercaPuntuale);
    }

    private List<PortaApplicativa> getEnginePorteApplicative_engine(IDServizio service, IDSoggetto soggettoVirtuale, boolean ricercaPuntuale) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (service == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametro idServizio non definito");
        }
        IDSoggetto soggettoErogatore = service.getSoggettoErogatore();
        if (soggettoErogatore == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri non validi (Soggetto Erogatore is null)");
        }
        String servizio = service.getNome();
        String tipoServizio = service.getTipo();
        Integer versioneServizio = service.getVersione();
        String azione = service.getAzione();
        if (servizio == null || tipoServizio == null || versioneServizio == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri (Servizio) non validi");
        }
        Soggetto soggetto = null;
        try {
            soggetto = this.getSoggetto(soggettoErogatore);
        }
        catch (DriverConfigurazioneNotFound dn) {
            throw new DriverConfigurazioneNotFound("[getPortaApplicativa] " + dn.getMessage(), dn);
        }
        catch (Exception dn) {
            // empty catch block
        }
        if (soggetto == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Soggetto erogatore [" + soggettoErogatore.getTipo() + "/" + soggettoErogatore.getNome() + "] non esistente");
        }
        if (soggettoVirtuale != null && (soggettoVirtuale.getTipo() == null || soggettoVirtuale.getNome() == null)) {
            throw new DriverConfigurazioneException("[getPortaApplicativa] Parametri (Soggetto Virtuale) non validi");
        }
        ArrayList<PortaApplicativa> paSenzaAzioneList = new ArrayList<PortaApplicativa>();
        ArrayList<PortaApplicativa> paList = new ArrayList<PortaApplicativa>();
        for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
            PortaApplicativa pa = soggetto.getPortaApplicativa(j);
            boolean paMatchaCriteriDiRicerca = false;
            if (soggettoVirtuale == null) {
                paMatchaCriteriDiRicerca = servizio.equals(pa.getServizio().getNome()) && tipoServizio.equals(pa.getServizio().getTipo()) && versioneServizio.intValue() == pa.getServizio().getVersione().intValue();
            } else {
                boolean bl = paMatchaCriteriDiRicerca = servizio.equals(pa.getServizio().getNome()) && tipoServizio.equals(pa.getServizio().getTipo()) && versioneServizio.intValue() == pa.getServizio().getVersione().intValue() && pa.getSoggettoVirtuale() != null && soggettoVirtuale.getTipo().equals(pa.getSoggettoVirtuale().getTipo()) && soggettoVirtuale.getNome().equals(pa.getSoggettoVirtuale().getNome());
            }
            if (paMatchaCriteriDiRicerca && pa.getAzione() != null && PortaApplicativaAzioneIdentificazione.DELEGATED_BY.equals(pa.getAzione().getIdentificazione())) {
                paMatchaCriteriDiRicerca = false;
            }
            if (!paMatchaCriteriDiRicerca) continue;
            if (azione == null) {
                if (pa.getAzione() != null) continue;
                pa.setTipoSoggettoProprietario(soggetto.getTipo());
                pa.setNomeSoggettoProprietario(soggetto.getNome());
                paList.add(pa);
                continue;
            }
            if (pa.getAzione() == null) {
                PortaApplicativa paSenzaAzione = pa;
                paSenzaAzione.setTipoSoggettoProprietario(soggetto.getTipo());
                paSenzaAzione.setNomeSoggettoProprietario(soggetto.getNome());
                paSenzaAzioneList.add(paSenzaAzione);
                continue;
            }
            if (!azione.equals(pa.getAzione().getNome())) continue;
            pa.setTipoSoggettoProprietario(soggetto.getTipo());
            pa.setNomeSoggettoProprietario(soggetto.getNome());
            paList.add(pa);
        }
        if (paList.size() > 0) {
            return paList;
        }
        if (paSenzaAzioneList.size() > 0 && !ricercaPuntuale) {
            return paSenzaAzioneList;
        }
        throw new DriverConfigurazioneNotFound("PorteApplicative non esistenti");
    }

    @Override
    public Map<IDSoggetto, PortaApplicativa> getPorteApplicativeSoggettiVirtuali(IDServizio idServizio) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idServizio == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro idServizio non valido");
        }
        if (idServizio.getSoggettoErogatore() == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametro Soggetto Erogatore non valido");
        }
        this.refreshConfigurazioneXML();
        HashMap<IDSoggetto, PortaApplicativa> paConSoggetti = new HashMap<IDSoggetto, PortaApplicativa>();
        IDSoggetto soggettoVirtuale = idServizio.getSoggettoErogatore();
        String servizio = idServizio.getNome();
        String tipoServizio = idServizio.getTipo();
        Integer versioneServizio = idServizio.getVersione();
        String azione = idServizio.getAzione();
        if (servizio == null || tipoServizio == null || versioneServizio == null) {
            throw new DriverConfigurazioneException("[getPortaApplicativa_SoggettiVirtuali] Parametri (Servizio) Non Validi");
        }
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto aSoggetto = this.openspcoop.getSoggetto(i);
            PortaApplicativa paSenzaAzione = null;
            for (int j = 0; j < aSoggetto.sizePortaApplicativaList(); ++j) {
                PortaApplicativa pa = aSoggetto.getPortaApplicativa(j);
                if (pa.getSoggettoVirtuale() == null || !pa.getSoggettoVirtuale().getTipo().equals(soggettoVirtuale.getTipo()) || !pa.getSoggettoVirtuale().getNome().equals(soggettoVirtuale.getNome()) || !servizio.equals(pa.getServizio().getNome()) || !tipoServizio.equals(pa.getServizio().getTipo()) || versioneServizio.intValue() != pa.getServizio().getVersione().intValue()) continue;
                if (azione == null) {
                    if (pa.getAzione() != null) continue;
                    for (k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                        paConSoggetti.put(new IDSoggetto(aSoggetto.getTipo(), aSoggetto.getNome()), pa);
                    }
                } else {
                    if (pa.getAzione() == null) {
                        paSenzaAzione = pa;
                        continue;
                    }
                    if (!azione.equals(pa.getAzione().getNome())) continue;
                    for (k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                        paConSoggetti.put(new IDSoggetto(aSoggetto.getTipo(), aSoggetto.getNome()), pa);
                        paSenzaAzione = null;
                    }
                }
                break;
            }
            if (paSenzaAzione == null) continue;
            paConSoggetti.put(new IDSoggetto(aSoggetto.getTipo(), aSoggetto.getNome()), paSenzaAzione);
        }
        if (paConSoggetti.size() == 0) {
            throw new DriverConfigurazioneNotFound("[getPortaApplicativa_SoggettiVirtuali] Porte applicative di soggetti virtuali non esistenti.");
        }
        return paConSoggetti;
    }

    @Override
    public List<IDPortaApplicativa> getAllIdPorteApplicative(FiltroRicercaPorteApplicative filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDPortaApplicativa> listIDPorteApplicative = new ArrayList<IDPortaApplicativa>();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                String id = pa.getNome();
                if (filtroRicerca != null) {
                    TrasformazioneRegola regola;
                    int z;
                    boolean contains;
                    boolean porteDelegatePerAzioni = false;
                    if (filtroRicerca.getNomePortaDelegante() != null) {
                        porteDelegatePerAzioni = true;
                    }
                    if (filtroRicerca.getMinDate() != null) {
                        if (pa.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteApplicative](FiltroByMinDate) PortaApplicativa [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (pa.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (soggetto.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteApplicative](FiltroByMaxDate) PortaApplicativa [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (soggetto.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipoSoggetto() != null && !soggetto.getTipo().equals(filtroRicerca.getTipoSoggetto()) || filtroRicerca.getNomeSoggetto() != null && !soggetto.getNome().equals(filtroRicerca.getNomeSoggetto()) || filtroRicerca.getTipoServizio() != null && !pa.getServizio().getTipo().equals(filtroRicerca.getTipoServizio()) || filtroRicerca.getNomeServizio() != null && (pa.getServizio().getNome() == null || !pa.getServizio().getNome().equals(filtroRicerca.getNomeServizio())) || filtroRicerca.getVersioneServizio() != null && (pa.getServizio().getVersione() == null || pa.getServizio().getVersione().intValue() != filtroRicerca.getVersioneServizio().intValue()) || !porteDelegatePerAzioni && filtroRicerca.getAzione() != null && (pa.getAzione().getNome() == null || !pa.getAzione().getNome().equals(filtroRicerca.getAzione()))) continue;
                    if (filtroRicerca.getIdRuolo() != null && filtroRicerca.getIdRuolo().getNome() != null) {
                        if (pa.getRuoli() == null) continue;
                        contains = false;
                        for (z = 0; z < pa.getRuoli().sizeRuoloList(); ++z) {
                            if (!filtroRicerca.getIdRuolo().getNome().equals(pa.getRuoli().getRuolo(z).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getIdScope() != null && filtroRicerca.getIdScope().getNome() != null) {
                        if (pa.getScope() == null) continue;
                        contains = false;
                        for (z = 0; z < pa.getScope().sizeScopeList(); ++z) {
                            if (!filtroRicerca.getIdScope().getNome().equals(pa.getScope().getScope(z).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getIdSoggettoAutorizzato() != null && (filtroRicerca.getIdSoggettoAutorizzato().getTipo() != null || filtroRicerca.getIdSoggettoAutorizzato().getNome() != null)) {
                        if (pa.getSoggetti() == null || pa.getSoggetti().sizeSoggettoList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pa.getSoggetti().sizeSoggettoList(); ++z) {
                            if (filtroRicerca.getIdSoggettoAutorizzato().getTipo() != null && !filtroRicerca.getIdSoggettoAutorizzato().getTipo().equals(pa.getSoggetti().getSoggetto(z).getTipo()) || filtroRicerca.getIdSoggettoAutorizzato().getNome() != null && !filtroRicerca.getIdSoggettoAutorizzato().getNome().equals(pa.getSoggetti().getSoggetto(z).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getIdServizioApplicativoAutorizzato() != null && filtroRicerca.getIdServizioApplicativoAutorizzato().getNome() != null && filtroRicerca.getIdServizioApplicativoAutorizzato().getIdSoggettoProprietario() != null && filtroRicerca.getIdServizioApplicativoAutorizzato().getIdSoggettoProprietario().getTipo() != null && filtroRicerca.getIdServizioApplicativoAutorizzato().getIdSoggettoProprietario().getNome() != null) {
                        if (pa.getServiziApplicativiAutorizzati() == null || pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pa.getServiziApplicativiAutorizzati().sizeServizioApplicativoList(); ++z) {
                            if (!filtroRicerca.getIdServizioApplicativoAutorizzato().getNome().equals(pa.getServiziApplicativiAutorizzati().getServizioApplicativo(z).getNome()) || !filtroRicerca.getIdServizioApplicativoAutorizzato().getIdSoggettoProprietario().getTipo().equals(pa.getServiziApplicativiAutorizzati().getServizioApplicativo(z).getTipoSoggettoProprietario()) || !filtroRicerca.getIdServizioApplicativoAutorizzato().getIdSoggettoProprietario().getNome().equals(pa.getServiziApplicativiAutorizzati().getServizioApplicativo(z).getNomeSoggettoProprietario())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getIdSoggettoRiferitoApplicabilitaTrasformazione() != null && (filtroRicerca.getIdSoggettoRiferitoApplicabilitaTrasformazione().getTipo() != null || filtroRicerca.getIdSoggettoRiferitoApplicabilitaTrasformazione().getNome() != null)) {
                        if (pa.getTrasformazioni() == null || pa.getTrasformazioni().sizeRegolaList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pa.getTrasformazioni().sizeRegolaList(); ++z) {
                            regola = pa.getTrasformazioni().getRegola(z);
                            if (regola.getApplicabilita() == null || regola.getApplicabilita().sizeSoggettoList() <= 0) continue;
                            for (TrasformazioneRegolaApplicabilitaSoggetto tSoggetto : regola.getApplicabilita().getSoggettoList()) {
                                if (filtroRicerca.getIdSoggettoRiferitoApplicabilitaTrasformazione().getTipo() != null && !filtroRicerca.getIdSoggettoRiferitoApplicabilitaTrasformazione().getTipo().equals(tSoggetto.getTipo()) || filtroRicerca.getIdSoggettoRiferitoApplicabilitaTrasformazione().getNome() != null && !filtroRicerca.getIdSoggettoRiferitoApplicabilitaTrasformazione().getNome().equals(tSoggetto.getNome())) continue;
                                contains = true;
                                break;
                            }
                            if (contains) break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getIdServizioApplicativoAutorizzatoToken() != null && filtroRicerca.getIdServizioApplicativoAutorizzatoToken().getNome() != null && filtroRicerca.getIdServizioApplicativoAutorizzatoToken().getIdSoggettoProprietario() != null && filtroRicerca.getIdServizioApplicativoAutorizzatoToken().getIdSoggettoProprietario().getTipo() != null && filtroRicerca.getIdServizioApplicativoAutorizzatoToken().getIdSoggettoProprietario().getNome() != null) {
                        if (pa.getAutorizzazioneToken() == null || pa.getAutorizzazioneToken().getServiziApplicativi() == null || pa.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pa.getAutorizzazioneToken().getServiziApplicativi().sizeServizioApplicativoList(); ++z) {
                            if (!filtroRicerca.getIdServizioApplicativoAutorizzatoToken().getNome().equals(pa.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativo(z).getNome()) || !filtroRicerca.getIdServizioApplicativoAutorizzatoToken().getIdSoggettoProprietario().getTipo().equals(pa.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativo(z).getTipoSoggettoProprietario()) || !filtroRicerca.getIdServizioApplicativoAutorizzatoToken().getIdSoggettoProprietario().getNome().equals(pa.getAutorizzazioneToken().getServiziApplicativi().getServizioApplicativo(z).getNomeSoggettoProprietario())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getIdRuoloToken() != null && filtroRicerca.getIdRuoloToken().getNome() != null) {
                        if (pa.getAutorizzazioneToken() == null || pa.getAutorizzazioneToken().getRuoli() == null || pa.getAutorizzazioneToken().getRuoli().sizeRuoloList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pa.getAutorizzazioneToken().getRuoli().sizeRuoloList(); ++z) {
                            if (!filtroRicerca.getIdRuoloToken().getNome().equals(pa.getAutorizzazioneToken().getRuoli().getRuolo(z).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getIdServizioApplicativoRiferitoApplicabilitaTrasformazione() != null && filtroRicerca.getIdServizioApplicativoRiferitoApplicabilitaTrasformazione().getNome() != null && filtroRicerca.getIdServizioApplicativoRiferitoApplicabilitaTrasformazione().getIdSoggettoProprietario() != null && filtroRicerca.getIdServizioApplicativoRiferitoApplicabilitaTrasformazione().getIdSoggettoProprietario().getTipo() != null && filtroRicerca.getIdServizioApplicativoRiferitoApplicabilitaTrasformazione().getIdSoggettoProprietario().getNome() != null) {
                        if (pa.getTrasformazioni() == null || pa.getTrasformazioni().sizeRegolaList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pa.getTrasformazioni().sizeRegolaList(); ++z) {
                            regola = pa.getTrasformazioni().getRegola(z);
                            if (regola.getApplicabilita() == null || regola.getApplicabilita().sizeServizioApplicativoList() <= 0) continue;
                            for (TrasformazioneRegolaApplicabilitaServizioApplicativo tSA : regola.getApplicabilita().getServizioApplicativoList()) {
                                if (!filtroRicerca.getIdServizioApplicativoRiferitoApplicabilitaTrasformazione().getNome().equals(tSA.getNome()) || !filtroRicerca.getIdServizioApplicativoRiferitoApplicabilitaTrasformazione().getIdSoggettoProprietario().getTipo().equals(tSA.getTipoSoggettoProprietario()) || !filtroRicerca.getIdServizioApplicativoRiferitoApplicabilitaTrasformazione().getIdSoggettoProprietario().getNome().equals(tSA.getNomeSoggettoProprietario())) continue;
                                contains = true;
                                break;
                            }
                            if (contains) break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getIdServizioApplicativoTokenRiferitoApplicabilitaTrasformazione() != null && filtroRicerca.getIdServizioApplicativoTokenRiferitoApplicabilitaTrasformazione().getNome() != null && filtroRicerca.getIdServizioApplicativoTokenRiferitoApplicabilitaTrasformazione().getIdSoggettoProprietario() != null && filtroRicerca.getIdServizioApplicativoTokenRiferitoApplicabilitaTrasformazione().getIdSoggettoProprietario().getTipo() != null && filtroRicerca.getIdServizioApplicativoTokenRiferitoApplicabilitaTrasformazione().getIdSoggettoProprietario().getNome() != null) {
                        if (pa.getTrasformazioni() == null || pa.getTrasformazioni().sizeRegolaList() <= 0) continue;
                        contains = false;
                        for (z = 0; z < pa.getTrasformazioni().sizeRegolaList(); ++z) {
                            regola = pa.getTrasformazioni().getRegola(z);
                            if (regola.getApplicabilita() == null || regola.getApplicabilita().sizeServizioApplicativoList() <= 0) continue;
                            for (TrasformazioneRegolaApplicabilitaServizioApplicativo tSA : regola.getApplicabilita().getServizioApplicativoList()) {
                                if (!filtroRicerca.getIdServizioApplicativoTokenRiferitoApplicabilitaTrasformazione().getNome().equals(tSA.getNome()) || !filtroRicerca.getIdServizioApplicativoTokenRiferitoApplicabilitaTrasformazione().getIdSoggettoProprietario().getTipo().equals(tSA.getTipoSoggettoProprietario()) || !filtroRicerca.getIdServizioApplicativoTokenRiferitoApplicabilitaTrasformazione().getIdSoggettoProprietario().getNome().equals(tSA.getNomeSoggettoProprietario())) continue;
                                contains = true;
                                break;
                            }
                            if (contains) break;
                        }
                        if (!contains) continue;
                    }
                    if (filtroRicerca.getStato() != null && (pa.getStato() != null ? !pa.getStato().equals(filtroRicerca.getStato()) : !StatoFunzionalita.ABILITATO.equals(filtroRicerca.getStato()))) continue;
                    if (porteDelegatePerAzioni && (pa.getAzione() == null || pa.getAzione().getNomePortaDelegante() == null || !pa.getAzione().getNomePortaDelegante().equals(filtroRicerca.getNomePortaDelegante()) || filtroRicerca.getAzione() != null && (pa.getAzione().getAzioneDelegataList().size() <= 0 || !pa.getAzione().getAzioneDelegataList().contains(filtroRicerca.getAzione())))) continue;
                }
                pa.setTipoSoggettoProprietario(soggetto.getTipo());
                pa.setNomeSoggettoProprietario(soggetto.getNome());
                listIDPorteApplicative.add(this.convertToIDPortaApplicativa(pa));
            }
        }
        if (listIDPorteApplicative.size() <= 0) {
            if (filtroRicerca != null) {
                throw new DriverConfigurazioneNotFound("PorteApplicative non trovate che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverConfigurazioneNotFound("PorteApplicative non trovate");
        }
        return listIDPorteApplicative;
    }

    @Override
    public ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (idServizioApplicativo == null) {
            throw new DriverConfigurazioneException("IDServizioApplicativo non definito");
        }
        if (idServizioApplicativo.getIdSoggettoProprietario() == null) {
            throw new DriverConfigurazioneException("IDServizioApplicativo.idSoggettoProprietario non definito");
        }
        if (idServizioApplicativo.getNome() == null) {
            throw new DriverConfigurazioneException("IDServizioApplicativo.nome non definito");
        }
        Soggetto soggettoProprietario = this.getSoggetto(idServizioApplicativo.getIdSoggettoProprietario());
        for (int j = 0; j < soggettoProprietario.sizeServizioApplicativoList(); ++j) {
            ServizioApplicativo sa = soggettoProprietario.getServizioApplicativo(j);
            if (!idServizioApplicativo.getNome().equals(sa.getNome())) continue;
            sa.setTipoSoggettoProprietario(soggettoProprietario.getTipo());
            sa.setNomeSoggettoProprietario(soggettoProprietario.getNome());
            return sa;
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiBasic(String aUser, String aPassword, CryptConfig config) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aUser == null) {
            throw new DriverConfigurazioneException("Username non definito");
        }
        if (aPassword == null) {
            throw new DriverConfigurazioneException("Password non definita");
        }
        boolean testInChiaro = false;
        ICrypt crypt = null;
        if (config == null || config.isBackwardCompatibility()) {
            testInChiaro = true;
        }
        if (config != null) {
            try {
                crypt = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), e);
            }
        }
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (sa.getInvocazionePorta() == null) continue;
                for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_BASIC.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUser.equals(sa.getInvocazionePorta().getCredenziali(z).getUser())) continue;
                    String passwordSaved = sa.getInvocazionePorta().getCredenziali(z).getPassword();
                    boolean found = false;
                    if (testInChiaro) {
                        found = aPassword.equals(passwordSaved);
                    }
                    if (!found && crypt != null) {
                        found = crypt.check(aPassword, passwordSaved);
                    }
                    if (!found) continue;
                    sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                    sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                    return sa;
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali basic non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiApiKey(String aUser, String aPassword, boolean appId, CryptConfig config) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aUser == null) {
            throw new DriverConfigurazioneException("Username non definito");
        }
        if (aPassword == null) {
            throw new DriverConfigurazioneException("Password non definita");
        }
        boolean testInChiaro = false;
        ICrypt crypt = null;
        if (config != null) {
            try {
                crypt = CryptFactory.getCrypt((Logger)this.log, (CryptConfig)config);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException(e.getMessage(), e);
            }
        } else {
            testInChiaro = true;
        }
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (sa.getInvocazionePorta() == null) continue;
                for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_APIKEY.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUser.equals(sa.getInvocazionePorta().getCredenziali(z).getUser()) || (appId ? !sa.getInvocazionePorta().getCredenziali(z).isAppId() : sa.getInvocazionePorta().getCredenziali(z).isAppId())) continue;
                    String passwordSaved = sa.getInvocazionePorta().getCredenziali(z).getPassword();
                    boolean found = false;
                    if (testInChiaro) {
                        found = aPassword.equals(passwordSaved);
                    }
                    if (!found && crypt != null) {
                        found = crypt.check(aPassword, passwordSaved);
                    }
                    if (!found) continue;
                    sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                    sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                    return sa;
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali basic non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiToken(String tokenPolicy, String tokenClientId, boolean tokenWithHttpsEnabled) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (tokenPolicy == null) {
            throw new DriverConfigurazioneException("TokenPolicy non definita");
        }
        if (tokenClientId == null) {
            throw new DriverConfigurazioneException("TokenClientId non definito");
        }
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (sa.getInvocazionePorta() == null) continue;
                for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_TOKEN.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo()) && (!tokenWithHttpsEnabled || !CostantiConfigurazione.CREDENZIALE_SSL.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo())) || !tokenClientId.equals(sa.getInvocazionePorta().getCredenziali(z).getUser()) || !tokenPolicy.equals(sa.getInvocazionePorta().getCredenziali(z).getTokenPolicy())) continue;
                    sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                    sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                    return sa;
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali principal non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(String aSubject, String aIssuer) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aSubject == null) {
            throw new DriverConfigurazioneException("Subject non definito");
        }
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (sa.getInvocazionePorta() == null) continue;
                for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    boolean issuerValid;
                    boolean subjectValid;
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null) {
                        try {
                            if (sa.getInvocazionePorta().getCredenziali(z).getSubject() == null) continue;
                            subjectValid = CertificateUtils.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getSubject(), (String)aSubject, (PrincipalType)PrincipalType.SUBJECT, (Logger)this.log);
                            issuerValid = true;
                            if (aIssuer != null) {
                                issuerValid = sa.getInvocazionePorta().getCredenziali(z).getIssuer() == null ? false : CertificateUtils.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getIssuer(), (String)aIssuer, (PrincipalType)PrincipalType.ISSUER, (Logger)this.log);
                            } else {
                                boolean bl = issuerValid = sa.getInvocazionePorta().getCredenziali(z).getIssuer() == null;
                            }
                            if (subjectValid && issuerValid) {
                                sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                                sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                                return sa;
                            }
                        }
                        catch (Exception e) {
                            throw new DriverConfigurazioneException(e.getMessage(), e);
                        }
                    }
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_SSL.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                    try {
                        if (sa.getInvocazionePorta().getCredenziali(z).getSubject() == null) continue;
                        subjectValid = CertificateUtils.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getSubject(), (String)aSubject, (PrincipalType)PrincipalType.SUBJECT, (Logger)this.log);
                        issuerValid = true;
                        if (aIssuer != null) {
                            issuerValid = sa.getInvocazionePorta().getCredenziali(z).getIssuer() == null ? false : CertificateUtils.sslVerify((String)sa.getInvocazionePorta().getCredenziali(z).getIssuer(), (String)aIssuer, (PrincipalType)PrincipalType.ISSUER, (Logger)this.log);
                        } else {
                            boolean bl = issuerValid = sa.getInvocazionePorta().getCredenziali(z).getIssuer() == null;
                        }
                        if (!subjectValid || !issuerValid) continue;
                        sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                        sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                        return sa;
                    }
                    catch (Exception e) {
                        throw new DriverConfigurazioneException(e.getMessage(), e);
                    }
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali ssl non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiSsl(CertificateInfo aCertificate, boolean aStrictVerifier) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aCertificate == null) {
            throw new DriverConfigurazioneException("Certificato non definito");
        }
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (sa.getInvocazionePorta() == null) continue;
                for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    Certificate certificato;
                    String cnSubject;
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null) {
                        try {
                            if (sa.getInvocazionePorta().getCredenziali(z).getCertificate() == null || aStrictVerifier != sa.getInvocazionePorta().getCredenziali(z).isCertificateStrictVerification()) continue;
                            cnSubject = aCertificate.getSubject().getCN();
                            if (cnSubject.equals(sa.getInvocazionePorta().getCredenziali(z).getCnSubject()) && aCertificate.equals((certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])sa.getInvocazionePorta().getCredenziali(z).getCertificate(), (int)0, null)).getCertificate(), aStrictVerifier)) {
                                sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                                sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                                return sa;
                            }
                        }
                        catch (Exception e) {
                            throw new DriverConfigurazioneException(e.getMessage(), e);
                        }
                    }
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_SSL.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo())) continue;
                    try {
                        if (sa.getInvocazionePorta().getCredenziali(z).getCertificate() == null || aStrictVerifier != sa.getInvocazionePorta().getCredenziali(z).isCertificateStrictVerification() || !(cnSubject = aCertificate.getSubject().getCN()).equals(sa.getInvocazionePorta().getCredenziali(z).getCnSubject()) || !aCertificate.equals((certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])sa.getInvocazionePorta().getCredenziali(z).getCertificate(), (int)0, null)).getCertificate(), aStrictVerifier)) continue;
                        sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                        sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                        return sa;
                    }
                    catch (Exception e) {
                        throw new DriverConfigurazioneException(e.getMessage(), e);
                    }
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali ssl non trovato");
    }

    @Override
    public ServizioApplicativo getServizioApplicativoByCredenzialiPrincipal(String aUserPrincipal) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (aUserPrincipal == null) {
            throw new DriverConfigurazioneException("Principal non definito");
        }
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggettoSearch = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggettoSearch.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggettoSearch.getServizioApplicativo(j);
                if (sa.getInvocazionePorta() == null) continue;
                for (int z = 0; z < sa.getInvocazionePorta().sizeCredenzialiList(); ++z) {
                    if (sa.getInvocazionePorta().getCredenziali(z).getTipo() == null || !CostantiConfigurazione.CREDENZIALE_PRINCIPAL.equals(sa.getInvocazionePorta().getCredenziali(z).getTipo()) || !aUserPrincipal.equals(sa.getInvocazionePorta().getCredenziali(z).getUser())) continue;
                    sa.setTipoSoggettoProprietario(soggettoSearch.getTipo());
                    sa.setNomeSoggettoProprietario(soggettoSearch.getNome());
                    return sa;
                }
            }
        }
        throw new DriverConfigurazioneNotFound("Servizio Applicativo cercato con credenziali principal non trovato");
    }

    @Override
    public List<IDServizioApplicativo> getAllIdServiziApplicativi(FiltroRicercaServiziApplicativi filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDServizioApplicativo> listIDServiziApplicativi = new ArrayList<IDServizioApplicativo>();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggetto.sizeServizioApplicativoList(); ++j) {
                ServizioApplicativo sa = soggetto.getServizioApplicativo(j);
                String id = sa.getNome();
                if (filtroRicerca != null) {
                    if (filtroRicerca.getMinDate() != null) {
                        if (sa.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteApplicative](FiltroByMinDate) PortaApplicativa [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (sa.getOraRegistrazione().before(filtroRicerca.getMinDate())) continue;
                    }
                    if (filtroRicerca.getMaxDate() != null) {
                        if (soggetto.getOraRegistrazione() == null) {
                            this.log.debug("[getAllIdPorteApplicative](FiltroByMaxDate) PortaApplicativa [" + id + "] non valorizzato nell'ora-registrazione. Non inserito nella lista ritornata.");
                            continue;
                        }
                        if (soggetto.getOraRegistrazione().after(filtroRicerca.getMaxDate())) continue;
                    }
                    if (filtroRicerca.getTipoSoggetto() != null && !soggetto.getTipo().equals(filtroRicerca.getTipoSoggetto()) || filtroRicerca.getNomeSoggetto() != null && !soggetto.getNome().equals(filtroRicerca.getNomeSoggetto())) continue;
                    if (filtroRicerca.getIdRuolo() != null && filtroRicerca.getIdRuolo().getNome() != null) {
                        if (sa.getInvocazionePorta() == null || sa.getInvocazionePorta().getRuoli() == null) continue;
                        boolean contains = false;
                        for (int z = 0; z < sa.getInvocazionePorta().getRuoli().sizeRuoloList(); ++z) {
                            if (!filtroRicerca.getIdRuolo().getNome().equals(sa.getInvocazionePorta().getRuoli().getRuolo(z).getNome())) continue;
                            contains = true;
                            break;
                        }
                        if (!contains) continue;
                    }
                }
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setNome(id);
                idSA.setIdSoggettoProprietario(new IDSoggetto(soggetto.getTipo(), soggetto.getNome()));
                listIDServiziApplicativi.add(idSA);
            }
        }
        if (listIDServiziApplicativi.size() <= 0) {
            if (filtroRicerca != null) {
                throw new DriverConfigurazioneNotFound("ServiziApplicativi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
            }
            throw new DriverConfigurazioneNotFound("ServiziApplicativi non trovati");
        }
        return listIDServiziApplicativi;
    }

    @Override
    public List<IDConnettore> getConnettoriConsegnaNotifichePrioritarie(String queueName) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        ArrayList<IDConnettore> listIDServiziApplicativi = new ArrayList<IDConnettore>();
        for (int i = 0; i < this.openspcoop.sizeSoggettoList(); ++i) {
            Soggetto soggetto = this.openspcoop.getSoggetto(i);
            for (int j = 0; j < soggetto.sizePortaApplicativaList(); ++j) {
                PortaApplicativa pa = soggetto.getPortaApplicativa(j);
                if (pa.sizeServizioApplicativoList() <= 0) continue;
                for (int k = 0; k < pa.sizeServizioApplicativoList(); ++k) {
                    PortaApplicativaServizioApplicativo pasa = pa.getServizioApplicativo(k);
                    if (pasa.getDatiConnettore() == null || !pasa.getDatiConnettore().isPrioritaMax()) continue;
                    if (queueName != null) {
                        String coda = pasa.getDatiConnettore().getCoda();
                        if (coda == null) {
                            coda = "DEFAULT";
                        }
                        if (!queueName.equals(coda)) continue;
                    }
                    IDConnettore idSA = new IDConnettore();
                    idSA.setNome(pasa.getNome());
                    idSA.setIdSoggettoProprietario(new IDSoggetto(soggetto.getTipo(), soggetto.getNome()));
                    idSA.setNomeConnettore(pasa.getDatiConnettore().getNome());
                    if (idSA.getNomeConnettore() == null) {
                        idSA.setNomeConnettore("Default");
                    }
                    listIDServiziApplicativi.add(idSA);
                }
            }
        }
        if (listIDServiziApplicativi.size() <= 0) {
            if (queueName != null) {
                throw new DriverConfigurazioneNotFound("ServiziApplicativi non trovati per la coda '" + queueName + "'");
            }
            throw new DriverConfigurazioneNotFound("ServiziApplicativi non trovati");
        }
        return listIDServiziApplicativi;
    }

    @Override
    public RoutingTable getRoutingTable() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML();
        RoutingTable r = null;
        if (this.openspcoop.getConfigurazione().getRoutingTable() == null) {
            r = new RoutingTable();
            r.setAbilitata(false);
        } else {
            r = this.openspcoop.getConfigurazione().getRoutingTable();
            r.setAbilitata(true);
        }
        return r;
    }

    @Override
    public AccessoRegistro getAccessoRegistro() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoRegistro() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoRegistro] Informazioni di accesso al RegistroServizi non trovate");
        }
        return this.openspcoop.getConfigurazione().getAccessoRegistro();
    }

    @Override
    public AccessoConfigurazione getAccessoConfigurazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoConfigurazione] Informazioni di accesso alla configurazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getAccessoConfigurazione();
    }

    @Override
    public AccessoDatiAutorizzazione getAccessoDatiAutorizzazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoDatiAutorizzazione() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoDatiAutorizzazione] Informazioni di accesso ai dati di autorizzazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getAccessoDatiAutorizzazione();
    }

    @Override
    public AccessoDatiAutenticazione getAccessoDatiAutenticazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoDatiAutenticazione() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoDatiAutenticazione] Informazioni di accesso ai dati di autenticazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getAccessoDatiAutenticazione();
    }

    @Override
    public AccessoDatiGestioneToken getAccessoDatiGestioneToken() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoDatiGestioneToken() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoDatiGestioneToken] Informazioni di accesso ai dati di gestione dei token non trovati");
        }
        return this.openspcoop.getConfigurazione().getAccessoDatiGestioneToken();
    }

    @Override
    public AccessoDatiAttributeAuthority getAccessoDatiAttributeAuthority() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoDatiAttributeAuthority() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoDatiAttributeAuthority] Informazioni di accesso ai dati recuperati da Attribute Authority non trovati");
        }
        return this.openspcoop.getConfigurazione().getAccessoDatiAttributeAuthority();
    }

    @Override
    public AccessoDatiKeystore getAccessoDatiKeystore() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoDatiKeystore() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoDatiKeystore] Informazioni di accesso ai dati per la gestione dei keystore non trovati");
        }
        return this.openspcoop.getConfigurazione().getAccessoDatiKeystore();
    }

    @Override
    public AccessoDatiRichieste getAccessoDatiRichieste() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoDatiRichieste() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoDatiRichieste] Informazioni di accesso ai dati per la gestione delle richieste non trovati");
        }
        return this.openspcoop.getConfigurazione().getAccessoDatiRichieste();
    }

    @Override
    public AccessoDatiConsegnaApplicativi getAccessoDatiConsegnaApplicativi() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione().getAccessoDatiConsegnaApplicativi() == null) {
            throw new DriverConfigurazioneNotFound("[getAccessoDatiKeystore] Informazioni di accesso ai dati per la gestione della consegna agli applicativi non trovati");
        }
        return this.openspcoop.getConfigurazione().getAccessoDatiConsegnaApplicativi();
    }

    @Override
    public GestioneErrore getGestioneErroreComponenteCooperazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteCooperazione] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteCooperazione] Informazioni per la gestione dell'errore non trovate");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteCooperazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteCooperazione] Informazioni per la gestione dell'errore per il componente di cooperazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteCooperazione();
    }

    @Override
    public GestioneErrore getGestioneErroreComponenteIntegrazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteIntegrazione] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteIntegrazione] Informazioni per la gestione dell'errore non trovate");
        }
        if (this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteIntegrazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGestioneErroreComponenteIntegrazione] Informazioni per la gestione dell'errore per il componente di cooperazione non trovate");
        }
        return this.openspcoop.getConfigurazione().getGestioneErrore().getComponenteIntegrazione();
    }

    @Override
    public StatoServiziPdd getStatoServiziPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getServiziAttiviPdD] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getStatoServiziPdd() == null) {
            throw new DriverConfigurazioneNotFound("[getServiziAttiviPdD] Configurazione servizi attivi sulla PdD non presente");
        }
        return this.openspcoop.getConfigurazione().getStatoServiziPdd();
    }

    @Override
    public SystemProperties getSystemPropertiesPdD() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getServiziAttiviPdD] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getSystemProperties() == null) {
            throw new DriverConfigurazioneNotFound("[getServiziAttiviPdD] Configurazione System Properties non presenti");
        }
        return this.openspcoop.getConfigurazione().getSystemProperties();
    }

    @Override
    public List<String> getEncryptedSystemPropertiesPdD() throws DriverConfigurazioneException {
        return new ArrayList<String>();
    }

    @Override
    public List<GenericProperties> getGenericProperties() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGenericProperties] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getGenericPropertiesList() == null || this.openspcoop.getConfigurazione().getGenericPropertiesList().size() <= 0) {
            throw new DriverConfigurazioneNotFound("[getGenericProperties] Configurazione Generic Properties non presenti");
        }
        return this.openspcoop.getConfigurazione().getGenericPropertiesList();
    }

    @Override
    public List<GenericProperties> getGenericProperties(String tipologia) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGenericProperties] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getGenericPropertiesList() == null || this.openspcoop.getConfigurazione().getGenericPropertiesList().size() <= 0) {
            throw new DriverConfigurazioneNotFound("[getGenericProperties] Configurazione Generic Properties non presenti");
        }
        ArrayList<GenericProperties> list = new ArrayList<GenericProperties>();
        for (GenericProperties genericProperties : this.openspcoop.getConfigurazione().getGenericPropertiesList()) {
            if (tipologia == null || !tipologia.equals(genericProperties.getTipologia())) continue;
            list.add(genericProperties);
        }
        if (list.isEmpty()) {
            throw new DriverConfigurazioneNotFound("[getGenericProperties] Configurazione Generic Properties non presenti con tipologia '" + tipologia + "'");
        }
        return list;
    }

    @Override
    public GenericProperties getGenericProperties(String tipologia, String name) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        if (this.openspcoop.getConfigurazione() == null) {
            throw new DriverConfigurazioneNotFound("[getGenericProperties] Configurazione non trovata");
        }
        if (this.openspcoop.getConfigurazione().getGenericPropertiesList() == null || this.openspcoop.getConfigurazione().getGenericPropertiesList().size() <= 0) {
            throw new DriverConfigurazioneNotFound("[getGenericProperties] Configurazione Generic Properties non presenti");
        }
        for (GenericProperties genericProperties : this.openspcoop.getConfigurazione().getGenericPropertiesList()) {
            if (tipologia == null || !tipologia.equals(genericProperties.getTipologia()) || !genericProperties.getNome().equals(name)) continue;
            return genericProperties;
        }
        throw new DriverConfigurazioneNotFound("[getGenericProperties] Configurazione Generic Properties non presenti con tipologia '" + tipologia + "' e nome '" + name + "'");
    }

    @Override
    public RegistroPlugins getRegistroPlugins() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        RegistroPlugins registro = this.openspcoop.getConfigurazione().getRegistroPlugins();
        if (registro == null || registro.sizePluginList() <= 0) {
            throw new DriverConfigurazioneNotFound("Nessun plugin registrato");
        }
        return registro;
    }

    @Override
    public CanaliConfigurazione getCanaliConfigurazione() throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        this.refreshConfigurazioneXML();
        CanaliConfigurazione c = this.openspcoop.getConfigurazione().getGestioneCanali();
        if (c == null) {
            c = new CanaliConfigurazione();
            c.setStato(StatoFunzionalita.DISABILITATO);
        }
        return c;
    }

    @Override
    public RegistroPlugin getRegistroPlugin(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getRegistroPlugin(nome, false);
    }

    @Override
    public RegistroPlugin getDatiRegistroPlugin(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getRegistroPlugin(nome, true);
    }

    private RegistroPlugin getRegistroPlugin(String nome, boolean soloDati) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (nome == null) {
            throw new DriverConfigurazioneException("Nome plugin non indicato");
        }
        this.refreshConfigurazioneXML();
        RegistroPlugins registro = this.openspcoop.getConfigurazione().getRegistroPlugins();
        if (registro == null || registro.sizePluginList() <= 0) {
            throw new DriverConfigurazioneNotFound("Plugin '" + nome + "' non esistente");
        }
        for (int i = 0; i < registro.sizePluginList(); ++i) {
            RegistroPlugin plug = registro.getPlugin(i);
            if (!plug.getNome().equals(nome)) continue;
            if (soloDati) {
                RegistroPlugin plugCloned = (RegistroPlugin)plug.clone();
                while (plugCloned.sizeArchivioList() > 0) {
                    plugCloned.removeArchivio(0);
                }
                continue;
            }
            return plug;
        }
        throw new DriverConfigurazioneNotFound("Plugin '" + nome + "' non esistente");
    }

    @Override
    public RegistroPluginArchivio getRegistroPluginArchivio(String nomePlugin, String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        RegistroPlugin plug = this.getRegistroPlugin(nomePlugin);
        if (nome == null) {
            throw new DriverConfigurazioneException("Nome archivio non indicato");
        }
        for (int i = 0; i < plug.sizeArchivioList(); ++i) {
            RegistroPluginArchivio plugArchivio = plug.getArchivio(i);
            if (!plugArchivio.getNome().equals(nome)) continue;
            return plugArchivio;
        }
        throw new DriverConfigurazioneNotFound("Archivio '" + nome + "' non esistente nel plugin '" + nomePlugin + "'");
    }

    @Override
    public ConfigurazioneUrlInvocazioneRegola getUrlInvocazioneRegola(String nome) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        if (nome == null) {
            throw new DriverConfigurazioneException("Nome regola non indicato");
        }
        this.refreshConfigurazioneXML();
        ConfigurazioneUrlInvocazione registro = this.openspcoop.getConfigurazione().getUrlInvocazione();
        if (registro == null || registro.sizeRegolaList() <= 0) {
            throw new DriverConfigurazioneNotFound("Regola '" + nome + "' non esistente");
        }
        for (int i = 0; i < registro.sizeRegolaList(); ++i) {
            ConfigurazioneUrlInvocazioneRegola regola = registro.getRegola(i);
            if (!regola.getNome().equals(nome)) continue;
            return regola;
        }
        throw new DriverConfigurazioneNotFound("Regola '" + nome + "' non esistente");
    }

    @Override
    public Configurazione getConfigurazioneGenerale() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML();
        Configurazione config = this.openspcoop.getConfigurazione();
        if (config != null && config.getDump() != null && config.getDump().getConfigurazione() != null && config.getDump().getConfigurazionePortaApplicativa() == null && config.getDump().getConfigurazionePortaDelegata() == null) {
            config.getDump().setConfigurazionePortaApplicativa(config.getDump().getConfigurazione());
            config.getDump().setConfigurazionePortaDelegata(config.getDump().getConfigurazione());
        }
        return config;
    }

    @Override
    public void isAlive() throws CoreException {
        if (!this.create) {
            throw new CoreException("Driver non inizializzato");
        }
        try {
            this.forzaRefreshConfigurazioneXML();
        }
        catch (Exception e) {
            throw new CoreException("Connessione al registro non disponibile: " + e.getMessage(), e);
        }
    }

    @Override
    public Openspcoop2 getImmagineCompletaConfigurazionePdD() throws DriverConfigurazioneException {
        this.refreshConfigurazioneXML();
        return this.openspcoop;
    }
}

