/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openspcoop2.core.byok.IDriverBYOK;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.commons.ErrorsHandlerCostant;
import org.openspcoop2.core.config.Connettore;
import org.openspcoop2.core.config.Credenziali;
import org.openspcoop2.core.config.GestioneErrore;
import org.openspcoop2.core.config.InvocazioneCredenziali;
import org.openspcoop2.core.config.InvocazionePorta;
import org.openspcoop2.core.config.InvocazionePortaGestioneErrore;
import org.openspcoop2.core.config.InvocazioneServizio;
import org.openspcoop2.core.config.Proprieta;
import org.openspcoop2.core.config.ProprietaOggetto;
import org.openspcoop2.core.config.ProtocolProperty;
import org.openspcoop2.core.config.RispostaAsincrona;
import org.openspcoop2.core.config.Ruolo;
import org.openspcoop2.core.config.ServizioApplicativo;
import org.openspcoop2.core.config.ServizioApplicativoRuoli;
import org.openspcoop2.core.config.constants.CostantiConfigurazione;
import org.openspcoop2.core.config.constants.CredenzialeTipo;
import org.openspcoop2.core.config.constants.InvocazioneServizioTipoAutenticazione;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.constants.TipologiaErogazione;
import org.openspcoop2.core.config.constants.TipologiaFruizione;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.DriverConfigurazioneNotFound;
import org.openspcoop2.core.config.driver.FiltroRicercaProtocolPropertyConfig;
import org.openspcoop2.core.config.driver.FiltroRicercaServiziApplicativi;
import org.openspcoop2.core.config.driver.IDServizioUtils;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBSoggetti;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBUtils;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_connettoriLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_gestioneErroreLIB;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_protocolPropertiesDriver;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_serviziApplicativiLIB;
import org.openspcoop2.core.config.driver.db.IDServizioApplicativoDB;
import org.openspcoop2.core.constants.CostantiDB;
import org.openspcoop2.core.constants.ProprietariProtocolProperty;
import org.openspcoop2.core.constants.TipiConnettore;
import org.openspcoop2.core.id.IDServizio;
import org.openspcoop2.core.id.IDServizioApplicativo;
import org.openspcoop2.core.id.IDSoggetto;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.UtilsException;
import org.openspcoop2.utils.certificate.ArchiveLoader;
import org.openspcoop2.utils.certificate.ArchiveType;
import org.openspcoop2.utils.certificate.Certificate;
import org.openspcoop2.utils.certificate.CertificateInfo;
import org.openspcoop2.utils.certificate.CertificateUtils;
import org.openspcoop2.utils.certificate.PrincipalType;
import org.openspcoop2.utils.crypt.CryptConfig;
import org.openspcoop2.utils.crypt.CryptFactory;
import org.openspcoop2.utils.crypt.ICrypt;
import org.openspcoop2.utils.date.DateManager;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;
import org.openspcoop2.utils.sql.SQLQueryObjectException;
import org.slf4j.Logger;

public class DriverConfigurazioneDB_serviziApplicativiDriver {
    private DriverConfigurazioneDB driver = null;
    private DriverConfigurazioneDBSoggetti soggettiDriver = null;
    private DriverConfigurazioneDB_protocolPropertiesDriver protocolPropertiesDriver = null;
    private DriverConfigurazioneDBUtils utilsDriver = null;

    protected DriverConfigurazioneDB_serviziApplicativiDriver(DriverConfigurazioneDB driver) {
        this.driver = driver;
        this.soggettiDriver = new DriverConfigurazioneDBSoggetti(driver);
        this.protocolPropertiesDriver = new DriverConfigurazioneDB_protocolPropertiesDriver(driver);
        this.utilsDriver = new DriverConfigurazioneDBUtils(driver);
    }

    protected ServizioApplicativo getServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(idServizioApplicativo, null, null, null, null, null, false, null, null, null, false, false, null, null, false, null, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiBasic(String aUser, String aPassword, CryptConfig config) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, aUser, aPassword, null, null, null, false, null, null, config, false, false, null, null, false, null, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiBasic(String aUser, String aPassword, CryptConfig config, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, aUser, aPassword, null, null, null, false, null, null, config, false, false, null, null, false, tipiSoggetto, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiApiKey(String aUser, String aPassword, boolean appId, CryptConfig config) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, aUser, aPassword, null, null, null, false, null, null, config, true, appId, null, null, false, null, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiApiKey(String aUser, String aPassword, boolean appId, CryptConfig config, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, aUser, aPassword, null, null, null, false, null, null, config, true, appId, null, null, false, tipiSoggetto, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiToken(String tokenPolicy, String tokenClientId, boolean tokenWithHttpsEnabled) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, null, null, null, false, null, null, null, false, false, tokenPolicy, tokenClientId, tokenWithHttpsEnabled, null, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiToken(String tokenPolicy, String tokenClientId, boolean tokenWithHttpsEnabled, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, null, null, null, false, null, null, null, false, false, tokenPolicy, tokenClientId, tokenWithHttpsEnabled, tipiSoggetto, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiSsl(String aSubject, String aIssuer) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, aSubject, aIssuer, null, false, null, null, null, false, false, null, null, false, null, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiSsl(String aSubject, String aIssuer, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, aSubject, aIssuer, null, false, null, null, null, false, false, null, null, false, tipiSoggetto, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiSsl(String aSubject, String aIssuer, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, aSubject, aIssuer, null, false, null, null, null, false, false, null, null, false, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, null, null, certificate, strictVerifier, null, null, null, false, false, null, null, false, null, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, null, null, certificate, strictVerifier, null, null, null, false, false, null, null, false, tipiSoggetto, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiSsl(CertificateInfo certificate, boolean strictVerifier, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, null, null, certificate, strictVerifier, null, null, null, false, false, null, null, false, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiPrincipal(String principal) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, null, null, null, false, principal, null, null, false, false, null, null, false, null, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativoByCredenzialiPrincipal(String principal, List<String> tipiSoggetto) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, null, null, null, false, principal, null, null, false, false, null, null, false, tipiSoggetto, false, false, false);
    }

    protected ServizioApplicativo getServizioApplicativo(long idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        return this.getEngineServizioApplicativo(null, null, null, null, null, null, false, null, idServizioApplicativo, null, false, false, null, null, false, null, false, false, false);
    }

    private ServizioApplicativo getEngineServizioApplicativo(IDServizioApplicativo idServizioApplicativoObject, String aUser, String aPassord, String aSubject, String aIssuer, CertificateInfo aCertificate, boolean aStrictVerifier, String principal, Long idServizioApplicativo, CryptConfig config, boolean apiKey, boolean appId, String tokenPolicy, String tokenClientId, boolean tokenWithHttpsEnabled, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ResultSet rs;
        PreparedStatement stm;
        Connection con;
        block173: {
            String encValue;
            int sbustamentoInfoProtocollo;
            con = null;
            stm = null;
            rs = null;
            String nome_sa = null;
            String sqlQuery = null;
            ServizioApplicativo sa = null;
            int type = 0;
            boolean TYPE_ID_OBJECT = true;
            int TYPE_BASIC = 2;
            int TYPE_SSL_SUBJECT_ISSUER = 31;
            int TYPE_SSL_CERTIFICATE = 32;
            int TYPE_PRINCIPAL = 4;
            int TYPE_ID_LONG = 5;
            int TYPE_API_KEY = 6;
            int TYPE_TOKEN = 7;
            if (idServizioApplicativoObject != null) {
                IDSoggetto idSO = idServizioApplicativoObject.getIdSoggettoProprietario();
                if (idSO == null) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Soggetto Proprietario non definito.");
                }
                if (idSO.getNome() == null || "".equals(idSO.getNome())) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Soggetto Proprietario non definito.");
                }
                if (idSO.getTipo() == null || "".equals(idSO.getTipo())) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Soggetto Proprietario non definito.");
                }
                nome_sa = idServizioApplicativoObject.getNome();
                if (nome_sa == null) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome non definito.");
                }
                type = 1;
            } else if (apiKey) {
                type = 6;
            } else if (aUser != null) {
                type = 2;
            } else if (aSubject != null) {
                type = 31;
            } else if (aCertificate != null) {
                type = 32;
            } else if (principal != null) {
                type = 4;
            } else if (tokenPolicy != null) {
                type = 7;
            } else {
                type = 5;
                if (idServizioApplicativo == null || idServizioApplicativo <= 0L) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Id DB non definito.");
                }
            }
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("getServizioApplicativo");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
            switch (type) {
                case 1: {
                    String tipoSog = idServizioApplicativoObject.getIdSoggettoProprietario().getTipo();
                    String nomeSog = idServizioApplicativoObject.getIdSoggettoProprietario().getNome();
                    long idSog = DBUtils.getIdSoggetto(nomeSog, tipoSog, con, this.driver.tipoDB, this.driver.tabellaSoggetti);
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("nome = ?");
                    sqlQueryObject.addWhereCondition("id_soggetto = ?");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, nome_sa);
                    stm.setLong(2, idSog);
                    this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, nome_sa));
                    break;
                }
                case 2: 
                case 6: {
                    boolean testInChiaro = false;
                    ICrypt crypt = null;
                    String tipoCredenziale = null;
                    if (type == 2) {
                        tipoCredenziale = CostantiConfigurazione.CREDENZIALE_BASIC.toString();
                        if (config == null || config.isBackwardCompatibility()) {
                            testInChiaro = true;
                        }
                        if (config != null) {
                            crypt = CryptFactory.getCrypt((Logger)this.driver.log, (CryptConfig)config);
                        }
                    } else {
                        tipoCredenziale = CostantiConfigurazione.CREDENZIALE_APIKEY.toString();
                        if (config != null) {
                            crypt = CryptFactory.getCrypt((Logger)this.driver.log, (CryptConfig)config);
                        } else {
                            testInChiaro = true;
                        }
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                        sqlQueryObject.addFromTable("soggetti");
                    }
                    sqlQueryObject.addSelectAliasField("servizi_applicativi.id", "saId");
                    sqlQueryObject.addSelectAliasField("servizi_applicativi.password", "saPwd");
                    sqlQueryObject.addWhereCondition("tipoauth = ?");
                    sqlQueryObject.addWhereCondition("utente = ?");
                    if (apiKey) {
                        sqlQueryObject.addWhereCondition("issuer = ?");
                    }
                    if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                        sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, tipoCredenziale);
                    stm.setString(2, aUser);
                    if (apiKey) {
                        stm.setString(3, CostantiDB.getIssuerApiKey(appId));
                    }
                    if (apiKey) {
                        this.driver.logDebug("eseguo query :" + DBUtils.formatSQLString(sqlQuery, tipoCredenziale, aUser, CostantiDB.getIssuerApiKey(appId)));
                    } else {
                        this.driver.logDebug("eseguo query :" + DBUtils.formatSQLString(sqlQuery, tipoCredenziale, aUser));
                    }
                    rs = stm.executeQuery();
                    long idSA = -1L;
                    while (rs.next()) {
                        String passwordDB = rs.getString("saPwd");
                        boolean found = false;
                        if (testInChiaro) {
                            found = aPassord.equals(passwordDB);
                        }
                        if (!found && crypt != null) {
                            found = crypt.check(aPassord, passwordDB);
                        }
                        if (!found) continue;
                        idSA = rs.getLong("saId");
                        break;
                    }
                    rs.close();
                    stm.close();
                    if (idSA <= 0L) {
                        throw new DriverConfigurazioneNotFound("Nessun Servizio Applicativo trovato.");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id = ?");
                    stm = con.prepareStatement(sqlQueryObject.toString());
                    stm.setLong(1, idSA);
                    this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, idSA));
                    break;
                }
                case 31: {
                    Object issuerPotenziale;
                    Object subjectPotenziale;
                    List listValues;
                    Map hashSubject = CertificateUtils.getPrincipalIntoMap((String)aSubject, (PrincipalType)PrincipalType.SUBJECT);
                    Map hashIssuer = null;
                    if (StringUtils.isNotEmpty((CharSequence)aIssuer)) {
                        hashIssuer = CertificateUtils.getPrincipalIntoMap((String)aIssuer, (PrincipalType)PrincipalType.ISSUER);
                    }
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                        sqlQueryObject.addFromTable("soggetti");
                    }
                    sqlQueryObject.addSelectAliasField("servizi_applicativi", "id", "saIdentificativo");
                    sqlQueryObject.addSelectAliasField("servizi_applicativi", "subject", "saSubject");
                    sqlQueryObject.addSelectAliasField("servizi_applicativi", "issuer", "saIssuer");
                    sqlQueryObject.addSelectAliasField("servizi_applicativi", "tipoauth", "saTipoAuth");
                    sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    if (!tokenWithHttpsEnabled) {
                        sqlQueryObject.addWhereIsNullCondition("servizi_applicativi.token_policy");
                    }
                    for (String key : hashSubject.keySet()) {
                        listValues = (List)hashSubject.get(key);
                        for (String value : listValues) {
                            sqlQueryObject.addWhereLikeCondition("servizi_applicativi.subject", "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", true, true, false);
                        }
                    }
                    if (hashIssuer != null) {
                        for (String key : hashIssuer.keySet()) {
                            listValues = (List)hashIssuer.get(key);
                            for (String value : listValues) {
                                sqlQueryObject.addWhereLikeCondition("servizi_applicativi.issuer", "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", true, true, false);
                            }
                        }
                    } else {
                        sqlQueryObject.addWhereIsNullCondition("servizi_applicativi.issuer");
                    }
                    if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                        if (includiApplicativiNonModI || includiApplicativiModIEsterni || includiApplicativiModIInterni) {
                            ISQLQueryObject object = this.buildFiltroApplicativiTls(sqlQueryObject, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
                            sqlQueryObject.addWhereCondition(object.createSQLConditions());
                        } else {
                            sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                        }
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                    this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.CREDENZIALE_SSL.toString()));
                    rs = stm.executeQuery();
                    long idSA = -1L;
                    while (rs.next()) {
                        subjectPotenziale = rs.getString("saSubject");
                        boolean subjectValid = CertificateUtils.sslVerify((String)subjectPotenziale, (String)aSubject, (PrincipalType)PrincipalType.SUBJECT, (Logger)this.driver.log);
                        boolean issuerValid = true;
                        if (hashIssuer != null) {
                            issuerPotenziale = rs.getString("saIssuer");
                            issuerValid = StringUtils.isNotEmpty((CharSequence)issuerPotenziale) ? CertificateUtils.sslVerify((String)issuerPotenziale, (String)aIssuer, (PrincipalType)PrincipalType.ISSUER, (Logger)this.driver.log) : false;
                        }
                        if (!subjectValid || !issuerValid) continue;
                        idSA = rs.getLong("saIdentificativo");
                        break;
                    }
                    rs.close();
                    stm.close();
                    if (idSA <= 0L) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                        sqlQueryObject.addFromTable("servizi_applicativi");
                        sqlQueryObject.addFromTable("sa_credenziali");
                        if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                            sqlQueryObject.addFromTable("soggetti");
                        }
                        sqlQueryObject.addSelectAliasField("servizi_applicativi", "id", "saIdentificativo");
                        sqlQueryObject.addSelectAliasField("sa_credenziali", "subject", "saSubject");
                        sqlQueryObject.addSelectAliasField("sa_credenziali", "issuer", "saIssuer");
                        sqlQueryObject.addSelectAliasField("servizi_applicativi", "tipoauth", "saTipoAuth");
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQueryObject.addWhereCondition("sa_credenziali.id_servizio_applicativo=servizi_applicativi.id");
                        sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                        if (!tokenWithHttpsEnabled) {
                            sqlQueryObject.addWhereIsNullCondition("servizi_applicativi.token_policy");
                        }
                        for (String key : hashSubject.keySet()) {
                            List listValues2 = (List)hashSubject.get(key);
                            for (String value : listValues2) {
                                sqlQueryObject.addWhereLikeCondition("sa_credenziali.subject", "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", true, true, false);
                            }
                        }
                        if (hashIssuer != null) {
                            for (String key : hashIssuer.keySet()) {
                                List listValues3 = (List)hashIssuer.get(key);
                                for (String value : listValues3) {
                                    sqlQueryObject.addWhereLikeCondition("sa_credenziali.issuer", "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", true, true, false);
                                }
                            }
                        } else {
                            sqlQueryObject.addWhereIsNullCondition("sa_credenziali.issuer");
                        }
                        if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                            if (includiApplicativiNonModI || includiApplicativiModIEsterni || includiApplicativiModIInterni) {
                                ISQLQueryObject object = this.buildFiltroApplicativiTls(sqlQueryObject, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
                                sqlQueryObject.addWhereCondition(object.createSQLConditions());
                            } else {
                                sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                            }
                        }
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = con.prepareStatement(sqlQuery);
                        stm.setString(1, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                        this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.CREDENZIALE_SSL.toString()));
                        rs = stm.executeQuery();
                        while (rs.next()) {
                            subjectPotenziale = rs.getString("saSubject");
                            boolean subjectValid = CertificateUtils.sslVerify((String)subjectPotenziale, (String)aSubject, (PrincipalType)PrincipalType.SUBJECT, (Logger)this.driver.log);
                            boolean issuerValid = true;
                            if (hashIssuer != null) {
                                issuerPotenziale = rs.getString("saIssuer");
                                issuerValid = StringUtils.isNotEmpty((CharSequence)issuerPotenziale) ? CertificateUtils.sslVerify((String)issuerPotenziale, (String)aIssuer, (PrincipalType)PrincipalType.ISSUER, (Logger)this.driver.log) : false;
                            }
                            if (!subjectValid || !issuerValid) continue;
                            idSA = rs.getLong("saIdentificativo");
                            break;
                        }
                        rs.close();
                        stm.close();
                    }
                    if (idSA <= 0L) {
                        throw new DriverConfigurazioneNotFound("Nessun Servizio Applicativo trovato.");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id = ?");
                    stm = con.prepareStatement(sqlQueryObject.toString());
                    stm.setLong(1, idSA);
                    this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, idSA));
                    break;
                }
                case 32: {
                    Certificate certificato;
                    byte[] certificatoBytes;
                    String cnSubject = aCertificate.getSubject().getCN();
                    String cnIssuer = aCertificate.getIssuer().getCN();
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                        sqlQueryObject.addFromTable("soggetti");
                    }
                    sqlQueryObject.addSelectAliasField("servizi_applicativi", "id", "saIdentificativo");
                    sqlQueryObject.addSelectAliasField("servizi_applicativi", "cn_subject", "saCNSubject");
                    sqlQueryObject.addSelectAliasField("servizi_applicativi", "cn_issuer", "saCNIssuer");
                    sqlQueryObject.addSelectAliasField("servizi_applicativi", "cert_strict_verification", "saCertStrictVerificationr");
                    sqlQueryObject.addSelectAliasField("servizi_applicativi", "certificate", "saCertificate");
                    sqlQueryObject.addSelectAliasField("servizi_applicativi", "tipoauth", "saTipoAuth");
                    sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    sqlQueryObject.addWhereCondition("servizi_applicativi.cn_subject = ?");
                    sqlQueryObject.addWhereCondition("servizi_applicativi.cn_issuer = ?");
                    sqlQueryObject.addWhereCondition("servizi_applicativi.cert_strict_verification = ?");
                    if (!tokenWithHttpsEnabled) {
                        sqlQueryObject.addWhereIsNullCondition("servizi_applicativi.token_policy");
                    }
                    if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                        if (includiApplicativiNonModI || includiApplicativiModIEsterni || includiApplicativiModIInterni) {
                            ISQLQueryObject object = this.buildFiltroApplicativiTls(sqlQueryObject, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
                            sqlQueryObject.addWhereCondition(object.createSQLConditions());
                        } else {
                            sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                        }
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    int index = 1;
                    stm.setString(index++, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                    stm.setString(index++, cnSubject);
                    stm.setString(index++, cnIssuer);
                    if (aStrictVerifier) {
                        stm.setInt(index++, 1);
                    } else {
                        stm.setInt(index++, 0);
                    }
                    this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.CREDENZIALE_SSL.toString()));
                    IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                    rs = stm.executeQuery();
                    long idSA = -1L;
                    while (rs.next()) {
                        certificatoBytes = jdbcAdapter.getBinaryData(rs, "saCertificate");
                        certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])certificatoBytes, (int)0, null);
                        if (!aCertificate.equals(certificato.getCertificate(), aStrictVerifier)) continue;
                        idSA = rs.getLong("saIdentificativo");
                        break;
                    }
                    rs.close();
                    stm.close();
                    if (idSA <= 0L) {
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                        sqlQueryObject.addFromTable("servizi_applicativi");
                        sqlQueryObject.addFromTable("sa_credenziali");
                        if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                            sqlQueryObject.addFromTable("soggetti");
                        }
                        sqlQueryObject.addSelectAliasField("servizi_applicativi", "id", "saIdentificativo");
                        sqlQueryObject.addSelectAliasField("sa_credenziali", "cn_subject", "saCNSubject");
                        sqlQueryObject.addSelectAliasField("sa_credenziali", "cn_issuer", "saCNIssuer");
                        sqlQueryObject.addSelectAliasField("sa_credenziali", "cert_strict_verification", "saCertStrictVerificationr");
                        sqlQueryObject.addSelectAliasField("sa_credenziali", "certificate", "saCertificate");
                        sqlQueryObject.addSelectAliasField("servizi_applicativi", "tipoauth", "saTipoAuth");
                        sqlQueryObject.addWhereCondition("sa_credenziali.id_servizio_applicativo=servizi_applicativi.id");
                        sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                        sqlQueryObject.addWhereCondition("sa_credenziali.cn_subject = ?");
                        sqlQueryObject.addWhereCondition("sa_credenziali.cn_issuer = ?");
                        sqlQueryObject.addWhereCondition("sa_credenziali.cert_strict_verification = ?");
                        if (!tokenWithHttpsEnabled) {
                            sqlQueryObject.addWhereIsNullCondition("servizi_applicativi.token_policy");
                        }
                        if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                            if (includiApplicativiNonModI || includiApplicativiModIEsterni || includiApplicativiModIInterni) {
                                ISQLQueryObject object = this.buildFiltroApplicativiTls(sqlQueryObject, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
                                sqlQueryObject.addWhereCondition(object.createSQLConditions());
                            } else {
                                sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                            }
                        }
                        sqlQueryObject.setANDLogicOperator(true);
                        sqlQuery = sqlQueryObject.createSQLQuery();
                        stm = con.prepareStatement(sqlQuery);
                        index = 1;
                        stm.setString(index++, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                        stm.setString(index++, cnSubject);
                        stm.setString(index++, cnIssuer);
                        if (aStrictVerifier) {
                            stm.setInt(index++, 1);
                        } else {
                            stm.setInt(index++, 0);
                        }
                        this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.CREDENZIALE_SSL.toString()));
                        jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                        rs = stm.executeQuery();
                        while (rs.next()) {
                            certificatoBytes = jdbcAdapter.getBinaryData(rs, "saCertificate");
                            certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])certificatoBytes, (int)0, null);
                            if (!aCertificate.equals(certificato.getCertificate(), aStrictVerifier)) continue;
                            idSA = rs.getLong("saIdentificativo");
                            break;
                        }
                        rs.close();
                        stm.close();
                    }
                    if (idSA <= 0L) {
                        throw new DriverConfigurazioneNotFound("Nessun Servizio Applicativo trovato.");
                    }
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id = ?");
                    stm = con.prepareStatement(sqlQueryObject.toString());
                    stm.setLong(1, idSA);
                    this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, idSA));
                    break;
                }
                case 4: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                        sqlQueryObject.addFromTable("soggetti");
                    }
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("tipoauth = ?");
                    sqlQueryObject.addWhereCondition("utente = ?");
                    if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                        sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                    }
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setString(1, CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString());
                    stm.setString(2, principal);
                    this.driver.logDebug("eseguo query :" + DBUtils.formatSQLString(sqlQuery, CostantiConfigurazione.CREDENZIALE_PRINCIPAL.toString(), principal));
                    break;
                }
                case 7: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                        sqlQueryObject.addFromTable("soggetti");
                    }
                    sqlQueryObject.addSelectField("*");
                    List<FiltroRicercaProtocolPropertyConfig> modiFilter = null;
                    if (tokenWithHttpsEnabled) {
                        modiFilter = this.buildListModiTokenCredentials(tokenPolicy, tokenClientId);
                        ISQLQueryObject sqlQueryObjectBuiltIn = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                        sqlQueryObjectBuiltIn.addFromTable("servizi_applicativi");
                        sqlQueryObjectBuiltIn.addWhereCondition(false, new String[]{"tipoauth = ?", "tipoauth = ?"});
                        sqlQueryObjectBuiltIn.addWhereCondition("token_policy = ?");
                        sqlQueryObjectBuiltIn.addWhereCondition("utente = ?");
                        sqlQueryObjectBuiltIn.setANDLogicOperator(true);
                        ISQLQueryObject sqlQueryObjectModi = this.buildSQLQueryObjectModiTokenCredentials(modiFilter);
                        sqlQueryObject.addWhereCondition(sqlQueryObjectBuiltIn.createSQLConditions());
                        sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectModi);
                        sqlQueryObject.setANDLogicOperator(false);
                    } else {
                        sqlQueryObject.addWhereCondition("tipoauth = ?");
                        sqlQueryObject.addWhereCondition("token_policy = ?");
                        sqlQueryObject.addWhereCondition("utente = ?");
                        sqlQueryObject.setANDLogicOperator(true);
                    }
                    if (tipiSoggetto != null && !tipiSoggetto.isEmpty()) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                        sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                    }
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    int index = 1;
                    if (tokenWithHttpsEnabled) {
                        stm.setString(index++, CostantiConfigurazione.CREDENZIALE_TOKEN.toString());
                        stm.setString(index++, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                        stm.setString(index++, tokenPolicy);
                        stm.setString(index++, tokenClientId);
                        this.setSQLQueryObjectModiTokenCredentials(stm, index, modiFilter);
                    } else {
                        stm.setString(index++, CostantiConfigurazione.CREDENZIALE_TOKEN.toString());
                        stm.setString(index++, tokenPolicy);
                        stm.setString(index++, tokenClientId);
                    }
                    this.driver.logDebug("eseguo query (tokenPolicy:" + tokenPolicy + " tokenClientId:" + tokenClientId + "):" + sqlQuery);
                    break;
                }
                case 5: {
                    ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id = ?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, idServizioApplicativo);
                    this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, idServizioApplicativo));
                    break;
                }
            }
            if (stm == null) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Type '" + type + "' sconosciuto?");
            }
            rs = stm.executeQuery();
            if (!rs.next()) break block173;
            sa = new ServizioApplicativo();
            sa.setId(rs.getLong("id"));
            sa.setTipo(rs.getString("tipo"));
            sa.setNome(rs.getString("nome"));
            sa.setIdSoggetto(rs.getLong("id_soggetto"));
            sa.setTipoSoggettoProprietario(this.soggettiDriver.getSoggetto(sa.getIdSoggetto(), con).getTipo());
            sa.setNomeSoggettoProprietario(this.soggettiDriver.getSoggetto(sa.getIdSoggetto(), con).getNome());
            sa.setDescrizione(rs.getString("descrizione"));
            int as_client = rs.getInt("as_client");
            sa.setUseAsClient(1 == as_client);
            String tipoFruizione = rs.getString("tipologia_fruizione") != null && !"".equals(rs.getString("tipologia_fruizione")) ? rs.getString("tipologia_fruizione") : TipologiaFruizione.DISABILITATO.toString();
            String tipoErogazione = rs.getString("tipologia_erogazione") != null && !"".equals(rs.getString("tipologia_erogazione")) ? rs.getString("tipologia_erogazione") : TipologiaErogazione.DISABILITATO.toString();
            sa.setTipologiaFruizione(TipologiaFruizione.valueOf(tipoFruizione.toUpperCase()).toString());
            sa.setTipologiaErogazione(TipologiaErogazione.valueOf(tipoErogazione.toUpperCase()).toString());
            InvocazionePorta invPorta = null;
            String tipoAuth = rs.getString("tipoauth");
            String fault = rs.getString("fault");
            String faultActor = rs.getString("fault_actor");
            String prefixFault = rs.getString("prefix_fault_code");
            String genericFault = rs.getString("generic_fault_code");
            if (tipoAuth != null && !tipoAuth.equals("") || fault != null && !fault.equals("") || faultActor != null && !faultActor.equals("") || genericFault != null && !genericFault.equals("") || prefixFault != null && !prefixFault.equals("")) {
                invPorta = new InvocazionePorta();
                Credenziali credenziali = new Credenziali();
                credenziali.setTipo(DriverConfigurazioneDBLib.getEnumCredenzialeTipo(tipoAuth));
                credenziali.setUser(rs.getString("utente"));
                credenziali.setPassword(rs.getString("password"));
                if (CredenzialeTipo.APIKEY.equals(credenziali.getTipo())) {
                    credenziali.setAppId(CostantiDB.isAPPID(rs.getString("issuer")));
                } else {
                    credenziali.setIssuer(rs.getString("issuer"));
                }
                credenziali.setSubject(rs.getString("subject"));
                credenziali.setCnSubject(rs.getString("cn_subject"));
                credenziali.setCnIssuer(rs.getString("cn_issuer"));
                IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                credenziali.setCertificate(jdbcAdapter.getBinaryData(rs, "certificate"));
                int strict = rs.getInt("cert_strict_verification");
                if (strict == 1) {
                    credenziali.setCertificateStrictVerification(true);
                } else if (strict == 0) {
                    credenziali.setCertificateStrictVerification(false);
                }
                credenziali.setTokenPolicy(rs.getString("token_policy"));
                if (tipoAuth != null && !tipoAuth.equals("")) {
                    invPorta.addCredenziali(credenziali);
                }
                InvocazionePortaGestioneErrore gestioneErrore = new InvocazionePortaGestioneErrore();
                gestioneErrore.setFault(DriverConfigurazioneDBLib.getEnumFaultIntegrazioneTipo(fault));
                gestioneErrore.setFaultActor(faultActor);
                gestioneErrore.setGenericFaultCode(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(genericFault));
                gestioneErrore.setPrefixFaultCode(prefixFault);
                invPorta.setGestioneErrore(fault != null || faultActor != null || genericFault != null || prefixFault != null ? gestioneErrore : null);
                invPorta.setInvioPerRiferimento(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("invio_x_rif")));
                sbustamentoInfoProtocollo = rs.getInt("sbustamento_protocol_info");
                if (1 == sbustamentoInfoProtocollo) {
                    invPorta.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                } else if (0 == sbustamentoInfoProtocollo) {
                    invPorta.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.DISABILITATO);
                } else {
                    invPorta.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                }
            }
            Long idConnettore = rs.getLong("id_connettore_risp");
            String getMsgRisp = rs.getString("getmsgrisp");
            RispostaAsincrona rispAsinc = null;
            if (idConnettore > 0L || getMsgRisp != null && !getMsgRisp.equals("")) {
                rispAsinc = new RispostaAsincrona();
                rispAsinc.setAutenticazione(DriverConfigurazioneDBLib.getEnumInvocazioneServizioTipoAutenticazione(rs.getString("tipoauthrisp")));
                rispAsinc.setInvioPerRiferimento(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("invio_x_rif_risp")));
                rispAsinc.setRispostaPerRiferimento(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("risposta_x_rif_risp")));
                if (rispAsinc.getAutenticazione() != null && InvocazioneServizioTipoAutenticazione.BASIC.equals(rispAsinc.getAutenticazione())) {
                    InvocazioneCredenziali credenzialiRispA = new InvocazioneCredenziali();
                    String encValue2 = rs.getString("enc_passwordrisp");
                    String plainValue = rs.getString("passwordrisp");
                    if (encValue2 != null && StringUtils.isNotEmpty((CharSequence)encValue2)) {
                        IDriverBYOK driverBYOK = this.driver.getDriverUnwrapBYOK();
                        if (driverBYOK != null) {
                            credenzialiRispA.setPassword(driverBYOK.unwrapAsString(encValue2));
                        } else {
                            credenzialiRispA.setPassword(encValue2);
                        }
                    } else {
                        credenzialiRispA.setPassword(plainValue);
                    }
                    credenzialiRispA.setUser(rs.getString("utenterisp"));
                    rispAsinc.setCredenziali(credenzialiRispA);
                }
                Connettore connettore = DriverConfigurazioneDB_connettoriLIB.getConnettore(idConnettore, con, this.driver.getDriverUnwrapBYOK());
                rispAsinc.setConnettore(connettore);
                rispAsinc.setGetMessage(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(getMsgRisp));
                sbustamentoInfoProtocollo = rs.getInt("sbustamento_protocol_info_risp");
                if (1 == sbustamentoInfoProtocollo) {
                    rispAsinc.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                } else if (0 == sbustamentoInfoProtocollo) {
                    rispAsinc.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.DISABILITATO);
                } else {
                    rispAsinc.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                }
                if (rs.getInt("sbustamentorisp") == 1) {
                    rispAsinc.setSbustamentoSoap(CostantiConfigurazione.ABILITATO);
                } else {
                    rispAsinc.setSbustamentoSoap(CostantiConfigurazione.DISABILITATO);
                }
                Long idGestioneErroreRispostaAsincrona = rs.getLong("id_gestione_errore_risp");
                GestioneErrore gestioneErroreRispostaAsincrona = null;
                if (idGestioneErroreRispostaAsincrona > 0L) {
                    gestioneErroreRispostaAsincrona = DriverConfigurazioneDB_gestioneErroreLIB.getGestioneErrore(idGestioneErroreRispostaAsincrona, con);
                    rispAsinc.setGestioneErrore(gestioneErroreRispostaAsincrona);
                }
            }
            idConnettore = rs.getLong("id_connettore_inv");
            String getMsgInv = rs.getString("getmsginv");
            InvocazioneServizio invServizio = null;
            if (idConnettore > 0L || getMsgInv != null && !getMsgInv.equals("")) {
                invServizio = new InvocazioneServizio();
                Connettore connserv = DriverConfigurazioneDB_connettoriLIB.getConnettore(idConnettore, con, this.driver.getDriverUnwrapBYOK());
                invServizio.setConnettore(connserv);
                invServizio.setGetMessage(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(getMsgInv));
                int sbustamentoInfoProtocollo2 = rs.getInt("sbustamento_protocol_info_inv");
                if (1 == sbustamentoInfoProtocollo2) {
                    invServizio.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                } else if (0 == sbustamentoInfoProtocollo2) {
                    invServizio.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.DISABILITATO);
                } else {
                    invServizio.setSbustamentoInformazioniProtocollo(CostantiConfigurazione.ABILITATO);
                }
                if (rs.getInt("sbustamentoinv") == 1) {
                    invServizio.setSbustamentoSoap(CostantiConfigurazione.ABILITATO);
                } else {
                    invServizio.setSbustamentoSoap(CostantiConfigurazione.DISABILITATO);
                }
                invServizio.setAutenticazione(DriverConfigurazioneDBLib.getEnumInvocazioneServizioTipoAutenticazione(rs.getString("tipoauthinv")));
                invServizio.setInvioPerRiferimento(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("invio_x_rif_inv")));
                invServizio.setRispostaPerRiferimento(DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("risposta_x_rif_inv")));
                if (invServizio.getAutenticazione() != null && InvocazioneServizioTipoAutenticazione.BASIC.equals(invServizio.getAutenticazione())) {
                    InvocazioneCredenziali credInvServ = new InvocazioneCredenziali();
                    encValue = rs.getString("enc_passwordinv");
                    String plainValue = rs.getString("passwordinv");
                    if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                        IDriverBYOK driverBYOK = this.driver.getDriverUnwrapBYOK();
                        if (driverBYOK != null) {
                            credInvServ.setPassword(driverBYOK.unwrapAsString(encValue));
                        } else {
                            credInvServ.setPassword(encValue);
                        }
                    } else {
                        credInvServ.setPassword(plainValue);
                    }
                    credInvServ.setUser(rs.getString("utenteinv"));
                    invServizio.setCredenziali(credInvServ);
                }
                Long idGestioneErroreInvocazioneServizio = rs.getLong("id_gestione_errore_inv");
                GestioneErrore gestioneErroreInvocazioneServizio = null;
                if (idGestioneErroreInvocazioneServizio > 0L) {
                    gestioneErroreInvocazioneServizio = DriverConfigurazioneDB_gestioneErroreLIB.getGestioneErrore(idGestioneErroreInvocazioneServizio, con);
                    invServizio.setGestioneErrore(gestioneErroreInvocazioneServizio);
                }
            }
            sa.setInvocazionePorta(invPorta);
            sa.setRispostaAsincrona(rispAsinc);
            sa.setInvocazioneServizio(invServizio);
            if (sa.getTipologiaErogazione() == null) {
                sa.setTipologiaErogazione(TipologiaErogazione.DISABILITATO.getValue());
            }
            if (sa.getTipologiaFruizione() == null) {
                sa.setTipologiaFruizione(TipologiaFruizione.DISABILITATO.getValue());
            }
            if (TipologiaErogazione.DISABILITATO.equals(sa.getTipologiaErogazione()) && TipologiaFruizione.DISABILITATO.equals(sa.getTipologiaFruizione())) {
                if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().sizeCredenzialiList() > 0) {
                    sa.setTipologiaFruizione(TipologiaFruizione.NORMALE.getValue());
                }
                if (sa.getInvocazioneServizio() != null) {
                    if (StatoFunzionalita.ABILITATO.equals(sa.getInvocazioneServizio().getGetMessage())) {
                        sa.setTipologiaErogazione(TipologiaErogazione.MESSAGE_BOX.getValue());
                    } else if (sa.getInvocazioneServizio().getConnettore() != null && !TipiConnettore.DISABILITATO.getNome().equals(sa.getInvocazioneServizio().getConnettore().getTipo())) {
                        sa.setTipologiaErogazione(TipologiaErogazione.TRASPARENTE.getValue());
                    }
                }
            }
            sa.setProprietaOggetto(this.utilsDriver.readProprietaOggetto(rs, false));
            rs.close();
            stm.close();
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("sa_ruoli");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, sa.getId());
            rs = stm.executeQuery();
            while (rs.next()) {
                if (sa.getInvocazionePorta() == null) {
                    sa.setInvocazionePorta(new InvocazionePorta());
                }
                if (sa.getInvocazionePorta().getRuoli() == null) {
                    sa.getInvocazionePorta().setRuoli(new ServizioApplicativoRuoli());
                }
                Ruolo ruolo = new Ruolo();
                ruolo.setNome(rs.getString("ruolo"));
                sa.getInvocazionePorta().getRuoli().addRuolo(ruolo);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("sa_credenziali");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            sqlQueryObject.addOrderBy("id", true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, sa.getId());
            rs = stm.executeQuery();
            while (rs.next()) {
                if (sa.getInvocazionePorta() == null) {
                    sa.setInvocazionePorta(new InvocazionePorta());
                }
                Credenziali credenziali = new Credenziali();
                credenziali.setTipo(DriverConfigurazioneDBLib.getEnumCredenzialeTipo(tipoAuth));
                credenziali.setIssuer(rs.getString("issuer"));
                credenziali.setSubject(rs.getString("subject"));
                credenziali.setCnSubject(rs.getString("cn_subject"));
                credenziali.setCnIssuer(rs.getString("cn_issuer"));
                IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                credenziali.setCertificate(jdbcAdapter.getBinaryData(rs, "certificate"));
                int strict = rs.getInt("cert_strict_verification");
                if (strict == 1) {
                    credenziali.setCertificateStrictVerification(true);
                } else if (strict == 0) {
                    credenziali.setCertificateStrictVerification(false);
                }
                sa.getInvocazionePorta().addCredenziali(credenziali);
            }
            rs.close();
            stm.close();
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("sa_properties");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_servizio_applicativo=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, sa.getId());
            rs = stm.executeQuery();
            while (rs.next()) {
                Proprieta proprieta = new Proprieta();
                proprieta.setNome(rs.getString("nome"));
                String plainValue = rs.getString("valore");
                encValue = rs.getString("enc_value");
                if (encValue != null && StringUtils.isNotEmpty((CharSequence)encValue)) {
                    IDriverBYOK driverBYOK = this.driver.getDriverUnwrapBYOK();
                    if (driverBYOK != null) {
                        proprieta.setValore(driverBYOK.unwrapAsString(encValue));
                    } else {
                        proprieta.setValore(encValue);
                    }
                } else {
                    proprieta.setValore(plainValue);
                }
                sa.addProprieta(proprieta);
            }
            rs.close();
            stm.close();
            try {
                List<ProtocolProperty> listPP = DriverConfigurazioneDBLib.getListaProtocolProperty(sa.getId(), ProprietariProtocolProperty.SERVIZIO_APPLICATIVO, con, this.driver.tipoDB, this.driver.getDriverUnwrapBYOK());
                if (listPP != null && !listPP.isEmpty()) {
                    for (ProtocolProperty protocolProperty : listPP) {
                        sa.addProtocolProperty(protocolProperty);
                    }
                }
            }
            catch (DriverConfigurazioneNotFound driverConfigurazioneNotFound) {
                // empty catch block
            }
            ServizioApplicativo servizioApplicativo = sa;
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
            return servizioApplicativo;
        }
        try {
            try {
                throw new DriverConfigurazioneNotFound("Nessun Servizio Applicativo trovato.");
            }
            catch (SQLException e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] SQLException :" + e.getMessage(), e);
            }
            catch (DriverConfigurazioneNotFound e) {
                throw new DriverConfigurazioneNotFound(e);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Exception :" + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(rs, stm);
            this.driver.closeConnection(con);
            throw throwable;
        }
    }

    private List<FiltroRicercaProtocolPropertyConfig> buildListModiTokenCredentials(String tokenPolicy, String tokenClientId) throws SQLQueryObjectException {
        ArrayList<FiltroRicercaProtocolPropertyConfig> list = new ArrayList<FiltroRicercaProtocolPropertyConfig>();
        FiltroRicercaProtocolPropertyConfig pTokenPolicy = new FiltroRicercaProtocolPropertyConfig();
        pTokenPolicy.setName("modipaSecurityTokenPolicy");
        pTokenPolicy.setValueAsString(tokenPolicy);
        list.add(pTokenPolicy);
        FiltroRicercaProtocolPropertyConfig pTokenClientId = new FiltroRicercaProtocolPropertyConfig();
        pTokenClientId.setName("modipaSecurityTokenClientId");
        pTokenClientId.setValueAsString(tokenClientId);
        list.add(pTokenClientId);
        return list;
    }

    private ISQLQueryObject buildSQLQueryObjectModiTokenCredentials(List<FiltroRicercaProtocolPropertyConfig> list) throws SQLQueryObjectException {
        ISQLQueryObject sqlQueryObjectProtocolProperties = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
        this.protocolPropertiesDriver._setProtocolPropertiesForSearch(sqlQueryObjectProtocolProperties, list, "servizi_applicativi");
        return sqlQueryObjectProtocolProperties;
    }

    private void setSQLQueryObjectModiTokenCredentials(PreparedStatement stmt, int index, List<FiltroRicercaProtocolPropertyConfig> list) throws SQLQueryObjectException, SQLException, JDBCAdapterException, UtilsException {
        this.protocolPropertiesDriver._setProtocolPropertiesForSearch(stmt, index, list, ProprietariProtocolProperty.SERVIZIO_APPLICATIVO);
    }

    private ISQLQueryObject buildFiltroApplicativiTls(ISQLQueryObject sqlQueryObject, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws SQLQueryObjectException {
        ISQLQueryObject object = null;
        if (includiApplicativiNonModI || includiApplicativiModIEsterni || includiApplicativiModIInterni) {
            object = sqlQueryObject.newSQLQueryObject();
            object.setANDLogicOperator(false);
            if (includiApplicativiNonModI) {
                ISQLQueryObject notModI = sqlQueryObject.newSQLQueryObject();
                notModI.setANDLogicOperator(true);
                notModI.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                notModI.setNOTBeforeConditions(true);
                object.addWhereCondition(notModI.createSQLConditions());
            }
            ISQLQueryObject modIEsterniPdd = null;
            if (includiApplicativiModIEsterni || includiApplicativiModIInterni) {
                modIEsterniPdd = sqlQueryObject.newSQLQueryObject();
                modIEsterniPdd.addFromTable("soggetti");
                modIEsterniPdd.setANDLogicOperator(false);
                modIEsterniPdd.addWhereIsNullCondition("soggetti.server");
                if (!TipiDatabase.ORACLE.toString().equals(sqlQueryObject.getTipoDatabase())) {
                    modIEsterniPdd.addWhereIsEmptyCondition("soggetti.server");
                }
                ISQLQueryObject modIEsterniPddQuery = sqlQueryObject.newSQLQueryObject();
                modIEsterniPddQuery.addFromTable("pdd");
                modIEsterniPddQuery.setANDLogicOperator(true);
                modIEsterniPddQuery.addSelectAliasField("pdd", "nome", "nomeServer");
                modIEsterniPddQuery.addWhereCondition("soggetti.server=pdd.nome");
                modIEsterniPddQuery.addWhereCondition("pdd.tipo='esterno'");
                modIEsterniPdd.addWhereExistsCondition(false, modIEsterniPddQuery);
                modIEsterniPdd.setNOTBeforeConditions(!includiApplicativiModIEsterni);
                ISQLQueryObject modIEsterniP = sqlQueryObject.newSQLQueryObject();
                modIEsterniP.setANDLogicOperator(true);
                modIEsterniP.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                modIEsterniP.addWhereCondition(modIEsterniPdd.createSQLConditions());
                object.addWhereCondition(modIEsterniP.createSQLConditions());
            }
        }
        return object;
    }

    protected void createServizioApplicativo(ServizioApplicativo aSA) throws DriverConfigurazioneException {
        if (aSA == null) {
            throw new DriverConfigurazioneException("Servizio Applicativo non valido");
        }
        if (aSA.getNome() == null || aSA.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Servizio Applicativo non valido");
        }
        if (aSA.getNomeSoggettoProprietario() == null || aSA.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Servizio Applicativo non valido");
        }
        if (aSA.getTipoSoggettoProprietario() == null || aSA.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Servizio Applicativo non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("createServizioApplicativo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDServizioApplicativo type = 1");
            DriverConfigurazioneDB_serviziApplicativiLIB.CRUDServizioApplicativo(1, aSA, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createServizioApplicativo] Errore durante la creazione del servizioApplicativo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void updateServizioApplicativo(ServizioApplicativo aSA) throws DriverConfigurazioneException {
        if (aSA == null) {
            throw new DriverConfigurazioneException("Servizio Applicativo non valida");
        }
        if (aSA.getNome() == null || aSA.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Servizio Applicativo non valido");
        }
        if (aSA.getNomeSoggettoProprietario() == null || aSA.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Servizio Applicativo non valido");
        }
        if (aSA.getTipoSoggettoProprietario() == null || aSA.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Servizio Applicativo non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("updateServizioApplicativo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::updateServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDServizioApplicativo type = 2");
            DriverConfigurazioneDB_serviziApplicativiLIB.CRUDServizioApplicativo(2, aSA, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("Errore durante l'aggiornamento del servizioApplicativo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected void deleteServizioApplicativo(ServizioApplicativo aSA) throws DriverConfigurazioneException {
        if (aSA == null) {
            throw new DriverConfigurazioneException("Servizio Applicativo non valida");
        }
        if (aSA.getNome() == null || aSA.getNome().equals("")) {
            throw new DriverConfigurazioneException("Nome Servizio Applicativo non valido");
        }
        if (aSA.getNomeSoggettoProprietario() == null || aSA.getNomeSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Nome Soggetto Proprietario Servizio Applicativo non valido");
        }
        if (aSA.getTipoSoggettoProprietario() == null || aSA.getTipoSoggettoProprietario().equals("")) {
            throw new DriverConfigurazioneException("Tipo Soggetto Proprietario Servizio Applicativo non valido");
        }
        Connection con = null;
        boolean error = false;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("deleteServizioApplicativo");
                con.setAutoCommit(false);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            this.driver.logDebug("CRUDServizioApplicativo type = 3");
            DriverConfigurazioneDB_serviziApplicativiLIB.CRUDServizioApplicativo(3, aSA, con, this.driver.getDriverWrapBYOK());
        }
        catch (Exception qe) {
            error = true;
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::deleteServizioApplicativo] Errore durante la delete del servizioApplicativo : " + qe.getMessage(), qe);
        }
        finally {
            this.driver.closeConnection(error, con);
        }
    }

    protected List<ServizioApplicativo> servizioApplicativoWithCredenzialiBasicList(String utente, String password, boolean checkPassword) throws DriverConfigurazioneException {
        ArrayList<ServizioApplicativo> arrayList;
        String nomeMetodo = "servizioApplicativoWithCredenzialiBasicList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("tipoauth = ?");
            sqlQueryObject.addWhereCondition("utente = ?");
            if (checkPassword) {
                sqlQueryObject.addWhereCondition("password = ?");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, CredenzialeTipo.BASIC.getValue());
            stmt.setString(index++, utente);
            if (checkPassword) {
                stmt.setString(index++, password);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("id"));
                lista.add(sa);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<ServizioApplicativo> servizioApplicativoWithCredenzialiApiKeyList(String utente, boolean appId) throws DriverConfigurazioneException {
        ArrayList<ServizioApplicativo> arrayList;
        String nomeMetodo = "servizioApplicativoWithCredenzialiApiKeyList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("tipoauth = ?");
            sqlQueryObject.addWhereCondition("utente = ?");
            sqlQueryObject.addWhereCondition("issuer = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, CredenzialeTipo.APIKEY.getValue());
            stmt.setString(index++, utente);
            stmt.setString(index++, CostantiDB.getIssuerApiKey(appId));
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("id"));
                lista.add(sa);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<ServizioApplicativo> servizioApplicativoWithCredenzialiSslList(String subject, String issuer, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws DriverConfigurazioneException {
        String nomeMetodo = "servizioApplicativoWithCredenzialiSslList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            for (int i = 0; i < 2; ++i) {
                List listValues;
                String tabella = null;
                tabella = i == 0 ? "servizi_applicativi" : "sa_credenziali";
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                if (tipiSoggetto != null) {
                    sqlQueryObject.addFromTable("soggetti");
                }
                if (i > 0) {
                    sqlQueryObject.addFromTable("sa_credenziali");
                }
                sqlQueryObject.addSelectAliasField("servizi_applicativi", "id", "saIdentificativo");
                sqlQueryObject.addSelectAliasField(tabella, "subject", "saSubject");
                sqlQueryObject.addSelectAliasField(tabella, "issuer", "saIssuer");
                sqlQueryObject.addSelectAliasField("servizi_applicativi", "tipoauth", "saTipoAuth");
                if (tipiSoggetto != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                    if (includiApplicativiNonModI || includiApplicativiModIEsterni || includiApplicativiModIInterni) {
                        ISQLQueryObject object = this.buildFiltroApplicativiTls(sqlQueryObject, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
                        sqlQueryObject.addWhereCondition(object.createSQLConditions());
                    } else {
                        sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                    }
                }
                if (i > 0) {
                    sqlQueryObject.addWhereCondition("sa_credenziali.id_servizio_applicativo=servizi_applicativi.id");
                }
                sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                boolean tokenWithHttpsEnabled = false;
                if (!tokenWithHttpsEnabled) {
                    sqlQueryObject.addWhereIsNullCondition("servizi_applicativi.token_policy");
                }
                Map hashSubject = CertificateUtils.getPrincipalIntoMap((String)subject, (PrincipalType)PrincipalType.SUBJECT);
                Map hashIssuer = null;
                if (StringUtils.isNotEmpty((CharSequence)issuer)) {
                    hashIssuer = CertificateUtils.getPrincipalIntoMap((String)issuer, (PrincipalType)PrincipalType.ISSUER);
                }
                for (String key : hashSubject.keySet()) {
                    listValues = (List)hashSubject.get(key);
                    for (String value : listValues) {
                        sqlQueryObject.addWhereLikeCondition(tabella + ".subject", "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", true, true, false);
                    }
                }
                if (hashIssuer != null) {
                    for (String key : hashIssuer.keySet()) {
                        listValues = (List)hashIssuer.get(key);
                        for (String value : listValues) {
                            sqlQueryObject.addWhereLikeCondition(tabella + ".issuer", "/" + CertificateUtils.formatKeyPrincipal((String)key) + "=" + CertificateUtils.formatValuePrincipal((String)value) + "/", true, true, false);
                        }
                    }
                } else {
                    sqlQueryObject.addWhereIsNullCondition(tabella + ".issuer");
                }
                sqlQueryObject.setANDLogicOperator(true);
                String queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setString(1, CredenzialeTipo.SSL.getValue());
                risultato = stmt.executeQuery();
                while (risultato.next()) {
                    String subjectPotenziale = risultato.getString("saSubject");
                    boolean subjectValid = CertificateUtils.sslVerify((String)subjectPotenziale, (String)subject, (PrincipalType)PrincipalType.SUBJECT, (Logger)this.driver.log);
                    boolean issuerValid = true;
                    if (hashIssuer != null) {
                        String issuerPotenziale = risultato.getString("saIssuer");
                        issuerValid = StringUtils.isNotEmpty((CharSequence)issuerPotenziale) ? CertificateUtils.sslVerify((String)issuerPotenziale, (String)issuer, (PrincipalType)PrincipalType.ISSUER, (Logger)this.driver.log) : false;
                    }
                    if (!subjectValid || !issuerValid) continue;
                    ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("saIdentificativo"));
                    lista.add(sa);
                }
                risultato.close();
                risultato = null;
                stmt.close();
                stmt = null;
            }
            ArrayList<ServizioApplicativo> i = lista;
            return i;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            JDBCUtilities.closeResources(risultato, stmt);
            this.driver.closeConnection(con);
        }
    }

    protected List<ServizioApplicativo> servizioApplicativoWithCredenzialiSslList(CertificateInfo certificate, boolean strictVerifier, List<String> tipiSoggetto, boolean includiApplicativiNonModI, boolean includiApplicativiModIEsterni, boolean includiApplicativiModIInterni) throws DriverConfigurazioneException {
        String nomeMetodo = "servizioApplicativoWithCredenzialiSslList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            for (int i = 0; i < 2; ++i) {
                String tabella = null;
                tabella = i == 0 ? "servizi_applicativi" : "sa_credenziali";
                ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                if (tipiSoggetto != null) {
                    sqlQueryObject.addFromTable("soggetti");
                }
                if (i > 0) {
                    sqlQueryObject.addFromTable("sa_credenziali");
                }
                sqlQueryObject.addSelectAliasField("servizi_applicativi", "id", "saIdentificativo");
                sqlQueryObject.addSelectAliasField(tabella, "cn_subject", "saCNSubject");
                sqlQueryObject.addSelectAliasField(tabella, "cn_issuer", "saCNIssuer");
                sqlQueryObject.addSelectAliasField(tabella, "cert_strict_verification", "saCertStrictVerificationr");
                sqlQueryObject.addSelectAliasField(tabella, "certificate", "saCertificate");
                if (tipiSoggetto != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                    if (includiApplicativiNonModI || includiApplicativiModIEsterni || includiApplicativiModIInterni) {
                        ISQLQueryObject object = this.buildFiltroApplicativiTls(sqlQueryObject, tipiSoggetto, includiApplicativiNonModI, includiApplicativiModIEsterni, includiApplicativiModIInterni);
                        sqlQueryObject.addWhereCondition(object.createSQLConditions());
                    } else {
                        sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiSoggetto.toArray(new String[1]));
                    }
                }
                if (i > 0) {
                    sqlQueryObject.addWhereCondition("sa_credenziali.id_servizio_applicativo=servizi_applicativi.id");
                }
                sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                boolean tokenWithHttpsEnabled = false;
                if (!tokenWithHttpsEnabled) {
                    sqlQueryObject.addWhereIsNullCondition("servizi_applicativi.token_policy");
                }
                sqlQueryObject.addWhereCondition(tabella + ".cn_subject = ?");
                sqlQueryObject.addWhereCondition(tabella + ".cn_issuer = ?");
                sqlQueryObject.setANDLogicOperator(true);
                String queryString = sqlQueryObject.createSQLQuery();
                String cnSubject = certificate.getSubject().getCN();
                String cnIssuer = certificate.getIssuer().getCN();
                stmt = con.prepareStatement(queryString);
                int indexStmt = 1;
                stmt.setString(indexStmt++, CredenzialeTipo.SSL.getValue());
                stmt.setString(indexStmt++, cnSubject);
                stmt.setString(indexStmt++, cnIssuer);
                risultato = stmt.executeQuery();
                IJDBCAdapter jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)this.driver.tipoDB);
                while (risultato.next()) {
                    byte[] certificatoBytes = jdbcAdapter.getBinaryData(risultato, "saCertificate");
                    Certificate certificato = ArchiveLoader.load((ArchiveType)ArchiveType.CER, (byte[])certificatoBytes, (int)0, null);
                    if (!certificate.equals(certificato.getCertificate(), strictVerifier)) continue;
                    ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("saIdentificativo"));
                    lista.add(sa);
                }
                risultato.close();
                risultato = null;
                stmt.close();
                stmt = null;
            }
            ArrayList<ServizioApplicativo> i = lista;
            return i;
        }
        catch (Exception qe) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
        }
        finally {
            JDBCUtilities.closeResources(risultato, stmt);
            this.driver.closeConnection(con);
        }
    }

    protected List<ServizioApplicativo> servizioApplicativoWithCredenzialiPrincipalList(String principal) throws DriverConfigurazioneException {
        ArrayList<ServizioApplicativo> arrayList;
        String nomeMetodo = "servizioApplicativoWithCredenzialiPrincipalList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("tipoauth = ?");
            sqlQueryObject.addWhereCondition("utente = ?");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setString(1, CredenzialeTipo.PRINCIPAL.getValue());
            stmt.setString(2, principal);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("id"));
                lista.add(sa);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<ServizioApplicativo> servizioApplicativoWithCredenzialiTokenList(String tokenPolicy, String tokenClientId, boolean tokenWithHttpsEnabled) throws DriverConfigurazioneException {
        ArrayList<ServizioApplicativo> arrayList;
        String nomeMetodo = "servizioApplicativoWithCredenzialiTokenList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addSelectField("nome");
            sqlQueryObject.addSelectField("id_soggetto");
            List<FiltroRicercaProtocolPropertyConfig> modiFilter = null;
            if (tokenWithHttpsEnabled) {
                modiFilter = this.buildListModiTokenCredentials(tokenPolicy, tokenClientId);
                ISQLQueryObject sqlQueryObjectBuiltIn = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObjectBuiltIn.addFromTable("servizi_applicativi");
                sqlQueryObjectBuiltIn.addWhereCondition(false, new String[]{"tipoauth = ?", "tipoauth = ?"});
                sqlQueryObjectBuiltIn.addWhereCondition("token_policy = ?");
                sqlQueryObjectBuiltIn.addWhereCondition("utente = ?");
                sqlQueryObjectBuiltIn.setANDLogicOperator(true);
                ISQLQueryObject sqlQueryObjectModi = this.buildSQLQueryObjectModiTokenCredentials(modiFilter);
                sqlQueryObject.addWhereCondition(sqlQueryObjectBuiltIn.createSQLConditions());
                sqlQueryObject.addWhereExistsCondition(false, sqlQueryObjectModi);
                sqlQueryObject.setANDLogicOperator(false);
            } else {
                sqlQueryObject.addWhereCondition("tipoauth = ?");
                sqlQueryObject.addWhereCondition("token_policy = ?");
                sqlQueryObject.addWhereCondition("utente = ?");
                sqlQueryObject.setANDLogicOperator(true);
            }
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            if (tokenWithHttpsEnabled) {
                stmt.setString(index++, CostantiConfigurazione.CREDENZIALE_TOKEN.toString());
                stmt.setString(index++, CostantiConfigurazione.CREDENZIALE_SSL.toString());
                stmt.setString(index++, tokenPolicy);
                stmt.setString(index++, tokenClientId);
                this.setSQLQueryObjectModiTokenCredentials(stmt, index, modiFilter);
            } else {
                stmt.setString(index++, CostantiConfigurazione.CREDENZIALE_TOKEN.toString());
                stmt.setString(index++, tokenPolicy);
                stmt.setString(index++, tokenClientId);
            }
            this.driver.logDebug("eseguo query (tokenPolicy:" + tokenPolicy + " tokenClientId:" + tokenClientId + "):" + queryString);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                ServizioApplicativo sa = this.getServizioApplicativo(risultato.getLong("id"));
                lista.add(sa);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected String[] soggettiServizioApplicativoList(long idSoggetto) throws DriverConfigurazioneException {
        String[] stringArray;
        String nomeMetodo = "soggettiServizioApplicativoList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        String[] silList = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("soggettiServizioApplicativoList");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectCountField("*", "cont");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            if (risultato.next()) {
                silList = new String[risultato.getInt(1)];
            }
            risultato.close();
            stmt.close();
            if (silList != null) {
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("nome");
                sqlQueryObject.addSelectField("id_soggetto");
                sqlQueryObject.addWhereCondition("id_soggetto = ?");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                queryString = sqlQueryObject.createSQLQuery();
                stmt = con.prepareStatement(queryString);
                stmt.setLong(1, idSoggetto);
                risultato = stmt.executeQuery();
                int i = 0;
                while (risultato.next()) {
                    silList[i] = risultato.getString("nome");
                    ++i;
                }
            }
            stringArray = silList;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return stringArray;
    }

    protected List<IDServizioApplicativoDB> soggettiServizioApplicativoList(IDSoggetto idSoggetto, String superuser, CredenzialeTipo credenziale, Boolean appId, String tipoSA, boolean bothSslAndToken, String tokenPolicy) throws DriverConfigurazioneException {
        return this.soggettiServizioApplicativoList(idSoggetto, superuser, credenziale, appId, tipoSA, bothSslAndToken, tokenPolicy, false);
    }

    protected List<IDServizioApplicativoDB> soggettiServizioApplicativoList(IDSoggetto idSoggetto, String superuser, CredenzialeTipo credenziale, Boolean appId, String tipoSA, boolean bothSslAndToken, String tokenPolicy, boolean tokenPolicyOR) throws DriverConfigurazioneException {
        ArrayList<IDServizioApplicativoDB> arrayList;
        String nomeMetodo = "soggettiServizioApplicativoList";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<IDServizioApplicativoDB> silList = new ArrayList<IDServizioApplicativoDB>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("servizi_applicativi", "id", "idServAppl");
            sqlQueryObject.addSelectAliasField("servizi_applicativi", "nome", "nomeServAppl");
            sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
            sqlQueryObject.addSelectField("id_soggetto");
            sqlQueryObject.addWhereCondition("id_soggetto = soggetti.id");
            sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
            sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                sqlQueryObject.addWhereCondition("soggetti.superuser = ?");
            }
            if (tipoSA != null) {
                if ("client".equals(tipoSA)) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipo = ?", "servizi_applicativi.as_client = ?"});
                } else {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.tipo = ?");
                }
            }
            if (credenziale != null) {
                if (tokenPolicyOR) {
                    ISQLQueryObject sqlQueryObjectTrasporto = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectTrasporto.addFromTable("servizi_applicativi");
                    sqlQueryObjectTrasporto.addWhereCondition("servizi_applicativi.tipoauth = ?");
                    if (CredenzialeTipo.APIKEY.equals(credenziale) && appId != null) {
                        sqlQueryObjectTrasporto.addWhereCondition("servizi_applicativi.issuer = ?");
                    }
                    sqlQueryObjectTrasporto.setANDLogicOperator(true);
                    String trasporto = sqlQueryObjectTrasporto.createSQLConditions();
                    ISQLQueryObject sqlQueryObjectToken = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                    sqlQueryObjectToken.addFromTable("servizi_applicativi");
                    sqlQueryObjectToken.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = ?", "servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy IS NOT NULL AND servizi_applicativi.utente IS NOT NULL"});
                    if (tokenPolicy != null) {
                        sqlQueryObjectToken.addWhereCondition("servizi_applicativi.token_policy = ?");
                    }
                    sqlQueryObjectToken.setANDLogicOperator(true);
                    String token = sqlQueryObjectToken.createSQLConditions();
                    sqlQueryObject.addWhereCondition(false, new String[]{trasporto, token});
                } else {
                    if (CredenzialeTipo.TOKEN.equals(credenziale)) {
                        if (bothSslAndToken) {
                            sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy IS NOT NULL AND servizi_applicativi.utente IS NOT NULL");
                        } else {
                            sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.tipoauth = ?", "servizi_applicativi.tipoauth = ? AND servizi_applicativi.token_policy IS NOT NULL AND servizi_applicativi.utente IS NOT NULL"});
                        }
                    } else {
                        boolean tokenWithHttpsEnabled;
                        sqlQueryObject.addWhereCondition("servizi_applicativi.tipoauth = ?");
                        if (CredenzialeTipo.SSL.equals(credenziale) && !(tokenWithHttpsEnabled = false)) {
                            sqlQueryObject.addWhereIsNullCondition("servizi_applicativi.token_policy");
                        }
                    }
                    if (CredenzialeTipo.APIKEY.equals(credenziale) && appId != null) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.issuer = ?");
                    }
                    if (tokenPolicy != null) {
                        sqlQueryObject.addWhereCondition("servizi_applicativi.token_policy = ?");
                    }
                }
            }
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            int index = 1;
            stmt.setString(index++, idSoggetto.getTipo());
            stmt.setString(index++, idSoggetto.getNome());
            if (this.driver.useSuperUser && superuser != null && !"".equals(superuser)) {
                stmt.setString(index++, superuser);
            }
            if (tipoSA != null) {
                stmt.setString(index++, tipoSA);
                if ("client".equals(tipoSA)) {
                    stmt.setInt(index++, 1);
                }
            }
            if (credenziale != null) {
                if (tokenPolicyOR) {
                    stmt.setString(index++, credenziale.getValue());
                    if (CredenzialeTipo.APIKEY.equals(credenziale) && appId != null) {
                        stmt.setString(index++, CostantiDB.getIssuerApiKey(appId));
                    }
                    stmt.setString(index++, CredenzialeTipo.TOKEN.getValue());
                    stmt.setString(index++, CredenzialeTipo.SSL.getValue());
                    if (tokenPolicy != null) {
                        stmt.setString(index++, tokenPolicy);
                    }
                } else {
                    if (CredenzialeTipo.TOKEN.equals(credenziale)) {
                        if (bothSslAndToken) {
                            stmt.setString(index++, CredenzialeTipo.SSL.getValue());
                        } else {
                            stmt.setString(index++, credenziale.getValue());
                            stmt.setString(index++, CredenzialeTipo.SSL.getValue());
                        }
                    } else {
                        stmt.setString(index++, credenziale.getValue());
                    }
                    if (CredenzialeTipo.APIKEY.equals(credenziale) && appId != null) {
                        stmt.setString(index++, CostantiDB.getIssuerApiKey(appId));
                    }
                    if (tokenPolicy != null) {
                        stmt.setString(index++, tokenPolicy);
                    }
                }
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                IDServizioApplicativoDB idSA = new IDServizioApplicativoDB();
                idSA.setIdSoggettoProprietario(new IDSoggetto(risultato.getString("tipo_soggetto"), risultato.getString("nome_soggetto")));
                idSA.setNome(risultato.getString("nomeServAppl"));
                idSA.setId(risultato.getLong("idServAppl"));
                silList.add(idSA);
            }
            arrayList = silList;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<String> nomiProprietaSA(String filterSoggettoTipo, String filterSoggettoNome, List<String> tipoSoggettiProtocollo) throws DriverConfigurazioneException {
        ArrayList<String> arrayList;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<String> lista = new ArrayList<String>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("nomiProprietaSA");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::nomiProprietaSA] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("sa_properties");
            sqlQueryObject.setSelectDistinct(true);
            sqlQueryObject.addSelectField("sa_properties.nome");
            if (filterSoggettoNome != null && !"".equals(filterSoggettoNome) || tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                sqlQueryObject.addFromTable("soggetti");
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
                sqlQueryObject.addWhereCondition("sa_properties.id_servizio_applicativo=servizi_applicativi.id");
            }
            if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto=?");
                sqlQueryObject.addWhereCondition("soggetti.nome_soggetto=?");
            }
            if (tipoSoggettiProtocollo != null && tipoSoggettiProtocollo.size() > 0) {
                String[] tipiServiziProtocolloS = tipoSoggettiProtocollo.toArray(new String[tipoSoggettiProtocollo.size()]);
                sqlQueryObject.addWhereINCondition("soggetti.tipo_soggetto", true, tipiServiziProtocolloS);
            }
            sqlQueryObject.addOrderBy("sa_properties.nome");
            sqlQueryObject.setSortType(true);
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            if (filterSoggettoNome != null && !"".equals(filterSoggettoNome)) {
                stmt.setString(1, filterSoggettoTipo);
                stmt.setString(2, filterSoggettoNome);
            }
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                lista.add(risultato.getString("nome"));
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::nomiProprietaSA] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected List<IDServizioApplicativoDB> getIdServiziApplicativiWithIdErogatore(Long idErogatore, String tipo, boolean checkIM, boolean checkConnettoreAbilitato) throws DriverConfigurazioneException {
        ArrayList<IDServizioApplicativoDB> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        ArrayList<IDServizioApplicativoDB> lista = new ArrayList<IDServizioApplicativoDB>();
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("getServiziApplicativiWithIdErogatore");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServiziApplicativiWithIdErogatore] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectAliasField("servizi_applicativi", "id", "idServAppl");
            sqlQueryObject.addSelectAliasField("servizi_applicativi", "nome", "nomeServAppl");
            sqlQueryObject.addSelectField("soggetti", "tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti", "nome_soggetto");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.addWhereCondition("soggetti.id=servizi_applicativi.id_soggetto");
            sqlQueryObject.setANDLogicOperator(true);
            if (tipo != null) {
                sqlQueryObject.addWhereCondition("servizi_applicativi.tipo = ?");
            }
            if (checkConnettoreAbilitato) {
                sqlQueryObject.addFromTable("connettori");
                sqlQueryObject.addWhereCondition("connettori.id=servizi_applicativi.id_connettore_inv");
                if (checkIM) {
                    sqlQueryObject.addWhereCondition(false, new String[]{"servizi_applicativi.getmsginv = ? ", "connettori.endpointtype <> ? "});
                } else {
                    sqlQueryObject.addWhereCondition("connettori.endpointtype <> ? ");
                }
            } else if (checkIM) {
                sqlQueryObject.addWhereCondition("servizi_applicativi.getmsginv = ? ");
            }
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            int index = 1;
            stm.setLong(index++, idErogatore);
            if (tipo != null) {
                stm.setString(index++, tipo);
            }
            if (checkConnettoreAbilitato) {
                if (checkIM) {
                    stm.setString(index++, DriverConfigurazioneDBLib.getValue(StatoFunzionalita.ABILITATO));
                    stm.setString(index++, TipiConnettore.DISABILITATO.getNome());
                } else {
                    stm.setString(index++, TipiConnettore.DISABILITATO.getNome());
                }
            } else if (checkIM) {
                stm.setString(index++, DriverConfigurazioneDBLib.getValue(StatoFunzionalita.ABILITATO));
            }
            String debugQuery = DBUtils.formatSQLString(sqlQuery, idErogatore);
            if (tipo != null) {
                debugQuery = DBUtils.formatSQLString(debugQuery, tipo);
            }
            if (checkConnettoreAbilitato) {
                if (checkIM) {
                    debugQuery = DBUtils.formatSQLString(debugQuery, DriverConfigurazioneDBLib.getValue(StatoFunzionalita.ABILITATO));
                    debugQuery = DBUtils.formatSQLString(debugQuery, TipiConnettore.DISABILITATO.getNome());
                } else {
                    debugQuery = DBUtils.formatSQLString(debugQuery, TipiConnettore.DISABILITATO.getNome());
                }
            } else if (checkIM) {
                debugQuery = DBUtils.formatSQLString(debugQuery, DriverConfigurazioneDBLib.getValue(StatoFunzionalita.ABILITATO));
            }
            this.driver.logDebug("eseguo query : " + debugQuery);
            rs = stm.executeQuery();
            while (rs.next()) {
                IDServizioApplicativoDB idSA = new IDServizioApplicativoDB();
                idSA.setIdSoggettoProprietario(new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto")));
                idSA.setNome(rs.getString("nomeServAppl"));
                idSA.setId(rs.getLong("idServAppl"));
                lista.add(idSA);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected boolean existsServizioApplicativo(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException {
        IDSoggetto idSoggetto = idServizioApplicativo.getIdSoggettoProprietario();
        if (idSoggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsServizioApplicativo] Soggetto Fruitore non Impostato.");
        }
        if (idServizioApplicativo.getNome() == null || "".equals(idServizioApplicativo.getNome())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsServizioApplicativo] Nome Servizio Applicativo non Impostato.");
        }
        if (idSoggetto.getNome() == null || "".equals(idSoggetto.getNome())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsServizioApplicativo] Nome Soggetto Fruitore non Impostato.");
        }
        if (idSoggetto.getTipo() == null || "".equals(idSoggetto.getTipo())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsServizioApplicativo] Nome Soggetto Fruitore non Impostato.");
        }
        Connection con = null;
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("existsServizioApplicativo");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::createAccessoRegistro] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            boolean e = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(idServizioApplicativo.getNome(), idSoggetto.getTipo(), idSoggetto.getNome(), con, this.driver.tipoDB, this.driver.tabellaSoggetti) > 0L;
            this.driver.closeConnection(con);
            return e;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
    }

    protected long getIdServizioApplicativo(IDSoggetto idSoggetto, String nomeServizioApplicativo) throws DriverConfigurazioneException {
        if (idSoggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Soggetto Fruitore non Impostato.");
        }
        if (nomeServizioApplicativo == null || "".equals(nomeServizioApplicativo)) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Servizio Applicativo non Impostato.");
        }
        if (idSoggetto.getNome() == null || "".equals(idSoggetto.getNome())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Nome Soggetto Fruitore non Impostato.");
        }
        if (idSoggetto.getTipo() == null || "".equals(idSoggetto.getTipo())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Tipo Soggetto Fruitore non Impostato.");
        }
        Connection con = null;
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("getIdServizioApplicativo");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::getServizioApplicativo] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            long e = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeServizioApplicativo, idSoggetto.getTipo(), idSoggetto.getNome(), con, this.driver.tipoDB, this.driver.tabellaSoggetti);
            this.driver.closeConnection(con);
            return e;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
    }

    protected boolean existsServizioApplicativoSoggetto(Long idSoggetto) throws DriverConfigurazioneException {
        boolean bl;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("existsServizioApplicativoSoggetto");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::existsServizioApplicativoSoggetto] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            boolean esiste = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSoggetto);
            this.driver.logDebug("eseguo query : " + DBUtils.formatSQLString(sqlQuery, idSoggetto));
            rs = stm.executeQuery();
            if (rs.next()) {
                esiste = true;
            }
            bl = esiste;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return bl;
    }

    protected boolean isServizioApplicativoInUsoComeErogatore(ServizioApplicativo sa, Map<ErrorsHandlerCostant, String> whereIsInUso) throws DriverConfigurazioneException {
        boolean bl;
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        try {
            if (this.driver.atomica) {
                try {
                    con = this.driver.getConnectionFromDatasource("isServizioApplicativoInUsoComeErogatore");
                }
                catch (Exception e) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::isServizioApplicativoInUsoComeErogatore] Exception accedendo al datasource :" + e.getMessage(), e);
                }
            } else {
                con = this.driver.globalConnection;
            }
            ArrayList<String> nomiPorteApplicative = new ArrayList<String>();
            boolean isInUso = false;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative_sa");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("porte_applicative_sa.id_servizio_applicativo = ?");
            sqlQueryObject.addWhereCondition("porte_applicative_sa.id_porta = porte_applicative.id");
            sqlQueryObject.setANDLogicOperator(true);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, sa.getId());
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                isInUso = true;
                nomiPorteApplicative.add(risultato.getString("nome_porta"));
            }
            risultato.close();
            stmt.close();
            if (isInUso) {
                if (whereIsInUso == null) {
                    whereIsInUso = new HashMap<ErrorsHandlerCostant, String>();
                }
                whereIsInUso.put(ErrorsHandlerCostant.IN_USO_IN_PORTE_APPLICATIVE, nomiPorteApplicative.toString());
            }
            bl = isInUso;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException(qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return bl;
    }

    protected List<ServizioApplicativo> getServiziApplicativiBySoggetto(long idSoggetto) throws DriverConfigurazioneException {
        ArrayList<ServizioApplicativo> arrayList;
        String nomeMetodo = "getPorteApplicativeBySoggetto";
        Connection con = null;
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        ArrayList<ServizioApplicativo> lista = new ArrayList<ServizioApplicativo>();
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_soggetto=?");
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idSoggetto);
            risultato = stmt.executeQuery();
            while (risultato.next()) {
                Long id = risultato.getLong("id");
                ServizioApplicativo sa = this.getServizioApplicativo(id);
                if (sa.getInvocazionePorta() != null && sa.getInvocazionePorta().sizeCredenzialiList() == 0) {
                    sa.setInvocazionePorta(null);
                }
                if (sa.getInvocazioneServizio() != null && (sa.getInvocazioneServizio().getConnettore() == null || CostantiConfigurazione.DISABILITATO.equals(sa.getInvocazioneServizio().getConnettore().getTipo())) && CostantiConfigurazione.DISABILITATO.equals(sa.getInvocazioneServizio().getGetMessage())) {
                    sa.setInvocazioneServizio(null);
                }
                if (sa.getRispostaAsincrona() != null && (sa.getRispostaAsincrona().getConnettore() == null || CostantiConfigurazione.DISABILITATO.equals(sa.getRispostaAsincrona().getConnettore().getTipo())) && CostantiConfigurazione.DISABILITATO.equals(sa.getRispostaAsincrona().getGetMessage())) {
                    sa.setRispostaAsincrona(null);
                }
                lista.add(sa);
            }
            arrayList = lista;
        }
        catch (Exception qe) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Errore : " + qe.getMessage(), qe);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return arrayList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<IDServizioApplicativo> getAllIdServiziApplicativi(FiltroRicercaServiziApplicativi filtroRicerca) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ArrayList<IDServizioApplicativo> arrayList;
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        this.driver.logDebug("getAllIdServiziApplicativi...");
        try {
            this.driver.logDebug("operazione atomica = " + this.driver.atomica);
            con = this.driver.atomica ? this.driver.getConnectionFromDatasource("getAllIdServiziApplicativi") : this.driver.globalConnection;
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("servizi_applicativi.nome");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto = soggetti.id");
            if (filtroRicerca != null && filtroRicerca.getIdRuolo() != null) {
                sqlQueryObject.addFromTable("sa_ruoli");
                sqlQueryObject.addWhereCondition("sa_ruoli.id_servizio_applicativo = servizi_applicativi.id");
            }
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.ora_registrazione > ?");
                }
                if (filtroRicerca.getMaxDate() != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.ora_registrazione < ?");
                }
                if (filtroRicerca.getTipoSoggetto() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.tipo_soggetto = ?");
                }
                if (filtroRicerca.getNomeSoggetto() != null) {
                    sqlQueryObject.addWhereCondition("soggetti.nome_soggetto = ?");
                }
                if (filtroRicerca.getNome() != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.nome = ?");
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    sqlQueryObject.addWhereCondition("sa_ruoli.ruolo = ?");
                }
                if (filtroRicerca.getTipo() != null) {
                    sqlQueryObject.addWhereCondition("servizi_applicativi.tipo = ?");
                }
                DBUtils.setPropertiesForSearch(sqlQueryObject, filtroRicerca.getProprieta(), "servizi_applicativi", "sa_properties", "nome", "valore", "id_servizio_applicativo");
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(sqlQueryObject, filtroRicerca, "servizi_applicativi");
            }
            sqlQueryObject.setANDLogicOperator(true);
            String sqlQuery = sqlQueryObject.createSQLQuery();
            this.driver.logDebug("eseguo query : " + sqlQuery);
            stm = con.prepareStatement(sqlQuery);
            int indexStmt = 1;
            if (filtroRicerca != null) {
                if (filtroRicerca.getMinDate() != null) {
                    this.driver.logDebug("minDate stmt.setTimestamp(" + String.valueOf(filtroRicerca.getMinDate()) + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMinDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getMaxDate() != null) {
                    this.driver.logDebug("maxDate stmt.setTimestamp(" + String.valueOf(filtroRicerca.getMaxDate()) + ")");
                    stm.setTimestamp(indexStmt, new Timestamp(filtroRicerca.getMaxDate().getTime()));
                    ++indexStmt;
                }
                if (filtroRicerca.getTipoSoggetto() != null) {
                    this.driver.logDebug("tipoSoggetto stmt.setString(" + filtroRicerca.getTipoSoggetto() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipoSoggetto());
                    ++indexStmt;
                }
                if (filtroRicerca.getNomeSoggetto() != null) {
                    this.driver.logDebug("nomeSoggetto stmt.setString(" + filtroRicerca.getNomeSoggetto() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNomeSoggetto());
                    ++indexStmt;
                }
                if (filtroRicerca.getNome() != null) {
                    this.driver.logDebug("nome stmt.setString(" + filtroRicerca.getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getIdRuolo() != null) {
                    this.driver.logDebug("ruolo stmt.setString(" + filtroRicerca.getIdRuolo().getNome() + ")");
                    stm.setString(indexStmt, filtroRicerca.getIdRuolo().getNome());
                    ++indexStmt;
                }
                if (filtroRicerca.getTipo() != null) {
                    this.driver.logDebug("tipo stmt.setString(" + filtroRicerca.getTipo() + ")");
                    stm.setString(indexStmt, filtroRicerca.getTipo());
                    ++indexStmt;
                }
                DBUtils.setPropertiesForSearch(stm, indexStmt, filtroRicerca.getProprieta(), this.driver.tipoDB, this.driver.log);
                this.protocolPropertiesDriver.setProtocolPropertiesForSearch(stm, indexStmt, filtroRicerca, ProprietariProtocolProperty.SERVIZIO_APPLICATIVO);
            }
            rs = stm.executeQuery();
            ArrayList<IDServizioApplicativo> idsSA = new ArrayList<IDServizioApplicativo>();
            while (rs.next()) {
                IDSoggetto idS = new IDSoggetto(rs.getString("tipo_soggetto"), rs.getString("nome_soggetto"));
                IDServizioApplicativo idSA = new IDServizioApplicativo();
                idSA.setIdSoggettoProprietario(idS);
                idSA.setNome(rs.getString("nome"));
                idsSA.add(idSA);
            }
            if (idsSA.size() == 0) {
                if (filtroRicerca != null) {
                    throw new DriverConfigurazioneNotFound("ServiziApplicativi non trovati che rispettano il filtro di ricerca selezionato: " + filtroRicerca.toString());
                }
                throw new DriverConfigurazioneNotFound("ServiziApplicativi non trovati");
            }
            arrayList = idsSA;
        }
        catch (DriverConfigurazioneNotFound de) {
            try {
                throw de;
                catch (Exception e) {
                    throw new DriverConfigurazioneException("getAllIdServiziApplicativi error", e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return arrayList;
    }

    protected long getIdServizioApplicativoByConnettore(long idConnettore) throws DriverConfigurazioneException {
        long l;
        String nomeMetodo = "getIdServizioApplicativoByConnettore";
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource("getProtocolProperty");
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        PreparedStatement stmt = null;
        ResultSet risultato = null;
        try {
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("id");
            sqlQueryObject.addWhereCondition("id_connettore_inv=?");
            sqlQueryObject.addWhereCondition("id_connettore_risp=?");
            sqlQueryObject.setANDLogicOperator(false);
            String queryString = sqlQueryObject.createSQLQuery();
            stmt = con.prepareStatement(queryString);
            stmt.setLong(1, idConnettore);
            stmt.setLong(2, idConnettore);
            risultato = stmt.executeQuery();
            long idSA = -1L;
            if (risultato.next()) {
                idSA = risultato.getLong("id");
            }
            l = idSA;
        }
        catch (Exception se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneException::" + nomeMetodo + "] Exception: " + se.getMessage());
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(risultato, stmt);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)risultato, (PreparedStatement)stmt);
        this.driver.closeConnection(con);
        return l;
    }

    protected IDServizio getLabelNomeServizioApplicativo(String nomeServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        IDServizio iDServizio;
        PreparedStatement stm;
        ResultSet rs;
        Connection con;
        block15: {
            long idSA;
            String sqlQuery;
            ISQLQueryObject sqlQueryObject;
            block16: {
                con = null;
                rs = null;
                stm = null;
                if (this.driver.atomica) {
                    try {
                        con = this.driver.getConnectionFromDatasource("findAllAllarmi");
                    }
                    catch (Exception e) {
                        throw new DriverConfigurazioneException("[DriverConfigurazioneDB::findAllAllarmi] Exception accedendo al datasource :" + e.getMessage(), e);
                    }
                } else {
                    con = this.driver.globalConnection;
                }
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
                sqlQueryObject.addFromTable("servizi_applicativi");
                sqlQueryObject.addSelectField("servizi_applicativi.id");
                sqlQueryObject.addSelectField("servizi_applicativi.tipo");
                sqlQueryObject.setANDLogicOperator(true);
                sqlQueryObject.addWhereCondition("nome=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setString(1, nomeServizioApplicativo);
                this.driver.logDebug("eseguo query: " + sqlQuery);
                idSA = -1L;
                String tipo = null;
                rs = stm.executeQuery();
                if (rs.next()) {
                    idSA = rs.getLong("id");
                    tipo = rs.getString("tipo");
                }
                rs.close();
                rs = null;
                stm.close();
                stm = null;
                if (idSA <= 0L) break block15;
                if (!"server".equals(tipo)) break block16;
                IDServizio iDServizio2 = null;
                JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
                this.driver.closeConnection(con);
                return iDServizio2;
            }
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("porte_applicative_sa");
            sqlQueryObject.addFromTable("porte_applicative");
            sqlQueryObject.addFromTable("soggetti");
            sqlQueryObject.addSelectField("porte_applicative.behaviour");
            sqlQueryObject.addSelectField("porte_applicative_sa.connettore_nome");
            sqlQueryObject.addSelectField("soggetti.tipo_soggetto");
            sqlQueryObject.addSelectField("soggetti.nome_soggetto");
            sqlQueryObject.addSelectField("porte_applicative.tipo_servizio");
            sqlQueryObject.addSelectField("porte_applicative.servizio");
            sqlQueryObject.addSelectField("porte_applicative.versione_servizio");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQueryObject.addWhereCondition("porte_applicative.id=porte_applicative_sa.id_porta");
            sqlQueryObject.addWhereCondition("soggetti.id=porte_applicative.id_soggetto");
            sqlQueryObject.addWhereCondition("porte_applicative_sa.id_servizio_applicativo=?");
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idSA);
            this.driver.logDebug("eseguo query: " + sqlQuery);
            ArrayList<IDServizio> nomiConnettore = new ArrayList<IDServizio>();
            rs = stm.executeQuery();
            while (rs.next()) {
                String behaviour = rs.getString("behaviour");
                String nomeConnettore = rs.getString("connettore_nome");
                String tipo_soggetto = rs.getString("tipo_soggetto");
                String nome_soggetto = rs.getString("nome_soggetto");
                String tipo_servizio = rs.getString("tipo_servizio");
                String servizio = rs.getString("servizio");
                int versione_servizio = rs.getInt("versione_servizio");
                IDServizio idServizio = IDServizioUtils.buildIDServizio(tipo_servizio, servizio, new IDSoggetto(tipo_soggetto, nome_soggetto), versione_servizio);
                if (nomeConnettore != null && !"".equals(nomeConnettore)) {
                    idServizio.setAzione(nomeConnettore);
                } else if (behaviour != null && !"".equals(behaviour)) {
                    idServizio.setAzione("Default");
                }
                nomiConnettore.add(idServizio);
            }
            rs.close();
            rs = null;
            stm.close();
            stm = null;
            if (nomiConnettore.isEmpty() || nomiConnettore.size() != 1) break block15;
            IDServizio iDServizio3 = (IDServizio)nomiConnettore.get(0);
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            this.driver.closeConnection(con);
            return iDServizio3;
        }
        try {
            iDServizio = null;
        }
        catch (Exception se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::findAllAllarmi] Exception: " + se.getMessage(), se);
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return iDServizio;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ProprietaOggetto getProprietaOggetto(IDServizioApplicativo idServizioApplicativo) throws DriverConfigurazioneException, DriverConfigurazioneNotFound {
        ProprietaOggetto proprietaOggetto;
        String nomeMetodo = "getProprietaOggetto";
        IDSoggetto idSoggetto = idServizioApplicativo.getIdSoggettoProprietario();
        if (idSoggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Soggetto Fruitore non Impostato.");
        }
        if (idServizioApplicativo.getNome() == null || "".equals(idServizioApplicativo.getNome())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Nome Servizio Applicativo non Impostato.");
        }
        if (idSoggetto.getNome() == null || "".equals(idSoggetto.getNome())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Nome Soggetto Fruitore non Impostato.");
        }
        if (idSoggetto.getTipo() == null || "".equals(idSoggetto.getTipo())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Tipo Soggetto Fruitore non Impostato.");
        }
        Connection con = null;
        PreparedStatement stm = null;
        ResultSet rs = null;
        String sqlQuery = "";
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        try {
            long idSog = DBUtils.getIdSoggetto(idSoggetto.getNome(), idSoggetto.getTipo(), con, this.driver.tipoDB, this.driver.tabellaSoggetti);
            ISQLQueryObject sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObject.addFromTable("servizi_applicativi");
            sqlQueryObject.addSelectField("utente_richiedente");
            sqlQueryObject.addSelectField("data_creazione");
            sqlQueryObject.addSelectField("utente_ultima_modifica");
            sqlQueryObject.addSelectField("data_ultima_modifica");
            sqlQueryObject.addWhereCondition("nome = ?");
            sqlQueryObject.addWhereCondition("id_soggetto = ?");
            sqlQueryObject.setANDLogicOperator(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setString(1, idServizioApplicativo.getNome());
            stm.setLong(2, idSog);
            this.driver.logDebug("eseguo query: " + DBUtils.formatSQLString(sqlQuery, idServizioApplicativo.getNome(), idSog));
            rs = stm.executeQuery();
            ProprietaOggetto proprieta = null;
            if (!rs.next()) {
                throw new DriverConfigurazioneNotFound("ServizioApplicativo [" + idServizioApplicativo.getNome() + "] non esistente");
            }
            proprieta = this.utilsDriver.readProprietaOggetto(rs, false);
            proprietaOggetto = proprieta;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] SqlException: " + se.getMessage(), se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception: " + se2.getMessage(), se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(rs, stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        this.driver.closeConnection(con);
        return proprietaOggetto;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void updateProprietaOggetto(IDServizioApplicativo idServizioApplicativo, String user) throws DriverConfigurazioneException {
        String nomeMetodo = "updateProprietaOggettoServizioApplicativo";
        IDSoggetto idSoggetto = idServizioApplicativo.getIdSoggettoProprietario();
        if (idSoggetto == null) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Soggetto Fruitore non Impostato.");
        }
        if (idServizioApplicativo.getNome() == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Nome Servizio Applicativo non Impostato.");
        if ("".equals(idServizioApplicativo.getNome())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Nome Servizio Applicativo non Impostato.");
        }
        if (idSoggetto.getNome() == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Nome Soggetto Fruitore non Impostato.");
        if ("".equals(idSoggetto.getNome())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Nome Soggetto Fruitore non Impostato.");
        }
        if (idSoggetto.getTipo() == null) throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Tipo Soggetto Fruitore non Impostato.");
        if ("".equals(idSoggetto.getTipo())) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Tipo Soggetto Fruitore non Impostato.");
        }
        Connection con = null;
        if (this.driver.atomica) {
            try {
                con = this.driver.getConnectionFromDatasource(nomeMetodo);
            }
            catch (Exception e) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB::" + nomeMetodo + "] Exception accedendo al datasource :" + e.getMessage(), e);
            }
        } else {
            con = this.driver.globalConnection;
        }
        this.driver.logDebug("operazione this.driver.atomica = " + this.driver.atomica);
        PreparedStatement stm = null;
        try {
            long idSog = DBUtils.getIdSoggetto(idSoggetto.getNome(), idSoggetto.getTipo(), con, this.driver.tipoDB, this.driver.tabellaSoggetti);
            ISQLQueryObject sqlQueryObjectUpdate = SQLObjectFactory.createSQLQueryObject((String)this.driver.tipoDB);
            sqlQueryObjectUpdate.addUpdateTable("servizi_applicativi");
            sqlQueryObjectUpdate.addUpdateField("utente_ultima_modifica", "?");
            sqlQueryObjectUpdate.addUpdateField("data_ultima_modifica", "?");
            sqlQueryObjectUpdate.addWhereCondition("nome = ?");
            sqlQueryObjectUpdate.addWhereCondition("id_soggetto = ?");
            sqlQueryObjectUpdate.setANDLogicOperator(true);
            String updateString = sqlQueryObjectUpdate.createSQLUpdate();
            stm = con.prepareStatement(updateString);
            int index = 1;
            stm.setString(index++, user);
            stm.setTimestamp(index++, DateManager.getTimestamp());
            stm.setString(index++, idServizioApplicativo.getNome());
            stm.setLong(index++, idSog);
            int n = stm.executeUpdate();
            stm.close();
            this.driver.logDebug("Aggiornata " + n + " entry per l'operazione di ultima modifica della tabella 'servizi_applicativi' con idSA: " + String.valueOf(idServizioApplicativo));
        }
        catch (SQLException e) {
            try {
                this.driver.logError("Errore SQL", e);
                throw new DriverConfigurazioneException(e);
                catch (Exception e2) {
                    this.driver.logError("Errore", e2);
                    throw new DriverConfigurazioneException(e2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(stm);
                this.driver.closeConnection(con);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((PreparedStatement)stm);
        this.driver.closeConnection(con);
    }
}

