/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.TrasformazioneRegola;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaRichiesta;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaRisposta;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaServizioApplicativo;
import org.openspcoop2.core.config.TrasformazioneRegolaApplicabilitaSoggetto;
import org.openspcoop2.core.config.TrasformazioneRegolaParametro;
import org.openspcoop2.core.config.TrasformazioneRegolaRichiesta;
import org.openspcoop2.core.config.TrasformazioneRegolaRisposta;
import org.openspcoop2.core.config.TrasformazioneRest;
import org.openspcoop2.core.config.TrasformazioneSoap;
import org.openspcoop2.core.config.TrasformazioneSoapRisposta;
import org.openspcoop2.core.config.Trasformazioni;
import org.openspcoop2.core.config.constants.StatoFunzionalita;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDB_serviziApplicativiLIB;
import org.openspcoop2.utils.TipiDatabase;
import org.openspcoop2.utils.jdbc.CustomKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.IJDBCAdapter;
import org.openspcoop2.utils.jdbc.IKeyGeneratorObject;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKey;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyJDBCType;
import org.openspcoop2.utils.jdbc.InsertAndGeneratedKeyObject;
import org.openspcoop2.utils.jdbc.JDBCAdapterException;
import org.openspcoop2.utils.jdbc.JDBCAdapterFactory;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDBTrasformazioniLib {
    private static final String ESEGUO_QUERY_PREFIX = "eseguo query : ";

    private DriverConfigurazioneDBTrasformazioniLib() {
    }

    private static void normalizePositionsEngine(Trasformazioni trasformazioni) {
        if (trasformazioni == null || trasformazioni.sizeRegolaList() <= 0) {
            return;
        }
        ArrayList<Integer> posizioni = new ArrayList<Integer>();
        HashMap<Integer, TrasformazioneRegola> regole = new HashMap<Integer, TrasformazioneRegola>();
        for (TrasformazioneRegola regola : trasformazioni.getRegolaList()) {
            posizioni.add(regola.getPosizione());
            regole.put(regola.getPosizione(), regola);
        }
        while (trasformazioni.sizeRegolaList() > 0) {
            trasformazioni.removeRegola(0);
        }
        Collections.sort(posizioni);
        int posNew = 1;
        for (Integer pos : posizioni) {
            TrasformazioneRegola regola = (TrasformazioneRegola)regole.get(pos);
            regola.setPosizione(posNew);
            trasformazioni.addRegola(regola);
            ++posNew;
        }
        for (TrasformazioneRegola regola : trasformazioni.getRegolaList()) {
            if (regola.getRispostaList() == null || regola.sizeRispostaList() <= 0) continue;
            ArrayList<Integer> posizioniRisposta = new ArrayList<Integer>();
            HashMap<Integer, TrasformazioneRegolaRisposta> regoleRisposta = new HashMap<Integer, TrasformazioneRegolaRisposta>();
            for (TrasformazioneRegolaRisposta regolaRisposta : regola.getRispostaList()) {
                posizioniRisposta.add(regolaRisposta.getPosizione());
                regoleRisposta.put(regolaRisposta.getPosizione(), regolaRisposta);
            }
            while (regola.sizeRispostaList() > 0) {
                regola.removeRisposta(0);
            }
            Collections.sort(posizioniRisposta);
            int posRispostaNew = 1;
            for (Integer posRisposta : posizioniRisposta) {
                TrasformazioneRegolaRisposta regolaRisposta = (TrasformazioneRegolaRisposta)regoleRisposta.get(posRisposta);
                regolaRisposta.setPosizione(posRispostaNew);
                regola.addRisposta(regolaRisposta);
                ++posRispostaNew;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    static void CRUDTrasformazioni(int type, Connection con, Trasformazioni trasformazioni, Long idProprietario, boolean portaDelegata) throws DriverConfigurazioneException, JDBCAdapterException {
        updateStmt = null;
        rs = null;
        jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverConfigurazioneDBLib.tipoDB);
        try {
            switch (type) {
                case 1: {
                    if (trasformazioni == null) ** break;
                    if (trasformazioni.sizeRegolaList() <= 0) {
                        ** break;
lbl10:
                        // 1 sources

                    } else {
                        DriverConfigurazioneDBTrasformazioniLib.normalizePositionsEngine(trasformazioni);
                        for (TrasformazioneRegola regola : trasformazioni.getRegolaList()) {
                            applicabilitaAzioni = null;
                            if (regola.getApplicabilita() != null && regola.getApplicabilita().sizeAzioneList() > 0) {
                                bf = new StringBuilder();
                                for (i = 0; i < regola.getApplicabilita().sizeAzioneList(); ++i) {
                                    if (i > 0) {
                                        bf.append(",");
                                    }
                                    bf.append(regola.getApplicabilita().getAzione(i));
                                }
                                if (bf.length() > 0) {
                                    applicabilitaAzioni = bf.toString();
                                }
                            }
                            applicabilitaCT = null;
                            if (regola.getApplicabilita() != null && regola.getApplicabilita().sizeContentTypeList() > 0) {
                                bf = new StringBuilder();
                                for (i = 0; i < regola.getApplicabilita().sizeContentTypeList(); ++i) {
                                    if (i > 0) {
                                        bf.append(",");
                                    }
                                    bf.append(regola.getApplicabilita().getContentType(i));
                                }
                                if (bf.length() > 0) {
                                    applicabilitaCT = bf.toString();
                                }
                            }
                            applicabilitaConnettori = null;
                            if (regola.getApplicabilita() != null && regola.getApplicabilita().sizeConnettoreList() > 0) {
                                bf = new StringBuilder();
                                for (i = 0; i < regola.getApplicabilita().sizeConnettoreList(); ++i) {
                                    if (i > 0) {
                                        bf.append(",");
                                    }
                                    bf.append(regola.getApplicabilita().getConnettore(i));
                                }
                                if (bf.length() > 0) {
                                    applicabilitaConnettori = bf.toString();
                                }
                            }
                            listInsertAndGeneratedKeyObject = new ArrayList<InsertAndGeneratedKeyObject>();
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("id_porta", (Object)idProprietario, InsertAndGeneratedKeyJDBCType.LONG));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome", (Object)regola.getNome(), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("posizione", (Object)regola.getPosizione(), InsertAndGeneratedKeyJDBCType.INT));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("stato", (Object)DriverConfigurazioneDBLib.getValue(regola.getStato()), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("applicabilita_azioni", (Object)applicabilitaAzioni, InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("applicabilita_ct", (Object)applicabilitaCT, InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("applicabilita_pattern", (Object)(regola.getApplicabilita() != null ? regola.getApplicabilita().getPattern() : null), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("applicabilita_connettori", (Object)applicabilitaConnettori, InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("req_conversione_enabled", (Object)(regola.getRichiesta() != null && regola.getRichiesta().getConversione() != false ? 1 : 0), InsertAndGeneratedKeyJDBCType.INT));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("req_conversione_tipo", (Object)(regola.getRichiesta() != null ? regola.getRichiesta().getConversioneTipo() : null), InsertAndGeneratedKeyJDBCType.STRING));
                            listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("req_content_type", (Object)(regola.getRichiesta() != null ? regola.getRichiesta().getContentType() : null), InsertAndGeneratedKeyJDBCType.STRING));
                            if (regola.getRichiesta() != null && regola.getRichiesta().getTrasformazioneRest() != null) {
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("rest_transformation", (Object)1, InsertAndGeneratedKeyJDBCType.INT));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("rest_method", (Object)regola.getRichiesta().getTrasformazioneRest().getMetodo(), InsertAndGeneratedKeyJDBCType.STRING));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("rest_path", (Object)regola.getRichiesta().getTrasformazioneRest().getPath(), InsertAndGeneratedKeyJDBCType.STRING));
                            }
                            if (regola.getRichiesta() != null && regola.getRichiesta().getTrasformazioneSoap() != null) {
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_transformation", (Object)1, InsertAndGeneratedKeyJDBCType.INT));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_version", (Object)DriverConfigurazioneDBLib.getValue(regola.getRichiesta().getTrasformazioneSoap().getVersione()), InsertAndGeneratedKeyJDBCType.STRING));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_action", (Object)regola.getRichiesta().getTrasformazioneSoap().getSoapAction(), InsertAndGeneratedKeyJDBCType.STRING));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_envelope", (Object)(regola.getRichiesta().getTrasformazioneSoap().getEnvelope() != false ? 1 : 0), InsertAndGeneratedKeyJDBCType.INT));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_envelope_as_attach", (Object)(regola.getRichiesta().getTrasformazioneSoap().getEnvelopeAsAttachment() != false ? 1 : 0), InsertAndGeneratedKeyJDBCType.INT));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_envelope_tipo", (Object)regola.getRichiesta().getTrasformazioneSoap().getEnvelopeBodyConversioneTipo(), InsertAndGeneratedKeyJDBCType.STRING));
                            }
                            tableName = null;
                            columnIdName = null;
                            sequence = null;
                            tableForId = null;
                            if (portaDelegata) {
                                tableName = "pd_transform";
                                columnIdName = "id";
                                sequence = "seq_pd_transform";
                                tableForId = "pd_transform_init_seq";
                            } else {
                                tableName = "pa_transform";
                                columnIdName = "id";
                                sequence = "seq_pa_transform";
                                tableForId = "pa_transform_init_seq";
                            }
                            idtrasformazione = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)DriverConfigurazioneDBLib.tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject(tableName, columnIdName, sequence, tableForId), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                            if (idtrasformazione <= 0L) {
                                throw new DriverConfigurazioneException("ID autoincrementale non ottenuto");
                            }
                            if (regola.getRichiesta() != null && (regola.getRichiesta().getConversioneTemplate() != null || regola.getRichiesta().getTrasformazioneSoap() != null && regola.getRichiesta().getTrasformazioneSoap().getEnvelopeBodyConversioneTemplate() != null)) {
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                sqlQueryObject.addUpdateTable(tableName);
                                if (regola.getRichiesta().getConversioneTemplate() != null) {
                                    sqlQueryObject.addUpdateField("req_conversione_template", "?");
                                }
                                if (regola.getRichiesta().getTrasformazioneSoap() != null && regola.getRichiesta().getTrasformazioneSoap().getEnvelopeBodyConversioneTemplate() != null) {
                                    sqlQueryObject.addUpdateField("soap_envelope_template", "?");
                                }
                                sqlQueryObject.addWhereCondition(columnIdName + "=?");
                                updateQuery = sqlQueryObject.createSQLUpdate();
                                updateStmt = con.prepareStatement(updateQuery);
                                index = 1;
                                if (regola.getRichiesta().getConversioneTemplate() != null) {
                                    jdbcAdapter.setBinaryData(updateStmt, index++, regola.getRichiesta() != null ? regola.getRichiesta().getConversioneTemplate() : null);
                                }
                                if (regola.getRichiesta().getTrasformazioneSoap() != null && regola.getRichiesta().getTrasformazioneSoap().getEnvelopeBodyConversioneTemplate() != null) {
                                    jdbcAdapter.setBinaryData(updateStmt, index++, regola.getRichiesta().getTrasformazioneSoap().getEnvelopeBodyConversioneTemplate());
                                }
                                updateStmt.setLong(index++, idtrasformazione);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                            }
                            if (regola.getRichiesta() != null) {
                                if (regola.getApplicabilita() != null) {
                                    if (!portaDelegata && regola.getApplicabilita().sizeSoggettoList() > 0) {
                                        n = 0;
                                        for (j = 0; j < regola.getApplicabilita().sizeSoggettoList(); ++j) {
                                            soggetto = regola.getApplicabilita().getSoggetto(j);
                                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                            sqlQueryObject.addInsertTable("pa_transform_soggetti");
                                            sqlQueryObject.addInsertField("id_trasformazione", "?");
                                            sqlQueryObject.addInsertField("tipo_soggetto", "?");
                                            sqlQueryObject.addInsertField("nome_soggetto", "?");
                                            sqlQuery = sqlQueryObject.createSQLInsert();
                                            updateStmt = con.prepareStatement(sqlQuery);
                                            updateStmt.setLong(1, idtrasformazione);
                                            updateStmt.setString(2, soggetto.getTipo());
                                            updateStmt.setString(3, soggetto.getNome());
                                            updateStmt.executeUpdate();
                                            updateStmt.close();
                                            ++n;
                                            DriverConfigurazioneDBLib.logDebug("Aggiunto soggetto [" + soggetto.getTipo() + "/" + soggetto.getNome() + "] alla Trasformazione[" + idtrasformazione + "]");
                                        }
                                        DriverConfigurazioneDBLib.logDebug("Aggiunti " + n + " soggetti alla Trasformazione[" + idtrasformazione + "]");
                                    }
                                    if (regola.getApplicabilita().sizeServizioApplicativoList() > 0) {
                                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                        if (portaDelegata) {
                                            sqlQueryObject.addInsertTable("pd_transform_sa");
                                        } else {
                                            sqlQueryObject.addInsertTable("pa_transform_sa");
                                        }
                                        sqlQueryObject.addInsertField("id_trasformazione", "?");
                                        sqlQueryObject.addInsertField("id_servizio_applicativo", "?");
                                        sqlQuery = sqlQueryObject.createSQLInsert();
                                        updateStmt = con.prepareStatement(sqlQuery);
                                        i = 0;
                                        for (i = 0; i < regola.getApplicabilita().sizeServizioApplicativoList(); ++i) {
                                            servizioApplicativo = regola.getApplicabilita().getServizioApplicativo(i);
                                            nomeSA = servizioApplicativo.getNome();
                                            nomeProprietarioSA = servizioApplicativo.getNomeSoggettoProprietario();
                                            tipoProprietarioSA = servizioApplicativo.getTipoSoggettoProprietario();
                                            if (nomeSA == null || nomeSA.equals("")) {
                                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[Transf]::Nome del ServizioApplicativo associato non valido.");
                                            }
                                            if (nomeProprietarioSA == null || nomeProprietarioSA.equals("")) {
                                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[Transf]::Nome Proprietario del ServizioApplicativo associato non valido.");
                                            }
                                            if (tipoProprietarioSA == null || tipoProprietarioSA.equals("")) {
                                                throw new DriverConfigurazioneException("[CRUDPortaApplicativa(CREATE)[Transf]::Tipo Proprietario del ServizioApplicativo associato non valido.");
                                            }
                                            idSA = DriverConfigurazioneDB_serviziApplicativiLIB.getIdServizioApplicativo(nomeSA, tipoProprietarioSA, nomeProprietarioSA, con, DriverConfigurazioneDBLib.tipoDB, DriverConfigurazioneDBLib.tabellaSoggetti);
                                            if (idSA <= 0L) {
                                                throw new DriverConfigurazioneException("Impossibile recuperare l'id del Servizio Applicativo [" + nomeSA + "] di [" + tipoProprietarioSA + "/" + nomeProprietarioSA + "]");
                                            }
                                            updateStmt.setLong(1, idtrasformazione);
                                            updateStmt.setLong(2, idSA);
                                            updateStmt.executeUpdate();
                                        }
                                        updateStmt.close();
                                        DriverConfigurazioneDBLib.logDebug("Inseriti " + i + " servizi applicativi autorizzati associati alla Trasformazione[" + idtrasformazione + "]");
                                    }
                                }
                                if (regola.getRichiesta().sizeHeaderList() > 0) {
                                    for (TrasformazioneRegolaParametro parametro : regola.getRichiesta().getHeaderList()) {
                                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                        if (portaDelegata) {
                                            sqlQueryObject.addInsertTable("pd_transform_hdr");
                                        } else {
                                            sqlQueryObject.addInsertTable("pa_transform_hdr");
                                        }
                                        sqlQueryObject.addInsertField("id_trasformazione", "?");
                                        sqlQueryObject.addInsertField("tipo", "?");
                                        sqlQueryObject.addInsertField("nome", "?");
                                        sqlQueryObject.addInsertField("valore", "?");
                                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                                        updateQuery = sqlQueryObject.createSQLInsert();
                                        updateStmt = con.prepareStatement(updateQuery);
                                        index = 1;
                                        updateStmt.setLong(index++, idtrasformazione);
                                        updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(parametro.getConversioneTipo()));
                                        updateStmt.setString(index++, parametro.getNome());
                                        updateStmt.setString(index++, parametro.getValore());
                                        updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(parametro.getIdentificazioneFallita()));
                                        updateStmt.executeUpdate();
                                        updateStmt.close();
                                    }
                                }
                                if (regola.getRichiesta().sizeParametroUrlList() > 0) {
                                    for (TrasformazioneRegolaParametro parametro : regola.getRichiesta().getParametroUrlList()) {
                                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                        if (portaDelegata) {
                                            sqlQueryObject.addInsertTable("pd_transform_url");
                                        } else {
                                            sqlQueryObject.addInsertTable("pa_transform_url");
                                        }
                                        sqlQueryObject.addInsertField("id_trasformazione", "?");
                                        sqlQueryObject.addInsertField("tipo", "?");
                                        sqlQueryObject.addInsertField("nome", "?");
                                        sqlQueryObject.addInsertField("valore", "?");
                                        sqlQueryObject.addInsertField("identificazione_fallita", "?");
                                        updateQuery = sqlQueryObject.createSQLInsert();
                                        updateStmt = con.prepareStatement(updateQuery);
                                        index = 1;
                                        updateStmt.setLong(index++, idtrasformazione);
                                        updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(parametro.getConversioneTipo()));
                                        updateStmt.setString(index++, parametro.getNome());
                                        updateStmt.setString(index++, parametro.getValore());
                                        updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(parametro.getIdentificazioneFallita()));
                                        updateStmt.executeUpdate();
                                        updateStmt.close();
                                    }
                                }
                            }
                            if (regola.sizeRispostaList() <= 0) continue;
                            for (TrasformazioneRegolaRisposta regolaRisposta : regola.getRispostaList()) {
                                applicabilitaCtResponse = null;
                                if (regolaRisposta.getApplicabilita() != null && regolaRisposta.getApplicabilita().sizeContentTypeList() > 0) {
                                    bf = new StringBuilder();
                                    for (i = 0; i < regolaRisposta.getApplicabilita().sizeContentTypeList(); ++i) {
                                        if (i > 0) {
                                            bf.append(",");
                                        }
                                        bf.append(regolaRisposta.getApplicabilita().getContentType(i));
                                    }
                                    if (bf.length() > 0) {
                                        applicabilitaCtResponse = bf.toString();
                                    }
                                }
                                listInsertAndGeneratedKeyObject = new ArrayList<E>();
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("id_trasformazione", (Object)idtrasformazione, InsertAndGeneratedKeyJDBCType.LONG));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("nome", (Object)regolaRisposta.getNome(), InsertAndGeneratedKeyJDBCType.STRING));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("posizione", (Object)regolaRisposta.getPosizione(), InsertAndGeneratedKeyJDBCType.INT));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("applicabilita_status_min", regolaRisposta.getApplicabilita() != null && regolaRisposta.getApplicabilita().getReturnCodeMin() != null && regolaRisposta.getApplicabilita().getReturnCodeMin() > 0 ? Integer.valueOf(regolaRisposta.getApplicabilita().getReturnCodeMin()) : null, InsertAndGeneratedKeyJDBCType.INT));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("applicabilita_status_max", regolaRisposta.getApplicabilita() != null && regolaRisposta.getApplicabilita().getReturnCodeMax() != null && regolaRisposta.getApplicabilita().getReturnCodeMax() > 0 ? Integer.valueOf(regolaRisposta.getApplicabilita().getReturnCodeMax()) : null, InsertAndGeneratedKeyJDBCType.INT));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("applicabilita_ct", (Object)applicabilitaCtResponse, InsertAndGeneratedKeyJDBCType.STRING));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("applicabilita_pattern", (Object)(regolaRisposta.getApplicabilita() != null ? regolaRisposta.getApplicabilita().getPattern() : null), InsertAndGeneratedKeyJDBCType.STRING));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("conversione_enabled", (Object)(regolaRisposta.getConversione() != false ? 1 : 0), InsertAndGeneratedKeyJDBCType.INT));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("conversione_tipo", (Object)regolaRisposta.getConversioneTipo(), InsertAndGeneratedKeyJDBCType.STRING));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("content_type", (Object)regolaRisposta.getContentType(), InsertAndGeneratedKeyJDBCType.STRING));
                                listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("return_code", (Object)regolaRisposta.getReturnCode(), InsertAndGeneratedKeyJDBCType.STRING));
                                if (regolaRisposta.getTrasformazioneSoap() != null) {
                                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_envelope", (Object)(regolaRisposta.getTrasformazioneSoap().getEnvelope() != false ? 1 : 0), InsertAndGeneratedKeyJDBCType.INT));
                                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_envelope_as_attach", (Object)(regolaRisposta.getTrasformazioneSoap().getEnvelopeAsAttachment() != false ? 1 : 0), InsertAndGeneratedKeyJDBCType.INT));
                                    listInsertAndGeneratedKeyObject.add(new InsertAndGeneratedKeyObject("soap_envelope_tipo", (Object)regolaRisposta.getTrasformazioneSoap().getEnvelopeBodyConversioneTipo(), InsertAndGeneratedKeyJDBCType.STRING));
                                }
                                tableName = null;
                                columnIdName = null;
                                sequence = null;
                                tableForId = null;
                                if (portaDelegata) {
                                    tableName = "pd_transform_risp";
                                    columnIdName = "id";
                                    sequence = "seq_pd_transform_risp";
                                    tableForId = "pd_transform_risp_init_seq";
                                } else {
                                    tableName = "pa_transform_risp";
                                    columnIdName = "id";
                                    sequence = "seq_pa_transform_risp";
                                    tableForId = "pa_transform_risp_init_seq";
                                }
                                idtrasformazioneRisposta = InsertAndGeneratedKey.insertAndReturnGeneratedKey((Connection)con, (TipiDatabase)TipiDatabase.toEnumConstant((String)DriverConfigurazioneDBLib.tipoDB), (IKeyGeneratorObject)new CustomKeyGeneratorObject(tableName, columnIdName, sequence, tableForId), (InsertAndGeneratedKeyObject[])listInsertAndGeneratedKeyObject.toArray(new InsertAndGeneratedKeyObject[1]));
                                if (idtrasformazioneRisposta <= 0L) {
                                    throw new DriverConfigurazioneException("ID autoincrementale non ottenuto");
                                }
                                if (regolaRisposta.getConversioneTemplate() != null || regolaRisposta.getTrasformazioneSoap() != null && regolaRisposta.getTrasformazioneSoap().getEnvelopeBodyConversioneTemplate() != null) {
                                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                    sqlQueryObject.addUpdateTable(tableName);
                                    if (regolaRisposta.getConversioneTemplate() != null) {
                                        sqlQueryObject.addUpdateField("conversione_template", "?");
                                    }
                                    if (regolaRisposta.getTrasformazioneSoap() != null && regolaRisposta.getTrasformazioneSoap().getEnvelopeBodyConversioneTemplate() != null) {
                                        sqlQueryObject.addUpdateField("soap_envelope_template", "?");
                                    }
                                    sqlQueryObject.addWhereCondition(columnIdName + "=?");
                                    updateQuery = sqlQueryObject.createSQLUpdate();
                                    updateStmt = con.prepareStatement(updateQuery);
                                    index = 1;
                                    if (regolaRisposta.getConversioneTemplate() != null) {
                                        jdbcAdapter.setBinaryData(updateStmt, index++, regolaRisposta.getConversioneTemplate());
                                    }
                                    if (regolaRisposta.getTrasformazioneSoap() != null && regolaRisposta.getTrasformazioneSoap().getEnvelopeBodyConversioneTemplate() != null) {
                                        jdbcAdapter.setBinaryData(updateStmt, index++, regolaRisposta.getTrasformazioneSoap().getEnvelopeBodyConversioneTemplate());
                                    }
                                    updateStmt.setLong(index++, idtrasformazioneRisposta);
                                    updateStmt.executeUpdate();
                                    updateStmt.close();
                                }
                                if (regolaRisposta.sizeHeaderList() <= 0) continue;
                                for (TrasformazioneRegolaParametro parametro : regolaRisposta.getHeaderList()) {
                                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                    if (portaDelegata) {
                                        sqlQueryObject.addInsertTable("pd_transform_risp_hdr");
                                    } else {
                                        sqlQueryObject.addInsertTable("pa_transform_risp_hdr");
                                    }
                                    sqlQueryObject.addInsertField("id_transform_risp", "?");
                                    sqlQueryObject.addInsertField("tipo", "?");
                                    sqlQueryObject.addInsertField("nome", "?");
                                    sqlQueryObject.addInsertField("valore", "?");
                                    sqlQueryObject.addInsertField("identificazione_fallita", "?");
                                    updateQuery = sqlQueryObject.createSQLInsert();
                                    updateStmt = con.prepareStatement(updateQuery);
                                    index = 1;
                                    updateStmt.setLong(index++, idtrasformazioneRisposta);
                                    updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(parametro.getConversioneTipo()));
                                    updateStmt.setString(index++, parametro.getNome());
                                    updateStmt.setString(index++, parametro.getValore());
                                    updateStmt.setString(index++, DriverConfigurazioneDBLib.getValue(parametro.getIdentificazioneFallita()));
                                    updateStmt.executeUpdate();
                                    updateStmt.close();
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    trasformazioniOld = DriverConfigurazioneDBTrasformazioniLib.readTrasformazioni(idProprietario, portaDelegata, con);
                    if (trasformazioniOld != null) {
                        DriverConfigurazioneDBTrasformazioniLib.CRUDTrasformazioni(3, con, trasformazioniOld, idProprietario, portaDelegata);
                    }
                    if (trasformazioni == null) ** break;
                    DriverConfigurazioneDBTrasformazioniLib.normalizePositionsEngine(trasformazioni);
                    DriverConfigurazioneDBTrasformazioniLib.CRUDTrasformazioni(1, con, trasformazioni, idProprietario, portaDelegata);
                    ** break;
lbl383:
                    // 1 sources

                    break;
                }
                case 3: {
                    if (trasformazioni == null) {
                        ** break;
lbl387:
                        // 1 sources

                    } else {
                        tableName = portaDelegata != false ? "pd_transform" : "pa_transform";
                        tableNameSoggetti = portaDelegata != false ? null : "pa_transform_soggetti";
                        tableNameSA = portaDelegata != false ? "pd_transform_sa" : "pa_transform_sa";
                        tableNameHeader = portaDelegata != false ? "pd_transform_hdr" : "pa_transform_hdr";
                        tableNameUrl = portaDelegata != false ? "pd_transform_url" : "pa_transform_url";
                        tableNameRisposte = portaDelegata != false ? "pd_transform_risp" : "pa_transform_risp";
                        tableNameRisposteHeader = portaDelegata != false ? "pd_transform_risp_hdr" : "pa_transform_risp_hdr";
                        idTrasformazioneList = new ArrayList<Long>();
                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                        sqlQueryObject.addFromTable(tableName);
                        sqlQueryObject.addSelectField("id");
                        sqlQueryObject.addWhereCondition("id_porta=?");
                        sqlQueryObject.setANDLogicOperator(true);
                        updateQuery = sqlQueryObject.createSQLQuery();
                        updateStmt = con.prepareStatement(updateQuery);
                        updateStmt.setLong(1, idProprietario);
                        rs = updateStmt.executeQuery();
                        while (rs.next()) {
                            idTrasformazioneList.add(rs.getLong("id"));
                        }
                        rs.close();
                        updateStmt.close();
                        if (idTrasformazioneList.isEmpty()) {
                            ** break;
lbl416:
                            // 1 sources

                        } else {
                            for (Long idTrasformazione : idTrasformazioneList) {
                                if (tableNameSoggetti != null) {
                                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                    sqlQueryObject.addDeleteTable(tableNameSoggetti);
                                    sqlQueryObject.addWhereCondition("id_trasformazione=?");
                                    sqlQueryObject.setANDLogicOperator(true);
                                    updateQuery = sqlQueryObject.createSQLDelete();
                                    updateStmt = con.prepareStatement(updateQuery);
                                    updateStmt.setLong(1, idTrasformazione);
                                    updateStmt.executeUpdate();
                                    updateStmt.close();
                                }
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                sqlQueryObject.addDeleteTable(tableNameSA);
                                sqlQueryObject.addWhereCondition("id_trasformazione=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idTrasformazione);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                sqlQueryObject.addDeleteTable(tableNameHeader);
                                sqlQueryObject.addWhereCondition("id_trasformazione=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idTrasformazione);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                sqlQueryObject.addDeleteTable(tableNameUrl);
                                sqlQueryObject.addWhereCondition("id_trasformazione=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idTrasformazione);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                                idTrasformazioneRisposteList = new ArrayList<Long>();
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                sqlQueryObject.addFromTable(tableNameRisposte);
                                sqlQueryObject.addSelectField("id");
                                sqlQueryObject.addWhereCondition("id_trasformazione=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLQuery();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idTrasformazione);
                                rs = updateStmt.executeQuery();
                                while (rs.next()) {
                                    idTrasformazioneRisposteList.add(rs.getLong("id"));
                                }
                                rs.close();
                                updateStmt.close();
                                if (!idTrasformazioneRisposteList.isEmpty()) {
                                    for (Long idTrasformazioneRisposta : idTrasformazioneRisposteList) {
                                        sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                        sqlQueryObject.addDeleteTable(tableNameRisposteHeader);
                                        sqlQueryObject.addWhereCondition("id_transform_risp=?");
                                        sqlQueryObject.setANDLogicOperator(true);
                                        updateQuery = sqlQueryObject.createSQLDelete();
                                        updateStmt = con.prepareStatement(updateQuery);
                                        updateStmt.setLong(1, idTrasformazioneRisposta);
                                        updateStmt.executeUpdate();
                                        updateStmt.close();
                                    }
                                }
                                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                                sqlQueryObject.addDeleteTable(tableNameRisposte);
                                sqlQueryObject.addWhereCondition("id_trasformazione=?");
                                sqlQueryObject.setANDLogicOperator(true);
                                updateQuery = sqlQueryObject.createSQLDelete();
                                updateStmt = con.prepareStatement(updateQuery);
                                updateStmt.setLong(1, idTrasformazione);
                                updateStmt.executeUpdate();
                                updateStmt.close();
                            }
                            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                            sqlQueryObject.addDeleteTable(tableName);
                            sqlQueryObject.addWhereCondition("id_porta=?");
                            sqlQueryObject.setANDLogicOperator(true);
                            updateQuery = sqlQueryObject.createSQLDelete();
                            updateStmt = con.prepareStatement(updateQuery);
                            updateStmt.setLong(1, idProprietario);
                            updateStmt.executeUpdate();
                            updateStmt.close();
                            ** break;
                        }
                    }
lbl527:
                    // 1 sources

                    break;
                }
                ** default:
lbl529:
                // 1 sources

                break;
            }
        }
        catch (SQLException se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneGenerale] SQLException [" + se.getMessage() + "].", se);
        }
        catch (Exception se) {
            throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDConfigurazioneGenerale] Exception [" + se.getMessage() + "].", se);
        }
        finally {
            JDBCUtilities.closeResources(rs, updateStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Trasformazioni readTrasformazioni(long idPorta, boolean portaDelegata, Connection con) throws Exception {
        IJDBCAdapter jdbcAdapter;
        String sqlQuery;
        ISQLQueryObject sqlQueryObject;
        String nomeTabella;
        Trasformazioni trasformazioni;
        ResultSet rs1;
        PreparedStatement stm1;
        ResultSet rs;
        PreparedStatement stm;
        block46: {
            stm = null;
            rs = null;
            stm1 = null;
            rs1 = null;
            trasformazioni = null;
            nomeTabella = portaDelegata ? "pd_transform" : "pa_transform";
            sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
            sqlQueryObject.addFromTable(nomeTabella);
            sqlQueryObject.addSelectField("*");
            sqlQueryObject.addWhereCondition("id_porta=?");
            sqlQueryObject.addOrderBy("posizione");
            sqlQueryObject.addOrderBy("nome");
            sqlQueryObject.setSortType(true);
            sqlQuery = sqlQueryObject.createSQLQuery();
            stm = con.prepareStatement(sqlQuery);
            stm.setLong(1, idPorta);
            DriverConfigurazioneDBLib.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, idPorta));
            rs = stm.executeQuery();
            while (rs.next()) {
                int trasformazioneSoapIntValue;
                if (trasformazioni == null) {
                    trasformazioni = new Trasformazioni();
                }
                TrasformazioneRegola regola = new TrasformazioneRegola();
                String nome = rs.getString("nome");
                regola.setNome(nome);
                int posizione = rs.getInt("posizione");
                regola.setPosizione(posizione);
                StatoFunzionalita stato = DriverConfigurazioneDBLib.getEnumStatoFunzionalita(rs.getString("stato"));
                regola.setStato(stato);
                String applicabilitaAzioni = rs.getString("applicabilita_azioni");
                String applicabilitaCT = rs.getString("applicabilita_ct");
                String applicabilitaPattern = rs.getString("applicabilita_pattern");
                String applicabilitaConnettori = rs.getString("applicabilita_connettori");
                if (applicabilitaAzioni != null && !"".equals(applicabilitaAzioni) || applicabilitaCT != null && !"".equals(applicabilitaCT) || applicabilitaPattern != null && !"".equals(applicabilitaPattern) || applicabilitaConnettori != null && !"".equals(applicabilitaConnettori)) {
                    int i;
                    String[] tmp;
                    TrasformazioneRegolaApplicabilitaRichiesta applicabilita = new TrasformazioneRegolaApplicabilitaRichiesta();
                    if (applicabilitaAzioni != null && !"".equals(applicabilitaAzioni)) {
                        if (applicabilitaAzioni.contains(",")) {
                            tmp = applicabilitaAzioni.split(",");
                            for (i = 0; i < tmp.length; ++i) {
                                applicabilita.addAzione(tmp[i].trim());
                            }
                        } else {
                            applicabilita.addAzione(applicabilitaAzioni);
                        }
                    }
                    if (applicabilitaCT != null && !"".equals(applicabilitaCT)) {
                        if (applicabilitaCT.contains(",")) {
                            tmp = applicabilitaCT.split(",");
                            for (i = 0; i < tmp.length; ++i) {
                                applicabilita.addContentType(tmp[i].trim());
                            }
                        } else {
                            applicabilita.addContentType(applicabilitaCT);
                        }
                    }
                    if (applicabilitaPattern != null && !"".equals(applicabilitaPattern)) {
                        applicabilita.setPattern(applicabilitaPattern);
                    }
                    if (applicabilitaConnettori != null && !"".equals(applicabilitaConnettori)) {
                        if (applicabilitaConnettori.contains(",")) {
                            tmp = applicabilitaConnettori.split(",");
                            for (i = 0; i < tmp.length; ++i) {
                                applicabilita.addConnettore(tmp[i].trim());
                            }
                        } else {
                            applicabilita.addConnettore(applicabilitaConnettori);
                        }
                    }
                    regola.setApplicabilita(applicabilita);
                }
                TrasformazioneRegolaRichiesta richiesta = new TrasformazioneRegolaRichiesta();
                int reqConversioneEnabled = rs.getInt("req_conversione_enabled");
                richiesta.setConversione(1 == reqConversioneEnabled);
                richiesta.setConversioneTipo(rs.getString("req_conversione_tipo"));
                jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverConfigurazioneDBLib.tipoDB);
                richiesta.setConversioneTemplate(jdbcAdapter.getBinaryData(rs, "req_conversione_template"));
                richiesta.setContentType(rs.getString("req_content_type"));
                int trasformazioneRestIntValue = rs.getInt("rest_transformation");
                if (1 == trasformazioneRestIntValue) {
                    TrasformazioneRest trasformazioneRest = new TrasformazioneRest();
                    trasformazioneRest.setMetodo(rs.getString("rest_method"));
                    trasformazioneRest.setPath(rs.getString("rest_path"));
                    richiesta.setTrasformazioneRest(trasformazioneRest);
                }
                if (1 == (trasformazioneSoapIntValue = rs.getInt("soap_transformation"))) {
                    TrasformazioneSoap trasformazioneSoap = new TrasformazioneSoap();
                    trasformazioneSoap.setVersione(DriverConfigurazioneDBLib.getEnumVersioneSOAP(rs.getString("soap_version")));
                    trasformazioneSoap.setSoapAction(rs.getString("soap_action"));
                    int envelope = rs.getInt("soap_envelope");
                    trasformazioneSoap.setEnvelope(1 == envelope);
                    int envelopeAsAttach = rs.getInt("soap_envelope_as_attach");
                    if (1 == envelopeAsAttach) {
                        trasformazioneSoap.setEnvelopeAsAttachment(true);
                        trasformazioneSoap.setEnvelopeBodyConversioneTipo(rs.getString("soap_envelope_tipo"));
                        trasformazioneSoap.setEnvelopeBodyConversioneTemplate(jdbcAdapter.getBinaryData(rs, "soap_envelope_template"));
                    } else {
                        trasformazioneSoap.setEnvelopeAsAttachment(false);
                    }
                    richiesta.setTrasformazioneSoap(trasformazioneSoap);
                }
                regola.setId(rs.getLong("id"));
                regola.setRichiesta(richiesta);
                trasformazioni.addRegola(regola);
            }
            rs.close();
            stm.close();
            if (trasformazioni != null) break block46;
            Trasformazioni trasformazioni2 = trasformazioni;
            JDBCUtilities.closeResources(rs1, stm1);
            JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
            return trasformazioni2;
        }
        try {
            for (TrasformazioneRegola regola : trasformazioni.getRegolaList()) {
                if (!portaDelegata) {
                    nomeTabella = "pa_transform_soggetti";
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_trasformazione=?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, regola.getId());
                    rs = stm.executeQuery();
                    while (rs.next()) {
                        if (regola.getApplicabilita() == null) {
                            regola.setApplicabilita(new TrasformazioneRegolaApplicabilitaRichiesta());
                        }
                        TrasformazioneRegolaApplicabilitaSoggetto soggetto = new TrasformazioneRegolaApplicabilitaSoggetto();
                        soggetto.setTipo(rs.getString("tipo_soggetto"));
                        soggetto.setNome(rs.getString("nome_soggetto"));
                        regola.getApplicabilita().addSoggetto(soggetto);
                    }
                    rs.close();
                    stm.close();
                }
                nomeTabella = portaDelegata ? "pd_transform_sa" : "pa_transform_sa";
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_trasformazione=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, regola.getId());
                rs = stm.executeQuery();
                while (rs.next()) {
                    long idSA = rs.getLong("id_servizio_applicativo");
                    if (idSA == 0L) continue;
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addFromTable("servizi_applicativi");
                    sqlQueryObject.addFromTable("soggetti");
                    sqlQueryObject.addSelectField("nome");
                    sqlQueryObject.addSelectField("tipo_soggetto");
                    sqlQueryObject.addSelectField("nome_soggetto");
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id=?");
                    sqlQueryObject.addWhereCondition("servizi_applicativi.id_soggetto=soggetti.id");
                    sqlQueryObject.setANDLogicOperator(true);
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm1 = con.prepareStatement(sqlQuery);
                    stm1.setLong(1, idSA);
                    DriverConfigurazioneDBLib.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, idSA));
                    rs1 = stm1.executeQuery();
                    TrasformazioneRegolaApplicabilitaServizioApplicativo servizioApplicativo = null;
                    if (rs1.next()) {
                        servizioApplicativo = new TrasformazioneRegolaApplicabilitaServizioApplicativo();
                        servizioApplicativo.setId(idSA);
                        servizioApplicativo.setNome(rs1.getString("nome"));
                        servizioApplicativo.setTipoSoggettoProprietario(rs1.getString("tipo_soggetto"));
                        servizioApplicativo.setNomeSoggettoProprietario(rs1.getString("nome_soggetto"));
                        if (regola.getApplicabilita() == null) {
                            regola.setApplicabilita(new TrasformazioneRegolaApplicabilitaRichiesta());
                        }
                        regola.getApplicabilita().addServizioApplicativo(servizioApplicativo);
                    }
                    rs1.close();
                    stm1.close();
                }
                rs.close();
                stm.close();
                nomeTabella = portaDelegata ? "pd_transform_hdr" : "pa_transform_hdr";
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_trasformazione=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, regola.getId());
                DriverConfigurazioneDBLib.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, idPorta));
                rs = stm.executeQuery();
                while (rs.next()) {
                    TrasformazioneRegolaParametro parametro = new TrasformazioneRegolaParametro();
                    parametro.setConversioneTipo(DriverConfigurazioneDBLib.getEnumTrasformazioneRegolaParametroTipoAzione(rs.getString("tipo")));
                    parametro.setNome(rs.getString("nome"));
                    parametro.setValore(rs.getString("valore"));
                    parametro.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumTrasformazioneIdentificazioneRisorsaFallita(rs.getString("identificazione_fallita")));
                    parametro.setId(rs.getLong("id"));
                    regola.getRichiesta().addHeader(parametro);
                }
                rs.close();
                stm.close();
                nomeTabella = portaDelegata ? "pd_transform_url" : "pa_transform_url";
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_trasformazione=?");
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, regola.getId());
                DriverConfigurazioneDBLib.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, idPorta));
                rs = stm.executeQuery();
                while (rs.next()) {
                    TrasformazioneRegolaParametro parametro = new TrasformazioneRegolaParametro();
                    parametro.setConversioneTipo(DriverConfigurazioneDBLib.getEnumTrasformazioneRegolaParametroTipoAzione(rs.getString("tipo")));
                    parametro.setNome(rs.getString("nome"));
                    parametro.setValore(rs.getString("valore"));
                    parametro.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumTrasformazioneIdentificazioneRisorsaFallita(rs.getString("identificazione_fallita")));
                    parametro.setId(rs.getLong("id"));
                    regola.getRichiesta().addParametroUrl(parametro);
                }
                rs.close();
                stm.close();
                nomeTabella = portaDelegata ? "pd_transform_risp" : "pa_transform_risp";
                sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                sqlQueryObject.addFromTable(nomeTabella);
                sqlQueryObject.addSelectField("*");
                sqlQueryObject.addWhereCondition("id_trasformazione=?");
                sqlQueryObject.addOrderBy("posizione");
                sqlQueryObject.addOrderBy("nome");
                sqlQueryObject.setSortType(true);
                sqlQuery = sqlQueryObject.createSQLQuery();
                stm = con.prepareStatement(sqlQuery);
                stm.setLong(1, regola.getId());
                DriverConfigurazioneDBLib.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, idPorta));
                rs = stm.executeQuery();
                while (rs.next()) {
                    int conversioneEnabled;
                    TrasformazioneRegolaRisposta risposta = new TrasformazioneRegolaRisposta();
                    String nome = rs.getString("nome");
                    risposta.setNome(nome);
                    int posizione = rs.getInt("posizione");
                    risposta.setPosizione(posizione);
                    int applicabilitaStatusMin = rs.getInt("applicabilita_status_min");
                    int applicabilitaStatusMax = rs.getInt("applicabilita_status_max");
                    String applicabilitaCT = rs.getString("applicabilita_ct");
                    String applicabilitaPattern = rs.getString("applicabilita_pattern");
                    if (applicabilitaStatusMin > 0 || applicabilitaStatusMax > 0 || applicabilitaCT != null && !"".equals(applicabilitaCT) || applicabilitaPattern != null && !"".equals(applicabilitaPattern)) {
                        TrasformazioneRegolaApplicabilitaRisposta applicabilita = new TrasformazioneRegolaApplicabilitaRisposta();
                        if (applicabilitaStatusMin > 0) {
                            applicabilita.setReturnCodeMin(applicabilitaStatusMin);
                        }
                        if (applicabilitaStatusMax > 0) {
                            applicabilita.setReturnCodeMax(applicabilitaStatusMax);
                        }
                        if (applicabilitaCT != null && !"".equals(applicabilitaCT)) {
                            if (applicabilitaCT.contains(",")) {
                                String[] tmp = applicabilitaCT.split(",");
                                for (int i = 0; i < tmp.length; ++i) {
                                    applicabilita.addContentType(tmp[i].trim());
                                }
                            } else {
                                applicabilita.addContentType(applicabilitaCT);
                            }
                        }
                        if (applicabilitaPattern != null && !"".equals(applicabilitaPattern)) {
                            applicabilita.setPattern(applicabilitaPattern);
                        }
                        risposta.setApplicabilita(applicabilita);
                    }
                    risposta.setConversione(1 == (conversioneEnabled = rs.getInt("conversione_enabled")));
                    risposta.setConversioneTipo(rs.getString("conversione_tipo"));
                    jdbcAdapter = JDBCAdapterFactory.createJDBCAdapter((String)DriverConfigurazioneDBLib.tipoDB);
                    risposta.setConversioneTemplate(jdbcAdapter.getBinaryData(rs, "conversione_template"));
                    risposta.setContentType(rs.getString("content_type"));
                    risposta.setReturnCode(rs.getString("return_code"));
                    if (regola.getRichiesta().getTrasformazioneRest() != null) {
                        TrasformazioneSoapRisposta trasformazioneSoap = new TrasformazioneSoapRisposta();
                        int envelope = rs.getInt("soap_envelope");
                        trasformazioneSoap.setEnvelope(1 == envelope);
                        int envelopeAsAttach = rs.getInt("soap_envelope_as_attach");
                        if (1 == envelopeAsAttach) {
                            trasformazioneSoap.setEnvelopeAsAttachment(true);
                            trasformazioneSoap.setEnvelopeBodyConversioneTipo(rs.getString("soap_envelope_tipo"));
                            trasformazioneSoap.setEnvelopeBodyConversioneTemplate(jdbcAdapter.getBinaryData(rs, "soap_envelope_template"));
                        } else {
                            trasformazioneSoap.setEnvelopeAsAttachment(false);
                        }
                        risposta.setTrasformazioneSoap(trasformazioneSoap);
                    }
                    risposta.setId(rs.getLong("id"));
                    regola.addRisposta(risposta);
                }
                rs.close();
                stm.close();
                for (TrasformazioneRegolaRisposta risposta : regola.getRispostaList()) {
                    nomeTabella = portaDelegata ? "pd_transform_risp_hdr" : "pa_transform_risp_hdr";
                    sqlQueryObject = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject.addFromTable(nomeTabella);
                    sqlQueryObject.addSelectField("*");
                    sqlQueryObject.addWhereCondition("id_transform_risp=?");
                    sqlQuery = sqlQueryObject.createSQLQuery();
                    stm = con.prepareStatement(sqlQuery);
                    stm.setLong(1, risposta.getId());
                    DriverConfigurazioneDBLib.logDebug(ESEGUO_QUERY_PREFIX + DBUtils.formatSQLString(sqlQuery, idPorta));
                    rs = stm.executeQuery();
                    while (rs.next()) {
                        TrasformazioneRegolaParametro parametro = new TrasformazioneRegolaParametro();
                        parametro.setConversioneTipo(DriverConfigurazioneDBLib.getEnumTrasformazioneRegolaParametroTipoAzione(rs.getString("tipo")));
                        parametro.setNome(rs.getString("nome"));
                        parametro.setValore(rs.getString("valore"));
                        parametro.setIdentificazioneFallita(DriverConfigurazioneDBLib.getEnumTrasformazioneIdentificazioneRisorsaFallita(rs.getString("identificazione_fallita")));
                        parametro.setId(rs.getLong("id"));
                        risposta.addHeader(parametro);
                    }
                    rs.close();
                    stm.close();
                }
            }
        }
        catch (Throwable throwable) {
            JDBCUtilities.closeResources(rs1, stm1);
            JDBCUtilities.closeResources(rs, stm);
            throw throwable;
        }
        JDBCUtilities.closeResources(rs1, stm1);
        JDBCUtilities.closeResources((ResultSet)rs, (PreparedStatement)stm);
        return trasformazioni;
    }
}

