/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.core.config.driver.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.openspcoop2.core.commons.DBUtils;
import org.openspcoop2.core.config.Soggetto;
import org.openspcoop2.core.config.driver.DriverConfigurazioneException;
import org.openspcoop2.core.config.driver.db.DriverConfigurazioneDBLib;
import org.openspcoop2.utils.jdbc.JDBCUtilities;
import org.openspcoop2.utils.sql.ISQLQueryObject;
import org.openspcoop2.utils.sql.SQLObjectFactory;

public class DriverConfigurazioneDBSoggettiLib {
    private DriverConfigurazioneDBSoggettiLib() {
    }

    private static String buildCrudSoggettoMessage(int type, int n) {
        return "CRUDSoggetto type = " + type + " row affected =" + n;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long CRUDSoggetto(int type, Soggetto soggetto, Connection con) throws DriverConfigurazioneException {
        long sqlQueryObject322222;
        int n;
        ResultSet selectRS;
        PreparedStatement selectStmt;
        PreparedStatement updateStmt;
        block17: {
            if (soggetto == null) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro non valido.");
            }
            String nome = soggetto.getNome();
            String tipo = soggetto.getTipo();
            if (nome == null || nome.equals("")) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro Nome non valido.");
            }
            if (tipo == null || tipo.equals("")) {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Parametro Tipo non valido.");
            }
            String descrizione = soggetto.getDescrizione();
            String identificativoPorta = soggetto.getIdentificativoPorta();
            String superuser = soggetto.getSuperUser();
            boolean router = soggetto.getRouter();
            boolean isDefault = soggetto.isDominioDefault();
            String pdUrlPrefixRewriter = soggetto.getPdUrlPrefixRewriter();
            String paUrlPrefixRewriter = soggetto.getPaUrlPrefixRewriter();
            updateStmt = null;
            selectStmt = null;
            String updateQuery = "";
            String selectQuery = "";
            selectRS = null;
            n = 0;
            switch (type) {
                case 1: {
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject2.addInsertTable(DriverConfigurazioneDBLib.tabellaSoggetti);
                    sqlQueryObject2.addInsertField("nome_soggetto", "?");
                    sqlQueryObject2.addInsertField("descrizione", "?");
                    sqlQueryObject2.addInsertField("identificativo_porta", "?");
                    sqlQueryObject2.addInsertField("tipo_soggetto", "?");
                    sqlQueryObject2.addInsertField("is_router", "?");
                    sqlQueryObject2.addInsertField("is_default", "?");
                    sqlQueryObject2.addInsertField("superuser", "?");
                    sqlQueryObject2.addInsertField("pd_url_prefix_rewriter", "?");
                    sqlQueryObject2.addInsertField("pa_url_prefix_rewriter", "?");
                    updateQuery = sqlQueryObject2.createSQLInsert();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descrizione);
                    updateStmt.setString(index++, identificativoPorta);
                    updateStmt.setString(index++, tipo);
                    updateStmt.setInt(index++, router ? 1 : 0);
                    updateStmt.setInt(index++, isDefault ? 1 : 0);
                    updateStmt.setString(index++, superuser);
                    updateStmt.setString(index++, pdUrlPrefixRewriter);
                    updateStmt.setString(index++, paUrlPrefixRewriter);
                    n = updateStmt.executeUpdate();
                    DriverConfigurazioneDBLib.logDebug("CRUDSoggetto CREATE : \n" + DBUtils.formatSQLString(updateQuery, nome, descrizione, identificativoPorta, tipo, router, superuser));
                    DriverConfigurazioneDBLib.logDebug(DriverConfigurazioneDBSoggettiLib.buildCrudSoggettoMessage(type, n));
                    sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject2.addFromTable(DriverConfigurazioneDBLib.tabellaSoggetti);
                    sqlQueryObject2.addSelectField("id");
                    sqlQueryObject2.addWhereCondition("tipo_soggetto = ?");
                    sqlQueryObject2.addWhereCondition("nome_soggetto = ?");
                    sqlQueryObject2.setANDLogicOperator(true);
                    selectQuery = sqlQueryObject2.createSQLQuery();
                    selectStmt = con.prepareStatement(selectQuery);
                    selectStmt.setString(1, tipo);
                    selectStmt.setString(2, nome);
                    break;
                }
                case 2: {
                    String oldNomeSoggetto = null;
                    String oldTipoSoggetto = null;
                    if (soggetto.getOldIDSoggettoForUpdate() != null) {
                        oldNomeSoggetto = soggetto.getOldIDSoggettoForUpdate().getNome();
                        oldTipoSoggetto = soggetto.getOldIDSoggettoForUpdate().getTipo();
                    }
                    if (oldNomeSoggetto == null || oldNomeSoggetto.equals("")) {
                        oldNomeSoggetto = nome;
                    }
                    if (oldTipoSoggetto == null || oldTipoSoggetto.equals("")) {
                        oldTipoSoggetto = tipo;
                    }
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject2.addUpdateTable(DriverConfigurazioneDBLib.tabellaSoggetti);
                    sqlQueryObject2.addUpdateField("nome_soggetto", "?");
                    sqlQueryObject2.addUpdateField("descrizione", "?");
                    sqlQueryObject2.addUpdateField("identificativo_porta", "?");
                    sqlQueryObject2.addUpdateField("tipo_soggetto", "?");
                    sqlQueryObject2.addUpdateField("is_router", "?");
                    sqlQueryObject2.addUpdateField("is_default", "?");
                    sqlQueryObject2.addUpdateField("superuser", "?");
                    sqlQueryObject2.addUpdateField("pd_url_prefix_rewriter", "?");
                    sqlQueryObject2.addUpdateField("pa_url_prefix_rewriter", "?");
                    sqlQueryObject2.addWhereCondition("nome_soggetto=?");
                    sqlQueryObject2.addWhereCondition("tipo_soggetto=?");
                    sqlQueryObject2.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject2.createSQLUpdate();
                    updateStmt = con.prepareStatement(updateQuery);
                    int index = 1;
                    updateStmt.setString(index++, nome);
                    updateStmt.setString(index++, descrizione);
                    updateStmt.setString(index++, identificativoPorta);
                    updateStmt.setString(index++, tipo);
                    updateStmt.setInt(index++, router ? 1 : 0);
                    updateStmt.setInt(index++, isDefault ? 1 : 0);
                    updateStmt.setString(index++, superuser);
                    updateStmt.setString(index++, pdUrlPrefixRewriter);
                    updateStmt.setString(index++, paUrlPrefixRewriter);
                    updateStmt.setString(index++, oldNomeSoggetto);
                    updateStmt.setString(index++, oldTipoSoggetto);
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverConfigurazioneDBLib.logDebug("CRUDSoggetto UPDATE : \n" + DBUtils.formatSQLString(updateQuery, nome, descrizione, identificativoPorta, tipo, router, soggetto.getId()));
                    DriverConfigurazioneDBLib.logDebug(DriverConfigurazioneDBSoggettiLib.buildCrudSoggettoMessage(type, n));
                    break;
                }
                case 3: {
                    ISQLQueryObject sqlQueryObject2 = SQLObjectFactory.createSQLQueryObject((String)DriverConfigurazioneDBLib.tipoDB);
                    sqlQueryObject2.addDeleteTable(DriverConfigurazioneDBLib.tabellaSoggetti);
                    sqlQueryObject2.addWhereCondition("nome_soggetto=?");
                    sqlQueryObject2.addWhereCondition("tipo_soggetto=?");
                    sqlQueryObject2.setANDLogicOperator(true);
                    updateQuery = sqlQueryObject2.createSQLDelete();
                    updateStmt = con.prepareStatement(updateQuery);
                    updateStmt.setString(1, soggetto.getNome());
                    updateStmt.setString(2, soggetto.getTipo());
                    n = updateStmt.executeUpdate();
                    updateStmt.close();
                    DriverConfigurazioneDBLib.logDebug(DriverConfigurazioneDBSoggettiLib.buildCrudSoggettoMessage(type, n));
                    DriverConfigurazioneDBLib.logDebug("CRUDSoggetto DELETE : \n" + DBUtils.formatSQLString(updateQuery, soggetto.getNome(), soggetto.getTipo()));
                    break;
                }
            }
            if (type != 1 || selectStmt == null || !(selectRS = selectStmt.executeQuery()).next()) break block17;
            soggetto.setId(selectRS.getLong("id"));
            long sqlQueryObject322222 = soggetto.getId();
            JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
            JDBCUtilities.closeResources((PreparedStatement)updateStmt);
            return sqlQueryObject322222;
        }
        try {
            sqlQueryObject322222 = n;
        }
        catch (SQLException se) {
            try {
                throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] SQLException [" + se.getMessage() + "].", se);
                catch (Exception se2) {
                    throw new DriverConfigurazioneException("[DriverConfigurazioneDB_LIB::CRUDSoggetto] Exception [" + se2.getMessage() + "].", se2);
                }
            }
            catch (Throwable throwable) {
                JDBCUtilities.closeResources(selectRS, selectStmt);
                JDBCUtilities.closeResources(updateStmt);
                throw throwable;
            }
        }
        JDBCUtilities.closeResources((ResultSet)selectRS, (PreparedStatement)selectStmt);
        JDBCUtilities.closeResources(updateStmt);
        return sqlQueryObject322222;
    }
}

