/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.xml;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.openspcoop2.message.OpenSPCoop2Message;
import org.openspcoop2.message.OpenSPCoop2RestMessage;
import org.openspcoop2.message.OpenSPCoop2RestXmlMessage;
import org.openspcoop2.message.constants.MessageType;
import org.openspcoop2.message.constants.ServiceBinding;
import org.openspcoop2.protocol.sdk.Busta;
import org.openspcoop2.protocol.sdk.constants.CodiceErroreCooperazione;
import org.openspcoop2.security.SecurityException;
import org.openspcoop2.security.message.AbstractRESTMessageSecurityReceiver;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.utils.EncryptionBean;
import org.openspcoop2.security.message.utils.KeystoreUtils;
import org.openspcoop2.security.message.utils.SignatureBean;
import org.openspcoop2.utils.Map;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.certificate.KeyStore;
import org.openspcoop2.utils.security.SymmetricKeyWrappedMode;
import org.openspcoop2.utils.security.VerifyXmlSignature;
import org.openspcoop2.utils.security.XmlDecrypt;
import org.w3c.dom.Element;

public class MessageSecurityReceiver_xml
extends AbstractRESTMessageSecurityReceiver {
    private VerifyXmlSignature xmlVerifierSignature = null;
    private XmlDecrypt xmlDecrypt = null;

    @Override
    public void process(MessageSecurityContext messageSecurityContext, OpenSPCoop2Message messageParam, Busta busta, Map<Object> ctx) throws SecurityException {
        block39: {
            boolean signatureProcess = false;
            boolean encryptProcess = false;
            try {
                String encryptionSymmetricWrapped;
                if (!ServiceBinding.REST.equals((Object)messageParam.getServiceBinding())) {
                    throw new SecurityException("XML Engine usable only with REST Binding");
                }
                if (!MessageType.XML.equals((Object)messageParam.getMessageType())) {
                    throw new SecurityException("XML Engine usable only with REST Binding and a xml message, found: " + String.valueOf(messageParam.getMessageType()));
                }
                OpenSPCoop2RestXmlMessage restXmlMessage = messageParam.castAsRestXml();
                boolean encrypt = false;
                boolean signature = false;
                String[] actions = ((String)messageSecurityContext.getIncomingProperties().get("action")).split(" ");
                for (int i = 0; i < actions.length; ++i) {
                    if (SecurityConstants.isActionEncryption(actions[i].trim()) || SecurityConstants.isActionDecryption(actions[i].trim())) {
                        encrypt = true;
                        continue;
                    }
                    if ("Signature".equals(actions[i].trim())) {
                        signature = true;
                        continue;
                    }
                    throw new SecurityException("XML Engine; action '" + actions[i] + "' unsupported");
                }
                if (encrypt && signature) {
                    throw new SecurityException("XML Engine usable only with one function beetwen encrypt or signature");
                }
                if (!encrypt && !signature) {
                    throw new SecurityException("XML Engine require one function beetwen encrypt or signature");
                }
                if (signature) {
                    SignatureBean bean = null;
                    bean = KeystoreUtils.getReceiverSignatureBean(messageSecurityContext, ctx);
                    KeyStore signatureKS = bean.getKeystore();
                    KeyStore signatureTrustStoreKS = bean.getTruststore();
                    String aliasSignatureUser = bean.getUser();
                    if (signatureKS == null && signatureTrustStoreKS == null) {
                        throw new SecurityException("XML SignatureVerifier Engine require truststore");
                    }
                    if (aliasSignatureUser == null) {
                        throw new SecurityException("XML SignatureVerifier Engine require alias certificate");
                    }
                    this.xmlVerifierSignature = signatureTrustStoreKS != null ? new VerifyXmlSignature(signatureTrustStoreKS, aliasSignatureUser) : new VerifyXmlSignature(signatureKS, aliasSignatureUser);
                    signatureProcess = true;
                    boolean verify = this.xmlVerifierSignature.verify((Element)restXmlMessage.getContent(), false);
                    if (!verify) {
                        throw new Exception("Signature verification failed");
                    }
                    break block39;
                }
                if (!encrypt) break block39;
                EncryptionBean bean = null;
                bean = KeystoreUtils.getReceiverEncryptionBean(messageSecurityContext, ctx);
                KeyStore encryptionKS = bean.getKeystore();
                boolean encryptionSymmetric = bean.isEncryptionSimmetric();
                SymmetricKeyWrappedMode encryptionSymmetricWrappedMode = null;
                encryptionSymmetricWrappedMode = encryptionSymmetric ? SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_SYMMETRIC_KEY : SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_ASYMMETRIC_KEY;
                String aliasEncryptUser = bean.getUser();
                String aliasEncryptPassword = bean.getPassword();
                if (encryptionSymmetric && (encryptionSymmetricWrapped = (String)messageSecurityContext.getIncomingProperties().get("decryptionSymmetricKeyWrapped")) != null) {
                    if ("true".equalsIgnoreCase(encryptionSymmetricWrapped)) {
                        encryptionSymmetricWrappedMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_WRAPPED_SYMMETRIC_KEY;
                    } else if ("false".equalsIgnoreCase(encryptionSymmetricWrapped)) {
                        encryptionSymmetricWrappedMode = SymmetricKeyWrappedMode.SYM_ENC_KEY_NO_WRAPPED;
                    }
                }
                if (encryptionKS == null) {
                    throw new SecurityException("XML Decrypt Engine require keystore");
                }
                if (aliasEncryptUser == null) {
                    if (encryptionSymmetric) {
                        throw new SecurityException("XML Decrypt Engine require alias secret key");
                    }
                    throw new SecurityException("XML Decrypt Engine require alias private key");
                }
                if (aliasEncryptPassword == null) {
                    if (encryptionSymmetric) {
                        throw new SecurityException("XML Decrypt Engine require password secret key");
                    }
                    throw new SecurityException("XML Decrypt Engine require password private key");
                }
                this.xmlDecrypt = new XmlDecrypt(encryptionKS, encryptionSymmetric, encryptionSymmetricWrappedMode, aliasEncryptUser, aliasEncryptPassword);
                boolean detach = true;
                String encryptionSymmetricWrapped2 = (String)messageSecurityContext.getIncomingProperties().get("detachSecurityInfo");
                if (encryptionSymmetricWrapped2 != null && "false".equalsIgnoreCase(encryptionSymmetricWrapped2)) {
                    detach = false;
                }
                Element xmlEncrypted = null;
                if (!detach) {
                    xmlEncrypted = (Element)((Element)restXmlMessage.getContent()).cloneNode(true);
                }
                encryptProcess = true;
                if (detach) {
                    this.xmlDecrypt.decrypt((Element)restXmlMessage.getContent());
                } else {
                    this.xmlDecrypt.decrypt(xmlEncrypted);
                }
            }
            catch (Exception e) {
                SecurityException secException = new SecurityException(e.getMessage(), e);
                String msg = Utilities.getInnerNotEmptyMessageException((Throwable)e).getMessage();
                Throwable innerExc = Utilities.getLastInnerException((Throwable)e);
                String innerMsg = null;
                if (innerExc != null) {
                    innerMsg = innerExc.getMessage();
                }
                Object messaggio = null;
                if (msg != null) {
                    messaggio = new String(msg);
                    if (innerMsg != null && !innerMsg.equals(msg)) {
                        messaggio = (String)messaggio + " ; " + innerMsg;
                    }
                } else if (innerMsg != null) {
                    messaggio = innerMsg;
                }
                secException.setMsgErrore((String)messaggio);
                if (signatureProcess) {
                    secException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_FIRMA_NON_VALIDA);
                } else if (encryptProcess) {
                    secException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA_CIFRATURA_NON_VALIDA);
                } else {
                    secException.setCodiceErrore(CodiceErroreCooperazione.SICUREZZA);
                }
                throw secException;
            }
        }
    }

    @Override
    public void detachSecurity(MessageSecurityContext messageSecurityContext, OpenSPCoop2RestMessage<?> messageParam) throws SecurityException {
        try {
            if (!ServiceBinding.REST.equals((Object)messageParam.getServiceBinding())) {
                throw new SecurityException("XML Engine usable only with REST Binding");
            }
            if (!MessageType.XML.equals((Object)messageParam.getMessageType())) {
                throw new SecurityException("XML Engine usable only with REST Binding and a xml message, found: " + String.valueOf(messageParam.getMessageType()));
            }
            OpenSPCoop2RestXmlMessage restXmlMessage = messageParam.castAsRestXml();
            if (this.xmlVerifierSignature != null) {
                this.xmlVerifierSignature.detach((Element)restXmlMessage.getContent());
            } else if (this.xmlDecrypt == null) {
                throw new SecurityException("XML Engine (detach method) usable only after one function beetwen encrypt or signature");
            }
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    @Override
    public String getCertificate() throws SecurityException {
        try {
            if (this.xmlVerifierSignature != null) {
                if (this.xmlVerifierSignature.getKeyInfo() != null) {
                    if (this.xmlVerifierSignature.getKeyInfo().getX509Certificate() != null && this.xmlVerifierSignature.getKeyInfo().getX509Certificate().getIssuerX500Principal() != null) {
                        return this.xmlVerifierSignature.getKeyInfo().getX509Certificate().getIssuerX500Principal().getName();
                    }
                    if (this.xmlVerifierSignature.getKeyInfo().getPublicKey() != null) {
                        // empty if block
                    }
                }
                return null;
            }
            if (this.xmlDecrypt != null) {
                return null;
            }
            throw new SecurityException("XML Engine (getCertificate method) usable only after one function beetwen encrypt or signature");
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    @Override
    public X509Certificate getX509Certificate() throws SecurityException {
        try {
            if (this.xmlVerifierSignature != null) {
                if (this.xmlVerifierSignature.getKeyInfo() != null && this.xmlVerifierSignature.getKeyInfo().getX509Certificate() != null && this.xmlVerifierSignature.getKeyInfo().getX509Certificate().getIssuerX500Principal() != null) {
                    return this.xmlVerifierSignature.getKeyInfo().getX509Certificate();
                }
                return null;
            }
            if (this.xmlDecrypt != null) {
                return null;
            }
            throw new SecurityException("XML Engine (getCertificate method) usable only after one function beetwen encrypt or signature");
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    @Override
    public PublicKey getPublicKey() throws SecurityException {
        try {
            if (this.xmlVerifierSignature != null) {
                if (this.xmlVerifierSignature.getKeyInfo() != null && this.xmlVerifierSignature.getKeyInfo().getPublicKey() != null) {
                    return this.xmlVerifierSignature.getKeyInfo().getPublicKey();
                }
                return null;
            }
            if (this.xmlDecrypt != null) {
                return null;
            }
            throw new SecurityException("XML Engine (getCertificate method) usable only after one function beetwen encrypt or signature");
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }

    @Override
    public String getCertificateId() throws SecurityException {
        try {
            if (this.xmlVerifierSignature != null) {
                if (this.xmlVerifierSignature.getKeyInfo() != null && this.xmlVerifierSignature.getKeyInfo().getId() != null) {
                    return this.xmlVerifierSignature.getKeyInfo().getId();
                }
                return null;
            }
            if (this.xmlDecrypt != null) {
                return null;
            }
            throw new SecurityException("XML Engine (getCertificate method) usable only after one function beetwen encrypt or signature");
        }
        catch (Exception e) {
            throw new SecurityException(e.getMessage(), e);
        }
    }
}

