/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.wss4j;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.UnsupportedDataTypeException;
import jakarta.xml.soap.AttachmentPart;
import jakarta.xml.soap.MimeHeader;
import jakarta.xml.soap.MimeHeaders;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.dom.DOMSource;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.message.Attachment;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.openspcoop2.message.OpenSPCoop2MessageFactory;
import org.openspcoop2.message.OpenSPCoop2SoapMessage;
import org.openspcoop2.message.xml.MessageXMLUtils;
import org.openspcoop2.security.message.constants.SecurityConstants;
import org.openspcoop2.security.message.utils.AttachmentProcessingPart;
import org.openspcoop2.utils.Utilities;
import org.openspcoop2.utils.dch.InputStreamDataSource;
import org.openspcoop2.utils.io.Base64Utilities;
import org.openspcoop2.utils.regexp.RegularExpressionEngine;
import org.slf4j.Logger;
import org.w3c.dom.Node;

public class WSSUtilities {
    public static void printWSResult(Logger log, List<?> results) {
        if (results != null) {
            for (Object object : results) {
                if (!(object instanceof WSHandlerResult)) continue;
                WSHandlerResult wsResult = (WSHandlerResult)object;
                log.debug("Actor [" + wsResult.getActor() + "]");
                List wsResultList = wsResult.getResults();
                if (wsResultList == null) continue;
                for (int i = 0; i < wsResultList.size(); ++i) {
                    log.debug("WSResult[" + i + "]=" + ((WSSecurityEngineResult)wsResultList.get(i)).toString());
                }
            }
        }
    }

    public static List<Attachment> readAttachments(List<String> cidAttachmentsForSecurity, OpenSPCoop2SoapMessage message, SoapMessage msgCtx) throws Exception {
        ArrayList<Attachment> listAttachments = null;
        if (cidAttachmentsForSecurity != null && cidAttachmentsForSecurity.size() > 0) {
            listAttachments = new ArrayList<Attachment>();
            for (String cid : cidAttachmentsForSecurity) {
                MimeHeaders mhs = new MimeHeaders();
                mhs.addHeader("Content-ID", cid);
                Iterator itAttach = message.getAttachments(mhs);
                if (itAttach == null) {
                    throw new Exception("Attachment with Content-ID [" + cid + "] not found");
                }
                AttachmentPart ap = (AttachmentPart)itAttach.next();
                if (ap == null) {
                    throw new Exception("Attachment with Content-ID [" + cid + "] not found");
                }
                listAttachments.add(WSSUtilities.convertToCxfAttachment(ap, msgCtx));
            }
        }
        return listAttachments;
    }

    public static List<Attachment> readAttachments(AttachmentProcessingPart app, OpenSPCoop2SoapMessage message, SoapMessage msgCtx) throws Exception {
        Object listApDaTrattare;
        ArrayList<Attachment> listAttachments = null;
        if (app != null && (listApDaTrattare = app.getOutput(message)) != null && listApDaTrattare.size() > 0) {
            listAttachments = new ArrayList<Attachment>();
            for (int i = 0; i < listApDaTrattare.size(); ++i) {
                AttachmentPart ap = (AttachmentPart)listApDaTrattare.get(i);
                listAttachments.add(WSSUtilities.convertToCxfAttachment(ap, msgCtx));
            }
        }
        return listAttachments;
    }

    private static Attachment convertToCxfAttachment(AttachmentPart ap, SoapMessage msgCtx) throws Exception {
        boolean encryptAttachmentsHeader;
        boolean addAttachmentIdBrackets;
        boolean encodeBase64;
        DataHandler dh = ap.getDataHandler();
        DataHandler dhNEW = null;
        byte[] bufferArray = null;
        String s = null;
        boolean bl = encodeBase64 = msgCtx.containsKey((Object)"preBase64EncodingAttachment") ? msgCtx.get((Object)"preBase64EncodingAttachment").equals("true") : SecurityConstants.PRE_BASE64_ENCODING_ATTACHMENT_DEFAULT;
        if (dh.getContentType() != null && dh.getContentType().startsWith("text/plain") && !encodeBase64) {
            dhNEW = dh;
        } else if (!encodeBase64 && (RegularExpressionEngine.isMatch((String)dh.getContentType(), (String)".*\\/xml") || RegularExpressionEngine.isMatch((String)dh.getContentType(), (String)".*\\+xml"))) {
            dhNEW = dh;
        } else {
            try {
                InputStream ins = null;
                ins = encodeBase64 ? new Base64InputStream(dh.getInputStream(), true) : dh.getInputStream();
                InputStreamDataSource isds = new InputStreamDataSource(ap.getContentId(), dh.getContentType(), ins);
                dhNEW = new DataHandler((DataSource)isds);
            }
            catch (UnsupportedDataTypeException edtx) {
                Object o = dh.getContent();
                if (o != null) {
                    InputStreamDataSource isds;
                    if (o instanceof String) {
                        s = (String)o;
                        dhNEW = new DataHandler((Object)s, dh.getContentType());
                    }
                    if (o instanceof byte[]) {
                        bufferArray = (byte[])o;
                        isds = new InputStreamDataSource(ap.getContentId(), dh.getContentType(), bufferArray);
                        dhNEW = new DataHandler((DataSource)isds);
                    }
                    if (o instanceof InputStream) {
                        isds = new InputStreamDataSource(ap.getContentId(), dh.getContentType(), (InputStream)o);
                        dhNEW = new DataHandler((DataSource)isds);
                    }
                    throw new Exception("Attach [" + ap.getContentId() + "] [" + dh.getContentType() + "] with type not supported: " + o.getClass().getName(), edtx);
                }
                throw new Exception("Attach [" + ap.getContentId() + "] [" + dh.getContentType() + "] error: " + edtx.getMessage(), edtx);
            }
        }
        String id = ap.getContentId();
        boolean bl2 = addAttachmentIdBrackets = msgCtx.containsKey((Object)"addAttachmentIdBrackets") ? msgCtx.get((Object)"addAttachmentIdBrackets").equals("true") : SecurityConstants.ADD_ATTACHMENT_ID_BRACKETS_DEFAULT;
        if (!addAttachmentIdBrackets) {
            id = id.replaceAll("(^<)|(>$)", "");
        }
        AttachmentImpl at = new AttachmentImpl(StringEscapeUtils.escapeXml10((String)id));
        boolean bl3 = encryptAttachmentsHeader = msgCtx.containsKey((Object)"encryptAttachmentHeaders") ? msgCtx.get((Object)"encryptAttachmentHeaders").equals("true") : SecurityConstants.ENCRYPT_ATTACHMENT_HEADERS_DEFAULT;
        if (encryptAttachmentsHeader) {
            Iterator headers = ap.getAllMimeHeaders();
            while (headers.hasNext()) {
                MimeHeader header = (MimeHeader)headers.next();
                at.setHeader(header.getName(), header.getValue());
            }
        }
        if (encodeBase64) {
            at.setHeader("Content-Transfer-Encoding", "base64");
        }
        at.setDataHandler(dhNEW);
        return at;
    }

    private static Object postProcessAttachment(Object o, SoapMessage msgCtx) {
        boolean decodeBase64;
        boolean bl = decodeBase64 = msgCtx.containsKey((Object)"postBase64DecodingAttachment") ? msgCtx.get((Object)"postBase64DecodingAttachment").equals("true") : SecurityConstants.POST_BASE64_DECODING_ATTACHMENT_DEFAULT;
        if (decodeBase64) {
            if (o instanceof String) {
                return new String(Base64Utilities.decode((String)((String)o)));
            }
            if (o instanceof byte[]) {
                return Base64Utilities.decode((byte[])((byte[])o));
            }
            if (o instanceof InputStream) {
                return new Base64InputStream((InputStream)o);
            }
        }
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateAttachments(List<Attachment> listAttachments, OpenSPCoop2SoapMessage message, SoapMessage msgCtx) throws Exception {
        if (listAttachments == null || listAttachments.size() <= 0) return;
        boolean decodeBase64 = msgCtx.containsKey((Object)"postBase64DecodingAttachment") ? msgCtx.get((Object)"postBase64DecodingAttachment").equals("true") : SecurityConstants.POST_BASE64_DECODING_ATTACHMENT_DEFAULT;
        boolean encodeBase64 = msgCtx.containsKey((Object)"postBase64EncodingAttachment") ? msgCtx.get((Object)"postBase64EncodingAttachment").equals("true") : SecurityConstants.POST_BASE64_ENCODING_ATTACHMENT_DEFAULT;
        for (Attachment attachmentPart : listAttachments) {
            Object o;
            MimeHeaders mhs = new MimeHeaders();
            mhs.addHeader("Content-ID", StringEscapeUtils.unescapeXml((String)attachmentPart.getId()));
            AttachmentPart ap = (AttachmentPart)message.getAttachments(mhs).next();
            if (encodeBase64) {
                ap.addMimeHeader("Content-Transfer-Encoding", "base64");
            }
            if (decodeBase64) {
                ap.addMimeHeader("Content-Transfer-Encoding", "binary");
            }
            DataHandler dh = attachmentPart.getDataHandler();
            byte[] bufferArray = null;
            String s = null;
            if (dh.getContentType() != null && dh.getContentType().startsWith("text/plain")) {
                o = dh.getContent();
                if (o instanceof String) {
                    s = (String)WSSUtilities.postProcessAttachment(o, msgCtx);
                    message.updateAttachmentPart(ap, s, dh.getContentType());
                    continue;
                }
                if (o instanceof byte[]) {
                    bufferArray = (byte[])WSSUtilities.postProcessAttachment(o, msgCtx);
                    message.updateAttachmentPart(ap, bufferArray, dh.getContentType());
                    continue;
                }
                if (!(o instanceof InputStream)) throw new Exception("Attach-Plain [" + attachmentPart.getId() + "] [" + dh.getContentType() + "] with type not supported: " + o.getClass().getName());
                bufferArray = Utilities.getAsByteArray((InputStream)((InputStream)WSSUtilities.postProcessAttachment(o, msgCtx)));
                message.updateAttachmentPart(ap, bufferArray, dh.getContentType());
                continue;
            }
            if (RegularExpressionEngine.isMatch((String)dh.getContentType(), (String)".*\\/xml") || RegularExpressionEngine.isMatch((String)dh.getContentType(), (String)".*\\+xml")) {
                o = dh.getContent();
                boolean testXml = false;
                boolean updated = false;
                Node n = null;
                if (o instanceof String) {
                    s = (String)WSSUtilities.postProcessAttachment(o, msgCtx);
                    message.updateAttachmentPart(ap, s, dh.getContentType());
                    updated = true;
                } else if (o instanceof byte[]) {
                    bufferArray = (byte[])WSSUtilities.postProcessAttachment(o, msgCtx);
                    testXml = true;
                } else if (o instanceof InputStream) {
                    bufferArray = Utilities.getAsByteArray((InputStream)((InputStream)WSSUtilities.postProcessAttachment(o, msgCtx)));
                    testXml = true;
                } else {
                    if (!(o instanceof Node)) throw new Exception("Attach-XML [" + attachmentPart.getId() + "] [" + dh.getContentType() + "] with type not supported: " + o.getClass().getName());
                    n = (Node)WSSUtilities.postProcessAttachment(o, msgCtx);
                }
                if (testXml) {
                    try {
                        if (n == null) {
                            n = MessageXMLUtils.getInstance((OpenSPCoop2MessageFactory)message.getFactory()).newElement(bufferArray);
                        }
                    }
                    catch (Exception e) {
                        message.updateAttachmentPart(ap, bufferArray, dh.getContentType());
                        updated = true;
                    }
                }
                if (updated) continue;
                DOMSource streamSource = new DOMSource(n);
                DataHandler newDH = new DataHandler((Object)streamSource, dh.getContentType());
                message.updateAttachmentPart(ap, newDH);
                continue;
            }
            try {
                InputStream ins = (InputStream)WSSUtilities.postProcessAttachment(dh.getInputStream(), msgCtx);
                InputStreamDataSource isds = new InputStreamDataSource(attachmentPart.getId(), dh.getContentType(), ins);
                DataHandler dhNEW = new DataHandler((DataSource)isds);
                message.updateAttachmentPart(ap, dhNEW);
            }
            catch (UnsupportedDataTypeException edtx) {
                Object o2 = dh.getContent();
                DataHandler dhNEW = null;
                if (o2 == null) throw new Exception("Attach [" + ap.getContentId() + "] [" + dh.getContentType() + "] error: " + edtx.getMessage(), edtx);
                if (o2 instanceof String) {
                    s = (String)o2;
                    dhNEW = new DataHandler((Object)s, dh.getContentType());
                } else if (o2 instanceof byte[]) {
                    bufferArray = (byte[])o2;
                    isds = new InputStreamDataSource(attachmentPart.getId(), dh.getContentType(), bufferArray);
                    dhNEW = new DataHandler((DataSource)isds);
                } else {
                    if (!(o2 instanceof InputStream)) throw new Exception("Attach [" + ap.getContentId() + "] [" + dh.getContentType() + "] with type not supported: " + o2.getClass().getName(), edtx);
                    isds = new InputStreamDataSource(attachmentPart.getId(), dh.getContentType(), (InputStream)o2);
                    dhNEW = new DataHandler((DataSource)isds);
                }
                message.updateAttachmentPart(ap, dhNEW);
            }
        }
    }
}

