/*
 * Decompiled with CFR 0.152.
 */
package org.openspcoop2.security.message.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openspcoop2.message.soap.reference.AttachmentReference;
import org.openspcoop2.message.soap.reference.Reference;
import org.openspcoop2.security.message.MessageSecurityContext;
import org.openspcoop2.security.message.utils.AttachmentProcessingPart;
import org.openspcoop2.security.message.utils.ProcessingPart;
import org.openspcoop2.security.message.utils.ProcessingPartUtils;

public class AttachmentsConfigReaderUtils {
    public static List<String> getListCIDAttachmentsForSecurity(MessageSecurityContext wssContext) throws Exception {
        ArrayList<String> cidSecurity = new ArrayList<String>();
        if (wssContext.getReferences() != null && wssContext.getReferences().size() > 0) {
            for (Reference reference : wssContext.getReferences()) {
                if (!(reference instanceof AttachmentReference)) continue;
                AttachmentReference ar = (AttachmentReference)reference;
                cidSecurity.add(ar.getReference());
            }
        }
        return cidSecurity;
    }

    public static AttachmentProcessingPart getSecurityOnAttachments(MessageSecurityContext wssContext) throws Exception {
        AttachmentProcessingPart ap = null;
        Map<String, Object> wssProperties = null;
        wssProperties = wssContext.isFunctionAsClient() ? wssContext.getOutgoingProperties() : wssContext.getIncomingProperties();
        if (wssProperties != null && wssProperties.size() > 0) {
            if (wssProperties.containsKey("encryptionParts")) {
                value = (String)wssProperties.get("encryptionParts");
                listProcessingParts = ProcessingPartUtils.getEncryptionInstance().getProcessingParts(value);
                AttachmentProcessingPart apFound = AttachmentsConfigReaderUtils.findAttachmentProcessingPart(listProcessingParts, ap, "encryptionParts");
                if (ap == null) {
                    ap = apFound;
                }
            } else if (wssProperties.containsKey("signatureParts")) {
                value = (String)wssProperties.get("signatureParts");
                listProcessingParts = ProcessingPartUtils.getEncryptionInstance().getProcessingParts(value);
                AttachmentProcessingPart apFound = AttachmentsConfigReaderUtils.findAttachmentProcessingPart(listProcessingParts, ap, "signatureParts");
                if (ap == null) {
                    ap = apFound;
                }
            }
        }
        if (ap == null) {
            if (wssContext.getManualAttachmentsEncryptPart() != null) {
                listProcessingParts = ProcessingPartUtils.getEncryptionInstance().getProcessingParts(wssContext.getManualAttachmentsEncryptPart());
                apFound = AttachmentsConfigReaderUtils.findAttachmentProcessingPart(listProcessingParts, ap, "encryptionParts");
                if (ap == null) {
                    ap = apFound;
                }
            } else if (wssContext.getManualAttachmentsSignaturePart() != null) {
                listProcessingParts = ProcessingPartUtils.getEncryptionInstance().getProcessingParts(wssContext.getManualAttachmentsSignaturePart());
                apFound = AttachmentsConfigReaderUtils.findAttachmentProcessingPart(listProcessingParts, ap, "signatureParts");
                if (ap == null) {
                    ap = apFound;
                }
            }
        }
        return ap;
    }

    public static AttachmentProcessingPart findAttachmentProcessingPart(List<ProcessingPart<?, ?>> listProcessingParts, AttachmentProcessingPart ap, String parts) throws Exception {
        AttachmentProcessingPart apFound = null;
        boolean found = false;
        for (ProcessingPart<?, ?> processingPart : listProcessingParts) {
            if (!(processingPart instanceof AttachmentProcessingPart)) continue;
            if (found) {
                throw new Exception("Only one configuration for attachments is allowed in " + parts);
            }
            apFound = (AttachmentProcessingPart)processingPart;
            if (ap != null) {
                if (ap.isAllAttachments()) {
                    if (!apFound.isAllAttachments()) {
                        throw new Exception("The configuration of signature and encryption for the attachments must be the same (found difference in encryptionParts and signatureParts)");
                    }
                } else {
                    int apIntValue = (Integer)ap.getPart();
                    if (apFound.isAllAttachments() || apIntValue != (Integer)apFound.getPart()) {
                        throw new Exception("The configuration of signature and encryption for the attachments must be the same (found difference in encryptionParts and signatureParts)");
                    }
                }
            }
            found = true;
        }
        return apFound;
    }
}

